/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import org.apache.commons.lang3.StringUtils;
import org.cyclos.entities.system.ImportedFile;
import org.cyclos.impl.system.ImportServiceLocal;
import org.cyclos.impl.system.ProfilingEntry;
import org.cyclos.impl.utils.tasks.AbstractBackgroundTask;
import org.cyclos.impl.utils.tasks.BackgroundTaskScheduling;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.scheduledtasks.BackgroundTaskPriority;
import org.cyclos.utils.MessageKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ImportBackgroundTask
extends AbstractBackgroundTask {
    @Autowired
    private ImportServiceLocal importService;

    public static BackgroundTaskScheduling scheduling(ImportedFile importedFile) {
        return new BackgroundTaskScheduling(ImportBackgroundTask.class, (Object)(importedFile.getId() + "," + String.valueOf(importedFile.getStatus())), "Processing of imported file " + importedFile.getFileName());
    }

    public MessageKey getMessageKey() {
        return SystemKeys.BackgroundTasks.PROCESS_IMPORT;
    }

    public BackgroundTaskPriority getPriority() {
        return BackgroundTaskPriority.LOW;
    }

    @Override
    protected long doExecute(String string, ProfilingEntry profilingEntry) {
        Long l = Long.parseLong(StringUtils.substringBefore((String)string, (String)","));
        return this.importService.resumeImport(l);
    }
}

