/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.access.Agreement;
import org.cyclos.entities.access.QAgreement;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.banking.VoucherConfiguration;
import org.cyclos.entities.system.AdExtensionPoint;
import org.cyclos.entities.system.AgreementExtensionPoint;
import org.cyclos.entities.system.AuthorizationExtensionPoint;
import org.cyclos.entities.system.CustomScript;
import org.cyclos.entities.system.ExtensionPoint;
import org.cyclos.entities.system.ExtensionPointWithGroup;
import org.cyclos.entities.system.ExtensionPointWithTransferType;
import org.cyclos.entities.system.ImportExtensionPoint;
import org.cyclos.entities.system.OperatorExtensionPoint;
import org.cyclos.entities.system.OrderExtensionPoint;
import org.cyclos.entities.system.PhoneExtensionPoint;
import org.cyclos.entities.system.QAdExtensionPoint;
import org.cyclos.entities.system.QAgreementExtensionPoint;
import org.cyclos.entities.system.QAuthorizationExtensionPoint;
import org.cyclos.entities.system.QExtensionPoint;
import org.cyclos.entities.system.QExtensionPointWithGroup;
import org.cyclos.entities.system.QExtensionPointWithTransferType;
import org.cyclos.entities.system.QImportExtensionPoint;
import org.cyclos.entities.system.QOperatorExtensionPoint;
import org.cyclos.entities.system.QOrderExtensionPoint;
import org.cyclos.entities.system.QPhoneExtensionPoint;
import org.cyclos.entities.system.QRecordExtensionPoint;
import org.cyclos.entities.system.QTransactionExtensionPoint;
import org.cyclos.entities.system.QTransferExtensionPoint;
import org.cyclos.entities.system.QUserAddressExtensionPoint;
import org.cyclos.entities.system.QUserExtensionPoint;
import org.cyclos.entities.system.QVoucherExtensionPoint;
import org.cyclos.entities.system.RecordExtensionPoint;
import org.cyclos.entities.system.TransactionExtensionPoint;
import org.cyclos.entities.system.TransferExtensionPoint;
import org.cyclos.entities.system.UserAddressExtensionPoint;
import org.cyclos.entities.system.UserExtensionPoint;
import org.cyclos.entities.system.VoucherExtensionPoint;
import org.cyclos.entities.users.Group;
import org.cyclos.entities.users.RecordType;
import org.cyclos.entities.users.SystemRecordType;
import org.cyclos.entities.users.UserGroup;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.access.AgreementServiceLocal;
import org.cyclos.impl.banking.TransferTypeServiceLocal;
import org.cyclos.impl.banking.VoucherConfigurationServiceLocal;
import org.cyclos.impl.system.CustomScriptAccessor;
import org.cyclos.impl.system.CustomScriptServiceLocal;
import org.cyclos.impl.system.ExtensionPointAccessor;
import org.cyclos.impl.system.ExtensionPointCacheKey;
import org.cyclos.impl.system.ExtensionPointFilter;
import org.cyclos.impl.system.ExtensionPointServiceLocal;
import org.cyclos.impl.users.GroupListViewFactory;
import org.cyclos.impl.users.RecordTypeServiceLocal;
import org.cyclos.impl.utils.SerializablePredicate;
import org.cyclos.impl.utils.cache.AccessorCacheValue;
import org.cyclos.impl.utils.cache.Cache;
import org.cyclos.impl.utils.cache.CacheHandler;
import org.cyclos.impl.utils.cache.CacheType;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.impl.utils.validation.EntityValidation;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.impl.utils.validation.validations.BaseEntityValidation;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.Property;
import org.cyclos.model.banking.accounttypes.AccountTypeVO;
import org.cyclos.model.banking.transfertypes.TransferTypeQuery;
import org.cyclos.model.banking.voucherconfigurations.VoucherConfigurationVO;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.extensionpoints.AdExtensionPointDTO;
import org.cyclos.model.system.extensionpoints.AdExtensionPointEvent;
import org.cyclos.model.system.extensionpoints.AgreementExtensionPointDTO;
import org.cyclos.model.system.extensionpoints.AgreementExtensionPointData;
import org.cyclos.model.system.extensionpoints.AgreementExtensionPointEvent;
import org.cyclos.model.system.extensionpoints.AuthorizationExtensionPointDTO;
import org.cyclos.model.system.extensionpoints.AuthorizationExtensionPointEvent;
import org.cyclos.model.system.extensionpoints.ExtensionPointDTO;
import org.cyclos.model.system.extensionpoints.ExtensionPointData;
import org.cyclos.model.system.extensionpoints.ExtensionPointEvent;
import org.cyclos.model.system.extensionpoints.ExtensionPointNature;
import org.cyclos.model.system.extensionpoints.ExtensionPointVO;
import org.cyclos.model.system.extensionpoints.ExtensionPointWithGroupData;
import org.cyclos.model.system.extensionpoints.ExtensionPointWithTransferTypeData;
import org.cyclos.model.system.extensionpoints.ImportExtensionPointDTO;
import org.cyclos.model.system.extensionpoints.ImportExtensionPointData;
import org.cyclos.model.system.extensionpoints.ImportExtensionPointEvent;
import org.cyclos.model.system.extensionpoints.OperatorExtensionPointDTO;
import org.cyclos.model.system.extensionpoints.OperatorExtensionPointEvent;
import org.cyclos.model.system.extensionpoints.OrderExtensionPointDTO;
import org.cyclos.model.system.extensionpoints.OrderExtensionPointEvent;
import org.cyclos.model.system.extensionpoints.PhoneExtensionPointDTO;
import org.cyclos.model.system.extensionpoints.PhoneExtensionPointEvent;
import org.cyclos.model.system.extensionpoints.RecordExtensionPointDTO;
import org.cyclos.model.system.extensionpoints.RecordExtensionPointData;
import org.cyclos.model.system.extensionpoints.RecordExtensionPointEvent;
import org.cyclos.model.system.extensionpoints.TransactionExtensionPointDTO;
import org.cyclos.model.system.extensionpoints.TransactionExtensionPointEvent;
import org.cyclos.model.system.extensionpoints.TransferExtensionPointDTO;
import org.cyclos.model.system.extensionpoints.TransferExtensionPointEvent;
import org.cyclos.model.system.extensionpoints.UserAddressExtensionPointDTO;
import org.cyclos.model.system.extensionpoints.UserAddressExtensionPointEvent;
import org.cyclos.model.system.extensionpoints.UserExtensionPointDTO;
import org.cyclos.model.system.extensionpoints.UserExtensionPointEvent;
import org.cyclos.model.system.extensionpoints.VoucherExtensionPointDTO;
import org.cyclos.model.system.extensionpoints.VoucherExtensionPointData;
import org.cyclos.model.system.extensionpoints.VoucherExtensionPointEvent;
import org.cyclos.model.system.scripts.CustomScriptVO;
import org.cyclos.model.system.scripts.ExtensionPointScriptFunction;
import org.cyclos.model.system.scripts.ScriptFunction;
import org.cyclos.model.system.scripts.ScriptType;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.utils.CollectionHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExtensionPointServiceImpl
extends CRUDServiceImpl<ExtensionPoint, QExtensionPoint, ExtensionPointDTO, ExtensionPointData, ExtensionPointNature>
implements ExtensionPointServiceLocal {
    private static final BidiMap<Class<? extends ExtensionPoint>, Class<? extends ExtensionPointDTO>> SUBCLASS_MAPPINGS = new DualHashBidiMap();
    private static final Map<ExtensionPointNature, Class<? extends ExtensionPoint>> CLASS_BY_NATURE = new HashMap<ExtensionPointNature, Class<? extends ExtensionPoint>>();
    @Autowired
    private CustomScriptServiceLocal customScriptService;
    @Autowired
    private TransferTypeServiceLocal transferTypeService;
    @Autowired
    private CacheHandler cacheHandler;
    private Cache<ExtensionPointCacheKey, AccessorCacheValue> cache;
    @Autowired
    private RecordTypeServiceLocal recordTypeService;
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    private VoucherConfigurationServiceLocal voucherConfigurationService;
    @Autowired
    private AgreementServiceLocal agreementService;

    public ExtensionPointServiceImpl() {
        super(ExtensionPoint.class, QExtensionPoint.extensionPoint, ExtensionPointDTO.class);
    }

    @PostConstruct
    public void initialize() {
        this.cache = this.cacheHandler.getCache(CacheType.EXTENSION_POINTS);
    }

    public List<ExtensionPointVO> list() throws FrameworkException {
        return ((DBQuery)this.from().orderBy(((QExtensionPoint)this.$).name.asc())).list(ExtensionPointVO.class, (Expression)this.$);
    }

    public ExtensionPointAccessor newAccessor(ExtensionPointEvent extensionPointEvent, ExtensionPointFilter extensionPointFilter) throws FrameworkException {
        Long l = SimpleEntity.id((SimpleEntity)this.getSessionData().getNetwork());
        List<ExtensionPoint> list = this.findExtensionPoints(l, extensionPointEvent, extensionPointFilter);
        if (CollectionHelper.isEmpty(list)) {
            return NoOpExtensionPointAccessor.INSTANCE;
        }
        return new ExtensionPointAccessorImpl(list, extensionPointEvent);
    }

    @Override
    public ExtensionPoint newEntity(ExtensionPointNature extensionPointNature) {
        ExtensionPoint extensionPoint = (ExtensionPoint)ClassHelper.instantiate(CLASS_BY_NATURE.get(extensionPointNature));
        extensionPoint.setEnabled(true);
        return extensionPoint;
    }

    @Override
    protected ExtensionPointData getData(ExtensionPoint extensionPoint) {
        ImportExtensionPointData importExtensionPointData;
        Object object;
        if (extensionPoint instanceof ExtensionPointWithGroup) {
            RecordExtensionPointData recordExtensionPointData;
            if (extensionPoint instanceof RecordExtensionPoint) {
                recordExtensionPointData = new RecordExtensionPointData();
                recordExtensionPointData.setRecordTypes(this.recordTypeService.list());
                object = recordExtensionPointData;
            } else if (extensionPoint instanceof AgreementExtensionPoint) {
                recordExtensionPointData = new AgreementExtensionPointData();
                recordExtensionPointData.setAgreements(this.agreementService.list());
                object = recordExtensionPointData;
            } else {
                object = new ExtensionPointWithGroupData();
            }
            boolean bl = extensionPoint instanceof UserExtensionPoint || extensionPoint instanceof PhoneExtensionPoint || extensionPoint instanceof UserAddressExtensionPoint || extensionPoint instanceof AgreementExtensionPoint;
            GroupListViewFactory groupListViewFactory = this.groupsHandler.visibles().accessibles();
            object.setGroups(bl ? groupListViewFactory.basic().sorted() : groupListViewFactory.basicUsers().sorted());
            importExtensionPointData = object;
        } else if (extensionPoint instanceof ExtensionPointWithTransferType) {
            object = new ExtensionPointWithTransferTypeData();
            TransferTypeQuery transferTypeQuery = new TransferTypeQuery();
            transferTypeQuery.setUnlimited();
            List list = this.transferTypeService.search(transferTypeQuery).getPageItems();
            Collections.sort(list, (transferTypeVO, transferTypeVO2) -> {
                AccountTypeVO accountTypeVO = transferTypeVO.getFrom();
                AccountTypeVO accountTypeVO2 = transferTypeVO2.getFrom();
                int n = accountTypeVO.getName().compareTo(accountTypeVO2.getName());
                if (n == 0) {
                    n = transferTypeVO.getName().compareTo(transferTypeVO2.getName());
                }
                return n;
            });
            object.setTransferTypes(list);
            importExtensionPointData = object;
        } else if (extensionPoint instanceof VoucherExtensionPoint) {
            object = new VoucherExtensionPointData();
            object.setVoucherConfigurations(this.conversionHandler.convertList(VoucherConfigurationVO.class, (Iterable)this.voucherConfigurationService.listAll()));
            importExtensionPointData = object;
        } else if (extensionPoint instanceof ImportExtensionPoint) {
            importExtensionPointData = new ImportExtensionPointData();
        } else {
            throw new IllegalStateException("Invalid extension point: " + String.valueOf(extensionPoint));
        }
        importExtensionPointData.setDto((EntityDTO)((ExtensionPointDTO)this.toDTO(extensionPoint)));
        importExtensionPointData.setNature(extensionPoint.getNature());
        object = this.customScriptService.listByType(ScriptType.EXTENSION_POINT);
        importExtensionPointData.setScripts(this.conversionHandler.convertList(CustomScriptVO.class, (Iterable)object));
        return importExtensionPointData;
    }

    @Override
    protected void onAfterRemove(ExtensionPoint extensionPoint) {
        Long l = SimpleEntity.id((SimpleEntity)extensionPoint.getNetwork());
        ExtensionPointNature extensionPointNature = extensionPoint.getNature();
        this.cacheHandler.schedulePartialEvict(CacheType.EXTENSION_POINTS, (SerializablePredicate & Serializable)extensionPointCacheKey -> extensionPointCacheKey.matchesNetworkAndNature(l, extensionPointNature));
    }

    @Override
    protected void onAfterSave(ExtensionPoint extensionPoint, ExtensionPoint extensionPoint2, Object object) {
        Long l = SimpleEntity.id((SimpleEntity)extensionPoint.getNetwork());
        ExtensionPointNature extensionPointNature = extensionPoint.getNature();
        this.cacheHandler.schedulePartialEvict(CacheType.EXTENSION_POINTS, (SerializablePredicate & Serializable)extensionPointCacheKey -> extensionPointCacheKey.matchesNetworkAndNature(l, extensionPointNature));
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QExtensionPoint)this.$).network());
    }

    @Override
    protected Validator resolveValidator(ExtensionPointDTO extensionPointDTO) {
        Validator validator = new Validator();
        validator.property((Property)ExtensionPointDTO.SCRIPT, SystemKeys.ExtensionPoints.SCRIPT).required().entity(CustomScript.class, (EntityValidation)new BaseEntityValidation<CustomScript>(){

            protected boolean isValid(Object object, Object object2, CustomScript customScript) {
                return customScript.getType() == ScriptType.EXTENSION_POINT;
            }
        });
        return validator;
    }

    @Override
    protected BidiMap<Class<? extends ExtensionPoint>, Class<? extends ExtensionPointDTO>> subClassMappings() {
        return SUBCLASS_MAPPINGS;
    }

    private List<ExtensionPoint> doFindExtensionPoints(Long l, ExtensionPointEvent extensionPointEvent, ExtensionPointFilter extensionPointFilter) {
        Agreement agreement;
        QAgreementExtensionPoint qAgreementExtensionPoint;
        QAdExtensionPoint qAdExtensionPoint;
        ExtensionPointNature extensionPointNature = extensionPointEvent.nature();
        QExtensionPointWithGroup qExtensionPointWithGroup = null;
        QExtensionPointWithTransferType qExtensionPointWithTransferType = null;
        QExtensionPoint qExtensionPoint = null;
        DBQuery dBQuery = null;
        boolean bl = false;
        switch (extensionPointNature) {
            case AD: {
                qAdExtensionPoint = QAdExtensionPoint.adExtensionPoint;
                dBQuery = (DBQuery)this.from(new EntityPath[]{qAdExtensionPoint}).where((Predicate)qAdExtensionPoint.events.contains((Object)((AdExtensionPointEvent)extensionPointEvent)));
                qExtensionPointWithGroup = qAdExtensionPoint._super;
                break;
            }
            case AGREEMENT: {
                qAgreementExtensionPoint = QAgreementExtensionPoint.agreementExtensionPoint;
                agreement = (Agreement)this.rawEntityManagerHandler.find(Agreement.class, extensionPointFilter.ensureAgreementId());
                dBQuery = (DBQuery)this.from(new EntityPath[]{qAgreementExtensionPoint}).where(new Predicate[]{qAgreementExtensionPoint.events.contains((Object)((AgreementExtensionPointEvent)extensionPointEvent)), qAgreementExtensionPoint.agreements.isEmpty().or((Predicate)((QAgreement)qAgreementExtensionPoint.agreements.any()).eq((Object)agreement))});
                qExtensionPointWithGroup = qAgreementExtensionPoint._super;
                break;
            }
            case AUTHORIZATION: {
                QAuthorizationExtensionPoint qAuthorizationExtensionPoint = QAuthorizationExtensionPoint.authorizationExtensionPoint;
                dBQuery = (DBQuery)this.from(new EntityPath[]{qAuthorizationExtensionPoint}).where((Predicate)qAuthorizationExtensionPoint.events.contains((Object)((AuthorizationExtensionPointEvent)extensionPointEvent)));
                qExtensionPointWithTransferType = qAuthorizationExtensionPoint._super;
                break;
            }
            case TRANSFER: {
                QTransferExtensionPoint qTransferExtensionPoint = QTransferExtensionPoint.transferExtensionPoint;
                dBQuery = (DBQuery)this.from(new EntityPath[]{qTransferExtensionPoint}).where((Predicate)qTransferExtensionPoint.events.contains((Object)((TransferExtensionPointEvent)extensionPointEvent)));
                qExtensionPointWithTransferType = qTransferExtensionPoint._super;
                break;
            }
            case TRANSACTION: {
                QTransactionExtensionPoint qTransactionExtensionPoint = QTransactionExtensionPoint.transactionExtensionPoint;
                dBQuery = (DBQuery)this.from(new EntityPath[]{qTransactionExtensionPoint}).where((Predicate)qTransactionExtensionPoint.events.contains((Object)((TransactionExtensionPointEvent)extensionPointEvent)));
                qExtensionPointWithTransferType = qTransactionExtensionPoint._super;
                break;
            }
            case USER: {
                QUserExtensionPoint qUserExtensionPoint = QUserExtensionPoint.userExtensionPoint;
                dBQuery = (DBQuery)this.from(new EntityPath[]{qUserExtensionPoint}).where((Predicate)qUserExtensionPoint.events.contains((Object)((UserExtensionPointEvent)extensionPointEvent)));
                qExtensionPointWithGroup = qUserExtensionPoint._super;
                break;
            }
            case OPERATOR: {
                QOperatorExtensionPoint qOperatorExtensionPoint = QOperatorExtensionPoint.operatorExtensionPoint;
                dBQuery = (DBQuery)this.from(new EntityPath[]{qOperatorExtensionPoint}).where((Predicate)qOperatorExtensionPoint.events.contains((Object)((OperatorExtensionPointEvent)extensionPointEvent)));
                qExtensionPointWithGroup = qOperatorExtensionPoint._super;
                break;
            }
            case ORDER: {
                QOrderExtensionPoint qOrderExtensionPoint = QOrderExtensionPoint.orderExtensionPoint;
                dBQuery = (DBQuery)this.from(new EntityPath[]{qOrderExtensionPoint}).where((Predicate)qOrderExtensionPoint.events.contains((Object)((OrderExtensionPointEvent)extensionPointEvent)));
                qExtensionPointWithGroup = qOrderExtensionPoint._super;
                break;
            }
            case USER_ADDRESS: {
                QUserAddressExtensionPoint qUserAddressExtensionPoint = QUserAddressExtensionPoint.userAddressExtensionPoint;
                dBQuery = (DBQuery)this.from(new EntityPath[]{qUserAddressExtensionPoint}).where((Predicate)qUserAddressExtensionPoint.events.contains((Object)((UserAddressExtensionPointEvent)extensionPointEvent)));
                qExtensionPointWithGroup = qUserAddressExtensionPoint._super;
                break;
            }
            case PHONE: {
                QPhoneExtensionPoint qPhoneExtensionPoint = QPhoneExtensionPoint.phoneExtensionPoint;
                dBQuery = (DBQuery)this.from(new EntityPath[]{qPhoneExtensionPoint}).where((Predicate)qPhoneExtensionPoint.events.contains((Object)((PhoneExtensionPointEvent)extensionPointEvent)));
                qExtensionPointWithGroup = qPhoneExtensionPoint._super;
                break;
            }
            case RECORD: {
                QRecordExtensionPoint qRecordExtensionPoint = QRecordExtensionPoint.recordExtensionPoint;
                RecordType recordType = (RecordType)this.rawEntityManagerHandler.find(RecordType.class, extensionPointFilter.ensureRecordTypeId());
                if (recordType instanceof SystemRecordType) {
                    bl = true;
                }
                dBQuery = (DBQuery)this.from(new EntityPath[]{qRecordExtensionPoint}).where(new Predicate[]{qRecordExtensionPoint.events.contains((Object)((RecordExtensionPointEvent)extensionPointEvent)), qRecordExtensionPoint.recordTypes.contains((Object)recordType)});
                qExtensionPointWithGroup = qRecordExtensionPoint._super;
                break;
            }
            case VOUCHER: {
                QVoucherExtensionPoint qVoucherExtensionPoint = QVoucherExtensionPoint.voucherExtensionPoint;
                VoucherConfiguration voucherConfiguration = (VoucherConfiguration)this.rawEntityManagerHandler.find(VoucherConfiguration.class, extensionPointFilter.ensureVoucherConfigurationId());
                dBQuery = (DBQuery)this.from(new EntityPath[]{qVoucherExtensionPoint}).where(new Predicate[]{qVoucherExtensionPoint.events.contains((Object)((VoucherExtensionPointEvent)extensionPointEvent)), qVoucherExtensionPoint.voucherConfigurations.contains((Object)voucherConfiguration)});
                qExtensionPoint = qVoucherExtensionPoint._super;
                break;
            }
            case IMPORT: {
                QImportExtensionPoint qImportExtensionPoint = QImportExtensionPoint.importExtensionPoint;
                dBQuery = (DBQuery)this.from(new EntityPath[]{qImportExtensionPoint}).where(new Predicate[]{qImportExtensionPoint.events.contains((Object)((ImportExtensionPointEvent)extensionPointEvent)), qImportExtensionPoint.importTypes.contains((Object)extensionPointFilter.ensureImportType())});
                qExtensionPoint = qImportExtensionPoint._super;
            }
        }
        if (dBQuery == null) {
            throw new IllegalStateException("Unhandled nature: " + String.valueOf(extensionPointNature));
        }
        if (qExtensionPointWithGroup != null) {
            if (!bl) {
                qAdExtensionPoint = (Group)this.rawEntityManagerHandler.find(Group.class, extensionPointFilter.ensureGroupId());
                qAgreementExtensionPoint = qExtensionPointWithGroup.groups.contains((Object)qAdExtensionPoint);
                if (qAdExtensionPoint instanceof UserGroup && (agreement = ((UserGroup)qAdExtensionPoint).getGroupSet()) != null) {
                    qAgreementExtensionPoint = qAgreementExtensionPoint.or((Predicate)qExtensionPointWithGroup.groups.contains((Object)agreement));
                }
                dBQuery.where((Predicate)qAgreementExtensionPoint);
            }
            qExtensionPoint = qExtensionPointWithGroup._super;
        } else if (qExtensionPointWithTransferType != null) {
            qAdExtensionPoint = (TransferType)this.rawEntityManagerHandler.find(TransferType.class, extensionPointFilter.ensureTransferTypeId());
            dBQuery.where((Predicate)qExtensionPointWithTransferType.transferTypes.contains((Object)qAdExtensionPoint));
            qExtensionPoint = qExtensionPointWithTransferType._super;
        } else if (qExtensionPoint == null) {
            throw new IllegalStateException("Extension point alias not set");
        }
        dBQuery.where(new Predicate[]{qExtensionPoint.enabled.isTrue(), l == null ? qExtensionPoint.network().isNull() : qExtensionPoint.network().id.eq((Object)l)});
        return dBQuery.list((Expression)qExtensionPoint);
    }

    private List<ExtensionPoint> findExtensionPoints(Long l, ExtensionPointEvent extensionPointEvent, ExtensionPointFilter extensionPointFilter) {
        ExtensionPointCacheKey extensionPointCacheKey = new ExtensionPointCacheKey(l, extensionPointEvent, extensionPointFilter);
        AccessorCacheValue accessorCacheValue = (AccessorCacheValue)this.cache.get((Serializable)extensionPointCacheKey, () -> {
            List<ExtensionPoint> list = this.doFindExtensionPoints(l, extensionPointEvent, extensionPointFilter);
            return AccessorCacheValue.create(list);
        });
        return (List)accessorCacheValue.unwrap(this.getApplicationContext());
    }

    static {
        SUBCLASS_MAPPINGS.put(UserExtensionPoint.class, UserExtensionPointDTO.class);
        SUBCLASS_MAPPINGS.put(OperatorExtensionPoint.class, OperatorExtensionPointDTO.class);
        SUBCLASS_MAPPINGS.put(RecordExtensionPoint.class, RecordExtensionPointDTO.class);
        SUBCLASS_MAPPINGS.put(AdExtensionPoint.class, AdExtensionPointDTO.class);
        SUBCLASS_MAPPINGS.put(OrderExtensionPoint.class, OrderExtensionPointDTO.class);
        SUBCLASS_MAPPINGS.put(UserAddressExtensionPoint.class, UserAddressExtensionPointDTO.class);
        SUBCLASS_MAPPINGS.put(PhoneExtensionPoint.class, PhoneExtensionPointDTO.class);
        SUBCLASS_MAPPINGS.put(TransferExtensionPoint.class, TransferExtensionPointDTO.class);
        SUBCLASS_MAPPINGS.put(TransactionExtensionPoint.class, TransactionExtensionPointDTO.class);
        SUBCLASS_MAPPINGS.put(AuthorizationExtensionPoint.class, AuthorizationExtensionPointDTO.class);
        SUBCLASS_MAPPINGS.put(VoucherExtensionPoint.class, VoucherExtensionPointDTO.class);
        SUBCLASS_MAPPINGS.put(ImportExtensionPoint.class, ImportExtensionPointDTO.class);
        SUBCLASS_MAPPINGS.put(AgreementExtensionPoint.class, AgreementExtensionPointDTO.class);
        if (SUBCLASS_MAPPINGS.size() != ExtensionPointNature.values().length) {
            throw new IllegalStateException("Some extension point mapping is missing");
        }
        for (Class clazz : SUBCLASS_MAPPINGS.keySet()) {
            ExtensionPointNature extensionPointNature = ((ExtensionPoint)ClassHelper.instantiate((Class)clazz)).getNature();
            CLASS_BY_NATURE.put(extensionPointNature, clazz);
        }
    }

    private static class NoOpExtensionPointAccessor
    implements ExtensionPointAccessor {
        private static NoOpExtensionPointAccessor INSTANCE = new NoOpExtensionPointAccessor();

        private NoOpExtensionPointAccessor() {
        }

        public ExtensionPointAccessor attribute(String string, Object object) {
            return this;
        }

        public void fireSaved() {
        }

        public void fireValidated() {
        }
    }

    private class ExtensionPointAccessorImpl
    implements ExtensionPointAccessor {
        public static final String ATTR_EVENT = "event";
        public static final String ATTR_EXTENSION_POINT = "extensionPoint";
        public static final String ATTR_CONTEXT = "context";
        private Map<ExtensionPoint, CustomScriptAccessor> accessors = new LinkedHashMap<ExtensionPoint, CustomScriptAccessor>();

        public ExtensionPointAccessorImpl(List<ExtensionPoint> list, ExtensionPointEvent extensionPointEvent) {
            for (ExtensionPoint extensionPoint : list) {
                CustomScriptAccessor customScriptAccessor = ExtensionPointServiceImpl.this.customScriptService.newAccessor(extensionPoint.getScript(), extensionPoint.getScriptParameters()).bind(ATTR_EXTENSION_POINT, (Object)extensionPoint).bind(ATTR_EVENT, (Object)extensionPointEvent).bind(ATTR_CONTEXT, new HashMap());
                this.accessors.put(extensionPoint, customScriptAccessor);
            }
        }

        public ExtensionPointAccessor attribute(String string, Object object) {
            for (CustomScriptAccessor customScriptAccessor : this.accessors.values()) {
                customScriptAccessor.bind(string, object);
            }
            return this;
        }

        public void fireSaved() {
            this.run(ExtensionPointScriptFunction.SAVED);
        }

        public void fireValidated() {
            this.run(ExtensionPointScriptFunction.VALIDATED);
        }

        private void run(ExtensionPointScriptFunction extensionPointScriptFunction) {
            for (CustomScriptAccessor customScriptAccessor : this.accessors.values()) {
                customScriptAccessor.run((ScriptFunction)extensionPointScriptFunction);
            }
        }
    }
}

