/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import java.io.Serializable;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.system.ExportFormat;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.system.QExportFormat;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.system.CustomScriptServiceLocal;
import org.cyclos.impl.system.ExportFormatCacheKey;
import org.cyclos.impl.system.ExportFormatServiceLocal;
import org.cyclos.impl.system.ExportFormatsComparator;
import org.cyclos.impl.system.ExportHandler;
import org.cyclos.impl.utils.cache.AccessorCacheValue;
import org.cyclos.impl.utils.cache.Cache;
import org.cyclos.impl.utils.cache.CacheHandler;
import org.cyclos.impl.utils.cache.CacheType;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.Property;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.ValidationException;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.exportformats.BuiltInExportFormat;
import org.cyclos.model.system.exportformats.ExportFormatContext;
import org.cyclos.model.system.exportformats.ExportFormatDTO;
import org.cyclos.model.system.exportformats.ExportFormatData;
import org.cyclos.model.system.exportformats.ExportFormatVO;
import org.cyclos.model.system.scripts.CustomScriptVO;
import org.cyclos.model.system.scripts.ScriptType;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.server.utils.DataIterator;
import org.cyclos.server.utils.SerializableInputStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExportFormatServiceImpl
extends CRUDServiceImpl<ExportFormat, QExportFormat, ExportFormatDTO, ExportFormatData, Void>
implements ExportFormatServiceLocal {
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    private CustomScriptServiceLocal customScriptService;
    @Autowired
    private CacheHandler cacheHandler;
    private Cache<ExportFormatCacheKey, AccessorCacheValue> cache;
    private Map<BuiltInExportFormat, ExportHandler> builtInHandlers;
    private ExportHandler customHandler;

    public ExportFormatServiceImpl() {
        super(ExportFormat.class, QExportFormat.exportFormat, ExportFormatDTO.class);
    }

    public FileInfo exportMultiple(ExportFormat exportFormat, ExportFormatContext exportFormatContext, QueryParameters queryParameters, DataIterator<?> dataIterator) {
        return this.exportMultiple(exportFormat, exportFormatContext, queryParameters, dataIterator, null);
    }

    public FileInfo exportMultiple(ExportFormat exportFormat, ExportFormatContext exportFormatContext, QueryParameters queryParameters, DataIterator<?> dataIterator, Map<String, Object> map) {
        return this.doExport(new ExportHandler.ExportParameters(exportFormat, exportFormatContext, queryParameters, dataIterator, map));
    }

    public FileInfo exportSingle(ExportFormat exportFormat, ExportFormatContext exportFormatContext, Object object) {
        return this.exportSingle(exportFormat, exportFormatContext, object, null);
    }

    public FileInfo exportSingle(ExportFormat exportFormat, ExportFormatContext exportFormatContext, Object object, Map<String, Object> map) {
        return this.doExport(new ExportHandler.ExportParameters(exportFormat, exportFormatContext, object, map));
    }

    public ExportFormat getCSV() {
        return this.find(BuiltInExportFormat.CSV.getInternalName(), null);
    }

    public ExportFormat getPDF() {
        return this.find(BuiltInExportFormat.PDF.getInternalName(), null);
    }

    public ExportFormat getXLSX() {
        return this.find(BuiltInExportFormat.XLSX.getInternalName(), null);
    }

    @PostConstruct
    public void initialize() {
        this.cache = this.cacheHandler.getCache(CacheType.EXPORT_FORMATS);
        this.builtInHandlers = new HashMap<BuiltInExportFormat, ExportHandler>();
        this.getApplicationContext().getBeansOfType(ExportHandler.class).values().forEach(exportHandler -> {
            BuiltInExportFormat builtInExportFormat = exportHandler.getBuiltInFormat();
            if (builtInExportFormat == null) {
                if (this.customHandler != null) {
                    throw new IllegalStateException("2 export handlers for custom types: " + String.valueOf(this.customHandler) + " and " + String.valueOf(exportHandler));
                }
                this.customHandler = exportHandler;
            } else {
                ExportHandler exportHandler2 = this.builtInHandlers.put(builtInExportFormat, (ExportHandler)exportHandler);
                if (exportHandler2 != null) {
                    throw new IllegalStateException("2 export handlers for " + String.valueOf(builtInExportFormat) + ": " + String.valueOf(exportHandler2) + " and " + String.valueOf(exportHandler));
                }
            }
        });
        EnumSet<BuiltInExportFormat> enumSet = EnumSet.allOf(BuiltInExportFormat.class);
        enumSet.removeAll(this.builtInHandlers.keySet());
        if (!enumSet.isEmpty()) {
            throw new IllegalStateException("No handlers for these export formats: " + String.valueOf(enumSet));
        }
        if (this.customHandler == null) {
            throw new IllegalStateException("No custom export handler");
        }
    }

    public List<ExportFormatVO> list() throws FrameworkException {
        return this.conversionHandler.convertList(ExportFormatVO.class, this.listAll());
    }

    public List<ExportFormat> listAll() {
        List list = this.from().list((Expression)this.$);
        Collections.sort(list, ExportFormatsComparator.getInstance());
        return list;
    }

    public List<ExportFormat> listByContext(ExportFormatContext exportFormatContext) {
        return this.listAll().stream().filter(ExportFormat::isEnabled).filter(exportFormat -> exportFormat.getContexts().contains(exportFormatContext)).collect(Collectors.toList());
    }

    public ExportFormat load(String string) {
        return this.find(string, this.getSessionData().getNetwork());
    }

    @Override
    public ExportFormat newEntity(Void void_) {
        ExportFormat exportFormat = new ExportFormat();
        exportFormat.setEnabled(true);
        exportFormat.setEncoding("UTF-8");
        return exportFormat;
    }

    @Override
    protected void addCustomInternalNameValidations(org.cyclos.impl.utils.validation.Property property, ExportFormatDTO exportFormatDTO) {
        boolean bl;
        String string = null;
        if (exportFormatDTO.isPersistent()) {
            ExportFormat exportFormat = (ExportFormat)this.find(exportFormatDTO.getId());
            string = exportFormat.getInternalName();
            bl = exportFormat.isCustom();
        } else {
            bl = true;
        }
        if (!(bl || string != null && string.equals(exportFormatDTO.getInternalName()))) {
            property.invalid();
        }
    }

    @Override
    protected ExportFormatData getData(ExportFormat exportFormat) {
        ExportFormatData exportFormatData = new ExportFormatData();
        boolean bl = exportFormat.isCustom();
        exportFormatData.setBuiltIn(!bl);
        exportFormatData.setDto((EntityDTO)((ExportFormatDTO)this.toDTO(exportFormat)));
        if (bl) {
            List list = this.customScriptService.listByType(ScriptType.EXPORT_FORMAT);
            exportFormatData.setScripts(this.conversionHandler.convertList(CustomScriptVO.class, (Iterable)list));
        }
        return exportFormatData;
    }

    @Override
    protected boolean isEntityInternalNameRequired(ExportFormatDTO exportFormatDTO) {
        return true;
    }

    @Override
    protected Object onBeforeSave(ExportFormat exportFormat, ExportFormat exportFormat2) {
        if (exportFormat.isBinary()) {
            exportFormat.setEncoding(null);
        }
        return null;
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QExportFormat)this.$).network(), true);
    }

    @Override
    protected Validator resolveValidator(ExportFormatDTO exportFormatDTO) {
        boolean bl;
        Validator validator = new Validator();
        if (exportFormatDTO.isPersistent()) {
            ExportFormat exportFormat = (ExportFormat)this.find(exportFormatDTO.getId());
            bl = exportFormat.isCustom();
            if (!bl) {
                if (!exportFormat.getContentType().equals(exportFormatDTO.getContentType())) {
                    validator.property((Property)ExportFormatDTO.CONTENT_TYPE, SystemKeys.ExportFormats.CONTENT_TYPE).invalid();
                }
                if (exportFormat.isBinary() ^ exportFormatDTO.isBinary()) {
                    validator.property((Property)ExportFormatDTO.BINARY, SystemKeys.ExportFormats.BINARY).invalid();
                }
                if (exportFormat.isBinary() ^ exportFormatDTO.isBinary()) {
                    validator.property((Property)ExportFormatDTO.BINARY, SystemKeys.ExportFormats.BINARY).invalid();
                }
                if (!Objects.equals(exportFormat.getEncoding(), exportFormatDTO.getEncoding())) {
                    validator.property((Property)ExportFormatDTO.ENCODING, SystemKeys.ExportFormats.ENCODING).invalid();
                }
                if (!exportFormat.getFileExtension().equals(exportFormatDTO.getFileExtension())) {
                    validator.property((Property)ExportFormatDTO.FILE_EXTENSION, SystemKeys.ExportFormats.FILE_EXTENSION).invalid();
                }
            }
        } else {
            bl = true;
        }
        if (bl) {
            validator.property((Property)ExportFormatDTO.CONTEXTS, SystemKeys.ExportFormats.CONTEXTS).required();
            validator.property((Property)ExportFormatDTO.SCRIPT, SystemKeys.ExportFormats.SCRIPT).required();
            validator.property((Property)ExportFormatDTO.CONTENT_TYPE, SystemKeys.ExportFormats.CONTENT_TYPE).required();
            validator.property((Property)ExportFormatDTO.FILE_EXTENSION, SystemKeys.ExportFormats.FILE_EXTENSION).required();
            if (!exportFormatDTO.isBinary()) {
                validator.property((Property)ExportFormatDTO.ENCODING, SystemKeys.ExportFormats.ENCODING).required();
            }
        }
        return validator;
    }

    private FileInfo doExport(ExportHandler.ExportParameters exportParameters) {
        ExportFormat exportFormat = exportParameters.getFormat();
        ExportFormatContext exportFormatContext = exportParameters.getContext();
        if (!exportFormat.getContexts().contains(exportFormatContext)) {
            throw new ValidationException(this.message(SystemKeys.ExportFormats.INVALID_CONTEXT, exportFormat, exportFormatContext));
        }
        BuiltInExportFormat builtInExportFormat = BuiltInExportFormat.getByInternalName((String)exportFormat.getInternalName());
        ExportHandler exportHandler = builtInExportFormat != null ? this.builtInHandlers.get(builtInExportFormat) : this.customHandler;
        SerializableInputStream serializableInputStream = exportHandler.export(exportParameters);
        FileInfo fileInfo = new FileInfo();
        fileInfo.setContentType(exportFormat.getContentType());
        if (!exportFormat.isBinary()) {
            fileInfo.setEncoding(exportFormat.getEncoding());
        }
        fileInfo.setName(exportFormatContext.fileName(exportFormat.getFileExtension()));
        fileInfo.setContent(serializableInputStream);
        return fileInfo;
    }

    private ExportFormat find(String string, Network network) throws FrameworkException {
        ExportFormatCacheKey exportFormatCacheKey = new ExportFormatCacheKey(string, SimpleEntity.id((SimpleEntity)network));
        AccessorCacheValue accessorCacheValue = (AccessorCacheValue)this.cache.get((Serializable)exportFormatCacheKey, () -> {
            try {
                return AccessorCacheValue.create((Object)((DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{this.$}).where((Predicate)((QExportFormat)this.$).internalName.eq((Object)string).and((Predicate)(network == null ? ((QExportFormat)this.$).network().isNull() : ((QExportFormat)this.$).network().isNull().or((Predicate)((QExportFormat)this.$).network().eq((Object)network)))))).requiredUniqueResult((Expression)this.$));
            }
            catch (EntityNotFoundException entityNotFoundException) {
                entityNotFoundException.setEntityType(ExportFormat.class.getSimpleName());
                entityNotFoundException.setKey(string);
                throw entityNotFoundException;
            }
        });
        return (ExportFormat)accessorCacheValue.unwrap(this.getApplicationContext());
    }
}

