/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.util.LocaleUtil;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFCreationHelper;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.banking.QCurrency;
import org.cyclos.entities.utils.CurrencyAmount;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.ExportHandler;
import org.cyclos.impl.system.TabularExportHandlerImpl;
import org.cyclos.impl.utils.formatting.FormatterImpl;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.exportformats.BuiltInExportFormat;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.utils.BigDecimalHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExcelExportHandlerImpl
extends TabularExportHandlerImpl {
    @Autowired
    private CyclosProperties cyclosProperties;

    public BuiltInExportFormat getBuiltInFormat() {
        return BuiltInExportFormat.XLSX;
    }

    @Override
    protected SerializableInputStream build(ExportHandler.ExportParameters exportParameters, List<TabularExportHandlerImpl.Column> list) {
        list.removeIf(column -> column.getType() == TabularExportHandlerImpl.ColumnType.CURRENCY);
        ConfigurationAccessor configurationAccessor = this.getSessionData().getConfiguration();
        TimeZone timeZone = configurationAccessor.getTimeZone();
        LocaleUtil.setUserTimeZone((TimeZone)timeZone);
        try {
            Object object;
            Object object2;
            XSSFWorkbook xSSFWorkbook = new XSSFWorkbook();
            XSSFSheet xSSFSheet = xSSFWorkbook.createSheet();
            AtomicInteger atomicInteger = new AtomicInteger();
            FormatterImpl formatterImpl = this.getFormatter();
            XSSFFont xSSFFont = xSSFWorkbook.createFont();
            xSSFFont.setFontName("Arial");
            xSSFFont.setFontHeightInPoints((short)10);
            XSSFCellStyle xSSFCellStyle = xSSFWorkbook.createCellStyle();
            XSSFFont xSSFFont2 = xSSFWorkbook.createFont();
            xSSFFont2.setFontName("Arial");
            xSSFFont2.setBold(true);
            xSSFFont2.setFontHeightInPoints((short)10);
            xSSFCellStyle.setFont((Font)xSSFFont2);
            XSSFRow xSSFRow = xSSFSheet.createRow(atomicInteger.getAndIncrement());
            xSSFRow.setRowStyle((CellStyle)xSSFCellStyle);
            for (int i = 0; i < list.size(); ++i) {
                object2 = list.get(i);
                object = xSSFRow.createCell(i);
                object.setCellValue(((TabularExportHandlerImpl.Column)object2).getHeading());
            }
            XSSFCreationHelper xSSFCreationHelper = xSSFWorkbook.getCreationHelper();
            object2 = new HashMap();
            object = new HashMap();
            HashMap hashMap = new HashMap();
            HashMap hashMap2 = new HashMap();
            String string = configurationAccessor.getDateFormat().getPattern() + " " + configurationAccessor.getTimeFormat().getPattern();
            short s = xSSFCreationHelper.createDataFormat().getFormat(string.toLowerCase());
            XSSFCellStyle xSSFCellStyle2 = xSSFWorkbook.createCellStyle();
            xSSFCellStyle2.setDataFormat(s);
            short s2 = xSSFCreationHelper.createDataFormat().getFormat("\"" + this.message(GeneralKeys.Ui.YES, new Object[0]) + "\";;\"" + this.message(GeneralKeys.Ui.NO, new Object[0]) + "\";");
            XSSFCellStyle xSSFCellStyle3 = xSSFWorkbook.createCellStyle();
            xSSFCellStyle3.setDataFormat(s2);
            this.processBatch(exportParameters.getEntities(), arg_0 -> this.lambda$build$5(xSSFSheet, atomicInteger, list, (Map)object, (Map)object2, xSSFCreationHelper, xSSFWorkbook, hashMap2, hashMap, xSSFCellStyle2, xSSFCellStyle3, formatterImpl, arg_0));
            for (int i = 0; i < list.size(); ++i) {
                xSSFSheet.autoSizeColumn(i);
            }
            File file = this.cyclosProperties.newTempFile(exportParameters.getContext().name(), ".xlsx");
            try {
                try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                    xSSFWorkbook.write((OutputStream)fileOutputStream);
                    xSSFWorkbook.close();
                }
                fileOutputStream = new SerializableInputStream(file);
                return fileOutputStream;
            }
            catch (IOException iOException) {
                file.delete();
                throw new UncheckedIOException("Error exporting file to XLSX", iOException);
            }
        }
        finally {
            LocaleUtil.resetUserTimeZone();
        }
    }

    private String numberFormat(int n) {
        String string = "#,##0";
        String string2 = n == 0 ? "" : "." + StringHelper.repeat((String)"0", (int)n);
        return string + string2;
    }

    private /* synthetic */ void lambda$build$5(XSSFSheet xSSFSheet, AtomicInteger atomicInteger, List list, Map map, Map map2, XSSFCreationHelper xSSFCreationHelper, XSSFWorkbook xSSFWorkbook, Map map3, Map map4, XSSFCellStyle xSSFCellStyle, XSSFCellStyle xSSFCellStyle2, FormatterImpl formatterImpl, Object object) {
        XSSFRow xSSFRow = xSSFSheet.createRow(atomicInteger.getAndIncrement());
        for (int i = 0; i < list.size(); ++i) {
            Object object2;
            TabularExportHandlerImpl.Column column = (TabularExportHandlerImpl.Column)list.get(i);
            Object object3 = column.getValue(object);
            XSSFCell xSSFCell = xSSFRow.createCell(i);
            if (object3 instanceof CurrencyAmount) {
                object2 = (CurrencyAmount)object3;
                if (object2.getAmount() == null) {
                    xSSFCell.setCellValue("");
                    continue;
                }
                XSSFCellStyle xSSFCellStyle3 = map.computeIfAbsent(object2.getCurrency(), currency -> {
                    short s = map2.computeIfAbsent(currency, currency2 -> {
                        Object object;
                        XSSFDataFormat xSSFDataFormat = xSSFCreationHelper.createDataFormat();
                        Object object2 = (String)ObjectHelper.defaultValue((Object)this.getTranslatedValue((BaseEntity)currency, QCurrency.currency.prefix), (Object)"");
                        if (!((String)object2).isEmpty()) {
                            object2 = "\"" + (String)object2 + "\"";
                        }
                        if (!((String)(object = (String)ObjectHelper.defaultValue((Object)this.getTranslatedValue((BaseEntity)currency, QCurrency.currency.suffix), (Object)""))).isEmpty()) {
                            object = "\"" + (String)object + "\"";
                        }
                        String string = (String)object2 + this.numberFormat(currency.getPrecision()) + (String)object;
                        return xSSFDataFormat.getFormat(string + ";[Red](" + string + ")");
                    });
                    XSSFCellStyle xSSFCellStyle = xSSFWorkbook.createCellStyle();
                    xSSFCellStyle.setAlignment(HorizontalAlignment.RIGHT);
                    xSSFCellStyle.setDataFormat(s);
                    return xSSFCellStyle;
                });
                xSSFCell.setCellStyle((CellStyle)xSSFCellStyle3);
                xSSFCell.setCellValue(object2.getAmount().doubleValue());
                continue;
            }
            if (object3 instanceof Number) {
                if (object3 instanceof BigDecimal) {
                    object2 = (BigDecimal)object3;
                    int n = Math.min(((BigDecimal)object2).scale(), BigDecimalHelper.MAX_SCALE);
                    XSSFCellStyle xSSFCellStyle4 = map3.computeIfAbsent(n, n3 -> {
                        short s = map4.computeIfAbsent(n, n2 -> {
                            XSSFDataFormat xSSFDataFormat = xSSFCreationHelper.createDataFormat();
                            return xSSFDataFormat.getFormat(this.numberFormat(n));
                        });
                        XSSFCellStyle xSSFCellStyle = xSSFWorkbook.createCellStyle();
                        xSSFCellStyle.setAlignment(HorizontalAlignment.RIGHT);
                        xSSFCellStyle.setDataFormat(s);
                        return xSSFCellStyle;
                    });
                    xSSFCell.setCellStyle((CellStyle)xSSFCellStyle4);
                }
                xSSFCell.setCellValue(((Number)object3).doubleValue());
                continue;
            }
            if (object3 instanceof Date) {
                xSSFCell.setCellValue((Date)object3);
                xSSFCell.setCellStyle((CellStyle)xSSFCellStyle);
                continue;
            }
            if (object3 instanceof Calendar) {
                xSSFCell.setCellValue((Calendar)object3);
                xSSFCell.setCellStyle((CellStyle)xSSFCellStyle);
                continue;
            }
            if (object3 instanceof Boolean) {
                xSSFCell.setCellValue(((Boolean)object3).booleanValue());
                xSSFCell.setCellStyle((CellStyle)xSSFCellStyle2);
                continue;
            }
            xSSFCell.setCellValue(formatterImpl.format(object3));
        }
    }
}

