/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import org.cyclos.entities.marketplace.BasicAd;
import org.cyclos.entities.system.ChannelConfiguration;
import org.cyclos.entities.system.EntityLog;
import org.cyclos.entities.users.User;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.system.EntityLogRegistry;
import org.cyclos.impl.utils.conversion.EntityVOConverter;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.system.entitylogs.EntityLogType;
import org.cyclos.model.system.entitylogs.EntityLogVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EntityLogVOConverter
extends EntityVOConverter<EntityLogVO> {
    @Autowired
    private EntityLogRegistry entityLogRegistry;
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;

    public EntityLogVOConverter() {
        super(EntityLogVO.class);
    }

    @Override
    protected void fill(Object object, EntityLogVO entityLogVO, Object[] objectArray, InvocationContext.ConversionContext conversionContext) {
        super.fill(object, entityLogVO, objectArray, conversionContext);
        if (object instanceof EntityLog) {
            EntityLog entityLog = (EntityLog)object;
            EntityLogType entityLogType = entityLog.getType();
            if (entityLogType.isUser() && entityLog.getOwnerEntityId() != null) {
                try {
                    this.entityManagerHandler.find(User.class, entityLog.getOwnerEntityId());
                }
                catch (EntityNotFoundException entityNotFoundException) {
                    entityLogVO.setOwnerEntityId(null);
                }
            }
            long l = entityLog.getEntityId();
            try {
                this.entityManagerHandler.find(this.entityLogRegistry.getHandler(entityLogType).getEntityClass(), Long.valueOf(l));
            }
            catch (EntityNotFoundException entityNotFoundException) {
                entityLogVO.setEntityId(null);
            }
            if (entityLogType == EntityLogType.AD) {
                try {
                    entityLogVO.setAdType(((BasicAd)this.rawEntityManagerHandler.find(BasicAd.class, Long.valueOf(l))).getAdType());
                }
                catch (EntityNotFoundException entityNotFoundException) {}
            } else if (entityLogType == EntityLogType.CHANNEL_CONFIGURATION) {
                try {
                    ChannelConfiguration channelConfiguration = (ChannelConfiguration)this.rawEntityManagerHandler.find(ChannelConfiguration.class, Long.valueOf(l));
                    entityLogVO.setChannelConfigurationConfigurationId(channelConfiguration.getConfiguration().getId());
                    entityLogVO.setChannelConfigurationChannelId(channelConfiguration.getChannel().getId());
                }
                catch (EntityNotFoundException entityNotFoundException) {
                    // empty catch block
                }
            }
        }
    }
}

