/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.impl.system.EntityLogHandler;
import org.cyclos.impl.system.EntityLogRegistry;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.system.entitylogs.EntityLogType;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class EntityLogRegistryImpl
implements EntityLogRegistry {
    private Map<EntityLogType, EntityLogHandler<? extends SimpleEntity, ? extends EntityDTO>> handlersByType = new HashMap<EntityLogType, EntityLogHandler<? extends SimpleEntity, ? extends EntityDTO>>();
    private Map<Class<? extends SimpleEntity>, EntityLogHandler<? extends SimpleEntity, ? extends EntityDTO>> handlersByClass = new HashMap<Class<? extends SimpleEntity>, EntityLogHandler<? extends SimpleEntity, ? extends EntityDTO>>();
    @Autowired
    private ApplicationContext applicationContext;

    public <E extends SimpleEntity, DTO extends EntityDTO> EntityLogHandler<E, DTO> getHandler(Class clazz) {
        EntityLogHandler<? extends SimpleEntity, ? extends EntityDTO> entityLogHandler = this.handlersByClass.get(clazz);
        while (entityLogHandler == null && clazz != SimpleEntity.class) {
            clazz = clazz.getSuperclass();
            entityLogHandler = this.handlersByClass.get(clazz);
        }
        return entityLogHandler;
    }

    public <T extends SimpleEntity, DTO extends EntityDTO> EntityLogHandler<T, DTO> getHandler(EntityLogType entityLogType) {
        return this.handlersByType.get(entityLogType);
    }

    public Iterable<EntityLogHandler<? extends SimpleEntity, ? extends EntityDTO>> getHandlers() {
        return () -> this.handlersByType.values().iterator();
    }

    public <E extends SimpleEntity> boolean isLogEnabled(E e) {
        EntityLogHandler entityLogHandler = this.getHandler(e.getClass());
        return entityLogHandler != null && entityLogHandler.isLogEnabled(e);
    }

    @PostConstruct
    private void initialize() {
        this.applicationContext.getBeansOfType(EntityLogHandler.class).values().stream().forEach(this::register);
        if (this.handlersByType.size() != EntityLogType.values().length) {
            throw new BeanInitializationException(String.format("Please ensure there is an %s for each %s", EntityLogHandler.class.getName(), EntityLogType.class.getName()));
        }
    }

    private void register(EntityLogHandler<? extends SimpleEntity, ? extends EntityDTO> entityLogHandler) {
        this.handlersByType.put(entityLogHandler.getType(), entityLogHandler);
        this.handlersByClass.put(entityLogHandler.getEntityClass(), entityLogHandler);
    }
}

