/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.system.CustomWizard;
import org.cyclos.entities.system.DirectWizard;
import org.cyclos.entities.system.MenuItemWizard;
import org.cyclos.entities.system.RegistrationWizard;
import org.cyclos.entities.system.SystemWizard;
import org.cyclos.entities.system.UserWizard;
import org.cyclos.entities.system.WizardWithChannels;
import org.cyclos.impl.EntityLogDescriptor;
import org.cyclos.impl.system.BaseEntityLogHandlerImpl;
import org.cyclos.model.CRUDOperation;
import org.cyclos.model.Property;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.entitylogs.EntityLogType;
import org.cyclos.model.system.wizards.CustomWizardDTO;
import org.cyclos.model.system.wizards.DirectWizardDTO;
import org.cyclos.model.system.wizards.MenuItemWizardDTO;
import org.cyclos.model.system.wizards.RegistrationWizardDTO;
import org.cyclos.model.system.wizards.SystemWizardDTO;
import org.cyclos.model.system.wizards.UserWizardDTO;
import org.cyclos.model.system.wizards.WizardWithChannelsDTO;
import org.cyclos.security.system.CustomWizardServiceSecurity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class CustomWizardEntityLogHandlerImpl
extends BaseEntityLogHandlerImpl<CustomWizard, CustomWizardDTO> {
    @Autowired
    @Lazy
    private CustomWizardServiceSecurity customWizardServiceSecurity;

    public Class<CustomWizard> getEntityClass() {
        return CustomWizard.class;
    }

    public EntityLogType getType() {
        return EntityLogType.CUSTOM_WIZARD;
    }

    public EntityLogDescriptor<? extends CustomWizardDTO> resolveLogDescriptor(CustomWizard customWizard) {
        EntityLogDescriptor entityLogDescriptor = new EntityLogDescriptor(this.resolveDtoType(customWizard)).property(CustomWizardDTO.NAME, GeneralKeys.Ui.NAME).property(CustomWizardDTO.DESCRIPTION, GeneralKeys.Ui.DESCRIPTION).property(CustomWizardDTO.INTERNAL_NAME, GeneralKeys.Ui.INTERNAL_NAME).property((Property)CustomWizardDTO.RESULT_TYPE, SystemKeys.Wizards.RESULT_TYPE).property((Property)CustomWizardDTO.SCRIPT, SystemKeys.Wizards.SCRIPT).property((Property)CustomWizardDTO.SCRIPT_PARAMETERS, SystemKeys.Wizards.SCRIPT_PARAMETERS).property((Property)CustomWizardDTO.SHOW_PROGRESS, SystemKeys.Wizards.SHOW_PROGRESS).property((Property)CustomWizardDTO.REQUIRE_CONFIRMATION_CREDENTIAL, SystemKeys.Operations.REQUIRE_CONFIRMATION_CREDENTIAL);
        if (customWizard instanceof WizardWithChannels) {
            entityLogDescriptor.cast().property((Property)WizardWithChannelsDTO.CHANNELS, SystemKeys.Wizards.CHANNELS);
            if (customWizard instanceof DirectWizard) {
                entityLogDescriptor.cast().property((Property)DirectWizardDTO.ICON, SystemKeys.Wizards.MOBILE_ICON).property((Property)DirectWizardDTO.SVG_ICON, GeneralKeys.Ui.SVG_ICON).property((Property)DirectWizardDTO.LABEL, SystemKeys.Wizards.LABEL);
                if (customWizard instanceof SystemWizard) {
                    entityLogDescriptor.cast().property((Property)SystemWizardDTO.ADMIN_MENU, SystemKeys.Wizards.ADMIN_MENU);
                } else if (customWizard instanceof UserWizard) {
                    entityLogDescriptor.cast().property((Property)UserWizardDTO.USER_MENU, SystemKeys.Wizards.USER_MENU).property((Property)UserWizardDTO.PROFILE_SECTION, SystemKeys.Wizards.PROFILE_SECTION);
                }
            }
        } else if (customWizard instanceof RegistrationWizard) {
            entityLogDescriptor.cast().property((Property)RegistrationWizardDTO.INCOMPLETE_REGISTRATION_NOTIFY_INTERVAL, SystemKeys.Wizards.NOTIFY_ON_INCOMPLETE_REGISTRATION);
        }
        return entityLogDescriptor;
    }

    @Override
    protected CustomWizard getEntityToViewLog(long l) {
        CustomWizard customWizard = this.find(CustomWizard.class, l);
        if (this.customWizardServiceSecurity.canPerformOperation((SimpleEntity)customWizard, CRUDOperation.READ)) {
            return customWizard;
        }
        return null;
    }

    private Class<? extends CustomWizardDTO> resolveDtoType(CustomWizard customWizard) {
        if (customWizard instanceof RegistrationWizard) {
            return RegistrationWizardDTO.class;
        }
        if (customWizard instanceof MenuItemWizard) {
            return MenuItemWizardDTO.class;
        }
        if (customWizard instanceof SystemWizard) {
            return SystemWizardDTO.class;
        }
        if (customWizard instanceof UserWizard) {
            return UserWizardDTO.class;
        }
        return null;
    }
}

