/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import org.cyclos.entities.NamedEntity;
import org.cyclos.entities.contentmanagement.BaseStaticContent;
import org.cyclos.entities.contentmanagement.ContentItem;
import org.cyclos.entities.contentmanagement.MobilePage;
import org.cyclos.entities.system.ChannelConfiguration;
import org.cyclos.entities.system.CustomWizardField;
import org.cyclos.entities.system.CustomWizardStep;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.contentmanagement.DataTranslationHandler;
import org.cyclos.impl.contentmanagement.TranslationHandler;
import org.cyclos.impl.utils.conversion.EntityVOConverter;
import org.cyclos.model.system.scripts.CustomScriptUsedInVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomScriptUsedInVOConverter
extends EntityVOConverter<CustomScriptUsedInVO> {
    @Autowired
    private DataTranslationHandler dataTranslationHandler;
    @Autowired
    private TranslationHandler translationHandler;

    public CustomScriptUsedInVOConverter() {
        super(CustomScriptUsedInVO.class);
    }

    @Override
    public CustomScriptUsedInVO convert(Class<CustomScriptUsedInVO> clazz, Object object, Object[] objectArray, InvocationContext.ConversionContext conversionContext) {
        CustomScriptUsedInVO customScriptUsedInVO = super.convert(clazz, object, objectArray, conversionContext);
        if (object instanceof ChannelConfiguration) {
            ChannelConfiguration channelConfiguration = (ChannelConfiguration)object;
            customScriptUsedInVO.setName(this.dataTranslationHandler.getName((NamedEntity)channelConfiguration.getConfiguration()));
        } else if (object instanceof BaseStaticContent) {
            BaseStaticContent baseStaticContent = (BaseStaticContent)object;
            customScriptUsedInVO.setName(this.dataTranslationHandler.getName((NamedEntity)baseStaticContent.getConfiguration()) + " - " + this.translationHandler.message(baseStaticContent.getNature().getMessageKey(), new Object[0]));
        } else if (object instanceof ContentItem) {
            ContentItem contentItem = (ContentItem)object;
            customScriptUsedInVO.setName(this.dataTranslationHandler.getName((NamedEntity)contentItem.getConfiguration()) + " - " + this.dataTranslationHandler.getName((NamedEntity)contentItem));
        } else if (object instanceof MobilePage) {
            MobilePage mobilePage = (MobilePage)object;
            customScriptUsedInVO.setName(this.dataTranslationHandler.getName((NamedEntity)mobilePage.getConfiguration()) + " - " + this.dataTranslationHandler.getName((NamedEntity)mobilePage));
        } else if (object instanceof CustomWizardField) {
            CustomWizardField customWizardField = (CustomWizardField)object;
            customScriptUsedInVO.setName(this.dataTranslationHandler.getName((NamedEntity)customWizardField.getWizard()) + " - " + this.dataTranslationHandler.getName((NamedEntity)customWizardField));
        } else if (object instanceof CustomWizardStep) {
            CustomWizardStep customWizardStep = (CustomWizardStep)object;
            customScriptUsedInVO.setName(this.dataTranslationHandler.getName((NamedEntity)customWizardStep.getWizard()) + " - " + this.dataTranslationHandler.getName((NamedEntity)customWizardStep));
        }
        return customScriptUsedInVO;
    }
}

