/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import com.google.common.collect.Streams;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.EntityPathBase;
import groovy.lang.Closure;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.PostConstruct;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.script.SimpleScriptContext;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.entities.NamedEntity;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.access.QPasswordType;
import org.cyclos.entities.banking.QAccountFee;
import org.cyclos.entities.banking.QTransactionCustomField;
import org.cyclos.entities.banking.QTransferFee;
import org.cyclos.entities.banking.QTransferStatusFlow;
import org.cyclos.entities.banking.QVoucherCustomField;
import org.cyclos.entities.contentmanagement.QBanner;
import org.cyclos.entities.contentmanagement.QBaseStaticContent;
import org.cyclos.entities.contentmanagement.QDocumentCustomField;
import org.cyclos.entities.contentmanagement.QMenuItem;
import org.cyclos.entities.contentmanagement.QMobilePage;
import org.cyclos.entities.marketplace.QAdCustomField;
import org.cyclos.entities.system.CustomScript;
import org.cyclos.entities.system.QConfiguration;
import org.cyclos.entities.system.QCustomBackgroundTask;
import org.cyclos.entities.system.QCustomField;
import org.cyclos.entities.system.QCustomOperation;
import org.cyclos.entities.system.QCustomOperationField;
import org.cyclos.entities.system.QCustomRecurringTask;
import org.cyclos.entities.system.QCustomScript;
import org.cyclos.entities.system.QCustomSmsOperationConfiguration;
import org.cyclos.entities.system.QCustomWebService;
import org.cyclos.entities.system.QCustomWizard;
import org.cyclos.entities.system.QCustomWizardField;
import org.cyclos.entities.system.QExportFormat;
import org.cyclos.entities.system.QExtensionPoint;
import org.cyclos.entities.system.QServiceInterceptor;
import org.cyclos.entities.system.QSmsChannelConfiguration;
import org.cyclos.entities.users.QContactCustomField;
import org.cyclos.entities.users.QContactInfoField;
import org.cyclos.entities.users.QRecordCustomField;
import org.cyclos.entities.users.QUserCustomField;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.RequestContext;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.sql.NativeQueryHandler;
import org.cyclos.impl.system.CompiledScriptCacheKey;
import org.cyclos.impl.system.CompiledScriptCacheValue;
import org.cyclos.impl.system.CustomScriptAccessor;
import org.cyclos.impl.system.CustomScriptServiceLocal;
import org.cyclos.impl.system.ProfilingEntry;
import org.cyclos.impl.system.ProfilingScriptEndEvent;
import org.cyclos.impl.system.ProfilingScriptStartEvent;
import org.cyclos.impl.system.RawFileServiceLocal;
import org.cyclos.impl.system.ScriptHelper;
import org.cyclos.impl.system.scriptbindings.ScriptBindingsRegistry;
import org.cyclos.impl.utils.SerializablePredicate;
import org.cyclos.impl.utils.cache.Cache;
import org.cyclos.impl.utils.cache.CacheHandler;
import org.cyclos.impl.utils.cache.CacheType;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.impl.utils.validation.BasePropertyAccess;
import org.cyclos.impl.utils.validation.EntityValidation;
import org.cyclos.impl.utils.validation.PropertyAccess;
import org.cyclos.impl.utils.validation.PropertyValidation;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.impl.utils.validation.validations.BaseEntityValidation;
import org.cyclos.impl.utils.validation.validations.BasePropertyValidation;
import org.cyclos.model.CyclosException;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.NamedEntityVO;
import org.cyclos.model.Property;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.scripts.CustomScriptDTO;
import org.cyclos.model.system.scripts.CustomScriptData;
import org.cyclos.model.system.scripts.CustomScriptException;
import org.cyclos.model.system.scripts.CustomScriptQuery;
import org.cyclos.model.system.scripts.CustomScriptUsedInVO;
import org.cyclos.model.system.scripts.CustomScriptVO;
import org.cyclos.model.system.scripts.DefaultScriptFunction;
import org.cyclos.model.system.scripts.RunScriptData;
import org.cyclos.model.system.scripts.RunScriptParams;
import org.cyclos.model.system.scripts.ScriptFunction;
import org.cyclos.model.system.scripts.ScriptResult;
import org.cyclos.model.system.scripts.ScriptResultType;
import org.cyclos.model.system.scripts.ScriptType;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.model.utils.RawFileVO;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.server.utils.IOHelper;
import org.cyclos.server.utils.PropertiesHelper;
import org.cyclos.server.utils.ResourceHelper;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.utils.AggregatedMap;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ContentType;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Page;
import org.cyclos.utils.Pair;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomScriptServiceImpl
extends CRUDServiceImpl<CustomScript, QCustomScript, CustomScriptDTO, CustomScriptData, ScriptType>
implements CustomScriptServiceLocal {
    public static final String CODE_SEPARATOR_LINE;
    public static final String PARAMS_SEPARATOR_LINE;
    public static final String SCRIPT_LANGUAGE = "groovy";
    @Autowired
    private NativeQueryHandler nativeQueryHandler;
    private ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
    @Autowired
    private ScriptHelper scriptHelper;
    @Autowired
    private CacheHandler cacheHandler;
    @Autowired
    private InvokerHandler invokerHandler;
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    private RawFileServiceLocal rawFileService;
    private volatile Map<String, Object> _defaultBindings;
    private Cache<CompiledScriptCacheKey, CompiledScriptCacheValue> cache;
    @Autowired
    private CyclosProperties cyclosProperties;

    private static String readContent(String string) {
        try {
            return ResourceHelper.readContent((String)string);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public CustomScriptServiceImpl() {
        super(CustomScript.class, QCustomScript.customScript, CustomScriptDTO.class);
    }

    public SerializableInputStream getCodeForDebug(CustomScriptVO customScriptVO) throws FrameworkException {
        CustomScript customScript = (CustomScript)this.conversionHandler.convert(CustomScript.class, (Object)customScriptVO);
        File file = this.cyclosProperties.newTempFile("script", ".zip");
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file));){
            InputStream inputStream;
            ScriptFunction[] scriptFunctionArray;
            String string = null;
            String string2 = customScript.getName().replaceAll("\\s+", "_");
            Object object = scriptFunctionArray = this.getFunctions(customScript.getType());
            int n = ((ScriptFunction[])object).length;
            for (int i = 0; i < n; ++i) {
                String string3;
                ScriptFunction scriptFunction = object[i];
                Pair<String, String> pair = this.resolveCodeAndParameters(customScript, scriptFunction);
                if (pair != null && StringHelper.isNotBlank((Object)pair.getSecond())) {
                    string = (String)pair.getSecond();
                }
                String string4 = string3 = pair == null ? null : (String)pair.getFirst();
                if (StringHelper.isBlank((Object)string3)) continue;
                zipOutputStream.putNextEntry(new ZipEntry(string2 + "_" + scriptFunction.name() + ".groovy"));
                IOUtils.write((String)string3, (OutputStream)zipOutputStream, (Charset)StandardCharsets.UTF_8);
                zipOutputStream.closeEntry();
            }
            if (StringHelper.isNotBlank(string)) {
                zipOutputStream.putNextEntry(new ZipEntry(string2 + ".properties"));
                IOUtils.write(string, (OutputStream)zipOutputStream, (Charset)StandardCharsets.UTF_8);
                zipOutputStream.closeEntry();
            }
            if ((object = this.getClass().getResourceAsStream("/debugScripts/README.txt")) != null) {
                zipOutputStream.putNextEntry(new ZipEntry("README.txt"));
                IOUtils.copy((InputStream)object, (OutputStream)zipOutputStream);
                zipOutputStream.closeEntry();
            }
            if ((inputStream = this.getClass().getResourceAsStream("/debugScripts/RunScript.groovy")) != null) {
                zipOutputStream.putNextEntry(new ZipEntry("RunScript.groovy"));
                IOUtils.copy((InputStream)inputStream, (OutputStream)zipOutputStream);
                zipOutputStream.closeEntry();
            }
        }
        catch (Exception exception) {
            file.delete();
            throw exception instanceof RuntimeException ? (RuntimeException)exception : new IllegalStateException(exception);
        }
        return new SerializableInputStream(file);
    }

    public ScriptFunction[] getFunctions(ScriptType scriptType) {
        Class clazz = scriptType.getFunctionClass();
        EnumSet enumSet = EnumSet.allOf(clazz);
        return (ScriptFunction[])enumSet.toArray(ScriptFunction[]::new);
    }

    public Set<Long> getReverseDependencyIds(Long l) {
        HashSet<Long> hashSet = new HashSet<Long>();
        this.fillReverseDependencies(l, hashSet);
        return hashSet;
    }

    public RunScriptData getRunData() throws FrameworkException {
        RunScriptData runScriptData = new RunScriptData();
        List<CustomScript> list = this.listByType(ScriptType.LIBRARY);
        runScriptData.setLibraries(this.conversionHandler.convertList(CustomScriptVO.class, list));
        return runScriptData;
    }

    public List<CustomScript> listByType(ScriptType scriptType) throws FrameworkException {
        return ((DBQuery)((DBQuery)this.from().where((Predicate)((QCustomScript)this.$).type.eq((Object)scriptType))).orderBy(((QCustomScript)this.$).name.asc())).list((Expression)this.$);
    }

    public List<CustomScriptUsedInVO> listUsages(CustomScriptVO customScriptVO) throws FrameworkException {
        CustomScript customScript = (CustomScript)this.conversionHandler.convert(CustomScript.class, (Object)customScriptVO);
        Stream stream = Stream.empty();
        ScriptType scriptType = customScript.getType();
        switch (scriptType) {
            case ACCOUNT_FEE_CALCULATION: {
                stream = this.usedInEntities(QAccountFee.accountFee, QAccountFee::customScript, customScript);
                break;
            }
            case ACCOUNT_NUMBER_GENERATION: {
                stream = this.usedInEntities(QConfiguration.configuration, qConfiguration -> qConfiguration.accountNumberConfiguration().script(), customScript);
                break;
            }
            case IP_GEOLOCATION: {
                stream = this.usedInEntities(QConfiguration.configuration, qConfiguration -> qConfiguration.ipGeolocationConfiguration().script(), customScript);
                break;
            }
            case CUSTOM_FIELD_VALIDATION: 
            case LOAD_CUSTOM_FIELD_VALUES: {
                Function<QCustomField, Stream> function = qCustomField2 -> this.usedInEntities((EntityPathBase)qCustomField2, qCustomField -> scriptType == ScriptType.CUSTOM_FIELD_VALIDATION ? qCustomField.validationScript() : qCustomField.loadValuesScript(), customScript);
                stream = Stream.of(QUserCustomField.userCustomField._super, QAdCustomField.adCustomField._super, QRecordCustomField.recordCustomField._super, QTransactionCustomField.transactionCustomField._super, QCustomOperationField.customOperationField._super, QCustomWizardField.customWizardField._super, QContactCustomField.contactCustomField._super, QContactInfoField.contactInfoField._super, QDocumentCustomField.documentCustomField._super, QVoucherCustomField.voucherCustomField._super).flatMap(qCustomField -> (Stream)function.apply((QCustomField)qCustomField));
                break;
            }
            case CUSTOM_OPERATION: {
                stream = this.usedInEntities(QCustomOperation.customOperation, QCustomOperation::script, customScript);
                break;
            }
            case CUSTOM_WEB_SERVICE: {
                stream = this.usedInEntities(QCustomWebService.customWebService, QCustomWebService::script, customScript);
                break;
            }
            case CUSTOM_WIZARD: {
                stream = this.usedInEntities(QCustomWizard.customWizard, QCustomWizard::script, customScript);
                break;
            }
            case EXPORT_FORMAT: {
                stream = this.usedInEntities(QExportFormat.exportFormat, QExportFormat::script, customScript);
                break;
            }
            case EXTENSION_POINT: {
                stream = this.usedInEntities(QExtensionPoint.extensionPoint, QExtensionPoint::script, customScript);
                break;
            }
            case INBOUND_SMS: {
                stream = this.usedInEntities(QSmsChannelConfiguration.smsChannelConfiguration, QSmsChannelConfiguration::script, customScript);
                break;
            }
            case LIBRARY: {
                stream = ((DBQuery)((DBQuery)this.rawEntityManagerHandler.selectFrom(this.$).where((Predicate)((QCustomScript)this.$).dependencies.contains((Object)customScript))).limit(Long.MAX_VALUE)).stream();
                break;
            }
            case LINK_GENERATION: {
                stream = this.usedInEntities(QConfiguration.configuration, qConfiguration -> qConfiguration.linkGenerationConfiguration().script(), customScript);
                break;
            }
            case PHONE_NUMBER_HANDLING: {
                stream = this.usedInEntities(QConfiguration.configuration, qConfiguration -> qConfiguration.phoneNumberHandlingConfiguration().script(), customScript);
                break;
            }
            case NOTIFICATION: {
                stream = this.usedInEntities(QConfiguration.configuration, qConfiguration -> qConfiguration.notificationConfiguration().script(), customScript);
                break;
            }
            case OUTBOUND_SMS: {
                stream = this.usedInEntities(QConfiguration.configuration, qConfiguration -> qConfiguration.outboundSmsConfiguration().script(), customScript);
                break;
            }
            case PASSWORD_HANDLING: {
                stream = this.usedInEntities(QPasswordType.passwordType, QPasswordType::script, customScript);
                break;
            }
            case SCHEDULED_TASK: {
                stream = this.usedInEntities(QCustomRecurringTask.customRecurringTask, QCustomRecurringTask::script, customScript);
                break;
            }
            case BACKGROUND_TASK: {
                stream = this.usedInEntities(QCustomBackgroundTask.customBackgroundTask, QCustomBackgroundTask::script, customScript);
                break;
            }
            case SERVICE_INTERCEPTOR: {
                stream = this.usedInEntities(QServiceInterceptor.serviceInterceptor, QServiceInterceptor::script, customScript);
                break;
            }
            case SESSION_HANDLING: {
                stream = this.usedInEntities(QConfiguration.configuration, qConfiguration -> qConfiguration.customSessionConfiguration().script(), customScript);
                break;
            }
            case SMS_OPERATION: {
                stream = this.usedInEntities(QCustomSmsOperationConfiguration.customSmsOperationConfiguration, QCustomSmsOperationConfiguration::script, customScript);
                break;
            }
            case TRANSFER_FEE_CALCULATION: {
                stream = this.usedInEntities(QTransferFee.transferFee, QTransferFee::customScript, customScript);
                break;
            }
            case TRANSFER_STATUS: {
                stream = this.usedInEntities(QTransferStatusFlow.transferStatusFlow, QTransferStatusFlow::script, customScript);
                break;
            }
            case CONTENT_HELPER: {
                stream = Streams.concat((Stream[])new Stream[]{this.usedInEntities(QBaseStaticContent.baseStaticContent, QBaseStaticContent::contentScript, customScript), this.usedInEntities(QMenuItem.menuItem, QMenuItem::contentScript, customScript), this.usedInEntities(QMobilePage.mobilePage, QMobilePage::contentScript, customScript), this.usedInEntities(QBanner.banner, QBanner::contentScript, customScript)});
            }
        }
        return CollectionHelper.sort((Collection)stream.map(simpleEntity -> (CustomScriptUsedInVO)this.conversionHandler.convert(CustomScriptUsedInVO.class, simpleEntity)).collect(Collectors.toSet()), Comparator.comparing(CustomScriptUsedInVO::getScriptUsedInType).thenComparing(NamedEntityVO::getName));
    }

    public CustomScriptAccessor newAccessor(CustomScript customScript, String string) throws FrameworkException {
        return new CustomScriptAccessorImpl(customScript, string);
    }

    @Override
    public CustomScript newEntity(ScriptType scriptType) {
        CustomScript customScript = new CustomScript();
        customScript.setRunAsSystem(true);
        customScript.setType(scriptType);
        return customScript;
    }

    public Bindings resolveBindings(String string, Map<String, Object> map) {
        Map<String, Object> map2 = this.initBindings();
        InvocationContext invocationContext = InvocationContext.get();
        map2.put("sessionData", invocationContext == null ? null : invocationContext.sessionData());
        map2.put("transactionLevel", invocationContext == null ? null : invocationContext.getTransactionLevel());
        map2.put("transactionStatus", invocationContext == null ? null : invocationContext.getTransactionStatus());
        if (map != null) {
            map2.putAll(map);
        }
        return this.createBindings(string, map2);
    }

    public Pair<String, String> resolveCodeAndParameters(CustomScript customScript, ScriptFunction scriptFunction) {
        String string;
        Map map = customScript.getFunctions();
        String string2 = string = map == null ? null : (String)map.get(scriptFunction.name());
        if (StringHelper.isBlank(string)) {
            return null;
        }
        Collection<CustomScript> collection = this.resolveDependencies(customScript);
        if (collection.isEmpty()) {
            return Pair.create((Object)string, (Object)customScript.getParameters());
        }
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        for (CustomScript customScript2 : collection) {
            String string3 = (String)CollectionHelper.first(customScript2.getFunctions().values());
            if (stringBuilder.length() > 0) {
                stringBuilder.append('\n');
            }
            stringBuilder.append(CODE_SEPARATOR_LINE).append("// ").append(customScript2.getName()).append('\n').append(CODE_SEPARATOR_LINE).append('\n').append(string3).append('\n');
            if (!StringHelper.isNotBlank((Object)customScript2.getParameters())) continue;
            stringBuilder2.append(PARAMS_SEPARATOR_LINE).append("# ").append(customScript2.getName()).append('\n').append(PARAMS_SEPARATOR_LINE).append('\n').append(customScript2.getParameters()).append('\n');
        }
        stringBuilder.append('\n').append(CODE_SEPARATOR_LINE).append("// ").append(customScript.getName()).append('\n').append(CODE_SEPARATOR_LINE).append('\n').append(string).append('\n');
        if (StringHelper.isNotBlank((Object)customScript.getParameters())) {
            stringBuilder2.append('\n').append(PARAMS_SEPARATOR_LINE).append("# ").append(customScript.getName()).append('\n').append(PARAMS_SEPARATOR_LINE).append('\n').append(customScript.getParameters());
        }
        return Pair.create((Object)stringBuilder.toString(), (Object)stringBuilder2.toString());
    }

    public ScriptResult run(RunScriptParams runScriptParams) throws FrameworkException {
        ScriptResultType scriptResultType;
        ScriptResult scriptResult;
        Validator validator = new Validator();
        validator.property((Property)RunScriptParams.DEPENDENCIES, SystemKeys.Scripts.DEPENDENCIES).entity(CustomScript.class, (EntityValidation)new BaseEntityValidation<CustomScript>(){

            protected boolean isValid(Object object, Object object2, CustomScript customScript) {
                return customScript.getType() == ScriptType.LIBRARY;
            }
        });
        validator.property((Property)RunScriptParams.SCRIPT, SystemKeys.Scripts.RUN_SCRIPT).required();
        this.validate(validator, runScriptParams, "run");
        Set set = this.conversionHandler.convertSet(CustomScript.class, (Iterable)runScriptParams.getDependencies());
        Pair<String, String> pair = this.resolveCodeAndParameters(runScriptParams.isRunAsSystem(), set, runScriptParams.getScript(), runScriptParams.getParameters());
        Object object = this.doRunScript((String)pair.getFirst(), (String)pair.getSecond(), runScriptParams.isRunAsSystem(), null);
        if (object == null) {
            scriptResult = new ScriptResult();
        } else if (object instanceof ScriptResult) {
            scriptResult = (ScriptResult)object;
        } else if (object instanceof CharSequence) {
            scriptResult = new ScriptResult();
            scriptResult.setPlainText(object.toString());
        } else if (object instanceof InputStream || object instanceof Reader || object instanceof File || object instanceof FileInfo) {
            FileInfo fileInfo;
            File file;
            try {
                Object object2;
                if (object instanceof InputStream) {
                    file = this.cyclosProperties.newTempFile("run-script", ".bin");
                    IOHelper.copyAndClose((InputStream)((InputStream)object), (File)file);
                    object = file;
                } else if (object instanceof Reader) {
                    file = this.cyclosProperties.newTempFile("run-script", ".txt");
                    IOHelper.copyAndClose((Reader)((Reader)object), (File)file);
                    object = file;
                } else if (object instanceof File) {
                    file = (File)object;
                    object2 = FilenameUtils.getBaseName((String)file.getName());
                    if (((String)object2).length() < 3) {
                        object2 = "temp-" + (String)object2;
                    }
                    String string = FilenameUtils.getExtension((String)file.getName());
                    File file2 = this.cyclosProperties.newTempFile((String)object2, string);
                    IOHelper.copyAndClose((InputStream)new FileInputStream(file), (File)file2);
                    object = file2;
                }
                if (object instanceof File) {
                    file = (File)object;
                    fileInfo = new FileInfo();
                    fileInfo.setName(file.getName());
                    object2 = (ContentType)ObjectHelper.defaultValue((Object)ContentType.getByFileName((String)file.getName()), (Object)ContentType.BIN);
                    fileInfo.setContentType(object2.getMimeType());
                    if (!object2.isBinary()) {
                        fileInfo.setEncoding("UTF-8");
                    }
                    fileInfo.setContent(new SerializableInputStream(file));
                } else {
                    fileInfo = (FileInfo)object;
                }
            }
            catch (Exception exception) {
                throw new CustomScriptException((Throwable)exception);
            }
            file = this.rawFileService.createTemp(fileInfo.getName(), fileInfo.getContentType(), fileInfo.getContent());
            scriptResult = new ScriptResult();
            scriptResult.setFile((RawFileVO)this.conversionHandler.convert(RawFileVO.class, (Object)file));
        } else {
            scriptResult = (ScriptResult)this.conversionHandler.convert(ScriptResult.class, object);
            boolean bl = true;
            for (Property property : scriptResult.properties()) {
                if (!StringHelper.isNotBlank((Object)scriptResult.get(property))) continue;
                bl = false;
            }
            if (bl) {
                scriptResult = new ScriptResult();
                scriptResult.setPlainText(object.toString());
            }
        }
        if (StringHelper.isNotBlank((Object)scriptResult.getPlainText())) {
            scriptResultType = ScriptResultType.PLAIN_TEXT;
        } else if (StringHelper.isNotBlank((Object)scriptResult.getRichText())) {
            scriptResultType = ScriptResultType.RICH_TEXT;
        } else if (StringHelper.isNotBlank((Object)scriptResult.getNotification())) {
            scriptResultType = ScriptResultType.NOTIFICATION;
        } else if (StringHelper.isNotBlank((Object)scriptResult.getFile())) {
            scriptResultType = ScriptResultType.FILE;
        } else {
            scriptResultType = ScriptResultType.PLAIN_TEXT;
            scriptResult.setPlainText(this.message(SystemKeys.Scripts.RUN_DONE_NO_RESULT, new Object[0]));
        }
        scriptResult.setType(scriptResultType);
        return scriptResult;
    }

    public <T> T runScript(String string, Set<CustomScript> set) {
        return this.runScript(string, null, null, set, true);
    }

    public <T> T runScript(String string, String string2, Map<String, Object> map, Set<CustomScript> set, boolean bl) {
        Pair<String, String> pair = this.resolveCodeAndParameters(bl, set, string, string2);
        return (T)(pair == null ? null : this.doRunScript((String)pair.getFirst(), (String)pair.getSecond(), true, map));
    }

    public Page<CustomScriptVO> search(CustomScriptQuery customScriptQuery) throws FrameworkException {
        String string;
        String string2;
        DBQuery<?> dBQuery = this.from();
        ScriptType scriptType = customScriptQuery.getType();
        if (scriptType != null) {
            dBQuery.where((Predicate)((QCustomScript)this.$).type.eq((Object)scriptType));
        }
        if ((string2 = StringHelper.trimToNull((Object)customScriptQuery.getName())) != null) {
            dBQuery.where((Predicate)((QCustomScript)this.$).name.containsIgnoreCase(string2));
        }
        if ((string = StringHelper.trimToNull((Object)customScriptQuery.getContent())) != null) {
            Long l = SimpleEntity.id((SimpleEntity)this.getSessionData().getNetwork());
            List list = this.nativeQueryHandler.scriptIdsMatchingContent(l, string);
            if (list.isEmpty()) {
                dBQuery.where((Predicate)((QCustomScript)this.$).id.isNull());
            } else {
                dBQuery.where((Predicate)((QCustomScript)this.$).id.in((Collection)list));
            }
        }
        dBQuery.orderBy(((QCustomScript)this.$).name.asc());
        return dBQuery.page(CustomScriptVO.class, (QueryParameters)customScriptQuery, (Expression)this.$);
    }

    @Override
    protected CustomScriptData getData(CustomScript customScript) {
        CustomScriptData customScriptData = new CustomScriptData();
        customScriptData.setDto((EntityDTO)((CustomScriptDTO)this.toDTO(customScript)));
        customScriptData.setScriptFunctions(Arrays.asList(this.getFunctions(customScript.getType())));
        List<CustomScript> list = this.listByType(ScriptType.LIBRARY);
        list.remove(customScript);
        customScriptData.setLibraries(this.conversionHandler.convertList(CustomScriptVO.class, list));
        customScriptData.setTemplates(this.loadTemplatesScriptTemplates(customScript.getType()));
        return customScriptData;
    }

    @Override
    protected void onAfterSave(CustomScript customScript, CustomScript customScript2, Object object) {
        Long l = customScript.getId();
        this.cacheHandler.schedulePartialEvict(CacheType.COMPILED_SCRIPTS, (SerializablePredicate & Serializable)compiledScriptCacheKey -> compiledScriptCacheKey.matches(l.longValue()));
    }

    @Override
    protected Object onBeforeSave(CustomScript customScript, CustomScript customScript2) {
        ScriptFunction[] scriptFunctionArray = this.getFunctions(customScript.getType());
        HashSet<String> hashSet = new HashSet<String>();
        for (ScriptFunction scriptFunction : scriptFunctionArray) {
            hashSet.add(scriptFunction.name());
        }
        Map map = customScript.getFunctions();
        map.keySet().retainAll(hashSet);
        if (!customScript.getType().allowAuthenticationCustomization()) {
            customScript.setRunAsSystem(customScript.getType().mustRunAsSystem());
        }
        return null;
    }

    @Override
    protected void preProcessCurrentCopy(CustomScriptDTO customScriptDTO, CustomScript customScript) {
        customScript.getDependencies().size();
        customScript.getFunctions().size();
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QCustomScript)this.$).network(), true);
    }

    @Override
    protected Validator resolveValidator(CustomScriptDTO customScriptDTO) {
        Validator validator = new Validator();
        validator.property((Property)CustomScriptDTO.TYPE, SystemKeys.Scripts.TYPE).required();
        ScriptType scriptType = customScriptDTO.getType();
        if (scriptType != null) {
            final Map map = customScriptDTO.getFunctions();
            for (final ScriptFunction scriptFunction : this.getFunctions(scriptType)) {
                if (!scriptFunction.required()) continue;
                BasePropertyAccess basePropertyAccess = new BasePropertyAccess(){

                    public Object get(Object object) {
                        return map == null ? null : map.get(scriptFunction.name());
                    }

                    public String getPropertyName() {
                        return String.valueOf(CustomScriptDTO.FUNCTIONS) + "." + scriptFunction.name();
                    }
                };
                validator.property((PropertyAccess)basePropertyAccess, scriptFunction.messageKey()).required();
            }
        }
        validator.property((Property)CustomScriptDTO.DEPENDENCIES, SystemKeys.Scripts.DEPENDENCIES).entity(CustomScript.class, (EntityValidation)new BaseEntityValidation<CustomScript>(){

            protected boolean isValid(Object object, Object object2, CustomScript customScript) {
                return customScript.getType() == ScriptType.LIBRARY;
            }
        }).add((PropertyValidation)new CircularDependenciesValidator());
        return validator;
    }

    private void addDependencies(CustomScript customScript, Set<CustomScript> set) {
        if (set.contains(customScript)) {
            return;
        }
        set.add(customScript);
        for (CustomScript customScript2 : customScript.getDependencies()) {
            this.addDependencies(customScript2, set);
        }
    }

    private CompiledScriptCacheKey cacheKey(CustomScript customScript, ScriptFunction scriptFunction) {
        HashSet<Long> hashSet = new HashSet<Long>();
        this.collectDependencies(hashSet, customScript);
        return new CompiledScriptCacheKey(hashSet, scriptFunction);
    }

    private void collectDependencies(Set<Long> set, CustomScript customScript2) {
        if (set.add(customScript2.getId())) {
            customScript2.getDependencies().forEach(customScript -> this.collectDependencies(set, (CustomScript)customScript));
        }
    }

    private Bindings createBindings(String string, Map<String, Object> map) {
        Properties properties = PropertiesHelper.from((String)string);
        AggregatedMap aggregatedMap = new AggregatedMap(this.getDefaultBindings());
        SimpleBindings simpleBindings = new SimpleBindings((Map<String, Object>)aggregatedMap);
        simpleBindings.put("scriptParameters", (Object)properties);
        if (map != null) {
            simpleBindings.putAll((Map<? extends String, ? extends Object>)map);
        }
        return simpleBindings;
    }

    private Pair<CompiledScript, String> doCompile(CustomScript customScript, ScriptFunction scriptFunction) {
        String string;
        Pair<String, String> pair = this.resolveCodeAndParameters(customScript, scriptFunction);
        String string2 = string = pair == null ? null : (String)pair.getFirst();
        if (StringHelper.isBlank((Object)string)) {
            return null;
        }
        try {
            ScriptEngine scriptEngine = this.scriptEngineManager.getEngineByName(SCRIPT_LANGUAGE);
            SimpleScriptContext simpleScriptContext = new SimpleScriptContext();
            String string3 = String.format("%s_%s.groovy", customScript.getName(), scriptFunction.name());
            simpleScriptContext.setAttribute("javax.script.filename", string3, 100);
            scriptEngine.setContext(simpleScriptContext);
            Compilable compilable = (Compilable)((Object)scriptEngine);
            CompiledScript compiledScript = compilable.compile(string);
            String string4 = (String)pair.getSecond();
            return Pair.create((Object)compiledScript, (Object)string4);
        }
        catch (Exception exception) {
            throw new CustomScriptException("Error compiling script " + String.valueOf(customScript) + ", function: " + String.valueOf(scriptFunction), (Throwable)exception);
        }
    }

    private Object doRunScript(String string, String string2, boolean bl, Map<String, Object> map) {
        SessionData sessionData = SessionDataFactory.script((boolean)bl);
        return this.invokerHandler.runAs(sessionData, () -> {
            try {
                ScriptEngine scriptEngine = this.scriptEngineManager.getEngineByName(SCRIPT_LANGUAGE);
                Bindings bindings = this.resolveBindings(string2, map);
                return scriptEngine.eval(string, bindings);
            }
            catch (ScriptException scriptException) {
                Throwable throwable;
                ScriptException scriptException2;
                if (scriptException.getCause() instanceof ScriptException) {
                    scriptException2 = (ScriptException)scriptException.getCause();
                }
                if ((throwable = scriptException2.getCause()) instanceof CyclosException) {
                    throw (CyclosException)throwable;
                }
                throw new CustomScriptException("Error running script", (Throwable)scriptException2);
            }
        });
    }

    private Pair<CompiledScript, String> ensureCompiled(CustomScript customScript, ScriptFunction scriptFunction) {
        CompiledScriptCacheValue compiledScriptCacheValue = (CompiledScriptCacheValue)this.cache.get((Serializable)this.cacheKey(customScript, scriptFunction), () -> {
            Pair<CompiledScript, String> pair = this.doCompile(customScript, scriptFunction);
            CompiledScript compiledScript = pair == null ? null : (CompiledScript)pair.getFirst();
            String string = pair == null ? null : (String)pair.getSecond();
            return new CompiledScriptCacheValue(compiledScript, string);
        });
        return Pair.create((Object)compiledScriptCacheValue.getCompiledScript(), (Object)compiledScriptCacheValue.getParameters());
    }

    private void fillReverseDependencies(Long l, Set<Long> set) {
        CustomScript customScript = (CustomScript)this.rawEntityManagerHandler.getReference(CustomScript.class, l);
        List list = ((DBQuery)this.from().where((Predicate)((QCustomScript)this.$).dependencies.contains((Object)customScript))).list((Expression)((QCustomScript)this.$).id);
        for (Long l2 : list) {
            if (set.contains(l2)) continue;
            set.add(l2);
            this.fillReverseDependencies(l2, set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> getDefaultBindings() {
        if (this._defaultBindings == null) {
            CustomScriptServiceImpl customScriptServiceImpl = this;
            synchronized (customScriptServiceImpl) {
                if (this._defaultBindings == null) {
                    HashMap<String, Object> hashMap = new HashMap<String, Object>(this.scriptHelper.getBeanMap());
                    for (Method method : ScriptHelper.class.getDeclaredMethods()) {
                        ScriptHelperClosure scriptHelperClosure;
                        Object v = hashMap.get(method.getName());
                        if (v instanceof ScriptHelperClosure && (scriptHelperClosure = (ScriptHelperClosure)((Object)v)).getParameterTypes().length <= method.getParameterTypes().length) {
                            v = null;
                        }
                        if (v != null) continue;
                        hashMap.put(method.getName(), (Object)new ScriptHelperClosure(method));
                    }
                    this._defaultBindings = hashMap;
                }
            }
        }
        return this._defaultBindings;
    }

    private ScriptFunction getScriptFunction(ScriptType scriptType, String string) {
        string = StringUtils.removeEnd((String)string, (String)".groovy");
        String string2 = StringHelper.camelizeAndCapitalizeFirst((String)scriptType.name());
        string = StringUtils.remove((String)string, (String)string2);
        if (ScriptType.EXTENSION_POINT == scriptType) {
            string = StringUtils.remove((String)string, (String)"Generic");
        }
        string = StringHelper.transformCase((String)string, (boolean)true, (char)'_');
        return (ScriptFunction)Enum.valueOf(scriptType.getFunctionClass(), string);
    }

    private Map<String, Object> initBindings() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("scriptHelper", this.scriptHelper);
        hashMap.put("entityManager", this.rawEntityManagerHandler.getEntityManager());
        hashMap.put("formatter", this.getFormatter());
        return hashMap;
    }

    @PostConstruct
    private void initialize() {
        this.cache = this.cacheHandler.getCache(CacheType.COMPILED_SCRIPTS);
    }

    private Map<String, String> loadTemplatesScriptTemplates(ScriptType scriptType) {
        List list = ResourceHelper.listResources((String)"/script-templates");
        if (list == null) {
            return Collections.emptyMap();
        }
        return list.stream().map(string -> StringUtils.substringAfterLast((String)string, (String)"/")).filter(string -> !string.endsWith("Bindings.groovy")).filter(string -> string.startsWith(StringHelper.camelizeAndCapitalizeFirst((String)scriptType.name()))).filter(string -> scriptType != ScriptType.EXTENSION_POINT || string.contains("Generic")).map(string -> Pair.create((Object)this.getScriptFunction(scriptType, (String)string).name(), (Object)CustomScriptServiceImpl.readContent("/script-templates/" + string))).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
    }

    private Pair<String, String> resolveCodeAndParameters(boolean bl, Set<CustomScript> set, String string, String string2) {
        CustomScript customScript = new CustomScript();
        customScript.setFunctions(Collections.singletonMap(DefaultScriptFunction.DEFAULT.name(), string));
        customScript.setDependencies(set);
        customScript.setRunAsSystem(bl);
        customScript.setParameters(string2);
        return this.resolveCodeAndParameters(customScript, (ScriptFunction)DefaultScriptFunction.DEFAULT);
    }

    private Collection<CustomScript> resolveDependencies(CustomScript customScript) {
        TreeSet<CustomScript> treeSet = new TreeSet<CustomScript>(new DependencyComparator());
        for (CustomScript customScript2 : CollectionHelper.orEmpty((Set)customScript.getDependencies())) {
            this.addDependencies(customScript2, treeSet);
        }
        return treeSet;
    }

    private <E extends SimpleEntity, Q extends EntityPathBase<E>> Stream<E> usedInEntities(Q q, Function<Q, QCustomScript> function, CustomScript customScript) {
        return ((DBQuery)((DBQuery)this.rawEntityManagerHandler.selectFrom(q).where((Predicate)function.apply(q).eq((Object)customScript))).limit(Long.MAX_VALUE)).stream();
    }

    static {
        ScriptBindingsRegistry.initialize();
        ProfilingEntry.excludeClassFromProfilingContext((String)CustomScriptAccessorImpl.class.getName());
        CODE_SEPARATOR_LINE = StringUtils.repeat((char)'/', (int)78) + "\n";
        PARAMS_SEPARATOR_LINE = StringUtils.repeat((char)'#', (int)78) + "\n";
    }

    private class CustomScriptAccessorImpl
    implements CustomScriptAccessor {
        private CustomScript script;
        private Map<String, Object> bindings;
        private String scriptParameters;

        public CustomScriptAccessorImpl(CustomScript customScript, String string) {
            this.script = customScript;
            this.scriptParameters = string;
            this.bindings = CustomScriptServiceImpl.this.initBindings();
        }

        public CustomScriptAccessor bind(String string, Object object) {
            if (string != null) {
                this.bindings.put(string, object);
            }
            return this;
        }

        public CustomScriptAccessor bindAll(Map<String, ?> map) {
            if (map != null) {
                this.bindings.putAll(map);
            }
            return this;
        }

        public Object run() {
            return this.run((ScriptFunction)DefaultScriptFunction.DEFAULT);
        }

        public <T> T run(Class<T> clazz) {
            return this.run(clazz, (ScriptFunction)DefaultScriptFunction.DEFAULT);
        }

        public <T> T run(Class<T> clazz, ScriptFunction scriptFunction) {
            Object object = this.run(scriptFunction);
            return (T)CustomScriptServiceImpl.this.conversionHandler.convert(clazz, object);
        }

        public Object run(ScriptFunction scriptFunction) {
            CompiledScript compiledScript;
            Pair<CompiledScript, String> pair = CustomScriptServiceImpl.this.ensureCompiled(this.script, scriptFunction);
            CompiledScript compiledScript2 = compiledScript = pair == null ? null : (CompiledScript)pair.getFirst();
            if (compiledScript == null) {
                return null;
            }
            SessionData sessionData = SessionDataFactory.script((boolean)this.script.isRunAsSystem());
            this.bindings.put("sessionData", sessionData);
            InvocationContext invocationContext = InvocationContext.get();
            this.bindings.put("transactionLevel", invocationContext.getTransactionLevel());
            this.bindings.put("transactionStatus", invocationContext.getTransactionStatus());
            StringBuilder stringBuilder = new StringBuilder();
            if (StringHelper.isNotBlank((Object)pair.getSecond())) {
                stringBuilder.append((String)pair.getSecond()).append('\n');
            }
            if (StringHelper.isNotBlank((Object)this.scriptParameters)) {
                stringBuilder.append(this.scriptParameters);
            }
            Bindings bindings = CustomScriptServiceImpl.this.createBindings(stringBuilder.toString(), this.bindings);
            return CustomScriptServiceImpl.this.invokerHandler.runAs(sessionData, () -> {
                try {
                    ProfilingScriptStartEvent profilingScriptStartEvent = (ProfilingScriptStartEvent)RequestContext.addProfilingEvent(startProfilingParams -> new ProfilingScriptStartEvent(this.script.getName(), this.script.getType().toString(), scriptFunction.toString()));
                    Object object = compiledScript.eval(bindings);
                    if (profilingScriptStartEvent != null) {
                        RequestContext.addProfilingEvent(startProfilingParams -> new ProfilingScriptEndEvent(profilingScriptStartEvent));
                    }
                    return object;
                }
                catch (ScriptException scriptException) {
                    ScriptException scriptException2;
                    if (scriptException.getCause() instanceof ScriptException) {
                        scriptException2 = (ScriptException)scriptException.getCause();
                    }
                    if (scriptException2.getCause() instanceof CyclosException) {
                        throw (CyclosException)scriptException2.getCause();
                    }
                    throw new CustomScriptException("Error invoking the custom script " + String.valueOf(this.script) + ", function " + String.valueOf(scriptFunction), (Throwable)scriptException2);
                }
            });
        }

        public <T> List<T> runForList(Class<T> clazz) {
            return this.runForList(clazz, (ScriptFunction)DefaultScriptFunction.DEFAULT);
        }

        public <T> List<T> runForList(Class<T> clazz, ScriptFunction scriptFunction) {
            Object object = this.run(scriptFunction);
            Iterator iterator = IteratorUtils.getIterator((Object)object);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                arrayList.add(CustomScriptServiceImpl.this.conversionHandler.convert(clazz, e));
            }
            return arrayList;
        }
    }

    private class CircularDependenciesValidator
    extends BasePropertyValidation {
        private CircularDependenciesValidator() {
            super(SystemKeys.Scripts.ERROR_CIRCULAR_DEPENDENCIES);
        }

        protected boolean isValid(Object object, Object object2, Object object3) {
            CustomScriptDTO customScriptDTO = (CustomScriptDTO)object;
            if (customScriptDTO.isTransient() || customScriptDTO.getType() != ScriptType.LIBRARY) {
                return true;
            }
            CustomScript customScript = (CustomScript)CustomScriptServiceImpl.this.find(customScriptDTO.getId());
            Set set = this.getConversionHandler().convertSet(CustomScript.class, (Iterable)((Collection)object3));
            return this.visit(new HashSet<CustomScript>(), customScript, set);
        }

        private boolean visit(Set<CustomScript> set, CustomScript customScript, Set<CustomScript> set2) {
            if (!set.add(customScript)) {
                return false;
            }
            for (CustomScript customScript2 : set2) {
                if (this.visit(set, customScript2, customScript2.getDependencies())) continue;
                return false;
            }
            return true;
        }
    }

    private class ScriptHelperClosure
    extends Closure<Object> {
        private static final long serialVersionUID = 1L;
        private final Method method;

        public ScriptHelperClosure(Method method) {
            super((Object)CustomScriptServiceImpl.this.scriptHelper);
            this.method = method;
            this.parameterTypes = method.getParameterTypes();
            this.maximumNumberOfParameters = method.getParameterTypes().length;
        }

        public Object doCall(Object[] objectArray) {
            if (objectArray == null) {
                objectArray = ArrayUtils.EMPTY_OBJECT_ARRAY;
            }
            try {
                int n = this.method.getParameterTypes().length;
                int n2 = objectArray.length;
                if (n2 < n) {
                    Object[] objectArray2 = new Object[n];
                    System.arraycopy(objectArray, 0, objectArray2, 0, n2);
                    objectArray = objectArray2;
                } else if (n2 > n) {
                    throw new IllegalArgumentException("Error invoking ScriptHelper." + this.method.getName() + ": Expecting " + n + " arguments, got " + n2);
                }
                return this.method.invoke((Object)CustomScriptServiceImpl.this.scriptHelper, objectArray);
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }
    }

    private static class DependencyComparator
    implements Comparator<CustomScript> {
        private DependencyComparator() {
        }

        @Override
        public int compare(CustomScript customScript, CustomScript customScript2) {
            if (customScript.getDependencies().contains(customScript2)) {
                return 1;
            }
            if (customScript2.getDependencies().contains(customScript)) {
                return -1;
            }
            return customScript.compareTo((NamedEntity)customScript2);
        }
    }
}

