/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.system.CustomRecurringTask;
import org.cyclos.entities.system.CustomRecurringTaskLog;
import org.cyclos.entities.system.CustomScript;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.system.QCustomRecurringTask;
import org.cyclos.entities.system.QCustomRecurringTaskLog;
import org.cyclos.entities.system.QNetwork;
import org.cyclos.entities.utils.DatePeriod;
import org.cyclos.entities.utils.TimeInterval;
import org.cyclos.impl.ApplicationInitializationListener;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.CustomRecurringTaskServiceLocal;
import org.cyclos.impl.system.CustomScriptServiceLocal;
import org.cyclos.impl.system.ProfilingEntry;
import org.cyclos.impl.system.RunScheduledRecurringTask;
import org.cyclos.impl.utils.persistence.CustomProjection;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.impl.utils.tasks.RecurringTaskHandler;
import org.cyclos.impl.utils.validation.EntityValidation;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.impl.utils.validation.validations.BaseEntityValidation;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.Property;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.RetryException;
import org.cyclos.model.StaleEntityException;
import org.cyclos.model.ValidationException;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.scheduledtasks.CustomRecurringTaskDTO;
import org.cyclos.model.system.scheduledtasks.CustomRecurringTaskData;
import org.cyclos.model.system.scheduledtasks.CustomRecurringTaskDetailedVO;
import org.cyclos.model.system.scheduledtasks.CustomRecurringTaskLogQuery;
import org.cyclos.model.system.scheduledtasks.CustomRecurringTaskLogStatus;
import org.cyclos.model.system.scheduledtasks.CustomRecurringTaskLogVO;
import org.cyclos.model.system.scheduledtasks.CustomRecurringTaskVO;
import org.cyclos.model.system.scripts.CustomScriptVO;
import org.cyclos.model.system.scripts.ScriptType;
import org.cyclos.model.utils.TimeField;
import org.cyclos.model.utils.TimeIntervalDTO;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.Page;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionCallback;

@Service
public class CustomRecurringTaskServiceImpl
extends CRUDServiceImpl<CustomRecurringTask, QCustomRecurringTask, CustomRecurringTaskDTO, CustomRecurringTaskData, Void>
implements CustomRecurringTaskServiceLocal,
ApplicationInitializationListener {
    private static QCustomRecurringTaskLog l = QCustomRecurringTaskLog.customRecurringTaskLog;
    @Autowired
    private CustomScriptServiceLocal customScriptService;
    @Autowired
    private InvokerHandler invokerHandler;
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    private RecurringTaskHandler recurringTaskHandler;

    public CustomRecurringTaskServiceImpl() {
        super(CustomRecurringTask.class, QCustomRecurringTask.customRecurringTask, CustomRecurringTaskDTO.class);
    }

    public Date getNextExecution(CustomRecurringTask customRecurringTask) {
        boolean bl;
        if (!customRecurringTask.isEnabled()) {
            return null;
        }
        Date date = (Date)((DBQuery)((DBQuery)this.from(new EntityPath[]{l}).where((Predicate)l.task().eq((Object)customRecurringTask))).orderBy(CustomRecurringTaskServiceImpl.l.date.desc())).singleResult((Expression)CustomRecurringTaskServiceImpl.l.date);
        boolean bl2 = bl = date == null;
        if (bl) {
            date = new Date();
        }
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor(customRecurringTask.getNetwork());
        TimeZone timeZone = configurationAccessor.getTimeZone();
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTime(date);
        TimeInterval timeInterval = customRecurringTask.getRecurrence();
        if (timeInterval.getField() != TimeField.MINUTES) {
            calendar.set(12, 0);
        }
        calendar.set(13, 0);
        calendar.set(14, 0);
        switch (timeInterval.getField()) {
            case MINUTES: {
                int n = bl ? 1 : timeInterval.getAmount();
                calendar.add(12, n);
                break;
            }
            case HOURS: {
                int n = bl ? 1 : timeInterval.getAmount();
                calendar.add(11, n);
                break;
            }
            case DAYS: {
                calendar.set(11, customRecurringTask.getHour());
                if (!calendar.getTime().before(new Date())) break;
                if (bl) {
                    calendar.add(5, 1);
                    break;
                }
                calendar.add(5, timeInterval.getAmount());
                break;
            }
            case WEEKS: {
                calendar.set(11, customRecurringTask.getHour());
                int n = customRecurringTask.getDayWeek().ordinal() + 1;
                while (calendar.get(7) != n) {
                    calendar.add(5, 1);
                }
                calendar.add(5, timeInterval.getAmount() * 7);
                break;
            }
            case MONTHS: {
                calendar.set(11, customRecurringTask.getHour());
                calendar.add(2, timeInterval.getAmount());
                calendar.set(5, customRecurringTask.getDayMonth());
                break;
            }
            default: {
                throw new IllegalArgumentException("Tasks accept recurrence between minutes and months");
            }
        }
        return calendar.getTime();
    }

    public CloseableIterator<CustomRecurringTask> iterateForRunningNow() {
        QCustomRecurringTaskLog qCustomRecurringTaskLog = new QCustomRecurringTaskLog("l1");
        QNetwork qNetwork = QNetwork.network;
        return ((DBQuery)((DBQuery)((DBQuery)((DBQuery)this.from(this.$).leftJoin((EntityPath)((QCustomRecurringTask)this.$).network(), (Path)qNetwork)).leftJoin((EntityPath)l)).on((Predicate)l.task().eq((Expression)this.$).and((Predicate)CustomRecurringTaskServiceImpl.l.date.eq((Expression)((DBQuery)this.subQuery(new EntityPath[]{qCustomRecurringTaskLog}).where((Predicate)qCustomRecurringTaskLog.task().eq((Expression)l.task()))).select((Expression)qCustomRecurringTaskLog.date.max()))))).where(new Predicate[]{qNetwork.isNull().or((Predicate)qNetwork.enabled.isTrue()), ((QCustomRecurringTask)this.$).enabled.isTrue(), ((QCustomRecurringTask)this.$).nextExecution.past(), CustomRecurringTaskServiceImpl.l.id.isNull().or((Predicate)CustomRecurringTaskServiceImpl.l.status.ne((Object)CustomRecurringTaskLogStatus.RUNNING))})).iterate((Expression)this.$);
    }

    public List<CustomRecurringTaskDetailedVO> list() throws FrameworkException {
        QCustomRecurringTaskLog qCustomRecurringTaskLog = new QCustomRecurringTaskLog("l1");
        return ((DBQuery)((DBQuery)((DBQuery)this.from().leftJoin((EntityPath)l)).on(new Predicate[]{l.task().eq((Expression)this.$), CustomRecurringTaskServiceImpl.l.date.eq((Expression)((DBQuery)this.subQuery(new EntityPath[]{qCustomRecurringTaskLog}).where((Predicate)qCustomRecurringTaskLog.task().eq((Expression)this.$))).select((Expression)qCustomRecurringTaskLog.date.max()))})).orderBy(((QCustomRecurringTask)this.$).name.asc())).list((Expression)new VOProjection());
    }

    @Override
    public CustomRecurringTask newEntity(Void void_) {
        CustomRecurringTask customRecurringTask = new CustomRecurringTask();
        customRecurringTask.setEnabled(true);
        customRecurringTask.setRecurrence(TimeInterval.ONE_DAY);
        customRecurringTask.setHour(Integer.valueOf(0));
        return customRecurringTask;
    }

    public void onApplicationInitialization() {
        List list = ((DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{l}).where((Predicate)CustomRecurringTaskServiceImpl.l.status.eq((Object)CustomRecurringTaskLogStatus.RUNNING))).list((Expression)l);
        for (CustomRecurringTaskLog customRecurringTaskLog : list) {
            this.getLogger().info("Custom scheduled task {} was running when the server was shut down. Marking the execution log as error.", (Object)customRecurringTaskLog.getTask().getName());
            this.invokerHandler.runAs(SessionDataFactory.system((Network)customRecurringTaskLog.getNetwork()), () -> {
                customRecurringTaskLog.setStatus(CustomRecurringTaskLogStatus.ERROR);
                customRecurringTaskLog.setMessage(this.message(SystemKeys.ScheduledTasks.ERROR_INTERRUPTED_ON_SHUTDOWN, new Object[0]));
                return null;
            });
        }
    }

    public boolean run(Long l, ProfilingEntry profilingEntry) {
        TaskExecutionData taskExecutionData;
        block7: {
            taskExecutionData = this.createInitialLog(l, profilingEntry);
            if (taskExecutionData == null) {
                return false;
            }
            try {
                this.doRun(taskExecutionData, profilingEntry);
            }
            catch (Exception exception) {
                if (taskExecutionData.error != null) break block7;
                taskExecutionData.error = exception;
            }
        }
        if (taskExecutionData.error == null) {
            if (profilingEntry != null) {
                profilingEntry.setResult(this.profilingResult(true, taskExecutionData.logMessage));
            }
            return true;
        }
        if (profilingEntry != null) {
            profilingEntry.setErrorTrace(ExceptionUtils.getStackTrace((Throwable)taskExecutionData.error));
        }
        this.markLogAsError(taskExecutionData);
        if (taskExecutionData.error instanceof RuntimeException) {
            throw (RuntimeException)taskExecutionData.error;
        }
        throw new RuntimeException(taskExecutionData.error);
    }

    public void runNow(CustomRecurringTaskVO customRecurringTaskVO) throws FrameworkException {
        CustomRecurringTask customRecurringTask = (CustomRecurringTask)this.conversionHandler.convert(CustomRecurringTask.class, (Object)customRecurringTaskVO);
        if (customRecurringTask == null) {
            throw new EntityNotFoundException(CustomRecurringTask.class);
        }
        if (!customRecurringTask.isEnabled()) {
            throw new IllegalActionException("Custom recurring task is disabled: " + String.valueOf(customRecurringTask));
        }
        CustomRecurringTaskLog customRecurringTaskLog = this.getLastLog(customRecurringTask);
        if (customRecurringTaskLog != null && customRecurringTaskLog.getStatus() == CustomRecurringTaskLogStatus.RUNNING) {
            throw new ValidationException(this.message(SystemKeys.ScheduledTasks.ERROR_ALREADY_RUNNING, new Object[0]));
        }
        customRecurringTask.setNextExecution(new Date());
        this.recurringTaskHandler.scheduleAwake(RunScheduledRecurringTask.class);
    }

    public Page<CustomRecurringTaskLogVO> searchLogs(CustomRecurringTaskLogQuery customRecurringTaskLogQuery) throws FrameworkException {
        Long l = customRecurringTaskLogQuery.getTaskId();
        if (l == null) {
            throw new ValidationException();
        }
        DBQuery dBQuery = (DBQuery)this.from(new EntityPath[]{CustomRecurringTaskServiceImpl.l}).where((Predicate)CustomRecurringTaskServiceImpl.l.task().id.eq((Object)l));
        if (CollectionHelper.isNotEmpty((Iterable)customRecurringTaskLogQuery.getStatus())) {
            dBQuery.where((Predicate)CustomRecurringTaskServiceImpl.l.status.in((Collection)customRecurringTaskLogQuery.getStatus()));
        }
        if (customRecurringTaskLogQuery.getDate() != null) {
            DatePeriod datePeriod = (DatePeriod)this.conversionHandler.convert(DatePeriod.class, (Object)customRecurringTaskLogQuery.getDate());
            dBQuery.where(CustomRecurringTaskServiceImpl.l.date.period(datePeriod));
        }
        dBQuery.orderBy(CustomRecurringTaskServiceImpl.l.date.desc());
        return dBQuery.page(CustomRecurringTaskLogVO.class, (QueryParameters)customRecurringTaskLogQuery, (Expression)CustomRecurringTaskServiceImpl.l);
    }

    @Override
    protected CustomRecurringTaskData getData(CustomRecurringTask customRecurringTask) {
        CustomRecurringTaskData customRecurringTaskData = new CustomRecurringTaskData();
        customRecurringTaskData.setDto((EntityDTO)((CustomRecurringTaskDTO)this.toDTO(customRecurringTask)));
        customRecurringTaskData.setScripts(this.conversionHandler.convertList(CustomScriptVO.class, (Iterable)this.customScriptService.listByType(ScriptType.SCHEDULED_TASK)));
        customRecurringTaskData.setNextExecution(this.conversionHandler.toDateTime(this.getNextExecution(customRecurringTask)));
        return customRecurringTaskData;
    }

    @Override
    protected Object onBeforeSave(CustomRecurringTask customRecurringTask, CustomRecurringTask customRecurringTask2) {
        Date date = this.getNextExecution(customRecurringTask);
        customRecurringTask.setNextExecution(date);
        switch (customRecurringTask.getRecurrence().getField()) {
            case MINUTES: 
            case HOURS: {
                customRecurringTask.setHour(null);
                customRecurringTask.setDayMonth(null);
                customRecurringTask.setDayWeek(null);
                break;
            }
            case DAYS: {
                customRecurringTask.setDayMonth(null);
                customRecurringTask.setDayWeek(null);
                break;
            }
            case WEEKS: {
                customRecurringTask.setDayMonth(null);
                break;
            }
            case MONTHS: {
                customRecurringTask.setDayWeek(null);
                break;
            }
            default: {
                throw new ValidationException();
            }
        }
        return null;
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QCustomRecurringTask)this.$).network());
        networkPathRegistry.register(l.task().network());
    }

    @Override
    protected Validator resolveValidator(CustomRecurringTaskDTO customRecurringTaskDTO) {
        TimeField timeField;
        Validator validator = new Validator();
        validator.property((Property)CustomRecurringTaskDTO.SCRIPT, SystemKeys.ScheduledTasks.SCRIPT).required().entity(CustomScript.class, (EntityValidation)new BaseEntityValidation<CustomScript>(){

            protected boolean isValid(Object object, Object object2, CustomScript customScript) {
                return customScript.getType() == ScriptType.SCHEDULED_TASK;
            }
        });
        org.cyclos.impl.utils.validation.Property property = validator.property((Property)CustomRecurringTaskDTO.RECURRENCE, SystemKeys.ScheduledTasks.RECURRENCE).required().positiveIntegerNonZero().timeInterval();
        TimeIntervalDTO timeIntervalDTO = customRecurringTaskDTO.getRecurrence();
        TimeField timeField2 = timeField = timeIntervalDTO == null ? null : timeIntervalDTO.getField();
        if (timeField != null) {
            switch (timeField) {
                case MINUTES: 
                case HOURS: 
                case DAYS: {
                    break;
                }
                case WEEKS: {
                    validator.property((Property)CustomRecurringTaskDTO.DAY_WEEK, SystemKeys.ScheduledTasks.DAY).required();
                    break;
                }
                case MONTHS: {
                    validator.property((Property)CustomRecurringTaskDTO.DAY_MONTH, SystemKeys.ScheduledTasks.DAY).required().between((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(28));
                    break;
                }
                default: {
                    property.invalid();
                }
            }
            if (timeField != TimeField.HOURS) {
                validator.property((Property)CustomRecurringTaskDTO.HOUR, SystemKeys.ScheduledTasks.HOUR).required().between((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(23));
            }
        }
        return validator;
    }

    private TaskExecutionData createInitialLog(Long l, ProfilingEntry profilingEntry) {
        return (TaskExecutionData)this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_WRITE, transactionStatus -> {
            Date date = new Date();
            CustomRecurringTask customRecurringTask = (CustomRecurringTask)this.rawEntityManagerHandler.find(CustomRecurringTask.class, l);
            if (profilingEntry != null) {
                profilingEntry.setName(customRecurringTask.getName());
            }
            if (!customRecurringTask.isEnabled() || customRecurringTask.getNextExecution().after(date)) {
                if (profilingEntry != null) {
                    profilingEntry.setResult(this.profilingResult(false, null));
                }
                return null;
            }
            CustomRecurringTaskLog customRecurringTaskLog = this.getLastLog(customRecurringTask);
            if (customRecurringTaskLog != null && customRecurringTaskLog.getStatus() == CustomRecurringTaskLogStatus.RUNNING) {
                customRecurringTaskLog.setDate(date);
            } else {
                customRecurringTaskLog = new CustomRecurringTaskLog();
                customRecurringTaskLog.setStatus(CustomRecurringTaskLogStatus.RUNNING);
                customRecurringTaskLog.setTask(customRecurringTask);
                customRecurringTaskLog.setDate(date);
                this.entityManagerHandler.persist((IEntity)customRecurringTaskLog);
            }
            try {
                Date date2 = this.getNextExecution(customRecurringTask);
                customRecurringTask.setNextExecution(date2);
                this.rawEntityManagerHandler.flush();
            }
            catch (StaleEntityException staleEntityException) {
                throw new RetryException();
            }
            return new TaskExecutionData(SimpleEntity.id((SimpleEntity)customRecurringTask.getNetwork()), customRecurringTaskLog.getId());
        });
    }

    private String doRun(CustomRecurringTaskLog customRecurringTaskLog, TaskExecutionData taskExecutionData) {
        CustomRecurringTask customRecurringTask = customRecurringTaskLog.getTask();
        return (String)this.customScriptService.newAccessor(customRecurringTask.getScript(), customRecurringTask.getScriptParameters()).bind("task", (Object)customRecurringTask).bind("scheduledTask", (Object)customRecurringTask).bind("log", (Object)customRecurringTaskLog).run(String.class);
    }

    private void doRun(TaskExecutionData taskExecutionData, ProfilingEntry profilingEntry) {
        this.runWithContext(taskExecutionData, transactionStatus -> {
            CustomRecurringTaskLog customRecurringTaskLog = this.find(CustomRecurringTaskLog.class, taskExecutionData.logId);
            if (profilingEntry != null) {
                HashMap<String, Comparable<Long>> hashMap = new HashMap<String, Comparable<Long>>();
                hashMap.put("logId", customRecurringTaskLog.getId());
                hashMap.put("date", customRecurringTaskLog.getDate());
                profilingEntry.setParameters(hashMap);
            }
            long l = System.currentTimeMillis();
            try {
                taskExecutionData.logMessage = this.doRun(customRecurringTaskLog, taskExecutionData);
                taskExecutionData.timeTaken = (int)(System.currentTimeMillis() - l);
                customRecurringTaskLog = this.find(CustomRecurringTaskLog.class, taskExecutionData.logId);
                customRecurringTaskLog.setStatus(CustomRecurringTaskLogStatus.SUCCESS);
                customRecurringTaskLog.setMessage(taskExecutionData.logMessage);
                customRecurringTaskLog.setTimeTaken(taskExecutionData.timeTaken);
                this.rawEntityManagerHandler.flush();
            }
            catch (Throwable throwable) {
                transactionStatus.setRollbackOnly();
                taskExecutionData.error = throwable;
            }
            return null;
        });
    }

    private CustomRecurringTaskLog getLastLog(CustomRecurringTask customRecurringTask) {
        return (CustomRecurringTaskLog)((DBQuery)((DBQuery)this.from(new EntityPath[]{l}).where((Predicate)l.task().eq((Object)customRecurringTask))).orderBy(CustomRecurringTaskServiceImpl.l.date.desc())).singleResult((Expression)l);
    }

    private void markLogAsError(TaskExecutionData taskExecutionData) {
        if (taskExecutionData.error != null) {
            this.runWithContext(taskExecutionData, transactionStatus -> {
                CustomRecurringTaskLog customRecurringTaskLog = this.find(CustomRecurringTaskLog.class, taskExecutionData.logId);
                customRecurringTaskLog.setStatus(CustomRecurringTaskLogStatus.ERROR);
                customRecurringTaskLog.setErrorStackTrace(ExceptionUtils.getStackTrace((Throwable)taskExecutionData.error));
                return null;
            });
        }
    }

    private Map<String, Object> profilingResult(boolean bl, String string) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("executed", bl);
        if (string != null) {
            hashMap.put("message", string);
        }
        return hashMap;
    }

    private <T> T runWithContext(TaskExecutionData taskExecutionData, TransactionCallback<T> transactionCallback) {
        return (T)this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_WRITE, transactionStatus -> {
            Network network = (Network)this.rawEntityManagerHandler.find(Network.class, taskExecutionData.networkId);
            return this.invokerHandler.runAs(SessionDataFactory.system((Network)network), () -> transactionCallback.doInTransaction(transactionStatus));
        });
    }

    private class VOProjection
    extends CustomProjection<CustomRecurringTaskDetailedVO> {
        private static final long serialVersionUID = 1L;

        private VOProjection() {
            super(CustomRecurringTaskDetailedVO.class);
            this.add(new Expression[]{CustomRecurringTaskServiceImpl.this.$, l});
        }

        protected CustomRecurringTaskDetailedVO instantiate() {
            CustomRecurringTask customRecurringTask = (CustomRecurringTask)this.get((Expression)CustomRecurringTaskServiceImpl.this.$);
            CustomRecurringTaskLog customRecurringTaskLog = (CustomRecurringTaskLog)this.get((Expression)l);
            CustomRecurringTaskDetailedVO customRecurringTaskDetailedVO = (CustomRecurringTaskDetailedVO)CustomRecurringTaskServiceImpl.this.conversionHandler.convert(CustomRecurringTaskDetailedVO.class, (Object)customRecurringTask);
            customRecurringTaskDetailedVO.setLastExecution((CustomRecurringTaskLogVO)CustomRecurringTaskServiceImpl.this.conversionHandler.convert(CustomRecurringTaskLogVO.class, (Object)customRecurringTaskLog));
            return customRecurringTaskDetailedVO;
        }
    }

    private static class TaskExecutionData {
        private Long networkId;
        private Long logId;
        private String logMessage;
        private Integer timeTaken;
        private Throwable error;

        public TaskExecutionData(Long l, Long l2) {
            this.networkId = l;
            this.logId = l2;
        }
    }
}

