/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.BeanMap;
import org.cyclos.entities.NamedEntity;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.access.Channel;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.Transfer;
import org.cyclos.entities.contentmanagement.MenuEntry;
import org.cyclos.entities.contentmanagement.MenuGroup;
import org.cyclos.entities.contentmanagement.MenuItem;
import org.cyclos.entities.marketplace.BasicAd;
import org.cyclos.entities.system.Configuration;
import org.cyclos.entities.system.CustomField;
import org.cyclos.entities.system.CustomOperation;
import org.cyclos.entities.system.CustomOperationAction;
import org.cyclos.entities.system.CustomOperationActionParameter;
import org.cyclos.entities.system.CustomOperationField;
import org.cyclos.entities.system.CustomScript;
import org.cyclos.entities.system.EntityWithParameterStorageContext;
import org.cyclos.entities.system.ExportFormat;
import org.cyclos.entities.system.ExternalRedirectExecution;
import org.cyclos.entities.system.QCustomOperation;
import org.cyclos.entities.system.QCustomOperationAction;
import org.cyclos.entities.system.QExternalRedirectExecution;
import org.cyclos.entities.users.BaseContactInfo;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.BulkActionUser;
import org.cyclos.entities.users.Contact;
import org.cyclos.entities.users.ContactInfo;
import org.cyclos.entities.users.CustomOperationBulkAction;
import org.cyclos.entities.users.QAdminProduct;
import org.cyclos.entities.users.QMemberProduct;
import org.cyclos.entities.users.QMemberProductCustomOperation;
import org.cyclos.entities.users.QProduct;
import org.cyclos.entities.users.QProductMyRecordType;
import org.cyclos.entities.users.QProductUserRecordType;
import org.cyclos.entities.users.QRecordType;
import org.cyclos.entities.users.QUserManagementProduct;
import org.cyclos.entities.users.Record;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserPrincipal;
import org.cyclos.entities.users.UserRecord;
import org.cyclos.entities.users.UserRecordType;
import org.cyclos.entities.utils.EntityBackedParameterStorage;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.ChannelServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.banking.TransferTypeServiceLocal;
import org.cyclos.impl.contentmanagement.MenuEntryServiceLocal;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.CustomFieldValueHandler;
import org.cyclos.impl.system.CustomOperationActionServiceLocal;
import org.cyclos.impl.system.CustomOperationServiceLocal;
import org.cyclos.impl.system.CustomScriptServiceLocal;
import org.cyclos.impl.system.ExportFormatServiceLocal;
import org.cyclos.impl.users.BulkActionUserResult;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.impl.users.RecordTypeServiceLocal;
import org.cyclos.impl.utils.BeanAccessor;
import org.cyclos.impl.utils.IdMaskJacksonConfiguration;
import org.cyclos.impl.utils.LinkGeneratorHandler;
import org.cyclos.impl.utils.SerializablePredicate;
import org.cyclos.impl.utils.cache.CacheHandler;
import org.cyclos.impl.utils.cache.CacheType;
import org.cyclos.impl.utils.formatting.FormatterImpl;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.EntityValidation;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.impl.utils.validation.validations.BaseEntityValidation;
import org.cyclos.impl.utils.validation.validations.GeneralValidations;
import org.cyclos.impl.utils.validation.validations.UrlValidation;
import org.cyclos.model.Bean;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.EntityVO;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.IInternalNamedEntity;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.Property;
import org.cyclos.model.access.CredentialUsage;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.RequestData;
import org.cyclos.model.access.channels.ChannelVO;
import org.cyclos.model.access.passwords.CredentialInputDTO;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.accounts.SystemAccountOwner;
import org.cyclos.model.banking.currencies.CurrencyVO;
import org.cyclos.model.banking.transfers.TransferVO;
import org.cyclos.model.banking.transfertypes.TransferTypeQuery;
import org.cyclos.model.contentmanagement.contentitems.ContentItemVisibility;
import org.cyclos.model.contentmanagement.contentitems.MenuItemType;
import org.cyclos.model.contentmanagement.contentitems.MenuItemVO;
import org.cyclos.model.marketplace.advertisements.AdType;
import org.cyclos.model.marketplace.advertisements.BasicAdVO;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.exportformats.ExportFormatContext;
import org.cyclos.model.system.exportformats.ExportFormatVO;
import org.cyclos.model.system.fields.CustomFieldDetailedVO;
import org.cyclos.model.system.fields.CustomFieldVO;
import org.cyclos.model.system.fields.CustomFieldValueDTO;
import org.cyclos.model.system.operations.CustomOperationDTO;
import org.cyclos.model.system.operations.CustomOperationData;
import org.cyclos.model.system.operations.CustomOperationResultPageRowAction;
import org.cyclos.model.system.operations.CustomOperationResultType;
import org.cyclos.model.system.operations.CustomOperationResultVO;
import org.cyclos.model.system.operations.CustomOperationScope;
import org.cyclos.model.system.operations.CustomOperationShowForm;
import org.cyclos.model.system.operations.CustomOperationVO;
import org.cyclos.model.system.operations.PageResultColumn;
import org.cyclos.model.system.operations.PageResultColumnType;
import org.cyclos.model.system.operations.RunAdCustomOperationDTO;
import org.cyclos.model.system.operations.RunAdCustomOperationData;
import org.cyclos.model.system.operations.RunAdCustomOperationDataParams;
import org.cyclos.model.system.operations.RunContactCustomOperationDTO;
import org.cyclos.model.system.operations.RunContactCustomOperationData;
import org.cyclos.model.system.operations.RunContactCustomOperationDataParams;
import org.cyclos.model.system.operations.RunContactInfoCustomOperationDTO;
import org.cyclos.model.system.operations.RunContactInfoCustomOperationData;
import org.cyclos.model.system.operations.RunContactInfoCustomOperationDataParams;
import org.cyclos.model.system.operations.RunCustomOperationAction;
import org.cyclos.model.system.operations.RunCustomOperationConfirmationField;
import org.cyclos.model.system.operations.RunCustomOperationDTO;
import org.cyclos.model.system.operations.RunCustomOperationData;
import org.cyclos.model.system.operations.RunCustomOperationDataParams;
import org.cyclos.model.system.operations.RunCustomOperationResult;
import org.cyclos.model.system.operations.RunExternalRedirectCallbackParams;
import org.cyclos.model.system.operations.RunMenuItemCustomOperationDTO;
import org.cyclos.model.system.operations.RunMenuItemCustomOperationData;
import org.cyclos.model.system.operations.RunMenuItemCustomOperationDataParams;
import org.cyclos.model.system.operations.RunRecordCustomOperationDTO;
import org.cyclos.model.system.operations.RunRecordCustomOperationData;
import org.cyclos.model.system.operations.RunRecordCustomOperationDataParams;
import org.cyclos.model.system.operations.RunTransferCustomOperationDTO;
import org.cyclos.model.system.operations.RunTransferCustomOperationData;
import org.cyclos.model.system.operations.RunTransferCustomOperationDataParams;
import org.cyclos.model.system.operations.RunUserCustomOperationDTO;
import org.cyclos.model.system.operations.RunUserCustomOperationData;
import org.cyclos.model.system.operations.RunUserCustomOperationDataParams;
import org.cyclos.model.system.operations.RunnableCustomOperationVO;
import org.cyclos.model.system.scripts.CustomOperationScriptFunction;
import org.cyclos.model.system.scripts.CustomScriptException;
import org.cyclos.model.system.scripts.CustomScriptVO;
import org.cyclos.model.system.scripts.LoadValuesScriptFunction;
import org.cyclos.model.system.scripts.ScriptFunction;
import org.cyclos.model.system.scripts.ScriptType;
import org.cyclos.model.users.bulkactions.BulkActionUserStatus;
import org.cyclos.model.users.contactinfos.ContactInfoDetailedVO;
import org.cyclos.model.users.contactinfos.ContactInfoVO;
import org.cyclos.model.users.contacts.ContactDetailedVO;
import org.cyclos.model.users.contacts.ContactVO;
import org.cyclos.model.users.records.RecordVO;
import org.cyclos.model.users.recordtypes.RecordTypeNature;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.AdminMainMenu;
import org.cyclos.model.utils.CurrencyAmountDTO;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.model.utils.FrontendMenu;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.model.utils.NotificationLevel;
import org.cyclos.model.utils.ProfileManagementSection;
import org.cyclos.model.utils.RequestInfo;
import org.cyclos.model.utils.UserMainMenu;
import org.cyclos.server.utils.CloseableIteratorAdapter;
import org.cyclos.server.utils.CloseableIteratorHelper;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.server.utils.DataIterator;
import org.cyclos.server.utils.PropertyHelper;
import org.cyclos.server.utils.SecureRandomHelper;
import org.cyclos.server.utils.jackson.JacksonConfiguration;
import org.cyclos.utils.BigDecimalHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.DateTime;
import org.cyclos.utils.MapParameterStorage;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Page;
import org.cyclos.utils.Pair;
import org.cyclos.utils.ParameterStorage;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.coercion.CoercionHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomOperationServiceImpl
extends CRUDServiceImpl<CustomOperation, QCustomOperation, CustomOperationDTO, CustomOperationData, Void>
implements CustomOperationServiceLocal {
    private static final Map<CustomOperationScope, ScopeMetadata> SCOPE_META = new EnumMap<CustomOperationScope, ScopeMetadata>(CustomOperationScope.class);
    private static final QExternalRedirectExecution ere;
    private static final QMemberProductCustomOperation mpco;
    @Autowired
    private CustomScriptServiceLocal customScriptService;
    @Autowired
    private RecordTypeServiceLocal recordTypeService;
    @Autowired
    private TransferTypeServiceLocal transferTypeService;
    @Autowired
    private CustomFieldValueHandler customFieldValueHandler;
    @Autowired
    private LinkGeneratorHandler linkGeneratorHandler;
    @Autowired
    private CacheHandler cacheHandler;
    @Autowired
    private IdMaskJacksonConfiguration idMaskJacksonConfiguration;
    @Autowired
    private JacksonConfiguration jacksonConfiguration;
    @Autowired
    private InvokerHandler invokerHandler;
    @Autowired
    private CyclosProperties cyclosProperties;
    @Autowired
    private MenuEntryServiceLocal menuEntryService;
    @Autowired
    private ChannelServiceLocal channelService;
    @Autowired
    private CustomOperationActionServiceLocal customOperationActionService;
    @Autowired
    private ExportFormatServiceLocal exportFormatService;

    private static void registerScopeMeta(String string, CustomOperationScope customOperationScope, Class<? extends SimpleEntity> clazz, Class<? extends EntityVO> clazz2, Property<?, ?> property, Property<?, ?> property2, Property<?, ?> property3) {
        ScopeMetadata scopeMetadata = new ScopeMetadata(string, clazz, clazz2, property.getBeanType(), property, property2, property3);
        SCOPE_META.put(customOperationScope, scopeMetadata);
    }

    public CustomOperationServiceImpl() {
        super(CustomOperation.class, QCustomOperation.customOperation, CustomOperationDTO.class);
    }

    public CredentialInputDTO getConfirmationPasswordInputForRun(RunCustomOperationDataParams runCustomOperationDataParams) {
        CustomOperation customOperation = this.resolveCustomOperation(this.getRelatedEntity(runCustomOperationDataParams), runCustomOperationDataParams.getCustomOperation());
        return this.getCredentialInputForRun(customOperation);
    }

    public SimpleEntity getRelatedEntity(RunCustomOperationDataParams runCustomOperationDataParams) {
        CustomOperationScope customOperationScope = runCustomOperationDataParams instanceof RunMenuItemCustomOperationDataParams ? CustomOperationScope.MENU : null;
        return this.doGetRelatedEntity((Bean)runCustomOperationDataParams, scopeMetadata -> scopeMetadata.runDataParamsProperty, customOperationScope);
    }

    public SimpleEntity getRelatedEntity(RunCustomOperationDTO runCustomOperationDTO) {
        CustomOperationScope customOperationScope = runCustomOperationDTO instanceof RunMenuItemCustomOperationDTO ? CustomOperationScope.MENU : null;
        return this.doGetRelatedEntity((Bean)runCustomOperationDTO, scopeMetadata -> scopeMetadata.runDataProperty, customOperationScope);
    }

    public RunCustomOperationData getRunData(RunCustomOperationDataParams runCustomOperationDataParams) {
        Object object;
        SimpleEntity simpleEntity = this.getRelatedEntity(runCustomOperationDataParams);
        CustomOperation customOperation = this.resolveCustomOperation(simpleEntity, runCustomOperationDataParams.getCustomOperation());
        CustomOperationScope customOperationScope = customOperation.getScope();
        ScopeMetadata scopeMetadata = SCOPE_META.get(customOperationScope);
        this.validateRun(customOperation, simpleEntity);
        Class clazz = scopeMetadata == null ? RunCustomOperationData.class : scopeMetadata.runDataClass;
        RunCustomOperationData runCustomOperationData = (RunCustomOperationData)this.conversionHandler.convertExcluding(clazz, (Object)customOperation, new Object[]{RunCustomOperationData.ACTIONS});
        this.setMissingFormParameters((RunnableCustomOperationVO)runCustomOperationData, customOperation, runCustomOperationDataParams.getOperationParameters());
        if (scopeMetadata != null) {
            object = (EntityVO)this.conversionHandler.convert(scopeMetadata.voClass, (Object)simpleEntity);
            runCustomOperationData.set(scopeMetadata.runDataProperty, object);
        }
        if (customOperation.getResultType() == CustomOperationResultType.RESULT_PAGE && customOperation.isAllowExport()) {
            runCustomOperationData.setExportFormats(this.conversionHandler.convertList(ExportFormatVO.class, (Iterable)this.exportFormatService.listByContext(ExportFormatContext.CUSTOM_OPERATION)));
        }
        runCustomOperationData.setConfirmationPasswordInput(this.getCredentialInputForRun(customOperation));
        object = this.toFormParameters(customOperation, runCustomOperationDataParams.getOperationParameters());
        Map<String, Object> map = this.ensureScopeContext(customOperationScope, simpleEntity);
        map.put("customOperation", customOperation);
        map.put("formParameters", object);
        this.customFieldValueHandler.fillValuesFromScript(CustomOperationField.class, LoadValuesScriptFunction.ENTITY, map, (Collection)runCustomOperationData.getFormParameters());
        Object object2 = this.customScriptService.newAccessor(customOperation.getScript(), customOperation.getScriptParameters()).bindAll(map).run((ScriptFunction)CustomOperationScriptFunction.PRE_RUN);
        Map map2 = null;
        if (object2 != null) {
            map2 = object2 instanceof Map ? (Map)object2 : new BeanMap(object2);
            for (CustomFieldDetailedVO customFieldDetailedVO : runCustomOperationData.getFormParameters()) {
                String string = ModelHelper.unqualifyInternalName((IInternalNamedEntity)customFieldDetailedVO);
                if (!map2.containsKey(string)) continue;
                Object v = map2.get(string);
                this.customFieldValueHandler.setDefaultValue(customFieldDetailedVO, v);
                runCustomOperationData.getMissingOptionalParameters().remove(customFieldDetailedVO);
                runCustomOperationData.getMissingRequiredParameters().remove(customFieldDetailedVO);
                if (object.containsKey(string)) continue;
                object.put(string, v);
            }
        }
        RunContext runContext = new RunContext(customOperation);
        runContext.rawResult = object2;
        runContext.formParameters = object;
        this.handleActions(runContext, true);
        runCustomOperationData.setActions(runContext.result.getActions());
        runCustomOperationData.setAutoRunActionId(runContext.result.getAutoRunActionId());
        runCustomOperationData.setReRun(map2 == null || !map2.containsKey("reRun") ? false : Boolean.parseBoolean(map2.get("reRun").toString()));
        return runCustomOperationData;
    }

    public List<CustomOperation> getRunnableCustomOperationsForSystem() {
        SessionData sessionData = this.getSessionData();
        List list = sessionData.getProducts().admin().getSystemCustomOperationsRun();
        return this.applyScopeAndAvailability(list, CustomOperationScope.SYSTEM, null);
    }

    public List<CustomOperation> getRunnableOperationsForAd(BasicAd basicAd) {
        SessionData sessionData = this.getSessionData();
        ProductsAccessor productsAccessor = sessionData.getProducts();
        boolean bl = basicAd.getType() == AdType.WEB_SHOP;
        return this.getRunnableOperations(CustomOperationScope.ADVERTISEMENT, basicAd.getOwner(), (SimpleEntity)basicAd, bl ? productsAccessor.member().hasPermission(Permission.MY_WEB_SHOP_ENABLE) : productsAccessor.member().hasPermission(Permission.MY_ADS_ENABLE), bl ? productsAccessor.userManagement().hasPermission(Permission.USER_WEB_SHOP_VIEW) : productsAccessor.userManagement().hasPermission(Permission.USER_ADS_VIEW), bl ? productsAccessor.member().hasPermission(Permission.USER_WEB_SHOP_VIEW) : productsAccessor.member().hasPermission(Permission.USER_ADS_VIEW));
    }

    public List<RunnableCustomOperationVO> getRunnableOperationsForAd(BasicAdVO basicAdVO) throws FrameworkException {
        BasicAd basicAd = (BasicAd)this.conversionHandler.convert(BasicAd.class, (Object)basicAdVO);
        List<CustomOperation> list = this.getRunnableOperationsForAd(basicAd);
        return this.conversionHandler.convertList(RunnableCustomOperationVO.class, list);
    }

    public List<CustomOperation> getRunnableOperationsForBulkActions() {
        List list = this.getProducts().userManagement().getUserCustomOperationsRun();
        return this.applyScopeAndAvailability(list, CustomOperationScope.BULK_ACTION, null);
    }

    public List<CustomOperation> getRunnableOperationsForContact(Contact contact) {
        SessionData sessionData = this.getSessionData();
        ProductsAccessor productsAccessor = sessionData.getProducts();
        return this.getRunnableOperations(CustomOperationScope.CONTACT, contact.getOwner(), (SimpleEntity)contact, productsAccessor.member().hasPermission(Permission.MY_CONTACTS_ENABLE), productsAccessor.userManagement().hasPermission(Permission.USER_CONTACTS_VIEW), false);
    }

    public List<RunnableCustomOperationVO> getRunnableOperationsForContact(ContactVO contactVO) throws FrameworkException {
        Contact contact = (Contact)this.conversionHandler.convert(Contact.class, (Object)contactVO);
        return this.conversionHandler.convertList(RunnableCustomOperationVO.class, this.getRunnableOperationsForContact(contact));
    }

    public List<CustomOperation> getRunnableOperationsForContactInfo(ContactInfo contactInfo) {
        SessionData sessionData = this.getSessionData();
        ProductsAccessor productsAccessor = sessionData.getProducts();
        return this.getRunnableOperations(CustomOperationScope.CONTACT_INFO, contactInfo.getUser(), (SimpleEntity)contactInfo, productsAccessor.member().getMaxContactInfos() > 0, true, true);
    }

    public List<RunnableCustomOperationVO> getRunnableOperationsForContactInfo(ContactInfoVO contactInfoVO) throws FrameworkException {
        BaseContactInfo baseContactInfo = (BaseContactInfo)this.conversionHandler.convert(BaseContactInfo.class, (Object)contactInfoVO);
        if (baseContactInfo instanceof ContactInfo) {
            return this.conversionHandler.convertList(RunnableCustomOperationVO.class, this.getRunnableOperationsForContactInfo((ContactInfo)baseContactInfo));
        }
        return Collections.emptyList();
    }

    public List<CustomOperation> getRunnableOperationsForMenu() throws FrameworkException {
        Configuration configuration = this.getConfiguration().getConfiguration();
        EnumSet<ContentItemVisibility> enumSet = EnumSet.of(ContentItemVisibility.ALL, this.isGuest() ? ContentItemVisibility.GUESTS : ContentItemVisibility.USERS);
        ArrayList<CustomOperation> arrayList = new ArrayList<CustomOperation>();
        List list = this.menuEntryService.list(null, configuration, false, enumSet, false);
        for (MenuEntry menuEntry : list) {
            if (menuEntry instanceof MenuGroup) {
                MenuGroup menuGroup = (MenuGroup)menuEntry;
                for (MenuEntry menuEntry2 : menuGroup.getEntries()) {
                    if (!enumSet.contains(menuEntry2.getVisibility()) || !(menuEntry2 instanceof MenuItem)) continue;
                    this.addCustomOperationIfAvailable(arrayList, menuEntry2);
                }
                continue;
            }
            if (!(menuEntry instanceof MenuItem)) continue;
            this.addCustomOperationIfAvailable(arrayList, menuEntry);
        }
        return CollectionHelper.sort(arrayList);
    }

    public List<CustomOperation> getRunnableOperationsForRecord(Record record) {
        SessionData sessionData = this.getSessionData();
        User user = record instanceof UserRecord ? ((UserRecord)record).getUser() : null;
        ProductsAccessor productsAccessor = sessionData.getProducts();
        if (user == null) {
            List list = productsAccessor.admin().getSystemCustomOperationsRun();
            list.removeIf(customOperation -> !customOperation.getRecordTypes().contains(record.getType()));
            return this.applyScopeAndAvailability(list, CustomOperationScope.RECORD, Collections.singletonMap("record", record));
        }
        UserRecordType userRecordType = (UserRecordType)record.getType();
        QProductMyRecordType qProductMyRecordType = QProductMyRecordType.productMyRecordType;
        QProductUserRecordType qProductUserRecordType = QProductUserRecordType.productUserRecordType;
        return this.getRunnableOperations(CustomOperationScope.RECORD, user, (SimpleEntity)record, productsAccessor.product().getMyRecordTypes().isSet((Object)userRecordType, (Path)qProductMyRecordType.enabled), productsAccessor.userManagement().getUserRecordTypes().isSet((Object)userRecordType, (Path)qProductUserRecordType.view), false);
    }

    public List<RunnableCustomOperationVO> getRunnableOperationsForRecord(RecordVO recordVO) throws FrameworkException {
        Record record = (Record)this.conversionHandler.convert(Record.class, (Object)recordVO);
        List<CustomOperation> list = this.getRunnableOperationsForRecord(record);
        return this.conversionHandler.convertList(RunnableCustomOperationVO.class, list);
    }

    public List<RunnableCustomOperationVO> getRunnableOperationsForSystem() throws FrameworkException {
        List<CustomOperation> list = this.getRunnableCustomOperationsForSystem();
        return this.conversionHandler.convertList(RunnableCustomOperationVO.class, list);
    }

    public List<CustomOperation> getRunnableOperationsForTransfer(Transfer transfer) {
        SessionData sessionData = this.getSessionData();
        ProductsAccessor productsAccessor = sessionData.getProducts();
        HashSet<CustomOperation> hashSet = new HashSet<CustomOperation>();
        Consumer<InternalAccountOwner> consumer = internalAccountOwner -> {
            if (internalAccountOwner instanceof User) {
                if (internalAccountOwner.equals((Object)sessionData.getLoggedUser())) {
                    hashSet.addAll(productsAccessor.member().getRunTransferCustomOperations());
                } else {
                    hashSet.addAll(productsAccessor.userManagement().getRunTransferCustomOperations());
                }
            } else if (internalAccountOwner instanceof SystemAccountOwner) {
                hashSet.addAll(productsAccessor.admin().getRunTransferCustomOperations());
            }
        };
        consumer.accept(transfer.getFromOwner());
        consumer.accept(transfer.getToOwner());
        hashSet.removeIf(customOperation -> CollectionHelper.isNotEmpty((Iterable)customOperation.getTransferTypes()) && !customOperation.getTransferTypes().contains(transfer.getType()));
        return this.applyScopeAndAvailability(hashSet, CustomOperationScope.TRANSFER, Collections.singletonMap("transfer", transfer));
    }

    public List<RunnableCustomOperationVO> getRunnableOperationsForTransfer(TransferVO transferVO) throws FrameworkException {
        Transfer transfer = (Transfer)this.conversionHandler.convert(Transfer.class, (Object)transferVO);
        List<CustomOperation> list = this.getRunnableOperationsForTransfer(transfer);
        return this.conversionHandler.convertList(RunnableCustomOperationVO.class, list);
    }

    public List<CustomOperation> getRunnableOperationsForUser(User user) {
        Object object;
        SessionData sessionData = this.getSessionData();
        QMemberProductCustomOperation qMemberProductCustomOperation = QMemberProductCustomOperation.memberProductCustomOperation;
        Set set = this.productsHandler.getAccessor((BasicUser)user).member().getCustomOperations().keysSet((Path)qMemberProductCustomOperation.enabled);
        if (sessionData.isManagerOf((BasicUser)user)) {
            set.retainAll(sessionData.getProducts().userManagement().getUserCustomOperationsRun());
        } else {
            object = user.equals((Object)sessionData.getLoggedUser()) ? qMemberProductCustomOperation.run : qMemberProductCustomOperation.runOnOthers;
            set.retainAll(sessionData.getProducts().member().getCustomOperations().keysSet((Path)object));
        }
        object = set.stream().filter(customOperation -> this.isUserActive(user) && customOperation.isEnabledForActiveUsers() || user.isPendingValidation() && customOperation.isEnabledForPendingUsers()).sorted().collect(Collectors.toList());
        return this.applyScopeAndAvailability((Collection<CustomOperation>)object, CustomOperationScope.USER, Collections.singletonMap("user", user));
    }

    public List<RunnableCustomOperationVO> getRunnableOperationsForUser(UserLocatorVO userLocatorVO) throws FrameworkException {
        User user = this.userLocatorHandler.toUserOrCurrent((BasicUserVO)userLocatorVO);
        List<CustomOperation> list = this.getRunnableOperationsForUser(user);
        return this.conversionHandler.convertList(RunnableCustomOperationVO.class, list);
    }

    public List<CustomOperationResultVO> list() throws FrameworkException {
        List list = ((DBQuery)this.from().orderBy(new OrderSpecifier[]{((QCustomOperation)this.$).scope.asc(), ((QCustomOperation)this.$).order.asc()})).list(CustomOperationResultVO.class, (Expression)this.$);
        for (CustomOperationResultVO customOperationResultVO : list) {
            Collections.sort(customOperationResultVO.getChannels());
        }
        return list;
    }

    public List<CustomOperation> listAllowedToRun() {
        List<CustomOperation> list = null;
        SessionData sessionData = this.getSessionData();
        if (sessionData.isAdmin()) {
            list = this.getRunnableCustomOperationsForSystem();
        } else if (sessionData.isMember()) {
            list = this.getRunnableOperationsForUser(sessionData.getLoggedUser());
        }
        return list;
    }

    public List<CustomOperation> listByScope(CustomOperationScope ... customOperationScopeArray) throws FrameworkException {
        return ((DBQuery)((DBQuery)this.from().where((Predicate)((QCustomOperation)this.$).scope.in((Object[])customOperationScopeArray))).orderBy(new OrderSpecifier[]{((QCustomOperation)this.$).scope.asc(), ((QCustomOperation)this.$).order.asc()})).list((Expression)this.$);
    }

    public List<CustomOperation> listOperationsRedirectingTo(CustomOperation customOperation) {
        QCustomOperationAction qCustomOperationAction = QCustomOperationAction.customOperationAction;
        List list = ((DBQuery)this.from().where((Predicate)((QCustomOperation)this.$).rowOperation().eq((Object)customOperation))).list((Expression)this.$);
        List list2 = ((DBQuery)this.from(new EntityPath[]{qCustomOperationAction}).where((Predicate)qCustomOperationAction.actionOperation().eq((Object)customOperation))).list((Expression)qCustomOperationAction.ownerOperation());
        HashSet hashSet = new HashSet(list);
        hashSet.addAll(list2);
        return CollectionHelper.sort(hashSet);
    }

    public List<CustomOperation> listWithRecordScope(RecordTypeNature ... recordTypeNatureArray) throws FrameworkException {
        QRecordType qRecordType = QRecordType.recordType;
        return ((DBQuery)((DBQuery)((DBQuery)this.from(new EntityPath[]{this.$, qRecordType}).where(new Predicate[]{((QCustomOperation)this.$).recordTypes.contains((Expression)qRecordType), qRecordType.nature.in((Object[])recordTypeNatureArray)})).distinct()).orderBy(new OrderSpecifier[]{((QCustomOperation)this.$).scope.asc(), ((QCustomOperation)this.$).order.asc()})).list((Expression)this.$);
    }

    @Override
    public CustomOperation newEntity(Void void_) {
        CustomOperation customOperation = new CustomOperation();
        customOperation.getChannels().add(this.channelService.getMain());
        customOperation.getChannels().add(this.channelService.getWebServices());
        customOperation.setScope(CustomOperationScope.SYSTEM);
        customOperation.setFrontendMenu(FrontendMenu.BANKING);
        customOperation.setAdminMenu(AdminMainMenu.values()[0]);
        customOperation.setUserMenu(UserMainMenu.values()[0]);
        customOperation.setProfileSection(ProfileManagementSection.values()[0]);
        customOperation.setSearchAutomatically(true);
        customOperation.setEnabledForActiveUsers(true);
        return customOperation;
    }

    public CustomOperation resolveCustomOperation(SimpleEntity simpleEntity, CustomOperationVO customOperationVO) {
        if (simpleEntity instanceof MenuItem) {
            return ((MenuItem)simpleEntity).getCustomOperation();
        }
        return (CustomOperation)this.conversionHandler.convert(CustomOperation.class, (Object)customOperationVO);
    }

    public RunCustomOperationResult run(RunCustomOperationDTO runCustomOperationDTO) throws FrameworkException {
        RunContext runContext = new RunContext(runCustomOperationDTO);
        CustomOperationResultType customOperationResultType = runContext.operation.getResultType();
        if (customOperationResultType.isContent()) {
            this.handleContent(runContext);
        } else if (customOperationResultType == CustomOperationResultType.NOTIFICATION) {
            this.handleNotification(runContext);
        } else if (customOperationResultType.isUrl()) {
            this.handleUrl(runContext);
        } else if (customOperationResultType == CustomOperationResultType.FILE_DOWNLOAD) {
            this.handleFileDownload(runContext);
        } else if (customOperationResultType == CustomOperationResultType.RESULT_PAGE) {
            this.handleResultPage(runContext);
        } else {
            throw new IllegalStateException("Unhandled result type: " + String.valueOf(customOperationResultType));
        }
        this.handleActions(runContext, false);
        return runContext.result;
    }

    public RunCustomOperationResult runExternalRedirectCallback(RunExternalRedirectCallbackParams runExternalRedirectCallbackParams) throws FrameworkException {
        String string2;
        Object object;
        SessionData sessionData = this.getSessionData();
        RequestData requestData = sessionData.getRequestData();
        ExternalRedirectExecution externalRedirectExecution = this.find(ExternalRedirectExecution.class, runExternalRedirectCallbackParams.getId());
        if (!this.cyclosProperties.isSessionsAnyAddress() && externalRedirectExecution.getRemoteAddress() != null && !externalRedirectExecution.getRemoteAddress().equals(requestData.getRemoteAddress())) {
            throw new EntityNotFoundException(ExternalRedirectExecution.class, runExternalRedirectCallbackParams.getId());
        }
        RequestInfo requestInfo = runExternalRedirectCallbackParams.getRequest();
        if (!Objects.equals(runExternalRedirectCallbackParams.getToken(), externalRedirectExecution.getVerificationToken())) {
            object = StringHelper.split((String)runExternalRedirectCallbackParams.getToken(), (String)",");
            if (object.stream().noneMatch(string -> Objects.equals(string, externalRedirectExecution.getVerificationToken()))) {
                throw new EntityNotFoundException(ExternalRedirectExecution.class, runExternalRedirectCallbackParams.getToken());
            }
            object.removeIf(string -> Objects.equals(string, externalRedirectExecution.getVerificationToken()));
            string2 = new MapParameterStorage(requestInfo.getParameters());
            string2.setString(RunExternalRedirectCallbackParams.TOKEN.getName(), new String[]{StringHelper.join((Collection)object, (String)",")});
            requestInfo = RequestInfo.builder().copy(requestInfo).parameters((ParameterStorage)string2).build();
        }
        object = externalRedirectExecution.getLoggedUser();
        string2 = externalRedirectExecution.getChannel().getInternalName();
        Object object2 = object == null ? SessionDataFactory.guest((RequestData)requestData, (String)string2) : SessionDataFactory.direct((UserPrincipal)externalRedirectExecution).channel(string2).build();
        RequestInfo requestInfo2 = requestInfo;
        Object object3 = this.invokerHandler.runAs(object2, () -> {
            CustomOperation customOperation = externalRedirectExecution.getOperation();
            EntityBackedParameterStorage entityBackedParameterStorage = new EntityBackedParameterStorage(this.jacksonConfiguration.getObjectMapper(), (EntityWithParameterStorageContext)externalRedirectExecution);
            return this.customScriptService.newAccessor(customOperation.getScript(), customOperation.getScriptParameters()).bind("customOperation", (Object)customOperation).bind("user", (Object)externalRedirectExecution.getUser()).bind("request", (Object)requestInfo2).bind("storage", (Object)entityBackedParameterStorage).bind("parameterStorage", (Object)entityBackedParameterStorage).bind("execution", (Object)externalRedirectExecution).bind("externalRedirectExecution", (Object)externalRedirectExecution).run((ScriptFunction)CustomOperationScriptFunction.CALLBACK);
        });
        this.remove(this.find(ExternalRedirectExecution.class, externalRedirectExecution.getId()));
        RunCustomOperationDTO runCustomOperationDTO = new RunCustomOperationDTO();
        runCustomOperationDTO.setCustomOperation(new CustomOperationVO(externalRedirectExecution.getOperation().getId()));
        RunContext runContext = new RunContext(runCustomOperationDTO);
        runContext.rawResult = object3;
        this.fillNotificationContext(runContext);
        return runContext.result;
    }

    public BulkActionUserResult runForBulkAction(BulkActionUser bulkActionUser) {
        CustomFieldValueDTO customFieldValueDTO;
        Object object2;
        CustomOperationBulkAction customOperationBulkAction = (CustomOperationBulkAction)bulkActionUser.getBulkAction();
        CustomOperation customOperation = customOperationBulkAction.getCustomOperation();
        Set set = CollectionHelper.orEmpty((Set)customOperationBulkAction.getFormParameters());
        User user = bulkActionUser.getUser();
        RunUserCustomOperationDTO runUserCustomOperationDTO = new RunUserCustomOperationDTO();
        runUserCustomOperationDTO.setUser(new UserLocatorVO(user.getId()));
        runUserCustomOperationDTO.setCustomOperation(new CustomOperationVO(customOperation.getId()));
        ArrayList<CustomFieldValueDTO> arrayList = new ArrayList<CustomFieldValueDTO>(set.size());
        for (Object object2 : set) {
            customFieldValueDTO = new CustomFieldValueDTO();
            customFieldValueDTO.setField(new CustomFieldVO(object2.getCustomField().getId()));
            customFieldValueDTO.setReferenceValue(object2.getValue());
            arrayList.add(customFieldValueDTO);
        }
        runUserCustomOperationDTO.setFormParameters(arrayList);
        RunContext runContext = new RunContext((RunCustomOperationDTO)runUserCustomOperationDTO);
        runContext.bindings = new HashMap<String, Object>();
        runContext.bindings.put("user", user);
        runContext.bindings.put("bulkAction", customOperationBulkAction);
        this.doRun(runContext);
        object2 = runContext.rawResult;
        customFieldValueDTO = null;
        if (object2 == null) {
            customFieldValueDTO = new BulkActionUserResult(BulkActionUserStatus.SKIPPED);
        } else if (object2 instanceof Boolean) {
            BulkActionUserStatus bulkActionUserStatus = Boolean.TRUE.equals(object2) ? BulkActionUserStatus.SUCCESS : BulkActionUserStatus.SKIPPED;
            customFieldValueDTO = new BulkActionUserResult(bulkActionUserStatus);
        } else if (object2 instanceof BulkActionUserResult) {
            customFieldValueDTO = (BulkActionUserResult)object2;
        } else if (object2 instanceof BulkActionUserStatus) {
            customFieldValueDTO = new BulkActionUserResult((BulkActionUserStatus)object2);
        } else if (object2 instanceof Throwable) {
            customFieldValueDTO = new BulkActionUserResult((Throwable)object2);
        } else {
            BulkActionUserResult bulkActionUserResult = (BulkActionUserResult)this.conversionHandler.convert(BulkActionUserResult.class, object2);
            if (bulkActionUserResult != null && (bulkActionUserResult.getStatus() != null || StringHelper.isNotBlank((Object)bulkActionUserResult.getMessage()))) {
                if (bulkActionUserResult.getStatus() == null) {
                    bulkActionUserResult.setStatus(BulkActionUserStatus.SUCCESS);
                }
                return bulkActionUserResult;
            }
            String string = object2.toString();
            try {
                BulkActionUserStatus bulkActionUserStatus = BulkActionUserStatus.valueOf((String)string);
                customFieldValueDTO = new BulkActionUserResult(bulkActionUserStatus);
            }
            catch (Exception exception) {
                customFieldValueDTO = new BulkActionUserResult(BulkActionUserStatus.SUCCESS, string);
            }
        }
        return customFieldValueDTO;
    }

    public void setMissingFormParameters(RunnableCustomOperationVO runnableCustomOperationVO, CustomOperation customOperation) {
        this.setMissingFormParameters(runnableCustomOperationVO, customOperation, null);
    }

    @Override
    public CustomOperation toEntity(CustomOperationDTO customOperationDTO) {
        CustomOperation customOperation = (CustomOperation)super.toEntity(customOperationDTO);
        if (customOperationDTO.getRowAction() == null) {
            customOperation.setRowUrl(null);
            customOperation.setRowLocation(null);
            customOperation.setRowOperation(null);
            customOperation.setRowParameters(null);
        }
        return customOperation;
    }

    @Override
    protected CustomOperationData getData(CustomOperation customOperation) {
        TransferTypeQuery transferTypeQuery;
        CustomOperationData customOperationData = new CustomOperationData();
        customOperationData.setDto((EntityDTO)((CustomOperationDTO)this.toDTO(customOperation)));
        customOperationData.setScripts(this.conversionHandler.convertList(CustomScriptVO.class, (Iterable)this.customScriptService.listByType(ScriptType.CUSTOM_OPERATION)));
        if (customOperation.isPersistent()) {
            customOperationData.setFormParameters(this.conversionHandler.convertList(CustomFieldVO.class, (Iterable)customOperation.getFormParameters()));
            customOperationData.setActions(this.customOperationActionService.list(new CustomOperationVO(customOperation.getId())));
        }
        List list = this.channelService.listAll();
        list.removeIf(channel -> !channel.isAllowOperations());
        customOperationData.setChannels(this.conversionHandler.convertList(ChannelVO.class, (Iterable)list));
        if (customOperation.isTransient() || customOperation.getScope() == CustomOperationScope.RECORD) {
            customOperationData.setRecordTypes(this.recordTypeService.list());
        }
        if (customOperation.isTransient() || customOperation.getScope() == CustomOperationScope.TRANSFER) {
            transferTypeQuery = new TransferTypeQuery();
            transferTypeQuery.setUnlimited();
            transferTypeQuery.setIncludeDisabled(true);
            customOperationData.setTransferTypes(this.transferTypeService.search(transferTypeQuery).getPageItems());
        }
        transferTypeQuery = (DBQuery)this.from().where((Predicate)((QCustomOperation)this.$).scope.eq((Object)CustomOperationScope.INTERNAL));
        if (customOperation.isPersistent() && customOperation.getScope() == CustomOperationScope.INTERNAL) {
            transferTypeQuery.where((Predicate)((QCustomOperation)this.$).id.ne((Object)customOperation.getId()));
        }
        transferTypeQuery.orderBy(((QCustomOperation)this.$).order.asc());
        customOperationData.setInternalOperations(transferTypeQuery.list(CustomOperationVO.class, (Expression)this.$));
        return customOperationData;
    }

    @Override
    protected void onAfterRemove(CustomOperation customOperation) {
        Long l = SimpleEntity.id((SimpleEntity)customOperation.getNetwork());
        List list = PropertyHelper.getGetterNames((Path[])new Path[]{QProduct.product.runTransferCustomOperations, QMemberProduct.memberProduct.customOperations, QAdminProduct.adminProduct.systemCustomOperationsRun, QUserManagementProduct.userManagementProduct.userCustomOperationsRun});
        this.cacheHandler.schedulePartialEvict(CacheType.PRODUCTS_ACCESSOR, (SerializablePredicate & Serializable)productsAccessorCacheKey -> productsAccessorCacheKey.matchesNetworkAndMethod(l, (Collection)list));
    }

    @Override
    protected Object onBeforeSave(CustomOperation customOperation, CustomOperation customOperation2) {
        CustomOperationScope customOperationScope = customOperation.getScope();
        switch (customOperationScope) {
            case SYSTEM: {
                customOperation.setUserMenu(null);
                customOperation.setProfileSection(null);
                break;
            }
            case USER: {
                customOperation.setAdminMenu(null);
                break;
            }
            case MENU: 
            case ADVERTISEMENT: 
            case CONTACT: 
            case CONTACT_INFO: 
            case RECORD: 
            case TRANSFER: {
                customOperation.setFrontendMenu(null);
                customOperation.setUserMenu(null);
                customOperation.setProfileSection(null);
                customOperation.setAdminMenu(null);
                if (customOperationScope != CustomOperationScope.MENU) break;
                customOperation.getChannels().removeIf(Channel::isMobile);
                break;
            }
            case INTERNAL: {
                customOperation.setFrontendMenu(null);
                customOperation.setUserMenu(null);
                customOperation.setProfileSection(null);
                customOperation.setAdminMenu(null);
                if (customOperation.getShowForm() != null) break;
                customOperation.setShowForm(CustomOperationShowForm.MISSING_REQUIRED);
                break;
            }
            case BULK_ACTION: {
                customOperation.setFrontendMenu(null);
                customOperation.setUserMenu(null);
                customOperation.setProfileSection(null);
                customOperation.setAdminMenu(null);
                customOperation.setHasFileUpload(false);
                customOperation.setRequireConfirmationCredential(false);
                customOperation.setResultType(CustomOperationResultType.BULK_ACTION);
            }
        }
        if (customOperationScope != CustomOperationScope.RECORD) {
            customOperation.setRecordTypes(null);
        }
        if (customOperationScope != CustomOperationScope.TRANSFER) {
            customOperation.setTransferTypes(null);
        }
        if (customOperationScope != CustomOperationScope.INTERNAL && customOperation.getShowForm() == null) {
            customOperation.setShowForm(CustomOperationShowForm.MISSING_ANY);
        }
        if (customOperationScope != CustomOperationScope.USER) {
            customOperation.setEnabledForActiveUsers(false);
            customOperation.setEnabledForPendingUsers(false);
        }
        if (customOperation.getResultType() != CustomOperationResultType.RESULT_PAGE) {
            customOperation.setRowUrl(null);
            customOperation.setRowLocation(null);
            customOperation.setRowOperation(null);
            customOperation.setRowParameters(null);
            customOperation.setSearchAutomatically(false);
            customOperation.setOpenRowInNewWindow(false);
            customOperation.setResultInformationText(null);
        } else {
            customOperation.setShowForm(CustomOperationShowForm.MISSING_REQUIRED);
            customOperation.setRequireConfirmationCredential(false);
        }
        if (!customOperation.getResultType().isContent()) {
            customOperation.setCloseAfterSeconds(null);
        }
        if (customOperation.getRowAction() == null) {
            customOperation.setRowUrl(null);
            customOperation.setRowLocation(null);
            customOperation.setRowOperation(null);
            customOperation.setRowParameters(null);
        }
        if (customOperation.isTransient()) {
            int n = (Integer)ObjectHelper.defaultValue((Object)((Integer)((DBQuery)this.from(this.$).where((Predicate)((QCustomOperation)this.$).scope.eq((Object)customOperation.getScope()))).singleResult((Expression)((QCustomOperation)this.$).order.max())), (Object)1);
            customOperation.setOrder(Integer.valueOf(n + 1));
        }
        return null;
    }

    @Override
    protected void preProcessCurrentCopy(CustomOperationDTO customOperationDTO, CustomOperation customOperation) {
        customOperation.getChannels().size();
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QCustomOperation)this.$).network());
        networkPathRegistry.register(ere.operation().network());
    }

    @Override
    protected Validator resolveValidator(CustomOperationDTO customOperationDTO) {
        CustomOperationResultPageRowAction customOperationResultPageRowAction;
        CustomOperationScope customOperationScope;
        final CustomOperationResultType customOperationResultType = customOperationDTO.getScope() == CustomOperationScope.BULK_ACTION ? CustomOperationResultType.BULK_ACTION : customOperationDTO.getResultType();
        Validator validator = new Validator();
        validator.property((Property)CustomOperationDTO.SCOPE, SystemKeys.Operations.SCOPE).required();
        validator.property((Property)CustomOperationDTO.SCRIPT, SystemKeys.Operations.SCRIPT).required().entity(CustomScript.class, (EntityValidation)new BaseEntityValidation<CustomScript>(){

            protected boolean isValid(Object object, Object object2, CustomScript customScript) {
                return customScript.getType() == ScriptType.CUSTOM_OPERATION;
            }
        }).entity(CustomScript.class, (EntityValidation)new BaseEntityValidation<CustomScript>(SystemKeys.Operations.ERROR_SCRIPT_NOT_EXTERNAL_REDIRECT, new Object[0]){

            protected boolean isValid(Object object, Object object2, CustomScript customScript) {
                if (customOperationResultType == CustomOperationResultType.EXTERNAL_REDIRECT) {
                    String string = (String)customScript.getFunctions().get(CustomOperationScriptFunction.CALLBACK.name());
                    return StringHelper.isNotBlank((Object)string);
                }
                return true;
            }
        });
        validator.property((Property)CustomOperationDTO.CHANNELS, SystemKeys.Operations.CHANNELS).entity(Channel.class, (EntityValidation)new BaseEntityValidation<Channel>(){

            protected boolean isValid(Object object, Object object2, Channel channel) {
                return channel.isAllowOperations();
            }
        });
        if (customOperationDTO.getScope() != CustomOperationScope.BULK_ACTION) {
            validator.property((Property)CustomOperationDTO.RESULT_TYPE, SystemKeys.Operations.RESULT_TYPE).noneOf(new Object[]{CustomOperationResultType.BULK_ACTION}).required();
        }
        if ((customOperationScope = customOperationDTO.getScope()) == CustomOperationScope.SYSTEM || customOperationScope == CustomOperationScope.USER) {
            customOperationResultPageRowAction = customOperationScope == CustomOperationScope.SYSTEM ? Arrays.asList(FrontendMenu.BANKING, FrontendMenu.USERS, FrontendMenu.CONTENT, FrontendMenu.PERSONAL) : Arrays.asList(FrontendMenu.BANKING, FrontendMenu.MARKETPLACE, FrontendMenu.CONTENT, FrontendMenu.PERSONAL, FrontendMenu.OPERATORS, FrontendMenu.BROKERING);
            validator.property((Property)CustomOperationDTO.FRONTEND_MENU, SystemKeys.Operations.FRONTEND_MENU).required().anyOf((Collection)customOperationResultPageRowAction);
        }
        if (customOperationScope == CustomOperationScope.SYSTEM) {
            validator.property((Property)CustomOperationDTO.ADMIN_MENU, SystemKeys.Operations.ADMIN_MENU).required();
        } else if (customOperationScope == CustomOperationScope.USER) {
            validator.property((Property)CustomOperationDTO.USER_MENU, SystemKeys.Operations.USER_MENU).required();
            validator.property((Property)CustomOperationDTO.PROFILE_SECTION, SystemKeys.Operations.PROFILE_SECTION).required();
        } else if (customOperationScope == CustomOperationScope.RECORD) {
            validator.property((Property)CustomOperationDTO.RECORD_TYPES, SystemKeys.Operations.RECORD_TYPES).required();
        }
        validator.property((Property)CustomOperationDTO.CLOSE_AFTER_SECONDS, SystemKeys.Operations.CLOSE_AFTER_SECONDS).positiveNonZero();
        if (customOperationDTO.isSubmitWithQrCodeScan() && !customOperationResultType.allowSubmitWithQrCodeScan()) {
            validator.property((Property)CustomOperationDTO.SUBMIT_WITH_QR_CODE_SCAN, SystemKeys.Operations.SUBMIT_WITH_QR_CODE_SCAN).invalid(SystemKeys.Operations.SUBMIT_WITH_QR_CODE_SCAN_INVALID_FOR_RESULT_TYPE, new Object[]{customOperationDTO.getResultType()});
        }
        if (customOperationResultType == CustomOperationResultType.RESULT_PAGE && (customOperationResultPageRowAction = customOperationDTO.getRowAction()) != null) {
            switch (customOperationResultPageRowAction) {
                case URL: {
                    validator.property((Property)CustomOperationDTO.ROW_URL, SystemKeys.Operations.ROW_URL).required();
                    break;
                }
                case LOCATION: {
                    validator.property((Property)CustomOperationDTO.ROW_LOCATION, SystemKeys.Operations.ROW_LOCATION).required();
                    break;
                }
                case OPERATION: {
                    validator.property((Property)CustomOperationDTO.ROW_OPERATION, SystemKeys.Operations.ROW_OPERATION).required().entity(CustomOperation.class, (EntityValidation)new BaseEntityValidation<CustomOperation>(){

                        protected boolean isValid(Object object, Object object2, CustomOperation customOperation) {
                            return customOperation.getScope() == CustomOperationScope.INTERNAL;
                        }
                    });
                    validator.property((Property)CustomOperationDTO.ROW_PARAMETERS, SystemKeys.Operations.ROW_PARAMETERS).required();
                }
            }
        }
        if (customOperationResultType != null && customOperationDTO.isPersistent()) {
            boolean bl;
            boolean bl2 = bl = !((CustomOperation)this.find(customOperationDTO.getId())).getActions().isEmpty();
            if (!customOperationResultType.supportActions() && bl) {
                validator.general(GeneralValidations.invalid((MessageKey)SystemKeys.Operations.ERROR_ACTIONS_NOT_SUPPORTED, (Object[])new Object[0]));
            }
        }
        return validator;
    }

    private void addCustomOperationIfAvailable(List<CustomOperation> list, MenuEntry menuEntry) {
        MenuItem menuItem = (MenuItem)menuEntry;
        if (menuItem.getType() == MenuItemType.CUSTOM_OPERATION) {
            CustomOperation customOperation = menuItem.getCustomOperation();
            list.addAll(this.applyScopeAndAvailability(Collections.singleton(customOperation), CustomOperationScope.MENU, Collections.singletonMap("menuItem", menuItem)));
        }
    }

    private List<CustomOperation> applyScopeAndAvailability(Collection<CustomOperation> collection, CustomOperationScope customOperationScope, Map<String, Object> map) {
        return this.applyScopeAndAvailability(collection, customOperationScope, map, null);
    }

    private List<CustomOperation> applyScopeAndAvailability(Collection<CustomOperation> collection, CustomOperationScope customOperationScope, Map<String, Object> map, Function<CustomOperation, Map<String, ?>> function) {
        return CollectionHelper.orEmpty(collection).stream().filter(customOperation -> {
            Object object;
            if (customOperation.getScope() != customOperationScope || !customOperation.getChannels().contains(this.getSessionData().getChannel())) {
                return false;
            }
            Map<String, Object> map2 = this.ensureScopeContext(null, null);
            if (map != null) {
                map2.putAll(map);
            }
            if (function != null && (object = (Map)function.apply((CustomOperation)customOperation)) != null) {
                map2.putAll((Map<String, Object>)object);
            }
            if (map2.get("formParameters") == null) {
                map2.put("formParameters", Collections.emptyMap());
            }
            return (object = (Boolean)this.customScriptService.newAccessor(customOperation.getScript(), customOperation.getScriptParameters()).bind("customOperation", customOperation).bindAll(map2).run(Boolean.class, (ScriptFunction)CustomOperationScriptFunction.AVAILABILITY)) == null || ((Boolean)object).booleanValue();
        }).sorted().collect(Collectors.toList());
    }

    private SimpleEntity doGetRelatedEntity(Bean bean, Function<ScopeMetadata, Property<?, ?>> function, CustomOperationScope customOperationScope) {
        ScopeMetadata scopeMetadata;
        CustomOperationScope customOperationScope2 = customOperationScope;
        if (customOperationScope2 == null) {
            customOperationScope2 = ((CustomOperation)this.conversionHandler.convert(CustomOperation.class, bean.get((Property)RunCustomOperationDataParams.CUSTOM_OPERATION))).getScope();
        }
        if ((scopeMetadata = SCOPE_META.get(customOperationScope2)) == null) {
            return null;
        }
        Property<?, ?> property = function.apply(scopeMetadata);
        SimpleEntity simpleEntity = (SimpleEntity)this.conversionHandler.convert(scopeMetadata.entityClass, bean.get(property));
        if (customOperationScope2 == CustomOperationScope.USER && simpleEntity == null) {
            return this.getLoggedUser();
        }
        return simpleEntity;
    }

    private void doRun(RunContext runContext) {
        Object object;
        Object object2;
        Object object3;
        CustomFieldValueDTO customFieldValueDTO2;
        SessionData sessionData = this.getSessionData();
        CustomOperation customOperation = runContext.operation;
        RunCustomOperationDTO runCustomOperationDTO = runContext.params;
        for (CustomFieldValueDTO customFieldValueDTO2 : CollectionHelper.orEmpty((List)runCustomOperationDTO.getFormParameters())) {
            object3 = customFieldValueDTO2.getField();
            if (object3.getId() != null || object3.getInternalName() == null) continue;
            customOperation.getFormParameters().stream().filter(arg_0 -> CustomOperationServiceImpl.lambda$doRun$11((CustomFieldVO)object3, arg_0)).findAny().ifPresent(arg_0 -> CustomOperationServiceImpl.lambda$doRun$12((CustomFieldVO)object3, arg_0));
        }
        CustomOperationScope customOperationScope = runContext.operation.getScope();
        customFieldValueDTO2 = null;
        object3 = SCOPE_META.get(customOperationScope);
        if (object3 != null) {
            object2 = runCustomOperationDTO.get(object3.runDtoProperty);
            customFieldValueDTO2 = (SimpleEntity)this.conversionHandler.convert(object3.entityClass, object2);
            if (customOperationScope == CustomOperationScope.USER && customFieldValueDTO2 == null) {
                customFieldValueDTO2 = sessionData.getLoggedUser();
            }
        }
        this.validateRun(customOperation, (SimpleEntity)customFieldValueDTO2);
        this.validate(customOperation, runCustomOperationDTO);
        if (customOperation.isRequireConfirmationCredential()) {
            this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).check(runCustomOperationDTO.getConfirmationPassword(), RunCustomOperationConfirmationField.confirmation((CustomOperationVO)new CustomOperationVO(customOperation.getId())));
        }
        object2 = this.customFieldValueHandler.toValuesMap((Collection)customOperation.getFormParameters(), (Collection)runCustomOperationDTO.getFormParameters(), true);
        runContext.formParameters = object2.entrySet().stream().collect(Collectors.toMap(entry -> ((CustomOperationField)entry.getKey()).getInternalName(), Map.Entry::getValue));
        String string = null;
        ExternalRedirectExecution externalRedirectExecution = null;
        EntityBackedParameterStorage entityBackedParameterStorage = null;
        if (customOperation.getResultType() == CustomOperationResultType.EXTERNAL_REDIRECT) {
            object = (User)ObjectHelper.ifType((Object)customFieldValueDTO2, User.class);
            externalRedirectExecution = new ExternalRedirectExecution();
            externalRedirectExecution.setDate(new Date());
            externalRedirectExecution.setOperation(customOperation);
            externalRedirectExecution.setChannel(sessionData.getChannel());
            externalRedirectExecution.setRemoteAddress(sessionData.getRemoteAddress());
            externalRedirectExecution.setVerificationToken(SecureRandomHelper.randomAlphanumeric((int)32));
            externalRedirectExecution.initFrom((UserPrincipal)sessionData);
            externalRedirectExecution.setUser(object);
            this.persist((IEntity)externalRedirectExecution);
            entityBackedParameterStorage = new EntityBackedParameterStorage(this.jacksonConfiguration.getObjectMapper(), (EntityWithParameterStorageContext)externalRedirectExecution);
            string = this.linkGeneratorHandler.customOperationExternalRedirect(externalRedirectExecution);
        }
        object = this.ensureScopeContext(customOperationScope, (SimpleEntity)customFieldValueDTO2);
        runContext.rawResult = this.customScriptService.newAccessor(customOperation.getScript(), customOperation.getScriptParameters()).bind("customOperation", (Object)customOperation).bindAll((Map)object).bindAll(runContext.bindings).bind("inputFile", (Object)runCustomOperationDTO.getFileUpload()).bind("formParameters", runContext.formParameters).bind("scannedQrCode", (Object)runCustomOperationDTO.getScannedQrCode()).bind("returnUrl", string).bind("execution", (Object)externalRedirectExecution).bind("externalRedirectExecution", (Object)externalRedirectExecution).bind("storage", entityBackedParameterStorage).bind("parameterStorage", (Object)entityBackedParameterStorage).bind("currentPage", (Object)runCustomOperationDTO.getCurrentPage()).bind("pageSize", (Object)runCustomOperationDTO.getPageSize()).bind("skipTotalCount", (Object)(runCustomOperationDTO.isSkipTotalCount() || sessionData.getConfiguration().isSkipTotalCount() ? 1 : 0)).bind("exportFormat", this.conversionHandler.convert(ExportFormat.class, (Object)runCustomOperationDTO.getExportFormat())).bind("pageContext", null).run((ScriptFunction)CustomOperationScriptFunction.DEFAULT);
    }

    private void doRunExporting(ExportFormat exportFormat, RunContext runContext) throws FrameworkException {
        runContext.setUnlimitedPage();
        List<Object> list = this.doRunForPage(runContext);
        RunCustomOperationResult runCustomOperationResult = runContext.result;
        List list2 = runCustomOperationResult.getColumns();
        DataIterator dataIterator = CloseableIteratorHelper.asDataIterator((CloseableIterator)new CloseableIteratorAdapter(list.iterator()));
        runCustomOperationResult.setResultType(CustomOperationResultType.FILE_DOWNLOAD);
        runCustomOperationResult.setTitle(this.getTranslatedName((NamedEntity)runContext.operation));
        runCustomOperationResult.setRows(null);
        runCustomOperationResult.setColumns(null);
        runCustomOperationResult.setPageCount(null);
        runCustomOperationResult.setPageSize(null);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("customOperation", runContext.operation);
        hashMap.put("formParameters", runContext.formParameters);
        hashMap.put("columns", list2);
        FileInfo fileInfo = this.exportFormatService.exportMultiple(exportFormat, ExportFormatContext.CUSTOM_OPERATION, null, dataIterator, hashMap);
        runContext.setFileDownload(fileInfo);
    }

    private List<Object> doRunForPage(RunContext runContext) {
        boolean bl;
        if (runContext.params.getCurrentPage() == null || runContext.params.getCurrentPage() < 0) {
            runContext.params.setCurrentPage(Integer.valueOf(0));
        }
        int n = runContext.params.getCurrentPage();
        if (runContext.params.getPageSize() == null || runContext.params.getPageSize() < 0) {
            runContext.params.setPageSize(Integer.valueOf(40));
        }
        this.doRun(runContext);
        if (runContext.rawResult == null) {
            throw new CustomScriptException("The script for " + runContext.operation.getName() + " didn't return a result");
        }
        runContext.fillResult();
        PageResultAdapter pageResultAdapter = new PageResultAdapter();
        List<Object> list = pageResultAdapter.apply(runContext);
        if (CollectionHelper.isEmpty((Iterable)runContext.result.getColumns())) {
            throw new CustomScriptException("The script for " + runContext.operation.getName() + " didn't return any columns for the results");
        }
        int n2 = runContext.params.getPageSize();
        if (runContext.result.getCurrentPage() == null) {
            runContext.result.setCurrentPage(Integer.valueOf(n));
        }
        if (runContext.result.getPageSize() == null) {
            runContext.result.setPageSize(Integer.valueOf(n2));
        } else {
            n2 = runContext.result.getPageSize();
        }
        boolean bl2 = bl = CollectionHelper.size((Collection)runContext.result.getRows()) > n2;
        if (runContext.result.getTotalCount() != null) {
            int n3 = n2 == 0 ? 0 : (int)Math.ceil((double)runContext.result.getTotalCount().intValue() / (double)n2);
            runContext.result.setPageCount(Integer.valueOf(n3));
            runContext.result.setHasNextPage(Boolean.valueOf(n + 1 < n3));
        } else if (runContext.result.getHasNextPage() == null) {
            runContext.result.setHasNextPage(Boolean.valueOf(bl));
        }
        if (bl) {
            runContext.result.setRows(runContext.result.getRows().subList(0, n2));
        }
        return list;
    }

    private Map<String, Object> ensureScopeContext(CustomOperationScope customOperationScope, SimpleEntity simpleEntity) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        SCOPE_META.forEach((customOperationScope2, scopeMetadata) -> hashMap.put(scopeMetadata.attribute, customOperationScope2 == customOperationScope ? simpleEntity : null));
        return hashMap;
    }

    private void fillNotificationContext(RunContext runContext) {
        if (runContext.rawResult == null) {
            runContext.result.setNotification("");
            runContext.result.setNotificationLevel(NotificationLevel.INFORMATION);
        } else {
            runContext.fillResult();
            if (StringHelper.isBlank((Object)runContext.result.getNotification())) {
                String string = StringHelper.trim((Object)runContext.rawResult);
                Pair pair = NotificationLevel.process((String)string);
                runContext.result.setNotificationLevel((NotificationLevel)pair.getFirst());
                runContext.result.setNotification(runContext.rawResult instanceof CharSequence ? (String)pair.getSecond() : "");
            } else {
                if (runContext.result.getNotificationLevel() == null) {
                    runContext.result.setNotificationLevel(NotificationLevel.INFORMATION);
                }
                runContext.result.setNotification(StringHelper.trim((Object)runContext.result.getNotification()));
            }
        }
        runContext.result.setResultType(CustomOperationResultType.NOTIFICATION);
    }

    private CredentialInputDTO getCredentialInputForRun(CustomOperation customOperation) {
        if (customOperation.isRequireConfirmationCredential()) {
            return this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).getCredentialInput();
        }
        return null;
    }

    private List<CustomOperation> getRunnableOperations(CustomOperationScope customOperationScope, User user, SimpleEntity simpleEntity, boolean bl, boolean bl2, boolean bl3) {
        Object object;
        if (user == null || simpleEntity == null) {
            return Collections.emptyList();
        }
        SessionData sessionData = this.getSessionData();
        Collection<Object> collection = user.equals((Object)sessionData.getLoggedUser()) ? (bl ? sessionData.getProducts().member().getCustomOperations().keysSet((Path)CustomOperationServiceImpl.mpco.run) : Collections.emptySet()) : (sessionData.isManagerOf((BasicUser)user) ? (bl2 ? sessionData.getProducts().userManagement().getUserCustomOperationsRun() : Collections.emptySet()) : (bl3 ? sessionData.getProducts().member().getCustomOperations().keysSet((Path)CustomOperationServiceImpl.mpco.runOnOthers) : Collections.emptySet()));
        Set set = this.productsHandler.getAccessor((BasicUser)user).member().getCustomOperations().keysSet((Path)CustomOperationServiceImpl.mpco.enabled);
        collection.retainAll(set);
        if (simpleEntity instanceof Record) {
            object = (Record)simpleEntity;
            collection.removeIf(arg_0 -> CustomOperationServiceImpl.lambda$getRunnableOperations$15((Record)object, arg_0));
        }
        object = SCOPE_META.get(customOperationScope);
        Map<String, SimpleEntity> map = Collections.singletonMap(object.attribute, simpleEntity);
        return this.applyScopeAndAvailability(collection, customOperationScope, map);
    }

    private void handleActions(RunContext runContext, boolean bl) {
        Object object;
        Object object2;
        CustomOperationAction customOperationAction2;
        Action action;
        CustomOperation customOperation2;
        CustomOperation customOperation3 = runContext.operation;
        ActionsContainer actionsContainer = (ActionsContainer)this.conversionHandler.convert(ActionsContainer.class, runContext.rawResult);
        Map map = CollectionHelper.orEmpty(actionsContainer == null ? null : actionsContainer.getActions());
        Map<CustomOperation, CustomOperationAction> map2 = CollectionHelper.orEmpty((Set)customOperation3.getActions()).stream().filter(customOperationAction -> customOperationAction.getVisibility().isVisible(bl)).collect(Collectors.toMap(CustomOperationAction::getActionOperation, customOperationAction -> customOperationAction));
        TreeMap<CustomOperation, Pair> treeMap = new TreeMap<CustomOperation, Pair>();
        Object object4 = map.entrySet().iterator();
        while (object4.hasNext()) {
            Map.Entry object32 = object4.next();
            customOperation2 = (CustomOperation)object32.getKey();
            action = (Action)object32.getValue();
            customOperationAction2 = map2.get(customOperation2);
            if (customOperationAction2 == null) {
                throw new CustomScriptException("The script for custom operation " + customOperation3.getName() + " has returned the custom operation " + customOperation2.getName() + " as possible action, but it is not enabled as action on the custom operation itself");
            }
            if (Boolean.FALSE.equals(action.getEnabled())) {
                object4.remove();
                map2.remove(customOperation2);
                continue;
            }
            RunCustomOperationAction runCustomOperationAction = new RunCustomOperationAction();
            runCustomOperationAction.setPrimary(customOperationAction2.isPrimary());
            runCustomOperationAction.setAction((RunnableCustomOperationVO)this.conversionHandler.convert(RunnableCustomOperationVO.class, (Object)customOperation2));
            Object object3 = new HashMap();
            runCustomOperationAction.setParameters((Map)object3);
            treeMap.put(customOperation2, Pair.create((Object)runCustomOperationAction, (Object)customOperationAction2.getOrder()));
            object2 = customOperationAction2.getParameters().stream().collect(Collectors.toMap(CustomOperationActionParameter::getActionField, customOperationActionParameter -> customOperationActionParameter));
            object = CollectionHelper.orEmpty(action.getParameters());
            for (Map.Entry entry : object.entrySet()) {
                CustomOperationField customOperationField;
                Object k = entry.getKey();
                if (k == null) {
                    throw new CustomScriptException("The script for custom operation " + customOperation3.getName() + " has returned an empty parameter field for the action " + customOperation2.getName());
                }
                try {
                    customOperationField = (CustomOperationField)this.conversionHandler.convert(CustomOperationField.class, k);
                }
                catch (EntityNotFoundException entityNotFoundException) {
                    customOperationField = (CustomOperationField)this.entityManagerHandler.find(CustomOperationField.class, k.toString(), (SimpleEntity)customOperation2);
                }
                CustomOperationActionParameter customOperationActionParameter2 = (CustomOperationActionParameter)object2.get(customOperationField);
                if (customOperationActionParameter2 == null) {
                    throw new CustomScriptException("The script for custom operation " + customOperation3.getName() + " has returned for the action " + customOperation2.getName() + " a an invalid parameter: " + (customOperationField == null ? null : customOperationField.getName()));
                }
                object3.put(customOperationField.getInternalName(), this.customFieldValueHandler.toReference((CustomField)customOperationField, entry.getValue()));
            }
        }
        for (CustomOperationAction customOperationAction3 : map2.values()) {
            customOperation2 = customOperationAction3.getActionOperation();
            action = (Pair)treeMap.get(customOperation2);
            RunCustomOperationAction runCustomOperationAction = customOperationAction2 = action != null ? (RunCustomOperationAction)action.getFirst() : null;
            if (customOperationAction2 == null) {
                customOperationAction2 = new RunCustomOperationAction();
                customOperationAction2.setAction((RunnableCustomOperationVO)this.conversionHandler.convert(RunnableCustomOperationVO.class, (Object)customOperation2));
                customOperationAction2.setPrimary(customOperationAction3.isPrimary());
                customOperationAction2.setParameters(new HashMap());
                treeMap.put(customOperation2, Pair.create((Object)customOperationAction2, (Object)customOperationAction3.getOrder()));
            }
            for (Object object3 : customOperationAction3.getParameters()) {
                object2 = object3.getActionField();
                object = object2.getInternalName();
                if (customOperationAction2.getParameters().get(object) != null) continue;
                Iterator iterator = null;
                if (object3.getOwnerField() != null) {
                    Map.Entry entry;
                    entry = object3.getOwnerField().getInternalName();
                    iterator = runContext.formParameters.get(entry);
                }
                if (iterator == null) {
                    iterator = this.customFieldValueHandler.getDefaultValue((CustomField)object3.getActionField());
                }
                customOperationAction2.getParameters().put(object, this.customFieldValueHandler.toReference((CustomField)object3.getOwnerField(), (Object)iterator));
            }
            this.setMissingFormParameters(customOperationAction2.getAction(), customOperation2, customOperationAction2.getParameters());
        }
        object4 = Collections.singletonMap("containerCustomOperation", customOperation3);
        List<CustomOperation> list = this.applyScopeAndAvailability(treeMap.keySet(), CustomOperationScope.INTERNAL, (Map<String, Object>)object4, customOperation -> {
            Map map = ((RunCustomOperationAction)((Pair)treeMap.get(customOperation)).getFirst()).getParameters();
            return Collections.singletonMap("formParameters", this.toFormParameters((CustomOperation)customOperation, map));
        });
        CustomOperation customOperation4 = customOperation2 = actionsContainer == null ? null : actionsContainer.getAutoRunAction();
        if (customOperation2 != null) {
            if (!list.contains(customOperation2)) {
                throw new CustomScriptException("The script for custom operation " + customOperation3.getName() + " has returned the custom operation " + customOperation2.getName() + " to run automatically, but it is not enabled as action on the custom operation itself");
            }
            runContext.result.setAutoRunActionId(customOperation2.getId());
        }
        runContext.result.setActions(list.stream().map(treeMap::get).sorted((pair, pair2) -> Integer.compare((Integer)pair.getSecond(), (Integer)pair2.getSecond())).map(Pair::getFirst).collect(Collectors.toList()));
    }

    private void handleContent(RunContext runContext) {
        this.doRun(runContext);
        if (runContext.rawResult == null) {
            runContext.result.setTitle(this.getTranslatedName((NamedEntity)runContext.operation));
            runContext.result.setContent("");
        } else {
            runContext.fillResult();
            if (StringHelper.isBlank((Object)runContext.result.getContent())) {
                runContext.result.setContent(StringHelper.trim((Object)runContext.rawResult));
            }
        }
    }

    private void handleFileDownload(RunContext runContext) {
        this.doRun(runContext);
        FileInfo fileInfo = (FileInfo)this.conversionHandler.convert(FileInfo.class, runContext.rawResult);
        if (fileInfo == null || fileInfo.getContent() == null || StringHelper.isBlank((Object)fileInfo.getContentType())) {
            throw new CustomScriptException("The script for " + runContext.operation.getName() + " didn't return a valid " + FileInfo.class.getName() + " instance, but returned " + String.valueOf(runContext.rawResult));
        }
        runContext.result.setFileDownload(fileInfo);
    }

    private void handleNotification(RunContext runContext) {
        this.doRun(runContext);
        this.fillNotificationContext(runContext);
    }

    private void handleResultPage(RunContext runContext) {
        ExportFormat exportFormat = (ExportFormat)this.conversionHandler.convert(ExportFormat.class, (Object)runContext.params.getExportFormat());
        if (exportFormat == null) {
            this.doRunForPage(runContext);
        } else {
            this.doRunExporting(exportFormat, runContext);
        }
    }

    private void handleUrl(RunContext runContext) {
        boolean bl;
        this.doRun(runContext);
        runContext.fillResult();
        Object object = runContext.result.getUrl();
        if (StringHelper.isBlank((Object)object)) {
            object = StringHelper.trim((Object)runContext.rawResult);
        }
        if (((String)object).startsWith("http")) {
            bl = UrlValidation.isValid((String)object);
        } else if (((String)object).contains(":")) {
            bl = ((String)object).split(":", 2).length > 1;
        } else {
            object = "http://" + (String)object;
            bl = UrlValidation.isValid((String)object);
        }
        if (!bl) {
            throw new CustomScriptException("The custom operation " + runContext.operation.getName() + " didn't return a valid return URL, but " + String.valueOf(runContext.rawResult));
        }
        runContext.result.setUrl((String)object);
    }

    private boolean isUserActive(User user) {
        return AccountServiceLocal.POSSIBLE_STATUSES_TO_OWN_ACCOUNTS.contains(user.getStatus());
    }

    private void setMissingFormParameters(RunnableCustomOperationVO runnableCustomOperationVO, CustomOperation customOperation, Map<String, String> map) {
        Map<Object, Object> map2 = map == null ? Collections.emptyMap() : map;
        List list = customOperation.getFormParameters().stream().filter(CustomField::isRequired).filter(customOperationField -> StringHelper.isBlank(map2.get(customOperationField.getInternalName()))).map(customOperationField -> (CustomFieldVO)this.conversionHandler.convert(CustomFieldVO.class, customOperationField)).collect(Collectors.toList());
        List list2 = customOperation.getFormParameters().stream().filter(customOperationField -> !customOperationField.isRequired()).filter(customOperationField -> StringHelper.isBlank(map2.get(customOperationField.getInternalName()))).map(customOperationField -> (CustomFieldVO)this.conversionHandler.convert(CustomFieldVO.class, customOperationField)).collect(Collectors.toList());
        runnableCustomOperationVO.setMissingOptionalParameters(list2);
        runnableCustomOperationVO.setMissingRequiredParameters(list);
    }

    private Map<String, Object> toFormParameters(CustomOperation customOperation, Map<String, String> map) {
        if (CollectionHelper.isEmpty(map)) {
            return new HashMap<String, Object>();
        }
        return customOperation.getFormParameters().stream().filter(customOperationField -> map.containsKey(customOperationField.getInternalName())).map(customOperationField -> Pair.create((Object)customOperationField.getInternalName(), (Object)this.customFieldValueHandler.getValue((CustomField)customOperationField, map.get(customOperationField.getInternalName()), true))).filter(pair -> pair.getSecond() != null).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
    }

    private void validate(CustomOperation customOperation, RunCustomOperationDTO runCustomOperationDTO) {
        EntityVO entityVO;
        Validator validator = new Validator();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("customOperation", customOperation);
        CustomOperationScope customOperationScope = customOperation.getScope();
        ScopeMetadata scopeMetadata = SCOPE_META.get(customOperationScope);
        if (scopeMetadata != null) {
            entityVO = (EntityVO)runCustomOperationDTO.get(scopeMetadata.runDtoProperty);
            CustomOperationField customOperationField = (SimpleEntity)this.conversionHandler.convert(scopeMetadata.entityClass, (Object)entityVO);
            hashMap.put(scopeMetadata.attribute, customOperationField);
        }
        for (CustomOperationField customOperationField : customOperation.getFormParameters()) {
            this.customFieldValueHandler.addValueValidation(validator, (CustomField)customOperationField, null, hashMap, RunCustomOperationDTO.FORM_PARAMETERS.getName());
        }
        if (customOperation.isRequireConfirmationCredential()) {
            this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).addRequiredValidation(validator, (Property)RunCustomOperationDTO.CONFIRMATION_PASSWORD);
        }
        entityVO = validator.property((Property)RunCustomOperationDTO.SCANNED_QR_CODE, SystemKeys.Operations.SCANNED_QR_CODE);
        if (customOperation.isSubmitWithQrCodeScan()) {
            entityVO.required();
        } else if (StringHelper.isNotBlank((Object)runCustomOperationDTO.getScannedQrCode())) {
            entityVO.invalid();
        }
        this.validate(validator, runCustomOperationDTO, "runCustomOperationDTO");
    }

    private void validateRun(CustomOperation customOperation, SimpleEntity simpleEntity) {
        User user;
        Class<? extends SimpleEntity> clazz;
        SessionData sessionData = this.getSessionData();
        if (!customOperation.getChannels().contains(sessionData.getChannel())) {
            throw new IllegalActionException();
        }
        CustomOperationScope customOperationScope = customOperation.getScope();
        if (customOperationScope == CustomOperationScope.BULK_ACTION) {
            return;
        }
        ScopeMetadata scopeMetadata = SCOPE_META.get(customOperationScope);
        Class<? extends SimpleEntity> clazz2 = clazz = scopeMetadata == null ? null : scopeMetadata.entityClass;
        if (clazz == null && simpleEntity != null || clazz != null && !clazz.isInstance(simpleEntity)) {
            throw new IllegalActionException();
        }
        if (customOperationScope == CustomOperationScope.USER && (this.isUserActive(user = (User)simpleEntity) && !customOperation.isEnabledForActiveUsers() || user.isPendingValidation() && !customOperation.isEnabledForPendingUsers())) {
            throw new IllegalActionException();
        }
    }

    private static /* synthetic */ boolean lambda$getRunnableOperations$15(Record record, CustomOperation customOperation) {
        return !customOperation.getRecordTypes().contains(record.getType());
    }

    private static /* synthetic */ void lambda$doRun$12(CustomFieldVO customFieldVO, CustomOperationField customOperationField) {
        customFieldVO.setId(customOperationField.getId());
    }

    private static /* synthetic */ boolean lambda$doRun$11(CustomFieldVO customFieldVO, CustomOperationField customOperationField) {
        return customOperationField.getInternalName().equals(customFieldVO.getInternalName());
    }

    static {
        CustomOperationServiceImpl.registerScopeMeta("user", CustomOperationScope.USER, User.class, UserVO.class, RunUserCustomOperationData.USER, RunUserCustomOperationDataParams.USER, RunUserCustomOperationDTO.USER);
        CustomOperationServiceImpl.registerScopeMeta("contact", CustomOperationScope.CONTACT, Contact.class, ContactDetailedVO.class, RunContactCustomOperationData.CONTACT, RunContactCustomOperationDataParams.CONTACT, RunContactCustomOperationDTO.CONTACT);
        CustomOperationServiceImpl.registerScopeMeta("contactInfo", CustomOperationScope.CONTACT_INFO, ContactInfo.class, ContactInfoDetailedVO.class, RunContactInfoCustomOperationData.CONTACT_INFO, RunContactInfoCustomOperationDataParams.CONTACT_INFO, RunContactInfoCustomOperationDTO.CONTACT_INFO);
        CustomOperationServiceImpl.registerScopeMeta("ad", CustomOperationScope.ADVERTISEMENT, BasicAd.class, BasicAdVO.class, RunAdCustomOperationData.AD, RunAdCustomOperationDataParams.AD, RunAdCustomOperationDTO.AD);
        CustomOperationServiceImpl.registerScopeMeta("record", CustomOperationScope.RECORD, Record.class, RecordVO.class, RunRecordCustomOperationData.RECORD, RunRecordCustomOperationDataParams.RECORD, RunRecordCustomOperationDTO.RECORD);
        CustomOperationServiceImpl.registerScopeMeta("transfer", CustomOperationScope.TRANSFER, Transfer.class, TransferVO.class, RunTransferCustomOperationData.TRANSFER, RunTransferCustomOperationDataParams.TRANSFER, RunTransferCustomOperationDTO.TRANSFER);
        CustomOperationServiceImpl.registerScopeMeta("menuItem", CustomOperationScope.MENU, MenuItem.class, MenuItemVO.class, RunMenuItemCustomOperationData.MENU_ITEM, RunMenuItemCustomOperationDataParams.MENU_ITEM, RunMenuItemCustomOperationDTO.MENU_ITEM);
        ere = QExternalRedirectExecution.externalRedirectExecution;
        mpco = QMemberProductCustomOperation.memberProductCustomOperation;
    }

    private static class ScopeMetadata {
        private final String attribute;
        private final Class<? extends SimpleEntity> entityClass;
        private final Class<? extends EntityVO> voClass;
        private final Class<? extends RunCustomOperationData> runDataClass;
        private final Property<?, ?> runDataProperty;
        private final Property<?, ?> runDataParamsProperty;
        private final Property<?, ?> runDtoProperty;

        public ScopeMetadata(String string, Class<? extends SimpleEntity> clazz, Class<? extends EntityVO> clazz2, Class<? extends RunCustomOperationData> clazz3, Property<?, ?> property, Property<?, ?> property2, Property<?, ?> property3) {
            this.attribute = string;
            this.entityClass = clazz;
            this.voClass = clazz2;
            this.runDataClass = clazz3;
            this.runDataProperty = property;
            this.runDataParamsProperty = property2;
            this.runDtoProperty = property3;
        }
    }

    private class RunContext {
        private CustomOperation operation;
        private RunCustomOperationDTO params;
        private RunCustomOperationResult result;
        private Object rawResult;
        private Map<String, Object> formParameters;
        private Map<String, Object> bindings;

        private RunContext(CustomOperation customOperation) {
            this.operation = customOperation;
            this.initResult(customOperation);
        }

        private RunContext(RunCustomOperationDTO runCustomOperationDTO) {
            this.params = runCustomOperationDTO;
            this.operation = CustomOperationServiceImpl.this.resolveCustomOperation(CustomOperationServiceImpl.this.getRelatedEntity(runCustomOperationDTO), runCustomOperationDTO.getCustomOperation());
            this.initResult(this.operation);
        }

        private void fillResult() {
            CustomOperationServiceImpl.this.conversionHandler.fillExcluding(this.rawResult, (Object)this.result, new Object[]{RunCustomOperationResult.ACTIONS.getName(), RunCustomOperationResult.ROWS.getName()});
            if (this.result.getResultType() == null) {
                this.result.setResultType(this.operation.getResultType());
            }
            if (StringHelper.isBlank((Object)this.result.getTitle())) {
                this.result.setTitle(CustomOperationServiceImpl.this.getTranslatedName((NamedEntity)this.operation));
            }
            CustomOperation customOperation = (CustomOperation)CustomOperationServiceImpl.this.conversionHandler.convert(CustomOperation.class, (Object)this.result.getBackTo());
            this.result.setBackTo((CustomOperationVO)CustomOperationServiceImpl.this.conversionHandler.convert(CustomOperationVO.class, (Object)customOperation));
        }

        private void initResult(CustomOperation customOperation) {
            this.result = new RunCustomOperationResult();
            this.result.setResultType(customOperation.getResultType());
        }

        private void setFileDownload(FileInfo fileInfo) {
            this.result.setFileDownload(fileInfo);
            this.result.setResultType(CustomOperationResultType.FILE_DOWNLOAD);
        }

        private void setUnlimitedPage() {
            ConfigurationAccessor configurationAccessor = CustomOperationServiceImpl.this.getConfiguration();
            this.params.setCurrentPage(Integer.valueOf(0));
            Integer n = configurationAccessor.getMaxResults();
            this.params.setPageSize((Integer)ObjectHelper.defaultValue((Object)n, (Object)Integer.MAX_VALUE));
        }
    }

    public class PageResultAdapter {
        private Iterable<?> headers;
        private Iterable<Iterable<?>> results;
        private Iterable<?> rows;

        public Iterable<?> getHeaders() {
            return this.headers;
        }

        public Iterable<Iterable<?>> getResults() {
            return this.results;
        }

        public Iterable<?> getRows() {
            return this.rows;
        }

        public void setHeaders(Iterable<?> iterable) {
            this.headers = iterable;
        }

        public void setResults(Iterable<Iterable<?>> iterable) {
            this.results = iterable;
        }

        public void setRows(Iterable<?> iterable) {
            this.rows = iterable;
        }

        private List<Object> apply(RunContext runContext) {
            int n;
            Object object2;
            CustomOperationServiceImpl.this.conversionHandler.fill(runContext.rawResult, (Object)this);
            RunCustomOperationResult runCustomOperationResult = runContext.result;
            List list = runCustomOperationResult.getColumns();
            if (CollectionHelper.isEmpty((Iterable)list)) {
                if (this.headers != null) {
                    for (Object object2 : this.headers) {
                        PageResultColumn pageResultColumn = new PageResultColumn();
                        pageResultColumn.setHeader(StringHelper.trimToNull((Object)object2));
                        list.add(pageResultColumn);
                    }
                }
                runCustomOperationResult.setColumns(list);
            }
            for (n = 0; n < list.size(); ++n) {
                object2 = (PageResultColumn)list.get(n);
                if (object2.getType() == null) {
                    if (StringHelper.isNotBlank((Object)object2.getCurrencyProperty())) {
                        object2.setType(PageResultColumnType.CURRENCY_AMOUNT);
                    } else if (StringHelper.isNotBlank((Object)object2.getDecimalDigits())) {
                        object2.setType(PageResultColumnType.NUMBER);
                    } else {
                        object2.setType(PageResultColumnType.STRING);
                    }
                }
                if (object2.getType() == PageResultColumnType.NUMBER) {
                    int n2 = (Integer)ObjectHelper.defaultValue((Object)object2.getDecimalDigits(), (Object)-1);
                    n2 = Math.max(n2, -1);
                    n2 = Math.min(n2, BigDecimalHelper.MAX_SCALE);
                    object2.setDecimalDigits(Integer.valueOf(n2));
                } else {
                    object2.setDecimalDigits(null);
                }
                if (object2.getType() != PageResultColumnType.CURRENCY_AMOUNT) {
                    object2.setCurrencyProperty(null);
                }
                if (object2.getAlign() == null && ObjectHelper.isOneOf((Object)object2.getType(), (Object[])new Object[]{PageResultColumnType.NUMBER, PageResultColumnType.CURRENCY_AMOUNT})) {
                    object2.setAlign("right");
                }
                object2.setIndex(Integer.valueOf(n));
            }
            n = runContext.params.getExportFormat() != null ? 1 : 0;
            object2 = n != 0 ? new ArrayList() : null;
            ArrayList<String> arrayList = n != 0 ? null : new ArrayList<String>();
            ObjectMapper objectMapper = CustomOperationServiceImpl.this.idMaskJacksonConfiguration.getObjectMapper();
            if (CollectionHelper.isNotEmpty(this.results)) {
                for (Iterable<?> iterable : this.results) {
                    if (n != 0) {
                        ((ArrayList)object2).add(iterable);
                        continue;
                    }
                    try {
                        arrayList.add(objectMapper.writeValueAsString(iterable));
                    }
                    catch (JsonProcessingException jsonProcessingException) {
                        throw new CustomScriptException("Error converting a value to JSON: " + String.valueOf(iterable), (Throwable)jsonProcessingException);
                    }
                }
            } else if (this.rows != null) {
                FormatterImpl formatterImpl = CustomOperationServiceImpl.this.getFormatter();
                arrayList = new ArrayList();
                for (Object obj : this.rows) {
                    if (obj instanceof String) {
                        if (n != 0) {
                            try {
                                ((ArrayList)object2).add(objectMapper.readValue((String)obj, Map.class));
                                continue;
                            }
                            catch (IOException iOException) {
                                throw new UncheckedIOException(iOException);
                            }
                        }
                        arrayList.add((String)obj);
                        continue;
                    }
                    BeanAccessor beanAccessor = BeanAccessor.instance();
                    for (PageResultColumn pageResultColumn : list) {
                        Object object3 = pageResultColumn.getIndex() != null && obj instanceof List ? (Object)((List)obj).get(pageResultColumn.getIndex()) : (pageResultColumn.getProperty() != null ? (Object)beanAccessor.get(obj, pageResultColumn.getProperty()) : null);
                        if (object3 == null) continue;
                        Object object4 = object3;
                        switch (pageResultColumn.getType()) {
                            case BOOLEAN: {
                                object4 = CoercionHelper.coerce(Boolean.TYPE, object3);
                                break;
                            }
                            case DATE: {
                                object4 = CustomOperationServiceImpl.this.conversionHandler.convert(DateTime.class, object3);
                                break;
                            }
                            case CURRENCY_AMOUNT: {
                                if (StringHelper.isNotBlank((Object)pageResultColumn.getCurrencyProperty())) {
                                    object4 = ModelHelper.currencyAmount((CurrencyVO)this.asCurrency(runContext, beanAccessor.get(obj, pageResultColumn.getCurrencyProperty())), (BigDecimal)((BigDecimal)CoercionHelper.coerce(BigDecimal.class, (Object)object3)));
                                    break;
                                }
                                object4 = ModelHelper.currencyAmount((CurrencyVO)this.asCurrency(runContext, beanAccessor.get(object3, CurrencyAmountDTO.CURRENCY.getName())), (BigDecimal)BigDecimalHelper.zeroWhenNull((BigDecimal)((BigDecimal)CoercionHelper.coerce(BigDecimal.class, beanAccessor.get(object3, CurrencyAmountDTO.AMOUNT.getName())))));
                                break;
                            }
                            case NUMBER: {
                                Number number;
                                if (object3 instanceof BigDecimal) {
                                    number = (BigDecimal)object3;
                                    if (((BigDecimal)number).signum() == 0 || ((BigDecimal)number).scale() <= 0 || ((BigDecimal)number).stripTrailingZeros().scale() <= 0) {
                                        try {
                                            int n3 = ((BigDecimal)number).intValueExact();
                                            object4 = n3;
                                        }
                                        catch (Exception exception) {
                                            object4 = number;
                                        }
                                        break;
                                    }
                                    double d = ((BigDecimal)number).doubleValue();
                                    if (Double.isFinite(d)) {
                                        object4 = d;
                                        break;
                                    }
                                    object4 = number;
                                    break;
                                }
                                if (object3 instanceof BigInteger) {
                                    number = (BigInteger)object3;
                                    try {
                                        object4 = ((BigInteger)number).intValueExact();
                                    }
                                    catch (Exception exception) {
                                        object4 = number;
                                    }
                                    break;
                                }
                                if (object3 instanceof Long) {
                                    long l = (Long)object3;
                                    if (l > Integer.MAX_VALUE) {
                                        object4 = new BigInteger(String.valueOf(l));
                                        break;
                                    }
                                    object4 = (int)l;
                                    break;
                                }
                                object4 = CoercionHelper.coerce(Number.class, (Object)object3);
                                break;
                            }
                            case STRING: {
                                object4 = formatterImpl.format(object3);
                            }
                        }
                        if (object3.equals(object4)) continue;
                        if (pageResultColumn.getIndex() != null && obj instanceof List) {
                            ((List)obj).set(pageResultColumn.getIndex(), object4);
                            continue;
                        }
                        if (pageResultColumn.getProperty() == null) continue;
                        beanAccessor.set(obj, pageResultColumn.getProperty(), object4);
                    }
                    if (n != 0) {
                        ((ArrayList)object2).add(obj);
                        continue;
                    }
                    try {
                        arrayList.add(objectMapper.writeValueAsString(obj));
                    }
                    catch (JsonProcessingException jsonProcessingException) {
                        throw new CustomScriptException("Couldn't convert result to JSON: " + String.valueOf(obj), (Throwable)jsonProcessingException);
                    }
                }
                if (this.rows instanceof Page) {
                    Page page = (Page)this.rows;
                    if (runCustomOperationResult.getCurrentPage() == null) {
                        runCustomOperationResult.setCurrentPage(Integer.valueOf(page.getCurrentPage()));
                    }
                    if (runCustomOperationResult.getPageSize() == null) {
                        runCustomOperationResult.setPageSize(Integer.valueOf(page.getPageSize()));
                    }
                    if (runCustomOperationResult.getTotalCount() == null) {
                        runCustomOperationResult.setTotalCount(page.getTotalCount());
                    }
                }
            }
            runCustomOperationResult.setRows(arrayList);
            return (List)ObjectHelper.defaultValue((Object)object2, arrayList);
        }

        private CurrencyVO asCurrency(RunContext runContext, Object object) {
            CurrencyVO currencyVO;
            if (object == null) {
                throw new CustomScriptException("Script " + runContext.operation.getScript().getName() + " didn't return a currency for a result row");
            }
            if (object instanceof CurrencyVO) {
                currencyVO = (CurrencyVO)object;
            } else if (object instanceof Currency) {
                Currency currency = (Currency)object;
                currencyVO = (CurrencyVO)CustomOperationServiceImpl.this.conversionHandler.cachedEntityFromId(Currency.class, CurrencyVO.class, currency.getId(), false);
            } else if (object instanceof Number) {
                long l = ((Number)object).longValue();
                currencyVO = (CurrencyVO)CustomOperationServiceImpl.this.conversionHandler.cachedEntityFromId(Currency.class, CurrencyVO.class, Long.valueOf(l), false);
            } else if (object instanceof CharSequence) {
                Currency currency = (Currency)CustomOperationServiceImpl.this.entityManagerHandler.find(Currency.class, object.toString());
                currencyVO = (CurrencyVO)CustomOperationServiceImpl.this.conversionHandler.cachedEntityFromId(Currency.class, CurrencyVO.class, currency.getId(), false);
            } else {
                throw new CustomScriptException("Script " + runContext.operation.getScript().getName() + " didn't returned an invalid currency: " + String.valueOf(object));
            }
            return currencyVO;
        }
    }

    public static class ActionsContainer {
        private Map<CustomOperation, Action> actions;
        private CustomOperation autoRunAction;

        public Map<CustomOperation, Action> getActions() {
            return this.actions;
        }

        public CustomOperation getAutoRunAction() {
            return this.autoRunAction;
        }

        public void setActions(Map<CustomOperation, Action> map) {
            this.actions = map;
        }

        public void setAutoRunAction(CustomOperation customOperation) {
            this.autoRunAction = customOperation;
        }
    }

    public static class Action {
        private Boolean enabled;
        private Map<Object, Object> parameters;

        public Boolean getEnabled() {
            return this.enabled;
        }

        public Map<Object, Object> getParameters() {
            return this.parameters;
        }

        public void setEnabled(Boolean bl) {
            this.enabled = bl;
        }

        public void setParameters(Map<Object, Object> map) {
            this.parameters = map;
        }
    }
}

