/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cyclos.entities.system.Configuration;
import org.cyclos.entities.system.ConfigurationGuestProfileField;
import org.cyclos.entities.system.EntityPropertyLog;
import org.cyclos.entities.users.ProfileFieldComparator;
import org.cyclos.impl.EntityLogDescriptor;
import org.cyclos.impl.system.BaseEntityLogHandlerImpl;
import org.cyclos.impl.utils.validation.BeanPropertyAccess;
import org.cyclos.impl.utils.validation.PropertyAccess;
import org.cyclos.model.NestedProperty;
import org.cyclos.model.Property;
import org.cyclos.model.access.AccessKeys;
import org.cyclos.model.access.Permission;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.configurations.AccountNumberConfigurationDTO;
import org.cyclos.model.system.configurations.AddressConfigurationDTO;
import org.cyclos.model.system.configurations.CaptchaConfigurationDTO;
import org.cyclos.model.system.configurations.ConfigurationDTO;
import org.cyclos.model.system.configurations.ConfigurationGuestProfileFieldDTO;
import org.cyclos.model.system.configurations.CustomScriptConfigurationDTO;
import org.cyclos.model.system.configurations.CustomSessionConfigurationDTO;
import org.cyclos.model.system.configurations.DynamicOidcClientConfigurationDTO;
import org.cyclos.model.system.configurations.IpGeolocationConfigurationDTO;
import org.cyclos.model.system.configurations.OutboundSmsConfigurationDTO;
import org.cyclos.model.system.configurations.SmtpConfigurationDTO;
import org.cyclos.model.system.configurations.UserFormatConfigurationDTO;
import org.cyclos.model.system.entitylogs.EntityLogEvent;
import org.cyclos.model.system.entitylogs.EntityLogType;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.users.ProfileField;
import org.cyclos.model.utils.CountryVO;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.Pair;
import org.cyclos.utils.StringHelper;
import org.springframework.stereotype.Component;

@Component
public class ConfigurationEntityLogHandlerImpl
extends BaseEntityLogHandlerImpl<Configuration, ConfigurationDTO> {
    private static final Set<String> NESTED_BEAN_PROPERTIES = Stream.of(ConfigurationDTO.ADDRESS_CONFIGURATION.getName(), ConfigurationDTO.USER_FORMAT_FOR_MANAGERS.getName(), ConfigurationDTO.USER_FORMAT_FOR_OTHERS.getName(), ConfigurationDTO.LINK_GENERATION_CONFIGURATION.getName(), ConfigurationDTO.IP_GEOLOCATION_CONFIGURATION.getName(), ConfigurationDTO.NOTIFICATION_CONFIGURATION.getName(), ConfigurationDTO.ACCOUNT_NUMBER_CONFIGURATION.getName(), ConfigurationDTO.CUSTOM_SESSION_CONFIGURATION.getName(), ConfigurationDTO.SMTP_CONFIGURATION.getName(), ConfigurationDTO.CAPTCHA_CONFIGURATION.getName(), ConfigurationDTO.DYNAMIC_OIDC_CLIENT_CONFIGURATION.getName(), ConfigurationDTO.OUTBOUND_SMS_CONFIGURATION.getName(), ConfigurationDTO.GUEST_PROFILE_FIELDS.getName()).collect(Collectors.toSet());

    @Override
    public boolean areEquals(Configuration configuration, Configuration configuration2, PropertyAccess propertyAccess, Object object, Object object2) {
        if (!super.areEquals(configuration, configuration2, propertyAccess, object, object2)) {
            return false;
        }
        if (!this.isNestedBeanProperty(propertyAccess.getPropertyName())) {
            boolean bl;
            String string = this.getConfigurationPropertyName(propertyAccess.getPropertyName());
            boolean bl2 = configuration != null && configuration.getDefinedProperties().contains(string);
            boolean bl3 = bl2 ^ (bl = configuration2 != null && configuration2.getDefinedProperties().contains(string));
            if (!bl3 && !this.isNestedBeanProperty(string)) {
                boolean bl4 = configuration != null && configuration.getLockedProperties().contains(string);
                boolean bl5 = configuration2 != null && configuration2.getLockedProperties().contains(string);
                return !(bl4 ^ bl5);
            }
            return !bl3;
        }
        return true;
    }

    public Class<Configuration> getEntityClass() {
        return Configuration.class;
    }

    public EntityLogType getType() {
        return EntityLogType.CONFIGURATION;
    }

    public EntityLogDescriptor<ConfigurationDTO> resolveLogDescriptor(Configuration configuration) {
        return new EntityLogDescriptor(ConfigurationDTO.class).property(this.toAccess(ConfigurationDTO.NAME), GeneralKeys.Ui.NAME).property(this.toAccess(ConfigurationDTO.INTERNAL_NAME), GeneralKeys.Ui.INTERNAL_NAME).property(this.toAccess(ConfigurationDTO.DESCRIPTION), GeneralKeys.Ui.DESCRIPTION).property(this.toAccess((Property<?, ?>)ConfigurationDTO.NAME_LABEL), SystemKeys.Configurations.NAME_LABEL).property(this.toAccess((Property<?, ?>)ConfigurationDTO.ACCOUNT_STATUS_INDICATORS), SystemKeys.Configurations.ACCOUNT_STATUS_INDICATORS).property(this.toAccess((Property<?, ?>)ConfigurationDTO.AD_CATEGORIES_RESULT_TYPE), SystemKeys.Configurations.AD_CATEGORIES_RESULT_TYPE).property(this.toAccess((Property<?, ?>)ConfigurationDTO.AD_FIELDS_VISIBLE_TO_GUESTS), SystemKeys.Configurations.AD_FIELDS_VISIBLE_TO_GUESTS).property(this.toAccess((Property<?, ?>)ConfigurationDTO.HIDE_AD_OWNER_TO_GUESTS), SystemKeys.Configurations.HIDE_AD_OWNER_TO_GUESTS).property(this.toAccess((Property<?, ?>)ConfigurationDTO.HIDE_AD_PRICE_TO_GUESTS), SystemKeys.Configurations.HIDE_AD_PRICE_TO_GUESTS).property(this.toAccess((Property<?, ?>)ConfigurationDTO.AD_INITIAL_SEARCH_TYPE), SystemKeys.Configurations.AD_INITIAL_SEARCH_TYPE).property(this.toAccess((Property<?, ?>)ConfigurationDTO.AD_SUB_CATEGORIES_RESULTS), SystemKeys.Configurations.AD_SUB_CATEGORIES_RESULTS).property(this.toAccess((Property<?, ?>)ConfigurationDTO.ADS_RESULT_TYPE), SystemKeys.Configurations.ADS_RESULT_TYPE).property(this.toAccess((Property<?, ?>)ConfigurationDTO.ADS_SORT_ORDER), SystemKeys.Configurations.ADS_SORT_ORDER).property(this.toAccess((Property<?, ?>)ConfigurationDTO.USERS_SORT_ORDER), SystemKeys.Configurations.USERS_SORT_ORDER).property(this.toAccess((Property<?, ?>)ConfigurationDTO.ALLOW_ACCESS_MODE), SystemKeys.Configurations.ALLOW_ACCESS_MODE).property(this.toAccess((Property<?, ?>)ConfigurationDTO.ALLOW_MULTIPLE_REPORTS), SystemKeys.Configurations.ALLOW_MULTIPLE_REPORTS).property(this.toAccess((Property<?, ?>)ConfigurationDTO.ALLOW_QUICK_PAYMENT_MOBILE), SystemKeys.Configurations.ALLOW_QUICK_PAYMENT_MOBILE).property(this.toAccess((Property<?, ?>)ConfigurationDTO.ALLOW_VIEW_USER_AD), SystemKeys.Configurations.ALLOW_VIEW_USER_AD).property(this.toAccess((Property<?, ?>)ConfigurationDTO.ALLOW_VIEW_USER_WEB_SHOP), SystemKeys.Configurations.ALLOW_VIEW_USER_WEB_SHOP).property(this.toAccess((Property<?, ?>)ConfigurationDTO.ALLOWED_LANGUAGES), SystemKeys.Configurations.ALLOWED_LANGUAGES).property(this.toAccess((Property<?, ?>)ConfigurationDTO.ALWAYS_SHOW_INTERNATIONAL_PHONE_NUMBER), SystemKeys.Configurations.ALWAYS_SHOW_INTERNATIONAL_PHONE_NUMBER).property(this.toAccess((Property<?, ?>)ConfigurationDTO.APPLE_STORE_URL_MOBILE), SystemKeys.Configurations.APPLE_STORE_URL_MOBILE).property(this.toAccess((Property<?, ?>)ConfigurationDTO.FIREBASE_PRIVATE_KEY), SystemKeys.Configurations.FIREBASE_PRIVATE_KEY).ignore((Property)ConfigurationDTO.FIREBASE_PRIVATE_KEY_SET).property(this.toAccess((Property<?, ?>)ConfigurationDTO.APPLICATION_DESCRIPTION), SystemKeys.Configurations.APPLICATION_DESCRIPTION).property(this.toAccess((Property<?, ?>)ConfigurationDTO.APPLICATION_NAME), SystemKeys.Configurations.APPLICATION_NAME).property(this.toAccess((Property<?, ?>)ConfigurationDTO.APPLICATION_USERNAME), SystemKeys.Configurations.APPLICATION_USERNAME).property(this.toAccess((Property<?, ?>)ConfigurationDTO.AUTOCOMPLETE_RESULTS), SystemKeys.Configurations.AUTOCOMPLETE_RESULTS).property(this.toAccess((Property<?, ?>)ConfigurationDTO.BANNER_ROTATE_SECONDS), SystemKeys.Configurations.BANNER_ROTATE_SECONDS).property(this.toAccess((Property<?, ?>)ConfigurationDTO.COMMUNITY_MENU_LABEL), SystemKeys.Configurations.COMMUNITY_MENU_LABEL).property(this.toAccess((Property<?, ?>)ConfigurationDTO.COUNTRY), SystemKeys.Configurations.COUNTRY).property(this.toAccess((Property<?, ?>)ConfigurationDTO.DATE_FORMAT), SystemKeys.Configurations.DATE_FORMAT).property(this.toAccess((Property<?, ?>)ConfigurationDTO.DEFAULT_ACCOUNT_HISTORY_PERIOD), SystemKeys.Configurations.DEFAULT_ACCOUNT_HISTORY_PERIOD).property(this.toAccess((Property<?, ?>)ConfigurationDTO.DEFAULT_ADDRESS_PRIVACY), SystemKeys.Configurations.USER_DATA_PRIVACY_ADDRESS).property(this.toAccess((Property<?, ?>)ConfigurationDTO.DEFAULT_CITY), SystemKeys.Configurations.DEFAULT_CITY).property(this.toAccess((Property<?, ?>)ConfigurationDTO.DEFAULT_EMAIL_PRIVACY), SystemKeys.Configurations.USER_DATA_PRIVACY_EMAIL).property(this.toAccess((Property<?, ?>)ConfigurationDTO.DEFAULT_LANGUAGE), SystemKeys.Configurations.DEFAULT_LANGUAGE).property(this.toAccess((Property<?, ?>)ConfigurationDTO.DEFAULT_MAP_LOCATION), SystemKeys.Configurations.DEFAULT_MAP_LOCATION).property(this.toAccess((Property<?, ?>)ConfigurationDTO.DEFAULT_MAP_ZOOM_MOBILE), SystemKeys.Configurations.DEFAULT_MAP_ZOOM_MOBILE).property(this.toAccess((Property<?, ?>)ConfigurationDTO.DEFAULT_MAP_ZOOM_WEB), SystemKeys.Configurations.DEFAULT_MAP_ZOOM_WEB).property(this.toAccess((Property<?, ?>)ConfigurationDTO.DEFAULT_PHONE_PRIVACY), SystemKeys.Configurations.USER_DATA_PRIVACY_PHONE).property(this.toAccess((Property<?, ?>)ConfigurationDTO.DEFAULT_REGION), SystemKeys.Configurations.DEFAULT_REGION).property(this.toAccess((Property<?, ?>)ConfigurationDTO.DEFAULT_USER_IMAGE), SystemKeys.Configurations.DEFAULT_USER_IMAGE).property(this.toAccess((Property<?, ?>)ConfigurationDTO.DISTANCE_UNIT), SystemKeys.Configurations.DISTANCE_UNIT).property(this.toAccess((Property<?, ?>)ConfigurationDTO.EMAIL_NAME), SystemKeys.Configurations.EMAIL_NAME).property(this.toAccess((Property<?, ?>)ConfigurationDTO.EMAIL_REQUIRED), SystemKeys.Configurations.EMAIL_REQUIRED).property(this.toAccess((Property<?, ?>)ConfigurationDTO.EMAIL_UNIQUE), SystemKeys.Configurations.EMAIL_UNIQUE).property(this.toAccess((Property<?, ?>)ConfigurationDTO.EMAIL_VALIDATION), SystemKeys.Configurations.EMAIL_VALIDATION).property(this.toAccess((Property<?, ?>)ConfigurationDTO.PROFILE_IMAGE_REQUIRED), SystemKeys.Configurations.PROFILE_IMAGE_REQUIRED).property(this.toAccess((Property<?, ?>)ConfigurationDTO.ENABLE_BLUETOOTH_PRINTER_MOBILE), SystemKeys.Configurations.ENABLE_BLUETOOTH_PRINTER_MOBILE).property(this.toAccess((Property<?, ?>)ConfigurationDTO.APPLY_DEFAULT_USER_SEARCH_FILTERS_ON_PAYMENT), SystemKeys.Configurations.APPLY_DEFAULT_USER_SEARCH_FILTERS_ON_PAYMENT).property(this.toAccess((Property<?, ?>)ConfigurationDTO.ENABLE_SERVICES_LOG), SystemKeys.Configurations.ENABLE_SERVICES_LOG).property(this.toAccess((Property<?, ?>)ConfigurationDTO.TASKS_LOGGING_MODE), SystemKeys.Configurations.TASKS_LOGGING).property(this.toAccess((Property<?, ?>)ConfigurationDTO.FORGOT_PASSWORD_MODE), SystemKeys.Configurations.FORGOT_PASSWORD_MODE).property(this.toAccess((Property<?, ?>)ConfigurationDTO.REQUIRE_SECURITY_QUESTION_ON_REGISTRATION), SystemKeys.Configurations.REQUIRE_SECURITY_QUESTION_ON_REGISTRATION).property(this.toAccess((Property<?, ?>)ConfigurationDTO.FORGOT_PASSWORD_SEND_MEDIUM), SystemKeys.Configurations.FORGOT_PASSWORD_SEND_MEDIUM).property(this.toAccess((Property<?, ?>)ConfigurationDTO.GENERATED_USERNAME), SystemKeys.Configurations.GENERATED_USERNAME).property(this.toAccess((Property<?, ?>)ConfigurationDTO.GENERATED_USERNAME_LENGTH), SystemKeys.Configurations.GENERATED_USERNAME_LENGTH).property(this.toAccess((Property<?, ?>)ConfigurationDTO.GIVEN_VERY_BAD_REFS), SystemKeys.Configurations.GIVEN_VERY_BAD_REFS).property(this.toAccess((Property<?, ?>)ConfigurationDTO.GROUPS_FOR_USER_DIRECTORY), SystemKeys.Configurations.GROUPS_FOR_USER_DIRECTORY).property(this.toAccess((Property<?, ?>)ConfigurationDTO.GROUPS_FOR_USER_SEARCH), SystemKeys.Configurations.GROUPS_FOR_USER_SEARCH).property(this.toAccess((Property<?, ?>)ConfigurationDTO.GROUPS_FOR_VIEW_PROFILE), SystemKeys.Configurations.GROUPS_FOR_VIEW_PROFILE).property(this.toAccess((Property<?, ?>)ConfigurationDTO.GUESTS_MENU_TYPE), SystemKeys.Configurations.GUESTS_MENU_TYPE).property(this.toAccess((Property<?, ?>)ConfigurationDTO.USER_SEARCH_IN_MENU_MODE), SystemKeys.Configurations.USER_SEARCH_IN_MENU_MODE).property(this.toAccess((Property<?, ?>)ConfigurationDTO.GROUPS_FOR_USER_SEARCH_IN_MENU), SystemKeys.Configurations.GROUPS_FOR_USER_SEARCH_IN_MENU).property(this.toAccess((Property<?, ?>)ConfigurationDTO.INCLUDE_IN_SITEMAP), SystemKeys.Configurations.INCLUDE_IN_SITEMAP).property(this.toAccess((Property<?, ?>)ConfigurationDTO.INDIVIDUAL_DOCUMENT_DIRECTORY), SystemKeys.Configurations.INDIVIDUAL_DOCUMENT_DIRECTORY).property(this.toAccess((Property<?, ?>)ConfigurationDTO.INVALID_POS_PAYER_ATTEMPTS), SystemKeys.Configurations.INVALID_POS_PAYER_ATTEMPTS).property(this.toAccess((Property<?, ?>)ConfigurationDTO.INVALID_TOTP_ATTEMPTS), SystemKeys.Configurations.INVALID_TOTP_ATTEMPTS).property(this.toAccess((Property<?, ?>)ConfigurationDTO.INVALID_USERNAME_ATTEMPTS), SystemKeys.Configurations.INVALID_USERNAME_ATTEMPTS).property(this.toAccess((Property<?, ?>)ConfigurationDTO.MAX_BLOCKED_USERS), SystemKeys.Configurations.MAX_BLOCKED_USERS).property(this.toAccess((Property<?, ?>)ConfigurationDTO.JPEG_QUALITY), SystemKeys.Configurations.JPEG_QUALITY).property(this.toAccess((Property<?, ?>)ConfigurationDTO.LAND_LINE_ENABLE_EXTENSION), SystemKeys.Configurations.LAND_LINE_ENABLE_EXTENSION).property(this.toAccess((Property<?, ?>)ConfigurationDTO.LAND_LINE_REQUIRED), SystemKeys.Configurations.LAND_LINE_REQUIRED).property(this.toAccess((Property<?, ?>)ConfigurationDTO.LIST_SEPARATOR), SystemKeys.Configurations.LIST_SEPARATOR).property(this.toAccess((Property<?, ?>)ConfigurationDTO.LOG_SERVICES_FOR_GUESTS), SystemKeys.Configurations.LOG_SERVICES_FOR_GUESTS).property(this.toAccess((Property<?, ?>)ConfigurationDTO.LOG_SERVICES_PARAMETERS), SystemKeys.Configurations.LOG_SERVICES_PARAMETERS).property(this.toAccess((Property<?, ?>)ConfigurationDTO.LOG_SERVICES_RESULTS), SystemKeys.Configurations.LOG_SERVICES_RESULTS).property(this.toAccess((Property<?, ?>)ConfigurationDTO.LOG_SERVICES_WRITES_ONLY), SystemKeys.Configurations.LOG_SERVICES_WRITES_ONLY).property(this.toAccess((Property<?, ?>)ConfigurationDTO.LOGIN_URL), SystemKeys.Configurations.LOGIN_URL).property(this.toAccess((Property<?, ?>)ConfigurationDTO.LOGOUT_URL), SystemKeys.Configurations.LOGOUT_URL).property(this.toAccess((Property<?, ?>)ConfigurationDTO.NOTIFY_LOGINS_ON_NEW_DEVICES), SystemKeys.Configurations.NOTIFY_LOGINS_ON_NEW_DEVICES).property(this.toAccess((Property<?, ?>)ConfigurationDTO.FRONTEND), SystemKeys.Configurations.FRONTEND).property(this.toAccess((Property<?, ?>)ConfigurationDTO.ALLOW_FRONTEND_SWITCHING), SystemKeys.Configurations.ALLOW_FRONTEND_SWITCHING).property(this.toAccess((Property<?, ?>)ConfigurationDTO.FRONTEND_TITLE), SystemKeys.Configurations.FRONTEND_TITLE).property(this.toAccess((Property<?, ?>)ConfigurationDTO.FRONTEND_MOBILE_TITLE), SystemKeys.Configurations.FRONTEND_MOBILE_TITLE).property(this.toAccess((Property<?, ?>)ConfigurationDTO.FRONTEND_MOBILE_MENU_TITLE), SystemKeys.Configurations.FRONTEND_MOBILE_MENU_TITLE).property(this.toAccess((Property<?, ?>)ConfigurationDTO.FRONTEND_MOBILE_LANDING_PAGE), SystemKeys.Configurations.FRONTEND_MOBILE_LANDING_PAGE_HOME).property(this.toAccess((Property<?, ?>)ConfigurationDTO.FRONTEND_MENU_BAR), SystemKeys.Configurations.FRONTEND_MENU_BAR).property(this.toAccess((Property<?, ?>)ConfigurationDTO.FRONTEND_DASHBOARD_ACCOUNTS), SystemKeys.Configurations.FRONTEND_DASHBOARD_ACCOUNTS).property(this.toAccess((Property<?, ?>)ConfigurationDTO.FRONTEND_DASHBOARD_USERS), SystemKeys.Configurations.FRONTEND_DASHBOARD_USERS).property(this.toAccess((Property<?, ?>)ConfigurationDTO.FRONTEND_DASHBOARD_ADS), SystemKeys.Configurations.FRONTEND_DASHBOARD_ADS).property(this.toAccess((Property<?, ?>)ConfigurationDTO.MAP_BROWSER_API_KEY), SystemKeys.Configurations.MAP_BROWSER_API_KEY).property(this.toAccess((Property<?, ?>)ConfigurationDTO.MAP_DIRECTORY_FIELD), SystemKeys.Configurations.MAP_DIRECTORY_FIELD).property(this.toAccess((Property<?, ?>)ConfigurationDTO.MAP_SERVER_API_KEY), SystemKeys.Configurations.MAP_SERVER_API_KEY).property(this.toAccess((Property<?, ?>)ConfigurationDTO.MARKETPLACE_MENU_LABEL), SystemKeys.Configurations.MARKETPLACE_MENU_LABEL).property(this.toAccess((Property<?, ?>)ConfigurationDTO.MAX_GUEST_TEMP_IMAGES), SystemKeys.Configurations.MAX_GUEST_TEMP_IMAGES).property(this.toAccess((Property<?, ?>)ConfigurationDTO.MAX_IMAGE_DIMENSIONS), SystemKeys.Configurations.MAX_IMAGE_DIMENSIONS).property(this.toAccess((Property<?, ?>)ConfigurationDTO.MAX_LEFT_BANNERS), SystemKeys.Configurations.MAX_LEFT_BANNERS).property(this.toAccess((Property<?, ?>)ConfigurationDTO.MAX_LOG_ENTRIES), SystemKeys.Configurations.MAX_LOG_ENTRIES).property(this.toAccess((Property<?, ?>)ConfigurationDTO.MAX_MEDIUM_THUMB_DIMENSIONS), SystemKeys.Configurations.MAX_MEDIUM_THUMB_DIMENSIONS).property(this.toAccess((Property<?, ?>)ConfigurationDTO.MAX_PNG_SIZE), SystemKeys.Configurations.MAX_PNG_SIZE).property(this.toAccess((Property<?, ?>)ConfigurationDTO.MAX_RESULTS), SystemKeys.Configurations.MAX_RESULTS).property(this.toAccess((Property<?, ?>)ConfigurationDTO.MAX_RESULTS_ON_MAP), SystemKeys.Configurations.MAX_RESULTS_ON_MAP).property(this.toAccess((Property<?, ?>)ConfigurationDTO.MAX_RIGHT_BANNERS), SystemKeys.Configurations.MAX_RIGHT_BANNERS).property(this.toAccess((Property<?, ?>)ConfigurationDTO.MAX_SMALL_THUMB_DIMENSIONS), SystemKeys.Configurations.MAX_SMALL_THUMB_DIMENSIONS).property(this.toAccess((Property<?, ?>)ConfigurationDTO.MAX_TINY_THUMB_DIMENSIONS), SystemKeys.Configurations.MAX_TINY_THUMB_DIMENSIONS).property(this.toAccess((Property<?, ?>)ConfigurationDTO.MAX_UPLOAD_SIZE), SystemKeys.Configurations.MAX_UPLOAD_SIZE).property(this.toAccess((Property<?, ?>)ConfigurationDTO.MAX_USER_TEMP_IMAGES), SystemKeys.Configurations.MAX_USER_TEMP_IMAGES).property(this.toAccess((Property<?, ?>)ConfigurationDTO.MOBILE_REQUIRED), SystemKeys.Configurations.MOBILE_REQUIRED).property(this.toAccess((Property<?, ?>)ConfigurationDTO.MOBILE_UNIQUE), SystemKeys.Configurations.MOBILE_UNIQUE).property(this.toAccess((Property<?, ?>)ConfigurationDTO.NUMBER_FORMAT), SystemKeys.Configurations.NUMBER_FORMAT).property(this.toAccess((Property<?, ?>)ConfigurationDTO.MAP_PREFERENCE_MOBILE), SystemKeys.Configurations.MAP_PREFERENCE_MOBILE).property(this.toAccess((Property<?, ?>)ConfigurationDTO.PATH), SystemKeys.Configurations.PATH).property(this.toAccess((Property<?, ?>)ConfigurationDTO.PLAY_STORE_URL_MOBILE), SystemKeys.Configurations.PLAY_STORE_URL_MOBILE).property(this.toAccess((Property<?, ?>)ConfigurationDTO.POSSIBLE_INITIAL_GROUPS), SystemKeys.Configurations.POSSIBLE_INITIAL_GROUPS).property(this.toAccess((Property<?, ?>)ConfigurationDTO.LARGE_SCREEN_REGISTRATION_WIZARD), SystemKeys.Configurations.LARGE_SCREEN_REGISTRATION_WIZARD).property(this.toAccess((Property<?, ?>)ConfigurationDTO.MEDIUM_SCREEN_REGISTRATION_WIZARD), SystemKeys.Configurations.MEDIUM_SCREEN_REGISTRATION_WIZARD).property(this.toAccess((Property<?, ?>)ConfigurationDTO.SMALL_SCREEN_REGISTRATION_WIZARD), SystemKeys.Configurations.SMALL_SCREEN_REGISTRATION_WIZARD).property(this.toAccess((Property<?, ?>)ConfigurationDTO.PRIVACY_CONTROLLED_PROFILE_FIELDS), SystemKeys.Configurations.PRIVACY_CONTROLLED_PROFILE_FIELDS).property(this.toAccess((Property<?, ?>)ConfigurationDTO.PROFILE_FIELD_IN_ACCOUNT_TITLE), SystemKeys.Configurations.PROFILE_FIELDS_ACCOUNT_TITLE).property(this.toAccess((Property<?, ?>)ConfigurationDTO.PROFILE_FIELDS_IN_ACCOUNT), SystemKeys.Configurations.PROFILE_FIELDS_IN_ACCOUNT).property(this.toAccess((Property<?, ?>)ConfigurationDTO.RECEIVED_VERY_BAD_REFS), SystemKeys.Configurations.RECEIVED_VERY_BAD_REFS).property(this.toAccess((Property<?, ?>)ConfigurationDTO.REGEX_FOR_USERNAME), SystemKeys.Configurations.REGEX_FOR_USERNAME).property(this.toAccess((Property<?, ?>)ConfigurationDTO.REMOTE_ADDRESS_BLOCK_TIME), SystemKeys.Configurations.REMOTE_ADDRESS_BLOCK_TIME).property(this.toAccess((Property<?, ?>)ConfigurationDTO.REMOTE_ADDRESS_BLOCK_TIME_BY_BLOCKED_USERS), SystemKeys.Configurations.REMOTE_ADDRESS_BLOCK_TIME_BY_BLOCKED_USERS).property(this.toAccess((Property<?, ?>)ConfigurationDTO.REQUIRED_ADDRESS), SystemKeys.Configurations.REQUIRED_ADDRESS).property(this.toAccess((Property<?, ?>)ConfigurationDTO.ROOT_URL), SystemKeys.Configurations.ROOT_URL).property(this.toAccess((Property<?, ?>)ConfigurationDTO.API_URL), SystemKeys.Configurations.API_URL).property(this.toAccess((Property<?, ?>)ConfigurationDTO.SKIP_TOTAL_COUNT), SystemKeys.Configurations.SKIP_TOTAL_COUNT).property(this.toAccess((Property<?, ?>)ConfigurationDTO.SKIP_PRODUCTS_VIEW), SystemKeys.Configurations.SKIP_PRODUCTS_VIEW).property(this.toAccess((Property<?, ?>)ConfigurationDTO.TIME_FORMAT), SystemKeys.Configurations.TIME_FORMAT).property(this.toAccess((Property<?, ?>)ConfigurationDTO.TIME_ZONE_ID), SystemKeys.Configurations.TIME_ZONE_ID).property(this.toAccess((Property<?, ?>)ConfigurationDTO.USE_LEFT_SPACE_FOR_GUESTS), SystemKeys.Configurations.USE_LEFT_SPACE_FOR_GUESTS).property(this.toAccess((Property<?, ?>)ConfigurationDTO.USE_MAP), SystemKeys.Configurations.USE_MAP).property(this.toAccess((Property<?, ?>)ConfigurationDTO.USERNAME_LENGTH), SystemKeys.Configurations.USERNAME_LENGTH).property(this.toAccess((Property<?, ?>)ConfigurationDTO.USERS_MENU_TYPE), SystemKeys.Configurations.USERS_MENU_TYPE).property(this.toAccess((Property<?, ?>)ConfigurationDTO.USERS_RESULT_TYPE), SystemKeys.Configurations.USERS_RESULT_TYPE).property(this.toAccess((Property<?, ?>)ConfigurationDTO.VISIBLE_AD_CATEGORIES), SystemKeys.Configurations.VISIBLE_AD_CATEGORIES).property(this.toAccess((Property<?, ?>)ConfigurationDTO.VISIBLE_AD_CURRENCIES), SystemKeys.Configurations.VISIBLE_AD_CURRENCIES).property(this.toAccess((Property<?, ?>)ConfigurationDTO.VISIBLE_AD_GROUPS), SystemKeys.Configurations.VISIBLE_AD_GROUPS).property(this.toAccess((Property<?, ?>)ConfigurationDTO.VOUCHER_BUYING_MENU), SystemKeys.Configurations.VOUCHER_BUYING_MENU).property(this.toAccess((Property<?, ?>)ConfigurationDTO.PARENT), SystemKeys.Configurations.PARENT).property(this.toAccess((Property<?, ?>)ConfigurationDTO.ADDRESS_CONFIGURATION), SystemKeys.Configurations.ADDRESS_CONFIGURATION).nested((Property)ConfigurationDTO.ADDRESS_CONFIGURATION, null, this::toAccess).property((Property)AddressConfigurationDTO.ENABLED_ADDRESS_FIELDS, SystemKeys.Configurations.ADDRESS_FIELDS).property((Property)AddressConfigurationDTO.REQUIRED_ADDRESS_FIELDS, SystemKeys.Configurations.REQUIRED_ADDRESS_FIELDS).addNested().property(this.toAccess((Property<?, ?>)ConfigurationDTO.SMTP_CONFIGURATION), SystemKeys.Configurations.SMTP_CONFIGURATION).nested((Property)ConfigurationDTO.SMTP_CONFIGURATION, null, this::toAccess).property((Property)SmtpConfigurationDTO.FROM_ADDRESS, SystemKeys.Configurations.SMTP_FROM_ADDRESS).property((Property)SmtpConfigurationDTO.USER, SystemKeys.Configurations.SMTP_USER).property((Property)SmtpConfigurationDTO.PASSWORD, SystemKeys.Configurations.SMTP_PASSWORD).property((Property)SmtpConfigurationDTO.HOST, SystemKeys.Configurations.SMTP_HOST).property((Property)SmtpConfigurationDTO.PORT, SystemKeys.Configurations.SMTP_PORT).property((Property)SmtpConfigurationDTO.MAX_RECIPIENTS, SystemKeys.Configurations.SMTP_MAX_RECIPIENTS).property((Property)SmtpConfigurationDTO.SECURITY, SystemKeys.Configurations.SMTP_SECURITY).ignore((Property)SmtpConfigurationDTO.PASSWORD_SET).addNested().property(this.toAccess((Property<?, ?>)ConfigurationDTO.CAPTCHA_CONFIGURATION), SystemKeys.Configurations.SECTION_CAPTCHA).nested((Property)ConfigurationDTO.CAPTCHA_CONFIGURATION, null, this::toAccess).property((Property)CaptchaConfigurationDTO.PROVIDER, SystemKeys.Configurations.CAPTCHA_PROVIDER).property((Property)CaptchaConfigurationDTO.TEXT_LENGTH, SystemKeys.Configurations.CAPTCHA_TEXT_LENGTH).property((Property)CaptchaConfigurationDTO.TEXT_COLOR, SystemKeys.Configurations.CAPTCHA_TEXT_COLOR).property((Property)CaptchaConfigurationDTO.EFFECT, SystemKeys.Configurations.CAPTCHA_EFFECT).property((Property)CaptchaConfigurationDTO.USE_ON_PUBLIC_REGISTRATION, SystemKeys.Configurations.CAPTCHA_ON_PUBLIC_REGISTRATION).property((Property)CaptchaConfigurationDTO.USE_ON_FORGOT_PASSWORD, SystemKeys.Configurations.CAPTCHA_ON_FORGOT_PASSWORD).property((Property)CaptchaConfigurationDTO.RECAPTCHA_KEY, SystemKeys.Configurations.CAPTCHA_RECAPTCHA_KEY).property((Property)CaptchaConfigurationDTO.RECAPTCHA_SECRET, SystemKeys.Configurations.CAPTCHA_RECAPTCHA_SECRET).ignore((Property)CaptchaConfigurationDTO.RECAPTCHA_SECRET_SET).addNested().property(this.toAccess((Property<?, ?>)ConfigurationDTO.DYNAMIC_OIDC_CLIENT_CONFIGURATION), SystemKeys.Configurations.DYNA_OIDC_CLIENTS).nested((Property)ConfigurationDTO.DYNAMIC_OIDC_CLIENT_CONFIGURATION, null, this::toAccess).property((Property)DynamicOidcClientConfigurationDTO.ENABLED, SystemKeys.Configurations.DYNA_OIDC_ENABLED).property((Property)DynamicOidcClientConfigurationDTO.ALLOW_UNENCRYPTED_URIS, SystemKeys.Configurations.DYNA_OIDC_ALLOW_UNENCRYPTED_URIS).property((Property)DynamicOidcClientConfigurationDTO.SCOPES, AccessKeys.OidcClients.SCOPES).property((Property)DynamicOidcClientConfigurationDTO.ACCOUNTS, AccessKeys.OidcClients.ACCOUNTS).property((Property)DynamicOidcClientConfigurationDTO.PAYMENTS, AccessKeys.OidcClients.PAYMENTS).property((Property)DynamicOidcClientConfigurationDTO.TICKETS, AccessKeys.OidcClients.TICKETS).property((Property)DynamicOidcClientConfigurationDTO.SINGLE_PAYMENT_PER_CONSENT, AccessKeys.OidcClients.SINGLE_PAYMENT_PER_CONSENT).property((Property)DynamicOidcClientConfigurationDTO.ACCESS_TOKEN_EXPIRATION, AccessKeys.OidcClients.ACCESS_TOKEN_EXPIRATION).addNested().property(this.toAccess((Property<?, ?>)ConfigurationDTO.USER_FORMAT_FOR_MANAGERS), SystemKeys.Configurations.USER_FORMAT_FOR_MANAGERS).nested((Property)ConfigurationDTO.USER_FORMAT_FOR_MANAGERS, SystemKeys.Configurations.USER_FORMAT_FOR_MANAGERS, this::toAccess).property((Property)UserFormatConfigurationDTO.PROFILE_FIELDS, SystemKeys.Configurations.USER_FORMAT_FIELDS).property((Property)UserFormatConfigurationDTO.SEPARATOR, SystemKeys.Configurations.USER_FORMAT_SEPARATOR).addNested().property(this.toAccess((Property<?, ?>)ConfigurationDTO.USER_FORMAT_FOR_OTHERS), SystemKeys.Configurations.USER_FORMAT_FOR_OTHERS).nested((Property)ConfigurationDTO.USER_FORMAT_FOR_OTHERS, SystemKeys.Configurations.USER_FORMAT_FOR_OTHERS, this::toAccess).property((Property)UserFormatConfigurationDTO.PROFILE_FIELDS, SystemKeys.Configurations.USER_FORMAT_FIELDS).property((Property)UserFormatConfigurationDTO.SEPARATOR, SystemKeys.Configurations.USER_FORMAT_SEPARATOR).addNested().property(this.toAccess((Property<?, ?>)ConfigurationDTO.OUTBOUND_SMS_CONFIGURATION), SystemKeys.Configurations.OUTBOUND_SMS).nested((Property)ConfigurationDTO.OUTBOUND_SMS_CONFIGURATION, null, this::toAccess).property((Property)OutboundSmsConfigurationDTO.ASCII_ONLY, SystemKeys.Configurations.SMS_ASCII_ONLY).property((Property)OutboundSmsConfigurationDTO.ENCODING, SystemKeys.Configurations.SMS_ENCODING).property((Property)OutboundSmsConfigurationDTO.ENABLED, SystemKeys.Configurations.SMS_ENABLED).property((Property)OutboundSmsConfigurationDTO.GATEWAY_URL, SystemKeys.Configurations.SMS_GATEWAY_URL).property((Property)OutboundSmsConfigurationDTO.HEADERS, SystemKeys.Configurations.SMS_HEADERS).property((Property)OutboundSmsConfigurationDTO.MAX_MESSAGES_PER_MONTH, SystemKeys.Configurations.SMS_MAX_MESSAGES_PER_MONTH).property((Property)OutboundSmsConfigurationDTO.MAX_MESSAGES_TO_UNREGISTERED, SystemKeys.Configurations.SMS_MAX_MESSAGES_TO_UNREGISTERED).property((Property)OutboundSmsConfigurationDTO.PASSWORD, SystemKeys.Configurations.SMS_PASSWORD).property((Property)OutboundSmsConfigurationDTO.REQUEST_TYPE, SystemKeys.Configurations.SMS_REQUEST_TYPE).property((Property)OutboundSmsConfigurationDTO.POST_BODY, SystemKeys.Configurations.SMS_POST_BODY).property((Property)OutboundSmsConfigurationDTO.SCRIPT, SystemKeys.Configurations.SMS_SCRIPT).property((Property)OutboundSmsConfigurationDTO.SCRIPT_PARAMETERS, SystemKeys.Configurations.SMS_SCRIPT_PARAMETERS).property((Property)OutboundSmsConfigurationDTO.USERNAME, SystemKeys.Configurations.SMS_USERNAME).ignore((Property)OutboundSmsConfigurationDTO.PASSWORD_SET).addNested().property(this.toAccess((Property<?, ?>)ConfigurationDTO.ACCOUNT_NUMBER_CONFIGURATION), SystemKeys.Configurations.ACCOUNT_NUMBER).nested((Property)ConfigurationDTO.ACCOUNT_NUMBER_CONFIGURATION, null, this::toAccess).property((Property)AccountNumberConfigurationDTO.ENABLED, SystemKeys.Configurations.ACCOUNT_NUMBER_ENABLED).property((Property)AccountNumberConfigurationDTO.MASK, SystemKeys.Configurations.ACCOUNT_NUMBER_MASK).property((Property)AccountNumberConfigurationDTO.SCRIPT, SystemKeys.Configurations.ACCOUNT_NUMBER_SCRIPT).property((Property)AccountNumberConfigurationDTO.SCRIPT_PARAMETERS, SystemKeys.Configurations.ACCOUNT_NUMBER_SCRIPT_PARAMETERS).addNested().property(this.toAccess((Property<?, ?>)ConfigurationDTO.CUSTOM_SESSION_CONFIGURATION), SystemKeys.Configurations.CUSTOM_SESSION).nested((Property)ConfigurationDTO.CUSTOM_SESSION_CONFIGURATION, SystemKeys.Configurations.CUSTOM_SESSION, this::toAccess).property((Property)CustomSessionConfigurationDTO.ENABLED, SystemKeys.Configurations.CUSTOM_SESSION_ENABLED).property((Property)CustomSessionConfigurationDTO.SCRIPT, SystemKeys.Configurations.CUSTOM_SESSION_SCRIPT).property((Property)CustomSessionConfigurationDTO.SCRIPT_PARAMETERS, SystemKeys.Configurations.CUSTOM_SESSION_SCRIPT_PARAMETERS).addNested().property(this.toAccess((Property<?, ?>)ConfigurationDTO.LINK_GENERATION_CONFIGURATION), SystemKeys.Configurations.LINK_GENERATION).nested((Property)ConfigurationDTO.LINK_GENERATION_CONFIGURATION, null, this::toAccess).property((Property)CustomScriptConfigurationDTO.SCRIPT, SystemKeys.Configurations.LINK_GENERATION_SCRIPT).property((Property)CustomScriptConfigurationDTO.SCRIPT_PARAMETERS, SystemKeys.Configurations.LINK_GENERATION_SCRIPT_PARAMETERS).addNested().nested((Property)ConfigurationDTO.PHONE_NUMBER_HANDLING_CONFIGURATION, null, this::toAccess).property((Property)CustomScriptConfigurationDTO.SCRIPT, SystemKeys.Configurations.PHONE_NUMBER_HANDLING_SCRIPT).property((Property)CustomScriptConfigurationDTO.SCRIPT_PARAMETERS, SystemKeys.Configurations.PHONE_NUMBER_HANDLING_SCRIPT_PARAMETERS).addNested().property(this.toAccess((Property<?, ?>)ConfigurationDTO.IP_GEOLOCATION_CONFIGURATION), SystemKeys.Configurations.IP_GEOLOCATION).nested((Property)ConfigurationDTO.IP_GEOLOCATION_CONFIGURATION, null, this::toAccess).property((Property)IpGeolocationConfigurationDTO.SCRIPT, SystemKeys.Configurations.IP_GEOLOCATION_SCRIPT).property((Property)IpGeolocationConfigurationDTO.SCRIPT_PARAMETERS, SystemKeys.Configurations.IP_GEOLOCATION_SCRIPT_PARAMETERS).property((Property)IpGeolocationConfigurationDTO.EXPIRATION, SystemKeys.Configurations.IP_GEOLOCATION_EXPIRATION).addNested().property(this.toAccess((Property<?, ?>)ConfigurationDTO.NOTIFICATION_CONFIGURATION), SystemKeys.Configurations.NOTIFICATION).nested((Property)ConfigurationDTO.NOTIFICATION_CONFIGURATION, null, this::toAccess).property((Property)CustomScriptConfigurationDTO.SCRIPT, SystemKeys.Configurations.NOTIFICATION_SCRIPT).property((Property)CustomScriptConfigurationDTO.SCRIPT_PARAMETERS, SystemKeys.Configurations.NOTIFICATION_SCRIPT_PARAMETERS).addNested().property(this.toAccess((Property<?, ?>)ConfigurationDTO.GUEST_PROFILE_FIELDS), SystemKeys.Configurations.GUEST_PROFILE_FIELDS).ignore((Property)ConfigurationDTO.DEFINE_ROOT_URL).ignore((Property)ConfigurationDTO.MAP_SERVER_API_KEY_SET).ignore((Property)ConfigurationDTO.LOCKED_PROPERTIES).ignore((Property)ConfigurationDTO.DEFINED_PROPERTIES).ignore((Property)ConfigurationDTO.GLOBAL);
    }

    @Override
    protected List<EntityPropertyLog> doOnBeforeLog(Configuration configuration, Configuration configuration2, List<EntityPropertyLog> list, EntityLogEvent entityLogEvent) {
        boolean bl = entityLogEvent == EntityLogEvent.CREATE;
        boolean bl2 = entityLogEvent == EntityLogEvent.DELETE;
        boolean bl3 = entityLogEvent == EntityLogEvent.UPDATE;
        List<EntityPropertyLog> list2 = list.stream().filter(entityPropertyLog -> {
            boolean bl4;
            String string = this.getConfigurationPropertyName(entityPropertyLog.getPropertyName());
            boolean bl5 = bl4 = bl3 || bl && (!this.isDefinable(string) || this.isDefined(configuration2, string)) || bl2 && (!this.isDefinable(string) || this.isDefined(configuration, string));
            if (!bl4) {
                return false;
            }
            if (this.isMasteredNestedBeanProperty(string, entityPropertyLog.getPropertyName(), (Property<?, ?>)ConfigurationDTO.OUTBOUND_SMS_CONFIGURATION, (Property<?, ?>)OutboundSmsConfigurationDTO.ENABLED)) {
                boolean bl6 = configuration != null && configuration.getOutboundSmsConfiguration() != null && configuration.getOutboundSmsConfiguration().isEnabled();
                boolean bl7 = configuration2 != null && configuration2.getOutboundSmsConfiguration() != null && configuration2.getOutboundSmsConfiguration().isEnabled();
                return bl3 && (bl6 || bl7) || bl && bl7 || bl2 && bl6;
            }
            if (this.isMasteredNestedBeanProperty(string, entityPropertyLog.getPropertyName(), (Property<?, ?>)ConfigurationDTO.LINK_GENERATION_CONFIGURATION, (Property<?, ?>)CustomScriptConfigurationDTO.SCRIPT)) {
                boolean bl8 = configuration != null && configuration.getLinkGenerationConfiguration() != null && configuration.getLinkGenerationConfiguration().getScript() != null;
                boolean bl9 = configuration2 != null && configuration2.getLinkGenerationConfiguration() != null && configuration2.getLinkGenerationConfiguration().getScript() != null;
                return bl3 && (bl8 || bl9) || bl && bl9 || bl2 && bl8;
            }
            if (this.isMasteredNestedBeanProperty(string, entityPropertyLog.getPropertyName(), (Property<?, ?>)ConfigurationDTO.PHONE_NUMBER_HANDLING_CONFIGURATION, (Property<?, ?>)CustomScriptConfigurationDTO.SCRIPT)) {
                boolean bl10 = configuration != null && configuration.getPhoneNumberHandlingConfiguration() != null && configuration.getPhoneNumberHandlingConfiguration().getScript() != null;
                boolean bl11 = configuration2 != null && configuration2.getPhoneNumberHandlingConfiguration() != null && configuration2.getPhoneNumberHandlingConfiguration().getScript() != null;
                return bl3 && (bl10 || bl11) || bl && bl11 || bl2 && bl10;
            }
            if (this.isMasteredNestedBeanProperty(string, entityPropertyLog.getPropertyName(), (Property<?, ?>)ConfigurationDTO.IP_GEOLOCATION_CONFIGURATION, (Property<?, ?>)CustomScriptConfigurationDTO.SCRIPT)) {
                boolean bl12 = configuration != null && configuration.getIpGeolocationConfiguration() != null && configuration.getIpGeolocationConfiguration().getScript() != null;
                boolean bl13 = configuration2 != null && configuration2.getIpGeolocationConfiguration() != null && configuration2.getIpGeolocationConfiguration().getScript() != null;
                return bl3 && (bl12 || bl13) || bl && bl13 || bl2 && bl12;
            }
            if (this.isMasteredNestedBeanProperty(string, entityPropertyLog.getPropertyName(), (Property<?, ?>)ConfigurationDTO.NOTIFICATION_CONFIGURATION, (Property<?, ?>)CustomScriptConfigurationDTO.SCRIPT)) {
                boolean bl14 = configuration != null && configuration.getNotificationConfiguration() != null && configuration.getNotificationConfiguration().getScript() != null;
                boolean bl15 = configuration2 != null && configuration2.getNotificationConfiguration() != null && configuration2.getNotificationConfiguration().getScript() != null;
                return bl3 && (bl14 || bl15) || bl && bl15 || bl2 && bl14;
            }
            if (this.isMasteredNestedBeanProperty(string, entityPropertyLog.getPropertyName(), (Property<?, ?>)ConfigurationDTO.ACCOUNT_NUMBER_CONFIGURATION, (Property<?, ?>)AccountNumberConfigurationDTO.ENABLED)) {
                boolean bl16 = configuration != null && configuration.getAccountNumberConfiguration() != null && configuration.getAccountNumberConfiguration().isEnabled();
                boolean bl17 = configuration2 != null && configuration2.getAccountNumberConfiguration() != null && configuration2.getAccountNumberConfiguration().isEnabled();
                return bl3 && (bl16 || bl17) || bl && bl17 || bl2 && bl16;
            }
            if (this.isMasteredNestedBeanProperty(string, entityPropertyLog.getPropertyName(), (Property<?, ?>)ConfigurationDTO.CUSTOM_SESSION_CONFIGURATION, (Property<?, ?>)CustomSessionConfigurationDTO.ENABLED)) {
                boolean bl18 = configuration != null && configuration.getCustomSessionConfiguration() != null && configuration.getCustomSessionConfiguration().isEnabled();
                boolean bl19 = configuration2 != null && configuration2.getCustomSessionConfiguration() != null && configuration2.getCustomSessionConfiguration().isEnabled();
                return bl3 && (bl18 || bl19) || bl && bl19 || bl2 && bl18;
            }
            return true;
        }).peek(entityPropertyLog -> {
            String string = this.getConfigurationPropertyName(entityPropertyLog.getPropertyName());
            if (configuration != null && this.isDefinable(string) && !this.isDefined(configuration, string)) {
                entityPropertyLog.setOldValue(this.message(SystemKeys.Configurations.PROPERTY_NOT_DEFINED, new Object[0]));
            }
            if (configuration2 != null && this.isDefinable(string) && !this.isDefined(configuration2, string)) {
                entityPropertyLog.setNewValue(this.message(SystemKeys.Configurations.PROPERTY_NOT_DEFINED, new Object[0]));
            }
            if (!this.isNestedBeanProperty(string)) {
                if (configuration != null && configuration.getLockedProperties().contains(string)) {
                    entityPropertyLog.setOldValue(this.message(SystemKeys.Configurations.PROPERTY_LOCKED, entityPropertyLog.getOldValue()));
                }
                if (configuration2 != null && configuration2.getLockedProperties().contains(string)) {
                    entityPropertyLog.setNewValue(this.message(SystemKeys.Configurations.PROPERTY_LOCKED, entityPropertyLog.getNewValue()));
                }
            }
        }).collect(Collectors.toList());
        return this.handleGuestProfileFields(configuration, configuration2, entityLogEvent, list2);
    }

    @Override
    protected Configuration getEntityToViewLog(long l) {
        return this.hasPermission(Permission.SYSTEM_CONFIGURATION_VIEW) ? this.find(Configuration.class, l) : null;
    }

    private EntityPropertyLog addPropertyLog(String string, ProfileField profileField, String string2, String string3, List<EntityPropertyLog> list) {
        String string4 = string + " - " + this.getFormatter().format(profileField);
        String string5 = ConfigurationGuestProfileFieldDTO.PROFILE_FIELD.getName();
        EntityPropertyLog entityPropertyLog = this.createEntityPropertyLog(string4, string5, string2, string3);
        entityPropertyLog.setOrder(Integer.valueOf(list.size()));
        list.add(entityPropertyLog);
        return entityPropertyLog;
    }

    private String format(ConfigurationGuestProfileField configurationGuestProfileField) {
        StringBuilder stringBuilder = new StringBuilder();
        BiConsumer<Boolean, MessageKey> biConsumer = (bl, messageKey) -> {
            if (bl.booleanValue()) {
                stringBuilder.append(this.message((MessageKey)messageKey, new Object[0])).append(", ");
            }
        };
        biConsumer.accept(configurationGuestProfileField.isVisible(), UsersKeys.Products.USER_PROFILE_FIELDS_VIEW);
        biConsumer.accept(configurationGuestProfileField.isUserFilter(), UsersKeys.Products.USER_PROFILE_FIELDS_USER_FILTER);
        biConsumer.accept(configurationGuestProfileField.isUserList(), UsersKeys.Products.USER_PROFILE_FIELDS_USER_LIST);
        biConsumer.accept(configurationGuestProfileField.isUserKeywords(), UsersKeys.Products.USER_PROFILE_FIELDS_USER_KEYWORDS);
        biConsumer.accept(configurationGuestProfileField.isMapFilter(), UsersKeys.Products.USER_PROFILE_FIELDS_MAP_FILTER);
        biConsumer.accept(configurationGuestProfileField.isMapResult(), UsersKeys.Products.USER_PROFILE_FIELDS_MAP_RESULT);
        biConsumer.accept(configurationGuestProfileField.isAdFilter(), UsersKeys.Products.USER_PROFILE_FIELDS_AD_FILTER);
        biConsumer.accept(configurationGuestProfileField.isAdKeywords(), UsersKeys.Products.USER_PROFILE_FIELDS_AD_KEYWORDS);
        if (stringBuilder.length() > 0) {
            stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
        }
        return stringBuilder.toString();
    }

    private String getConfigurationPropertyName(String string) {
        if (ConfigurationGuestProfileFieldDTO.PROFILE_FIELD.getName().equals(string)) {
            return ConfigurationDTO.GUEST_PROFILE_FIELDS.getName();
        }
        return (String)StringHelper.split((String)string, (String)".").get(0);
    }

    private List<EntityPropertyLog> handleGuestProfileFields(Configuration configuration, Configuration configuration2, EntityLogEvent entityLogEvent, List<EntityPropertyLog> list) {
        boolean bl;
        String string = ConfigurationDTO.GUEST_PROFILE_FIELDS.getName();
        boolean bl2 = entityLogEvent == EntityLogEvent.CREATE;
        boolean bl3 = entityLogEvent == EntityLogEvent.DELETE;
        boolean bl4 = entityLogEvent == EntityLogEvent.UPDATE;
        boolean bl5 = bl = bl4 || bl2 && configuration2.getDefinedProperties().contains(string) || bl3 && configuration.getDefinedProperties().contains(string);
        if (!bl) {
            return list;
        }
        String string2 = this.message(SystemKeys.Configurations.GUEST_PROFILE_FIELDS, new Object[0]);
        if (bl2) {
            CollectionHelper.sort((Collection)configuration2.getGuestProfileFields(), Comparator.comparing(ConfigurationGuestProfileField::getProfileField, ProfileFieldComparator.getInstance())).forEach(configurationGuestProfileField -> {
                EntityPropertyLog entityPropertyLog = this.addPropertyLog(string2, configurationGuestProfileField.getProfileField(), null, this.format((ConfigurationGuestProfileField)configurationGuestProfileField), list);
                if (!this.isDefined(configuration2, string)) {
                    entityPropertyLog.setNewValue(this.message(SystemKeys.Configurations.PROPERTY_NOT_DEFINED, new Object[0]));
                }
            });
        } else if (bl3) {
            CollectionHelper.sort((Collection)configuration.getGuestProfileFields(), Comparator.comparing(ConfigurationGuestProfileField::getProfileField, ProfileFieldComparator.getInstance())).forEach(configurationGuestProfileField -> {
                EntityPropertyLog entityPropertyLog = this.addPropertyLog(string2, configurationGuestProfileField.getProfileField(), this.format((ConfigurationGuestProfileField)configurationGuestProfileField), null, list);
                if (!this.isDefined(configuration, string)) {
                    entityPropertyLog.setOldValue(this.message(SystemKeys.Configurations.PROPERTY_NOT_DEFINED, new Object[0]));
                }
            });
        } else if (!CollectionHelper.isEmpty((Iterable)configuration.getGuestProfileFields()) || !CollectionHelper.isEmpty((Iterable)configuration2.getGuestProfileFields())) {
            Map<ProfileField, ConfigurationGuestProfileField> map = this.toMap(configuration.getGuestProfileFields());
            Map<ProfileField, ConfigurationGuestProfileField> map2 = this.toMap(configuration2.getGuestProfileFields());
            TreeMap treeMap = new TreeMap(ProfileFieldComparator.getInstance());
            map.entrySet().stream().forEach(entry -> {
                ConfigurationGuestProfileField configurationGuestProfileField = (ConfigurationGuestProfileField)map2.get(entry.getKey());
                if (configurationGuestProfileField == null) {
                    treeMap.put((ProfileField)entry.getKey(), Pair.create((Object)this.format((ConfigurationGuestProfileField)entry.getValue()), null));
                } else if (!((ConfigurationGuestProfileField)entry.getValue()).sameContent(configurationGuestProfileField)) {
                    treeMap.put((ProfileField)entry.getKey(), Pair.create((Object)this.format((ConfigurationGuestProfileField)entry.getValue()), (Object)this.format(configurationGuestProfileField)));
                }
            });
            map2.entrySet().stream().forEach(entry -> {
                if (!map.containsKey(entry.getKey())) {
                    treeMap.put((ProfileField)entry.getKey(), Pair.create(null, (Object)this.format((ConfigurationGuestProfileField)entry.getValue())));
                }
            });
            treeMap.entrySet().stream().forEach(entry -> {
                EntityPropertyLog entityPropertyLog = this.addPropertyLog(string2, (ProfileField)entry.getKey(), (String)((Pair)entry.getValue()).getFirst(), (String)((Pair)entry.getValue()).getSecond(), list);
                if (!this.isDefined(configuration, string)) {
                    entityPropertyLog.setOldValue(this.message(SystemKeys.Configurations.PROPERTY_NOT_DEFINED, new Object[0]));
                }
                if (!this.isDefined(configuration2, string)) {
                    entityPropertyLog.setNewValue(this.message(SystemKeys.Configurations.PROPERTY_NOT_DEFINED, new Object[0]));
                }
            });
        }
        return list;
    }

    private boolean isDefinable(String string) {
        return this.configurationHandler.getConfigurableProperties().contains(string) || ConfigurationDTO.ROOT_URL.getName().equals(string);
    }

    private boolean isDefined(Configuration configuration, String string) {
        return configuration.getDefinedProperties().contains(string) || ConfigurationDTO.ROOT_URL.getName().equals(string) && configuration.isDefineRootUrl();
    }

    private boolean isMasteredNestedBeanProperty(String string, String string2, Property<?, ?> property, Property<?, ?> property2) {
        return !string.equals(string2) && property.getName().equals(string) && !NestedProperty.nested(property, property2).getName().equals(string2);
    }

    private boolean isNestedBeanProperty(String string) {
        return NESTED_BEAN_PROPERTIES.contains(string);
    }

    private PropertyAccess toAccess(Property<?, ?> property) {
        return new ConfigurationPropertyAccess(property);
    }

    private Map<ProfileField, ConfigurationGuestProfileField> toMap(Set<ConfigurationGuestProfileField> set) {
        return CollectionHelper.asStream(set).collect(Collectors.toMap(ConfigurationGuestProfileField::getProfileField, Function.identity()));
    }

    private class ConfigurationPropertyAccess
    extends BeanPropertyAccess {
        private Property<?, ?> firstProperty;

        public ConfigurationPropertyAccess(Property<?, ?> property) {
            super(property);
            this.firstProperty = property instanceof NestedProperty ? (Property)((NestedProperty)property).getPath().get(0) : property;
        }

        public Object get(Object object) {
            Configuration configuration = (Configuration)object;
            String string = this.firstProperty.getName();
            if (ConfigurationEntityLogHandlerImpl.this.isNestedBeanProperty(this.getBeanProperty().getName())) {
                return configuration.getLockedProperties().contains(this.firstProperty.getName()) ? ConfigurationEntityLogHandlerImpl.this.message(SystemKeys.Configurations.PROPERTY_LOCKED, new Object[0]) : ConfigurationEntityLogHandlerImpl.this.message(SystemKeys.Configurations.PROPERTY_UNLOCKED, new Object[0]);
            }
            if (ConfigurationEntityLogHandlerImpl.this.isDefinable(string) && !ConfigurationEntityLogHandlerImpl.this.isDefined(configuration, string)) {
                return null;
            }
            if (ConfigurationDTO.COUNTRY.getName().equals(this.firstProperty.getName())) {
                return StringHelper.isBlank((Object)configuration.getCountry()) ? null : ((CountryVO)ConfigurationEntityLogHandlerImpl.this.conversionHandler.convert(CountryVO.class, (Object)configuration.getCountry())).getName();
            }
            return super.get(object);
        }
    }
}

