/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import java.util.List;
import org.cyclos.entities.system.ChannelConfiguration;
import org.cyclos.entities.system.EntityPropertyLog;
import org.cyclos.entities.system.SmsChannelConfiguration;
import org.cyclos.impl.EntityLogDescriptor;
import org.cyclos.impl.PropertyLogDescriptor;
import org.cyclos.impl.system.BaseEntityLogHandlerImpl;
import org.cyclos.impl.system.EntityLogHelper;
import org.cyclos.model.Property;
import org.cyclos.model.access.Permission;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.channelconfigurations.ChannelConfigurationDTO;
import org.cyclos.model.system.channelconfigurations.CredentialsConfigurationDTO;
import org.cyclos.model.system.channelconfigurations.PaymentPrincipalsConfigurationDTO;
import org.cyclos.model.system.channelconfigurations.PinChannelConfigurationDTO;
import org.cyclos.model.system.channelconfigurations.SmsChannelConfigurationDTO;
import org.cyclos.model.system.entitylogs.EntityLogEvent;
import org.cyclos.model.system.entitylogs.EntityLogType;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Pair;
import org.springframework.stereotype.Component;

@Component
public class ChannelConfigurationEntityLogHandlerImpl
extends BaseEntityLogHandlerImpl<ChannelConfiguration, ChannelConfigurationDTO> {
    @Override
    public List<EntityPropertyLog> doOnBeforeLog(ChannelConfiguration channelConfiguration, ChannelConfiguration channelConfiguration2, List<EntityPropertyLog> list, EntityLogEvent entityLogEvent) {
        if (!channelConfiguration2.isDefined() && channelConfiguration.isDefined()) {
            list.removeIf(entityPropertyLog -> !entityPropertyLog.getPropertyName().equals(SmsChannelConfigurationDTO.DEFINED.getName()));
        } else {
            list.stream().filter(entityPropertyLog -> entityPropertyLog.getPropertyName().equals(SmsChannelConfigurationDTO.DEFINED.getName())).forEach(entityPropertyLog -> entityPropertyLog.setOrder(Integer.valueOf(list.size())));
        }
        return list;
    }

    public Class<ChannelConfiguration> getEntityClass() {
        return ChannelConfiguration.class;
    }

    @Override
    public String getEntityLogName(ChannelConfiguration channelConfiguration, ChannelConfiguration channelConfiguration2, EntityLogEvent entityLogEvent) {
        return ((ChannelConfiguration)ObjectHelper.defaultValue((Object)channelConfiguration2, (Object)channelConfiguration)).getChannel().getName();
    }

    public EntityLogType getType() {
        return EntityLogType.CHANNEL_CONFIGURATION;
    }

    @Override
    public Pair<Object, Object> getValues(ChannelConfiguration channelConfiguration, ChannelConfiguration channelConfiguration2, PropertyLogDescriptor<ChannelConfigurationDTO> propertyLogDescriptor) {
        if (!channelConfiguration.isDefined() && channelConfiguration2.isDefined()) {
            ChannelConfiguration channelConfiguration3 = channelConfiguration.getConfiguration().getParent().getChannelConfiguration(channelConfiguration.getChannel());
            EntityLogHelper entityLogHelper = new EntityLogHelper(propertyLogDescriptor.getAccess(), channelConfiguration3, channelConfiguration2);
            if (propertyLogDescriptor.getAccess().getPropertyName().equals(SmsChannelConfigurationDTO.DEFINED.getName())) {
                return Pair.create((Object)false, (Object)true);
            }
            return Pair.create((Object)entityLogHelper.getOldValue(), (Object)entityLogHelper.getNewValue());
        }
        return null;
    }

    public EntityLogDescriptor<? extends ChannelConfigurationDTO> resolveLogDescriptor(ChannelConfiguration channelConfiguration) {
        EntityLogDescriptor entityLogDescriptor = new EntityLogDescriptor(this.resolveDTOType(channelConfiguration)).ignore((Property)ChannelConfigurationDTO.CHANNEL).ignore((Property)ChannelConfigurationDTO.CONFIGURATION).property((Property)ChannelConfigurationDTO.DEFINED, SystemKeys.EntityLogs.DEFINED).property((Property)ChannelConfigurationDTO.LOCKED, SystemKeys.EntityLogs.LOCKED).property((Property)ChannelConfigurationDTO.ENABLED, SystemKeys.ChannelConfigurations.ENABLED).property((Property)ChannelConfigurationDTO.USER_ACCESS, SystemKeys.ChannelConfigurations.USER_ACCESS).property((Property)ChannelConfigurationDTO.ALLOW_LOGIN, SystemKeys.ChannelConfigurations.ALLOW_LOGIN).property((Property)ChannelConfigurationDTO.PRINCIPAL_TYPES, SystemKeys.ChannelConfigurations.PRINCIPAL_TYPES).property((Property)ChannelConfigurationDTO.DEFAULT_PRINCIPAL_TYPE, SystemKeys.ChannelConfigurations.DEFAULT_PRINCIPAL_TYPE).property((Property)ChannelConfigurationDTO.PRINCIPAL_TYPES_ALLOWING_QR_CODE, SystemKeys.ChannelConfigurations.SHOW_QR_CODE_FOR_USER_IDENTIFICATION_METHODS).property((Property)ChannelConfigurationDTO.IDENTITY_PROVIDERS, SystemKeys.ChannelConfigurations.IDENTITY_PROVIDERS).property((Property)ChannelConfigurationDTO.REGISTRATION_WITH_IDENTITY_PROVIDERS, SystemKeys.ChannelConfigurations.REGISTRATION_WITH_IDENTITY_PROVIDERS).property((Property)ChannelConfigurationDTO.REQUIRE_TRUSTED_DEVICE_FOR_LOGIN, SystemKeys.ChannelConfigurations.REQUIRE_TRUSTED_DEVICE_FOR_LOGIN).property((Property)ChannelConfigurationDTO.TRUSTED_DEVICE_ON_STARTUP, SystemKeys.ChannelConfigurations.TRUSTED_DEVICE_ON_STARTUP).property((Property)ChannelConfigurationDTO.REQUIRE_AUTHENTICATION_FOR_DEVICE_CONFIRMATION, SystemKeys.ChannelConfigurations.REQUIRE_AUTHENTICATION_FOR_DEVICE_CONFIRMATION).property((Property)ChannelConfigurationDTO.SESSION_TIMEOUT, SystemKeys.ChannelConfigurations.SESSION_TIMEOUT).ignore((Property)ChannelConfigurationDTO.USE_IP_WHITELIST).property((Property)ChannelConfigurationDTO.IP_WHITELIST, SystemKeys.ChannelConfigurations.IP_WHITELIST).property((Property)ChannelConfigurationDTO.ACCESS_PASSWORD, SystemKeys.ChannelConfigurations.ACCESS_PASSWORD).nested((Property)ChannelConfigurationDTO.PIN_CONFIGURATION).property((Property)PinChannelConfigurationDTO.MAX_PIN_TRIES, SystemKeys.ChannelConfigurations.DEVICE_PIN_MAX_TRIES).property((Property)PinChannelConfigurationDTO.PIN_EXPIRES_AFTER, SystemKeys.ChannelConfigurations.DEVICE_PIN_EXPIRES_AFTER).property((Property)PinChannelConfigurationDTO.PIN_LENGTH, SystemKeys.ChannelConfigurations.DEVICE_PIN_LENGTH).property((Property)PinChannelConfigurationDTO.DEVICE_PIN_ON_STARTUP, SystemKeys.ChannelConfigurations.DEVICE_PIN_ON_STARTUP).addNested();
        this.addCredentialsConfiguration((EntityLogDescriptor<ChannelConfigurationDTO>)entityLogDescriptor, (Property<CredentialsConfigurationDTO, ChannelConfigurationDTO>)ChannelConfigurationDTO.LOGIN_CONFIRMATION, SystemKeys.ChannelConfigurations.SECTION_LOGIN_CONFIRMATION);
        this.addCredentialsConfiguration((EntityLogDescriptor<ChannelConfigurationDTO>)entityLogDescriptor, (Property<CredentialsConfigurationDTO, ChannelConfigurationDTO>)ChannelConfigurationDTO.CONFIRMATION, SystemKeys.ChannelConfigurations.SECTION_CONFIRMATION);
        entityLogDescriptor.property((Property)ChannelConfigurationDTO.CONFIRMATION_ONCE_PER_SESSION, SystemKeys.ChannelConfigurations.CONFIRMATION_ONCE_PER_SESSION).property((Property)ChannelConfigurationDTO.SKIP_CONFIRMATION_FOR_TRUSTED_DEVICES, SystemKeys.ChannelConfigurations.SKIP_CONFIRMATION_FOR_TRUSTED_DEVICES);
        this.addPaymentPrincipalsConfiguration((EntityLogDescriptor<ChannelConfigurationDTO>)entityLogDescriptor, (Property<PaymentPrincipalsConfigurationDTO, ChannelConfigurationDTO>)ChannelConfigurationDTO.PAYMENT, SystemKeys.ChannelConfigurations.SECTION_PERFORM_PAYMENTS);
        this.addPaymentPrincipalsConfiguration((EntityLogDescriptor<ChannelConfigurationDTO>)entityLogDescriptor, (Property<PaymentPrincipalsConfigurationDTO, ChannelConfigurationDTO>)ChannelConfigurationDTO.POS, SystemKeys.ChannelConfigurations.SECTION_RECEIVE_PAYMENTS);
        if (channelConfiguration instanceof SmsChannelConfiguration) {
            entityLogDescriptor.cast().property((Property)SmsChannelConfigurationDTO.MOBILE_NUMBER_SOURCE, SystemKeys.ChannelConfigurations.MOBILE_NUMBER_SOURCE).property((Property)SmsChannelConfigurationDTO.USERNAME, SystemKeys.ChannelConfigurations.USERNAME).property((Property)SmsChannelConfigurationDTO.PASSWORD, SystemKeys.ChannelConfigurations.PASSWORD).property((Property)SmsChannelConfigurationDTO.SCRIPT, SystemKeys.ChannelConfigurations.SCRIPT).property((Property)SmsChannelConfigurationDTO.SCRIPT_PARAMETERS, SystemKeys.ChannelConfigurations.SCRIPT_PARAMETERS).property((Property)SmsChannelConfigurationDTO.SMS_MESSAGE_SOURCE, SystemKeys.ChannelConfigurations.SMS_MESSAGE_SOURCE).ignore((Property)SmsChannelConfigurationDTO.PASSWORD_SET);
        }
        return entityLogDescriptor;
    }

    @Override
    protected ChannelConfiguration getEntityToViewLog(long l) {
        return this.hasPermission(Permission.SYSTEM_CONFIGURATION_VIEW) ? this.find(ChannelConfiguration.class, l) : null;
    }

    private void addCredentialsConfiguration(EntityLogDescriptor<ChannelConfigurationDTO> entityLogDescriptor, Property<CredentialsConfigurationDTO, ChannelConfigurationDTO> property, MessageKey messageKey) {
        entityLogDescriptor.nested(property, messageKey).property((Property)CredentialsConfigurationDTO.PASSWORD, SystemKeys.ChannelConfigurations.CREDENTIALS_PASSWORD).property((Property)CredentialsConfigurationDTO.DEVICE, SystemKeys.ChannelConfigurations.CREDENTIALS_DEVICE).property((Property)CredentialsConfigurationDTO.TOTP, SystemKeys.ChannelConfigurations.CREDENTIALS_TOTP).addNested();
    }

    private void addPaymentPrincipalsConfiguration(EntityLogDescriptor<ChannelConfigurationDTO> entityLogDescriptor, Property<PaymentPrincipalsConfigurationDTO, ChannelConfigurationDTO> property, MessageKey messageKey) {
        entityLogDescriptor.nested(property, messageKey).property((Property)PaymentPrincipalsConfigurationDTO.PRINCIPAL_TYPES, SystemKeys.ChannelConfigurations.PAYMENTS_PRINCIPAL_TYPES).property((Property)PaymentPrincipalsConfigurationDTO.SCAN_QR_CODE, SystemKeys.ChannelConfigurations.PAYMENTS_SCAN_QR_CODE).property((Property)PaymentPrincipalsConfigurationDTO.AUTOCOMPLETE, SystemKeys.ChannelConfigurations.PAYMENTS_AUTOCOMPLETE).property((Property)PaymentPrincipalsConfigurationDTO.CONTACTS, SystemKeys.ChannelConfigurations.PAYMENTS_CONTACTS).property((Property)PaymentPrincipalsConfigurationDTO.DEFAULT_ID_METHOD, SystemKeys.ChannelConfigurations.PAYMENTS_DEFAULT_ID_METHOD).property((Property)PaymentPrincipalsConfigurationDTO.DEFAULT_PRINCIPAL_TYPE, SystemKeys.ChannelConfigurations.PAYMENTS_DEFAULT_PRINCIPAL_TYPE).addNested();
    }

    private Class<? extends ChannelConfigurationDTO> resolveDTOType(ChannelConfiguration channelConfiguration) {
        return channelConfiguration instanceof SmsChannelConfiguration ? SmsChannelConfigurationDTO.class : ChannelConfigurationDTO.class;
    }
}

