/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.system.ImportedField;
import org.cyclos.entities.system.ImportedFile;
import org.cyclos.entities.system.ImportedLine;
import org.cyclos.entities.system.UserSpecificImportedFile;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.impl.ApplicationHandler;
import org.cyclos.impl.BaseNetworkedHandlerImpl;
import org.cyclos.impl.banking.CurrencyServiceLocal;
import org.cyclos.impl.messaging.ErrorLogServiceLocal;
import org.cyclos.impl.system.ImportHandler;
import org.cyclos.impl.system.ImportServiceLocal;
import org.cyclos.impl.utils.formatting.FormatterImpl;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.MaxItemsException;
import org.cyclos.model.Property;
import org.cyclos.model.ValidationException;
import org.cyclos.model.banking.TransferException;
import org.cyclos.model.banking.currencies.CurrencyVO;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.imports.ImportField;
import org.cyclos.model.system.imports.ImportedFileDTO;
import org.cyclos.model.system.imports.ImportedFileData;
import org.cyclos.model.system.imports.ImportedFileDataParams;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.utils.CurrencyAmountDTO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.utils.DateTime;
import org.cyclos.utils.ExceptionTranslationHelper;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.TranslationMessageSpecification;
import org.cyclos.utils.coercion.CoercionException;
import org.cyclos.utils.coercion.CoercionHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

public abstract class BaseImportHandlerImpl<DTO extends ImportedFileDTO, D extends ImportedFileData, IF extends ImportedFile, E extends SimpleEntity>
extends BaseNetworkedHandlerImpl
implements ImportHandler<DTO, D, IF, E> {
    @Autowired
    protected CurrencyServiceLocal currencyService;
    @Autowired
    protected RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    @Lazy
    protected ImportServiceLocal importService;
    private final Map<String, ImportField> importFields;
    @Autowired
    private ApplicationHandler applicationHandler;
    @Autowired
    private ErrorLogServiceLocal errorLogService;

    public BaseImportHandlerImpl(ImportField[] importFieldArray) {
        this.importFields = Collections.unmodifiableMap(Arrays.stream(importFieldArray).collect(Collectors.toMap(ImportField::getName, importField -> importField)));
    }

    public String fieldName(ImportedField importedField) {
        ImportField importField = this.getImportField(importedField.getFieldName());
        if (importField != null && importField.getMessageKey() != null) {
            return this.message(importField.getMessageKey(), new Object[0]);
        }
        return importedField.getFieldName();
    }

    public void finishImport(IF IF) {
    }

    public final List<ImportedField> getFieldsInList(IF IF) {
        return this.doGetFieldsInList(IF).stream().map(arg_0 -> IF.getField(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public IF newEntity(ImportedFileDataParams importedFileDataParams) {
        ImportedFile importedFile = (ImportedFile)ClassHelper.instantiate((Class)this.getImportedFileClass());
        if (importedFile instanceof UserSpecificImportedFile) {
            UserSpecificImportedFile userSpecificImportedFile = (UserSpecificImportedFile)importedFile;
            userSpecificImportedFile.setUser(this.userLocatorHandler.toUserOrCurrent((BasicUserVO)importedFileDataParams.getUser()));
        }
        return (IF)importedFile;
    }

    public void onImportError(ImportedLine importedLine, Throwable throwable) {
        String string = this.getImportErrorMessage(throwable);
        if (string == null) {
            string = this.message(SystemKeys.Imports.ERROR_INTERNAL_ERROR, new Object[0]);
            StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[1];
            String string2 = ModelHelper.unqualifyInternalName((String)stackTraceElement.getClassName()) + "." + stackTraceElement.getMethodName();
            Long l = this.applicationHandler.getIdMask().apply(importedLine.getId());
            String string3 = String.format("{\"importedLineId\": %s}", l);
            this.errorLogService.create(string2, string3, ExceptionUtils.getStackTrace((Throwable)throwable), null, null);
        }
        importedLine.setErrorMessage(string);
    }

    protected abstract List<ImportField> doGetFieldsInList(IF var1);

    protected E find(Long l) {
        return (E)((SimpleEntity)this.rawEntityManagerHandler.find(this.getEntityClass(), l));
    }

    protected String getImportErrorMessage(Throwable throwable) {
        try {
            throw throwable;
        }
        catch (ValidationException validationException) {
            return validationException.getValidation().getFirstError();
        }
        catch (EntityNotFoundException entityNotFoundException) {
            if (entityNotFoundException.getEntityType() == null) {
                return this.message(GeneralKeys.Errors.NOT_FOUND, new Object[0]);
            }
            Object object = entityNotFoundException.getId() != null ? this.applicationHandler.getIdMask().apply(entityNotFoundException.getId()) : entityNotFoundException.getKey();
            return this.message(StringHelper.isBlank((Object)object) ? GeneralKeys.Errors.ENTITY_NOT_FOUND : GeneralKeys.Errors.ENTITY_NOT_FOUND_KEY, entityNotFoundException.getEntityType(), object);
        }
        catch (TransferException transferException) {
            TranslationMessageSpecification translationMessageSpecification = ExceptionTranslationHelper.getForTransferException((TransferException)transferException);
            return this.message(translationMessageSpecification.getKey(), translationMessageSpecification.getArguments());
        }
        catch (MaxItemsException maxItemsException) {
            return this.message(SystemKeys.Imports.ERROR_MAX_ITEMS_REACHED, new Object[0]);
        }
        catch (Throwable throwable2) {
            return null;
        }
    }

    protected ImportField getImportField(String string) {
        return this.importFields.get(string);
    }

    protected BasicUser locateUser(String string) {
        return this.locateUser(string, false);
    }

    protected BasicUser locateUser(String string, boolean bl) {
        if (StringHelper.isBlank((Object)string)) {
            if (bl) {
                String string2 = this.message(SystemKeys.Imports.ERROR_INVALID_PRINCIPAL, "");
                throw new ValidationException(string2);
            }
            return null;
        }
        try {
            UserLocatorVO userLocatorVO = new UserLocatorVO((Property)UserLocatorVO.PRINCIPAL, (Object)string);
            return this.userLocatorHandler.locate(userLocatorVO).getBasicUser();
        }
        catch (EntityNotFoundException entityNotFoundException) {
            String string3 = this.message(SystemKeys.Imports.ERROR_INVALID_PRINCIPAL, string);
            throw new ValidationException(string3);
        }
    }

    protected CurrencyAmountDTO parseAmount(String string, Currency currency) {
        if (StringHelper.isBlank((Object)string)) {
            return null;
        }
        CurrencyAmountDTO currencyAmountDTO = new CurrencyAmountDTO();
        currencyAmountDTO.setAmount(this.parseDecimal(string, currency.getPrecision()));
        currencyAmountDTO.setCurrency((CurrencyVO)this.conversionHandler.convert(CurrencyVO.class, (Object)currency));
        return currencyAmountDTO;
    }

    protected Boolean parseBoolean(String string) {
        try {
            return (Boolean)CoercionHelper.coerce(Boolean.class, (Object)StringHelper.trimToNull((Object)string));
        }
        catch (Exception exception) {
            String string2 = this.message(SystemKeys.Imports.ERROR_INVALID_BOOLEAN_VALUE, string);
            throw new ValidationException(string2);
        }
    }

    protected Date parseDate(String string) {
        if (StringHelper.isNotBlank((Object)string)) {
            try {
                return this.getFormatter().parseDate(string);
            }
            catch (CoercionException coercionException) {
                try {
                    return this.toDate(new DateTime(string));
                }
                catch (Exception exception) {
                    String string2 = this.message(SystemKeys.Imports.ERROR_DATE_CONVERSION, string, this.getFormatter().getDatePattern());
                    throw new ValidationException(string2);
                }
            }
        }
        return null;
    }

    protected DateTime parseDateTime(String string) {
        if (StringHelper.isBlank((Object)string)) {
            return null;
        }
        FormatterImpl formatterImpl = this.getFormatter();
        try {
            return this.conversionHandler.toDateTime(formatterImpl.parseTimestamp(string));
        }
        catch (Exception exception) {
            try {
                return new DateTime(string);
            }
            catch (Exception exception2) {
                String string2 = this.message(SystemKeys.Imports.ERROR_DATE_CONVERSION, string, formatterImpl.getDatePattern() + " " + formatterImpl.getTimePattern());
                throw new ValidationException(string2);
            }
        }
    }

    protected BigDecimal parseDecimal(String string, int n) {
        if (StringHelper.isBlank((Object)string)) {
            return null;
        }
        try {
            return this.getFormatter().parseDecimal(string, n);
        }
        catch (CoercionException coercionException) {
            String string2 = this.message(SystemKeys.Imports.ERROR_INVALID_NUMBER_FORMAT, new Object[0]);
            throw new ValidationException(string2);
        }
    }
}

