/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import com.querydsl.core.types.EntityPath;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclos.entities.system.CustomField;
import org.cyclos.entities.system.CustomFieldPossibleValue;
import org.cyclos.entities.system.CustomFieldPossibleValueCategory;
import org.cyclos.entities.system.CustomScript;
import org.cyclos.entities.utils.DecimalRange;
import org.cyclos.entities.utils.IntegerRange;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.search.SearchHandler;
import org.cyclos.impl.storage.StoredFileHandler;
import org.cyclos.impl.system.BaseCustomFieldPossibleValueCategoryServiceLocal;
import org.cyclos.impl.system.BaseCustomFieldPossibleValueServiceLocal;
import org.cyclos.impl.system.CustomFieldValueHandler;
import org.cyclos.impl.system.CustomScriptServiceLocal;
import org.cyclos.impl.users.RecordTypeServiceLocal;
import org.cyclos.impl.utils.validation.EntityValidation;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.impl.utils.validation.validations.BaseEntityValidation;
import org.cyclos.impl.utils.validation.validations.RangeOptionalType;
import org.cyclos.model.Property;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.fields.CustomFieldDTO;
import org.cyclos.model.system.fields.CustomFieldData;
import org.cyclos.model.system.fields.CustomFieldDetailedVO;
import org.cyclos.model.system.fields.CustomFieldPossibleValueQuery;
import org.cyclos.model.system.fields.CustomFieldType;
import org.cyclos.model.system.fields.CustomFieldVO;
import org.cyclos.model.system.fields.LinkedEntityType;
import org.cyclos.model.system.fields.ValueMatch;
import org.cyclos.model.system.scripts.CustomScriptVO;
import org.cyclos.model.system.scripts.ScriptType;
import org.cyclos.model.users.recordtypes.RecordTypeVO;
import org.cyclos.model.utils.FileMimeType;
import org.cyclos.model.utils.Range;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.services.system.BaseCustomFieldService;
import org.cyclos.utils.BigDecimalHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.MaskHelper;
import org.cyclos.utils.ObjectHelper;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseCustomFieldServiceImpl<CF extends CustomField<CF, C, PV>, C extends CustomFieldPossibleValueCategory<CF, C, PV>, PV extends CustomFieldPossibleValue<CF, C, PV>, A extends EntityPath<CF>, DTO extends CustomFieldDTO, D extends CustomFieldData<DTO>, DP>
extends CRUDServiceImpl<CF, A, DTO, D, DP>
implements BaseCustomFieldService<DTO, D, DP> {
    protected final Class<D> dataClass;
    @Autowired
    protected CustomFieldValueHandler customFieldValueHandler;
    @Autowired
    protected CustomScriptServiceLocal customScriptService;
    @Autowired
    private StoredFileHandler storedFileHandler;
    @Autowired
    private RecordTypeServiceLocal recordTypeService;
    @Autowired
    private SearchHandler searchHandler;

    public BaseCustomFieldServiceImpl(Class<CF> clazz, A a, Class<DTO> clazz2, Class<D> clazz3) {
        super(clazz, a, clazz2);
        this.dataClass = clazz3;
    }

    @Override
    public DTO toDTO(CF CF) {
        CustomFieldDTO customFieldDTO = (CustomFieldDTO)super.toDTO(CF);
        if (CF.getType() == CustomFieldType.STRING && CF.getPattern() != null) {
            customFieldDTO.setDefaultStringValue(MaskHelper.applyMask((String)CF.getPattern(), (String)CF.getDefaultStringValue()));
        }
        return (DTO)customFieldDTO;
    }

    @Override
    protected void addCustomInternalNameValidations(org.cyclos.impl.utils.validation.Property property, DTO DTO) {
        property.noPropertyOf(this.getPropertyClasses());
    }

    protected void addCustomValidations(Validator validator, DTO DTO) {
    }

    @Override
    protected D getData(CF CF) {
        List list;
        CustomFieldData customFieldData = (CustomFieldData)ClassHelper.instantiate(this.dataClass);
        if (CF.isTransient()) {
            CF.setDecimalDigits(Integer.valueOf(2));
            CF.setMaxFiles(Integer.valueOf(1));
        }
        customFieldData.setDto(this.toDTO(CF));
        customFieldData.setSupportsValues(this.supportsValues());
        customFieldData.setSupportsTranslatedValues(this.searchHandler.isTranslationSupported());
        if (CF.isPersistent() && CF.getType().isEnumerated()) {
            customFieldData.setPossibleValueCategories(this.getPossibleValueCategoryService().list(new CustomFieldVO(CF.getId())));
            list = new CustomFieldPossibleValueQuery();
            list.setUnlimited();
            list.setField(new CustomFieldVO(CF.getId()));
            customFieldData.setPossibleValues(this.getPossibleValueService().search((CustomFieldPossibleValueQuery)list).getPageItems());
            customFieldData.setShowDefaultOnSearch(this.getPossibleValueService().showDefaultOnSearch());
        }
        list = this.customScriptService.listByType(ScriptType.CUSTOM_FIELD_VALIDATION);
        customFieldData.setValidationScripts(this.conversionHandler.convertList(CustomScriptVO.class, (Iterable)list));
        List list2 = this.customScriptService.listByType(ScriptType.LOAD_CUSTOM_FIELD_VALUES);
        customFieldData.setLoadValuesScripts(this.conversionHandler.convertList(CustomScriptVO.class, (Iterable)list2));
        if (CF.isTransient()) {
            customFieldData.setPossibleTypes(EnumSet.allOf(CustomFieldType.class).stream().filter(customFieldType -> {
                if (customFieldType.isBinary()) {
                    return this.isBinaryTypesAllowed();
                }
                if (customFieldType.isDynamic()) {
                    return !list2.isEmpty();
                }
                return true;
            }).collect(Collectors.toList()));
        }
        if (CF.isTransient() && this.isBinaryTypesAllowed() || CF.getType().isBinary()) {
            customFieldData.setStorageDirectories(this.storedFileHandler.getStorageDirectories().stream().sorted().collect(Collectors.toList()));
        }
        if (CF.isTransient() || CF.getLinkedEntityType() == LinkedEntityType.RECORD) {
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(this.recordTypeService.listVisibleSystemTypes());
            arrayList.addAll(this.recordTypeService.listVisibleUserTypes());
            customFieldData.setPossibleLinkedEntityRecordTypes(this.conversionHandler.convertList(RecordTypeVO.class, arrayList));
        }
        return (D)customFieldData;
    }

    protected abstract Integer getMaxOrder(CF var1);

    protected abstract BaseCustomFieldPossibleValueCategoryServiceLocal<CF, C, PV> getPossibleValueCategoryService();

    protected abstract BaseCustomFieldPossibleValueServiceLocal<CF, C, PV> getPossibleValueService();

    protected List<Class<?>> getPropertyClasses() {
        return null;
    }

    protected abstract boolean isBinaryTypesAllowed();

    @Override
    protected boolean isEntityInternalNameRequired(DTO DTO) {
        return true;
    }

    @Override
    protected Object onBeforeSave(CF CF, CF CF2) {
        Integer n;
        if (CF.getOrder() == null || CF2 == null) {
            n = this.getMaxOrder(CF);
            CF.setOrder(Integer.valueOf(n == null ? 1 : n + 1));
        }
        if ((n = CF.getType()) != CustomFieldType.LINKED_ENTITY) {
            CF.setLinkedEntityType(null);
        }
        if (!n.canHaveLoadValuesScript()) {
            CF.setLoadValuesScript(null);
        }
        if (CF.getLoadValuesScript() == null) {
            CF.setLoadValuesScriptParameters(null);
        } else {
            CF.setShowQrCodeScan(null);
        }
        if (CF.getValidationScript() == null) {
            CF.setValidationScriptParameters(null);
        }
        if (!n.isUseSize(CF.getControl())) {
            CF.setSize(null);
        }
        if (!n.isEnumerated() && CF.getLoadValuesScript() == null) {
            CF.setAllSelectedLabel(null);
        }
        if (this.supportsValues()) {
            if (n == CustomFieldType.URL) {
                CF.setValueMatch(ValueMatch.EXACT);
            } else if (!n.isSearchable()) {
                CF.setValueMatch(null);
            }
        } else {
            CF.setValueMatch(null);
        }
        if (n == CustomFieldType.DECIMAL) {
            if (CF.getDecimalDigits() == null) {
                CF.setDecimalDigits(Integer.valueOf(BigDecimalHelper.MAX_SCALE));
            }
            int n2 = CF.getDecimalDigits();
            CF.setDefaultDecimalValue(BigDecimalHelper.round((BigDecimal)CF.getDefaultDecimalValue(), (int)n2));
            DecimalRange decimalRange = CF.getDecimalValueRange();
            if (decimalRange != null) {
                decimalRange.setMin(BigDecimalHelper.round((BigDecimal)decimalRange.getMin(), (int)n2));
                decimalRange.setMax(BigDecimalHelper.round((BigDecimal)decimalRange.getMax(), (int)n2));
            }
        } else {
            CF.setDecimalDigits(null);
            CF.setDecimalValueRange(null);
        }
        if (n != CustomFieldType.INTEGER) {
            CF.setIntegerValueRange(null);
        }
        if (!ObjectHelper.isOneOf((Object)n, (Object[])new Object[]{CustomFieldType.STRING, CustomFieldType.TEXT, CustomFieldType.RICH_TEXT})) {
            CF.setMaxWordSize(null);
            CF.setIgnoreSanitizer(false);
        }
        if (!n.isBinary()) {
            CF.setMaxFiles(null);
        }
        if (n == CustomFieldType.FILE) {
            if (!CF.getAllowedMimeTypes().contains(FileMimeType.OTHERS)) {
                CF.setOtherMimeTypes(null);
            }
        } else {
            CF.setAllowedMimeTypes(null);
            CF.setOtherMimeTypes(null);
        }
        if (n == CustomFieldType.STRING) {
            CF.setDefaultStringValue(MaskHelper.removeMask((String)CF.getPattern(), (String)CF.getDefaultStringValue()));
        } else {
            CF.setShowQrCodeScan(null);
            CF.setPattern(null);
        }
        if (n == CustomFieldType.BOOLEAN && CF.getDefaultBooleanValue() == null) {
            CF.setDefaultBooleanValue(Boolean.valueOf(false));
        }
        return null;
    }

    @Override
    protected final Validator resolveValidator(DTO DTO) {
        IntegerRange integerRange;
        Validator validator = new Validator();
        this.addCustomValidations(validator, DTO);
        org.cyclos.impl.utils.validation.Property property = validator.property((Property)CustomFieldDTO.TYPE, SystemKeys.Fields.TYPE);
        org.cyclos.impl.utils.validation.Property property2 = validator.property((Property)CustomFieldDTO.CONTROL, SystemKeys.Fields.CONTROL);
        property2.required();
        property.required();
        CustomFieldType customFieldType = DTO.getType();
        if (customFieldType != null) {
            if (customFieldType.isBinary() && !this.isBinaryTypesAllowed()) {
                property.invalid();
            }
            property2.anyOf((Collection)customFieldType.getPossibleControls(DTO.getLoadValuesScript() != null));
            if (customFieldType.isUseSize(DTO.getControl())) {
                validator.property((Property)CustomFieldDTO.SIZE, SystemKeys.Fields.SIZE).required();
            }
        }
        if (customFieldType != CustomFieldType.URL && customFieldType.isString() && this.supportsValues()) {
            validator.property((Property)CustomFieldDTO.VALUE_MATCH, SystemKeys.Fields.VALUE_MATCH).required();
        }
        if (customFieldType == CustomFieldType.STRING) {
            integerRange = (IntegerRange)this.conversionHandler.convert(IntegerRange.class, (Object)DTO.getLengthConstraint());
            org.cyclos.impl.utils.validation.Property property3 = validator.property((Property)CustomFieldDTO.DEFAULT_STRING_VALUE, SystemKeys.Fields.DEFAULT_VALUE);
            this.customFieldValueHandler.addLengthValidation(property3, integerRange);
            this.customFieldValueHandler.addPatternValidation(property3, DTO.getPattern());
            if (DTO.getPattern() != null) {
                validator.property((Property)CustomFieldDTO.DEFAULT_STRING_VALUE, SystemKeys.Fields.DEFAULT_VALUE).maskValue(DTO.getPattern());
            }
            validator.property((Property)CustomFieldDTO.LENGTH_CONSTRAINT, SystemKeys.Fields.LENGTH_CONSTRAINT).range(RangeOptionalType.BOTH_OPTIONAL);
            validator.property((Property)CustomFieldDTO.PATTERN, SystemKeys.Fields.PATTERN).mask(1);
        } else if (customFieldType == CustomFieldType.LINKED_ENTITY) {
            validator.property((Property)CustomFieldDTO.LINKED_ENTITY_TYPE, SystemKeys.Fields.LINKED_ENTITY_TYPE).required();
        } else if (customFieldType == CustomFieldType.DECIMAL) {
            validator.property((Property)CustomFieldDTO.DECIMAL_DIGITS, SystemKeys.Fields.DECIMAL_DIGITS).required().between((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(BigDecimalHelper.MAX_SCALE));
            validator.property((Property)CustomFieldDTO.DECIMAL_VALUE_RANGE, SystemKeys.Fields.VALUE_RANGE).range(RangeOptionalType.BOTH_OPTIONAL);
            validator.property((Property)CustomFieldDTO.DEFAULT_DECIMAL_VALUE, SystemKeys.Fields.DEFAULT_VALUE).between((Range)DTO.getDecimalValueRange());
        } else if (customFieldType == CustomFieldType.INTEGER) {
            validator.property((Property)CustomFieldDTO.INTEGER_VALUE_RANGE, SystemKeys.Fields.VALUE_RANGE).range(RangeOptionalType.BOTH_OPTIONAL);
            validator.property((Property)CustomFieldDTO.DEFAULT_INTEGER_VALUE, SystemKeys.Fields.DEFAULT_VALUE).between((Range)DTO.getIntegerValueRange());
        } else if (customFieldType == CustomFieldType.FILE) {
            validator.property((Property)CustomFieldDTO.ALLOWED_MIME_TYPES, SystemKeys.Fields.ALLOWED_MIME_TYPES).required();
            if (CollectionHelper.orEmpty((Set)DTO.getAllowedMimeTypes()).contains(FileMimeType.OTHERS)) {
                validator.property((Property)CustomFieldDTO.OTHER_MIME_TYPES, SystemKeys.Fields.OTHER_MIME_TYPES).required();
            }
        }
        validator.property((Property)CustomFieldDTO.ALL_SELECTED_LABEL, SystemKeys.Fields.ALL_SELECTED_LABEL).maxLength(250);
        integerRange = validator.property((Property)CustomFieldDTO.LOAD_VALUES_SCRIPT, SystemKeys.Fields.LOAD_VALUES_SCRIPT).entity(CustomScript.class, (EntityValidation)new BaseEntityValidation<CustomScript>(){

            protected boolean isValid(Object object, Object object2, CustomScript customScript) {
                return customScript.getType() == ScriptType.LOAD_CUSTOM_FIELD_VALUES;
            }
        });
        if (customFieldType == CustomFieldType.DYNAMIC_SELECTION) {
            integerRange.required();
        }
        validator.property((Property)CustomFieldDTO.VALIDATION_SCRIPT, SystemKeys.Fields.VALIDATION_SCRIPT).entity(CustomScript.class, (EntityValidation)new BaseEntityValidation<CustomScript>(){

            protected boolean isValid(Object object, Object object2, CustomScript customScript) {
                return customScript.getType() == ScriptType.CUSTOM_FIELD_VALIDATION;
            }
        });
        return validator;
    }

    protected boolean supportsValues() {
        return this.isBinaryTypesAllowed();
    }

    protected List<CustomFieldDetailedVO> toDetailedVOs(Collection<CF> collection) {
        return CollectionHelper.sort((Collection)this.conversionHandler.convertList(CustomFieldDetailedVO.class, collection));
    }
}

