/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import org.cyclos.impl.system.ImportServiceLocal;
import org.cyclos.impl.utils.tasks.SimpleRecurringTask;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.utils.RecurringTaskRecurrence;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.utils.MessageKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ArchiveImportsRecurringTask
extends SimpleRecurringTask {
    @Autowired
    private ImportServiceLocal importService;
    @Autowired
    private CyclosProperties cyclosProperties;

    public MessageKey getMessageKey() {
        return SystemKeys.RecurringTasks.ARCHIVE_IMPORTS;
    }

    @Override
    public String getNotesForLogging() {
        int n = this.cyclosProperties.getArchiveImportsDays();
        return n >= 1 ? String.format("Retention period: %d days", n) : "Disabled";
    }

    @Override
    public RecurringTaskRecurrence getRecurrence() {
        return RecurringTaskRecurrence.EVERY_DAY;
    }

    @Override
    protected long execute() throws Throwable {
        return this.importService.archiveImports();
    }
}

