/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.storage;

import com.google.auth.Credentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.ReadChannel;
import com.google.cloud.WriteChannel;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cyclos.entities.utils.StoredFile;
import org.cyclos.impl.storage.DelayedSaveStoredFileContentAction;
import org.cyclos.impl.storage.DelayedStoredFileContentAction;
import org.cyclos.impl.storage.SaveStoredFileContentAction;
import org.cyclos.impl.storage.StoredFileContentAction;
import org.cyclos.impl.storage.StoredFileContentManager;
import org.cyclos.impl.storage.StoredFileHandler;
import org.cyclos.model.StoredFileException;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.server.utils.IOHelper;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;

public class GoogleCloudStoredFileContentManagerImpl
implements StoredFileContentManager {
    private static final Logger logger = LogManager.getLogger(GoogleCloudStoredFileContentManagerImpl.class);
    private static final String CREDENTIALS_FILE_PROPERTY = "credentialsFile";
    private static final String BUCKET_NAME_PROPERTY = "bucketName";
    @Autowired
    private CyclosProperties cyclosProperties;
    private String defaultBucketName;
    private Storage storage;

    public SaveStoredFileContentAction copy(String string, final Object object) {
        final BlobId blobId = this.newBlobId(string);
        String string2 = this.metadata(blobId);
        return new DelayedSaveStoredFileContentAction(string2, string2){

            public void confirm() {
                BlobId blobId2 = GoogleCloudStoredFileContentManagerImpl.this.blobId(object);
                Storage.CopyRequest copyRequest = Storage.CopyRequest.newBuilder().setSource(blobId2).setTarget(blobId).build();
                GoogleCloudStoredFileContentManagerImpl.this.storage.copy(copyRequest).getResult();
            }
        };
    }

    public String getKey(StoredFile storedFile) throws StoredFileException {
        return (String)this.getMetadata(storedFile);
    }

    public Object getMetadata(StoredFile storedFile) throws StoredFileException {
        return storedFile.getMetadata();
    }

    public SerializableInputStream open(Object object) {
        SerializableInputStream serializableInputStream;
        block8: {
            ReadChannel readChannel = this.storage.reader(this.blobId(object), new Storage.BlobSourceOption[0]);
            try {
                SerializableInputStream serializableInputStream2 = new SerializableInputStream(Channels.newInputStream((ReadableByteChannel)readChannel));
                serializableInputStream2.forceCopyToFile();
                serializableInputStream = serializableInputStream2;
                if (readChannel == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (readChannel != null) {
                        try {
                            readChannel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    throw new StoredFileException(String.format("Error retrieving file from %s", object), (Throwable)exception);
                }
            }
            readChannel.close();
        }
        return serializableInputStream;
    }

    public StoredFileContentAction remove(final Object object) {
        return new DelayedStoredFileContentAction(){

            public void confirm() {
                GoogleCloudStoredFileContentManagerImpl.this.storage.delete(GoogleCloudStoredFileContentManagerImpl.this.blobId(object));
            }
        };
    }

    public boolean requiresPersistentStoredFileToSetMetadata() {
        return false;
    }

    public void setMetadata(StoredFile storedFile, Object object) throws StoredFileException {
        storedFile.setMetadata((String)object);
    }

    public SaveStoredFileContentAction store(String string, final SerializableInputStream serializableInputStream) {
        final BlobId blobId = this.newBlobId(string);
        final BlobInfo blobInfo = BlobInfo.newBuilder((BlobId)blobId).build();
        final Consumer<Exception> consumer = exception -> {
            throw new StoredFileException(String.format("Error storing from stream to '%s'", this.metadata(blobId)), (Throwable)exception);
        };
        try {
            final File file = serializableInputStream.file();
            return new SaveStoredFileContentAction(){

                public void cancel() {
                    file.delete();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void confirm() {
                    try (WriteChannel writeChannel = GoogleCloudStoredFileContentManagerImpl.this.storage.writer(blobInfo, new Storage.BlobWriteOption[0]);
                         OutputStream outputStream = Channels.newOutputStream((WritableByteChannel)writeChannel);){
                        IOUtils.copy((InputStream)serializableInputStream, (OutputStream)outputStream);
                    }
                    catch (IOException iOException) {
                        consumer.accept(iOException);
                    }
                    finally {
                        IOHelper.close((Closeable)serializableInputStream);
                        file.delete();
                    }
                }

                public String key() {
                    return (String)this.metadata();
                }

                public Object metadata() {
                    return GoogleCloudStoredFileContentManagerImpl.this.metadata(blobId);
                }
            };
        }
        catch (Exception exception2) {
            consumer.accept(exception2);
            return null;
        }
    }

    public boolean supportStorageDirectories() {
        return true;
    }

    public void testConnection() throws StoredFileException {
        this.storage.list(this.defaultBucketName, new Storage.BlobListOption[0]).hasNextPage();
    }

    private BlobId blobId(Object object) {
        List list = StringHelper.split((String)object.toString(), (String)"/");
        return BlobId.of((String)((String)list.get(0)), (String)((String)list.get(1)));
    }

    private void ensure(String string) {
        Bucket bucket = this.storage.get(string, new Storage.BucketGetOption[0]);
        if (bucket == null) {
            throw new IllegalStateException("Google Cloud Storage bucket doesn't exist: " + string);
        }
    }

    @PostConstruct
    private void initialize() throws IOException {
        Properties properties = this.cyclosProperties.getStoredFileContentManagerProperties();
        String string = properties.getProperty(CREDENTIALS_FILE_PROPERTY);
        if (string == null) {
            throw new IllegalStateException("Missing google cloud storage's credentials file name");
        }
        ServiceAccountCredentials serviceAccountCredentials = ServiceAccountCredentials.fromStream((InputStream)new FileInputStream(new File(string)));
        StorageOptions storageOptions = ((StorageOptions.Builder)StorageOptions.newBuilder().setCredentials((Credentials)serviceAccountCredentials)).build();
        this.storage = (Storage)storageOptions.getService();
        this.defaultBucketName = properties.getProperty(BUCKET_NAME_PROPERTY);
        logger.info(String.format("Initializing content manager: <alias=%s, defaultBucketName=%s>", CyclosProperties.getStoredFileContentManagerAlias((String)this.getClass().getName()), this.defaultBucketName));
        this.ensure(this.defaultBucketName);
        StoredFileHandler.getStorageDirectories((CyclosProperties)this.cyclosProperties).stream().forEach(this::ensure);
    }

    private String metadata(BlobId blobId) {
        return blobId.getBucket() + "/" + blobId.getName();
    }

    private BlobId newBlobId(String string) {
        return BlobId.of((String)(StringHelper.isBlank((Object)string) ? this.defaultBucketName : string), (String)UUID.randomUUID().toString());
    }
}

