/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.storage;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.S3Object;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cyclos.entities.utils.StoredFile;
import org.cyclos.impl.storage.DelayedSaveStoredFileContentAction;
import org.cyclos.impl.storage.DelayedStoredFileContentAction;
import org.cyclos.impl.storage.SaveStoredFileContentAction;
import org.cyclos.impl.storage.StoredFileContentAction;
import org.cyclos.impl.storage.StoredFileContentManager;
import org.cyclos.impl.storage.StoredFileHandler;
import org.cyclos.model.StoredFileException;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.server.utils.IOHelper;
import org.cyclos.server.utils.PropertiesHelper;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.utils.Pair;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;

public class AmazonS3StoredFileContentManagerImpl
implements StoredFileContentManager {
    private static final Logger logger = LogManager.getLogger(AmazonS3StoredFileContentManagerImpl.class);
    private static final String ACCESS_KEY_ID_PROPERTY = "accessKeyId";
    private static final String SECRET_ACCESS_KEY_PROPERTY = "secretAccessKey";
    private static final String BUCKET_NAME_PROPERTY = "bucketName";
    private static final String REGION_NAME_PROPERTY = "regionName";
    private static final String SERVICE_ENDPOINT_PROPERTY = "serviceEndpoint";
    private static final String SIGNIN_REGION_PROPERTY = "signinRegion";
    private static final String BUILDER_PREFIX = "builder.";
    private static final String CLIENT_PREFIX = "client.";
    @Autowired
    private CyclosProperties cyclosProperties;
    private String defaultBucketName;
    private Map<String, AmazonS3> s3clientsMap = new HashMap<String, AmazonS3>();

    public SaveStoredFileContentAction copy(String string, final Object object) {
        final S3ObjectDescriptor s3ObjectDescriptor = this.newDescriptor(string);
        String string2 = s3ObjectDescriptor.metadata();
        return new DelayedSaveStoredFileContentAction(string2, string2){

            public void confirm() {
                S3ObjectDescriptor s3ObjectDescriptor2 = AmazonS3StoredFileContentManagerImpl.this.toDescriptor((String)object);
                AmazonS3StoredFileContentManagerImpl.this.s3Client(s3ObjectDescriptor2).copyObject(s3ObjectDescriptor2.bucketName(), s3ObjectDescriptor2.key(), s3ObjectDescriptor.bucketName(), s3ObjectDescriptor.key());
            }
        };
    }

    public String getKey(StoredFile storedFile) throws StoredFileException {
        return (String)this.getMetadata(storedFile);
    }

    public Object getMetadata(StoredFile storedFile) throws StoredFileException {
        return storedFile.getMetadata();
    }

    public SerializableInputStream open(Object object) {
        try {
            S3ObjectDescriptor s3ObjectDescriptor = this.toDescriptor((String)object);
            S3Object s3Object = this.s3Client(s3ObjectDescriptor).getObject(s3ObjectDescriptor.bucketName(), s3ObjectDescriptor.key());
            SerializableInputStream serializableInputStream = new SerializableInputStream((InputStream)s3Object.getObjectContent());
            serializableInputStream.forceCopyToFile();
            return serializableInputStream;
        }
        catch (Exception exception) {
            throw new StoredFileException(String.format("Error retrieving file from %s", object), (Throwable)exception);
        }
    }

    public StoredFileContentAction remove(final Object object) {
        return new DelayedStoredFileContentAction(){

            public void confirm() {
                S3ObjectDescriptor s3ObjectDescriptor = AmazonS3StoredFileContentManagerImpl.this.toDescriptor((String)object);
                AmazonS3StoredFileContentManagerImpl.this.s3Client(s3ObjectDescriptor).deleteObject(s3ObjectDescriptor.bucketName(), s3ObjectDescriptor.key());
            }
        };
    }

    public boolean requiresPersistentStoredFileToSetMetadata() {
        return false;
    }

    public void setMetadata(StoredFile storedFile, Object object) throws StoredFileException {
        storedFile.setMetadata((String)object);
    }

    public SaveStoredFileContentAction store(String string, final SerializableInputStream serializableInputStream) {
        final S3ObjectDescriptor s3ObjectDescriptor = this.newDescriptor(string);
        try {
            final File file = serializableInputStream.file();
            return new SaveStoredFileContentAction(){

                public void cancel() {
                    file.delete();
                }

                public void confirm() {
                    try {
                        AmazonS3StoredFileContentManagerImpl.this.s3Client(s3ObjectDescriptor).putObject(s3ObjectDescriptor.bucketName(), s3ObjectDescriptor.key(), file);
                    }
                    finally {
                        IOHelper.close((Closeable)serializableInputStream);
                        file.delete();
                    }
                }

                public String key() {
                    return (String)this.metadata();
                }

                public Object metadata() {
                    return s3ObjectDescriptor.metadata();
                }
            };
        }
        catch (Exception exception) {
            throw new StoredFileException(String.format("Error storing from stream to '%s'", s3ObjectDescriptor.metadata()), (Throwable)exception);
        }
    }

    public boolean supportStorageDirectories() {
        return true;
    }

    public void testConnection() throws StoredFileException {
        try {
            AmazonS3 amazonS3 = this.s3clientsMap.get(this.defaultBucketName);
            amazonS3.putObject(this.defaultBucketName, "write-test", "content");
            amazonS3.deleteObject(this.defaultBucketName, "write-test");
        }
        catch (Exception exception) {
            throw new StoredFileException("Error testing connection to Amazon S3", (Throwable)exception);
        }
    }

    @PostConstruct
    private void initialize() {
        Object object;
        BeanWrapperImpl beanWrapperImpl;
        Properties properties = this.cyclosProperties.getStoredFileContentManagerProperties();
        String string2 = properties.getProperty(ACCESS_KEY_ID_PROPERTY);
        String string3 = properties.getProperty(SECRET_ACCESS_KEY_PROPERTY);
        String string4 = properties.getProperty(SERVICE_ENDPOINT_PROPERTY);
        String string5 = properties.getProperty(SIGNIN_REGION_PROPERTY);
        Properties properties2 = PropertiesHelper.getSubProperties((Properties)properties, (String)BUILDER_PREFIX);
        Properties properties3 = PropertiesHelper.getSubProperties((Properties)properties, (String)CLIENT_PREFIX);
        this.defaultBucketName = properties.getProperty(BUCKET_NAME_PROPERTY);
        String string6 = properties.getProperty(REGION_NAME_PROPERTY);
        logger.info(String.format("Initializing content manager: <alias=%s, defaultBucketName=%s, defaultRegionName=%s>", CyclosProperties.getStoredFileContentManagerAlias((String)this.getClass().getName()), this.defaultBucketName, string6));
        AmazonS3ClientBuilder amazonS3ClientBuilder = (AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(string2, string3)));
        if (StringHelper.isNotBlank((Object)string4) && StringHelper.isNotBlank((Object)string5)) {
            amazonS3ClientBuilder.setEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(string4, string5));
        }
        if (!properties2.isEmpty()) {
            beanWrapperImpl = new BeanWrapperImpl((Object)amazonS3ClientBuilder);
            for (Map.Entry object2 : properties2.entrySet()) {
                Object k = object2.getKey();
                object = object2.getValue();
                if (object == null) continue;
                beanWrapperImpl.setPropertyValue(k.toString(), object);
            }
        }
        if (!properties3.isEmpty()) {
            beanWrapperImpl = new ClientConfiguration();
            BeanWrapperImpl beanWrapperImpl2 = new BeanWrapperImpl((Object)beanWrapperImpl);
            for (Map.Entry<Object, Object> entry : properties3.entrySet()) {
                object = entry.getKey();
                Object object2 = entry.getValue();
                if (object2 == null) continue;
                beanWrapperImpl2.setPropertyValue(object.toString(), object2);
            }
            amazonS3ClientBuilder.withClientConfiguration((ClientConfiguration)beanWrapperImpl);
        }
        this.initializeBucket(this.defaultBucketName, amazonS3ClientBuilder);
        StoredFileHandler.getStorageDirectories((CyclosProperties)this.cyclosProperties).stream().forEach(string -> this.initializeBucket((String)string, amazonS3ClientBuilder));
    }

    private void initializeBucket(String string, AmazonS3ClientBuilder amazonS3ClientBuilder) {
        Properties properties = this.cyclosProperties.getStoredFileContentManagerProperties();
        String string2 = properties.getProperty("regionName." + string);
        if (StringHelper.isBlank((Object)string2)) {
            string2 = properties.getProperty(REGION_NAME_PROPERTY);
        }
        if (StringHelper.isNotBlank((Object)string2)) {
            amazonS3ClientBuilder.withRegion(string2);
        }
        AmazonS3 amazonS3 = (AmazonS3)amazonS3ClientBuilder.build();
        try {
            if (!amazonS3.doesBucketExistV2(string)) {
                amazonS3.createBucket(string);
            } else {
                amazonS3.getBucketAcl(string);
            }
            this.s3clientsMap.put(string, amazonS3);
        }
        catch (AmazonClientException amazonClientException) {
            String string3 = "";
            if (amazonClientException instanceof AmazonServiceException) {
                int n = ((AmazonServiceException)amazonClientException).getStatusCode();
                try {
                    HttpStatus httpStatus = HttpStatus.valueOf((int)n);
                    switch (httpStatus) {
                        case NOT_FOUND: {
                            string3 = "Bucket not found.";
                            break;
                        }
                        case FORBIDDEN: {
                            string3 = "Bucket not accessible. Possibly because the bucket name is not available (it must be unique for all users). Please select a different name and try again.";
                            break;
                        }
                        default: {
                            string3 = String.format("Service error (http status code=%s)", httpStatus);
                            break;
                        }
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    string3 = String.format("Unknown service error (code=%s)", n);
                }
            }
            throw new IllegalStateException(String.format("Error initializing S3 storage with bucket/region: %s/%s. %s", string, string2, string3), amazonClientException);
        }
    }

    private S3ObjectDescriptor newDescriptor(String string) {
        return new S3ObjectDescriptor(StringHelper.isBlank((Object)string) ? this.defaultBucketName : string, UUID.randomUUID().toString());
    }

    private AmazonS3 s3Client(S3ObjectDescriptor s3ObjectDescriptor) {
        String string = s3ObjectDescriptor.bucketName();
        AmazonS3 amazonS3 = this.s3clientsMap.get(string);
        if (amazonS3 == null) {
            throw new IllegalArgumentException("Unknown bucket: " + string + ". Please check the configuration in cyclos.properties");
        }
        return amazonS3;
    }

    private S3ObjectDescriptor toDescriptor(String string) {
        return new S3ObjectDescriptor(string);
    }

    private static class S3ObjectDescriptor
    extends Pair<String, String> {
        private static final long serialVersionUID = 1L;

        private S3ObjectDescriptor(String string) {
            String[] stringArray = StringUtils.split((String)string, (String)"/");
            this.setFirst(stringArray[0]);
            this.setSecond(stringArray[1]);
        }

        private S3ObjectDescriptor(String string, String string2) {
            this.setFirst(string);
            this.setSecond(string2);
        }

        String bucketName() {
            return (String)this.getFirst();
        }

        String key() {
            return (String)this.getSecond();
        }

        String metadata() {
            return this.bucketName() + "/" + this.key();
        }
    }
}

