/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.sql.postgresql.fulltext;

import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.LexerNoViableAltException;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.impl.fulltextquery.FullTextQueryLexer;
import org.cyclos.impl.fulltextquery.FullTextQueryParser;
import org.cyclos.impl.sql.postgresql.fulltext.FullTextQuery;
import org.cyclos.impl.utils.validation.validations.PropertyValidations;
import org.cyclos.model.QueryParseException;
import org.cyclos.utils.StringHelper;

public class FullTextQueryHelper {
    private static final String ALLOWED_PUNCTUATION = " \"+-()";

    public static FullTextQuery parse(String object, boolean bl) throws QueryParseException {
        String string = object;
        if (object != null) {
            if (((String)object).equals("\"") || ((String)object).equals("\"\"")) {
                return new FullTextQuery("");
            }
            int n = StringUtils.countMatches((CharSequence)object, (CharSequence)"\"");
            if (n > 0 && n % 2 != 0) {
                object = ((String)object).endsWith("\"") ? ((String)object).substring(0, ((String)object).length() - 1) : (String)object + "\"";
            }
        }
        if (PropertyValidations.email().validate(null, null, object) == null) {
            return FullTextQueryHelper.parsePlain((String)object);
        }
        if (object != null) {
            StringBuilder stringBuilder = new StringBuilder(((String)object).length());
            boolean bl2 = false;
            for (int i = 0; i < ((String)object).length(); ++i) {
                boolean bl3;
                char c = ((String)object).charAt(i);
                boolean bl4 = Character.isAlphabetic(c) || Character.isIdeographic(c) || Character.isDigit(c);
                boolean bl5 = bl3 = ALLOWED_PUNCTUATION.indexOf(c) >= 0;
                if (bl4 || bl3) {
                    stringBuilder.append(c);
                } else {
                    stringBuilder.append(' ');
                }
                if (!bl4) continue;
                bl2 = true;
            }
            object = !bl2 ? null : stringBuilder.toString();
        }
        if (object == null) {
            throw new QueryParseException(string);
        }
        object = ((String)object).replaceAll("\"+", "\"");
        FullTextQueryParser fullTextQueryParser = FullTextQueryHelper.setupQueryParser((String)object);
        StringBuilder stringBuilder = new StringBuilder(((String)object).length() + 10);
        FullTextQueryParser.QueryContext queryContext = fullTextQueryParser.query();
        FullTextQueryHelper.append(stringBuilder, (ParseTree)queryContext, false, false, bl);
        return new FullTextQuery(stringBuilder.toString().trim());
    }

    public static FullTextQuery parsePlain(String string) throws QueryParseException {
        String string2 = string;
        if ((string = StringHelper.trimToNull((Object)StringUtils.replaceChars((String)string, (String)"*()", (String)""))) == null) {
            throw new QueryParseException(string2);
        }
        String[] stringArray = string.split("\\s");
        StringBuilder stringBuilder = new StringBuilder();
        for (String string3 : stringArray) {
            String string4 = StringUtils.containsAny((CharSequence)string3, (CharSequence)"-+./#!@$%&") ? "''" + string3 + "''" : string3 + ":*";
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" | ");
            }
            stringBuilder.append(string4);
        }
        return new FullTextQuery(stringBuilder.toString().trim());
    }

    private static void append(StringBuilder stringBuilder, ParseTree parseTree, boolean bl, boolean bl2, boolean bl3) {
        block22: {
            block21: {
                String string;
                if (!(parseTree instanceof TerminalNode)) break block21;
                switch (string = parseTree.getText().trim()) {
                    case "+": {
                        if (!bl) {
                            stringBuilder.append(" & ");
                            break;
                        }
                        break block22;
                    }
                    case "-": {
                        if (bl) {
                            stringBuilder.append(" !");
                            break;
                        }
                        stringBuilder.append(" & !");
                        break;
                    }
                    default: {
                        Object object = StringUtils.replace((String)string.replaceAll("\\s+", " "), (String)"'", (String)"");
                        if (bl2) {
                            if (bl3) {
                                object = StringUtils.removeStart((String)object, (String)"\"");
                                object = StringUtils.removeEnd((String)object, (String)"\"");
                                object = StringUtils.replace((String)((String)object).trim(), (String)" ", (String)"<->");
                            } else {
                                object = StringUtils.replace((String)object, (String)"\"", (String)"''");
                            }
                        } else if (!((String)object).endsWith("(") && !((String)object).endsWith(")")) {
                            object = (String)object + ":*";
                        }
                        stringBuilder.append((String)object);
                        break;
                    }
                }
                break block22;
            }
            boolean bl4 = false;
            if (parseTree instanceof FullTextQueryParser.ExpressionContext) {
                FullTextQueryParser.ExpressionContext expressionContext = (FullTextQueryParser.ExpressionContext)parseTree;
                bl4 = expressionContext.pipe;
                bl2 = expressionContext.inQuotes;
                bl = expressionContext.ignoreOperator;
            }
            boolean bl5 = false;
            for (int i = 0; i < parseTree.getChildCount(); ++i) {
                ParseTree parseTree2 = parseTree.getChild(i);
                if (parseTree2 instanceof TerminalNode) {
                    String string = parseTree2.getText().trim();
                    boolean bl6 = bl5 = !string.isEmpty();
                    if (!bl5) {
                        continue;
                    }
                } else {
                    bl5 = true;
                }
                FullTextQueryHelper.append(stringBuilder, parseTree2, bl, bl2, bl3);
                if (!bl5 || i >= parseTree.getChildCount() - 1) continue;
                if (bl4) {
                    stringBuilder.append(" | ");
                    continue;
                }
                if (!bl2 || !bl3) continue;
                stringBuilder.append("<->");
            }
        }
    }

    private static FullTextQueryParser setupQueryParser(final String string) {
        CodePointCharStream codePointCharStream = CharStreams.fromString((String)string);
        FullTextQueryLexer fullTextQueryLexer = new FullTextQueryLexer((CharStream)codePointCharStream){

            public void recover(LexerNoViableAltException lexerNoViableAltException) {
                throw new QueryParseException(string);
            }

            public void recover(RecognitionException recognitionException) {
                throw new QueryParseException(string);
            }
        };
        fullTextQueryLexer.removeErrorListeners();
        CommonTokenStream commonTokenStream = new CommonTokenStream((TokenSource)fullTextQueryLexer);
        FullTextQueryParser fullTextQueryParser = new FullTextQueryParser((TokenStream)commonTokenStream);
        fullTextQueryParser.removeErrorListeners();
        fullTextQueryParser.setErrorHandler((ANTLRErrorStrategy)new BailErrorStrategy(){

            public void recover(Parser parser, RecognitionException recognitionException) {
                throw new QueryParseException(string);
            }

            public Token recoverInline(Parser parser) throws RecognitionException {
                throw new QueryParseException(string);
            }
        });
        return fullTextQueryParser;
    }
}

