/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.sql.postgresql;

import com.querydsl.core.types.EntityPath;
import com.querydsl.sql.RelationalPathBase;
import com.querydsl.sql.SQLQuery;
import java.sql.Connection;
import java.time.Instant;
import java.util.List;
import javax.annotation.PostConstruct;
import org.cyclos.entities.banking.QArchivedEntityToRemoveFromIndex;
import org.cyclos.impl.BeanHandler;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.search.RemoveArchivedEntitiesFromIndexException;
import org.cyclos.impl.search.SearchHandler;
import org.cyclos.impl.sql.postgresql.PostgresqlAdSearchHandlerImpl;
import org.cyclos.impl.sql.postgresql.PostgresqlContactSearchHandlerImpl;
import org.cyclos.impl.sql.postgresql.PostgresqlInstallmentSearchHandlerImpl;
import org.cyclos.impl.sql.postgresql.PostgresqlQueryHandlerImpl;
import org.cyclos.impl.sql.postgresql.PostgresqlRecordSearchHandlerImpl;
import org.cyclos.impl.sql.postgresql.PostgresqlTransactionSearchHandlerImpl;
import org.cyclos.impl.sql.postgresql.PostgresqlTransferSearchHandlerImpl;
import org.cyclos.impl.sql.postgresql.PostgresqlUserSearchHandlerImpl;
import org.cyclos.impl.sql.postgresql.querydsl.QuerydslConfiguration;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.model.utils.TransactionLevel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.jdbc.core.JdbcTemplate;

public class PostgresqlSearchHandlerImpl
implements SearchHandler {
    public static final String REGCONFIG = "unaccent";
    private PostgresqlAdSearchHandlerImpl ad;
    private PostgresqlContactSearchHandlerImpl contact;
    private PostgresqlRecordSearchHandlerImpl record;
    private PostgresqlUserSearchHandlerImpl user;
    private PostgresqlTransferSearchHandlerImpl transfer;
    private PostgresqlTransactionSearchHandlerImpl transaction;
    private PostgresqlInstallmentSearchHandlerImpl installment;
    @Autowired
    @Lazy
    protected BeanHandler beanHandler;
    @Autowired
    @Lazy
    protected RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    @Lazy
    protected JdbcTemplate jdbcTemplate;
    private Boolean phraseSearchSupported;
    protected final PostgresqlQueryHandlerImpl queryHandler;
    @Autowired
    private InvokerHandler invokerHandler;

    public PostgresqlSearchHandlerImpl(PostgresqlQueryHandlerImpl postgresqlQueryHandlerImpl) {
        this.queryHandler = postgresqlQueryHandlerImpl;
    }

    public PostgresqlAdSearchHandlerImpl ad() {
        return this.ad;
    }

    public PostgresqlContactSearchHandlerImpl contact() {
        return this.contact;
    }

    public SQLQuery<?> from(Connection connection, RelationalPathBase<?> ... relationalPathBaseArray) {
        return (SQLQuery)this.query(connection).from(relationalPathBaseArray);
    }

    @PostConstruct
    public void initialize() {
        this.ad = (PostgresqlAdSearchHandlerImpl)this.beanHandler.autowireWithArgs(PostgresqlAdSearchHandlerImpl.class, new Object[]{this});
        this.contact = (PostgresqlContactSearchHandlerImpl)this.beanHandler.autowireWithArgs(PostgresqlContactSearchHandlerImpl.class, new Object[]{this});
        this.record = (PostgresqlRecordSearchHandlerImpl)this.beanHandler.autowireWithArgs(PostgresqlRecordSearchHandlerImpl.class, new Object[]{this});
        this.user = (PostgresqlUserSearchHandlerImpl)this.beanHandler.autowireWithArgs(PostgresqlUserSearchHandlerImpl.class, new Object[]{this});
        this.transfer = (PostgresqlTransferSearchHandlerImpl)this.beanHandler.autowireWithArgs(PostgresqlTransferSearchHandlerImpl.class, new Object[]{this});
        this.transaction = (PostgresqlTransactionSearchHandlerImpl)this.beanHandler.autowireWithArgs(PostgresqlTransactionSearchHandlerImpl.class, new Object[]{this});
        this.installment = (PostgresqlInstallmentSearchHandlerImpl)this.beanHandler.autowireWithArgs(PostgresqlInstallmentSearchHandlerImpl.class, new Object[]{this});
    }

    public PostgresqlInstallmentSearchHandlerImpl installment() {
        return this.installment;
    }

    public boolean isPhraseSearchSupported() {
        if (this.phraseSearchSupported == null) {
            Integer n = (Integer)this.jdbcTemplate.queryForObject("select count(*) from pg_proc where proname = 'phraseto_tsquery'", Integer.class);
            this.phraseSearchSupported = n != null && n > 0;
        }
        return this.phraseSearchSupported;
    }

    public boolean isTranslationSupported() {
        return false;
    }

    public void onApplicationInitialization() {
    }

    public void performIndex(String string, List<Long> list) {
    }

    public SQLQuery<?> query(Connection connection) {
        return new SQLQuery(connection, QuerydslConfiguration.get());
    }

    public PostgresqlRecordSearchHandlerImpl record() {
        return this.record;
    }

    public void reindex() {
        this.user.reindex();
        this.contact.reindex();
        this.ad.reindex();
        this.record.reindex();
        this.transfer.reindex();
        this.transaction.reindex();
        this.installment.reindex();
    }

    public long removeArchived(Instant instant) throws RemoveArchivedEntitiesFromIndexException {
        return (Long)this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_WRITE, transactionStatus -> {
            QArchivedEntityToRemoveFromIndex qArchivedEntityToRemoveFromIndex = QArchivedEntityToRemoveFromIndex.archivedEntityToRemoveFromIndex;
            return this.rawEntityManagerHandler.delete((EntityPath)qArchivedEntityToRemoveFromIndex).execute();
        });
    }

    public <S extends SearchHandler> S self() {
        return (S)this;
    }

    public PostgresqlTransactionSearchHandlerImpl transaction() {
        return this.transaction;
    }

    public PostgresqlTransferSearchHandlerImpl transfer() {
        return this.transfer;
    }

    public PostgresqlUserSearchHandlerImpl user() {
        return this.user;
    }
}

