/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.sql.postgresql;

import com.google.common.collect.Lists;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.DateTimeExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.EclipseLinkTemplates;
import com.querydsl.jpa.JPQLTemplates;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.RelationalPathBase;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableObject;
import org.cyclos.CyclosVersion;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.banking.AccountFee;
import org.cyclos.entities.banking.AccountFeeLog;
import org.cyclos.entities.banking.IUserAccount;
import org.cyclos.entities.banking.Installment;
import org.cyclos.entities.banking.PendingUserAccount;
import org.cyclos.entities.banking.Transaction;
import org.cyclos.entities.banking.Transfer;
import org.cyclos.entities.banking.TransferStatus;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.banking.UserAccount;
import org.cyclos.entities.banking.UserAccountType;
import org.cyclos.entities.marketplace.BasicAd;
import org.cyclos.entities.messaging.OutgoingMessage;
import org.cyclos.entities.system.IpGeolocation;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Product;
import org.cyclos.entities.users.Record;
import org.cyclos.entities.users.User;
import org.cyclos.entities.utils.LatLong;
import org.cyclos.entities.utils.queryextensions.CustomOperator;
import org.cyclos.impl.BeanHandler;
import org.cyclos.impl.banking.ArchiveAccountFeeLogBackgroundTask;
import org.cyclos.impl.banking.ArchiveBulkActionBackgroundTask;
import org.cyclos.impl.banking.NativeAccountStatus;
import org.cyclos.impl.locks.LockKey;
import org.cyclos.impl.messaging.EntityNotificationProcessingBackgroundTask;
import org.cyclos.impl.search.IndexEntitiesBackgroundTask;
import org.cyclos.impl.search.SearchHandler;
import org.cyclos.impl.sql.AccountStatusUpdateParams;
import org.cyclos.impl.sql.AccountStatusUpdateResult;
import org.cyclos.impl.sql.BaseNativeQueryHandlerImpl;
import org.cyclos.impl.sql.CountConnectedUsersParams;
import org.cyclos.impl.sql.DatabaseVacuumInformation;
import org.cyclos.impl.sql.InconsistentBalance;
import org.cyclos.impl.sql.NativeQueryHandler;
import org.cyclos.impl.sql.postgresql.NativeQuery;
import org.cyclos.impl.sql.postgresql.PostgresqlLockHandlerImpl;
import org.cyclos.impl.sql.postgresql.PostgresqlSearchHandlerImpl;
import org.cyclos.impl.sql.postgresql.UserNativeQuery;
import org.cyclos.impl.sql.postgresql.querydsl.QuerydslConfiguration;
import org.cyclos.impl.sql.postgresql.querytypes.SAccounts;
import org.cyclos.impl.sql.postgresql.querytypes.SAds;
import org.cyclos.impl.sql.postgresql.querytypes.SBrokerings;
import org.cyclos.impl.sql.postgresql.querytypes.SBulkActionsUsers;
import org.cyclos.impl.sql.postgresql.querytypes.SGroups;
import org.cyclos.impl.sql.postgresql.querytypes.SInstallments;
import org.cyclos.impl.sql.postgresql.querytypes.SMessages;
import org.cyclos.impl.sql.postgresql.querytypes.SPendingUserAccounts;
import org.cyclos.impl.sql.postgresql.querytypes.SProductsAccountFees;
import org.cyclos.impl.sql.postgresql.querytypes.SRecords;
import org.cyclos.impl.sql.postgresql.querytypes.SStoredFiles;
import org.cyclos.impl.sql.postgresql.querytypes.STransactions;
import org.cyclos.impl.sql.postgresql.querytypes.STransferStatusLogs;
import org.cyclos.impl.sql.postgresql.querytypes.STransfers;
import org.cyclos.impl.sql.postgresql.querytypes.STransfersTransferStatusFlows;
import org.cyclos.impl.sql.postgresql.querytypes.SUserAccountFeeLogs;
import org.cyclos.impl.sql.postgresql.querytypes.SUsers;
import org.cyclos.impl.system.ExcludeFromProfilingContext;
import org.cyclos.impl.system.ProfilingServiceLocal;
import org.cyclos.impl.users.GroupsHandler;
import org.cyclos.impl.users.ProductServiceLocal;
import org.cyclos.impl.users.UserProductsQueryResult;
import org.cyclos.impl.utils.conversion.ConversionHandler;
import org.cyclos.impl.utils.notifications.NotificationProcessingEntityType;
import org.cyclos.impl.utils.tasks.BaseBackgroundTaskScheduling;
import org.cyclos.impl.utils.tasks.CustomBackgroundTaskScheduling;
import org.cyclos.model.UnexpectedDataAccessException;
import org.cyclos.model.access.Role;
import org.cyclos.model.banking.accountfees.AccountFeeLogStatus;
import org.cyclos.model.banking.accountfees.UserAccountFeeStatus;
import org.cyclos.model.banking.accounts.BalanceEntryVO;
import org.cyclos.model.messaging.messages.MessageDestination;
import org.cyclos.model.messaging.messages.MessageNature;
import org.cyclos.model.messaging.messages.MessageOwner;
import org.cyclos.model.messaging.messages.SendMessageDTO;
import org.cyclos.model.system.languages.BuiltinLanguage;
import org.cyclos.model.system.scheduledtasks.BackgroundTaskPriority;
import org.cyclos.model.users.bulkactions.BulkActionStatus;
import org.cyclos.model.users.bulkactions.BulkActionUserStatus;
import org.cyclos.model.users.groups.BasicGroupNature;
import org.cyclos.model.users.users.UserQuery;
import org.cyclos.model.users.users.UserStatus;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.Pair;
import org.cyclos.utils.StringHelper;
import org.postgresql.PGConnection;
import org.postgresql.largeobject.LargeObject;
import org.postgresql.largeobject.LargeObjectManager;
import org.postgresql.util.PSQLState;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.PreparedStatementCreatorFactory;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;

public class PostgresqlQueryHandlerImpl
extends BaseNativeQueryHandlerImpl {
    private static final String CONNECTION_TERMINATING = "57P01";
    private static final HashFunction HASH;
    private static final PreparedStatementCreatorFactory INSERT_BACKGROUND_TASK_EXECUTION_PS_FACTORY;
    private static final PreparedStatementCreatorFactory INSERT_IP_GEOLOCATION_PS_FACTORY;
    @Autowired
    @Lazy
    private GroupsHandler groupsHandler;
    @Autowired
    @Lazy
    private ProductServiceLocal productService;
    @Autowired
    @Lazy
    private ConversionHandler conversionHandler;
    @Autowired
    private BeanHandler beanHandler;
    private PostgresqlSearchHandlerImpl _searchHandler;
    @Autowired
    private CyclosProperties cyclosProperties;

    public static SQLQuery<?> from(Connection connection, RelationalPathBase<?> ... relationalPathBaseArray) {
        return (SQLQuery)PostgresqlQueryHandlerImpl.query(connection).from(relationalPathBaseArray);
    }

    public static SQLQuery<?> query() {
        return new SQLQuery(QuerydslConfiguration.get());
    }

    public static SQLQuery<?> query(Connection connection) {
        return new SQLQuery(connection, QuerydslConfiguration.get());
    }

    private static String inParams(int n) {
        return "(" + StringUtils.removeEnd((String)StringUtils.repeat((String)"?,", (int)n), (String)",") + ")";
    }

    public long archiveAccountBalances() {
        return (Long)this.jdbcTemplate.queryForObject("select cy_archive_account_balances()", Long.class);
    }

    public long closeAccountBalances() {
        return (Long)this.jdbcTemplate.queryForObject("select cy_close_account_balances()", Long.class);
    }

    public long copyLargeObject(long l) throws IOException {
        MutableObject mutableObject = new MutableObject();
        Long l2 = (Long)this.jdbcTemplate.execute(arg_0 -> this.lambda$copyLargeObject$0(l, (Mutable)mutableObject, arg_0));
        if (mutableObject.getValue() != null) {
            throw (IOException)mutableObject.getValue();
        }
        return l2;
    }

    public Map<Role, Integer> countConnectedUsers(CountConnectedUsersParams countConnectedUsersParams) {
        EnumSet<Role> enumSet = countConnectedUsersParams.getRoles();
        if (CollectionHelper.isEmpty((Iterable)enumSet)) {
            enumSet = EnumSet.noneOf(Role.class);
            CollectionHelper.addAll(enumSet, (Object[])Role.basic());
        } else if (enumSet.stream().anyMatch(role -> !role.isBasic())) {
            throw new IllegalArgumentException("Only basic roles are allowed");
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("adminNature", BasicGroupNature.ADMIN_GROUP.name());
        hashMap.put("brokerNature", BasicGroupNature.BROKER_GROUP.name());
        hashMap.put("memberNature", BasicGroupNature.MEMBER_GROUP.name());
        hashMap.put("operatorRole", Role.OPERATOR.name());
        hashMap.put("brokerRole", Role.BROKER.name());
        hashMap.put("memberRole", Role.MEMBER.name());
        hashMap.put("adminRole", Role.ADMIN.name());
        Object object = "select case     when s.basic_user_id != s.user_id then :operatorRole     when g.subclass = :adminNature then :adminRole     when g.subclass = :brokerNature then :brokerRole     when g.subclass = :memberNature then :memberRole end as role, count(*) as count from sessions s inner join users u on s.user_id = u.id inner join groups g on u.user_group_id = g.id where true";
        if (!enumSet.contains(Role.ADMIN)) {
            object = (String)object + " and g.subclass <> :adminNature";
        }
        if (!enumSet.contains(Role.BROKER)) {
            object = (String)object + " and g.subclass <> :brokerNature";
        }
        if (!enumSet.contains(Role.MEMBER)) {
            object = (String)object + " and g.subclass <> :memberNature";
        }
        if (!enumSet.contains(Role.OPERATOR)) {
            object = (String)object + " and s.basic_user_id = s.user_id";
        }
        if (countConnectedUsersParams.isGlobal()) {
            object = (String)object + " and u.network_id is null";
        } else if (countConnectedUsersParams.getNetworkId() != null) {
            object = (String)object + " and u.network_id = :networkId";
            hashMap.put("networkId", countConnectedUsersParams.getNetworkId());
        }
        if (CollectionHelper.isNotEmpty((Iterable)countConnectedUsersParams.getGroupIds())) {
            object = (String)object + " and u.user_group_id in (:groupIds)";
            hashMap.put("groupIds", countConnectedUsersParams.getGroupIds());
        }
        if (countConnectedUsersParams.getBrokerId() != null) {
            object = (String)object + " and exists (";
            object = (String)object + "     select 1";
            object = (String)object + "     from users_brokers b";
            object = (String)object + "     where b.broker_id = :brokerId";
            object = (String)object + "     and b.user_id = u.id";
            object = (String)object + " )";
            hashMap.put("brokerId", countConnectedUsersParams.getBrokerId());
        }
        object = (String)object + " group by 1";
        EnumMap<Role, Integer> enumMap = new EnumMap<Role, Integer>(Role.class);
        Stream.of(Role.basic()).forEach(role -> enumMap.put((Role)role, 0));
        RowCallbackHandler rowCallbackHandler = resultSet -> {
            Role role = Role.valueOf((String)resultSet.getString("role"));
            int n = resultSet.getInt("count");
            enumMap.put(role, n);
        };
        this.namedJdbcTemplate.query((String)object, hashMap, rowCallbackHandler);
        return enumMap;
    }

    public List<Pair<String, Long>> countUsersByUrl() {
        String string = "SELECT c.root_url url, COUNT(u.id) users FROM users u INNER JOIN groups g ON u.user_group_id = g.id INNER JOIN configurations c ON g.configuration_id = c.id WHERE u.status NOT IN (?, ?) AND g.subclass IN (?, ?) GROUP BY 1 ORDER BY 2 DESC";
        return this.jdbcTemplate.queryForList(string, new Object[]{UserStatus.REMOVED.name(), UserStatus.PURGED.name(), BasicGroupNature.MEMBER_GROUP.name(), BasicGroupNature.BROKER_GROUP.name()}).stream().map(map -> new Pair((Object)((String)map.get("url")), (Object)((Long)map.get("users")))).collect(Collectors.toList());
    }

    public void deleteLargeObject(long l) {
        this.jdbcTemplate.execute(connection -> {
            LargeObjectManager largeObjectManager = this.getLargeObjectManager(connection);
            largeObjectManager.delete(l);
            SStoredFiles sStoredFiles = SStoredFiles.storedFiles;
            ((SQLUpdateClause)((SQLUpdateClause)this.update(connection, (RelationalPath<?>)sStoredFiles).setNull(sStoredFiles.oid)).where((Predicate)sStoredFiles.oid.eq((Object)l))).execute();
            return null;
        });
    }

    public List<InconsistentBalance> fixInconsistentAccountBalances(List<Long> list) {
        BeanPropertyRowMapper beanPropertyRowMapper = new BeanPropertyRowMapper(InconsistentBalance.class);
        if (CollectionHelper.isEmpty(list)) {
            return this.jdbcTemplate.query("select * from cy_fix_inconsistent_account_balances()", (RowMapper)beanPropertyRowMapper);
        }
        ArrayList<InconsistentBalance> arrayList = new ArrayList<InconsistentBalance>();
        for (List list2 : Lists.partition(list, (int)50)) {
            String string = "select * from cy_fix_inconsistent_account_balances" + PostgresqlQueryHandlerImpl.inParams(list2.size()) + " fix";
            int[] nArray = new int[list2.size()];
            Arrays.fill(nArray, -5);
            arrayList.addAll(this.jdbcTemplate.query(string, list2.toArray(), nArray, (RowMapper)beanPropertyRowMapper));
        }
        return arrayList;
    }

    public List<BalanceEntryVO> getAccountBalanceHistory(Long l, List<Date> list) {
        String string = list.stream().map(date -> "select ?, cy_account_balance(?, ?)").collect(Collectors.joining(" union ")) + " order by 1";
        ArrayList arrayList = new ArrayList(list.size() * 3);
        MutableInt mutableInt = new MutableInt();
        list.forEach(date -> {
            arrayList.add(mutableInt.incrementAndGet());
            arrayList.add(l);
            arrayList.add(date);
        });
        RowMapper rowMapper = (resultSet, n) -> {
            Date date = (Date)list.get(n);
            BalanceEntryVO balanceEntryVO = new BalanceEntryVO();
            balanceEntryVO.setDate(this.conversionHandler.toDateTime(date));
            balanceEntryVO.setAmount(resultSet.getBigDecimal(2));
            return balanceEntryVO;
        };
        return this.jdbcTemplate.query(string, rowMapper, arrayList.toArray());
    }

    public Map<Account, NativeAccountStatus> getAccountStatuses(Collection<Account> collection, Date date) {
        Object object;
        List list;
        NativeAccountStatus nativeAccountStatus = new NativeAccountStatus(BigDecimal.ZERO, BigDecimal.ZERO);
        RowMapper rowMapper = (resultSet, n) -> {
            NativeAccountStatusWithAccount nativeAccountStatusWithAccount = new NativeAccountStatusWithAccount();
            nativeAccountStatusWithAccount.setAccountId(resultSet.getLong("id"));
            nativeAccountStatusWithAccount.setBalance(resultSet.getBigDecimal("balance"));
            nativeAccountStatusWithAccount.setReserved(resultSet.getBigDecimal("reserved"));
            if (date == null) {
                nativeAccountStatusWithAccount.setCached(resultSet.getBoolean("cached"));
                Array array = resultSet.getArray("dirty_transfer_ids");
                nativeAccountStatusWithAccount.setDirtyTransferIds(array == null ? ArrayUtils.EMPTY_LONG_OBJECT_ARRAY : (Long[])array.getArray());
            }
            return nativeAccountStatusWithAccount;
        };
        List list2 = collection.stream().filter(SimpleEntity::isPersistent).collect(Collectors.toList());
        if (list2.isEmpty()) {
            return collection.stream().collect(Collectors.toMap(account -> account, account -> nativeAccountStatus));
        }
        if (date == null) {
            list = this.jdbcTemplate.query(" select a.id, st.* from accounts a inner join lateral cy_current_account_status(a.id) st on true where a.id in " + PostgresqlQueryHandlerImpl.inParams(list2.size()), rowMapper, SimpleEntity.ids(list2).toArray());
        } else {
            object = new ArrayList<Timestamp>();
            ((ArrayList)object).add(new Timestamp(date.getTime()));
            ((ArrayList)object).addAll(SimpleEntity.ids(list2));
            list = this.jdbcTemplate.query(" select * from accounts a inner join lateral cy_account_status_from_closing(a.id, ?) st on true where a.id in " + PostgresqlQueryHandlerImpl.inParams(list2.size()), rowMapper, ((ArrayList)object).toArray());
        }
        object = list2.stream().collect(Collectors.toMap(SimpleEntity::getId, account -> account));
        Map<Account, NativeAccountStatus> map = list.stream().collect(Collectors.toMap(arg_0 -> PostgresqlQueryHandlerImpl.lambda$getAccountStatuses$13((Map)object, arg_0), nativeAccountStatusWithAccount -> nativeAccountStatusWithAccount));
        collection.stream().filter(SimpleEntity::isTransient).forEach(account -> map.put((Account)account, nativeAccountStatus));
        return map;
    }

    public NativeQueryHandler.DatabaseInfo getDatabaseInfo() {
        return (NativeQueryHandler.DatabaseInfo)this.jdbcTemplate.execute(connection -> {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            return new BaseNativeQueryHandlerImpl.DatabaseInfoImpl(databaseMetaData.getDatabaseProductName(), databaseMetaData.getDatabaseProductVersion(), databaseMetaData.getDriverName(), databaseMetaData.getDriverVersion());
        });
    }

    public JPQLTemplates getJpaQueryTemplates() {
        return CustomTemplates.getInstance();
    }

    public Long getNextTransactionNumber() {
        return (Long)this.jdbcTemplate.queryForObject("select nextval('seq_transaction_numbers')", Long.class);
    }

    public Long getObjectId(long l) {
        SStoredFiles sStoredFiles = SStoredFiles.storedFiles;
        return (Long)this.jdbcTemplate.execute(connection -> (Long)((SQLQuery)PostgresqlQueryHandlerImpl.from(connection, sStoredFiles).where((Predicate)sStoredFiles.id.eq((Object)l))).select(sStoredFiles.oid).fetchOne());
    }

    public Date getRunningVacuumStart() {
        String string = "SELECT query_start FROM pg_stat_activity WHERE query LIKE 'VACUUM analyze%' AND state ='active' AND query NOT ILIKE '%pg_stat_activity%' LIMIT 1";
        List list = this.jdbcTemplate.queryForList(string, Date.class);
        return (Date)CollectionHelper.first((Iterable)list);
    }

    public SearchHandler getSearchHandler() {
        if (this._searchHandler == null) {
            this._searchHandler = (PostgresqlSearchHandlerImpl)this.beanHandler.autowireWithArgs(PostgresqlSearchHandlerImpl.class, new Object[]{this});
        }
        return this._searchHandler;
    }

    public DatabaseVacuumInformation getVacuumInfo() {
        String string = "SELECT max(last_vacuum) as lastVacuumDate, max(last_autovacuum) as lastAutoVacuumDate, max(last_analyze) as lastAnalyzeDate, max(last_autoanalyze) as lastAutoAnalyzeDate FROM pg_stat_user_tables WHERE schemaname='public'";
        return (DatabaseVacuumInformation)this.jdbcTemplate.queryForObject(string, (RowMapper)new BeanPropertyRowMapper(DatabaseVacuumInformation.class));
    }

    @Override
    public void initialize() {
        super.initialize();
        ConnectionCallback connectionCallback = connection -> connection.getMetaData().getDatabaseMajorVersion();
        int n = (Integer)this.jdbcTemplate.execute(connectionCallback);
        if (n < 12) {
            throw new IllegalStateException("Cyclos " + CyclosVersion.get() + " requires PostgreSQL 12 or newer");
        }
    }

    public SQLInsertClause insert(Connection connection, RelationalPath<?> relationalPath) {
        return new SQLInsertClause(connection, QuerydslConfiguration.get(), relationalPath);
    }

    public long insertArchiveAccountFees() {
        int n = this.cyclosProperties.getArchiveAccountFeesDays();
        if (n <= 0) {
            return 0L;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" INSERT INTO background_task_executions").append(" (class_name, context, priority, display, submitted_at)").append(" SELECT ?, l.id::text, ?, concat('Archive of account fee ', f.name, ' for date ', l.date), null").append(" FROM account_fee_logs l inner join account_fees f on l.account_fee_id = f.id").append(" WHERE l.date < now() - concat(?, ' days')::interval").append(" AND l.status = ?").append(" AND (l.archived is null or l.archived is false)");
        return this.jdbcTemplate.update(stringBuilder.toString(), new Object[]{ArchiveAccountFeeLogBackgroundTask.class.getName(), BackgroundTaskPriority.LOW.ordinal(), n, AccountFeeLogStatus.FINISHED.name()});
    }

    public long insertArchiveBulkActions() {
        int n = this.cyclosProperties.getArchiveBulkActionsDays();
        if (n <= 0) {
            return 0L;
        }
        EnumSet<BulkActionStatus> enumSet = EnumSet.of(BulkActionStatus.CANCELED, BulkActionStatus.FINISHED);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" INSERT INTO background_task_executions").append(" (class_name, context, priority, display, submitted_at)").append(" SELECT ?, id::text, ?, concat('Archive of bulk action ', id, ' for date ', creation_date), null").append(" FROM bulk_actions").append(" WHERE creation_date < now() - concat(?, ' days')::interval").append(" AND status in ").append(PostgresqlQueryHandlerImpl.inParams(enumSet.size())).append(" AND (archived is null or archived is false)");
        return this.jdbcTemplate.update(stringBuilder.toString(), new Object[]{ArchiveBulkActionBackgroundTask.class.getName(), BackgroundTaskPriority.LOW.ordinal(), n, BulkActionStatus.FINISHED.name(), BulkActionStatus.CANCELED.name()});
    }

    public long insertBackgroundTaskExecution(BaseBackgroundTaskScheduling<?> baseBackgroundTaskScheduling) {
        GeneratedKeyHolder generatedKeyHolder;
        boolean bl;
        OffsetDateTime offsetDateTime = null;
        if (baseBackgroundTaskScheduling.getStartAfter() != null) {
            offsetDateTime = OffsetDateTime.ofInstant(baseBackgroundTaskScheduling.getStartAfter().toInstant(), ZoneId.systemDefault());
        }
        Long l = null;
        if (baseBackgroundTaskScheduling instanceof CustomBackgroundTaskScheduling) {
            l = ((CustomBackgroundTaskScheduling)baseBackgroundTaskScheduling).getTask().getId();
        }
        String string = baseBackgroundTaskScheduling.getClassName();
        String string2 = StringHelper.trim((Object)baseBackgroundTaskScheduling.getContext());
        PreparedStatementCreator preparedStatementCreator = INSERT_BACKGROUND_TASK_EXECUTION_PS_FACTORY.newPreparedStatementCreator(Arrays.asList(string, string2, baseBackgroundTaskScheduling.getPriority().ordinal(), baseBackgroundTaskScheduling.getDisplay(), offsetDateTime, l, baseBackgroundTaskScheduling.getForkJoinId()));
        boolean bl2 = bl = this.jdbcTemplate.update(preparedStatementCreator, (KeyHolder)(generatedKeyHolder = new GeneratedKeyHolder())) > 0;
        if (!bl) {
            this.jdbcTemplate.update("delete from background_task_executions where class_name = ? and digest(context, 'sha512') = digest(?, 'sha512')", new Object[]{string, string2});
            return this.insertBackgroundTaskExecution(baseBackgroundTaskScheduling);
        }
        return (Long)generatedKeyHolder.getKeyAs(Long.class);
    }

    public long insertEntityNotificationProcessingBackgroundTasks(NotificationProcessingEntityType<?> notificationProcessingEntityType, int n) {
        return (Long)this.jdbcTemplate.queryForObject("select cy_insert_tasks_entity_notifications(?, ?, ?, ?)", Long.class, new Object[]{EntityNotificationProcessingBackgroundTask.class.getName(), notificationProcessingEntityType.name(), notificationProcessingEntityType.tableName(), n});
    }

    public long insertIdRangeBackgroundTasks(Class<?> clazz, long l, long l2, String string, Long l3) {
        string = StringHelper.trim((Object)string);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("insert into background_task_executions (class_name, context, priority, display, fork_join_id)").append("select ").append("?, ").append("case when ? = '' then concat(s, ',', s + ?) else concat(s, ',', s + ?, ',', ?) end, ").append("?, ").append("'Account verification for range: [' || s || ', ' || s + ? || ')', ").append("? ").append("from generate_series(0, ?, ?) s ").append("ON CONFLICT (class_name, digest(context, 'sha512')) ").append("DO NOTHING");
        return this.jdbcTemplate.update(stringBuilder.toString(), new Object[]{clazz.getName(), string, l2, l2, string, BackgroundTaskPriority.NORMAL.ordinal(), l2, l3, l, l2});
    }

    public long insertIpAddressLocalization(IpGeolocation ipGeolocation) {
        LatLong latLong = ipGeolocation.getLocation();
        OffsetDateTime offsetDateTime = ipGeolocation.getExpirationDate() == null ? null : OffsetDateTime.ofInstant(ipGeolocation.getExpirationDate().toInstant(), this.getSessionData().getConfiguration().getTimeZone().toZoneId());
        PreparedStatementCreator preparedStatementCreator = INSERT_IP_GEOLOCATION_PS_FACTORY.newPreparedStatementCreator(Arrays.asList(ipGeolocation.getAddress(), offsetDateTime, ipGeolocation.getCountry(), ipGeolocation.getRegion(), ipGeolocation.getCity(), latLong == null ? null : latLong.getLatitude(), latLong == null ? null : latLong.getLongitude(), offsetDateTime, ipGeolocation.getCountry(), ipGeolocation.getRegion(), ipGeolocation.getCity(), latLong == null ? null : latLong.getLatitude(), latLong == null ? null : latLong.getLongitude()));
        GeneratedKeyHolder generatedKeyHolder = new GeneratedKeyHolder();
        this.jdbcTemplate.update(preparedStatementCreator, (KeyHolder)generatedKeyHolder);
        return (Long)generatedKeyHolder.getKeyAs(Long.class);
    }

    public long insertReindexBackgroundTasks(Class<? extends SimpleEntity> clazz, String string, int n) {
        String string2;
        Object object = "";
        if (User.class.isAssignableFrom(clazz)) {
            string2 = SUsers.users.getTableName();
            object = "where " + SUsers.users.userGroupId.getMetadata().getName() + " is not null";
        } else if (BasicAd.class.isAssignableFrom(clazz)) {
            string2 = SAds.ads.getTableName();
            object = "where " + SAds.ads.deletedDate.getMetadata().getName() + " is null";
        } else if (Record.class.isAssignableFrom(clazz)) {
            string2 = SRecords.records.getTableName();
        } else if (Transfer.class.isAssignableFrom(clazz)) {
            string2 = STransfers.transfers.getTableName();
        } else if (Transaction.class.isAssignableFrom(clazz)) {
            string2 = STransactions.transactions.getTableName();
        } else if (Installment.class.isAssignableFrom(clazz)) {
            string2 = SInstallments.installments.getTableName();
        } else {
            throw new IllegalArgumentException("Unhandled class for indexing: " + clazz.getName());
        }
        return (Long)this.jdbcTemplate.queryForObject("select cy_insert_tasks_reindex(?, ?, ?, ?, ?)", Long.class, new Object[]{IndexEntitiesBackgroundTask.class.getName(), string, string2, n, object});
    }

    public void insertTransferInitialStatus(TransferType transferType, TransferStatus transferStatus) {
        STransfers sTransfers = STransfers.transfers;
        Long l = transferStatus.getId();
        Long l2 = transferStatus.getFlow().getId();
        STransfersTransferStatusFlows sTransfersTransferStatusFlows = new STransfersTransferStatusFlows("cs1");
        SQLQuery sQLQuery = (SQLQuery)((SQLQuery)new SQLQuery().from((Expression)sTransfers)).where(new Predicate[]{sTransfers.typeId.eq((Object)transferType.getId()), ((SQLQuery)((SQLQuery)new SQLQuery().from((Expression)sTransfersTransferStatusFlows)).where(new Predicate[]{sTransfersTransferStatusFlows.transferId.eq(sTransfers.id), sTransfersTransferStatusFlows.flowId.eq((Object)l2)})).notExists()});
        STransferStatusLogs sTransferStatusLogs = STransferStatusLogs.transferStatusLogs;
        this.jdbcTemplate.execute(connection -> ((SQLInsertClause)((SQLInsertClause)this.insert(connection, (RelationalPath<?>)sTransferStatusLogs).columns(new Path[]{sTransferStatusLogs.date, sTransferStatusLogs.transferId, sTransferStatusLogs.statusId})).select((SubQueryExpression)sQLQuery.select(new Expression[]{DateTimeExpression.currentTimestamp(), sTransfers.id, Expressions.constant((Object)l)}))).execute());
        STransfersTransferStatusFlows sTransfersTransferStatusFlows2 = STransfersTransferStatusFlows.transfersTransferStatusFlows;
        this.jdbcTemplate.execute(connection -> ((SQLInsertClause)((SQLInsertClause)this.insert(connection, (RelationalPath<?>)sTransfersTransferStatusFlows2).columns(new Path[]{sTransfersTransferStatusFlows.version, sTransfersTransferStatusFlows.transferId, sTransfersTransferStatusFlows.flowId, sTransfersTransferStatusFlows.statusId})).select((SubQueryExpression)sQLQuery.select(new Expression[]{Expressions.constant((Object)0), sTransfers.id, Expressions.constant((Object)l2), Expressions.constant((Object)l)}))).execute());
    }

    public long insertUserAccountFeeLogs(AccountFeeLog accountFeeLog) {
        AccountFee accountFee = accountFeeLog.getAccountFee();
        SUserAccountFeeLogs sUserAccountFeeLogs = SUserAccountFeeLogs.userAccountFeeLogs;
        SUsers sUsers = SUsers.users;
        SProductsAccountFees sProductsAccountFees = SProductsAccountFees.productsAccountFees;
        List list = (List)this.jdbcTemplate.execute(connection -> ((SQLQuery)PostgresqlQueryHandlerImpl.from(connection, sProductsAccountFees).select(sProductsAccountFees.productId).where((Predicate)sProductsAccountFees.accountFeeId.eq((Object)accountFee.getId()))).fetch());
        Set set = list.stream().map(l -> (Product)this.rawEntityManagerHandler.find(Product.class, l)).collect(Collectors.toSet());
        UserProductsQueryResult userProductsQueryResult = this.productService.productQuery(set);
        SQLQuery sQLQuery = (SQLQuery)((SQLQuery)new SQLQuery().select(new Expression[]{Expressions.constant((Object)accountFeeLog.getId()), sUsers.id, Expressions.constant((Object)0), Expressions.constant((Object)UserAccountFeeStatus.PENDING.name())}).from((Expression)sUsers)).where(new Predicate[]{sUsers.status.in((Object[])new UserStatus[]{UserStatus.ACTIVE, UserStatus.BLOCKED}), NativeQuery.apply(userProductsQueryResult, sUsers)});
        return (Long)this.jdbcTemplate.execute(connection -> ((SQLInsertClause)((SQLInsertClause)this.insert(connection, (RelationalPath<?>)sUserAccountFeeLogs).columns(new Path[]{sUserAccountFeeLogs.accountFeeLogId, sUserAccountFeeLogs.userId, sUserAccountFeeLogs.rechargeAttempt, sUserAccountFeeLogs.status})).select((SubQueryExpression)sQLQuery)).execute());
    }

    public void insertUserIncomingMessages(SendMessageDTO sendMessageDTO, MessageOwner messageOwner, User user, OutgoingMessage outgoingMessage) {
        Object object;
        Object object2;
        SMessages sMessages = SMessages.messages;
        SUsers sUsers = SUsers.users;
        SGroups sGroups = SGroups.groups;
        List<UserStatus> list = sendMessageDTO.getDestination() == MessageDestination.USER ? Arrays.asList(UserStatus.ACTIVE, UserStatus.BLOCKED, UserStatus.DISABLED) : Arrays.asList(UserStatus.ACTIVE, UserStatus.BLOCKED);
        SQLQuery sQLQuery = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)new SQLQuery().from((Expression)sUsers)).innerJoin((EntityPath)sGroups)).on((Predicate)sUsers.userGroupId.eq(sGroups.id))).where((Predicate)sUsers.status.in(list));
        switch (sendMessageDTO.getDestination()) {
            case GROUP: {
                object2 = SimpleEntity.uniqueIds((Collection)this.groupsHandler.flattenVOs((Collection)sendMessageDTO.getToGroups()));
                if (object2.isEmpty()) {
                    return;
                }
                sQLQuery.where((Predicate)sGroups.id.in((Collection)object2));
                break;
            }
            case BROKERED: {
                object = this.getSessionData().getLoggedBasicUser().getUser();
                SBrokerings sBrokerings = SBrokerings.brokerings;
                sQLQuery.where((Predicate)((SQLQuery)((SQLQuery)new SQLQuery().from((Expression)sBrokerings)).where(new Predicate[]{sBrokerings.userId.eq(sUsers.id), sBrokerings.endDate.isNull().or((Predicate)sBrokerings.endDate.after((Expression)DateTimeExpression.currentTimestamp())), sBrokerings.brokerId.eq((Object)object.getId())})).exists());
                break;
            }
            case USER: {
                Set set = this.conversionHandler.convertSet(User.class, (Iterable)sendMessageDTO.getToUsers());
                if (set.isEmpty()) {
                    return;
                }
                sQLQuery.where((Predicate)sUsers.id.in((Collection)SimpleEntity.uniqueIds((Collection)set)));
                break;
            }
            default: {
                return;
            }
        }
        object2 = SimpleEntity.id((SimpleEntity)outgoingMessage.getCategory());
        object = SimpleEntity.id((SimpleEntity)outgoingMessage.getOwner());
        this.jdbcTemplate.execute(arg_0 -> this.lambda$insertUserIncomingMessages$24(sMessages, sQLQuery, sGroups, (Long)object2, outgoingMessage, (Long)object, sUsers, arg_0));
    }

    public long insertUsersForBulkAction(Long l, UserQuery userQuery) {
        UserNativeQuery userNativeQuery = (UserNativeQuery)this.beanHandler.autowireWithArgs(UserNativeQuery.class, new Object[]{userQuery});
        SQLQuery<?> sQLQuery = userNativeQuery.getQuery();
        SBulkActionsUsers sBulkActionsUsers = SBulkActionsUsers.bulkActionsUsers;
        return (Long)this.jdbcTemplate.execute(connection -> ((SQLInsertClause)((SQLInsertClause)this.insert(connection, (RelationalPath<?>)sBulkActionsUsers).columns(new Path[]{sBulkActionsUsers.bulkActionId, sBulkActionsUsers.userId, sBulkActionsUsers.status})).select((SubQueryExpression)sQLQuery.select(new Expression[]{Expressions.constant((Object)l), userNativeQuery.u.id, Expressions.constant((Object)BulkActionUserStatus.PENDING.name())}))).execute());
    }

    public boolean isConnectionError(SQLException sQLException) {
        String string = sQLException.getSQLState();
        return PSQLState.isConnectionError((String)string) || CONNECTION_TERMINATING.equals(string);
    }

    public List<Long> nextAccountIdsToClose(int n, Date date) {
        return this.rawEntityManagerHandler.getEntityManager().createNativeQuery(" select a.id from accounts a where (a.last_balance_closing_date is null      or a.last_balance_closing_date < ?) and (a.last_balance_closing_date is null    or exists (     select 1     from transfers t     where t.from_id = a.id       and t.date > a.last_balance_closing_date ) or exists (     select 1     from transfers t     where t.to_id = a.id       and t.date > a.last_balance_closing_date )) limit ?").setParameter(1, (Object)date).setParameter(2, (Object)n).getResultList();
    }

    public InputStream openLargeObject(long l) {
        return (InputStream)this.jdbcTemplate.execute(connection -> {
            LargeObjectManager largeObjectManager = this.getLargeObjectManager(connection);
            LargeObject largeObject = largeObjectManager.open(l, 262144);
            return largeObject.getInputStream();
        });
    }

    public Pair<Set<String>, Set<Long>> purgeRemovedBuiltinLanguages() {
        Object[] objectArray = EnumSet.allOf(BuiltinLanguage.class).stream().map(Enum::name).toArray();
        String string = "select id, template from languages where parent_id is null and template not in " + PostgresqlQueryHandlerImpl.inParams(objectArray.length);
        List list = this.jdbcTemplate.queryForList(string, objectArray);
        Set set = list.stream().map(map -> (String)map.get("template")).collect(Collectors.toSet());
        Set set2 = list.stream().map(map -> (Long)map.get("id")).collect(Collectors.toSet());
        if (!set2.isEmpty()) {
            String string2 = BuiltinLanguage.EN.name();
            Long l = (Long)this.jdbcTemplate.queryForObject("select id from languages where parent_id is null and template = ?", Long.class, new Object[]{string2});
            this.jdbcTemplate.update("update languages set parent_id = ? where parent_id in " + PostgresqlQueryHandlerImpl.inParams(set2.size()), CollectionHelper.flatten((Object[])new Object[]{l, set2}));
            this.jdbcTemplate.update("update languages set template = ? where template in " + PostgresqlQueryHandlerImpl.inParams(set.size()), CollectionHelper.flatten((Object[])new Object[]{string2, set}));
            this.jdbcTemplate.update("update configurations set language_id = ? where language_id in " + PostgresqlQueryHandlerImpl.inParams(set2.size()), CollectionHelper.flatten((Object[])new Object[]{l, set2}));
            this.jdbcTemplate.update("delete from configurations_languages where language_id in " + PostgresqlQueryHandlerImpl.inParams(set2.size()), CollectionHelper.flatten((Object[])new Object[]{set2}));
            this.jdbcTemplate.update("delete from products_languages where language_id in " + PostgresqlQueryHandlerImpl.inParams(set2.size()), CollectionHelper.flatten((Object[])new Object[]{set2}));
            this.jdbcTemplate.update("delete from translation_messages where language_id in " + PostgresqlQueryHandlerImpl.inParams(set2.size()), CollectionHelper.flatten((Object[])new Object[]{set2}));
            this.jdbcTemplate.update("delete from data_translations where language_id in " + PostgresqlQueryHandlerImpl.inParams(set2.size()), CollectionHelper.flatten((Object[])new Object[]{set2}));
            this.jdbcTemplate.update("delete from languages where id in " + PostgresqlQueryHandlerImpl.inParams(set2.size()), CollectionHelper.flatten((Object[])new Object[]{set2}));
        }
        return Pair.create(set, set2);
    }

    public long rebuildClosedAccountBalances(List<Long> list) {
        if (CollectionHelper.isEmpty(list)) {
            return (Long)this.jdbcTemplate.queryForObject("select cy_rebuild_closed_account_balances()", Long.class);
        }
        long l = 0L;
        for (List list2 : Lists.partition(list, (int)50)) {
            String string = "select cy_rebuild_closed_account_balances" + PostgresqlQueryHandlerImpl.inParams(list2.size()) + " fix";
            int[] nArray = new int[list2.size()];
            Arrays.fill(nArray, -5);
            l += ((Long)this.jdbcTemplate.queryForObject(string, list2.toArray(), nArray, Long.class)).longValue();
        }
        return l;
    }

    public List<Long> scriptIdsMatchingContent(Long l, String string) {
        return this.jdbcTemplate.queryForList(" select distinct(s.id) from custom_script_functions f    inner join custom_scripts s on f.script_id = s.id where (s.network_id is null " + (String)(l == null ? "" : " or s.network_id = " + l) + ")   and lower(f.code) like ?", Long.class, new Object[]{"%" + string.toLowerCase() + "%"});
    }

    public void setObjectId(long l, long l2) {
        this.jdbcTemplate.execute(connection -> {
            SStoredFiles sStoredFiles = SStoredFiles.storedFiles;
            ((SQLUpdateClause)((SQLUpdateClause)this.update(connection, (RelationalPath<?>)sStoredFiles).set(sStoredFiles.oid, (Object)l2)).where((Predicate)sStoredFiles.id.eq((Object)l))).execute();
            return null;
        });
    }

    public void storeLoginDate(BasicUser basicUser, Date date) {
        this.jdbcTemplate.update("INSERT INTO user_login_stats (user_id, first_login, last_login) VALUES (?, ?, ?) ON CONFLICT (user_id) DO UPDATE SET last_login = ?", new Object[]{basicUser.getId(), date, date, date});
    }

    public boolean supportsBlobsInReadOnlyTransactions() {
        return false;
    }

    public boolean tryLock(JdbcTemplate jdbcTemplate, LockKey lockKey) {
        long l = HASH.hashString((CharSequence)lockKey.toString(), StandardCharsets.UTF_8).padToLong();
        return (Boolean)jdbcTemplate.queryForObject("select pg_try_advisory_xact_lock(?)", Boolean.class, new Object[]{l});
    }

    public boolean tryLock(LockKey lockKey) {
        return this.tryLock(this.jdbcTemplate, lockKey);
    }

    public SQLUpdateClause update(Connection connection, RelationalPath<?> relationalPath) {
        return new SQLUpdateClause(connection, QuerydslConfiguration.get(), relationalPath);
    }

    public List<AccountStatusUpdateResult> updateAccountStatuses(Collection<AccountStatusUpdateParams> collection) {
        if (CollectionHelper.isEmpty(collection)) {
            return Collections.emptyList();
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringBuilder stringBuilder = new StringBuilder();
        for (AccountStatusUpdateParams accountStatusUpdateParams : collection) {
            String string;
            Object[] objectArray = accountStatusUpdateParams.getDirtyTransferIds();
            String string2 = string = CollectionHelper.isEmpty((Object[])objectArray) ? null : Stream.of(objectArray).map(Object::toString).collect(Collectors.joining(","));
            if (stringBuilder.length() == 0) {
                stringBuilder.append("select ");
            } else {
                stringBuilder.append(" union select ");
            }
            stringBuilder.append("* from cy_update_account_status(?, ?, ?, ?) b");
            arrayList.add(accountStatusUpdateParams.getAccount().getId());
            arrayList.add(accountStatusUpdateParams.getBalance());
            arrayList.add(accountStatusUpdateParams.getReserved());
            arrayList.add(string);
        }
        return this.jdbcTemplate.query(stringBuilder.toString(), (RowMapper)new BeanPropertyRowMapper(AccountStatusUpdateResult.class), arrayList.toArray());
    }

    @ExcludeFromProfilingContext
    public Map<UserAccountType, IUserAccount> userAccounts(User user, Collection<UserAccountType> collection, boolean bl, Integer n) {
        if (user == null || user.isTransient()) {
            return new HashMap<UserAccountType, IUserAccount>();
        }
        SAccounts sAccounts = SAccounts.accounts;
        SPendingUserAccounts sPendingUserAccounts = SPendingUserAccounts.pendingUserAccounts;
        List list = SimpleEntity.ids(collection);
        ArrayList<SubQueryExpression> arrayList = new ArrayList<SubQueryExpression>();
        arrayList.add((SubQueryExpression)((SQLQuery)PostgresqlQueryHandlerImpl.query().select(new Expression[]{Expressions.nullExpression(), sPendingUserAccounts.id, sPendingUserAccounts.accountTypeId, Expressions.nullExpression(), sPendingUserAccounts.number, sPendingUserAccounts.active, Expressions.nullExpression(), sPendingUserAccounts.creditLimit, sPendingUserAccounts.upperCreditLimit, sPendingUserAccounts.upperCreditLimitFromProduct, Expressions.nullExpression(), Expressions.nullExpression(), Expressions.nullExpression(), Expressions.nullExpression(), Expressions.nullExpression(), Expressions.nullExpression()}).from((Expression)sPendingUserAccounts)).where(new Predicate[]{sPendingUserAccounts.userId.eq((Object)user.getId()), list.isEmpty() ? sPendingUserAccounts.id.isNotNull() : sPendingUserAccounts.accountTypeId.in((Collection)list), bl ? sPendingUserAccounts.number.isNotNull() : sPendingUserAccounts.id.isNotNull()}));
        arrayList.add((SubQueryExpression)((SQLQuery)PostgresqlQueryHandlerImpl.query().select(new Expression[]{sAccounts.id, Expressions.nullExpression(), sAccounts.accountTypeId, sAccounts.creationDate, sAccounts.number, sAccounts.active, sAccounts.negativeSince, sAccounts.creditLimit, sAccounts.upperCreditLimit, sAccounts.upperCreditLimitFromProduct, sAccounts.paymentAmountLimit, sAccounts.paymentAmountPerDayLimit, sAccounts.paymentAmountPerWeekLimit, sAccounts.paymentAmountPerMonthLimit, sAccounts.paymentAmountPerYearLimit, sAccounts.accountRatesId}).from((Expression)sAccounts)).where(new Predicate[]{sAccounts.userId.eq((Object)user.getId()), list.isEmpty() ? sAccounts.id.isNotNull() : sAccounts.accountTypeId.in((Collection)list), bl ? sAccounts.number.isNotNull() : sAccounts.id.isNotNull()}));
        ConnectionCallback connectionCallback = connection -> {
            SQLQuery<?> sQLQuery = PostgresqlQueryHandlerImpl.query(connection);
            if (n != null) {
                sQLQuery.limit((long)n.intValue());
            }
            return sQLQuery.union(arrayList).fetch().stream().map(tuple -> this.toUserAccount(user, (Tuple)tuple)).collect(Collectors.toMap(IUserAccount::getType, Function.identity(), this::preferredAccount));
        };
        return (Map)this.jdbcTemplate.execute(connectionCallback);
    }

    public void vacuum() {
        this.jdbcTemplate.execute("VACUUM analyze");
    }

    public long writeLargeObject(InputStream inputStream) throws IOException {
        MutableObject mutableObject = new MutableObject();
        long l = (Long)this.jdbcTemplate.execute(arg_0 -> this.lambda$writeLargeObject$32(inputStream, (Mutable)mutableObject, arg_0));
        if (mutableObject.getValue() != null) {
            throw (IOException)mutableObject.getValue();
        }
        return l;
    }

    @Override
    protected PostgresqlLockHandlerImpl instantiateDbLockHandler() {
        return new PostgresqlLockHandlerImpl(new JdbcTemplate(this.getRawDataSource()));
    }

    private void checkConnectionForUseLargeObject(Connection connection) throws SQLException {
        if (connection.getAutoCommit()) {
            throw new UnexpectedDataAccessException("Invalid auto-commit mode. A transaction is required to work with large objects");
        }
    }

    private long copyLargeObject(Connection connection, long l, boolean bl) throws SQLException, DataAccessException, IOException {
        LargeObjectManager largeObjectManager = this.getLargeObjectManager(connection);
        LargeObject largeObject = largeObjectManager.open(l, 262144);
        long l2 = largeObjectManager.createLO(393216);
        LargeObject largeObject2 = largeObjectManager.open(l2, 131072);
        try (InputStream inputStream = largeObject.getInputStream();
             OutputStream outputStream = largeObject2.getOutputStream();
             AutoCloseableWrapper autoCloseableWrapper = new AutoCloseableWrapper(largeObject);
             AutoCloseableWrapper autoCloseableWrapper2 = new AutoCloseableWrapper(largeObject2);){
            IOUtils.copyLarge((InputStream)inputStream, (OutputStream)outputStream);
        }
        if (bl) {
            largeObjectManager.delete(l);
        }
        return l2;
    }

    private LargeObjectManager getLargeObjectManager(Connection connection) throws SQLException {
        this.checkConnectionForUseLargeObject(connection);
        PGConnection pGConnection = connection.unwrap(PGConnection.class);
        return pGConnection.getLargeObjectAPI();
    }

    private IUserAccount preferredAccount(IUserAccount iUserAccount, IUserAccount iUserAccount2) {
        if (iUserAccount instanceof UserAccount) {
            return iUserAccount;
        }
        return iUserAccount2;
    }

    private IUserAccount toUserAccount(User user, Tuple tuple) {
        Long l = (Long)tuple.get(0, Long.class);
        Long l2 = (Long)tuple.get(1, Long.class);
        UserAccountType userAccountType = (UserAccountType)this.rawEntityManagerHandler.find(UserAccountType.class, (Long)tuple.get(2, Long.class));
        Date date = (Date)tuple.get(3, Date.class);
        String string = (String)tuple.get(4, String.class);
        Boolean bl = (Boolean)tuple.get(5, Boolean.class);
        if (bl == null) {
            bl = true;
        }
        Date date2 = (Date)tuple.get(6, Date.class);
        BigDecimal bigDecimal = (BigDecimal)tuple.get(7, BigDecimal.class);
        BigDecimal bigDecimal2 = (BigDecimal)tuple.get(8, BigDecimal.class);
        boolean bl2 = Boolean.TRUE.equals(tuple.get(9, Boolean.class));
        if (l != null) {
            UserAccount userAccount = new UserAccount(l, user, userAccountType, string, date, bl.booleanValue(), date2, bigDecimal, bigDecimal2, bl2);
            BigDecimal bigDecimal3 = (BigDecimal)tuple.get(10, BigDecimal.class);
            BigDecimal bigDecimal4 = (BigDecimal)tuple.get(11, BigDecimal.class);
            BigDecimal bigDecimal5 = (BigDecimal)tuple.get(12, BigDecimal.class);
            BigDecimal bigDecimal6 = (BigDecimal)tuple.get(13, BigDecimal.class);
            BigDecimal bigDecimal7 = (BigDecimal)tuple.get(14, BigDecimal.class);
            userAccount.setPaymentAmountLimit(bigDecimal3);
            userAccount.setPaymentAmountPerDayLimit(bigDecimal4);
            userAccount.setPaymentAmountPerWeekLimit(bigDecimal5);
            userAccount.setPaymentAmountPerMonthLimit(bigDecimal6);
            userAccount.setPaymentAmountPerYearLimit(bigDecimal7);
            userAccount.setAccountRatesId((Long)tuple.get(15, Long.class));
            return userAccount;
        }
        return new PendingUserAccount(l2, user, userAccountType, string, bl.booleanValue(), bigDecimal, bigDecimal2, bl2);
    }

    private /* synthetic */ Long lambda$writeLargeObject$32(InputStream inputStream, Mutable mutable, Connection connection) throws SQLException, DataAccessException {
        LargeObjectManager largeObjectManager = this.getLargeObjectManager(connection);
        long l = largeObjectManager.createLO(393216);
        LargeObject largeObject = largeObjectManager.open(l, 131072);
        try (OutputStream outputStream = largeObject.getOutputStream();
             AutoCloseableWrapper autoCloseableWrapper = new AutoCloseableWrapper(largeObject);){
            IOUtils.copyLarge((InputStream)inputStream, (OutputStream)outputStream);
        }
        catch (IOException iOException) {
            mutable.setValue((Object)iOException);
            return 0L;
        }
        return l;
    }

    private /* synthetic */ Long lambda$insertUserIncomingMessages$24(SMessages sMessages, SQLQuery sQLQuery, SGroups sGroups, Long l, OutgoingMessage outgoingMessage, Long l2, SUsers sUsers, Connection connection) throws SQLException, DataAccessException {
        return ((SQLInsertClause)((SQLInsertClause)this.insert(connection, (RelationalPath<?>)sMessages).columns(new Path[]{sMessages.subclass, sMessages.networkId, sMessages.categoryId, sMessages.date, sMessages.messageOwner, sMessages.fromOwner, sMessages.isRead, sMessages.isReplied, sMessages.subject, sMessages.body, sMessages.fromUserId, sMessages.ownerUserId, sMessages.conversationId})).select((SubQueryExpression)sQLQuery.select(new Expression[]{Expressions.constant((Object)MessageNature.INCOMING.name()), sGroups.networkId, l == null ? Expressions.nullExpression() : Expressions.constant((Object)l), Expressions.constant((Object)outgoingMessage.getDate()), Expressions.constant((Object)MessageOwner.USER.name()), Expressions.constant((Object)outgoingMessage.getMessageOwner().name()), Expressions.constant((Object)false), Expressions.constant((Object)false), Expressions.constant((Object)outgoingMessage.getSubject()), Expressions.constant((Object)outgoingMessage.getBody()), l2 == null ? Expressions.nullExpression() : Expressions.constant((Object)l2), sUsers.id, Expressions.constant((Object)outgoingMessage.getConversationId())}))).execute();
    }

    private static /* synthetic */ Account lambda$getAccountStatuses$13(Map map, NativeAccountStatusWithAccount nativeAccountStatusWithAccount) {
        return (Account)map.get(nativeAccountStatusWithAccount.getAccountId());
    }

    private /* synthetic */ Long lambda$copyLargeObject$0(long l, Mutable mutable, Connection connection) throws SQLException, DataAccessException {
        try {
            return this.copyLargeObject(connection, l, false);
        }
        catch (IOException iOException) {
            mutable.setValue((Object)iOException);
            return null;
        }
    }

    static {
        ProfilingServiceLocal.excludeMethodsFromProfilingContext(PostgresqlQueryHandlerImpl.class);
        HASH = Hashing.sipHash24();
        String string = " INSERT INTO background_task_executions (class_name, context, priority, display, submitted_at, scheduled_for, custom_id, fork_join_id) VALUES (?, ?, ?, ?, null, ?, ?, ?) ON CONFLICT (class_name, digest(context, 'sha512')) DO NOTHING RETURNING id";
        INSERT_BACKGROUND_TASK_EXECUTION_PS_FACTORY = new PreparedStatementCreatorFactory(string, new int[]{12, 12, 4, 12, 2014, -5, -5});
        INSERT_BACKGROUND_TASK_EXECUTION_PS_FACTORY.setReturnGeneratedKeys(true);
        INSERT_BACKGROUND_TASK_EXECUTION_PS_FACTORY.setGeneratedKeysColumnNames(new String[]{"id"});
        string = " INSERT INTO ip_geolocations (address, expiration_date, country, region, city, latitude, longitude) VALUES (?, ?, ?, ?, ?, ?, ?) ON CONFLICT (address) DO UPDATE SET expiration_date = ?, country = ?, region = ?, city = ?, latitude = ?, longitude = ? RETURNING id";
        INSERT_IP_GEOLOCATION_PS_FACTORY = new PreparedStatementCreatorFactory(string, new int[]{12, 2014, 12, 12, 12, 2, 2, 2014, 12, 12, 12, 2, 2});
        INSERT_IP_GEOLOCATION_PS_FACTORY.setReturnGeneratedKeys(true);
        INSERT_IP_GEOLOCATION_PS_FACTORY.setGeneratedKeysColumnNames(new String[]{"id"});
    }

    public static class CustomTemplates
    extends EclipseLinkTemplates {
        private static final CustomTemplates INSTANCE = new CustomTemplates();

        public static CustomTemplates getInstance() {
            return INSTANCE;
        }

        private CustomTemplates() {
            this.add((Operator)CustomOperator.UNIX_TIMESTAMP, "FUNCTION('cy_unix_timestamp', {0})");
            this.add((Operator)CustomOperator.ADD_INTERVAL, "FUNCTION('cy_add_interval', {0}, {1}, {2})");
            this.add((Operator)CustomOperator.ADD_DAYS, "FUNCTION('cy_add_days', {0}, {1})");
            this.add((Operator)CustomOperator.BALANCE_SUM, "FUNCTION('cy_balance_sum', {0}, {1}, {2}, {3}, {4})");
            this.add((Operator)CustomOperator.ACCOUNT_BALANCE1, "FUNCTION('cy_account_balance', {0})");
            this.add((Operator)CustomOperator.ACCOUNT_BALANCE2, "FUNCTION('cy_account_balance', {0}, {1})");
            this.add((Operator)CustomOperator.NAME_HIERARCHY, "FUNCTION('cy_name_hierarchy', {0}, {1}, {2}, {3})");
            this.add((Operator)CustomOperator.ORDER_HIERARCHY, "FUNCTION('cy_order_hierarchy', {0}, {1}, {2}, {3})");
        }
    }

    private class AutoCloseableWrapper
    implements AutoCloseable {
        private LargeObject lo;

        private AutoCloseableWrapper(LargeObject largeObject) {
            this.lo = largeObject;
        }

        @Override
        public void close() throws SQLException {
            if (this.lo == null) {
                return;
            }
            this.lo.close();
            this.lo = null;
        }
    }

    protected static class NativeAccountStatusWithAccount
    extends NativeAccountStatus {
        private Long accountId;

        protected NativeAccountStatusWithAccount() {
        }

        public Long getAccountId() {
            return this.accountId;
        }

        public void setAccountId(Long l) {
            this.accountId = l;
        }
    }
}

