/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.search.opensearch;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.lucene.search.join.ScoreMode;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.system.AccountNumberConfiguration;
import org.cyclos.entities.system.CustomField;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserCustomField;
import org.cyclos.entities.utils.DatePeriod;
import org.cyclos.entities.utils.DecimalRange;
import org.cyclos.entities.utils.IntegerRange;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.search.opensearch.OpenSearchAccessor;
import org.cyclos.impl.search.opensearch.SourceAccessor;
import org.cyclos.impl.utils.PhoneNumberDescriptor;
import org.cyclos.impl.utils.QueryHelper;
import org.cyclos.model.Property;
import org.cyclos.model.access.Permission;
import org.cyclos.model.system.fields.BaseValueForSearchDTO;
import org.cyclos.model.system.fields.CustomFieldValueForSearchDTO;
import org.cyclos.model.system.fields.ValueMatch;
import org.cyclos.model.users.addresses.AddressQueryField;
import org.cyclos.model.users.addresses.UserAddressVO;
import org.cyclos.model.users.groups.BasicGroupVO;
import org.cyclos.model.users.users.AddressFieldValueForSearchDTO;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.BasicProfileFieldValueForSearchDTO;
import org.cyclos.model.users.users.ProfileField;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.users.users.UserWithFieldsVO;
import org.cyclos.model.utils.DistanceDTO;
import org.cyclos.model.utils.IDatePeriod;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.model.utils.Range;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.MaskHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;
import org.opensearch.common.unit.DistanceUnit;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.ExistsQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.SimpleQueryStringBuilder;
import org.opensearch.index.query.TermQueryBuilder;
import org.opensearch.index.query.functionscore.ScoreFunctionBuilder;
import org.opensearch.index.query.functionscore.ScoreFunctionBuilders;
import org.opensearch.script.Script;

public class QueryAccessor
extends OpenSearchAccessor {
    private static final Pattern WORDS = Pattern.compile("[\\p{Punct}\\p{Space}]+");
    private static final Pattern SPACES = Pattern.compile("\\p{Space}+");
    private BoolQueryBuilder where = QueryBuilders.boolQuery();

    public static QueryBuilder invalidFilter() {
        return QueryBuilders.existsQuery((String)"__invalid__");
    }

    protected static QueryBuilder toAddressesQueryBuilder(DistanceDTO distanceDTO, boolean bl, boolean bl2, String string) {
        DistanceUnit distanceUnit;
        Object object;
        ExistsQueryBuilder existsQueryBuilder = null;
        String string2 = string + "." + UserAddressVO.LOCATION.getName();
        if (ModelHelper.isValid((DistanceDTO)distanceDTO)) {
            object = distanceDTO.getLocation();
            distanceUnit = InvocationContext.getSessionData().getConfiguration().getDistanceUnit() == org.cyclos.model.utils.DistanceUnit.MILE ? DistanceUnit.MILES : DistanceUnit.KILOMETERS;
            existsQueryBuilder = QueryBuilders.geoDistanceQuery((String)string2).distance(distanceDTO.getDistance().doubleValue(), distanceUnit).point(object.getLatitude().doubleValue(), object.getLongitude().doubleValue());
        } else if (bl) {
            existsQueryBuilder = QueryBuilders.existsQuery((String)string2);
        } else if (bl2) {
            existsQueryBuilder = QueryBuilders.existsQuery((String)string);
        }
        if (existsQueryBuilder != null) {
            if (!InvocationContext.getSessionData().hasPermission(Permission.USERS_VIEW_HIDDEN_FIELDS)) {
                object = string + "." + UserAddressVO.HIDDEN.getName();
                distanceUnit = QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termQuery((String)object, (boolean)true));
                existsQueryBuilder = QueryBuilders.boolQuery().filter((QueryBuilder)existsQueryBuilder).filter((QueryBuilder)distanceUnit);
            }
            return QueryBuilders.nestedQuery((String)string, (QueryBuilder)existsQueryBuilder, (ScoreMode)ScoreMode.None);
        }
        return null;
    }

    private static SimpleQueryStringBuilder queryString(String string2) {
        if (!(string2.contains("\"") || string2.contains("(") || string2.contains(")") || string2.contains("*") || string2.contains("?"))) {
            String[] stringArray = WORDS.split(string2);
            string2 = Stream.of(stringArray).map(string -> string + "*").collect(Collectors.joining(" "));
        }
        return QueryBuilders.simpleQueryStringQuery((String)string2);
    }

    public QueryAccessor() {
        Network network = InvocationContext.getSessionData().getNetwork();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"network"));
        if (network == null) {
            this.where.filter((QueryBuilder)boolQueryBuilder);
        } else {
            this.where.filter((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.termQuery((String)"network", (Object)network.getId())).should((QueryBuilder)boolQueryBuilder));
        }
    }

    public void customField(CustomField<?, ?, ?> customField, CustomFieldValueForSearchDTO customFieldValueForSearchDTO) {
        if (customField instanceof UserCustomField) {
            throw new IllegalStateException("For user fields, use the other form, with the canViewHidden flag");
        }
        this.customField(customField, customFieldValueForSearchDTO, true);
    }

    public void customField(CustomField<?, ?, ?> customField, CustomFieldValueForSearchDTO customFieldValueForSearchDTO, boolean bl) {
        Object object = this.customFieldValueHandler().getValueForSearch(customField, (Object)customFieldValueForSearchDTO, true);
        if (object == null) {
            return;
        }
        String string = QueryAccessor.baseName(customField);
        String string3 = StringHelper.trimToNull((Object)customFieldValueForSearchDTO.getStringValue());
        BoolQueryBuilder boolQueryBuilder = bl ? this.where : QueryBuilders.boolQuery();
        switch (customField.getType()) {
            case STRING: 
            case URL: 
            case TEXT: 
            case RICH_TEXT: {
                SimpleQueryStringBuilder simpleQueryStringBuilder = QueryAccessor.queryString(string3);
                ValueMatch valueMatch = (ValueMatch)ObjectHelper.defaultValue((Object)customField.getValueMatch(), (Object)ValueMatch.EXACT);
                switch (valueMatch) {
                    case EXACT: {
                        boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)QueryAccessor.keywordSuffix(string), (String)string3.toLowerCase()));
                        break;
                    }
                    case TEXT: {
                        boolQueryBuilder.must((QueryBuilder)simpleQueryStringBuilder.field(QueryAccessor.textSuffix(string)));
                        break;
                    }
                    case LANGUAGE: {
                        QueryAccessor.languageSuffixes(null).forEach(string2 -> simpleQueryStringBuilder.field(QueryAccessor.suffix(string, string2)));
                        boolQueryBuilder.must((QueryBuilder)simpleQueryStringBuilder);
                    }
                }
                break;
            }
            case SINGLE_SELECTION: 
            case MULTI_SELECTION: {
                Collection collection = (Collection)object;
                boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termsQuery((String)QueryAccessor.idSuffix(string), (Collection)collection));
                break;
            }
            case DYNAMIC_SELECTION: 
            case DYNAMIC_MULTI_SELECTION: {
                if (object instanceof CharSequence) {
                    boolQueryBuilder.must((QueryBuilder)QueryAccessor.queryString(string3).field(QueryAccessor.textSuffix(string)));
                    break;
                }
                if (!(object instanceof Collection)) break;
                Collection collection = (Collection)object;
                boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termsQuery((String)QueryAccessor.keywordSuffix(string), (Collection)collection));
                break;
            }
            case INTEGER: {
                IntegerRange integerRange = (IntegerRange)object;
                boolQueryBuilder.filter((QueryBuilder)QueryBuilders.rangeQuery((String)QueryAccessor.integerSuffix(string)).from((Object)integerRange.getMin(), true).to((Object)integerRange.getMax(), true));
                break;
            }
            case DECIMAL: {
                DecimalRange decimalRange = (DecimalRange)object;
                boolQueryBuilder.filter((QueryBuilder)QueryBuilders.rangeQuery((String)QueryAccessor.decimalSuffix(string)).from((Object)decimalRange.getMin(), true).to((Object)decimalRange.getMax(), true));
                break;
            }
            case DATE: {
                DatePeriod datePeriod = (DatePeriod)object;
                boolQueryBuilder.filter((QueryBuilder)QueryBuilders.rangeQuery((String)QueryAccessor.dateSuffix(string)).from((Object)datePeriod.getBegin(), true).to((Object)datePeriod.getEnd(), true));
                break;
            }
            case BOOLEAN: {
                boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)QueryAccessor.booleanSuffix(string), (Object)object));
                break;
            }
            case LINKED_ENTITY: {
                Collection collection = (Collection)object;
                boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termsQuery((String)QueryAccessor.idSuffix(string), (Collection)collection));
                break;
            }
            default: {
                return;
            }
        }
        if (!bl && boolQueryBuilder.hasClauses()) {
            this.where.must((QueryBuilder)boolQueryBuilder);
            this.where.mustNot((QueryBuilder)QueryBuilders.termQuery((String)"hiddenCustomProfileFields", (String)customField.getId().toString()));
        }
    }

    public <C extends CustomField<C, ?, ?>> void customFields(Class<C> clazz, Collection<CustomFieldValueForSearchDTO> collection, boolean bl, Predicate<C> predicate) {
        if (CollectionHelper.isEmpty(collection)) {
            return;
        }
        for (CustomFieldValueForSearchDTO customFieldValueForSearchDTO : collection) {
            CustomField customField = (CustomField)this.conversionHandler().convert(clazz, (Object)customFieldValueForSearchDTO.getField());
            if (!predicate.test(customField)) continue;
            this.customField(customField, customFieldValueForSearchDTO);
        }
    }

    public <C extends CustomField<C, ?, ?>> void customFields(Class<C> clazz, Collection<CustomFieldValueForSearchDTO> collection, Predicate<C> predicate) {
        this.customFields(clazz, collection, true, predicate);
    }

    public void entities(Property<?, ?> property, Collection<? extends SimpleEntity> collection) {
        this.entities(property.getName(), collection);
    }

    public void entities(String string, Collection<? extends SimpleEntity> collection) {
        Set set = SimpleEntity.uniqueIds(collection);
        if (CollectionHelper.isNotEmpty((Iterable)set)) {
            this.where.filter((QueryBuilder)QueryBuilders.termsQuery((String)string, (Collection)set));
        }
    }

    public void enums(Property<?, ?> property, Collection<? extends Enum<?>> collection) {
        this.enums(property.getName(), collection);
    }

    public void enums(String string, Collection<? extends Enum<?>> collection) {
        if (CollectionHelper.isNotEmpty(collection)) {
            this.where.filter((QueryBuilder)QueryBuilders.termsQuery((String)string, (Collection)collection.stream().map(Enum::name).collect(Collectors.toSet())));
        }
    }

    public BoolQueryBuilder filter(QueryBuilder queryBuilder) {
        return this.where.filter(queryBuilder);
    }

    public void invalid() {
        this.where.filter(QueryAccessor.invalidFilter());
    }

    public <CF extends CustomField<CF, ?, ?>> void keywords(String string2, Map<String, Float> map, Collection<String> collection, boolean bl) {
        String string3 = StringHelper.trimToNull((Object)string2);
        if (string3 == null) {
            return;
        }
        boolean bl2 = CollectionHelper.isNotEmpty(map);
        boolean bl3 = CollectionHelper.isNotEmpty(collection);
        if (!(bl2 || bl3 || bl)) {
            this.invalid();
        } else {
            BoolQueryBuilder boolQueryBuilder;
            QueryBuilder queryBuilder = bl2 ? QueryAccessor.queryString(string3).fields(map) : QueryAccessor.invalidFilter();
            QueryBuilder queryBuilder2 = QueryAccessor.invalidFilter();
            QueryBuilder queryBuilder3 = QueryAccessor.invalidFilter();
            if (bl3) {
                boolQueryBuilder = QueryBuilders.boolQuery();
                String[] stringArray = SPACES.split(string3.toLowerCase());
                collection.forEach(string -> boolQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)string, (String[])stringArray)));
                queryBuilder2 = boolQueryBuilder;
            }
            if (bl) {
                boolQueryBuilder = new BasicProfileFieldValueForSearchDTO();
                boolQueryBuilder.setField(BasicProfileField.PHONE);
                boolQueryBuilder.setStringValue(string2);
                queryBuilder3 = this.basicProfileFieldFilter(BasicProfileField.PHONE, (BaseValueForSearchDTO)boolQueryBuilder, InvocationContext.getSessionData().hasPermission(Permission.USERS_VIEW_HIDDEN_FIELDS));
            }
            this.where.must((QueryBuilder)QueryBuilders.boolQuery().should(queryBuilder).should(queryBuilder2).should(queryBuilder3));
        }
    }

    public BoolQueryBuilder must(QueryBuilder queryBuilder) {
        return this.where.must(queryBuilder);
    }

    public BoolQueryBuilder mustNot(QueryBuilder queryBuilder) {
        return this.where.mustNot(queryBuilder);
    }

    public void period(Property<?, ?> property, IDatePeriod iDatePeriod) {
        this.period(property.getName(), iDatePeriod);
    }

    public void period(String string, IDatePeriod iDatePeriod) {
        if (QueryHelper.useParameter((Object)iDatePeriod)) {
            DatePeriod datePeriod = (DatePeriod)this.conversionHandler().convert(DatePeriod.class, (Object)iDatePeriod);
            this.where.filter((QueryBuilder)QueryBuilders.rangeQuery((String)string).from((Object)datePeriod.getBegin()).to((Object)datePeriod.getEnd()));
        }
    }

    public BoolQueryBuilder queryBuilder() {
        return this.where;
    }

    public void randomScore() {
        this.where.must((QueryBuilder)QueryBuilders.functionScoreQuery((ScoreFunctionBuilder)ScoreFunctionBuilders.randomFunction().seed(System.currentTimeMillis())));
    }

    public void range(Property<?, ?> property, Range<?> range) {
        this.range(property.getName(), range);
    }

    public void range(String string, Range<?> range) {
        if (QueryHelper.useParameter(range)) {
            this.where.filter((QueryBuilder)QueryBuilders.rangeQuery((String)string).from((Object)range.getMin()).to((Object)range.getMax()));
        }
    }

    public void script(CharSequence charSequence, Map<String, Object> map) {
        this.script(QueryAccessor.newScript(charSequence, map));
    }

    public void script(Script script) {
        this.where.filter((QueryBuilder)QueryBuilders.scriptQuery((Script)script));
    }

    public BoolQueryBuilder should(QueryBuilder queryBuilder) {
        return this.where.should(queryBuilder);
    }

    public String toString() {
        return "{\n\"query\": " + this.where.toString() + "\n}";
    }

    public void user(Collection<ProfileField> collection, Collection<BaseValueForSearchDTO> collection2, Collection<? extends BasicGroupVO> collection3, Collection<? extends UserVO> collection4, Boolean bl, Boolean bl2) {
        ExistsQueryBuilder existsQueryBuilder;
        BoolQueryBuilder boolQueryBuilder2;
        Object object;
        Set set;
        boolean bl3 = InvocationContext.getSessionData().hasPermission(Permission.USERS_VIEW_HIDDEN_FIELDS);
        Set set2 = SimpleEntity.uniqueIds((Collection)this.groupsHandler().flattenVOs(collection3));
        if (!set2.isEmpty()) {
            this.where.filter((QueryBuilder)QueryBuilders.termsQuery((String)UserWithFieldsVO.GROUP.getName(), (Collection)set2));
        }
        if (!(set = this.conversionHandler().convertSet(User.class, collection4)).isEmpty()) {
            object = SimpleEntity.uniqueIds((Collection)set);
            if (bl != null) {
                if (bl.booleanValue()) {
                    this.where.filter((QueryBuilder)QueryBuilders.termsQuery((String)UserWithFieldsVO.MAIN_BROKER.getName(), (Collection)object));
                } else {
                    this.where.filter((QueryBuilder)QueryBuilders.termsQuery((String)"otherBrokers", (Collection)object));
                }
            } else {
                boolQueryBuilder2 = QueryBuilders.boolQuery();
                boolQueryBuilder2.should((QueryBuilder)QueryBuilders.termsQuery((String)UserWithFieldsVO.MAIN_BROKER.getName(), (Collection)object));
                boolQueryBuilder2.should((QueryBuilder)QueryBuilders.termsQuery((String)"otherBrokers", (Collection)object));
                this.where.filter((QueryBuilder)boolQueryBuilder2);
            }
        }
        if (bl2 != null) {
            object = QueryBuilders.boolQuery();
            boolQueryBuilder2 = QueryBuilders.existsQuery((String)UserWithFieldsVO.MAIN_BROKER.getName());
            existsQueryBuilder = QueryBuilders.existsQuery((String)"otherBrokers");
            if (bl2.booleanValue()) {
                object.should((QueryBuilder)boolQueryBuilder2);
                object.should((QueryBuilder)existsQueryBuilder);
            } else {
                object.mustNot((QueryBuilder)boolQueryBuilder2);
                object.mustNot((QueryBuilder)existsQueryBuilder);
            }
            this.where.filter((QueryBuilder)object);
        }
        if (CollectionHelper.isEmpty(collection)) {
            return;
        }
        for (BoolQueryBuilder boolQueryBuilder2 : CollectionHelper.orEmpty(collection2)) {
            Object object2;
            BasicProfileField basicProfileField;
            if (boolQueryBuilder2 instanceof BasicProfileFieldValueForSearchDTO) {
                existsQueryBuilder = (BasicProfileFieldValueForSearchDTO)boolQueryBuilder2;
                basicProfileField = existsQueryBuilder.getField();
                if (!collection.contains(basicProfileField) || (object2 = this.basicProfileFieldFilter(basicProfileField, (BaseValueForSearchDTO)boolQueryBuilder2, bl3)) == null) continue;
                this.where.must(object2);
                continue;
            }
            if (boolQueryBuilder2 instanceof CustomFieldValueForSearchDTO) {
                existsQueryBuilder = (CustomFieldValueForSearchDTO)boolQueryBuilder2;
                basicProfileField = (UserCustomField)this.conversionHandler().convert(UserCustomField.class, (Object)existsQueryBuilder.getField());
                if (!collection.contains(basicProfileField)) continue;
                this.customField((CustomField<?, ?, ?>)basicProfileField, (CustomFieldValueForSearchDTO)existsQueryBuilder, bl3);
                continue;
            }
            if (!(boolQueryBuilder2 instanceof AddressFieldValueForSearchDTO) || !collection.contains(BasicProfileField.ADDRESS)) continue;
            existsQueryBuilder = (AddressFieldValueForSearchDTO)boolQueryBuilder2;
            basicProfileField = existsQueryBuilder.getAddressField();
            object2 = this.nestedAddressName("addresses", (AddressQueryField)basicProfileField);
            String string = StringHelper.trimToNull((Object)boolQueryBuilder2.getStringValue());
            if (string == null) continue;
            TermQueryBuilder termQueryBuilder = null;
            switch (1.$SwitchMap$org$cyclos$model$users$addresses$AddressQueryField[basicProfileField.ordinal()]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    termQueryBuilder = QueryAccessor.queryString(string).field((String)object2);
                    break;
                }
                case 5: 
                case 6: {
                    object2 = QueryAccessor.keywordSuffix((String)object2);
                    termQueryBuilder = QueryBuilders.termQuery((String)object2, (String)StringHelper.removeNonAlpha((String)string));
                    break;
                }
                case 7: {
                    termQueryBuilder = QueryBuilders.termQuery((String)object2, (String)string);
                }
            }
            if (termQueryBuilder == null) continue;
            this.where.filter((QueryBuilder)QueryBuilders.nestedQuery((String)"addresses", (QueryBuilder)termQueryBuilder, (ScoreMode)ScoreMode.None));
        }
    }

    private QueryBuilder basicProfileFieldFilter(BasicProfileField basicProfileField, BaseValueForSearchDTO baseValueForSearchDTO, boolean bl) {
        String string = SourceAccessor.storedFieldName(basicProfileField);
        switch (basicProfileField) {
            case IMAGE: {
                if (baseValueForSearchDTO.getBooleanValue() == null) break;
                return QueryBuilders.termQuery((String)"hasProfileImage", (Object)baseValueForSearchDTO.getBooleanValue());
            }
            case ADDRESS: {
                String string2 = StringHelper.trimToNull((Object)baseValueForSearchDTO.getStringValue());
                if (string2 == null) break;
                SimpleQueryStringBuilder simpleQueryStringBuilder = QueryAccessor.queryString(string2).field(QueryAccessor.publicSuffix(string), 1.0f);
                if (bl) {
                    simpleQueryStringBuilder.field(QueryAccessor.privateSuffix(string), 1.0f);
                }
                return simpleQueryStringBuilder;
            }
            case PHONE: {
                if (!StringHelper.isNotBlank((Object)baseValueForSearchDTO.getStringValue())) break;
                PhoneNumberDescriptor phoneNumberDescriptor = this.getPhoneNumberHandler().parse(baseValueForSearchDTO.getStringValue(), InvocationContext.getSessionData().getConfiguration());
                if (phoneNumberDescriptor == null) {
                    return QueryAccessor.invalidFilter();
                }
                TermQueryBuilder termQueryBuilder = QueryBuilders.termQuery((String)QueryAccessor.publicSuffix(string), (String)phoneNumberDescriptor.toE164());
                if (bl) {
                    return QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.termQuery((String)QueryAccessor.privateSuffix(string), (String)phoneNumberDescriptor.toE164())).should((QueryBuilder)termQueryBuilder);
                }
                return termQueryBuilder;
            }
            case FULL_NAME: {
                String string3 = StringHelper.trimToNull((Object)baseValueForSearchDTO.getStringValue());
                if (string3 == null) break;
                return QueryAccessor.queryString(string3).field(string, 1.5f);
            }
            case LOGIN_NAME: {
                String string4 = StringHelper.trimToNull((Object)baseValueForSearchDTO.getStringValue());
                if (string4 == null) break;
                return QueryBuilders.termQuery((String)string, (String)string4.toLowerCase());
            }
            case EMAIL: {
                String string5 = StringHelper.trimToNull((Object)baseValueForSearchDTO.getStringValue());
                if (string5 == null) break;
                TermQueryBuilder termQueryBuilder = QueryBuilders.termQuery((String)string, (String)string5.toLowerCase());
                if (bl) {
                    return termQueryBuilder;
                }
                return QueryBuilders.boolQuery().must((QueryBuilder)termQueryBuilder).mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"hideEmail"));
            }
            case ACCOUNT_NUMBER: {
                String string6 = StringHelper.trimToNull((Object)baseValueForSearchDTO.getStringValue());
                if (string6 == null) break;
                AccountNumberConfiguration accountNumberConfiguration = InvocationContext.getSessionData().getConfiguration().getAccountNumberConfiguration();
                if (accountNumberConfiguration == null || !accountNumberConfiguration.isEnabled()) {
                    return QueryAccessor.invalidFilter();
                }
                string6 = MaskHelper.removeMask((String)accountNumberConfiguration.getMask(), (String)string6);
                return QueryBuilders.termQuery((String)string, (String)string6.toLowerCase());
            }
        }
        return null;
    }

    private String nestedAddressName(String string, AddressQueryField addressQueryField) {
        return string + "." + addressQueryField.internalName();
    }
}

