/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.search.opensearch;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.access.Agreement;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.banking.QUserAccount;
import org.cyclos.entities.banking.UserAccount;
import org.cyclos.entities.banking.UserAccountType;
import org.cyclos.entities.system.Image;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.GeoLocatedAddress;
import org.cyclos.entities.users.Group;
import org.cyclos.entities.users.Phone;
import org.cyclos.entities.users.Product;
import org.cyclos.entities.users.QUser;
import org.cyclos.entities.users.RoleContainer;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserGroup;
import org.cyclos.entities.utils.DatePeriod;
import org.cyclos.entities.utils.DateRange;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.access.LoginServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.search.UserSearchHandler;
import org.cyclos.impl.search.opensearch.OpenSearchAccessor;
import org.cyclos.impl.search.opensearch.OpenSearchEntitySearchHandlerImpl;
import org.cyclos.impl.search.opensearch.OpenSearchHandlerImpl;
import org.cyclos.impl.search.opensearch.QueryAccessor;
import org.cyclos.impl.search.opensearch.ResultsCollector;
import org.cyclos.impl.search.opensearch.SourceAccessor;
import org.cyclos.impl.sql.AccountStatusUpdateResult;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.users.BulkActionServiceLocal;
import org.cyclos.impl.users.GroupList;
import org.cyclos.impl.users.ProductServiceLocal;
import org.cyclos.impl.users.ProfileFieldSearchContext;
import org.cyclos.impl.users.UserCustomFieldServiceLocal;
import org.cyclos.impl.users.UserProductsQueryResult;
import org.cyclos.impl.utils.PermissionHelper;
import org.cyclos.impl.utils.PhoneNumberHandler;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.model.Bean;
import org.cyclos.model.EntityVO;
import org.cyclos.model.Property;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.UnexpectedDataAccessException;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.banking.accounts.BalanceLevel;
import org.cyclos.model.banking.accounts.UserWithBalanceOrderBy;
import org.cyclos.model.banking.accounts.UserWithBalanceQuery;
import org.cyclos.model.banking.accounts.UserWithBalanceVO;
import org.cyclos.model.banking.accounts.UsersWithBalancesOverview;
import org.cyclos.model.banking.currencies.CurrencyVO;
import org.cyclos.model.system.fields.HasValueMatch;
import org.cyclos.model.users.addresses.GeoLocatedAddressVO;
import org.cyclos.model.users.addresses.UserAddressResult;
import org.cyclos.model.users.addresses.UserAddressVO;
import org.cyclos.model.users.groups.GroupVO;
import org.cyclos.model.users.groups.UserGroupVO;
import org.cyclos.model.users.users.AbstractUserQuery;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.ProfileField;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserOrderBy;
import org.cyclos.model.users.users.UserQuery;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.users.users.UserWithFieldsVO;
import org.cyclos.model.users.users.ViewProfileData;
import org.cyclos.model.utils.AmountSummaryVO;
import org.cyclos.model.utils.DecimalRangeDTO;
import org.cyclos.model.utils.DistanceDTO;
import org.cyclos.model.utils.IDatePeriod;
import org.cyclos.model.utils.IIntegerRange;
import org.cyclos.model.utils.IntegerRangeDTO;
import org.cyclos.model.utils.LatLongDTO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.server.utils.DataIterator;
import org.cyclos.utils.BigDecimalHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.MaskHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Page;
import org.cyclos.utils.PageImpl;
import org.cyclos.utils.StringHelper;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.ExistsQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.TermsQueryBuilder;
import org.opensearch.index.query.functionscore.ScoreFunctionBuilder;
import org.opensearch.index.query.functionscore.ScoreFunctionBuilders;
import org.opensearch.index.reindex.UpdateByQueryRequest;
import org.opensearch.search.SearchHit;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregationBuilders;
import org.opensearch.search.aggregations.Aggregations;
import org.opensearch.search.aggregations.bucket.range.Range;
import org.opensearch.search.aggregations.bucket.range.RangeAggregationBuilder;
import org.opensearch.search.aggregations.metrics.Stats;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.sort.FieldSortBuilder;
import org.opensearch.search.sort.NestedSortBuilder;
import org.opensearch.search.sort.SortBuilder;
import org.opensearch.search.sort.SortBuilders;
import org.opensearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

public class OpenSearchUserSearchHandlerImpl
extends OpenSearchEntitySearchHandlerImpl<User, UserQuery, UserWithFieldsVO>
implements UserSearchHandler {
    private static final String INDEX = "users";
    public static final String VERSION = "16";
    private static final String RAW_USERNAME = "username$raw";
    private static final String RAW_EMAIL = "email$raw";
    private static final String PREFERRED_PHONE = "preferredPhone";
    private static final String CREATION_DATE = "creationDate";
    private static final String ACTIVATION_DATE = "activationDate";
    private static final String LAST_LOGIN = "lastLogin";
    private static final String ROLE = "role";
    private static final String INDIVIDUAL_PRODUCTS = "individualProducts";
    private static final String ACCEPTED_AGREEMENTS = "acceptedAgreements";
    @Autowired
    @Lazy
    private AccountServiceLocal accountService;
    @Autowired
    @Lazy
    private LoginServiceLocal loginService;
    @Autowired
    @Lazy
    private ProductServiceLocal productService;
    @Autowired
    @Lazy
    private UserCustomFieldServiceLocal userCustomFieldService;
    @Autowired
    private PhoneNumberHandler phoneNumberHandler;

    public OpenSearchUserSearchHandlerImpl(OpenSearchHandlerImpl openSearchHandlerImpl) {
        super(openSearchHandlerImpl, User.class, QUser.user);
    }

    public DataIterator<UserWithBalanceVO> exportWithBalances(UserWithBalanceQuery userWithBalanceQuery) {
        UserAccountType userAccountType = this.accountType(userWithBalanceQuery);
        return this.export(userWithBalanceQuery, this.toWhere(userWithBalanceQuery), this.getWithBalancesSort(userWithBalanceQuery, userAccountType), this.getWithBalancesCollector(userWithBalanceQuery, userAccountType, InvocationContext.getSessionData()));
    }

    public UsersWithBalancesOverview getBalancesOverview(UserWithBalanceQuery userWithBalanceQuery) {
        AmountSummaryVO amountSummaryVO;
        Range range;
        SearchResponse searchResponse;
        UserAccountType userAccountType = this.accountType(userWithBalanceQuery);
        IntegerRangeDTO integerRangeDTO = userWithBalanceQuery.getYellowBalanceRange();
        Integer n = integerRangeDTO == null ? null : integerRangeDTO.getMin();
        Integer n2 = integerRangeDTO == null ? null : integerRangeDTO.getMax();
        boolean bl = n != null && n2 != null;
        String string = this.balanceField(userAccountType.getId());
        Object object = bl ? ((RangeAggregationBuilder)AggregationBuilders.range((String)"ranges").field(string)).addRange(BalanceLevel.LOW.name(), 0.0, (double)n.intValue()).addRange(BalanceLevel.MEDIUM.name(), (double)n.intValue(), (double)n2.intValue()).addRange(BalanceLevel.HIGH.name(), (double)n2.intValue(), 3.4028234663852886E38).subAggregation((AggregationBuilder)AggregationBuilders.stats((String)"stats").field(string)) : AggregationBuilders.stats((String)"general").field(string);
        SearchRequest searchRequest = new SearchRequest(new String[]{this.indexName()}).source(new SearchSourceBuilder().query(this.toWhere(userWithBalanceQuery)).size(0).aggregation((AggregationBuilder)object));
        try {
            searchResponse = this.client.search(searchRequest, this.requestOptions);
        }
        catch (Exception exception) {
            throw new UnexpectedDataAccessException((Throwable)exception);
        }
        boolean bl2 = this.processResponse(searchResponse);
        CurrencyVO currencyVO = (CurrencyVO)this.conversionHandler.convert(CurrencyVO.class, (Object)userAccountType.getCurrency());
        Aggregations aggregations = searchResponse.getAggregations();
        EnumMap<BalanceLevel, AmountSummaryVO> enumMap = null;
        if (bl) {
            range = (Range)aggregations.get("ranges");
            enumMap = new EnumMap<BalanceLevel, AmountSummaryVO>(BalanceLevel.class);
            int n3 = 0;
            double d = 0.0;
            for (Range.Bucket bucket : range.getBuckets()) {
                BalanceLevel balanceLevel = BalanceLevel.valueOf((String)bucket.getKeyAsString());
                AmountSummaryVO amountSummaryVO2 = this.toAmountSummaryVO(bucket.getAggregations(), "stats", currencyVO);
                n3 += amountSummaryVO2.getCount();
                d += amountSummaryVO2.getSum().doubleValue();
                enumMap.put(balanceLevel, amountSummaryVO2);
            }
            amountSummaryVO = ModelHelper.amountSummary((BigDecimal)new BigDecimal(d), (BigDecimal)(n3 == 0 ? BigDecimal.ZERO : new BigDecimal(d / (double)n3)), (int)n3, (CurrencyVO)currencyVO);
        } else {
            amountSummaryVO = this.toAmountSummaryVO(aggregations, "general", currencyVO);
        }
        range = new UsersWithBalancesOverview();
        range.setGeneralOverview(amountSummaryVO);
        range.setOverviewByRange(enumMap);
        range.setPartialData(bl2);
        return range;
    }

    public String indexName() {
        return INDEX;
    }

    @Override
    public String indexVersion() {
        return VERSION;
    }

    public void onBrokerChange(User user) {
        this.updateTrans(user.getId());
        this.updateUserFields(user);
    }

    public void onGroupChange(User user) {
        this.updateTrans(user.getId());
        this.updateUserFields(user);
    }

    public Page<UserWithBalanceVO> searchWithBalances(UserWithBalanceQuery userWithBalanceQuery) {
        UserAccountType userAccountType = this.accountType(userWithBalanceQuery);
        try {
            return this.search(userWithBalanceQuery, this.toWhere(userWithBalanceQuery), this.getWithBalancesSort(userWithBalanceQuery, userAccountType), this.getWithBalancesCollector(userWithBalanceQuery, userAccountType, InvocationContext.getSessionData()));
        }
        catch (ValidationException validationException) {
            if (Boolean.TRUE.equals(validationException.getAttribute("missingSortField"))) {
                return PageImpl.empty();
            }
            throw validationException;
        }
    }

    public void updateBalances(Map<UserAccount, AccountStatusUpdateResult> map) {
        Set set = SimpleEntity.uniqueIds(map.keySet());
        Function<Exception, BulkRequest> function = exception -> {
            BulkRequest bulkRequest = new BulkRequest();
            set.forEach(l -> {
                UserAccount userAccount = (UserAccount)this.rawEntityManagerHandler.find(UserAccount.class, l);
                bulkRequest.add(this.updateAccount(userAccount));
            });
            return bulkRequest;
        };
        this.searchHandler.scheduleBulk(function, null, null);
    }

    public void updateLastLogin(User user) {
        Function<Exception, UpdateRequest> function = exception -> {
            User user2 = (User)this.find(user.getId());
            DateRange dateRange = this.loginService.getFirstAndLastLogin((BasicUser)user2);
            Date date = dateRange == null ? null : dateRange.getMax();
            UpdateRequest updateRequest = ((UpdateRequest)new UpdateRequest().index(this.indexName())).id(user2.getId().toString());
            SourceAccessor sourceAccessor = new SourceAccessor();
            sourceAccessor.set(LAST_LOGIN, (Object)date);
            updateRequest.doc(sourceAccessor.map());
            return updateRequest;
        };
        this.searchHandler.scheduleUpdate(function, null, null);
    }

    public void updateUserFields(User user, boolean bl) {
        Function<Exception, UpdateRequest> function;
        Supplier<SourceAccessor> supplier = () -> {
            User user2 = (User)this.find(user.getId());
            List list = this.contactInfoFieldService.listForMap();
            List list2 = user2.getAddresses().stream().map(userAddress -> SourceAccessor.from((GeoLocatedAddress)userAddress, list).map()).collect(Collectors.toList());
            SourceAccessor sourceAccessor = new SourceAccessor();
            sourceAccessor.setUserFields(user2, null);
            sourceAccessor.set("addresses", list2);
            sourceAccessor.set((Property<?, ?>)UserWithFieldsVO.IMAGE, (Object)SourceAccessor.from((Image)user2.getImage()));
            return sourceAccessor;
        };
        if (bl) {
            function = exception -> {
                UpdateRequest updateRequest = new UpdateRequest(this.indexName(), user.getId().toString());
                updateRequest.doc(((SourceAccessor)supplier.get()).map());
                return updateRequest;
            };
            this.searchHandler.scheduleUpdate(function, null, null);
        }
        function = exception -> {
            SourceAccessor sourceAccessor = (SourceAccessor)supplier.get();
            sourceAccessor.setOwnerUser(user, this.userCustomFieldService.listAll());
            UpdateByQueryRequest updateByQueryRequest = new UpdateByQueryRequest(new String[]{this.searchHandler.record().indexName(), this.searchHandler.ad().indexName()});
            updateByQueryRequest.setScript(this.loadScript("update-user-fields", sourceAccessor.map()));
            updateByQueryRequest.setConflicts("proceed");
            updateByQueryRequest.setQuery((QueryBuilder)QueryBuilders.termQuery((String)"owner", (String)user.getId().toString()));
            return updateByQueryRequest;
        };
        this.searchHandler.scheduleUpdateByQuery(function, null, null);
    }

    @Override
    protected void fillSource(User user, SourceAccessor sourceAccessor) {
        sourceAccessor.set("displayForManagers", (Object)user.getDisplayForManagers());
        sourceAccessor.set("displayForOthers", (Object)user.getDisplayForOthers());
        sourceAccessor.setUserFields(user, null);
        String string = user.getName();
        if (string != null) {
            sourceAccessor.set(OpenSearchAccessor.sortFieldName(BasicProfileField.FULL_NAME), (Object)StringHelper.unaccent((String)string).toLowerCase());
        }
        sourceAccessor.set(RAW_USERNAME, (Object)user.getUsername());
        sourceAccessor.set(RAW_EMAIL, (Object)user.getEmail());
        sourceAccessor.set(CREATION_DATE, (Object)user.getCreationDate());
        sourceAccessor.set(ACTIVATION_DATE, (Object)user.getActivationDate());
        sourceAccessor.set((Property<?, ?>)ViewProfileData.INVITED_BY, (Object)user.getInvitedBy());
        DateRange dateRange = this.loginService.getFirstAndLastLogin((BasicUser)user);
        sourceAccessor.set(LAST_LOGIN, (Object)(dateRange == null ? null : dateRange.getMax()));
        List list = this.contactInfoFieldService.listForMap();
        sourceAccessor.set("addresses", user.getAddresses().stream().map(userAddress -> SourceAccessor.from((GeoLocatedAddress)userAddress, list)).collect(Collectors.toList()));
        sourceAccessor.set((Property<?, ?>)UserWithFieldsVO.IMAGE, (Object)SourceAccessor.from((Image)user.getImage()), true);
        Phone phone = user.getPreferredPhone();
        if (phone != null) {
            sourceAccessor.set(PREFERRED_PHONE, (Object)phone.getNormalizedNumber(), true);
        }
        sourceAccessor.set(ROLE, (Object)PermissionHelper.allRoles((RoleContainer)user));
        sourceAccessor.set(INDIVIDUAL_PRODUCTS, (Object)user.getProductIds());
        sourceAccessor.set(ACCEPTED_AGREEMENTS, (Object)StringHelper.toLongSet((String)user.getAcceptedAgreementIds()));
        this.appendAccounts(user, sourceAccessor);
    }

    @Override
    protected Page<UserWithFieldsVO> preExecuteSearch(UserQuery userQuery) {
        if (ModelHelper.isValid((UserLocatorVO)userQuery.getContactsOwner()) || userQuery.isMessagesEnabled()) {
            return this.nativeQueryHandler.getSearchHandler().user().search((QueryParameters)userQuery);
        }
        return null;
    }

    @Override
    protected ResultsCollector<UserQuery, UserWithFieldsVO> resultsCollector(UserQuery userQuery2) {
        SessionData sessionData = InvocationContext.getSessionData();
        List<ProfileField> list = this.getProfileFieldsInList((AbstractUserQuery)userQuery2);
        return (userQuery, list2, searchHit) -> this.collectUserWithFieldsVOs(sessionData, list, (UserQuery)userQuery, list2, searchHit);
    }

    @Override
    protected List<SortBuilder<?>> toSort(UserQuery userQuery) {
        UserOrderBy userOrderBy = (UserOrderBy)ObjectHelper.defaultValue((Object)userQuery.getOrderBy(), (Object)InvocationContext.getSessionData().getConfiguration().getUsersSortOrder());
        if (userOrderBy == UserOrderBy.RELEVANCE && StringHelper.isBlank((Object)userQuery.getKeywords()) || userOrderBy == UserOrderBy.DISTANCE && !ModelHelper.isValid((DistanceDTO)userQuery.getDistance())) {
            userOrderBy = UserOrderBy.CREATION_DATE;
        }
        switch ((UserOrderBy)ObjectHelper.defaultValue((Object)userOrderBy, (Object)UserOrderBy.RELEVANCE)) {
            case ALPHABETICALLY_ASC: 
            case ALPHABETICALLY_DESC: {
                List<ProfileField> list = this.getProfileFieldsInList((AbstractUserQuery)userQuery);
                return this.alphabeticSort(list, userOrderBy == UserOrderBy.ALPHABETICALLY_ASC);
            }
            case CREATION_DATE: {
                return Collections.singletonList(SortBuilders.fieldSort((String)CREATION_DATE).order(SortOrder.DESC));
            }
            case DISTANCE: {
                String string = GeoLocatedAddressVO.LOCATION.getName();
                LatLongDTO latLongDTO = userQuery.getDistance().getLocation();
                double d = latLongDTO.getLatitude().doubleValue();
                double d2 = latLongDTO.getLongitude().doubleValue();
                return Collections.singletonList(SortBuilders.geoDistanceSort((String)("addresses." + string), (double)d, (double)d2).setNestedSort(new NestedSortBuilder("addresses")).order(SortOrder.ASC));
            }
        }
        return null;
    }

    @Override
    protected QueryBuilder toWhere(UserQuery userQuery) {
        BoolQueryBuilder boolQueryBuilder = this.toWhere((AbstractUserQuery)userQuery);
        if (userQuery.getOrderBy() == UserOrderBy.RANDOM) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.functionScoreQuery((ScoreFunctionBuilder)ScoreFunctionBuilders.randomFunction().seed(System.currentTimeMillis())));
        }
        return boolQueryBuilder;
    }

    private String accountNumberField(Long l) {
        return OpenSearchAccessor.keywordSuffix("accountNumber_" + l);
    }

    private UserAccountType accountType(UserWithBalanceQuery userWithBalanceQuery) {
        UserAccountType userAccountType = (UserAccountType)this.conversionHandler.convert(UserAccountType.class, (Object)userWithBalanceQuery.getAccountType());
        if (userAccountType == null) {
            throw new ValidationException();
        }
        return userAccountType;
    }

    private List<SortBuilder<?>> alphabeticSort(List<ProfileField> list, boolean bl) {
        SortOrder sortOrder = bl ? SortOrder.ASC : SortOrder.DESC;
        ArrayList arrayList = new ArrayList();
        if (CollectionHelper.isEmpty(list)) {
            boolean bl2 = InvocationContext.getSessionData().hasPermission(Permission.USERS_VIEW_HIDDEN_FIELDS);
            arrayList.add(SortBuilders.fieldSort((String)(bl2 ? "displayForManagers" : "displayForOthers")).order(sortOrder));
        } else {
            for (ProfileField profileField : list) {
                String string = SourceAccessor.sortFieldName((HasValueMatch)profileField);
                if (string == null) continue;
                arrayList.add((SortBuilder<?>)((FieldSortBuilder)SortBuilders.fieldSort((String)string).order(sortOrder)).unmappedType("keyword"));
            }
        }
        return arrayList;
    }

    private void appendAccounts(User user, SourceAccessor sourceAccessor) {
        QUserAccount qUserAccount = QUserAccount.userAccount;
        Map map = ((DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{qUserAccount}).where((Predicate)qUserAccount.user().eq((Object)user))).map((Expression)qUserAccount.type().id, (Expression)qUserAccount.balance());
        Collection collection = this.nativeQueryHandler.userAccounts(user, null, false, null).values();
        collection.forEach(iUserAccount -> {
            UserAccountType userAccountType = iUserAccount.getAccountType();
            Long l = userAccountType.getId();
            sourceAccessor.set(this.balanceField(l), (Object)BigDecimalHelper.zeroWhenNull((BigDecimal)((BigDecimal)map.get(l))));
            sourceAccessor.set(this.accountNumberField(l), (Object)iUserAccount.getNumber());
            sourceAccessor.set(this.negativeSinceField(l), (Object)iUserAccount.getNegativeSince());
        });
    }

    private String balanceField(Long l) {
        return OpenSearchAccessor.decimalSuffix("balance_" + l);
    }

    private void collectUserWithFieldsVOs(SessionData sessionData, List<ProfileField> list, UserQuery userQuery, List<UserWithFieldsVO> list2, SearchHit searchHit) {
        UserWithFieldsVO userWithFieldsVO = this.toUserWithFieldsVO(sessionData, UserWithFieldsVO.class, list, (AbstractUserQuery)userQuery, searchHit);
        UserAddressResult userAddressResult = (UserAddressResult)ObjectHelper.defaultValue((Object)userQuery.getAddressResult(), (Object)UserAddressResult.NO_ADDRESSES);
        DistanceDTO distanceDTO = userQuery.getDistance();
        LatLongDTO latLongDTO = ModelHelper.isValid((DistanceDTO)distanceDTO) ? distanceDTO.getLocation() : null;
        Double d = latLongDTO == null ? null : Double.valueOf(distanceDTO.getDistance().doubleValue());
        List list3 = this.contactInfoFieldService.listForMap();
        List list4 = CollectionHelper.orEmpty((List)((List)searchHit.getSourceAsMap().get("addresses")));
        boolean bl = InvocationContext.getSessionData().hasPermission(Permission.USERS_VIEW_HIDDEN_FIELDS);
        switch (userAddressResult) {
            case DEFAULT_ADDRESS: {
                Map map2 = list4.stream().filter(map -> Boolean.TRUE.equals(map.get(UserAddressVO.DEFAULT_ADDRESS.getName()))).filter(map -> bl || Boolean.FALSE.equals(map.get(UserAddressVO.HIDDEN.getName()))).findAny().orElse(null);
                if (map2 != null) {
                    userWithFieldsVO.setAddress(new SourceAccessor(map2).asUserAddressVO(sessionData, latLongDTO, list3));
                }
                list2.add(userWithFieldsVO);
                break;
            }
            case NEAREST_ADDRESS: 
            case ALL_LOCATED_ADDRESSES: {
                List<UserAddressVO> list5 = list4.stream().map(map -> new SourceAccessor((Map<String, Object>)map).asUserAddressVO(sessionData, latLongDTO, list3)).filter(userAddressVO -> bl || !userAddressVO.isHidden()).collect(Collectors.toList());
                if (userAddressResult == UserAddressResult.NEAREST_ADDRESS) {
                    list5.stream().filter(userAddressVO -> userAddressVO.getCurrentDistance() != null).sorted(Comparator.comparing(GeoLocatedAddressVO::getCurrentDistance)).findFirst().ifPresent(arg_0 -> ((UserWithFieldsVO)userWithFieldsVO).setAddress(arg_0));
                    list2.add(userWithFieldsVO);
                    break;
                }
                if (d != null) {
                    list5.removeIf(userAddressVO -> userAddressVO.getCurrentDistance() == null || userAddressVO.getCurrentDistance() > d);
                }
                if (list5.size() == 1) {
                    userWithFieldsVO.setAddress((UserAddressVO)CollectionHelper.first(list5));
                    list2.add(userWithFieldsVO);
                    break;
                }
                list5.forEach(userAddressVO -> {
                    UserWithFieldsVO userWithFieldsVO2 = new UserWithFieldsVO();
                    userWithFieldsVO.copyPropertiesTo((Bean)userWithFieldsVO2);
                    userWithFieldsVO2.setAddress(userAddressVO);
                    list2.add(userWithFieldsVO2);
                });
                break;
            }
            default: {
                list2.add(userWithFieldsVO);
            }
        }
    }

    private void filterByProducts(BoolQueryBuilder boolQueryBuilder, Collection<? extends Product> collection, boolean bl) {
        if (CollectionHelper.isNotEmpty(collection)) {
            Set set = SimpleEntity.uniqueIds(collection);
            TermsQueryBuilder termsQueryBuilder = QueryBuilders.termsQuery((String)INDIVIDUAL_PRODUCTS, (Collection)set);
            if (bl) {
                boolQueryBuilder.filter((QueryBuilder)termsQueryBuilder);
            } else {
                UserProductsQueryResult userProductsQueryResult = this.productService.productQuery(collection);
                Set set2 = SimpleEntity.uniqueIds((Collection)userProductsQueryResult.getGroups());
                if (CollectionHelper.isEmpty((Iterable)set2)) {
                    boolQueryBuilder.filter((QueryBuilder)termsQueryBuilder);
                } else {
                    TermsQueryBuilder termsQueryBuilder2 = QueryBuilders.termsQuery((String)UserWithFieldsVO.GROUP.getName(), (Collection)set2);
                    boolQueryBuilder.filter((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)termsQueryBuilder).should((QueryBuilder)termsQueryBuilder2));
                }
            }
        }
    }

    private List<ProfileField> getProfileFieldsInList(AbstractUserQuery abstractUserQuery) {
        return abstractUserQuery.isIgnoreProfileFieldsInList() ? Collections.emptyList() : this.resolveProfileFieldsInList(abstractUserQuery);
    }

    private ResultsCollector<UserWithBalanceQuery, UserWithBalanceVO> getWithBalancesCollector(UserWithBalanceQuery userWithBalanceQuery, UserAccountType userAccountType, SessionData sessionData) {
        List<ProfileField> list = this.getProfileFieldsInList((AbstractUserQuery)userWithBalanceQuery);
        ResultsCollector<UserWithBalanceQuery, UserWithBalanceVO> resultsCollector = (userWithBalanceQuery2, list2, searchHit) -> {
            UserWithBalanceVO userWithBalanceVO = this.toUserWithBalanceVO(sessionData, userAccountType, list, userWithBalanceQuery, searchHit);
            list2.add(userWithBalanceVO);
        };
        return resultsCollector;
    }

    private List<SortBuilder<?>> getWithBalancesSort(UserWithBalanceQuery userWithBalanceQuery, UserAccountType userAccountType) {
        UserWithBalanceOrderBy userWithBalanceOrderBy = (UserWithBalanceOrderBy)ObjectHelper.defaultValue((Object)userWithBalanceQuery.getOrderBy(), (Object)UserWithBalanceOrderBy.BALANCE_DESC);
        ArrayList arrayList = new ArrayList();
        switch (userWithBalanceOrderBy) {
            case ALPHABETICALLY_ASC: 
            case ALPHABETICALLY_DESC: {
                boolean bl = InvocationContext.getSessionData().hasPermission(Permission.USERS_VIEW_HIDDEN_FIELDS);
                SortOrder sortOrder = userWithBalanceOrderBy == UserWithBalanceOrderBy.ALPHABETICALLY_ASC ? SortOrder.ASC : SortOrder.DESC;
                arrayList.add(SortBuilders.fieldSort((String)(bl ? "displayForManagers" : "displayForOthers")).order(sortOrder));
                break;
            }
            case BALANCE_ASC: 
            case BALANCE_DESC: {
                String string = this.balanceField(userAccountType.getId());
                SortOrder sortOrder = userWithBalanceOrderBy == UserWithBalanceOrderBy.BALANCE_ASC ? SortOrder.ASC : SortOrder.DESC;
                arrayList.add(SortBuilders.fieldSort((String)string).order(sortOrder));
            }
        }
        return arrayList;
    }

    private boolean isOverBrokeredUsers(AbstractUserQuery abstractUserQuery) {
        SessionData sessionData = InvocationContext.getSessionData();
        Set set = this.conversionHandler.convertSet(User.class, (Iterable)abstractUserQuery.getBrokers());
        return set.size() == 1 && set.contains(sessionData.getLoggedUser());
    }

    private String negativeSinceField(Long l) {
        return OpenSearchAccessor.dateSuffix("negativeSince_" + l);
    }

    private List<ProfileField> resolveProfileFieldsInList(AbstractUserQuery abstractUserQuery) {
        if (Boolean.TRUE.equals(abstractUserQuery.getAttribute("export"))) {
            return this.profileFieldHandler.getProfileFieldsForExport();
        }
        return this.profileFieldHandler.getFieldsInUserList(this.isOverBrokeredUsers(abstractUserQuery));
    }

    private AmountSummaryVO toAmountSummaryVO(Aggregations aggregations, String string, CurrencyVO currencyVO) {
        Stats stats = (Stats)aggregations.get(string);
        if (stats == null) {
            return ModelHelper.amountSummary((BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ZERO, (int)0, (CurrencyVO)currencyVO);
        }
        int n = currencyVO.getPrecision();
        return ModelHelper.amountSummary((BigDecimal)BigDecimalHelper.round((BigDecimal)new BigDecimal(stats.getSum()), (int)n), (BigDecimal)BigDecimalHelper.round((BigDecimal)new BigDecimal(stats.getAvg()), (int)n), (int)((int)stats.getCount()), (CurrencyVO)currencyVO);
    }

    private UserWithBalanceVO toUserWithBalanceVO(SessionData sessionData, UserAccountType userAccountType, List<ProfileField> list, UserWithBalanceQuery userWithBalanceQuery, SearchHit searchHit) {
        SourceAccessor sourceAccessor = new SourceAccessor(searchHit);
        Long l = userAccountType.getId();
        UserWithBalanceVO userWithBalanceVO = this.toUserWithFieldsVO(sessionData, UserWithBalanceVO.class, list, (AbstractUserQuery)userWithBalanceQuery, searchHit);
        userWithBalanceVO.setBalance(sourceAccessor.getAsBigDecimal(this.balanceField(l), userAccountType.getCurrency().getPrecision()));
        userWithBalanceVO.setBalanceLevel(BalanceLevel.getFromYellowRange((BigDecimal)userWithBalanceVO.getBalance(), (IIntegerRange)userWithBalanceQuery.getYellowBalanceRange()));
        userWithBalanceVO.setNegativeSince(sourceAccessor.getAsDateTime(this.negativeSinceField(l)));
        ConfigurationAccessor configurationAccessor = InvocationContext.getSessionData().getConfiguration();
        String string = configurationAccessor.getAccountNumberConfiguration() == null ? null : configurationAccessor.getAccountNumberConfiguration().getMask();
        String string2 = sourceAccessor.getAsString(this.accountNumberField(l));
        userWithBalanceVO.setAccountNumber(MaskHelper.applyMask((String)string, (String)string2));
        return userWithBalanceVO;
    }

    private <VO extends UserWithFieldsVO> VO toUserWithFieldsVO(SessionData sessionData, Class<VO> clazz, List<ProfileField> list, AbstractUserQuery abstractUserQuery, SearchHit searchHit) {
        Object object;
        ConfigurationAccessor configurationAccessor;
        UserWithFieldsVO userWithFieldsVO;
        SourceAccessor sourceAccessor = new SourceAccessor(searchHit);
        if (list.isEmpty()) {
            userWithFieldsVO = (UserWithFieldsVO)sourceAccessor.getAsUserVO(clazz, sessionData, this.userService, null);
        } else {
            boolean bl;
            userWithFieldsVO = (UserWithFieldsVO)this.userService.toUserVO(clazz, sessionData, sourceAccessor.getAsLong((Property<?, ?>)UserVO.ID), null, null, sourceAccessor.getUserBrokerIds(), sourceAccessor.getAsImageVO((Property<?, ?>)UserVO.IMAGE));
            configurationAccessor = sessionData.getConfiguration();
            if (list.contains(BasicProfileField.FULL_NAME)) {
                userWithFieldsVO.setName(sourceAccessor.getAsString(OpenSearchAccessor.storedFieldName(BasicProfileField.FULL_NAME)));
            }
            if (list.contains(BasicProfileField.LOGIN_NAME)) {
                userWithFieldsVO.setUsername(sourceAccessor.getAsString(RAW_USERNAME));
            }
            if (list.contains(BasicProfileField.EMAIL) && (!(bl = sourceAccessor.getAsBoolean("hideEmail")) || sessionData.hasPermission(Permission.USERS_VIEW_HIDDEN_FIELDS))) {
                userWithFieldsVO.setEmail(sourceAccessor.getAsString(RAW_EMAIL));
            }
            if (list.contains(BasicProfileField.PHONE) && (!(bl = sourceAccessor.getAsBoolean("hidePreferredPhone")) || sessionData.hasPermission(Permission.USERS_VIEW_HIDDEN_FIELDS))) {
                userWithFieldsVO.setPhone(this.phoneNumberHandler.tryNormalize(sourceAccessor.getAsString(PREFERRED_PHONE), configurationAccessor));
            }
            if (list.contains(BasicProfileField.ACCOUNT_NUMBER)) {
                String string = configurationAccessor.getAccountNumberConfiguration() == null ? null : configurationAccessor.getAccountNumberConfiguration().getMask();
                object = sourceAccessor.getAsString(OpenSearchAccessor.storedFieldName(BasicProfileField.ACCOUNT_NUMBER));
                userWithFieldsVO.setAccountNumber(MaskHelper.applyMask((String)string, (String)object));
            }
            userWithFieldsVO.setCustomValues(sourceAccessor.getAsCustomValueVOs(this.profileFieldHandler.getCustomFields(list)));
        }
        if (abstractUserQuery.isIncludeMainBroker()) {
            userWithFieldsVO.setMainBroker(sourceAccessor.getAsEntityVO(User.class, UserVO.class, (Property<?, ?>)UserWithFieldsVO.MAIN_BROKER));
        }
        if (abstractUserQuery.isIncludeGroup() || abstractUserQuery.isIncludeGroupSet()) {
            configurationAccessor = sourceAccessor.getAsEntity(Group.class, (Property<?, ?>)UserWithFieldsVO.GROUP);
            if (configurationAccessor instanceof UserGroup) {
                UserGroupVO userGroupVO;
                Class clazz2 = abstractUserQuery.isIncludeGroupSet() ? UserGroupVO.class : GroupVO.class;
                object = (GroupVO)this.conversionHandler.cachedEntityFromId(Group.class, clazz2, configurationAccessor.getId(), true);
                if (abstractUserQuery.isIncludeGroup()) {
                    if (object.getClass().equals(GroupVO.class)) {
                        userWithFieldsVO.setGroup(object);
                    } else {
                        userGroupVO = new GroupVO();
                        object.copyPropertiesTo((Bean)userGroupVO);
                        userWithFieldsVO.setGroup((GroupVO)userGroupVO);
                    }
                }
                if (abstractUserQuery.isIncludeGroupSet()) {
                    userGroupVO = (UserGroupVO)object;
                    userWithFieldsVO.setGroupSet(userGroupVO.getGroupSet());
                }
            } else if (abstractUserQuery.isIncludeGroup()) {
                userWithFieldsVO.setGroup((GroupVO)this.conversionHandler.cachedEntityFromId(Group.class, GroupVO.class, configurationAccessor.getId(), true));
            }
        }
        return (VO)userWithFieldsVO;
    }

    private BoolQueryBuilder toWhere(AbstractUserQuery abstractUserQuery) {
        Boolean bl;
        BasicUser basicUser;
        Set set;
        UserAddressResult userAddressResult;
        Set set2;
        Object object;
        QueryAccessor queryAccessor = new QueryAccessor();
        boolean bl2 = false;
        if (abstractUserQuery instanceof UserQuery) {
            bl2 = ((UserQuery)abstractUserQuery).isIncludeGlobal();
        }
        boolean bl3 = this.isOverBrokeredUsers(abstractUserQuery);
        List list = this.profileFieldHandler.getSearchFilters(ProfileFieldSearchContext.USER_KEYWORDS, bl3, null);
        List list2 = this.profileFieldHandler.getSearchFilters(ProfileFieldSearchContext.USER_FILTER, bl3, null);
        GroupList groupList = GroupList.USERS;
        if (abstractUserQuery instanceof UserQuery) {
            object = (UserQuery)abstractUserQuery;
            if (object.isMapDirectory()) {
                groupList = GroupList.DIRECTORY;
            } else if (object.isFromMenu()) {
                groupList = GroupList.MENU;
            }
        }
        this.visibility(queryAccessor).others(groupList, bl2);
        if (StringHelper.isNotBlank((Object)abstractUserQuery.getKeywords())) {
            queryAccessor.keywords(abstractUserQuery.getKeywords(), this.fieldWeights(list), this.exactMatchNames(list), list.contains(BasicProfileField.PHONE));
        }
        queryAccessor.user(list2, abstractUserQuery.getProfileFields(), abstractUserQuery.getGroups(), abstractUserQuery.getBrokers(), abstractUserQuery.getOnlyBrokerIsMain(), abstractUserQuery.getHasBroker());
        queryAccessor.enums("userStatus", abstractUserQuery.getUserStatus());
        queryAccessor.enums(ROLE, abstractUserQuery.getRoles());
        object = this.conversionHandler.convertSet(Product.class, (Iterable)abstractUserQuery.getProducts());
        this.filterByProducts(queryAccessor.queryBuilder(), (Collection<? extends Product>)object, abstractUserQuery.isProductsIndividuallyAssigned());
        Set set3 = this.conversionHandler.convertSet(Agreement.class, (Iterable)abstractUserQuery.getAcceptedAgreements());
        if (!set3.isEmpty()) {
            queryAccessor.filter((QueryBuilder)QueryBuilders.termsQuery((String)ACCEPTED_AGREEMENTS, (Collection)SimpleEntity.uniqueIds((Collection)set3)));
        }
        if (!(set2 = this.conversionHandler.convertSet(Agreement.class, (Iterable)abstractUserQuery.getNotAcceptedAgreements())).isEmpty()) {
            queryAccessor.filter((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termsQuery((String)ACCEPTED_AGREEMENTS, (Collection)SimpleEntity.uniqueIds((Collection)set2))));
        }
        boolean bl4 = (userAddressResult = abstractUserQuery.getAddressResult()) == UserAddressResult.ALL_LOCATED_ADDRESSES || userAddressResult == UserAddressResult.NEAREST_ADDRESS;
        QueryBuilder queryBuilder = QueryAccessor.toAddressesQueryBuilder(abstractUserQuery.getDistance(), bl4, bl4, "addresses");
        if (queryBuilder != null) {
            queryAccessor.filter(queryBuilder);
        }
        queryAccessor.period(ACTIVATION_DATE, (IDatePeriod)abstractUserQuery.getActivated());
        queryAccessor.period(CREATION_DATE, (IDatePeriod)abstractUserQuery.getCreated());
        queryAccessor.period(LAST_LOGIN, (IDatePeriod)abstractUserQuery.getLastLogin());
        Set set4 = SimpleEntity.uniqueIds((Collection)this.conversionHandler.convertSet(User.class, (Iterable)abstractUserQuery.getUsersToInclude()));
        if (!set4.isEmpty()) {
            queryAccessor.filter((QueryBuilder)QueryBuilders.termsQuery((String)EntityVO.ID.getName(), (Collection)set4));
        }
        if (!(set = SimpleEntity.uniqueIds((Collection)this.conversionHandler.convertSet(User.class, (Iterable)abstractUserQuery.getUsersToExclude()))).isEmpty()) {
            queryAccessor.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)EntityVO.ID.getName(), (Collection)set));
        }
        if ((basicUser = (BasicUser)this.conversionHandler.convert(BasicUser.class, (Object)abstractUserQuery.getInvitedBy())) != null) {
            queryAccessor.filter((QueryBuilder)QueryBuilders.termQuery((String)ViewProfileData.INVITED_BY.getName(), (Object)basicUser.getId()));
        }
        if ((bl = BulkActionServiceLocal.getEmailRequired((AbstractUserQuery)abstractUserQuery)) != null) {
            ExistsQueryBuilder existsQueryBuilder = QueryBuilders.existsQuery((String)SourceAccessor.storedFieldName(BasicProfileField.EMAIL));
            if (bl.booleanValue()) {
                queryAccessor.must((QueryBuilder)existsQueryBuilder);
            } else {
                queryAccessor.mustNot((QueryBuilder)existsQueryBuilder);
            }
        }
        return queryAccessor.queryBuilder();
    }

    @Override
    private QueryBuilder toWhere(UserWithBalanceQuery userWithBalanceQuery) {
        DatePeriod datePeriod;
        UserAccountType userAccountType = this.accountType(userWithBalanceQuery);
        BoolQueryBuilder boolQueryBuilder = this.toWhere((AbstractUserQuery)userWithBalanceQuery);
        this.filterByProducts(boolQueryBuilder, this.productService.listByAccount(userAccountType), false);
        DecimalRangeDTO decimalRangeDTO = userWithBalanceQuery.getBalanceRange();
        if (decimalRangeDTO != null && (decimalRangeDTO.getMin() != null || decimalRangeDTO.getMax() != null)) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.rangeQuery((String)this.balanceField(userAccountType.getId())).from((Object)decimalRangeDTO.getMin()).to((Object)decimalRangeDTO.getMax()));
        }
        if ((datePeriod = (DatePeriod)this.conversionHandler.convert(DatePeriod.class, (Object)userWithBalanceQuery.getNegativeSince())) != null && !datePeriod.isEmpty()) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.rangeQuery((String)this.negativeSinceField(userAccountType.getId())).from((Object)datePeriod.getBegin()).to((Object)datePeriod.getEnd()));
        }
        return boolQueryBuilder;
    }

    private UpdateRequest updateAccount(UserAccount userAccount) {
        BigDecimal bigDecimal = this.accountService.getBalance((Account)userAccount, null);
        Long l = userAccount.getType().getId();
        User user = userAccount.getUser();
        UpdateRequest updateRequest = new UpdateRequest(this.indexName(), user.getId().toString());
        SourceAccessor sourceAccessor = new SourceAccessor();
        sourceAccessor.set(this.balanceField(l), (Object)bigDecimal, true);
        sourceAccessor.set(this.negativeSinceField(l), (Object)userAccount.getNegativeSince(), true);
        updateRequest.doc(sourceAccessor.map());
        return updateRequest;
    }

    private void updateTrans(Long l) {
        Function<Exception, UpdateByQueryRequest> function = exception -> {
            User user = (User)this.find(l);
            UpdateByQueryRequest updateByQueryRequest = new UpdateByQueryRequest(new String[]{this.searchHandler.transfer().indexName(), this.searchHandler.transaction().indexName(), this.searchHandler.installment().indexName()});
            updateByQueryRequest.setAbortOnVersionConflict(false);
            updateByQueryRequest.setQuery(this.updateTransQuery(user));
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("id", user.getId());
            hashMap.put("group", user.getGroup().getId());
            hashMap.put("broker", user.getBrokerIds());
            updateByQueryRequest.setScript(this.loadScript("update-trans-user", hashMap));
            return updateByQueryRequest;
        };
        this.searchHandler.scheduleUpdateByQuery(function, null, null);
    }

    private QueryBuilder updateTransQuery(User user) {
        return QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.termQuery((String)"from.user", (Object)user.getId())).should((QueryBuilder)QueryBuilders.termQuery((String)"to.user", (Object)user.getId()));
    }
}

