/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.search.opensearch;

import com.querydsl.core.types.Path;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.banking.HasExpirationDate;
import org.cyclos.entities.banking.QTransaction;
import org.cyclos.entities.banking.Transaction;
import org.cyclos.entities.banking.TransactionCustomField;
import org.cyclos.entities.banking.TransactionWithInstallments;
import org.cyclos.entities.users.Operator;
import org.cyclos.entities.users.OperatorGroup;
import org.cyclos.entities.users.QAdminProductAuthorizationRole;
import org.cyclos.entities.users.User;
import org.cyclos.entities.utils.DatePeriod;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.banking.AuthorizationLevelServiceLocal;
import org.cyclos.impl.search.TransactionSearchHandler;
import org.cyclos.impl.search.opensearch.OpenSearchBaseTransactionSearchHandlerImpl;
import org.cyclos.impl.search.opensearch.OpenSearchHandlerImpl;
import org.cyclos.impl.search.opensearch.QueryAccessor;
import org.cyclos.impl.search.opensearch.ResultsCollector;
import org.cyclos.impl.search.opensearch.SourceAccessor;
import org.cyclos.impl.users.ProductAccessor;
import org.cyclos.impl.utils.conversion.VOFiller;
import org.cyclos.model.access.Permission;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.transactions.AbstractTransQuery;
import org.cyclos.model.banking.transactions.BaseTransactionQuery;
import org.cyclos.model.banking.transactions.TransactionAuthorizationStatus;
import org.cyclos.model.banking.transactions.TransactionAuthorizationType;
import org.cyclos.model.banking.transactions.TransactionNature;
import org.cyclos.model.banking.transactions.TransactionOverviewQuery;
import org.cyclos.model.banking.transactions.TransactionQuery;
import org.cyclos.model.banking.transactions.TransactionResultVO;
import org.cyclos.model.banking.transactions.TransactionVO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.utils.DatePeriodDTO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.server.utils.DataIterator;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.Page;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.SearchHit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

public class OpenSearchTransactionSearchHandlerImpl
extends OpenSearchBaseTransactionSearchHandlerImpl<Transaction, TransactionOverviewQuery, TransactionResultVO>
implements TransactionSearchHandler {
    private static final String INDEX = "transactions";
    public static final String VERSION = "5";
    private static final String EXPIRATION_DATE = "expirationDate";
    @Autowired
    @Lazy
    private AuthorizationLevelServiceLocal authorizationLevelService;

    public OpenSearchTransactionSearchHandlerImpl(OpenSearchHandlerImpl openSearchHandlerImpl) {
        super(openSearchHandlerImpl, Transaction.class, QTransaction.transaction1);
    }

    public DataIterator<Transaction> export(TransactionQuery transactionQuery) {
        SessionData sessionData = InvocationContext.getSessionData();
        QueryAccessor queryAccessor = new QueryAccessor();
        this.appendWhere(sessionData, queryAccessor, (AbstractTransQuery)transactionQuery);
        return this.doExportEntities(transactionQuery, (QueryBuilder)queryAccessor.queryBuilder(), this.toSort((AbstractTransQuery)transactionQuery));
    }

    @Override
    public void index(Transaction transaction) {
        super.index(transaction);
        if (transaction instanceof TransactionWithInstallments) {
            CollectionHelper.orEmpty((List)((TransactionWithInstallments)transaction).getInstallments()).forEach(this.searchHandler.installment()::index);
        }
    }

    public String indexName() {
        return INDEX;
    }

    @Override
    public String indexVersion() {
        return VERSION;
    }

    public Page<TransactionResultVO> searchTransactions(TransactionQuery transactionQuery) {
        SessionData sessionData = InvocationContext.getSessionData();
        QueryAccessor queryAccessor = new QueryAccessor();
        this.appendWhere(sessionData, queryAccessor, (AbstractTransQuery)transactionQuery);
        TransactionResultVOCollector transactionResultVOCollector = new TransactionResultVOCollector(transactionQuery.getOwner(), this.transactionCustomFieldService.listVisibleForList((AbstractTransQuery)transactionQuery));
        return this.search(transactionQuery, (QueryBuilder)queryAccessor.queryBuilder(), this.toSort((AbstractTransQuery)transactionQuery), transactionResultVOCollector);
    }

    @Override
    protected void appendWhere(SessionData sessionData, QueryAccessor queryAccessor, AbstractTransQuery abstractTransQuery) {
        super.appendWhere(sessionData, queryAccessor, abstractTransQuery);
        if (abstractTransQuery instanceof BaseTransactionQuery) {
            DatePeriod datePeriod;
            BaseTransactionQuery baseTransactionQuery = (BaseTransactionQuery)abstractTransQuery;
            this.applyStatusesFilter(queryAccessor, TransactionNature.EXTERNAL_PAYMENT, baseTransactionQuery.getExternalPaymentStatuses());
            this.applyStatusesFilter(queryAccessor, TransactionNature.PAYMENT_REQUEST, baseTransactionQuery.getPaymentRequestStatuses());
            this.applyStatusesFilter(queryAccessor, TransactionNature.RECURRING_PAYMENT, baseTransactionQuery.getRecurringPaymentStatuses());
            this.applyStatusesFilter(queryAccessor, TransactionNature.SCHEDULED_PAYMENT, baseTransactionQuery.getScheduledPaymentStatuses());
            this.applyStatusesFilter(queryAccessor, TransactionNature.TICKET, baseTransactionQuery.getTicketStatuses());
            if (!ModelHelper.isEmpty((DatePeriodDTO)baseTransactionQuery.getPaymentRequestExpiration())) {
                datePeriod = (DatePeriod)this.conversionHandler.convert(DatePeriod.class, (Object)baseTransactionQuery.getPaymentRequestExpiration());
                queryAccessor.filter(this.notNatureOr(TransactionNature.PAYMENT_REQUEST, (QueryBuilder)QueryBuilders.rangeQuery((String)EXPIRATION_DATE).from((Object)datePeriod.getBegin()).to((Object)datePeriod.getEnd())));
            }
            if (!ModelHelper.isEmpty((DatePeriodDTO)baseTransactionQuery.getExternalPaymentExpiration())) {
                datePeriod = (DatePeriod)this.conversionHandler.convert(DatePeriod.class, (Object)baseTransactionQuery.getExternalPaymentExpiration());
                queryAccessor.filter(this.notNatureOr(TransactionNature.EXTERNAL_PAYMENT, (QueryBuilder)QueryBuilders.rangeQuery((String)EXPIRATION_DATE).from((Object)datePeriod.getBegin()).to((Object)datePeriod.getEnd())));
            }
            if (!ModelHelper.isEmpty((DatePeriodDTO)baseTransactionQuery.getTicketExpiration())) {
                datePeriod = (DatePeriod)this.conversionHandler.convert(DatePeriod.class, (Object)baseTransactionQuery.getTicketExpiration());
                queryAccessor.filter(this.notNatureOr(TransactionNature.TICKET, (QueryBuilder)QueryBuilders.rangeQuery((String)EXPIRATION_DATE).from((Object)datePeriod.getBegin()).to((Object)datePeriod.getEnd())));
            }
        }
    }

    @Override
    protected void applyOverview(SessionData sessionData, QueryAccessor queryAccessor, AbstractTransQuery abstractTransQuery) {
        TransactionOverviewQuery transactionOverviewQuery;
        super.applyOverview(sessionData, queryAccessor, abstractTransQuery);
        if (abstractTransQuery instanceof TransactionOverviewQuery && (transactionOverviewQuery = (TransactionOverviewQuery)abstractTransQuery).isPendingMyAuthorization()) {
            this.applyPendingMyAuthorization(queryAccessor);
        }
    }

    @Override
    protected void doApplyVisibility(SessionData sessionData, QueryAccessor queryAccessor, AbstractTransQuery abstractTransQuery) {
        super.doApplyVisibility(sessionData, queryAccessor, abstractTransQuery);
        if (sessionData.isMember()) {
            User user = sessionData.getLoggedUser();
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.existsQuery((String)this.fromName("user")))).should((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termQuery((String)this.fromName("user"), (Object)user.getId())));
            if (!(abstractTransQuery instanceof TransactionQuery) || !user.equals((Object)((TransactionQuery)abstractTransQuery).getOwner())) {
                boolQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)this.toName("broker"), (Object)user.getId()));
            }
            queryAccessor.filter(this.notNatureOr(TransactionNature.TICKET, (QueryBuilder)boolQueryBuilder));
        }
    }

    @Override
    protected void fillSource(Transaction transaction, SourceAccessor sourceAccessor) {
        super.fillSource(transaction, sourceAccessor);
        if (transaction instanceof HasExpirationDate) {
            sourceAccessor.set(EXPIRATION_DATE, (Object)((HasExpirationDate)transaction).getExpirationDate());
        }
    }

    @Override
    protected ResultsCollector<TransactionOverviewQuery, TransactionResultVO> resultsCollector(TransactionOverviewQuery transactionOverviewQuery) {
        return new TransactionResultVOCollector<TransactionOverviewQuery>(null, this.transactionCustomFieldService.listVisibleForList((AbstractTransQuery)transactionOverviewQuery));
    }

    private void applyPendingMyAuthorization(QueryAccessor queryAccessor) {
        queryAccessor.filter((QueryBuilder)QueryBuilders.termQuery((String)TransactionVO.AUTHORIZATION_STATUS.getName(), (Object)TransactionAuthorizationStatus.PENDING_AUTHORIZATION));
        SessionData sessionData = InvocationContext.getSessionData();
        if (sessionData.isSystem()) {
            return;
        }
        if (sessionData.isAdmin()) {
            Set set = sessionData.getProducts().admin().getAuthorizationRoles().keysSet((Path)QAdminProductAuthorizationRole.adminProductAuthorizationRole.manage);
            List list = this.authorizationLevelService.listByRoles(set);
            if (list.isEmpty()) {
                queryAccessor.invalid();
            } else {
                queryAccessor.filter((QueryBuilder)QueryBuilders.termsQuery((String)"authorizationLevel", (Collection)SimpleEntity.uniqueIds((Collection)list)));
            }
        } else if (sessionData.isRestrictedOperator()) {
            Operator operator = sessionData.getLoggedOperator();
            OperatorGroup operatorGroup = operator.getGroup();
            List list = this.operatorGroupService.listPaymentTypesWithAuthorize(operatorGroup);
            if (CollectionHelper.isNotEmpty((Iterable)list)) {
                queryAccessor.filter((QueryBuilder)QueryBuilders.termQuery((String)"authorizationType", (Object)TransactionAuthorizationType.OPERATOR));
                queryAccessor.filter((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termQuery((String)"by", (Object)operator.getId())));
                queryAccessor.filter((QueryBuilder)QueryBuilders.termQuery((String)this.fromName("user"), (Object)operatorGroup.getUser().getId()));
                queryAccessor.filter((QueryBuilder)QueryBuilders.termsQuery((String)TransactionVO.TYPE.getName(), (Collection)SimpleEntity.uniqueIds((Collection)list)));
            } else {
                queryAccessor.invalid();
            }
        } else {
            List list;
            User user = sessionData.getLoggedUser();
            ProductAccessor productAccessor = sessionData.getProducts().product();
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            if (productAccessor.hasPermission(Permission.MY_AUTHORIZED_PAYMENTS_AUTHORIZE)) {
                List list2;
                list = this.authorizationLevelService.listByPayer();
                if (!list.isEmpty()) {
                    boolQueryBuilder.should((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termsQuery((String)"authorizationLevel", (Collection)SimpleEntity.uniqueIds((Collection)list))).must((QueryBuilder)QueryBuilders.termQuery((String)this.fromName("user"), (Object)user.getId())));
                }
                if (!(list2 = this.authorizationLevelService.listByReceiver()).isEmpty()) {
                    boolQueryBuilder.should((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termsQuery((String)"authorizationLevel", (Collection)SimpleEntity.uniqueIds((Collection)list2))).must((QueryBuilder)QueryBuilders.termQuery((String)this.toName("user"), (Object)user.getId())));
                }
            }
            if (productAccessor.hasPermission(Permission.MY_OPERATORS_ENABLE) && this.operatorGroupService.anyRequiresAuthorization(user)) {
                boolQueryBuilder.should((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termsQuery((String)"authorizationType", (Object[])new Object[]{TransactionAuthorizationType.OPERATOR})).must((QueryBuilder)QueryBuilders.termQuery((String)this.fromName("user"), (Object)user.getId())));
            }
            if (user.isBroker() && productAccessor.hasPermission(Permission.BROKER_AUTHORIZED_PAYMENTS_AUTHORIZE) && !(list = this.authorizationLevelService.listByBroker()).isEmpty()) {
                boolQueryBuilder.should((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termsQuery((String)"authorizationLevel", (Collection)SimpleEntity.uniqueIds((Collection)list))).must((QueryBuilder)QueryBuilders.termQuery((String)this.fromName("broker"), (Object)user.getId())));
            }
            if (CollectionHelper.isEmpty((Iterable)boolQueryBuilder.should())) {
                queryAccessor.invalid();
            } else {
                queryAccessor.filter((QueryBuilder)boolQueryBuilder);
            }
        }
    }

    private void applyStatusesFilter(QueryAccessor queryAccessor, TransactionNature transactionNature, Set<? extends Enum<?>> set) {
        if (CollectionHelper.isNotEmpty(set)) {
            queryAccessor.filter(this.notNatureOr(transactionNature, (QueryBuilder)QueryBuilders.termsQuery((String)"status", set)));
        }
    }

    private QueryBuilder notNatureOr(TransactionNature transactionNature, QueryBuilder queryBuilder) {
        return QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termQuery((String)"nature", (Object)transactionNature))).should(queryBuilder);
    }

    private class TransactionResultVOCollector<Q extends BaseTransactionQuery>
    implements ResultsCollector<Q, TransactionResultVO> {
        private InternalAccountOwner owner;
        private SessionData sessionData = InvocationContext.getSessionData();
        private VOFiller<BasicUserVO> voFiller;
        private List<TransactionCustomField> customFields;

        public TransactionResultVOCollector(InternalAccountOwner internalAccountOwner, List<TransactionCustomField> list) {
            this.voFiller = OpenSearchTransactionSearchHandlerImpl.this.userLocatorHandler.newVOFiller();
            this.owner = internalAccountOwner;
            this.customFields = list;
        }

        @Override
        public void collect(Q q, List<TransactionResultVO> list, SearchHit searchHit) {
            list.add(OpenSearchTransactionSearchHandlerImpl.this.toTransactionResultVO(this.owner, this.voFiller, this.customFields, this.sessionData, searchHit));
        }

        @Override
        public void postProcess(Q q, List<TransactionResultVO> list) {
            this.voFiller.fill();
        }
    }
}

