/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.search.opensearch;

import com.querydsl.core.types.EntityPath;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclos.entities.NetworkedEntity;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.access.AccessClient;
import org.cyclos.entities.access.Channel;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.banking.AccountType;
import org.cyclos.entities.banking.BasePayment;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.Installment;
import org.cyclos.entities.banking.Trans;
import org.cyclos.entities.banking.Transaction;
import org.cyclos.entities.banking.TransactionCustomField;
import org.cyclos.entities.banking.Transfer;
import org.cyclos.entities.banking.TransferFilter;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.banking.UserAccount;
import org.cyclos.entities.system.AccountNumberConfiguration;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Operator;
import org.cyclos.entities.users.User;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.banking.AccountHandler;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.banking.RestrictedOperatorAccessibleAccounts;
import org.cyclos.impl.banking.TransactionCustomFieldServiceLocal;
import org.cyclos.impl.banking.TransactionServiceLocal;
import org.cyclos.impl.search.opensearch.OpenSearchEntitySearchHandlerImpl;
import org.cyclos.impl.search.opensearch.OpenSearchHandlerImpl;
import org.cyclos.impl.search.opensearch.QueryAccessor;
import org.cyclos.impl.search.opensearch.SourceAccessor;
import org.cyclos.impl.utils.conversion.VOFiller;
import org.cyclos.model.EntityVO;
import org.cyclos.model.Property;
import org.cyclos.model.access.clients.AccessClientVO;
import org.cyclos.model.banking.accounts.AccountVO;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.accounts.SystemAccountOwner;
import org.cyclos.model.banking.accounttypes.AccountTypeVO;
import org.cyclos.model.banking.transactions.AbstractTransQuery;
import org.cyclos.model.banking.transactions.TransOverviewQuery;
import org.cyclos.model.banking.transactions.TransVO;
import org.cyclos.model.banking.transactions.TransactionOrderBy;
import org.cyclos.model.banking.transactions.TransactionOverviewQuery;
import org.cyclos.model.banking.transactions.TransactionResultVO;
import org.cyclos.model.users.operators.OperatorVO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.CurrencyAmountDTO;
import org.cyclos.model.utils.IDatePeriod;
import org.cyclos.model.utils.Range;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.MaskHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.TermQueryBuilder;
import org.opensearch.search.sort.SortBuilder;
import org.opensearch.search.sort.SortBuilders;
import org.opensearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

public abstract class OpenSearchTransSearchHandlerImpl<E extends NetworkedEntity, Q extends AbstractTransQuery, T>
extends OpenSearchEntitySearchHandlerImpl<E, Q, T> {
    protected static final String BY = "by";
    protected static final String RECEIVED_BY = "receivedBy";
    protected static final String ACCESS_CLIENT = "accessClient";
    protected static final String GENERATED_BY_ACCESS_CLIENT = "generatedByAccessClient";
    @Autowired
    @Lazy
    protected AccountServiceLocal accountService;
    @Autowired
    @Lazy
    protected AccountHandler accountHandler;
    @Autowired
    @Lazy
    protected TransactionServiceLocal transactionService;
    @Autowired
    @Lazy
    protected TransactionCustomFieldServiceLocal transactionCustomFieldService;
    @Autowired
    protected InvokerHandler invokerHandler;

    public OpenSearchTransSearchHandlerImpl(OpenSearchHandlerImpl openSearchHandlerImpl, Class<E> clazz, EntityPath<E> entityPath) {
        super(openSearchHandlerImpl, clazz, entityPath);
    }

    protected QueryBuilder additionalAdminFilter(SessionData sessionData) {
        return null;
    }

    protected QueryBuilder additionalBrokerFilter(SessionData sessionData) {
        return null;
    }

    protected QueryBuilder additionalRestrictedOperatorFilter(SessionData sessionData) {
        return null;
    }

    protected void appendWhere(SessionData sessionData, QueryAccessor queryAccessor, AbstractTransQuery abstractTransQuery) {
        Set set;
        Object object;
        Set set2;
        Set set3;
        Set set4;
        TermQueryBuilder termQueryBuilder;
        BasicUser basicUser;
        if (StringHelper.isNotBlank((Object)abstractTransQuery.getTransactionNumber())) {
            queryAccessor.filter((QueryBuilder)QueryBuilders.termQuery((String)TransVO.TRANSACTION_NUMBER.getName(), (String)abstractTransQuery.getTransactionNumber()));
        }
        queryAccessor.period(this.dateField(), (IDatePeriod)abstractTransQuery.getPeriod());
        queryAccessor.range((Property<?, ?>)CurrencyAmountDTO.AMOUNT, (Range<?>)abstractTransQuery.getAmount());
        queryAccessor.keywords(abstractTransQuery.getDescription(), Collections.singletonMap(TransactionResultVO.DESCRIPTION.getName(), Float.valueOf(1.0f)), Collections.emptySet(), false);
        if (CollectionHelper.isNotEmpty((Iterable)abstractTransQuery.getExcludedIds())) {
            queryAccessor.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)EntityVO.ID.getName(), (Collection)abstractTransQuery.getExcludedIds()));
        }
        if ((basicUser = (BasicUser)this.conversionHandler.convert(BasicUser.class, (Object)abstractTransQuery.getBy())) != null) {
            termQueryBuilder = QueryBuilders.termQuery((String)BY, (Object)basicUser.getId());
            if (basicUser.isOperator()) {
                termQueryBuilder = QueryBuilders.boolQuery().should((QueryBuilder)termQueryBuilder).should((QueryBuilder)QueryBuilders.termQuery((String)RECEIVED_BY, (Object)basicUser.getId()));
            }
            queryAccessor.filter((QueryBuilder)termQueryBuilder);
        }
        if ((termQueryBuilder = (User)this.conversionHandler.convert(User.class, (Object)abstractTransQuery.getUser())) != null) {
            queryAccessor.filter((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.termQuery((String)this.fromName("user"), (Object)termQueryBuilder.getId())).should((QueryBuilder)QueryBuilders.termQuery((String)this.toName("user"), (Object)termQueryBuilder.getId())));
        }
        if (!(set4 = this.groupsHandler.flattenVOs((Collection)abstractTransQuery.getGroups())).isEmpty()) {
            set3 = SimpleEntity.uniqueIds((Collection)set4);
            queryAccessor.filter((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.termsQuery((String)this.fromName("group"), (Collection)set3)).should((QueryBuilder)QueryBuilders.termsQuery((String)this.toName("group"), (Collection)set3)));
        }
        if (!(set3 = this.conversionHandler.convertSet(User.class, (Iterable)abstractTransQuery.getBrokers())).isEmpty()) {
            set2 = SimpleEntity.uniqueIds((Collection)set3);
            queryAccessor.filter((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.termsQuery((String)this.fromName("broker"), (Collection)set2)).should((QueryBuilder)QueryBuilders.termsQuery((String)this.toName("broker"), (Collection)set2)));
        }
        if (!(set2 = this.conversionHandler.convertSet(Channel.class, (Iterable)abstractTransQuery.getChannels())).isEmpty()) {
            if (set2.stream().anyMatch(Channel::isMain)) {
                object = SimpleEntity.uniqueIds((Collection)set2);
                queryAccessor.filter((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.termsQuery((String)"channel", (Collection)object)).should((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"channel"))));
            } else {
                queryAccessor.entities("channel", (Collection<? extends SimpleEntity>)set2);
            }
        }
        if (abstractTransQuery.isFromCurrentAccessClient()) {
            object = sessionData.getAccessClient();
            if (object == null) {
                queryAccessor.invalid();
            } else {
                abstractTransQuery.setAccessClients(Collections.singleton(new AccessClientVO(object.getId())));
            }
        }
        if (!(object = this.conversionHandler.convertSet(AccessClient.class, (Iterable)abstractTransQuery.getAccessClients())).isEmpty()) {
            if (abstractTransQuery.isIncludeGeneratedByAccessClient()) {
                set = SimpleEntity.uniqueIds((Collection)object);
                queryAccessor.filter((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.termsQuery((String)ACCESS_CLIENT, (Collection)set)).should((QueryBuilder)QueryBuilders.termsQuery((String)GENERATED_BY_ACCESS_CLIENT, (Collection)set)));
            } else {
                queryAccessor.entities(ACCESS_CLIENT, (Collection<? extends SimpleEntity>)object);
            }
        }
        if (!(set = this.conversionHandler.convertSet(TransferType.class, (Iterable)abstractTransQuery.getTransferTypes())).isEmpty()) {
            queryAccessor.entities((Property<?, ?>)TransVO.TYPE, (Collection<? extends SimpleEntity>)set);
        }
        if (!(set = CollectionHelper.orEmpty((Set)abstractTransQuery.getTransferFilters()).stream().map(this.conversionHandler.convertingFunction(TransferFilter.class, new Object[0])).flatMap(transferFilter -> transferFilter.getTransferTypes().stream()).collect(Collectors.toSet())).isEmpty()) {
            queryAccessor.entities((Property<?, ?>)TransVO.TYPE, (Collection<? extends SimpleEntity>)set);
        }
        this.applyVisibility(sessionData, queryAccessor, abstractTransQuery);
        queryAccessor.customFields(TransactionCustomField.class, abstractTransQuery.getCustomValues(), this.transactionCustomFieldService.listVisibleForSearch(abstractTransQuery)::contains);
        if (abstractTransQuery instanceof TransOverviewQuery) {
            this.applyOverview(sessionData, queryAccessor, abstractTransQuery);
        } else {
            this.applyOwned(sessionData, queryAccessor, abstractTransQuery);
        }
    }

    protected void applyOverview(SessionData sessionData, QueryAccessor queryAccessor, AbstractTransQuery abstractTransQuery) {
        Set set;
        Set set2;
        TransOverviewQuery transOverviewQuery = (TransOverviewQuery)abstractTransQuery;
        Set set3 = this.conversionHandler.convertSet(Currency.class, (Iterable)transOverviewQuery.getCurrencies());
        if (!set3.isEmpty()) {
            queryAccessor.entities((Property<?, ?>)CurrencyAmountDTO.CURRENCY, (Collection<? extends SimpleEntity>)set3);
        }
        if (!(set2 = this.conversionHandler.convertSet(AccountType.class, (Iterable)transOverviewQuery.getFromAccounts())).isEmpty()) {
            queryAccessor.entities(this.fromName((Property<?, ?>)AccountVO.TYPE), (Collection<? extends SimpleEntity>)set2);
        }
        if (!(set = this.conversionHandler.convertSet(AccountType.class, (Iterable)transOverviewQuery.getToAccounts())).isEmpty()) {
            queryAccessor.entities(this.toName((Property<?, ?>)AccountVO.TYPE), (Collection<? extends SimpleEntity>)set);
        }
    }

    protected abstract void applyOwned(SessionData var1, QueryAccessor var2, AbstractTransQuery var3);

    protected void applyVisibility(SessionData sessionData, QueryAccessor queryAccessor, AbstractTransQuery abstractTransQuery) {
        if (!sessionData.isSystem()) {
            this.doApplyVisibility(sessionData, queryAccessor, abstractTransQuery);
        }
    }

    protected String dateField() {
        return TransVO.DATE.getName();
    }

    protected void doApplyVisibility(SessionData sessionData, QueryAccessor queryAccessor, AbstractTransQuery abstractTransQuery) {
        Object object = sessionData.isAdmin() ? this.getAdminFilters(sessionData, abstractTransQuery) : (sessionData.isRestrictedOperator() ? this.getRestrictedOperatorFilters(sessionData) : (sessionData.isBroker() ? this.getBrokerFilters(sessionData) : (sessionData.isMember() ? this.getMemberFilters(sessionData) : null)));
        if (object == null) {
            queryAccessor.invalid();
        } else {
            queryAccessor.filter((QueryBuilder)object);
        }
    }

    protected void doFillSource(Trans trans, SourceAccessor sourceAccessor) {
        Transaction transaction = (Transaction)ObjectHelper.ifType((Object)trans, Transaction.class);
        Set set = null;
        if (transaction == null && trans instanceof Transfer) {
            transaction = ((Transfer)trans).getTransaction();
            set = ((Transfer)trans).getCustomValuesForExport();
        }
        if (transaction == null && trans instanceof Installment) {
            transaction = ((Installment)trans).getTransaction();
        }
        if (set == null && transaction != null) {
            set = transaction.getCustomValues();
        }
        sourceAccessor.set((Property<?, ?>)TransVO.DISPLAY, (Object)this.getFormatter().format(trans));
        sourceAccessor.set((Property<?, ?>)TransVO.DATE, (Object)trans.getDate());
        sourceAccessor.set((Property<?, ?>)TransVO.TRANSACTION_NUMBER, (Object)trans.getTransactionNumber());
        sourceAccessor.set((Property<?, ?>)TransVO.TYPE, (Object)trans.getType());
        sourceAccessor.set((Property<?, ?>)CurrencyAmountDTO.CURRENCY, (Object)trans.getCurrency());
        sourceAccessor.set((Property<?, ?>)CurrencyAmountDTO.AMOUNT, (Object)trans.getAmount());
        sourceAccessor.set((Property<?, ?>)TransVO.FROM, (Object)this.toAccount(trans.getFrom()));
        sourceAccessor.set((Property<?, ?>)TransVO.TO, (Object)this.toAccount(trans.getTo()));
        if (set != null) {
            sourceAccessor.setCustomValues((BasicUser)null, set, null);
        }
        if (transaction != null) {
            sourceAccessor.set("channel", (Object)transaction.getChannel());
            sourceAccessor.set((Property<?, ?>)TransactionResultVO.DESCRIPTION, ObjectHelper.defaultValue((Object)transaction.getDescription(), (Object)transaction.getType().getValueForEmptyDescription()));
            this.setBasicUser(sourceAccessor, BY, transaction.getBy());
            if (transaction instanceof BasePayment) {
                this.setBasicUser(sourceAccessor, RECEIVED_BY, (BasicUser)((BasePayment)transaction).getReceivedBy());
            }
            Operator operator = (Operator)ObjectHelper.ifType((Object)transaction.getPerformer(), Operator.class);
            this.setBasicUser(sourceAccessor, (Property<?, ?>)TransactionResultVO.FROM_OPERATOR, (BasicUser)operator);
            sourceAccessor.set((Property<?, ?>)TransactionResultVO.FROM_NAME, (Object)transaction.getFromName());
            Operator operator2 = (Operator)ObjectHelper.ifType((Object)transaction.getReceiver(), Operator.class);
            this.setBasicUser(sourceAccessor, (Property<?, ?>)TransactionResultVO.TO_OPERATOR, (BasicUser)operator2);
            sourceAccessor.set((Property<?, ?>)TransactionResultVO.TO_NAME, (Object)transaction.getToName());
            sourceAccessor.set(ACCESS_CLIENT, (Object)transaction.getAccessClient());
            Transaction transaction2 = this.transactionService.getGeneratedBy(transaction);
            if (transaction2 != null) {
                sourceAccessor.set(GENERATED_BY_ACCESS_CLIENT, (Object)transaction2.getAccessClient());
            }
        }
    }

    @Override
    protected void fillSource(E e, SourceAccessor sourceAccessor) {
        this.doFillSource((Trans)e, sourceAccessor);
    }

    protected String fromName(Property<?, ?> property) {
        return this.fromName(property.getName());
    }

    protected String fromName(String string) {
        return "from." + string;
    }

    protected QueryBuilder getAdminFilters(SessionData sessionData, AbstractTransQuery abstractTransQuery) {
        Set set;
        boolean bl;
        Set set2 = SimpleEntity.uniqueIds((Collection)sessionData.getProducts().admin().getSystemAccounts());
        boolean bl2 = CollectionHelper.isNotEmpty((Iterable)set2);
        List list = sessionData.getProducts().admin().getUserAccountsAccess();
        Set set3 = this.groupsHandler.accessibles().users().items();
        boolean bl3 = CollectionHelper.isNotEmpty((Iterable)list) && CollectionHelper.isNotEmpty((Iterable)set3);
        boolean bl4 = bl = abstractTransQuery instanceof TransactionOverviewQuery && ((TransactionOverviewQuery)abstractTransQuery).isPendingMyAuthorization();
        if (!bl2 && !bl3) {
            return null;
        }
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (bl2) {
            boolQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)this.fromName((Property<?, ?>)AccountVO.TYPE), (Collection)set2));
            if (!bl) {
                boolQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)this.toName((Property<?, ?>)AccountVO.TYPE), (Collection)set2));
            }
        }
        if (bl3) {
            set = SimpleEntity.uniqueIds((Collection)list);
            Set set4 = SimpleEntity.uniqueIds((Collection)set3);
            boolQueryBuilder.should((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termsQuery((String)this.fromName((Property<?, ?>)AccountVO.TYPE), (Collection)set)).must((QueryBuilder)QueryBuilders.termsQuery((String)this.fromName("group"), (Collection)set4)));
            if (!bl) {
                boolQueryBuilder.should((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termsQuery((String)this.toName((Property<?, ?>)AccountVO.TYPE), (Collection)set)).must((QueryBuilder)QueryBuilders.termsQuery((String)this.toName("group"), (Collection)set4)));
            }
        }
        if ((set = this.additionalAdminFilter(sessionData)) != null) {
            boolQueryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)boolQueryBuilder).must((QueryBuilder)set);
        }
        return boolQueryBuilder;
    }

    protected BasicUserVO getBasicUser(VOFiller<BasicUserVO> vOFiller, SourceAccessor sourceAccessor, Property<?, ?> property) {
        return this.getBasicUser(vOFiller, sourceAccessor, property.getName());
    }

    protected BasicUserVO getBasicUser(VOFiller<BasicUserVO> vOFiller, SourceAccessor sourceAccessor, String string) {
        Class clazz = sourceAccessor.getAsLong(this.userName(string)) == null ? UserVO.class : OperatorVO.class;
        return (BasicUserVO)vOFiller.add(sourceAccessor.getAsLong(string), clazz);
    }

    protected QueryBuilder getBrokerFilters(SessionData sessionData) {
        QueryBuilder queryBuilder = this.getMemberFilters(sessionData);
        QueryBuilder queryBuilder2 = this.getBrokeringFilters(sessionData);
        if (queryBuilder != null && queryBuilder2 != null) {
            return QueryBuilders.boolQuery().should(queryBuilder).should(queryBuilder2);
        }
        return (QueryBuilder)ObjectHelper.defaultValue((Object)queryBuilder, (Object)queryBuilder2);
    }

    protected QueryBuilder getBrokeringFilters(SessionData sessionData) {
        User user = sessionData.getLoggedUser();
        List list = sessionData.getProducts().broker().getUserAccountsAccess();
        if (list.isEmpty()) {
            return null;
        }
        Set set = SimpleEntity.uniqueIds((Collection)list);
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)this.fromName("broker"), (Object)user.getId())).must((QueryBuilder)QueryBuilders.termsQuery((String)this.fromName((Property<?, ?>)AccountVO.TYPE), (Collection)set))).should((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)this.toName("broker"), (Object)user.getId())).must((QueryBuilder)QueryBuilders.termsQuery((String)this.toName((Property<?, ?>)AccountVO.TYPE), (Collection)set)));
        QueryBuilder queryBuilder = this.additionalBrokerFilter(sessionData);
        if (queryBuilder == null) {
            return boolQueryBuilder;
        }
        return QueryBuilders.boolQuery().must((QueryBuilder)boolQueryBuilder).must(queryBuilder);
    }

    protected TransactionOrderBy getDefaultOrder() {
        return TransactionOrderBy.DATE_DESC;
    }

    protected QueryBuilder getMemberFilters(SessionData sessionData) {
        String string = sessionData.getLoggedUser().getId().toString();
        return QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.termsQuery((String)this.fromName("user"), (String[])new String[]{string})).should((QueryBuilder)QueryBuilders.termsQuery((String)this.toName("user"), (String[])new String[]{string}));
    }

    protected OperatorVO getOperator(VOFiller<BasicUserVO> vOFiller, SourceAccessor sourceAccessor, Property<?, ?> property) {
        return this.getOperator(vOFiller, sourceAccessor, property.getName());
    }

    protected OperatorVO getOperator(VOFiller<BasicUserVO> vOFiller, SourceAccessor sourceAccessor, String string) {
        return (OperatorVO)vOFiller.add(sourceAccessor.getAsLong(string), OperatorVO.class);
    }

    protected QueryBuilder getRestrictedOperatorFilters(SessionData sessionData) {
        User user;
        Operator operator = sessionData.getLoggedOperator();
        RestrictedOperatorAccessibleAccounts restrictedOperatorAccessibleAccounts = this.accountService.getRetrictedOperatorAccessibleAccounts();
        BoolQueryBuilder boolQueryBuilder = null;
        if (restrictedOperatorAccessibleAccounts.isAnyVisible()) {
            Set set;
            Set set2;
            Set set3;
            user = operator.getUser();
            boolQueryBuilder = QueryBuilders.boolQuery();
            Set set4 = restrictedOperatorAccessibleAccounts.getOwnPayments();
            if (!set4.isEmpty()) {
                set3 = SimpleEntity.uniqueIds((Collection)set4);
                boolQueryBuilder.should((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termsQuery((String)this.fromName((Property<?, ?>)AccountVO.TYPE), (Collection)set3)).must((QueryBuilder)QueryBuilders.termQuery((String)this.fromName("user"), (Object)user.getId()))).should((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termsQuery((String)this.toName((Property<?, ?>)AccountVO.TYPE), (Collection)set3)).must((QueryBuilder)QueryBuilders.termQuery((String)this.toName("user"), (Object)user.getId())))).must((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.termQuery((String)BY, (Object)operator.getId())).should((QueryBuilder)QueryBuilders.termQuery((String)RECEIVED_BY, (Object)operator.getId()))));
            }
            if (!(set3 = restrictedOperatorAccessibleAccounts.getIncoming()).isEmpty()) {
                set2 = SimpleEntity.uniqueIds((Collection)set3);
                boolQueryBuilder.should((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termsQuery((String)this.toName((Property<?, ?>)AccountVO.TYPE), (Collection)set2)).must((QueryBuilder)QueryBuilders.termQuery((String)this.toName("user"), (Object)user.getId())));
            }
            if (!(set2 = restrictedOperatorAccessibleAccounts.getOutgoing()).isEmpty()) {
                set = SimpleEntity.uniqueIds((Collection)set2);
                boolQueryBuilder.should((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termsQuery((String)this.fromName((Property<?, ?>)AccountVO.TYPE), (Collection)set)).must((QueryBuilder)QueryBuilders.termQuery((String)this.fromName("user"), (Object)user.getId())));
            }
            if ((set = this.additionalRestrictedOperatorFilter(sessionData)) != null) {
                boolQueryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)boolQueryBuilder).must((QueryBuilder)set);
            }
        }
        user = null;
        if (sessionData.isBroker()) {
            user = this.getBrokeringFilters(sessionData);
        }
        if (boolQueryBuilder == null || user == null) {
            return (QueryBuilder)ObjectHelper.defaultValue((Object)boolQueryBuilder, (Object)user);
        }
        return QueryBuilders.boolQuery().should((QueryBuilder)boolQueryBuilder).should((QueryBuilder)user);
    }

    protected UserVO getUser(VOFiller<BasicUserVO> vOFiller, SourceAccessor sourceAccessor, Property<?, ?> property) {
        return this.getUser(vOFiller, sourceAccessor, property.getName());
    }

    protected UserVO getUser(VOFiller<BasicUserVO> vOFiller, SourceAccessor sourceAccessor, String string) {
        return (UserVO)vOFiller.add(sourceAccessor.getAsLong(string), UserVO.class);
    }

    protected void setBasicUser(SourceAccessor sourceAccessor, Property<?, ?> property, BasicUser basicUser) {
        this.setBasicUser(sourceAccessor, property.getName(), basicUser);
    }

    protected void setBasicUser(SourceAccessor sourceAccessor, String string, BasicUser basicUser) {
        sourceAccessor.set(string, (Object)basicUser);
        User user = null;
        if (basicUser != null && basicUser.isOperator()) {
            user = basicUser.getUser();
        }
        sourceAccessor.set(this.userName(string), (Object)user);
    }

    protected AccountVO toAccountVO(VOFiller<BasicUserVO> vOFiller, SessionData sessionData, SourceAccessor sourceAccessor) {
        if (sourceAccessor == null) {
            return null;
        }
        AccountVO accountVO = new AccountVO();
        accountVO.setId(sourceAccessor.getAsLong((Property<?, ?>)AccountVO.ID));
        Long l = sourceAccessor.getAsLong("user");
        if (l == null) {
            accountVO.setOwner((InternalAccountOwner)SystemAccountOwner.instance());
        } else {
            accountVO.setOwner((InternalAccountOwner)vOFiller.add(l, UserVO.class));
        }
        accountVO.setType(sourceAccessor.getAsEntityVO(AccountType.class, AccountTypeVO.class, (Property<?, ?>)AccountVO.TYPE));
        AccountNumberConfiguration accountNumberConfiguration = sessionData.getConfiguration().getAccountNumberConfiguration();
        if (accountNumberConfiguration != null && accountNumberConfiguration.isEnabled()) {
            accountVO.setNumber(MaskHelper.applyMask((String)accountNumberConfiguration.getMask(), (String)sourceAccessor.getAsString((Property<?, ?>)AccountVO.NUMBER)));
        }
        return accountVO;
    }

    protected String toName(Property<?, ?> property) {
        return this.toName(property.getName());
    }

    protected String toName(String string) {
        return "to." + string;
    }

    @Override
    protected List<SortBuilder<?>> toSort(AbstractTransQuery abstractTransQuery) {
        TransactionOrderBy transactionOrderBy = (TransactionOrderBy)ObjectHelper.defaultValue((Object)abstractTransQuery.getOrderBy(), (Object)this.getDefaultOrder());
        boolean bl = EnumSet.of(TransactionOrderBy.DATE_ASC, TransactionOrderBy.AMOUNT_ASC).contains(transactionOrderBy);
        switch (transactionOrderBy) {
            case DATE_ASC: 
            case DATE_DESC: {
                return Collections.singletonList(SortBuilders.fieldSort((String)this.dateField()).order(bl ? SortOrder.ASC : SortOrder.DESC));
            }
            case AMOUNT_ASC: 
            case AMOUNT_DESC: {
                return Collections.singletonList(SortBuilders.fieldSort((String)CurrencyAmountDTO.AMOUNT.getName()).order(bl ? SortOrder.ASC : SortOrder.DESC));
            }
        }
        return null;
    }

    @Override
    protected final QueryBuilder toWhere(Q q) {
        QueryAccessor queryAccessor = new QueryAccessor();
        this.appendWhere(InvocationContext.getSessionData(), queryAccessor, (AbstractTransQuery)q);
        return queryAccessor.queryBuilder();
    }

    protected String userName(Property<?, ?> property) {
        return this.userName(property.getName());
    }

    protected String userName(String string) {
        return string + "$user";
    }

    private SourceAccessor toAccount(Account account) {
        if (account == null) {
            return null;
        }
        SourceAccessor sourceAccessor = new SourceAccessor();
        sourceAccessor.set((Property<?, ?>)AccountVO.ID, (Object)account.getId());
        sourceAccessor.set((Property<?, ?>)AccountVO.NUMBER, (Object)account.getNumber());
        sourceAccessor.set((Property<?, ?>)AccountVO.TYPE, (Object)account.getType());
        if (account instanceof UserAccount) {
            User user = ((UserAccount)account).getUser();
            sourceAccessor.set("user", (Object)user);
            sourceAccessor.set("group", (Object)user.getGroup());
            sourceAccessor.set("broker", (Object)user.getBrokerIds());
        }
        return sourceAccessor;
    }
}

