/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.search.opensearch;

import com.google.common.collect.Iterators;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Predicate;
import java.io.IOException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cyclos.entities.NetworkedEntity;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.banking.ArchivedEntityToRemoveFromIndex;
import org.cyclos.entities.banking.EntityTypeToRemoveFromIndex;
import org.cyclos.entities.banking.QArchivedEntityToRemoveFromIndex;
import org.cyclos.impl.BeanHandler;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.search.ContactSearchHandler;
import org.cyclos.impl.search.EntitySearchHandler;
import org.cyclos.impl.search.IndexEntitiesBackgroundTask;
import org.cyclos.impl.search.RemoveArchivedEntitiesFromIndexException;
import org.cyclos.impl.search.SearchHandler;
import org.cyclos.impl.search.opensearch.OpenSearchAdSearchHandlerImpl;
import org.cyclos.impl.search.opensearch.OpenSearchEntitySearchHandlerImpl;
import org.cyclos.impl.search.opensearch.OpenSearchInstallmentSearchHandlerImpl;
import org.cyclos.impl.search.opensearch.OpenSearchRecordSearchHandlerImpl;
import org.cyclos.impl.search.opensearch.OpenSearchTransactionSearchHandlerImpl;
import org.cyclos.impl.search.opensearch.OpenSearchTransferSearchHandlerImpl;
import org.cyclos.impl.search.opensearch.OpenSearchUserSearchHandlerImpl;
import org.cyclos.impl.search.opensearch.PartialBulkFailureException;
import org.cyclos.impl.sql.NativeQueryHandler;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.impl.utils.tasks.BackgroundTaskHandler;
import org.cyclos.impl.utils.tasks.BackgroundTaskScheduling;
import org.cyclos.model.utils.TimeField;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.StringHelper;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionResponse;
import org.opensearch.action.bulk.BulkItemResponse;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.search.ClearScrollRequest;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestClient;
import org.opensearch.client.RestClientBuilder;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.index.reindex.DeleteByQueryRequest;
import org.opensearch.index.reindex.UpdateByQueryRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class OpenSearchHandlerImpl
implements SearchHandler {
    private static final Logger LOG = LogManager.getLogger(OpenSearchHandlerImpl.class);
    public static final String STANDARD = "standard";
    public static final RequestOptions REQUEST_OPTIONS = RequestOptions.DEFAULT;
    private static final int TO_ARCHIVE_BATCH_SIZE = 1000;
    @Autowired
    private BeanHandler beanHandler;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private CyclosProperties cyclosProperties;
    @Autowired
    private NativeQueryHandler nativeQueryHandler;
    @Autowired
    private BackgroundTaskHandler backgroundTaskHandler;
    @Autowired
    private InvokerHandler invokerHandler;
    private RestHighLevelClient client;
    private Map<String, OpenSearchEntitySearchHandlerImpl<?, ?, ?>> entities;
    private OpenSearchAdSearchHandlerImpl ad;
    private OpenSearchRecordSearchHandlerImpl record;
    private OpenSearchUserSearchHandlerImpl user;
    private OpenSearchTransferSearchHandlerImpl transfer;
    private OpenSearchTransactionSearchHandlerImpl transaction;
    private OpenSearchInstallmentSearchHandlerImpl installment;
    private Class<? extends OpenSearchAdSearchHandlerImpl> adSearchHandlerClass;
    private Class<? extends OpenSearchRecordSearchHandlerImpl> recordSearchHandlerClass;
    private Class<? extends OpenSearchUserSearchHandlerImpl> userSearchHandlerClass;
    private Class<? extends OpenSearchTransferSearchHandlerImpl> transferSearchHandlerClass;
    private Class<? extends OpenSearchTransactionSearchHandlerImpl> transactionSearchHandlerClass;
    private Class<? extends OpenSearchInstallmentSearchHandlerImpl> installmentSearchHandlerClass;
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;

    public static boolean ignoreESResponse(String string) {
        return StringUtils.containsIgnoreCase((CharSequence)string, (CharSequence)"type=index_not_found_exception") || StringUtils.containsIgnoreCase((CharSequence)string, (CharSequence)"type=document_missing_exception") || StringUtils.containsIgnoreCase((CharSequence)string, (CharSequence)"type=version_conflict_engine_exception");
    }

    public static RestHighLevelClient newClient(CyclosProperties cyclosProperties) {
        Properties properties = cyclosProperties.getSearchHandlerProperties();
        List list = StringHelper.splitTrimming((String)properties.getProperty("host", "https://localhost:9200"), (String)",");
        String string = "/" + StringHelper.removeEnd((String)StringHelper.removeStart((String)properties.getProperty("pathPrefix", "/"), (String)"/"), (String)"/");
        String string2 = properties.getProperty("user");
        String string3 = properties.getProperty("password");
        boolean bl = Boolean.parseBoolean(properties.getProperty("trustAllCertificates"));
        HttpHost[] httpHostArray = (HttpHost[])list.stream().map(HttpHost::create).toArray(HttpHost[]::new);
        RestClientBuilder restClientBuilder = RestClient.builder((HttpHost[])httpHostArray);
        restClientBuilder.setPathPrefix(string);
        restClientBuilder.setHttpClientConfigCallback(httpAsyncClientBuilder -> {
            TrustManager[] trustManagerArray;
            if (StringHelper.isNotBlank((Object)string2) && StringHelper.isNotBlank((Object)string3)) {
                trustManagerArray = new BasicCredentialsProvider();
                trustManagerArray.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(string2, string3));
                httpAsyncClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)trustManagerArray);
            }
            if (bl) {
                trustManagerArray = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return new X509Certificate[0];
                    }
                }};
                try {
                    SSLContext sSLContext = SSLContext.getInstance("SSL");
                    sSLContext.init(null, trustManagerArray, new SecureRandom());
                    httpAsyncClientBuilder.setSSLContext(sSLContext);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return httpAsyncClientBuilder;
        });
        return new RestHighLevelClient(restClientBuilder);
    }

    public OpenSearchHandlerImpl() {
        this(OpenSearchAdSearchHandlerImpl.class, OpenSearchRecordSearchHandlerImpl.class, OpenSearchUserSearchHandlerImpl.class, OpenSearchTransferSearchHandlerImpl.class, OpenSearchTransactionSearchHandlerImpl.class, OpenSearchInstallmentSearchHandlerImpl.class);
    }

    public OpenSearchHandlerImpl(Class<? extends OpenSearchAdSearchHandlerImpl> clazz, Class<? extends OpenSearchRecordSearchHandlerImpl> clazz2, Class<? extends OpenSearchUserSearchHandlerImpl> clazz3, Class<? extends OpenSearchTransferSearchHandlerImpl> clazz4, Class<? extends OpenSearchTransactionSearchHandlerImpl> clazz5, Class<? extends OpenSearchInstallmentSearchHandlerImpl> clazz6) {
        this.adSearchHandlerClass = clazz;
        this.recordSearchHandlerClass = clazz2;
        this.userSearchHandlerClass = clazz3;
        this.transferSearchHandlerClass = clazz4;
        this.transactionSearchHandlerClass = clazz5;
        this.installmentSearchHandlerClass = clazz6;
    }

    public OpenSearchAdSearchHandlerImpl ad() {
        return this.ad;
    }

    public void addEntityToIndex(String string, Long l) {
        if (this.cyclosProperties.isTestingEnv()) {
            this.performIndex(string, Arrays.asList(l));
        } else {
            InvocationContext invocationContext = InvocationContext.ensure();
            Set set = (Set)invocationContext.getAttribute((Object)this.indexAttribute(string), HashSet::new);
            if (set.isEmpty()) {
                HashMap hashMap = new HashMap();
                invocationContext.addBeforeEndListener(() -> Iterators.partition(set.iterator(), (int)50).forEachRemaining(list -> {
                    Long l = this.backgroundTaskHandler.schedule((BackgroundTaskScheduling)new IndexEntitiesBackgroundTask.IndexEntitiesContext(string, (Collection<Long>)list).scheduling().startAfter(DateHelper.add((Date)new Date(), (TimeField)TimeField.MINUTES, (int)1)));
                    hashMap.put(l, list);
                }));
                invocationContext.addCommitListener(false, () -> hashMap.entrySet().forEach(entry -> {
                    Long l = (Long)entry.getKey();
                    List list = (List)entry.getValue();
                    this.doPerformIndex(string, list, l, 0);
                }));
            }
            set.add(l);
        }
    }

    public ContactSearchHandler contact() {
        return this.nativeQueryHandler.getSearchHandler().contact();
    }

    @PreDestroy
    public void destroy() {
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.beanHandler.destroy((Object)this.user);
    }

    public RestHighLevelClient getClient() {
        return this.client;
    }

    @PostConstruct
    public void initialize() {
        this.client = OpenSearchHandlerImpl.newClient(this.cyclosProperties);
        LOG.info("Handling searches with OpenSearch on " + this.client.getLowLevelClient().getNodes().stream().map(node -> node.getHost().toURI()).collect(Collectors.joining(",")));
        this.ad = (OpenSearchAdSearchHandlerImpl)this.beanHandler.autowireWithArgs(this.adSearchHandlerClass, new Object[]{this});
        this.record = (OpenSearchRecordSearchHandlerImpl)this.beanHandler.autowireWithArgs(this.recordSearchHandlerClass, new Object[]{this});
        this.user = (OpenSearchUserSearchHandlerImpl)this.beanHandler.autowireWithArgs(this.userSearchHandlerClass, new Object[]{this});
        this.transfer = (OpenSearchTransferSearchHandlerImpl)this.beanHandler.autowireWithArgs(this.transferSearchHandlerClass, new Object[]{this});
        this.transaction = (OpenSearchTransactionSearchHandlerImpl)this.beanHandler.autowireWithArgs(this.transactionSearchHandlerClass, new Object[]{this});
        this.installment = (OpenSearchInstallmentSearchHandlerImpl)this.beanHandler.autowireWithArgs(this.installmentSearchHandlerClass, new Object[]{this});
        this.entities = Arrays.asList(this.ad, this.record, this.user, this.transfer, this.transaction, this.installment).stream().collect(Collectors.toMap(EntitySearchHandler::indexName, openSearchEntitySearchHandlerImpl -> openSearchEntitySearchHandlerImpl));
    }

    public OpenSearchInstallmentSearchHandlerImpl installment() {
        return this.installment;
    }

    public boolean isPhraseSearchSupported() {
        return true;
    }

    public boolean isTranslationSupported() {
        return true;
    }

    public void onApplicationInitialization() {
        this.entities.values().forEach(OpenSearchEntitySearchHandlerImpl::syncIndex);
    }

    public void performIndex(String string, List<Long> list) {
        this.doPerformIndex(string, list, null, 0);
    }

    public OpenSearchRecordSearchHandlerImpl record() {
        return this.record;
    }

    public void reindex() {
        this.entities.values().forEach(EntitySearchHandler::reindex);
    }

    public long removeArchived(Instant instant) throws RemoveArchivedEntitiesFromIndexException {
        List<ArchivedEntityToRemoveFromIndex> list;
        int n = this.cyclosProperties.getArchivingDeleteDurationMinutes();
        int n2 = this.cyclosProperties.getArchivingWaitTimeBetweenDeletesMillis();
        long l = 0L;
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zoneId);
        while (!localDateTime.plusMinutes(n).isBefore(LocalDateTime.now(zoneId)) && !(list = this.nextArchivedBatchToRemove()).isEmpty()) {
            try {
                this.requestRemoval(list);
                this.deleteArchivedBatchToRemove(list);
            }
            catch (Exception exception) {
                throw new RemoveArchivedEntitiesFromIndexException(l, (Throwable)exception);
            }
            l += (long)list.size();
            if (n2 <= 0) continue;
            try {
                Thread.sleep(n2);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
        return l;
    }

    public void scheduleBulk(Function<Exception, BulkRequest> function, Runnable runnable, Consumer<Exception> consumer) {
        this.doSchedule(function, true, (arg_0, arg_1) -> ((RestHighLevelClient)this.client).bulk(arg_0, arg_1), (arg_0, arg_1, arg_2) -> ((RestHighLevelClient)this.client).bulkAsync(arg_0, arg_1, arg_2), runnable, consumer, 0, null);
    }

    public void scheduleClearScroll(ClearScrollRequest clearScrollRequest, Runnable runnable, Consumer<Exception> consumer) {
        this.doSchedule(exception -> clearScrollRequest, false, (arg_0, arg_1) -> ((RestHighLevelClient)this.client).clearScroll(arg_0, arg_1), (arg_0, arg_1, arg_2) -> ((RestHighLevelClient)this.client).clearScrollAsync(arg_0, arg_1, arg_2), runnable, consumer, 0, null);
    }

    public void scheduleDelete(DeleteRequest deleteRequest, Runnable runnable, Consumer<Exception> consumer) {
        this.doSchedule(exception -> deleteRequest, false, (arg_0, arg_1) -> ((RestHighLevelClient)this.client).delete(arg_0, arg_1), (arg_0, arg_1, arg_2) -> ((RestHighLevelClient)this.client).deleteAsync(arg_0, arg_1, arg_2), runnable, consumer, 0, null);
    }

    public void scheduleDeleteByQuery(DeleteByQueryRequest deleteByQueryRequest, Runnable runnable, Consumer<Exception> consumer) {
        this.doSchedule(exception -> deleteByQueryRequest, false, (arg_0, arg_1) -> ((RestHighLevelClient)this.client).deleteByQuery(arg_0, arg_1), (arg_0, arg_1, arg_2) -> ((RestHighLevelClient)this.client).deleteByQueryAsync(arg_0, arg_1, arg_2), runnable, consumer, 0, null);
    }

    public void scheduleUpdate(Function<Exception, UpdateRequest> function, Runnable runnable, Consumer<Exception> consumer) {
        this.doSchedule(function, true, (arg_0, arg_1) -> ((RestHighLevelClient)this.client).update(arg_0, arg_1), (arg_0, arg_1, arg_2) -> ((RestHighLevelClient)this.client).updateAsync(arg_0, arg_1, arg_2), runnable, consumer, 0, null);
    }

    public void scheduleUpdateByQuery(Function<Exception, UpdateByQueryRequest> function, Runnable runnable, Consumer<Exception> consumer) {
        this.doSchedule(function, true, (arg_0, arg_1) -> ((RestHighLevelClient)this.client).updateByQuery(arg_0, arg_1), (arg_0, arg_1, arg_2) -> ((RestHighLevelClient)this.client).updateByQueryAsync(arg_0, arg_1, arg_2), runnable, consumer, 0, null);
    }

    public <S extends SearchHandler> S self() {
        return (S)this;
    }

    public OpenSearchTransactionSearchHandlerImpl transaction() {
        return this.transaction;
    }

    public OpenSearchTransferSearchHandlerImpl transfer() {
        return this.transfer;
    }

    public OpenSearchUserSearchHandlerImpl user() {
        return this.user;
    }

    private void deleteArchivedBatchToRemove(List<ArchivedEntityToRemoveFromIndex> list) {
        List list2 = SimpleEntity.ids(list);
        this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_WRITE, transactionStatus -> {
            QArchivedEntityToRemoveFromIndex qArchivedEntityToRemoveFromIndex = QArchivedEntityToRemoveFromIndex.archivedEntityToRemoveFromIndex;
            return this.rawEntityManagerHandler.delete((EntityPath)qArchivedEntityToRemoveFromIndex).where(new Predicate[]{qArchivedEntityToRemoveFromIndex.id.in((Collection)list2)}).execute();
        });
    }

    private void doPerformIndex(String string, List<Long> list, Long l, int n) {
        if (CollectionHelper.isEmpty(list)) {
            return;
        }
        OpenSearchEntitySearchHandlerImpl<?, ?, ?> openSearchEntitySearchHandlerImpl = this.entities.get(string);
        Function<Exception, BulkRequest> function = exception -> {
            BulkRequest bulkRequest;
            List list2 = list;
            if (exception instanceof PartialBulkFailureException) {
                bulkRequest = ((PartialBulkFailureException)exception).getFailures();
                list2 = bulkRequest.stream().map(bulkItemResponse -> Long.valueOf(bulkItemResponse.getId())).collect(Collectors.toList());
            }
            if (list2.isEmpty()) {
                return null;
            }
            bulkRequest = new BulkRequest(string);
            List list3 = openSearchEntitySearchHandlerImpl.findAll(list);
            list3.stream().map(networkedEntity -> this.toIndexRequest(openSearchEntitySearchHandlerImpl, networkedEntity)).filter(Objects::nonNull).forEach(arg_0 -> ((BulkRequest)bulkRequest).add(arg_0));
            return bulkRequest;
        };
        this.scheduleBulk(function, l == null ? null : () -> this.removeTask(l), null);
    }

    private <Req extends ActionRequest, Resp extends ActionResponse> void doSchedule(final Function<Exception, Req> function, final boolean bl, final SyncRequest<Req, Resp> syncRequest, final AsyncRequest<Req, Resp> asyncRequest, final Runnable runnable, final Consumer<Exception> consumer, final Integer n, Exception exception) {
        if (this.cyclosProperties.isTestingEnv()) {
            ActionRequest actionRequest = (ActionRequest)function.apply(null);
            if (actionRequest instanceof WriteRequest) {
                ((WriteRequest)actionRequest).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            }
            try {
                syncRequest.run(actionRequest, REQUEST_OPTIONS);
            }
            catch (Exception exception2) {
                if (consumer != null) {
                    consumer.accept(exception2);
                }
            }
        } else {
            Runnable runnable2 = () -> {
                ActionRequest actionRequest;
                ActionRequest actionRequest2 = actionRequest = bl ? (ActionRequest)this.invokerHandler.runAsInCurrentOrNewTransaction(SessionDataFactory.system(), TransactionLevel.READ_ONLY, transactionStatus -> (ActionRequest)function.apply(exception)) : (ActionRequest)function.apply(exception);
                if (actionRequest == null) {
                    return;
                }
                asyncRequest.run(actionRequest, REQUEST_OPTIONS, new ActionListener<Resp>(){

                    public void onFailure(Exception exception) {
                        Integer n2 = OpenSearchHandlerImpl.this.nextRetryAfterSeconds(n);
                        if (n2 != null) {
                            OpenSearchHandlerImpl.this.invokerHandler.getExecutorService().schedule(() -> OpenSearchHandlerImpl.this.doSchedule(function, bl, syncRequest, asyncRequest, runnable, consumer, n + 1, exception), (long)n2.intValue(), TimeUnit.SECONDS);
                        } else {
                            if (!OpenSearchHandlerImpl.ignoreESResponse(exception.getMessage())) {
                                LOG.warn("Error on OpenSearch request: " + exception.getMessage());
                            }
                            if (consumer != null) {
                                try {
                                    consumer.accept(exception);
                                }
                                catch (Exception exception2) {
                                    LOG.warn("Exception handling for an OpenSearch operation failed", (Throwable)exception2);
                                }
                            }
                        }
                    }

                    public void onResponse(Resp Resp) {
                        if (Resp instanceof BulkResponse) {
                            List<BulkItemResponse> list = Stream.of(((BulkResponse)Resp).getItems()).filter(BulkItemResponse::isFailed).collect(Collectors.toList());
                            if (list.isEmpty()) {
                                if (runnable != null) {
                                    runnable.run();
                                }
                            } else if (consumer != null) {
                                consumer.accept(new PartialBulkFailureException(list));
                            }
                        } else if (runnable != null) {
                            runnable.run();
                        }
                    }
                });
            };
            InvocationContext invocationContext = InvocationContext.get();
            if (invocationContext != null && invocationContext.getTransactionLevel() == TransactionLevel.READ_WRITE) {
                invocationContext.addCommitListener(false, runnable2);
            } else {
                runnable2.run();
            }
        }
    }

    private String indexAttribute(String string) {
        return "to-index@" + string;
    }

    private String indexOf(EntityTypeToRemoveFromIndex entityTypeToRemoveFromIndex) {
        switch (entityTypeToRemoveFromIndex) {
            case TRANSFER: {
                return this.transfer.indexName();
            }
            case TRANSACTION: {
                return this.transaction.indexName();
            }
            case INSTALLMENT: {
                return this.installment.indexName();
            }
        }
        throw new IllegalStateException("Unhandled index type: " + String.valueOf(entityTypeToRemoveFromIndex));
    }

    private List<ArchivedEntityToRemoveFromIndex> nextArchivedBatchToRemove() {
        return (List)this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_ONLY, transactionStatus -> {
            QArchivedEntityToRemoveFromIndex qArchivedEntityToRemoveFromIndex = QArchivedEntityToRemoveFromIndex.archivedEntityToRemoveFromIndex;
            List list = ((DBQuery)this.rawEntityManagerHandler.selectFrom((EntityPath)qArchivedEntityToRemoveFromIndex).limit(1000L)).fetch();
            return list;
        });
    }

    private Integer nextRetryAfterSeconds(Integer n) {
        if (n == null || this.cyclosProperties.isTestingEnv() || n >= 2) {
            return null;
        }
        return 10 * n;
    }

    private void removeTask(Long l) {
        this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_WRITE, transactionStatus -> {
            this.backgroundTaskHandler.remove(l);
            return null;
        });
    }

    private void requestRemoval(List<ArchivedEntityToRemoveFromIndex> list) throws IOException {
        BulkRequest bulkRequest = new BulkRequest();
        list.forEach(archivedEntityToRemoveFromIndex -> bulkRequest.add(new DeleteRequest(this.indexOf(archivedEntityToRemoveFromIndex.getEntityType()), archivedEntityToRemoveFromIndex.getEntityId().toString())));
        this.client.bulk(bulkRequest, REQUEST_OPTIONS);
    }

    private <E extends NetworkedEntity> IndexRequest toIndexRequest(OpenSearchEntitySearchHandlerImpl<E, ?, ?> openSearchEntitySearchHandlerImpl, E e) {
        IndexRequest indexRequest = new IndexRequest(openSearchEntitySearchHandlerImpl.indexName());
        indexRequest.id(e.getId().toString());
        indexRequest.source(openSearchEntitySearchHandlerImpl.entityToMap(e));
        return indexRequest;
    }

    @FunctionalInterface
    private static interface SyncRequest<Req extends ActionRequest, Resp extends ActionResponse> {
        public Resp run(Req var1, RequestOptions var2) throws IOException;
    }

    @FunctionalInterface
    private static interface AsyncRequest<Req extends ActionRequest, Resp extends ActionResponse> {
        public void run(Req var1, RequestOptions var2, ActionListener<Resp> var3);
    }
}

