/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.search.opensearch;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclos.entities.NetworkedEntity;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.access.PrincipalType;
import org.cyclos.entities.banking.AccountType;
import org.cyclos.entities.banking.AuthorizationLevel;
import org.cyclos.entities.banking.AuthorizationRole;
import org.cyclos.entities.banking.BasePayment;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.ExternalPayment;
import org.cyclos.entities.banking.HasExpirationDate;
import org.cyclos.entities.banking.Installment;
import org.cyclos.entities.banking.RecurringPayment;
import org.cyclos.entities.banking.ScheduledPayment;
import org.cyclos.entities.banking.Trans;
import org.cyclos.entities.banking.Transaction;
import org.cyclos.entities.banking.TransactionCustomField;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.users.Operator;
import org.cyclos.entities.users.OperatorGroup;
import org.cyclos.entities.users.QAdminProductAuthorizationRole;
import org.cyclos.entities.users.User;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.banking.AuthorizationLevelServiceLocal;
import org.cyclos.impl.banking.LocateAccountOwnerResult;
import org.cyclos.impl.search.TransactionSearchHandler;
import org.cyclos.impl.search.opensearch.OpenSearchHandlerImpl;
import org.cyclos.impl.search.opensearch.OpenSearchTransSearchHandlerImpl;
import org.cyclos.impl.search.opensearch.QueryAccessor;
import org.cyclos.impl.search.opensearch.SourceAccessor;
import org.cyclos.impl.users.AdminProductAccessor;
import org.cyclos.impl.users.OperatorGroupServiceLocal;
import org.cyclos.impl.utils.conversion.VOFiller;
import org.cyclos.model.Property;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.principaltypes.PrincipalTypeVO;
import org.cyclos.model.banking.accounts.AccountOwner;
import org.cyclos.model.banking.accounts.AccountVO;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.accounts.SystemAccountOwner;
import org.cyclos.model.banking.accounts.TransferDirection;
import org.cyclos.model.banking.currencies.CurrencyVO;
import org.cyclos.model.banking.transactions.AbstractTransQuery;
import org.cyclos.model.banking.transactions.AbstractTransactionQuery;
import org.cyclos.model.banking.transactions.ExternalPaymentResultVO;
import org.cyclos.model.banking.transactions.ExternalPaymentStatus;
import org.cyclos.model.banking.transactions.HasShowToReceiver;
import org.cyclos.model.banking.transactions.HasTransactionStatus;
import org.cyclos.model.banking.transactions.InstallmentStatus;
import org.cyclos.model.banking.transactions.InstallmentVO;
import org.cyclos.model.banking.transactions.OwnedTransactionQuery;
import org.cyclos.model.banking.transactions.PaymentCreationType;
import org.cyclos.model.banking.transactions.PaymentRequestResultVO;
import org.cyclos.model.banking.transactions.PaymentRequestStatus;
import org.cyclos.model.banking.transactions.RecurringPaymentResultVO;
import org.cyclos.model.banking.transactions.RecurringPaymentStatus;
import org.cyclos.model.banking.transactions.ScheduledPaymentResultVO;
import org.cyclos.model.banking.transactions.ScheduledPaymentStatus;
import org.cyclos.model.banking.transactions.TicketResultVO;
import org.cyclos.model.banking.transactions.TicketStatus;
import org.cyclos.model.banking.transactions.TransVO;
import org.cyclos.model.banking.transactions.TransactionAuthorizationStatus;
import org.cyclos.model.banking.transactions.TransactionAuthorizationType;
import org.cyclos.model.banking.transactions.TransactionNature;
import org.cyclos.model.banking.transactions.TransactionResultVO;
import org.cyclos.model.banking.transactions.TransactionVO;
import org.cyclos.model.banking.transfertypes.TransferTypeWithCurrencyVO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.utils.CurrencyAmountDTO;
import org.cyclos.security.banking.TransactionServiceSecurity;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.coercion.CoercionHelper;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.ExistsQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.TermQueryBuilder;
import org.opensearch.search.SearchHit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

public abstract class OpenSearchBaseTransactionSearchHandlerImpl<E extends NetworkedEntity, Q extends AbstractTransactionQuery, T>
extends OpenSearchTransSearchHandlerImpl<E, Q, T> {
    protected static final String AUTHORIZATION_TYPE = "authorizationType";
    protected static final String AUTHORIZATION_LEVEL = "authorizationLevel";
    protected static final String AUTHORIZATION_PERFORMED_BY = "authorizationPerformedBy";
    protected static final String SHOW_TO_RECEIVER = "showToReceiver";
    protected static final String EXPIRATION_DATE = "expirationDate";
    protected static final String NATURE_SPECIFIC = "natureSpecific";
    @Autowired
    @Lazy
    protected OperatorGroupServiceLocal operatorGroupService;
    @Autowired
    @Lazy
    protected AuthorizationLevelServiceLocal authorizationLevelService;
    @Autowired
    @Lazy
    protected TransactionServiceSecurity transactionServiceSecurity;

    public OpenSearchBaseTransactionSearchHandlerImpl(OpenSearchHandlerImpl openSearchHandlerImpl, Class<E> clazz, EntityPath<E> entityPath) {
        super(openSearchHandlerImpl, clazz, entityPath);
    }

    @Override
    protected QueryBuilder additionalAdminFilter(SessionData sessionData) {
        Set set = sessionData.getProducts().admin().getAuthorizationRoles().keysSet((Path)QAdminProductAuthorizationRole.adminProductAuthorizationRole.view);
        Set set2 = set.stream().flatMap(authorizationRole -> authorizationRole.getLevels().stream()).map(AuthorizationLevel::getTransferType).collect(Collectors.toSet());
        return set2.isEmpty() ? this.authorized() : QueryBuilders.boolQuery().should(this.authorized()).should((QueryBuilder)QueryBuilders.termsQuery((String)TransVO.TYPE.getName(), (Collection)SimpleEntity.uniqueIds(set2)));
    }

    @Override
    protected QueryBuilder additionalBrokerFilter(SessionData sessionData) {
        if (!sessionData.hasPermission(Permission.BROKER_AUTHORIZED_PAYMENTS_VIEW)) {
            return this.authorized();
        }
        return null;
    }

    @Override
    protected QueryBuilder additionalRestrictedOperatorFilter(SessionData sessionData) {
        Operator operator = sessionData.getLoggedOperator();
        OperatorGroup operatorGroup = operator.getGroup();
        List list = this.operatorGroupService.listPaymentTypesWithAuthorize(operatorGroup);
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.should(this.authorized());
        boolQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"by", (Object)operator.getId()));
        boolQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"receivedBy", (Object)operator.getId()));
        if (!list.isEmpty()) {
            boolQueryBuilder.should((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)AUTHORIZATION_TYPE, (Object)TransactionAuthorizationType.OPERATOR)).must((QueryBuilder)QueryBuilders.termQuery((String)this.fromName("user"), (Object)operator.getUser().getId())).must((QueryBuilder)QueryBuilders.termsQuery((String)TransVO.TYPE.getName(), (Collection)SimpleEntity.uniqueIds((Collection)list))));
        }
        if (sessionData.hasPermission(Permission.MY_AUTHORIZED_PAYMENTS_VIEW)) {
            boolQueryBuilder.should((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)AUTHORIZATION_TYPE, (Object)TransactionAuthorizationType.LEVEL)).must((QueryBuilder)QueryBuilders.termQuery((String)this.fromName("user"), (Object)operator.getUser().getId())));
        }
        return boolQueryBuilder;
    }

    @Override
    protected void appendWhere(SessionData sessionData, QueryAccessor queryAccessor, AbstractTransQuery abstractTransQuery) {
        super.appendWhere(sessionData, queryAccessor, abstractTransQuery);
        if (abstractTransQuery instanceof AbstractTransactionQuery) {
            User user;
            Set set;
            AbstractTransactionQuery abstractTransactionQuery = (AbstractTransactionQuery)abstractTransQuery;
            if (abstractTransactionQuery.getAuthorized() != null) {
                set = QueryBuilders.termQuery((String)TransactionResultVO.AUTHORIZATION_STATUS.getName(), (Object)TransactionAuthorizationStatus.NA);
                if (abstractTransactionQuery.getAuthorized().booleanValue()) {
                    queryAccessor.filter((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)set));
                } else {
                    queryAccessor.filter((QueryBuilder)set);
                }
            }
            if (CollectionHelper.isNotEmpty((Iterable)(set = abstractTransactionQuery.getAuthorizationStatuses()))) {
                if (set.contains(TransactionAuthorizationStatus.AUTHORIZED)) {
                    user = EnumSet.of(TransactionAuthorizationStatus.NA);
                    user.addAll(set);
                    set = user;
                }
                queryAccessor.filter((QueryBuilder)QueryBuilders.termsQuery((String)TransactionResultVO.AUTHORIZATION_STATUS.getName(), (Collection)set));
            }
            if ((user = (User)this.conversionHandler.convert(User.class, (Object)abstractTransactionQuery.getAuthorizationPerformedBy())) != null) {
                queryAccessor.filter((QueryBuilder)QueryBuilders.termQuery((String)AUTHORIZATION_PERFORMED_BY, (Object)user.getId()));
            }
            Set set2 = this.conversionHandler.convertSet(AuthorizationRole.class, (Iterable)abstractTransactionQuery.getAuthorizationRoles());
            if (sessionData.isAdmin() && CollectionHelper.isNotEmpty((Iterable)set2)) {
                List list = this.authorizationLevelService.listByRoles(set2);
                if (list.isEmpty()) {
                    queryAccessor.invalid();
                } else {
                    queryAccessor.filter((QueryBuilder)QueryBuilders.termsQuery((String)AUTHORIZATION_LEVEL, (Collection)SimpleEntity.uniqueIds((Collection)list)));
                }
            }
            if (CollectionHelper.isNotEmpty((Iterable)abstractTransactionQuery.getNatures())) {
                queryAccessor.filter((QueryBuilder)QueryBuilders.termsQuery((String)"nature", (Collection)abstractTransactionQuery.getNatures()));
            }
            if (CollectionHelper.isNotEmpty((Iterable)abstractTransactionQuery.getCreationTypes())) {
                queryAccessor.filter((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termsQuery((String)TransactionVO.NATURE.getName(), (Collection)TransactionNature.basePayment()))).should((QueryBuilder)QueryBuilders.termsQuery((String)TransactionVO.CREATION_TYPE.getName(), (Collection)abstractTransactionQuery.getCreationTypes())));
            }
        }
    }

    @Override
    protected void applyOwned(SessionData sessionData, QueryAccessor queryAccessor, AbstractTransQuery abstractTransQuery) {
        TermQueryBuilder termQueryBuilder;
        BoolQueryBuilder boolQueryBuilder;
        Set set;
        OwnedTransactionQuery ownedTransactionQuery = (OwnedTransactionQuery)abstractTransQuery;
        Set set2 = this.conversionHandler.convertSet(AccountType.class, (Iterable)ownedTransactionQuery.getAccountTypes());
        if (!set2.isEmpty()) {
            set = SimpleEntity.uniqueIds((Collection)set2);
            queryAccessor.filter((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.termsQuery((String)this.fromName((Property<?, ?>)AccountVO.TYPE), (Collection)set)).should((QueryBuilder)QueryBuilders.termsQuery((String)this.toName((Property<?, ?>)AccountVO.TYPE), (Collection)set)));
        }
        set = this.accountHandler.locateOrCurrent((AccountOwner)ownedTransactionQuery.getOwner()).getInternalAccountOwner();
        TransferDirection transferDirection = ownedTransactionQuery.getDirection();
        if (set instanceof SystemAccountOwner) {
            boolQueryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.existsQuery((String)this.fromName((Property<?, ?>)AccountVO.ID))).mustNot((QueryBuilder)QueryBuilders.existsQuery((String)this.fromName("user")));
            termQueryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.existsQuery((String)this.toName((Property<?, ?>)AccountVO.ID))).mustNot((QueryBuilder)QueryBuilders.existsQuery((String)this.toName("user")));
        } else if (set instanceof User) {
            User user = (User)set;
            boolQueryBuilder = QueryBuilders.termQuery((String)this.fromName("user"), (Object)user.getId());
            termQueryBuilder = QueryBuilders.termQuery((String)this.toName("user"), (Object)user.getId());
        } else {
            queryAccessor.invalid();
            return;
        }
        if (transferDirection == TransferDirection.CREDIT) {
            queryAccessor.filter((QueryBuilder)termQueryBuilder);
        } else if (transferDirection == TransferDirection.DEBIT) {
            queryAccessor.filter((QueryBuilder)boolQueryBuilder);
        } else {
            queryAccessor.filter((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)boolQueryBuilder).should((QueryBuilder)termQueryBuilder));
        }
    }

    @Override
    protected void doApplyVisibility(SessionData sessionData, QueryAccessor queryAccessor, AbstractTransQuery abstractTransQuery) {
        User user;
        super.doApplyVisibility(sessionData, queryAccessor, abstractTransQuery);
        AbstractTransactionQuery abstractTransactionQuery = (AbstractTransactionQuery)abstractTransQuery;
        LocateAccountOwnerResult locateAccountOwnerResult = abstractTransactionQuery instanceof OwnedTransactionQuery ? this.accountHandler.locateOrCurrent((AccountOwner)((OwnedTransactionQuery)abstractTransactionQuery).getOwner(), true) : LocateAccountOwnerResult.empty();
        Set set = this.transactionServiceSecurity.getVisibleNatures(locateAccountOwnerResult.getInternalAccountOwner());
        queryAccessor.filter((QueryBuilder)QueryBuilders.termsQuery((String)"nature", (Collection)set));
        if (sessionData.isAdmin() && locateAccountOwnerResult.isEmpty()) {
            this.applyAdminOverviewRestrictedNatures(sessionData, queryAccessor, set);
        }
        if ((user = sessionData.getLoggedUser()) != null) {
            queryAccessor.filter((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.termQuery((String)this.fromName("user"), (Object)user.getId())).should((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termQuery((String)AUTHORIZATION_TYPE, (Object)TransactionAuthorizationType.OPERATOR))));
            if (user.isMember()) {
                queryAccessor.filter((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"nature", (Object[])new Object[]{TransactionNature.SCHEDULED_PAYMENT, TransactionNature.RECURRING_PAYMENT}))).should((QueryBuilder)QueryBuilders.termQuery((String)SHOW_TO_RECEIVER, (boolean)true)).should((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.existsQuery((String)this.toName("user")))).should((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termQuery((String)this.toName("user"), (Object)user.getId()))));
            }
        }
    }

    @Override
    protected void doFillSource(Trans trans, SourceAccessor sourceAccessor) {
        Object object;
        Object object2;
        Transaction transaction;
        super.doFillSource(trans, sourceAccessor);
        if (trans instanceof Transaction) {
            transaction = (Transaction)trans;
        } else if (trans instanceof Installment) {
            transaction = ((Installment)trans).getTransaction();
        } else {
            throw new IllegalStateException("Unknown transaction");
        }
        sourceAccessor.set("nature", (Object)transaction.getNature());
        if (transaction instanceof BasePayment) {
            object2 = (BasePayment)transaction;
            sourceAccessor.set((Property<?, ?>)TransactionVO.CREATION_TYPE, (Object)object2.getCreationType());
            sourceAccessor.set((Property<?, ?>)TransactionVO.AUTHORIZATION_STATUS, ObjectHelper.defaultValue((Object)object2.getAuthorizationStatus(), (Object)TransactionAuthorizationStatus.NA));
            sourceAccessor.set(AUTHORIZATION_LEVEL, (Object)object2.getNextAuthorizationLevel());
            sourceAccessor.set(AUTHORIZATION_TYPE, (Object)object2.getAuthorizationType());
            object = CollectionHelper.orEmpty((List)object2.getAuthorizations()).stream().map(transactionAuthorization -> SimpleEntity.id((SimpleEntity)transactionAuthorization.getBy())).filter(Objects::nonNull).collect(Collectors.toSet());
            sourceAccessor.set(AUTHORIZATION_PERFORMED_BY, object);
        } else {
            sourceAccessor.set((Property<?, ?>)TransactionVO.AUTHORIZATION_STATUS, (Object)TransactionAuthorizationStatus.NA);
        }
        if (transaction instanceof HasTransactionStatus) {
            sourceAccessor.set("status", (Object)((HasTransactionStatus)transaction).getStatus());
        }
        if (transaction instanceof HasExpirationDate) {
            sourceAccessor.set(EXPIRATION_DATE, (Object)((HasExpirationDate)transaction).getExpirationDate());
        }
        if (transaction instanceof HasShowToReceiver) {
            sourceAccessor.set(SHOW_TO_RECEIVER, (Object)((HasShowToReceiver)transaction).isShowToReceiver());
        } else {
            sourceAccessor.set(SHOW_TO_RECEIVER, (Object)true);
        }
        object2 = new SourceAccessor();
        if (transaction instanceof ScheduledPayment) {
            object = (ScheduledPayment)transaction;
            ((SourceAccessor)object2).set((Property<?, ?>)ScheduledPaymentResultVO.FIRST_INSTALLMENT, (Object)this.toInstallment((Installment)object.getFirstInstallment()));
            ((SourceAccessor)object2).set((Property<?, ?>)ScheduledPaymentResultVO.FIRST_OPEN_INSTALLMENT, (Object)this.toInstallment((Installment)object.getFirstScheduledInstallment()));
            ((SourceAccessor)object2).set((Property<?, ?>)ScheduledPaymentResultVO.INSTALLMENT_COUNT, (Object)object.getInstallmentCount());
            ((SourceAccessor)object2).set((Property<?, ?>)ScheduledPaymentResultVO.PROCESSED_INSTALLMENTS, (Object)object.getProcessedInstallments());
        } else if (transaction instanceof RecurringPayment) {
            object = (RecurringPayment)transaction;
            ((SourceAccessor)object2).set((Property<?, ?>)RecurringPaymentResultVO.LAST_OCCURRENCE_NUMBER, (Object)object.getLastOccurrenceNumber());
            ((SourceAccessor)object2).set((Property<?, ?>)RecurringPaymentResultVO.NEXT_OCCURRENCE_DATE, (Object)object.getNextOccurrenceDate());
            ((SourceAccessor)object2).set((Property<?, ?>)RecurringPaymentResultVO.OCCURRENCES_COUNT, (Object)object.getOccurrencesCount());
        } else if (transaction instanceof ExternalPayment) {
            object = (ExternalPayment)transaction;
            ((SourceAccessor)object2).set((Property<?, ?>)ExternalPaymentResultVO.TO_PRINCIPAL_TYPE, (Object)object.getToPrincipalType());
            ((SourceAccessor)object2).set((Property<?, ?>)ExternalPaymentResultVO.TO_PRINCIPAL_VALUE, (Object)object.getToPrincipalValue());
        }
        sourceAccessor.set(NATURE_SPECIFIC, object2);
    }

    protected SourceAccessor toInstallment(Installment installment) {
        if (installment == null) {
            return null;
        }
        SourceAccessor sourceAccessor = new SourceAccessor();
        sourceAccessor.set((Property<?, ?>)InstallmentVO.ID, (Object)installment.getId());
        this.setBasicUser(sourceAccessor, (Property<?, ?>)InstallmentVO.BY, installment.getBy());
        sourceAccessor.set((Property<?, ?>)InstallmentVO.AMOUNT, (Object)installment.getAmount());
        sourceAccessor.set((Property<?, ?>)InstallmentVO.DUE_DATE, (Object)installment.getDueDate());
        sourceAccessor.set((Property<?, ?>)InstallmentVO.NUMBER, (Object)installment.getNumber());
        sourceAccessor.set((Property<?, ?>)InstallmentVO.STATUS, (Object)installment.getStatus());
        sourceAccessor.set((Property<?, ?>)InstallmentVO.TRANSFER_ID, (Object)installment.getTransferId());
        sourceAccessor.set((Property<?, ?>)InstallmentVO.TRANSFER_TRANSACTION_NUMBER, (Object)installment.getTransferTransactionNumber());
        sourceAccessor.set((Property<?, ?>)InstallmentVO.TRANSFER_DATE, (Object)installment.getTransferDate());
        return sourceAccessor;
    }

    protected InstallmentVO toInstallmentVO(int n, VOFiller<BasicUserVO> vOFiller, SourceAccessor sourceAccessor) {
        if (sourceAccessor == null) {
            return null;
        }
        InstallmentVO installmentVO = new InstallmentVO();
        installmentVO.setId(sourceAccessor.getAsLong((Property<?, ?>)InstallmentVO.ID));
        installmentVO.setAmount(sourceAccessor.getAsBigDecimal((Property<?, ?>)InstallmentVO.AMOUNT, n));
        installmentVO.setBy(this.getBasicUser(vOFiller, sourceAccessor, (Property<?, ?>)InstallmentVO.BY));
        installmentVO.setDueDate(sourceAccessor.getAsDateTime((Property<?, ?>)InstallmentVO.DUE_DATE));
        installmentVO.setNumber(sourceAccessor.getAsInt((Property<?, ?>)InstallmentVO.NUMBER));
        installmentVO.setStatus(sourceAccessor.getAsEnum(InstallmentStatus.class, InstallmentVO.STATUS));
        installmentVO.setTransferId(sourceAccessor.getAsLong((Property<?, ?>)InstallmentVO.TRANSFER_ID));
        installmentVO.setTransferTransactionNumber(sourceAccessor.getAsString((Property<?, ?>)InstallmentVO.TRANSFER_TRANSACTION_NUMBER));
        installmentVO.setTransferDate(sourceAccessor.getAsDateTime((Property<?, ?>)InstallmentVO.TRANSFER_DATE));
        return installmentVO;
    }

    protected TransactionResultVO toTransactionResultVO(InternalAccountOwner internalAccountOwner, VOFiller<BasicUserVO> vOFiller, List<TransactionCustomField> list, SessionData sessionData, SearchHit searchHit) {
        Object object;
        Object object2;
        Object object3;
        SourceAccessor sourceAccessor = new SourceAccessor(searchHit);
        TransactionNature transactionNature = sourceAccessor.getAsEnum(TransactionNature.class, "nature");
        CurrencyVO currencyVO = sourceAccessor.getAsEntityVO(Currency.class, CurrencyVO.class, (Property<?, ?>)CurrencyAmountDTO.CURRENCY);
        TransactionResultVO transactionResultVO = (TransactionResultVO)ClassHelper.instantiate((Class)TransactionSearchHandler.resultType((TransactionNature)transactionNature));
        transactionResultVO.setId(Long.valueOf(Long.parseLong(searchHit.getId())));
        transactionResultVO.setNature(transactionNature);
        transactionResultVO.setCreationType(sourceAccessor.getAsEnum(PaymentCreationType.class, TransactionVO.CREATION_TYPE));
        transactionResultVO.setDisplay(sourceAccessor.getAsString((Property<?, ?>)TransVO.DISPLAY));
        transactionResultVO.setDate(sourceAccessor.getAsDateTime((Property<?, ?>)TransVO.DATE));
        transactionResultVO.setTransactionNumber(sourceAccessor.getAsString((Property<?, ?>)TransVO.TRANSACTION_NUMBER));
        transactionResultVO.setType(sourceAccessor.getAsEntityVO(TransferType.class, TransferTypeWithCurrencyVO.class, (Property<?, ?>)TransVO.TYPE));
        transactionResultVO.setAmount(sourceAccessor.getAsBigDecimal((Property<?, ?>)CurrencyAmountDTO.AMOUNT, currencyVO.getPrecision()));
        transactionResultVO.setDescription(sourceAccessor.getAsString((Property<?, ?>)TransactionResultVO.DESCRIPTION));
        TransactionAuthorizationStatus transactionAuthorizationStatus = sourceAccessor.getAsEnum(TransactionAuthorizationStatus.class, TransactionVO.AUTHORIZATION_STATUS);
        if (transactionAuthorizationStatus == TransactionAuthorizationStatus.NA) {
            transactionAuthorizationStatus = null;
        }
        transactionResultVO.setAuthorizationStatus(transactionAuthorizationStatus);
        SourceAccessor sourceAccessor2 = sourceAccessor.getAsSource((Property<?, ?>)TransVO.FROM);
        Long l = sourceAccessor2 == null ? null : sourceAccessor2.getAsLong("user");
        SourceAccessor sourceAccessor3 = sourceAccessor.getAsSource((Property<?, ?>)TransVO.TO);
        String string = sourceAccessor.getAsString((Property<?, ?>)TransactionResultVO.FROM_NAME);
        String string2 = sourceAccessor.getAsString((Property<?, ?>)TransactionResultVO.TO_NAME);
        if (internalAccountOwner == null) {
            transactionResultVO.setFrom(this.toAccountVO(vOFiller, sessionData, sourceAccessor2));
            transactionResultVO.setFromName(string);
            transactionResultVO.setTo(this.toAccountVO(vOFiller, sessionData, sourceAccessor3));
            transactionResultVO.setToName(string2);
            if (sessionData.isMember()) {
                object3 = sessionData.getLoggedUser().getId();
                object2 = sourceAccessor.getAsLong(this.userName((Property<?, ?>)TransactionResultVO.FROM_OPERATOR));
                object = sourceAccessor.getAsLong(this.userName((Property<?, ?>)TransactionResultVO.TO_OPERATOR));
                if (((Long)object3).equals(object2)) {
                    transactionResultVO.setFromOperator(this.getOperator(vOFiller, sourceAccessor, (Property<?, ?>)TransactionResultVO.FROM_OPERATOR));
                }
                if (((Long)object3).equals(object)) {
                    transactionResultVO.setToOperator(this.getOperator(vOFiller, sourceAccessor, (Property<?, ?>)TransactionResultVO.TO_OPERATOR));
                }
            }
        } else if (internalAccountOwner instanceof SystemAccountOwner && l == null || internalAccountOwner instanceof User && ((User)internalAccountOwner).getId().equals(l)) {
            transactionResultVO.setRelated(this.toAccountVO(vOFiller, sessionData, sourceAccessor3));
            transactionResultVO.setRelatedName(string2);
            transactionResultVO.setAmount(transactionResultVO.getAmount().negate());
        } else {
            transactionResultVO.setRelated(this.toAccountVO(vOFiller, sessionData, sourceAccessor2));
            transactionResultVO.setRelatedName(string);
        }
        transactionResultVO.setCustomValues(sourceAccessor.getAsCustomValueVOs(list));
        object3 = sourceAccessor.getAsString("status");
        object2 = sourceAccessor.getAsDateTime(EXPIRATION_DATE);
        object = sourceAccessor.getAsSource(NATURE_SPECIFIC);
        if (object == null) {
            object = new SourceAccessor();
        }
        if (transactionResultVO instanceof ScheduledPaymentResultVO) {
            ScheduledPaymentResultVO scheduledPaymentResultVO = (ScheduledPaymentResultVO)transactionResultVO;
            scheduledPaymentResultVO.setFirstInstallment(this.toInstallmentVO(currencyVO.getPrecision(), vOFiller, ((SourceAccessor)object).getAsSource((Property<?, ?>)ScheduledPaymentResultVO.FIRST_INSTALLMENT)));
            scheduledPaymentResultVO.setFirstOpenInstallment(this.toInstallmentVO(currencyVO.getPrecision(), vOFiller, ((SourceAccessor)object).getAsSource((Property<?, ?>)ScheduledPaymentResultVO.FIRST_OPEN_INSTALLMENT)));
            scheduledPaymentResultVO.setInstallmentCount(((SourceAccessor)object).getAsInt((Property<?, ?>)ScheduledPaymentResultVO.INSTALLMENT_COUNT));
            scheduledPaymentResultVO.setProcessedInstallments(((SourceAccessor)object).getAsInt((Property<?, ?>)ScheduledPaymentResultVO.PROCESSED_INSTALLMENTS));
            scheduledPaymentResultVO.setStatus((ScheduledPaymentStatus)CoercionHelper.coerce(ScheduledPaymentStatus.class, (Object)object3));
        } else if (transactionResultVO instanceof RecurringPaymentResultVO) {
            RecurringPaymentResultVO recurringPaymentResultVO = (RecurringPaymentResultVO)transactionResultVO;
            recurringPaymentResultVO.setLastOccurrenceNumber(((SourceAccessor)object).getAsInt((Property<?, ?>)RecurringPaymentResultVO.LAST_OCCURRENCE_NUMBER));
            recurringPaymentResultVO.setNextOccurrenceDate(((SourceAccessor)object).getAsDateTime((Property<?, ?>)RecurringPaymentResultVO.NEXT_OCCURRENCE_DATE));
            recurringPaymentResultVO.setOccurrencesCount(((SourceAccessor)object).getAsInteger((Property<?, ?>)RecurringPaymentResultVO.OCCURRENCES_COUNT));
            recurringPaymentResultVO.setStatus((RecurringPaymentStatus)CoercionHelper.coerce(RecurringPaymentStatus.class, (Object)object3));
        } else if (transactionResultVO instanceof PaymentRequestResultVO) {
            PaymentRequestResultVO paymentRequestResultVO = (PaymentRequestResultVO)transactionResultVO;
            paymentRequestResultVO.setExpirationDate(object2);
            paymentRequestResultVO.setStatus((PaymentRequestStatus)CoercionHelper.coerce(PaymentRequestStatus.class, (Object)object3));
        } else if (transactionResultVO instanceof TicketResultVO) {
            TicketResultVO ticketResultVO = (TicketResultVO)transactionResultVO;
            ticketResultVO.setExpirationDate(object2);
            ticketResultVO.setStatus((TicketStatus)CoercionHelper.coerce(TicketStatus.class, (Object)object3));
        } else if (transactionResultVO instanceof ExternalPaymentResultVO) {
            ExternalPaymentResultVO externalPaymentResultVO = (ExternalPaymentResultVO)transactionResultVO;
            externalPaymentResultVO.setExpirationDate(object2);
            externalPaymentResultVO.setStatus((ExternalPaymentStatus)CoercionHelper.coerce(ExternalPaymentStatus.class, (Object)object3));
            externalPaymentResultVO.setToPrincipalType(((SourceAccessor)object).getAsEntityVO(PrincipalType.class, PrincipalTypeVO.class, (Property<?, ?>)ExternalPaymentResultVO.TO_PRINCIPAL_TYPE));
            externalPaymentResultVO.setToPrincipalValue(((SourceAccessor)object).getAsString((Property<?, ?>)ExternalPaymentResultVO.TO_PRINCIPAL_VALUE));
        }
        return transactionResultVO;
    }

    private void applyAdminOverviewRestrictedNatures(SessionData sessionData, QueryAccessor queryAccessor, Set<TransactionNature> set) {
        AdminProductAccessor adminProductAccessor = sessionData.getProducts().admin();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.existsQuery((String)this.fromName((Property<?, ?>)AccountVO.ID))).must((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.existsQuery((String)this.fromName("user"))));
        ExistsQueryBuilder existsQueryBuilder = QueryBuilders.existsQuery((String)this.fromName("user"));
        BoolQueryBuilder boolQueryBuilder2 = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.existsQuery((String)this.toName((Property<?, ?>)AccountVO.ID))).must((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.existsQuery((String)this.toName("user"))));
        ExistsQueryBuilder existsQueryBuilder2 = QueryBuilders.existsQuery((String)this.toName("user"));
        if (set.contains(TransactionNature.SCHEDULED_PAYMENT) && !adminProductAccessor.hasPermission(Permission.SYSTEM_SCHEDULED_PAYMENTS_VIEW)) {
            queryAccessor.filter((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"nature", (Object[])new Object[]{TransactionNature.SCHEDULED_PAYMENT, TransactionNature.RECURRING_PAYMENT}))).should((QueryBuilder)existsQueryBuilder).should((QueryBuilder)existsQueryBuilder2));
        }
        if (set.contains(TransactionNature.SCHEDULED_PAYMENT) && !adminProductAccessor.hasPermission(Permission.USER_SCHEDULED_PAYMENTS_VIEW)) {
            queryAccessor.filter((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"nature", (Object[])new Object[]{TransactionNature.SCHEDULED_PAYMENT, TransactionNature.RECURRING_PAYMENT}))).should((QueryBuilder)boolQueryBuilder).should((QueryBuilder)boolQueryBuilder2));
        }
        if (set.contains(TransactionNature.PAYMENT_REQUEST) && !adminProductAccessor.hasPermission(Permission.USER_PAYMENT_REQUESTS_VIEW)) {
            queryAccessor.filter((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termQuery((String)"nature", (Object)TransactionNature.PAYMENT_REQUEST))).should((QueryBuilder)boolQueryBuilder).should((QueryBuilder)boolQueryBuilder2));
        }
        if (set.contains(TransactionNature.EXTERNAL_PAYMENT) && !adminProductAccessor.hasPermission(Permission.USER_EXTERNAL_PAYMENTS_VIEW)) {
            queryAccessor.filter((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termQuery((String)"nature", (Object)TransactionNature.EXTERNAL_PAYMENT))).should((QueryBuilder)boolQueryBuilder));
        }
        if (set.contains(TransactionNature.EXTERNAL_PAYMENT) && !adminProductAccessor.hasPermission(Permission.SYSTEM_EXTERNAL_PAYMENTS_VIEW)) {
            queryAccessor.filter((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termQuery((String)"nature", (Object)TransactionNature.EXTERNAL_PAYMENT))).should((QueryBuilder)existsQueryBuilder));
        }
    }

    private QueryBuilder authorized() {
        return QueryBuilders.termsQuery((String)TransactionVO.AUTHORIZATION_STATUS.getName(), (Object[])new Object[]{TransactionAuthorizationStatus.NA, TransactionAuthorizationStatus.AUTHORIZED});
    }
}

