/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.messaging;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import java.util.Collection;
import org.cyclos.entities.messaging.InboundSms;
import org.cyclos.entities.messaging.OutboundSms;
import org.cyclos.entities.messaging.QBaseSms;
import org.cyclos.entities.messaging.QInboundSms;
import org.cyclos.entities.messaging.QOutboundSms;
import org.cyclos.entities.users.QGroup;
import org.cyclos.entities.users.QOperator;
import org.cyclos.entities.users.QUser;
import org.cyclos.entities.utils.DatePeriod;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.messaging.SmsServiceLocal;
import org.cyclos.impl.utils.PhoneNumberHandler;
import org.cyclos.impl.utils.QueryHelper;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.ValidationException;
import org.cyclos.model.messaging.messages.InboundSmsMessageVO;
import org.cyclos.model.messaging.messages.InboundSmsQuery;
import org.cyclos.model.messaging.messages.OutboundSmsMessageVO;
import org.cyclos.model.messaging.messages.OutboundSmsQuery;
import org.cyclos.model.messaging.messages.SmsQuery;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.utils.Page;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SmsServiceImpl
extends BaseServiceImpl
implements SmsServiceLocal {
    @Autowired
    private PhoneNumberHandler phoneNumberHandler;

    public InboundSmsMessageVO getInboundMessageData(Long l) throws FrameworkException {
        InboundSms inboundSms = (InboundSms)this.entityManagerHandler.find(InboundSms.class, l);
        return (InboundSmsMessageVO)this.conversionHandler.convert(InboundSmsMessageVO.class, (Object)inboundSms);
    }

    public OutboundSmsMessageVO getOutboundMessageData(Long l) throws FrameworkException {
        OutboundSms outboundSms = (OutboundSms)this.entityManagerHandler.find(OutboundSms.class, l);
        return (OutboundSmsMessageVO)this.conversionHandler.convert(OutboundSmsMessageVO.class, (Object)outboundSms);
    }

    public Page<InboundSmsMessageVO> searchInboundMessages(InboundSmsQuery inboundSmsQuery) {
        QInboundSms qInboundSms = QInboundSms.inboundSms;
        DBQuery<?> dBQuery = this.from(new EntityPath[]{qInboundSms});
        this.filterSmsQuery((SmsQuery)inboundSmsQuery, qInboundSms._super, dBQuery);
        if (QueryHelper.useParameter((Object)inboundSmsQuery.getStatus())) {
            dBQuery.where((Predicate)qInboundSms.status.in((Collection)inboundSmsQuery.getStatus()));
        }
        return dBQuery.page(InboundSmsMessageVO.class, (QueryParameters)inboundSmsQuery, (Expression)qInboundSms);
    }

    public Page<OutboundSmsMessageVO> searchOutboundMessages(OutboundSmsQuery outboundSmsQuery) {
        QOutboundSms qOutboundSms = QOutboundSms.outboundSms;
        DBQuery<?> dBQuery = this.from(new EntityPath[]{qOutboundSms});
        this.filterSmsQuery((SmsQuery)outboundSmsQuery, qOutboundSms._super, dBQuery);
        if (QueryHelper.useParameter((Object)outboundSmsQuery.getStatus())) {
            dBQuery.where((Predicate)qOutboundSms.status.in((Collection)outboundSmsQuery.getStatus()));
        }
        return dBQuery.page(OutboundSmsMessageVO.class, (QueryParameters)outboundSmsQuery, (Expression)qOutboundSms);
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(QBaseSms.baseSms.network(), true);
    }

    private void filterSmsQuery(SmsQuery smsQuery, QBaseSms qBaseSms, DBQuery<?> dBQuery) {
        Object object;
        QGroup qGroup = QGroup.group;
        if (QueryHelper.useParameter((Object)smsQuery.getPeriod())) {
            object = (DatePeriod)this.conversionHandler.convert(DatePeriod.class, (Object)smsQuery.getPeriod());
            dBQuery.where(qBaseSms.date.period(object));
        }
        if (QueryHelper.useParameter((Object)smsQuery.getMobilePhone())) {
            object = this.phoneNumberHandler.parse(smsQuery.getMobilePhone(), this.getConfiguration());
            if (object == null) {
                throw new ValidationException(this.message(UsersKeys.Phones.INVALID_PHONE, new Object[0]));
            }
            dBQuery.where((Predicate)qBaseSms.phoneNumber.eq((Object)object.toE164()));
        }
        object = this.groupsHandler.all().groups().items();
        QUser qUser = QUser.user;
        QOperator qOperator = new QOperator("op");
        dBQuery.where((Predicate)qBaseSms.user().isNull().or((Predicate)((DBQuery)this.subQuery(new EntityPath[]{qGroup, qUser}).where(new Predicate[]{qUser.eq((Expression)qBaseSms.user()), qUser.group().eq((Expression)qGroup).and((Predicate)qGroup.in((Collection)object))})).exists()).or((Predicate)((DBQuery)this.subQuery(new EntityPath[]{qGroup, qOperator}).where(new Predicate[]{qOperator.eq((Expression)qBaseSms.user()), qOperator.user().group().eq((Expression)qGroup).and((Predicate)qGroup.in((Collection)object))})).exists()));
        dBQuery.orderBy(qBaseSms.date.desc());
    }
}

