/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.messaging;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.DateTimeExpression;
import org.cyclos.entities.messaging.QNotification;
import org.cyclos.impl.utils.tasks.SimpleRecurringTask;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.utils.RecurringTaskRecurrence;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.utils.MessageKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PurgeOldNotificationsRecurringTask
extends SimpleRecurringTask {
    @Autowired
    private CyclosProperties cyclosProperties;

    public MessageKey getMessageKey() {
        return SystemKeys.RecurringTasks.PURGE_OLD_NOTIFICATIONS;
    }

    @Override
    public RecurringTaskRecurrence getRecurrence() {
        return RecurringTaskRecurrence.EVERY_DAY;
    }

    @Override
    protected long execute() throws Throwable {
        int n = this.cyclosProperties.getPurgeNotificationsDays();
        if (n < 1) {
            return 0L;
        }
        QNotification qNotification = QNotification.notification;
        return this.delete((EntityPath<?>)qNotification).where(new Predicate[]{qNotification.date.addDays(Integer.valueOf(n)).lt((Expression)DateTimeExpression.currentTimestamp())}).execute();
    }
}

