/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.messaging;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.security.Key;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Hex;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.banking.AccountType;
import org.cyclos.entities.banking.AuthorizationRole;
import org.cyclos.entities.banking.QPaymentTransferType;
import org.cyclos.entities.banking.Trans;
import org.cyclos.entities.banking.UserAccountType;
import org.cyclos.entities.messaging.AdminNotificationSettings;
import org.cyclos.entities.messaging.BaseAccountNotificationSettings;
import org.cyclos.entities.messaging.IncomingMessage;
import org.cyclos.entities.messaging.Notification;
import org.cyclos.entities.messaging.NotificationSettings;
import org.cyclos.entities.messaging.NotificationTypeSettings;
import org.cyclos.entities.messaging.QAdminNotificationSettings;
import org.cyclos.entities.messaging.QAdminNotificationTypeSettings;
import org.cyclos.entities.messaging.QNotificationSettings;
import org.cyclos.entities.messaging.QUserNotificationSettings;
import org.cyclos.entities.messaging.QUserNotificationTypeSettings;
import org.cyclos.entities.messaging.UserAccountNotificationSettings;
import org.cyclos.entities.messaging.UserNotificationSettings;
import org.cyclos.entities.system.OutboundSmsConfiguration;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Operator;
import org.cyclos.entities.users.OperatorGroup;
import org.cyclos.entities.users.QAdminGroup;
import org.cyclos.entities.users.QAdminProduct;
import org.cyclos.entities.users.QAdminProductAuthorizationRole;
import org.cyclos.entities.users.QOperator;
import org.cyclos.entities.users.QOperatorGroup;
import org.cyclos.entities.users.QUser;
import org.cyclos.entities.users.QUserProductNotification;
import org.cyclos.entities.users.RoleContainer;
import org.cyclos.entities.users.User;
import org.cyclos.entities.utils.DecimalRange;
import org.cyclos.impl.ApplicationHandler;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.InitializationServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.banking.TransferTypeServiceLocal;
import org.cyclos.impl.banking.VoucherConfigurationServiceLocal;
import org.cyclos.impl.messaging.NotificationSettingsServiceLocal;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.ConfigurationImageServiceLocal;
import org.cyclos.impl.users.OperatorGroupServiceLocal;
import org.cyclos.impl.users.OperatorServiceLocal;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.impl.utils.BooleanProperties;
import org.cyclos.impl.utils.BooleanPropertiesHolder;
import org.cyclos.impl.utils.LinkGeneratorHandler;
import org.cyclos.impl.utils.PermissionHelper;
import org.cyclos.impl.utils.SerializablePredicate;
import org.cyclos.impl.utils.appnotifications.AppNotificationHandler;
import org.cyclos.impl.utils.cache.CacheHandler;
import org.cyclos.impl.utils.cache.CacheType;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.sms.OutboundSmsHandler;
import org.cyclos.impl.utils.validation.ValidationError;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.impl.utils.validation.validations.PropertyValidations;
import org.cyclos.impl.utils.validation.validations.RangeOptionalType;
import org.cyclos.impl.utils.validation.validations.ValidationErrors;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.Property;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.Role;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.accounttypes.AccountTypeVO;
import org.cyclos.model.banking.authorizationroles.AuthorizationRoleVO;
import org.cyclos.model.banking.transfertypes.TransferTypeNature;
import org.cyclos.model.banking.transfertypes.TransferTypeQuery;
import org.cyclos.model.banking.transfertypes.TransferTypeVO;
import org.cyclos.model.banking.voucherconfigurations.VoucherConfigurationVO;
import org.cyclos.model.messaging.MessagingKeys;
import org.cyclos.model.messaging.alerts.SystemAlertType;
import org.cyclos.model.messaging.alerts.UserAlertType;
import org.cyclos.model.messaging.messagecategories.MessageCategoryVO;
import org.cyclos.model.messaging.notifications.AccountNotificationCategory;
import org.cyclos.model.messaging.notifications.AccountNotificationType;
import org.cyclos.model.messaging.notifications.AdminNotificationType;
import org.cyclos.model.messaging.notifications.BrokeringNotificationType;
import org.cyclos.model.messaging.notifications.FeedbackAndReferenceNotificationType;
import org.cyclos.model.messaging.notifications.INotificationType;
import org.cyclos.model.messaging.notifications.MarketplaceBuyerNotificationType;
import org.cyclos.model.messaging.notifications.MarketplaceSellerNotificationType;
import org.cyclos.model.messaging.notifications.OperatorNotificationPropagation;
import org.cyclos.model.messaging.notifications.UserNotificationType;
import org.cyclos.model.messaging.notificationsettings.AccountNotificationSettingsDTO;
import org.cyclos.model.messaging.notificationsettings.AdminNotificationSettingsDTO;
import org.cyclos.model.messaging.notificationsettings.AdminNotificationSettingsData;
import org.cyclos.model.messaging.notificationsettings.EmailUnsubscribeData;
import org.cyclos.model.messaging.notificationsettings.EmailUnsubscribeType;
import org.cyclos.model.messaging.notificationsettings.NotificationSettingsDTO;
import org.cyclos.model.messaging.notificationsettings.NotificationSettingsData;
import org.cyclos.model.messaging.notificationsettings.NotificationTypeSettingsDTO;
import org.cyclos.model.messaging.notificationsettings.UserNotificationSettingsDTO;
import org.cyclos.model.messaging.notificationsettings.UserNotificationSettingsData;
import org.cyclos.model.system.configurations.ConfigurationImageType;
import org.cyclos.model.system.configurations.ConfigurationVO;
import org.cyclos.model.system.languages.BuiltinLanguage;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.bulkactions.BulkActionNature;
import org.cyclos.model.users.bulkactions.BulkActionUsage;
import org.cyclos.model.users.groups.GroupVO;
import org.cyclos.model.users.products.AccountAccessibility;
import org.cyclos.model.users.products.MyMessagesForwardOperation;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.ProfileField;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.Location;
import org.cyclos.model.utils.Range;
import org.cyclos.model.utils.TimeField;
import org.cyclos.server.utils.CloseableIteratorHelper;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.server.utils.JsonConverter;
import org.cyclos.server.utils.LocaleHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NotificationSettingsServiceImpl
extends BaseServiceImpl
implements NotificationSettingsServiceLocal {
    private static final QNotificationSettings $ = QNotificationSettings.notificationSettings;
    private static final QUserProductNotification upn = QUserProductNotification.userProductNotification;
    @Autowired
    private TransferTypeServiceLocal transferTypeService;
    @Autowired
    private VoucherConfigurationServiceLocal voucherConfigurationService;
    @Autowired
    private OutboundSmsHandler outboundSmsHandler;
    @Autowired
    private InvokerHandler invokerHandler;
    @Autowired
    private OperatorGroupServiceLocal operatorGroupService;
    @Autowired
    private AccountServiceLocal accountService;
    @Autowired
    private CacheHandler cacheHandler;
    @Autowired
    private ApplicationHandler applicationHandler;
    @Autowired
    private JsonConverter jsonConverter;
    @Autowired
    private InitializationServiceLocal initializationService;
    @Autowired
    private ConfigurationImageServiceLocal configurationImageService;
    @Autowired
    private LinkGeneratorHandler linkGeneratorHandler;
    @Autowired
    private AppNotificationHandler appNotificationHandler;

    public boolean allowMailing(User user, BulkActionNature bulkActionNature) {
        if (!user.isMember() || bulkActionNature.getUsage() != BulkActionUsage.MAILING_LIST) {
            return false;
        }
        UserNotificationSettings userNotificationSettings = (UserNotificationSettings)this.findNotificationSettings((BasicUser)user, false);
        if (userNotificationSettings == null) {
            return true;
        }
        switch (bulkActionNature) {
            case EMAIL_MAILING: {
                return userNotificationSettings.isEmailMailings();
            }
            case SMS_MAILING: {
                return userNotificationSettings.isSmsMailings();
            }
            case APP_MAILING: {
                return userNotificationSettings.isAppMailings();
            }
        }
        return false;
    }

    public void appendAccountSettingsValidations(BasicUser basicUser, org.cyclos.impl.utils.validation.Property property) {
        if (basicUser == null) {
            return;
        }
        List list = basicUser.isRestrictedOperator() ? null : this.productsHandler.getAccessor(basicUser).member().getUserAccounts();
        property.add((object, object2, object3) -> {
            if (basicUser.isRestrictedOperator()) {
                return ValidationErrors.invalid();
            }
            List list2 = (List)object3;
            for (AccountNotificationSettingsDTO accountNotificationSettingsDTO : list2) {
                UserAccountType userAccountType = (UserAccountType)this.conversionHandler.convert(UserAccountType.class, (Object)accountNotificationSettingsDTO.getAccountType());
                if (!list.contains(userAccountType)) {
                    return ValidationErrors.invalid();
                }
                ValidationError validationError = PropertyValidations.range((RangeOptionalType)RangeOptionalType.BOTH_OPTIONAL).validate((Object)accountNotificationSettingsDTO.getPaymentAmount(), (Object)AccountNotificationSettingsDTO.PAYMENT_AMOUNT, (Object)accountNotificationSettingsDTO.getPaymentAmount());
                if (validationError == null) continue;
                return validationError;
            }
            return null;
        });
    }

    public void emailUnsubscribe(String string) throws FrameworkException {
        EmailUnsubscribeFields emailUnsubscribeFields = this.emailUnsubscribeFields(string);
        this.invokerHandler.runAs(SessionDataFactory.system(), () -> {
            BasicUser basicUser = (BasicUser)this.conversionHandler.convert(BasicUser.class, (Object)emailUnsubscribeFields.getId());
            NotificationSettingsData notificationSettingsData = this.getData(new UserLocatorVO(basicUser.getId()));
            NotificationSettingsDTO notificationSettingsDTO = (NotificationSettingsDTO)notificationSettingsData.get((Property)UserNotificationSettingsData.NOTIFICATION_SETTINGS);
            switch (emailUnsubscribeFields.getType()) {
                case NOTIFICATION: {
                    notificationSettingsDTO.getNotificationTypeSettings().forEach(notificationTypeSettingsDTO -> notificationTypeSettingsDTO.setNotifyByEmail(Boolean.valueOf(false)));
                    break;
                }
                case MESSAGE: {
                    if (notificationSettingsDTO instanceof UserNotificationSettingsDTO) {
                        ((UserNotificationSettingsDTO)notificationSettingsDTO).setFwdMessageToEmail(false);
                        break;
                    }
                    if (!(notificationSettingsDTO instanceof AdminNotificationSettingsDTO)) break;
                    ((AdminNotificationSettingsDTO)notificationSettingsDTO).setFwdMessageCategoriesToEmail(new HashSet());
                    break;
                }
                case MAILING: {
                    if (!(notificationSettingsDTO instanceof UserNotificationSettingsDTO)) break;
                    ((UserNotificationSettingsDTO)notificationSettingsDTO).setEmailMailings(false);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unhandled email unsubscription type: " + String.valueOf(emailUnsubscribeFields.getType()));
                }
            }
            this.save(notificationSettingsDTO);
            return null;
        });
    }

    public NotificationSettings findNotificationSettings(BasicUser basicUser, boolean bl) {
        NotificationSettings notificationSettings = (NotificationSettings)((DBQuery)this.from(new EntityPath[]{$}).where((Predicate)$.user().eq((Object)basicUser))).singleResult((Expression)$);
        if (notificationSettings != null && bl) {
            this.entityManagerHandler.checkAccess((IEntity)notificationSettings);
        }
        return notificationSettings;
    }

    public <T> List<T> getAvailableOptionsFor(User user, AdminNotificationType adminNotificationType) {
        ProductsAccessor productsAccessor = this.productsHandler.getAccessor((BasicUser)user);
        if (!productsAccessor.product().hasPermission(Permission.MY_NOTIFICATIONS_ENABLE)) {
            return Collections.emptyList();
        }
        adminNotificationType = this.getTypeBasedOnSetting(adminNotificationType);
        HashSet<AuthorizationRole> hashSet = new HashSet<AuthorizationRole>();
        switch (adminNotificationType) {
            case APPLICATION_ERROR: 
            case NETWORK_CREATED: 
            case AD_PENDING_AUTHORIZATION: {
                break;
            }
            case PAYMENT_AWAITING_AUTHORIZATION: {
                for (Object object : productsAccessor.admin().getAuthorizationRoles().entries()) {
                    if (!((BooleanProperties)object.getValue()).isSet((Path)QAdminProductAuthorizationRole.adminProductAuthorizationRole.view)) continue;
                    hashSet.add((AuthorizationRole)object.getKey());
                }
                if (hashSet.isEmpty()) {
                    return Collections.emptyList();
                }
            }
            case PAYMENT_PERFORMED: 
            case EXTERNAL_PAYMENT_EXPIRED: 
            case EXTERNAL_PAYMENT_PERFORMED_FAILED: {
                Object object;
                ArrayList arrayList = new ArrayList();
                object = new ArrayList();
                object.addAll(productsAccessor.admin().getSystemAccounts());
                if (adminNotificationType != AdminNotificationType.EXTERNAL_PAYMENT_EXPIRED && adminNotificationType != AdminNotificationType.EXTERNAL_PAYMENT_PERFORMED_FAILED) {
                    object.addAll(productsAccessor.userManagement().getUserAccountsAccess());
                }
                if (object.isEmpty()) {
                    return Collections.emptyList();
                }
                boolean bl = adminNotificationType == AdminNotificationType.PAYMENT_AWAITING_AUTHORIZATION;
                boolean bl2 = adminNotificationType == AdminNotificationType.EXTERNAL_PAYMENT_EXPIRED || adminNotificationType == AdminNotificationType.EXTERNAL_PAYMENT_PERFORMED_FAILED;
                object.stream().collect(Collectors.groupingBy(AccountType::getCurrency)).values().forEach(list2 -> arrayList.addAll(this.addTransferTypes(bl, bl2, (Set<AuthorizationRole>)hashSet, (List<AccountType>)list2)));
                return arrayList;
            }
            case SYSTEM_ALERT: {
                return user.isGlobal() ? Arrays.asList(SystemAlertType.values()) : SystemAlertType.networkedTypes();
            }
            case USER_ALERT: {
                return Arrays.asList(UserAlertType.values());
            }
            case USER_REGISTRATION: 
            case USER_IMPORT_REGISTRATION: {
                return new ArrayList(this.groupsHandler.getAccessibleUserGroups(user));
            }
            case GENERATED_VOUCHERS_ABOUT_TO_EXPIRE: 
            case GENERATED_VOUCHERS_EXPIRED: 
            case VOUCHER_BUYING_ABOUT_TO_EXPIRE: {
                return this.voucherConfigurationService.listVisible(user, false, false);
            }
            default: {
                throw new IllegalArgumentException("Unsupported admin notification type");
            }
        }
        return null;
    }

    public NotificationSettingsData getData(UserLocatorVO userLocatorVO) throws FrameworkException {
        BasicUser basicUser = this.userLocatorHandler.toBasicUserOrCurrent((BasicUserVO)userLocatorVO);
        Object object = basicUser.isAdmin() ? this.getAdminNotificationSettingsData(basicUser.getUser()) : this.getUserNotificationSettingsData(basicUser);
        ProductsAccessor productsAccessor = this.productsHandler.getAccessor(basicUser);
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor(basicUser);
        OutboundSmsConfiguration outboundSmsConfiguration = configurationAccessor.getOutboundSmsConfiguration();
        boolean bl = this.profileFieldHandler.isEnabled(basicUser, (ProfileField)BasicProfileField.EMAIL);
        boolean bl2 = this.profileFieldHandler.isEnabled(basicUser, (ProfileField)BasicProfileField.PHONE) && outboundSmsConfiguration != null && outboundSmsConfiguration.isEnabled();
        object.setUser((BasicUserVO)this.conversionHandler.convert(BasicUserVO.class, (Object)basicUser));
        object.setRole(basicUser.getMainRole());
        object.setCurrentSmsCount(Integer.valueOf(this.outboundSmsHandler.getCurrentSmsCountForUser(basicUser.getUser())));
        object.setMaxSmsPerMonth(Integer.valueOf(productsAccessor.product().getMaxSmsPerMonth()));
        object.setEmailAllowed(object.isEmailAllowed() && bl);
        object.setSmsAllowed(object.isSmsAllowed() && bl2);
        if (basicUser.isMember()) {
            UserNotificationSettingsData userNotificationSettingsData = object;
            if (!basicUser.isOperator()) {
                userNotificationSettingsData.setEmailMailingsAllowed(bl);
                userNotificationSettingsData.setSmsMailingsAllowed(bl2);
                userNotificationSettingsData.setAppMailingsAllowed(this.appNotificationHandler.isEnabled(configurationAccessor));
            }
        }
        return object;
    }

    public EmailUnsubscribeData getEmailUnsubscribeData(String string) throws FrameworkException {
        EmailUnsubscribeFields emailUnsubscribeFields = this.emailUnsubscribeFields(string);
        return (EmailUnsubscribeData)this.invokerHandler.runAs(SessionDataFactory.system(), () -> {
            BasicUser basicUser = this.find(BasicUser.class, emailUnsubscribeFields.getId());
            EmailUnsubscribeData emailUnsubscribeData = new EmailUnsubscribeData();
            emailUnsubscribeData.setUser((BasicUserVO)this.conversionHandler.convert(BasicUserVO.class, (Object)basicUser));
            emailUnsubscribeData.setType(emailUnsubscribeFields.getType());
            emailUnsubscribeData.setEmail(basicUser.getEmail());
            ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor(basicUser);
            emailUnsubscribeData.setResourceCacheKey(this.initializationService.getResourceCacheKey());
            emailUnsubscribeData.setCountry(configurationAccessor.getCountry());
            BuiltinLanguage builtinLanguage = configurationAccessor.getLanguage().getTemplate();
            emailUnsubscribeData.setLocale(LocaleHelper.mapLocale((BuiltinLanguage)builtinLanguage).toString());
            emailUnsubscribeData.setApplicationName(configurationAccessor.getApplicationName());
            ConfigurationVO configurationVO = new ConfigurationVO(configurationAccessor.getConfiguration().getId());
            emailUnsubscribeData.setApplicationLogo(this.configurationImageService.getImageVO(configurationVO, ConfigurationImageType.PAY_LOGO));
            emailUnsubscribeData.setShortcutIcon(this.configurationImageService.getImageVO(configurationVO, ConfigurationImageType.SHORTCUT_ICON));
            emailUnsubscribeData.setRootUrl(this.linkGeneratorHandler.root(basicUser));
            emailUnsubscribeData.setNotificationSettingsUrl(this.linkGeneratorHandler.location(Location.NOTIFICATION_SETTING, basicUser));
            emailUnsubscribeData.setHomeUrl(this.linkGeneratorHandler.home(basicUser));
            return emailUnsubscribeData;
        });
    }

    public NotificationTypeSettingsDTO getNotificationTypeSettings(Notification notification) {
        NotificationTypeSettingsDTO notificationTypeSettingsDTO;
        BasicUser basicUser = notification.getUser();
        Object t = this.findNotificationTypePreference(basicUser, notification.getType());
        if (notification.getType() instanceof AdminNotificationType) {
            notificationTypeSettingsDTO = t == null ? this.createDefaultTypeSettingsDTO((AdminNotificationType)notification.getType()) : (NotificationTypeSettingsDTO)this.conversionHandler.convert(NotificationTypeSettingsDTO.class, t);
        } else {
            boolean bl;
            UserNotificationType userNotificationType = (UserNotificationType)notification.getType();
            BooleanProperties booleanProperties = this.productsHandler.getAccessor(basicUser).memberOrBroker().getNotifications().get((Object)userNotificationType);
            boolean bl2 = bl = booleanProperties.isSet((Path)NotificationSettingsServiceImpl.upn.enabled) && this.isAllowedNotificationType(basicUser, userNotificationType, null);
            if (!bl) {
                notificationTypeSettingsDTO = this.createDisabledTypeSettingsDTO((UserNotificationType)notification.getType());
            } else if (t == null) {
                notificationTypeSettingsDTO = this.createTypeSettingsDTO(notification.getType(), booleanProperties, basicUser.isRestrictedOperator());
            } else {
                notificationTypeSettingsDTO = (NotificationTypeSettingsDTO)this.conversionHandler.convert(NotificationTypeSettingsDTO.class, t);
                this.applySettingsFromProducts(booleanProperties, notificationTypeSettingsDTO);
            }
        }
        return notificationTypeSettingsDTO;
    }

    public AdminNotificationType getTypeBasedOnSetting(AdminNotificationType adminNotificationType) {
        switch (adminNotificationType) {
            case USER_IMPORT_REGISTRATION: {
                return AdminNotificationType.USER_REGISTRATION;
            }
            case GENERATED_VOUCHERS_ABOUT_TO_EXPIRE: {
                return AdminNotificationType.GENERATED_VOUCHERS_EXPIRED;
            }
        }
        return adminNotificationType;
    }

    public boolean isAllowedNotificationType(AdminNotificationType adminNotificationType, User user) {
        ProductsAccessor productsAccessor = this.productsHandler.getAccessor((BasicUser)user);
        if (!productsAccessor.product().hasPermission(Permission.MY_NOTIFICATIONS_ENABLE)) {
            return false;
        }
        adminNotificationType = this.getTypeBasedOnSetting(adminNotificationType);
        switch (adminNotificationType) {
            case APPLICATION_ERROR: {
                return productsAccessor.product().hasPermission(Permission.ERROR_LOG_VIEW);
            }
            case NETWORK_CREATED: {
                return productsAccessor.product().hasPermission(Permission.GLOBAL_CONFIGURATION_VIEW) || productsAccessor.product().hasPermission(Permission.NETWORKS_REGISTER);
            }
            case EXTERNAL_PAYMENT_EXPIRED: 
            case EXTERNAL_PAYMENT_PERFORMED_FAILED: {
                return productsAccessor.product().hasPermission(Permission.SYSTEM_EXTERNAL_PAYMENTS_VIEW);
            }
            case SYSTEM_ALERT: {
                return productsAccessor.product().hasPermission(Permission.SYSTEM_ALERTS_VIEW);
            }
            case USER_ALERT: {
                return productsAccessor.product().hasPermission(Permission.USER_ALERTS_VIEW);
            }
            case AD_PENDING_AUTHORIZATION: {
                return productsAccessor.product().hasPermission(Permission.USER_PENDING_ADS_VIEW) || productsAccessor.product().hasPermission(Permission.USER_PENDING_WEB_SHOP_VIEW);
            }
            case PAYMENT_AWAITING_AUTHORIZATION: 
            case PAYMENT_PERFORMED: 
            case USER_REGISTRATION: 
            case USER_IMPORT_REGISTRATION: {
                return CollectionHelper.isNotEmpty(this.getAvailableOptionsFor(user, adminNotificationType));
            }
            case GENERATED_VOUCHERS_ABOUT_TO_EXPIRE: 
            case GENERATED_VOUCHERS_EXPIRED: {
                return productsAccessor.product().hasPermission(Permission.VOUCHERS_VIEW);
            }
            case VOUCHER_BUYING_ABOUT_TO_EXPIRE: {
                return productsAccessor.product().hasPermission(Permission.VOUCHER_TYPES_VIEW);
            }
        }
        throw new IllegalArgumentException("Unknown admin notification type: " + String.valueOf(adminNotificationType));
    }

    public boolean isEnabled(UserNotificationType userNotificationType, BasicUser basicUser, SimpleEntity simpleEntity) {
        BooleanProperties booleanProperties = this.getAllowedNotification(basicUser, userNotificationType, simpleEntity);
        if (booleanProperties == null) {
            return false;
        }
        Object t = this.findNotificationTypePreference(basicUser, (INotificationType)userNotificationType);
        if (t == null) {
            return !basicUser.isRestrictedOperator();
        }
        return t.getNotifyByInternal();
    }

    public boolean isPaymentAmountInRange(BasicUser basicUser, UserAccountType userAccountType, BigDecimal bigDecimal) {
        UserNotificationSettings userNotificationSettings;
        if (basicUser.isAdmin()) {
            return false;
        }
        Set set = basicUser.isRestrictedOperator() ? ((Operator)basicUser).getGroup().getAccountNotificationSettings() : ((userNotificationSettings = (UserNotificationSettings)this.findNotificationSettings(basicUser, false)) == null ? null : userNotificationSettings.getAccountNotificationSettings());
        userNotificationSettings = CollectionHelper.orEmpty((Collection)set).stream().filter(baseAccountNotificationSettings -> baseAccountNotificationSettings.getAccountType().equals((Object)userAccountType)).findFirst().orElse(null);
        DecimalRange decimalRange = userNotificationSettings == null ? null : userNotificationSettings.getPaymentAmount();
        return Range.includes((Range)decimalRange, (Comparable)bigDecimal);
    }

    public String keyForEmailUnsubscribe(BasicUser basicUser, EmailUnsubscribeType emailUnsubscribeType) {
        String string;
        EmailUnsubscribeFields emailUnsubscribeFields = new EmailUnsubscribeFields();
        emailUnsubscribeFields.setId(basicUser == null ? null : basicUser.getId());
        emailUnsubscribeFields.setType(emailUnsubscribeType);
        emailUnsubscribeFields.setDate(new Date());
        try {
            string = this.jsonConverter.writeValueAsString((Object)emailUnsubscribeFields);
        }
        catch (JsonGenerationException | JsonMappingException throwable) {
            throw new IllegalArgumentException(throwable);
        }
        Long l = basicUser == null ? null : SimpleEntity.id((SimpleEntity)basicUser.getNetwork());
        byte[] byArray = l == null ? null : ByteBuffer.allocate(16).putLong(l).array();
        byte[] byArray2 = this.applicationHandler.encrypt(string, byArray);
        return Hex.encodeHexString((byte[])byArray2);
    }

    public UserNotificationSettingsDTO resolveUserNotificationSettingsDTO(BasicUser basicUser, BooleanPropertiesHolder<UserNotificationType> booleanPropertiesHolder, UserNotificationSettings userNotificationSettings) {
        Object object;
        Object object2;
        ArrayList<Object> arrayList;
        UserNotificationSettingsDTO userNotificationSettingsDTO;
        BooleanPropertiesHolder<UserNotificationType> booleanPropertiesHolder2;
        BooleanPropertiesHolder<UserNotificationType> booleanPropertiesHolder3 = booleanPropertiesHolder2 = booleanPropertiesHolder != null ? booleanPropertiesHolder : this.getEnabledUserNotificationTypes(basicUser);
        if (userNotificationSettings == null) {
            userNotificationSettingsDTO = new UserNotificationSettingsDTO();
            userNotificationSettingsDTO.setUser((BasicUserVO)this.conversionHandler.convert(BasicUserVO.class, (Object)basicUser));
            arrayList = new ArrayList<Object>();
            for (Object object3 : booleanPropertiesHolder2.entries()) {
                object2 = (UserNotificationType)object3.getKey();
                object = this.createTypeSettingsDTO((INotificationType)object2, (BooleanProperties)object3.getValue(), basicUser.isRestrictedOperator());
                arrayList.add(object);
            }
            userNotificationSettingsDTO.setNotificationTypeSettings(arrayList);
            userNotificationSettingsDTO.setFwdMessageToEmail(this.isForwardEnabledByDefault(this.productsHandler.getAccessor(basicUser)));
        } else {
            userNotificationSettingsDTO = (UserNotificationSettingsDTO)this.conversionHandler.convert(UserNotificationSettingsDTO.class, (Object)userNotificationSettings);
            this.applySettingsFromProducts(booleanPropertiesHolder2, userNotificationSettingsDTO.getNotificationTypeSettings(), basicUser.isRestrictedOperator());
            if (!this.isForwardEnabled(basicUser)) {
                userNotificationSettingsDTO.setFwdMessageToEmail(false);
            }
        }
        userNotificationSettingsDTO.getNotificationTypeSettings().sort(Comparator.comparing(NotificationTypeSettingsDTO::getType, INotificationType.COMPARATOR));
        arrayList = null;
        if (!basicUser.isRestrictedOperator()) {
            Object object3;
            List list = this.accountService.listVisibleTypes((InternalAccountOwner)basicUser);
            arrayList = new ArrayList(list.size());
            object3 = userNotificationSettings == null ? Collections.emptySet() : userNotificationSettings.getAccountNotificationSettings();
            object2 = object3.stream().collect(Collectors.toMap(BaseAccountNotificationSettings::getAccountType, userAccountNotificationSettings -> userAccountNotificationSettings));
            object = list.iterator();
            while (object.hasNext()) {
                AccountType accountType = (AccountType)object.next();
                UserAccountNotificationSettings userAccountNotificationSettings2 = (UserAccountNotificationSettings)object2.get(accountType);
                if (userAccountNotificationSettings2 == null) {
                    userAccountNotificationSettings2 = new UserAccountNotificationSettings();
                    userAccountNotificationSettings2.setAccountType((UserAccountType)accountType);
                }
                arrayList.add((AccountNotificationSettingsDTO)this.conversionHandler.convert(AccountNotificationSettingsDTO.class, (Object)userAccountNotificationSettings2));
            }
        }
        userNotificationSettingsDTO.setAccountNotificationSettings(arrayList);
        return userNotificationSettingsDTO;
    }

    public void save(NotificationSettingsDTO notificationSettingsDTO) {
        NotificationSettings notificationSettings;
        Object object;
        this.validate(notificationSettingsDTO);
        BasicUser basicUser = (BasicUser)this.conversionHandler.convert(BasicUser.class, (Object)notificationSettingsDTO.getUser());
        NotificationSettings notificationSettings2 = this.findNotificationSettings(basicUser);
        if (notificationSettingsDTO instanceof UserNotificationSettingsDTO && basicUser.isOperator()) {
            object = (UserNotificationSettingsDTO)notificationSettingsDTO;
            object.setEmailMailings(false);
            object.setSmsMailings(false);
        }
        if (notificationSettings2 != null) {
            notificationSettingsDTO.setId(notificationSettings2.getId());
            CollectionHelper.orEmpty((List)notificationSettingsDTO.getNotificationTypeSettings()).stream().forEach(notificationTypeSettingsDTO -> {
                Object t;
                if (notificationTypeSettingsDTO.getId() == null && (t = this.findNotificationTypePreference(basicUser, notificationTypeSettingsDTO.getType())) != null) {
                    notificationTypeSettingsDTO.setId(t.getId());
                    notificationTypeSettingsDTO.setVersion(t.getVersion());
                }
            });
            if (notificationSettingsDTO instanceof UserNotificationSettingsDTO) {
                CollectionHelper.orEmpty((List)((UserNotificationSettingsDTO)notificationSettingsDTO).getAccountNotificationSettings()).stream().forEach(accountNotificationSettingsDTO -> {
                    Set set;
                    UserAccountNotificationSettings userAccountNotificationSettings2;
                    if (accountNotificationSettingsDTO.getId() == null && (userAccountNotificationSettings2 = (UserAccountNotificationSettings)(set = CollectionHelper.orEmpty((Set)((UserNotificationSettings)notificationSettings2).getAccountNotificationSettings())).stream().filter(userAccountNotificationSettings -> userAccountNotificationSettings.getAccountType().equals(this.conversionHandler.convert(UserAccountType.class, (Object)accountNotificationSettingsDTO.getAccountType()))).findFirst().orElse(null)) != null) {
                        accountNotificationSettingsDTO.setId(userAccountNotificationSettings2.getId());
                        accountNotificationSettingsDTO.setVersion(userAccountNotificationSettings2.getVersion());
                    }
                });
            }
        }
        if ((notificationSettings = (NotificationSettings)this.conversionHandler.convert((Class)(object = basicUser.isAdmin() ? AdminNotificationSettings.class : UserNotificationSettings.class), (Object)notificationSettingsDTO)).isTransient()) {
            this.persist((IEntity)notificationSettings);
        }
        if (notificationSettings instanceof AdminNotificationSettings) {
            Long l = SimpleEntity.id((SimpleEntity)basicUser.getNetwork());
            this.cacheHandler.schedulePartialEvict(CacheType.ADMINS_TO_NOTIFY, (SerializablePredicate & Serializable)adminsToNotifyCacheKey -> adminsToNotifyCacheKey.matchesNetwork(l));
        }
    }

    public CloseableIterator<BasicUser> usersToForwardMessageIterator(IncomingMessage incomingMessage) {
        switch (incomingMessage.getMessageOwner()) {
            case SYSTEM: {
                QUser qUser = QUser.user;
                QAdminGroup qAdminGroup = QAdminGroup.adminGroup;
                QAdminProduct qAdminProduct = QAdminProduct.adminProduct;
                QAdminNotificationSettings qAdminNotificationSettings = QAdminNotificationSettings.adminNotificationSettings;
                return ((DBQuery)((DBQuery)((DBQuery)((DBQuery)this.from(new EntityPath[]{qAdminNotificationSettings}).join((EntityPath)qAdminNotificationSettings.user(), (Path)qUser._super)).join((EntityPath)qUser.group(), (Path)qAdminGroup._super)).join((EntityPath)qAdminGroup.adminProduct(), (Path)qAdminProduct)).where(new Predicate[]{qAdminProduct.viewMessagesSentToSysWithCat.contains((Object)incomingMessage.getCategory()), qAdminProduct.permissions.contains((Object)Permission.MY_NOTIFICATIONS_ENABLE), qUser.email.isNotNull(), qUser.email.isNotEmpty(), qAdminNotificationSettings.fwdMessageCategoriesToEmail.contains((Object)incomingMessage.getCategory())})).iterate((Expression)qUser._super);
            }
            case USER: {
                NotificationSettings notificationSettings;
                User user = incomingMessage.getOwner();
                CloseableIterator closeableIterator = CloseableIteratorHelper.empty();
                if (!this.isForwardEnabled((BasicUser)user)) {
                    return closeableIterator;
                }
                ProductsAccessor productsAccessor = this.productsHandler.getAccessor((BasicUser)user);
                if (StringHelper.isNotBlank((Object)user.getEmail())) {
                    boolean bl;
                    notificationSettings = this.findNotificationSettings((BasicUser)user);
                    boolean bl2 = notificationSettings == null ? this.isForwardEnabledByDefault(productsAccessor) : (bl = notificationSettings instanceof UserNotificationSettings && ((UserNotificationSettings)notificationSettings).isFwdMessageToEmail());
                    if (bl) {
                        closeableIterator = CloseableIteratorHelper.singleton((Object)user);
                    }
                }
                if (productsAccessor.member().hasPermission(Permission.MY_OPERATORS_ENABLE)) {
                    notificationSettings = QUserNotificationSettings.userNotificationSettings;
                    QOperator qOperator = OperatorServiceLocal.op;
                    QOperatorGroup qOperatorGroup = QOperatorGroup.operatorGroup;
                    CloseableIterator closeableIterator2 = ((DBQuery)((DBQuery)((DBQuery)this.from(new EntityPath[]{notificationSettings}).innerJoin((EntityPath)notificationSettings.user(), (Path)qOperator._super)).leftJoin((EntityPath)qOperator.group(), (Path)qOperatorGroup)).where(new Predicate[]{notificationSettings.fwdMessageToEmail.isTrue(), qOperatorGroup.isNull().or((Predicate)qOperatorGroup.messages.isTrue()), qOperator.user().eq((Object)user), qOperator.email.isNotNull(), qOperator.email.isNotEmpty()})).iterate((Expression)qOperator);
                    closeableIterator = CloseableIteratorHelper.chained((CloseableIterator[])new CloseableIterator[]{closeableIterator, closeableIterator2});
                }
                return closeableIterator;
            }
        }
        throw new IllegalArgumentException("Unsupported message owner: " + String.valueOf(incomingMessage.getMessageOwner()));
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register($.user().network());
    }

    private List<TransferTypeVO> addTransferTypes(boolean bl, boolean bl2, Set<AuthorizationRole> set, List<AccountType> list) {
        TransferTypeQuery transferTypeQuery = new TransferTypeQuery();
        transferTypeQuery.setNatures(Collections.singleton(TransferTypeNature.PAYMENT));
        transferTypeQuery.setUnlimited();
        if (bl) {
            transferTypeQuery.setFromAccountTypes(this.conversionHandler.convertSet(AccountTypeVO.class, list));
        } else {
            transferTypeQuery.setFromOrToAccountTypes(this.conversionHandler.convertSet(AccountTypeVO.class, list));
        }
        if (bl2) {
            QPaymentTransferType qPaymentTransferType = QPaymentTransferType.paymentTransferType;
            List list2 = ((DBQuery)this.entityManagerHandler.from(new EntityPath[]{qPaymentTransferType}).where((Predicate)qPaymentTransferType.myExternalPaymentTypesOnProducts.isNotEmpty().or((Predicate)qPaymentTransferType.externalPaymentsAsUserOnProducts.isNotEmpty()).or((Predicate)qPaymentTransferType.systemToUserExternalPaymentOnProducts.isNotEmpty()))).list((Expression)qPaymentTransferType.id);
            transferTypeQuery.setPossibleTransferTypes(list2.stream().map(TransferTypeVO::new).collect(Collectors.toSet()));
        } else if (bl) {
            transferTypeQuery.setRequiresAuthorization(Boolean.valueOf(true));
            transferTypeQuery.setAuthorizationRoles(this.conversionHandler.convertSet(AuthorizationRoleVO.class, set));
        }
        return this.transferTypeService.search(transferTypeQuery).getPageItems();
    }

    private void applySettingsFromProducts(AdminNotificationSettingsData adminNotificationSettingsData, AdminNotificationSettingsDTO adminNotificationSettingsDTO, User user) {
        if (CollectionHelper.isEmpty((Iterable)adminNotificationSettingsDTO.getNotificationTypeSettings())) {
            return;
        }
        ArrayList<AdminNotificationType> arrayList = new ArrayList<AdminNotificationType>(Arrays.asList(AdminNotificationType.values()));
        Iterator iterator = adminNotificationSettingsDTO.getNotificationTypeSettings().iterator();
        while (iterator.hasNext()) {
            NotificationTypeSettingsDTO notificationTypeSettingsDTO = (NotificationTypeSettingsDTO)iterator.next();
            AdminNotificationType adminNotificationType = (AdminNotificationType)notificationTypeSettingsDTO.getType();
            if (!this.isAllowedNotificationSettingForType(adminNotificationType, adminNotificationSettingsData, user)) {
                this.removeAdminNotificationValuesByType(adminNotificationSettingsDTO, adminNotificationType);
                iterator.remove();
            }
            arrayList.remove(notificationTypeSettingsDTO.getType());
        }
        if (CollectionHelper.isEmpty((Iterable)adminNotificationSettingsData.getMessageCategories())) {
            adminNotificationSettingsDTO.setFwdMessageCategoriesToEmail(Collections.emptySet());
        }
        for (AdminNotificationType adminNotificationType : arrayList) {
            if (!this.isAllowedNotificationSettingForType(adminNotificationType, adminNotificationSettingsData, user)) continue;
            adminNotificationSettingsDTO.getNotificationTypeSettings().add(this.createDefaultTypeSettingsDTO(adminNotificationType));
        }
    }

    private void applySettingsFromProducts(BooleanProperties booleanProperties, NotificationTypeSettingsDTO notificationTypeSettingsDTO) {
        if (!booleanProperties.isSet((Path)NotificationSettingsServiceImpl.upn.allowMail)) {
            notificationTypeSettingsDTO.setNotifyByEmail(null);
        } else if (notificationTypeSettingsDTO.getNotifyByEmail() == null) {
            notificationTypeSettingsDTO.setNotifyByEmail(Boolean.valueOf(booleanProperties.isSet((Path)NotificationSettingsServiceImpl.upn.defaultMail)));
        }
        if (!booleanProperties.isSet((Path)NotificationSettingsServiceImpl.upn.allowSms)) {
            notificationTypeSettingsDTO.setNotifyBySms(null);
        } else if (notificationTypeSettingsDTO.getNotifyBySms() == null) {
            notificationTypeSettingsDTO.setNotifyBySms(Boolean.valueOf(booleanProperties.isSet((Path)NotificationSettingsServiceImpl.upn.defaultSms)));
        }
        if (!booleanProperties.isSet((Path)NotificationSettingsServiceImpl.upn.allowApp)) {
            notificationTypeSettingsDTO.setNotifyByApp(null);
        } else if (notificationTypeSettingsDTO.getNotifyByApp() == null) {
            notificationTypeSettingsDTO.setNotifyByApp(Boolean.valueOf(booleanProperties.isSet((Path)NotificationSettingsServiceImpl.upn.defaultApp)));
        }
    }

    private void applySettingsFromProducts(BooleanPropertiesHolder<UserNotificationType> booleanPropertiesHolder, List<NotificationTypeSettingsDTO> list, boolean bl) {
        HashSet<UserNotificationType> hashSet = new HashSet<UserNotificationType>();
        Iterator<Object> iterator = list.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            UserNotificationType userNotificationType = (UserNotificationType)object.getType();
            if (booleanPropertiesHolder.containsKey((Object)userNotificationType)) {
                hashSet.add(userNotificationType);
                this.applySettingsFromProducts(booleanPropertiesHolder.get((Object)userNotificationType), (NotificationTypeSettingsDTO)object);
                continue;
            }
            iterator.remove();
        }
        for (Object object : booleanPropertiesHolder.entries()) {
            if (hashSet.contains(object.getKey())) continue;
            list.add(this.createTypeSettingsDTO((INotificationType)object.getKey(), (BooleanProperties)object.getValue(), bl));
        }
    }

    private boolean canReceiveNotification(OperatorGroup operatorGroup, UserNotificationType userNotificationType) {
        switch (userNotificationType.getRootType()) {
            case ACCOUNT: {
                return ((AccountNotificationType)userNotificationType).getPropagation().isPropagateToRestricted();
            }
            case BROKERING: {
                return operatorGroup.isBrokering();
            }
            case FEEDBACK_AND_REFERENCE: {
                return false;
            }
            case MARKETPLACE_BUYER: {
                return false;
            }
            case MARKETPLACE_SELLER: {
                return operatorGroup.isManageAdvertisements();
            }
            case PERSONAL: {
                return true;
            }
        }
        throw new IllegalStateException("Unhandled notification root type: " + String.valueOf(userNotificationType.getRootType()));
    }

    private boolean canReceiveNotification(SessionData sessionData, UserNotificationType userNotificationType, SimpleEntity simpleEntity) {
        ProductsAccessor productsAccessor = sessionData.getProducts();
        switch (userNotificationType.getRootType()) {
            case ACCOUNT: {
                AccountNotificationType accountNotificationType = (AccountNotificationType)userNotificationType;
                if (!AccountAccessibility.isAccessible((AccountAccessibility)productsAccessor.member().getAccountAccessibility())) {
                    return false;
                }
                switch (accountNotificationType.getCategory()) {
                    case ACCOUNT: {
                        return true;
                    }
                    case RECEIVED_TRANSACTION: 
                    case PERFORMED_TRANSACTION: {
                        if (simpleEntity instanceof Trans) {
                            AccountType accountType;
                            AccountType accountType2 = accountType = accountNotificationType.getCategory() == AccountNotificationCategory.RECEIVED_TRANSACTION ? ((Trans)simpleEntity).getToType() : ((Trans)simpleEntity).getFromType();
                            if (accountType instanceof UserAccountType) {
                                return AccountAccessibility.isAccessible((AccountAccessibility)productsAccessor.member((UserAccountType)accountType).getAccountAccessibility());
                            }
                            return false;
                        }
                        return true;
                    }
                    case VOUCHER: {
                        return sessionData.hasPermission(Permission.MY_VOUCHERS_VIEW_VOUCHERS) || sessionData.hasPermission(Permission.MY_VOUCHERS_BUY);
                    }
                    case TICKET: {
                        return sessionData.hasPermission(Permission.MY_PAYMENT_TICKETS_CREATE);
                    }
                    case OPERATOR_AUTHORIZED_PAYMENT: {
                        return this.operatorGroupService.anyRequiresAuthorization(sessionData.getLoggedUser());
                    }
                }
                throw new IllegalStateException("Unhandled account notification category: " + String.valueOf(accountNotificationType.getCategory()));
            }
            case BROKERING: {
                BrokeringNotificationType brokeringNotificationType = (BrokeringNotificationType)userNotificationType;
                switch (brokeringNotificationType) {
                    case MEMBER_ASSIGNED: 
                    case MEMBER_UNASSIGNED: {
                        return sessionData.isBroker();
                    }
                    case AD_PENDING_AUTHORIZATION: {
                        return productsAccessor.broker().hasPermission(Permission.USER_WEB_SHOP_MANAGE) || productsAccessor.broker().hasPermission(Permission.USER_ADS_MANAGE);
                    }
                }
                throw new IllegalStateException("Unhandled brokering notification: " + String.valueOf(brokeringNotificationType));
            }
            case FEEDBACK_AND_REFERENCE: {
                FeedbackAndReferenceNotificationType feedbackAndReferenceNotificationType = (FeedbackAndReferenceNotificationType)userNotificationType;
                switch (feedbackAndReferenceNotificationType) {
                    case FEEDBACK_REQUIRED: 
                    case FEEDBACK_OPTIONAL: 
                    case FEEDBACK_EXPIRATION_REMINDER: 
                    case FEEDBACK_REPLY_CREATED: {
                        return sessionData.hasPermission(Permission.MY_TRANSACTION_FEEDBACKS_GIVE);
                    }
                    case FEEDBACK_CREATED: 
                    case FEEDBACK_CHANGED: {
                        return sessionData.hasPermission(Permission.MY_TRANSACTION_FEEDBACKS_RECEIVE);
                    }
                    case REFERENCE_CHANGED: 
                    case REFERENCE_CREATED: {
                        return sessionData.hasPermission(Permission.MY_REFERENCES_RECEIVE);
                    }
                }
                break;
            }
            case MARKETPLACE_BUYER: {
                MarketplaceBuyerNotificationType marketplaceBuyerNotificationType = (MarketplaceBuyerNotificationType)userNotificationType;
                switch (marketplaceBuyerNotificationType) {
                    case AD_INTEREST_NOTIFICATION: 
                    case AD_QUESTION_ANSWERED: {
                        return sessionData.hasPermission(new Permission[]{Permission.USER_ADS_VIEW, Permission.USER_WEB_SHOP_VIEW});
                    }
                    case ORDER_CANCELED_BUYER: 
                    case ORDER_PAYMENT_CANCELED_BUYER: 
                    case ORDER_PAYMENT_DENIED_BUYER: 
                    case ORDER_PAYMENT_EXPIRED_BUYER: 
                    case ORDER_PENDING_AUTHORIZATION_BUYER: 
                    case ORDER_PENDING_BUYER: 
                    case ORDER_PENDING_DELIVERY_DATA_BUYER: 
                    case ORDER_REALIZED_SELLER: 
                    case ORDER_REJECTED_BY_SELLER: 
                    case SALE_PENDING_BUYER: 
                    case SALE_REJECTED_SELLER: {
                        return sessionData.hasPermission(Permission.USER_WEB_SHOP_PURCHASE);
                    }
                }
            }
            case MARKETPLACE_SELLER: {
                MarketplaceSellerNotificationType marketplaceSellerNotificationType = (MarketplaceSellerNotificationType)userNotificationType;
                switch (marketplaceSellerNotificationType) {
                    case AD_AUTHORIZED: 
                    case AD_EXPIRED: 
                    case AD_QUESTION_CREATED: 
                    case AD_REJECTED: {
                        return sessionData.hasPermission(new Permission[]{Permission.MY_WEB_SHOP_ENABLE, Permission.MY_ADS_ENABLE});
                    }
                    case ARTICLE_OUT_OF_STOCK: 
                    case LOW_STOCK_QUANTITY: 
                    case ORDER_CANCELED_SELLER: 
                    case ORDER_CREATED: 
                    case ORDER_PAYMENT_CANCELED_SELLER: 
                    case ORDER_PAYMENT_DENIED_SELLER: 
                    case ORDER_PAYMENT_EXPIRED_SELLER: 
                    case ORDER_PENDING_AUTHORIZATION_SELLER: 
                    case ORDER_PENDING_DELIVERY_DATA_SELLER: 
                    case ORDER_REALIZED_BUYER: 
                    case ORDER_REJECTED_BY_BUYER: 
                    case SALE_REALIZED_BUYER: {
                        return sessionData.hasPermission(Permission.MY_WEB_SHOP_ENABLE);
                    }
                }
            }
            case PERSONAL: {
                return true;
            }
        }
        throw new IllegalStateException("Unhandled root notification type: " + String.valueOf(userNotificationType.getRootType()));
    }

    private AdminNotificationSettingsDTO createDefaultAdminNotificationSettingsDTO(AdminNotificationSettingsData adminNotificationSettingsData, User user) {
        AdminNotificationSettingsDTO adminNotificationSettingsDTO = new AdminNotificationSettingsDTO();
        ArrayList<NotificationTypeSettingsDTO> arrayList = new ArrayList<NotificationTypeSettingsDTO>();
        for (AdminNotificationType adminNotificationType : AdminNotificationType.values()) {
            if (!this.isAllowedNotificationSettingForType(adminNotificationType, adminNotificationSettingsData, user)) continue;
            arrayList.add(this.createDefaultTypeSettingsDTO(adminNotificationType));
        }
        adminNotificationSettingsDTO.setNotificationTypeSettings(arrayList);
        adminNotificationSettingsDTO.setUser((BasicUserVO)this.conversionHandler.convert(UserVO.class, (Object)user));
        return adminNotificationSettingsDTO;
    }

    private NotificationTypeSettingsDTO createDefaultTypeSettingsDTO(AdminNotificationType adminNotificationType) {
        NotificationTypeSettingsDTO notificationTypeSettingsDTO = new NotificationTypeSettingsDTO();
        notificationTypeSettingsDTO.setType((INotificationType)adminNotificationType);
        notificationTypeSettingsDTO.setNotifyByInternal(Boolean.valueOf(false));
        notificationTypeSettingsDTO.setNotifyByEmail(Boolean.valueOf(false));
        notificationTypeSettingsDTO.setNotifyBySms(Boolean.valueOf(false));
        notificationTypeSettingsDTO.setNotifyByApp(Boolean.valueOf(false));
        return notificationTypeSettingsDTO;
    }

    private NotificationTypeSettingsDTO createDisabledTypeSettingsDTO(UserNotificationType userNotificationType) {
        NotificationTypeSettingsDTO notificationTypeSettingsDTO = new NotificationTypeSettingsDTO();
        notificationTypeSettingsDTO.setType((INotificationType)userNotificationType);
        notificationTypeSettingsDTO.setNotifyByInternal(null);
        notificationTypeSettingsDTO.setNotifyByEmail(null);
        notificationTypeSettingsDTO.setNotifyBySms(null);
        notificationTypeSettingsDTO.setNotifyByApp(null);
        return notificationTypeSettingsDTO;
    }

    private NotificationTypeSettingsDTO createTypeSettingsDTO(INotificationType iNotificationType, BooleanProperties booleanProperties, boolean bl) {
        NotificationTypeSettingsDTO notificationTypeSettingsDTO = new NotificationTypeSettingsDTO();
        notificationTypeSettingsDTO.setType(iNotificationType);
        notificationTypeSettingsDTO.setNotifyByInternal(Boolean.valueOf(!bl));
        notificationTypeSettingsDTO.setNotifyByApp(Boolean.valueOf(!bl));
        notificationTypeSettingsDTO.setNotifyByEmail(booleanProperties.isSet((Path)NotificationSettingsServiceImpl.upn.allowMail) ? Boolean.valueOf(!bl && booleanProperties.isSet((Path)NotificationSettingsServiceImpl.upn.defaultMail)) : null);
        notificationTypeSettingsDTO.setNotifyBySms(booleanProperties.isSet((Path)NotificationSettingsServiceImpl.upn.allowSms) ? Boolean.valueOf(!bl && booleanProperties.isSet((Path)NotificationSettingsServiceImpl.upn.defaultSms)) : null);
        notificationTypeSettingsDTO.setNotifyByApp(booleanProperties.isSet((Path)NotificationSettingsServiceImpl.upn.allowApp) ? Boolean.valueOf(!bl && booleanProperties.isSet((Path)NotificationSettingsServiceImpl.upn.defaultApp)) : null);
        return notificationTypeSettingsDTO;
    }

    private boolean doHasPermission(SessionData sessionData, UserNotificationType userNotificationType, SimpleEntity simpleEntity) {
        if (simpleEntity != null && simpleEntity.isPersistent() && userNotificationType != BrokeringNotificationType.MEMBER_UNASSIGNED && !this.entityManagerHandler.isAccessible((IEntity)simpleEntity)) {
            return false;
        }
        if (sessionData.isOperator()) {
            if (!this.canReceiveNotification(sessionData, userNotificationType, simpleEntity)) {
                return false;
            }
            OperatorGroup operatorGroup = sessionData.isRestrictedOperator() ? sessionData.getLoggedOperator().getGroup() : null;
            return operatorGroup == null ? true : this.canReceiveNotification(operatorGroup, userNotificationType);
        }
        return this.canReceiveNotification(sessionData, userNotificationType, simpleEntity);
    }

    private EmailUnsubscribeFields emailUnsubscribeFields(String string) {
        String string2;
        Object object;
        Long l = SimpleEntity.id((SimpleEntity)this.getSessionData().getNetwork());
        byte[] byArray = l == null ? null : ByteBuffer.allocate(16).putLong(l).array();
        try {
            object = Hex.decodeHex((String)string);
            string2 = this.applicationHandler.decrypt((byte[])object, byArray);
        }
        catch (Exception exception) {
            throw new EntityNotFoundException(Key.class, string);
        }
        try {
            object = (EmailUnsubscribeFields)this.jsonConverter.readValue(string2, EmailUnsubscribeFields.class);
        }
        catch (JsonParseException | JsonMappingException throwable) {
            throw new EntityNotFoundException(Key.class, string);
        }
        Date date = DateHelper.subtract((Date)new Date(), (TimeField)TimeField.MONTHS, (int)1);
        if (((EmailUnsubscribeFields)object).getDate() == null || ((EmailUnsubscribeFields)object).getDate().before(date)) {
            throw new EntityNotFoundException(Key.class, string);
        }
        return object;
    }

    private NotificationSettings findNotificationSettings(BasicUser basicUser) {
        return this.findNotificationSettings(basicUser, true);
    }

    private <T extends NotificationTypeSettings> T findNotificationTypePreference(BasicUser basicUser, INotificationType iNotificationType) {
        if (iNotificationType instanceof AdminNotificationType) {
            QAdminNotificationTypeSettings qAdminNotificationTypeSettings = QAdminNotificationTypeSettings.adminNotificationTypeSettings;
            return (T)((NotificationTypeSettings)((DBQuery)this.from(new EntityPath[]{qAdminNotificationTypeSettings}).where(new Predicate[]{qAdminNotificationTypeSettings.notificationSettings().user().eq((Object)basicUser), qAdminNotificationTypeSettings.type.eq((Object)this.getTypeBasedOnSetting((AdminNotificationType)iNotificationType))})).singleResult((Expression)qAdminNotificationTypeSettings));
        }
        QUserNotificationTypeSettings qUserNotificationTypeSettings = QUserNotificationTypeSettings.userNotificationTypeSettings;
        return (T)((NotificationTypeSettings)((DBQuery)this.from(new EntityPath[]{qUserNotificationTypeSettings}).where(new Predicate[]{qUserNotificationTypeSettings.notificationSettings().user().id.eq((Object)basicUser.getId()), qUserNotificationTypeSettings.type.eq((Object)((UserNotificationType)iNotificationType))})).singleResult((Expression)qUserNotificationTypeSettings));
    }

    private AdminNotificationSettingsData getAdminNotificationSettingsData(User user) {
        AdminNotificationSettingsDTO adminNotificationSettingsDTO;
        if (!user.isAdmin()) {
            throw new IllegalActionException();
        }
        AdminNotificationSettingsData adminNotificationSettingsData = new AdminNotificationSettingsData();
        adminNotificationSettingsData.setSmsAllowed(true);
        adminNotificationSettingsData.setEmailAllowed(true);
        adminNotificationSettingsData.setNewUsers(this.conversionHandler.convertList(GroupVO.class, this.getAvailableOptionsFor(user, AdminNotificationType.USER_REGISTRATION)));
        adminNotificationSettingsData.setMessageCategories(this.conversionHandler.convertList(MessageCategoryVO.class, (Iterable)this.productsHandler.getAccessor((BasicUser)user).admin().getViewMessagesSentToSysWithCat()));
        adminNotificationSettingsData.setPayments(this.getAvailableOptionsFor(user, AdminNotificationType.PAYMENT_PERFORMED));
        adminNotificationSettingsData.setExternalPayments(this.conversionHandler.convertList(TransferTypeVO.class, this.getAvailableOptionsFor(user, AdminNotificationType.EXTERNAL_PAYMENT_EXPIRED)));
        adminNotificationSettingsData.setNewPendingPayments(this.getAvailableOptionsFor(user, AdminNotificationType.PAYMENT_AWAITING_AUTHORIZATION));
        adminNotificationSettingsData.setSystemAlerts(this.getAvailableOptionsFor(user, AdminNotificationType.SYSTEM_ALERT));
        adminNotificationSettingsData.setUserAlerts(this.getAvailableOptionsFor(user, AdminNotificationType.USER_ALERT));
        adminNotificationSettingsData.setVoucherConfigurations(this.conversionHandler.convertList(VoucherConfigurationVO.class, this.getAvailableOptionsFor(user, AdminNotificationType.GENERATED_VOUCHERS_EXPIRED)));
        AdminNotificationSettings adminNotificationSettings = (AdminNotificationSettings)this.findNotificationSettings((BasicUser)user);
        if (adminNotificationSettings == null) {
            adminNotificationSettingsDTO = this.createDefaultAdminNotificationSettingsDTO(adminNotificationSettingsData, user);
        } else {
            adminNotificationSettingsDTO = (AdminNotificationSettingsDTO)this.conversionHandler.convert(AdminNotificationSettingsDTO.class, (Object)adminNotificationSettings);
            this.applySettingsFromProducts(adminNotificationSettingsData, adminNotificationSettingsDTO, user);
        }
        Collections.sort(adminNotificationSettingsDTO.getNotificationTypeSettings(), (notificationTypeSettingsDTO, notificationTypeSettingsDTO2) -> ((AdminNotificationType)notificationTypeSettingsDTO.getType()).ordinal() - ((AdminNotificationType)notificationTypeSettingsDTO2.getType()).ordinal());
        adminNotificationSettingsData.setNotificationSettings(adminNotificationSettingsDTO);
        return adminNotificationSettingsData;
    }

    private BooleanProperties getAllowedNotification(BasicUser basicUser, UserNotificationType userNotificationType, SimpleEntity simpleEntity) {
        BooleanProperties booleanProperties = this.productsHandler.getAccessor(basicUser).memberOrBroker().getNotifications().get((Object)userNotificationType);
        if (!booleanProperties.isSet((Path)NotificationSettingsServiceImpl.upn.enabled)) {
            return null;
        }
        return this.isAllowedNotificationType(basicUser, userNotificationType, simpleEntity) ? booleanProperties : null;
    }

    private BooleanPropertiesHolder<UserNotificationType> getEnabledUserNotificationTypes(BasicUser basicUser) {
        BooleanPropertiesHolder booleanPropertiesHolder = this.productsHandler.getAccessor(basicUser).memberOrBroker().getNotifications();
        booleanPropertiesHolder.entries().removeIf(entry -> !((BooleanProperties)entry.getValue()).isSet((Path)NotificationSettingsServiceImpl.upn.enabled) || !this.isValidForUser((UserNotificationType)entry.getKey(), basicUser));
        return booleanPropertiesHolder;
    }

    private UserNotificationSettingsData getUserNotificationSettingsData(BasicUser basicUser) {
        if (basicUser.isAdmin()) {
            throw new IllegalActionException();
        }
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor(basicUser);
        BooleanPropertiesHolder<UserNotificationType> booleanPropertiesHolder = this.getEnabledUserNotificationTypes(basicUser);
        boolean bl = booleanPropertiesHolder.isAnyKeySet((Path)NotificationSettingsServiceImpl.upn.allowMail);
        OutboundSmsConfiguration outboundSmsConfiguration = configurationAccessor.getOutboundSmsConfiguration();
        boolean bl2 = outboundSmsConfiguration != null && outboundSmsConfiguration.isEnabled() && booleanPropertiesHolder.isAnyKeySet((Path)NotificationSettingsServiceImpl.upn.allowSms);
        boolean bl3 = this.appNotificationHandler.isEnabled(configurationAccessor) && booleanPropertiesHolder.isAnyKeySet((Path)NotificationSettingsServiceImpl.upn.allowApp);
        UserNotificationSettingsData userNotificationSettingsData = new UserNotificationSettingsData();
        userNotificationSettingsData.setEmailAllowed(bl);
        userNotificationSettingsData.setSmsAllowed(bl2);
        userNotificationSettingsData.setAppAllowed(bl3);
        userNotificationSettingsData.setForwardAllowed(this.isForwardEnabled(basicUser));
        UserNotificationSettings userNotificationSettings = (UserNotificationSettings)this.findNotificationSettings(basicUser);
        userNotificationSettingsData.setNotificationSettings(this.resolveUserNotificationSettingsDTO(basicUser, booleanPropertiesHolder, userNotificationSettings));
        return userNotificationSettingsData;
    }

    private boolean isAllowedNotificationSettingForType(AdminNotificationType adminNotificationType, AdminNotificationSettingsData adminNotificationSettingsData, User user) {
        switch (adminNotificationType) {
            case APPLICATION_ERROR: 
            case NETWORK_CREATED: 
            case AD_PENDING_AUTHORIZATION: 
            case SYSTEM_ALERT: 
            case USER_ALERT: {
                return this.isAllowedNotificationType(adminNotificationType, user);
            }
            case PAYMENT_PERFORMED: {
                return CollectionHelper.isNotEmpty((Iterable)adminNotificationSettingsData.getPayments());
            }
            case EXTERNAL_PAYMENT_EXPIRED: 
            case EXTERNAL_PAYMENT_PERFORMED_FAILED: {
                return CollectionHelper.isNotEmpty((Iterable)adminNotificationSettingsData.getExternalPayments());
            }
            case PAYMENT_AWAITING_AUTHORIZATION: {
                return CollectionHelper.isNotEmpty((Iterable)adminNotificationSettingsData.getNewPendingPayments());
            }
            case USER_REGISTRATION: {
                return CollectionHelper.isNotEmpty((Iterable)adminNotificationSettingsData.getNewUsers());
            }
            case USER_IMPORT_REGISTRATION: {
                return false;
            }
            case GENERATED_VOUCHERS_ABOUT_TO_EXPIRE: {
                return false;
            }
            case GENERATED_VOUCHERS_EXPIRED: 
            case VOUCHER_BUYING_ABOUT_TO_EXPIRE: {
                return CollectionHelper.isNotEmpty((Iterable)adminNotificationSettingsData.getVoucherConfigurations());
            }
        }
        throw new IllegalArgumentException("Unknown admin notification type: " + String.valueOf(adminNotificationType));
    }

    private boolean isAllowedNotificationType(BasicUser basicUser, UserNotificationType userNotificationType, SimpleEntity simpleEntity) {
        if (!this.isValidForUser(userNotificationType, basicUser)) {
            return false;
        }
        SessionData sessionData = this.getSessionData();
        if (basicUser.equals((Object)sessionData.getLoggedBasicUser())) {
            return this.doHasPermission(sessionData, userNotificationType, simpleEntity);
        }
        return (Boolean)this.invokerHandler.runAs(SessionDataFactory.user((BasicUser)basicUser), () -> this.doHasPermission(this.getSessionData(), userNotificationType, simpleEntity));
    }

    private boolean isForwardEnabled(BasicUser basicUser) {
        ProductsAccessor productsAccessor = this.productsHandler.getAccessor(basicUser);
        if (!productsAccessor.product().hasPermission(Permission.MY_MESSAGES_VIEW)) {
            return false;
        }
        MyMessagesForwardOperation myMessagesForwardOperation = productsAccessor.member().getFwdMessageToEmail();
        return myMessagesForwardOperation != null && myMessagesForwardOperation != MyMessagesForwardOperation.DISABLED;
    }

    private boolean isForwardEnabledByDefault(ProductsAccessor productsAccessor) {
        return MyMessagesForwardOperation.ENABLED_AND_DEFAULT == productsAccessor.member().getFwdMessageToEmail();
    }

    private boolean isValidForUser(UserNotificationType userNotificationType, BasicUser basicUser) {
        if (basicUser.isRestrictedOperator() && userNotificationType.getPropagation() == OperatorNotificationPropagation.OWNER_ONLY) {
            return false;
        }
        return PermissionHelper.hasRole((RoleContainer)basicUser, (Role)userNotificationType.getRole());
    }

    private void removeAdminNotificationValuesByType(AdminNotificationSettingsDTO adminNotificationSettingsDTO, AdminNotificationType adminNotificationType) {
        switch (adminNotificationType) {
            case PAYMENT_PERFORMED: {
                adminNotificationSettingsDTO.setPayments(Collections.emptySet());
                break;
            }
            case EXTERNAL_PAYMENT_EXPIRED: {
                adminNotificationSettingsDTO.setExternalPaymentsExpired(Collections.emptySet());
                break;
            }
            case EXTERNAL_PAYMENT_PERFORMED_FAILED: {
                adminNotificationSettingsDTO.setExternalPaymentsFailed(Collections.emptySet());
                break;
            }
            case PAYMENT_AWAITING_AUTHORIZATION: {
                adminNotificationSettingsDTO.setAuthorizablePayments(Collections.emptySet());
                break;
            }
            case SYSTEM_ALERT: {
                adminNotificationSettingsDTO.setSystemAlerts(Collections.emptySet());
                break;
            }
            case USER_ALERT: {
                adminNotificationSettingsDTO.setUserAlerts(Collections.emptySet());
                break;
            }
            case USER_REGISTRATION: {
                adminNotificationSettingsDTO.setUserGroups(Collections.emptySet());
                break;
            }
            case GENERATED_VOUCHERS_ABOUT_TO_EXPIRE: 
            case GENERATED_VOUCHERS_EXPIRED: 
            case VOUCHER_BUYING_ABOUT_TO_EXPIRE: {
                adminNotificationSettingsDTO.setVoucherConfigurations(Collections.emptySet());
            }
        }
    }

    private void validate(NotificationSettingsDTO notificationSettingsDTO) {
        UserNotificationSettingsDTO userNotificationSettingsDTO;
        BasicUser basicUser;
        Validator validator = new Validator();
        validator.property((Property)UserNotificationSettingsDTO.USER, UsersKeys.Users.USER).required();
        if (notificationSettingsDTO instanceof UserNotificationSettingsDTO && (basicUser = (BasicUser)this.conversionHandler.convert(BasicUser.class, (Object)(userNotificationSettingsDTO = (UserNotificationSettingsDTO)notificationSettingsDTO).getUser())) != null && CollectionHelper.isNotEmpty((Iterable)userNotificationSettingsDTO.getAccountNotificationSettings())) {
            org.cyclos.impl.utils.validation.Property property = validator.property((Property)UserNotificationSettingsDTO.ACCOUNT_NOTIFICATION_SETTINGS, MessagingKeys.NotificationSettings.ACCOUNT_SETTINGS_PAYMENT_AMOUNT);
            this.appendAccountSettingsValidations(basicUser, property);
        }
        this.validate(validator, notificationSettingsDTO, "notificationSettingsDTO");
    }

    public static class EmailUnsubscribeFields {
        private Long id;
        private Date date;
        private EmailUnsubscribeType type;

        public Date getDate() {
            return this.date;
        }

        public Long getId() {
            return this.id;
        }

        public EmailUnsubscribeType getType() {
            return this.type;
        }

        public void setDate(Date date) {
            this.date = date;
        }

        public void setId(Long l) {
            this.id = l;
        }

        public void setType(EmailUnsubscribeType emailUnsubscribeType) {
            this.type = emailUnsubscribeType;
        }
    }
}

