/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.messaging;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import org.cyclos.entities.QDatabaseHistoryLog;
import org.cyclos.entities.access.Channel;
import org.cyclos.entities.messaging.ErrorLog;
import org.cyclos.entities.messaging.QErrorLog;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.AdminGroup;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.User;
import org.cyclos.entities.utils.DatePeriod;
import org.cyclos.impl.ApplicationUpgradeInitializationListener;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.messaging.ErrorLogServiceLocal;
import org.cyclos.impl.system.NetworkServiceLocal;
import org.cyclos.impl.utils.QueryHelper;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.messaging.ErrorLogType;
import org.cyclos.model.messaging.errorlogs.ErrorLogDetailedVO;
import org.cyclos.model.messaging.errorlogs.ErrorLogQuery;
import org.cyclos.model.messaging.errorlogs.ErrorLogSearchData;
import org.cyclos.model.messaging.errorlogs.ErrorLogVO;
import org.cyclos.model.utils.DatePeriodDTO;
import org.cyclos.utils.Page;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ErrorLogServiceImpl
extends BaseServiceImpl
implements ErrorLogServiceLocal,
ApplicationUpgradeInitializationListener {
    private static String DATABASE_UPGRADE_VERSION = "DATABASE UPGRADE v";
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    private NetworkServiceLocal networkService;

    public Integer countErrors(Date date) {
        ErrorLogQuery errorLogQuery = new ErrorLogQuery();
        DatePeriodDTO datePeriodDTO = new DatePeriodDTO();
        datePeriodDTO.setBegin(this.toDateTime(date));
        errorLogQuery.setDate(datePeriodDTO);
        errorLogQuery.setRemoved(Boolean.valueOf(false));
        errorLogQuery.setCountOnly();
        return this.search(errorLogQuery).getTotalCount();
    }

    public Long create(ErrorLogType errorLogType, String string, String string2) {
        return this.doCreate(errorLogType, string, null, string2, null, null, null);
    }

    public Long create(String string, String string2, String string3, Channel channel, BasicUser basicUser) {
        return this.doCreate(ErrorLogType.SERVICE, string, string2, string3, channel, basicUser, this.getRemoteAddress());
    }

    public long deleteOldErrorLogs() {
        QErrorLog qErrorLog = QErrorLog.errorLog;
        Integer n = this.configurationHandler.getGlobalDefault().getMaxLogEntries();
        if (n == null || n == 0) {
            return 0L;
        }
        Date date = (Date)((DBQuery)((DBQuery)((DBQuery)this.from(new EntityPath[]{qErrorLog}).orderBy(qErrorLog.date.desc())).limit((long)n.intValue())).offset((long)(n - 1))).singleResult((Expression)qErrorLog.date);
        if (date == null) {
            return 0L;
        }
        return this.entityManagerHandler.delete((EntityPath)qErrorLog).where(new Predicate[]{qErrorLog.date.lt((Comparable)date)}).execute();
    }

    public ErrorLogSearchData getSearchData() throws FrameworkException {
        ErrorLogSearchData errorLogSearchData = new ErrorLogSearchData();
        errorLogSearchData.setNetworks(this.networkService.getManagedNetworks());
        ErrorLogQuery errorLogQuery = (ErrorLogQuery)QueryHelper.newQuery(ErrorLogQuery.class);
        errorLogSearchData.setQuery((QueryParameters)errorLogQuery);
        return errorLogSearchData;
    }

    public ErrorLogDetailedVO load(Long l) throws EntityNotFoundException {
        ErrorLog errorLog = (ErrorLog)this.rawEntityManagerHandler.find(ErrorLog.class, l);
        return (ErrorLogDetailedVO)this.conversionHandler.convert(ErrorLogDetailedVO.class, (Object)errorLog);
    }

    public void onApplicationUpgradeInitialization() {
        QDatabaseHistoryLog qDatabaseHistoryLog = QDatabaseHistoryLog.databaseHistoryLog;
        this.processBatch(((DBQuery)this.from(new EntityPath[]{qDatabaseHistoryLog}).where((Predicate)qDatabaseHistoryLog.error.isNotNull().and((Predicate)qDatabaseHistoryLog.logGenerated.isNull().or((Predicate)qDatabaseHistoryLog.logGenerated.isFalse())))).iterate((Expression)qDatabaseHistoryLog), (T databaseHistoryLog) -> {
            this.create(DATABASE_UPGRADE_VERSION + databaseHistoryLog.getDatabaseVersion(), null, databaseHistoryLog.getError(), null, null);
            databaseHistoryLog.setLogGenerated(true);
        });
    }

    public void remove(Long l) {
        ErrorLog errorLog = this.find(ErrorLog.class, l);
        errorLog.setRemoved(true);
    }

    public void removeAll(Set<Long> set) {
        for (Long l : set) {
            this.remove(l);
        }
    }

    public Page<ErrorLogVO> search(ErrorLogQuery errorLogQuery) {
        DBQuery dBQuery;
        QErrorLog qErrorLog = QErrorLog.errorLog;
        SessionData sessionData = this.getSessionData();
        if (sessionData.getNetwork() != null) {
            dBQuery = this.from(new EntityPath[]{qErrorLog});
        } else {
            dBQuery = this.rawEntityManagerHandler.from(new EntityPath[]{qErrorLog});
            if (sessionData.isMultiNetworkAdminInGlobalMode()) {
                dBQuery.where((Predicate)qErrorLog.network().in((Collection)((AdminGroup)this.getLoggedUser().getGroup()).getManagedNetworks()));
            }
            if (QueryHelper.useParameter((Object)errorLogQuery.getNetwork())) {
                dBQuery.where((Predicate)qErrorLog.network().eq((Object)((Network)this.conversionHandler.convert(Network.class, (Object)errorLogQuery.getNetwork()))));
            }
            if (Boolean.TRUE.equals(errorLogQuery.getOnlyGlobal()) && sessionData.isGlobalAdmin()) {
                dBQuery.where((Predicate)qErrorLog.network().isNull());
            }
        }
        if (QueryHelper.useParameter((Object)errorLogQuery.getLoggedUser())) {
            dBQuery.where((Predicate)qErrorLog.loggedUser().eq((Object)((BasicUser)this.conversionHandler.convert(User.class, (Object)errorLogQuery.getLoggedUser()))));
        }
        if (QueryHelper.useParameter((Object)errorLogQuery.getDate())) {
            dBQuery.where(qErrorLog.date.period((DatePeriod)this.conversionHandler.convert(DatePeriod.class, (Object)errorLogQuery.getDate())));
        }
        if (QueryHelper.useParameter((Object)errorLogQuery.getRemoved())) {
            dBQuery.where((Predicate)qErrorLog.removed.eq(errorLogQuery.getRemoved()));
        }
        if (QueryHelper.useParameter((Object)errorLogQuery.getRemoteAddress())) {
            dBQuery.where((Predicate)qErrorLog.remoteAddress.eq((Object)errorLogQuery.getRemoteAddress()));
        }
        if (QueryHelper.useParameter((Object)errorLogQuery.getCustomBackgroundTask())) {
            dBQuery.where(new Predicate[]{qErrorLog.method.eq((Object)errorLogQuery.getCustomBackgroundTask().getId().toString()), qErrorLog.type.eq((Object)ErrorLogType.BACKGROUND_TASK)});
        }
        dBQuery.orderBy(qErrorLog.date.desc());
        return dBQuery.page(ErrorLogVO.class, (QueryParameters)errorLogQuery, (Expression)qErrorLog);
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(QErrorLog.errorLog.network());
    }

    private Long doCreate(ErrorLogType errorLogType, String string, String string2, String string3, Channel channel, BasicUser basicUser, String string4) {
        ErrorLog errorLog = new ErrorLog();
        errorLog.setDate(new Date());
        errorLog.setLoggedUser(basicUser);
        errorLog.setChannel(channel);
        errorLog.setStackTrace(string3);
        errorLog.setMethod(string);
        errorLog.setParameters(string2);
        errorLog.setRemoteAddress(string4);
        errorLog.setType(errorLogType);
        this.persist((IEntity)errorLog);
        this.notificationHandler.admin().applicationError(errorLog);
        return errorLog.getId();
    }
}

