/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.messaging;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.system.ProfilingEntry;
import org.cyclos.impl.utils.notifications.EntityNotificationProcessingHandler;
import org.cyclos.impl.utils.notifications.NotificationHandler;
import org.cyclos.impl.utils.notifications.NotificationProcessingEntityType;
import org.cyclos.impl.utils.tasks.AbstractBackgroundTask;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EntityNotificationProcessingBackgroundTask
extends AbstractBackgroundTask {
    @Autowired
    private NotificationHandler notificationHandler;

    public MessageKey getMessageKey() {
        return SystemKeys.BackgroundTasks.DISPATCH_ENTITY_NOTIFICATION;
    }

    @Override
    protected long doExecute(String string, ProfilingEntry profilingEntry) {
        String[] stringArray = StringUtils.split((String)string, (String)"|");
        NotificationProcessingEntityType notificationProcessingEntityType = NotificationProcessingEntityType.valueOf((String)stringArray[0]);
        List<Long> list = StringHelper.splitTrimming((String)stringArray[1], (String)",").stream().map(Long::valueOf).collect(Collectors.toList());
        return this.process(notificationProcessingEntityType, list);
    }

    private <E extends SimpleEntity> int process(NotificationProcessingEntityType<E> notificationProcessingEntityType, List<Long> list) {
        EntityNotificationProcessingHandler entityNotificationProcessingHandler = this.notificationHandler.getProcessingHandler(notificationProcessingEntityType);
        try {
            return (Integer)this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_WRITE, transactionStatus -> {
                List list2 = entityNotificationProcessingHandler.loadToNotify(list);
                list2.forEach(simpleEntity -> this.runInEntityNetwork((SimpleEntity)simpleEntity, () -> {
                    entityNotificationProcessingHandler.process(simpleEntity);
                    return null;
                }));
                return list2.size();
            });
        }
        catch (Exception exception) {
            list.forEach(l -> {
                try {
                    this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_WRITE, transactionStatus -> {
                        SimpleEntity simpleEntity = (SimpleEntity)CollectionHelper.first((Iterable)entityNotificationProcessingHandler.loadToNotify(Collections.singletonList(l)));
                        this.runInEntityNetwork(simpleEntity, () -> {
                            entityNotificationProcessingHandler.process(simpleEntity);
                            return null;
                        });
                        return null;
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            return list.size();
        }
    }
}

