/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.marketplace;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import org.cyclos.entities.marketplace.AdWebShopSetting;
import org.cyclos.entities.marketplace.QAdWebShopSetting;
import org.cyclos.entities.users.User;
import org.cyclos.entities.utils.NumberGeneration;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.marketplace.AdWebShopSettingServiceLocal;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.ValidationError;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.Property;
import org.cyclos.model.marketplace.MarketplaceKeys;
import org.cyclos.model.marketplace.webshopsettings.AdWebShopSettingDTO;
import org.cyclos.model.marketplace.webshopsettings.AdWebShopSettingData;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.utils.NumberGenerationDTO;
import org.springframework.stereotype.Service;

@Service
public class AdWebShopSettingServiceImpl
extends BaseServiceImpl
implements AdWebShopSettingServiceLocal {
    private static final QAdWebShopSetting $ = QAdWebShopSetting.adWebShopSetting;

    public AdWebShopSetting getAdWebShopSetting(User user) {
        AdWebShopSetting adWebShopSetting = (AdWebShopSetting)((DBQuery)this.from(new EntityPath[]{$}).where((Predicate)$.owner().eq((Object)user))).singleResult((Expression)$);
        if (adWebShopSetting == null) {
            adWebShopSetting = new AdWebShopSetting();
            adWebShopSetting.setOwner(user);
        }
        return adWebShopSetting;
    }

    public AdWebShopSettingData getData(UserLocatorVO userLocatorVO) {
        User user = this.userLocatorHandler.locate(userLocatorVO).getUser();
        AdWebShopSetting adWebShopSetting = this.getAdWebShopSetting(user);
        AdWebShopSettingData adWebShopSettingData = new AdWebShopSettingData();
        adWebShopSettingData.setSetting((AdWebShopSettingDTO)this.conversionHandler.convert(AdWebShopSettingDTO.class, (Object)adWebShopSetting));
        adWebShopSettingData.setCanEdit(true);
        return adWebShopSettingData;
    }

    public void remove(User user) {
        AdWebShopSetting adWebShopSetting = this.getAdWebShopSetting(user);
        if (adWebShopSetting != null && adWebShopSetting.isPersistent()) {
            this.remove((IEntity)adWebShopSetting);
        }
    }

    public void save(AdWebShopSettingDTO adWebShopSettingDTO) throws FrameworkException {
        this.validate(adWebShopSettingDTO);
        User user = this.userLocatorHandler.toUserOrCurrent((BasicUserVO)adWebShopSettingDTO.getOwner());
        AdWebShopSetting adWebShopSetting = this.getAdWebShopSetting(user);
        this.conversionHandler.fill((Object)adWebShopSettingDTO, (Object)adWebShopSetting);
        if (adWebShopSetting.isTransient()) {
            this.persist((IEntity)adWebShopSetting);
        }
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register($.owner().network());
    }

    protected boolean validGeneration(String string, Integer n, String string2) {
        try {
            NumberGeneration numberGeneration = new NumberGeneration(string, n, string2);
            numberGeneration.generate(Long.valueOf(0L));
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void validate(AdWebShopSettingDTO adWebShopSettingDTO) {
        Validator validator = new Validator();
        if (!adWebShopSettingDTO.isProductNumberGenerated()) {
            validator.property((Property)AdWebShopSettingDTO.PRODUCT_NUMBER_MASK, MarketplaceKeys.WebshopSettings.PRODUCT_NUMBER_MASK).required().mask(4);
        }
        if (adWebShopSettingDTO.isEnableOrderNumber()) {
            org.cyclos.impl.utils.validation.Property property = validator.property((Property)AdWebShopSettingDTO.ORDER_NUMBER, MarketplaceKeys.WebshopSettings.ORDER_NUMBER);
            property.nested((Property)NumberGenerationDTO.PREFIX, MarketplaceKeys.WebshopSettings.ORDER_NUMBER_PREFIX);
            property.nested((Property)NumberGenerationDTO.PAD_LENGTH, MarketplaceKeys.WebshopSettings.ORDER_NUMBER_PAD_LENGTH).required().between((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(10));
            property.nested((Property)NumberGenerationDTO.SUFFIX, MarketplaceKeys.WebshopSettings.ORDER_NUMBER_SUFFIX);
            property.add((object, object2, object3) -> {
                if (!this.validGeneration(adWebShopSettingDTO.getOrderNumber().getPrefix(), adWebShopSettingDTO.getOrderNumber().getPadLength(), adWebShopSettingDTO.getOrderNumber().getSuffix())) {
                    return new ValidationError(MarketplaceKeys.WebshopSettings.ERROR_INVALID_NUMBER_GENERATION);
                }
                return null;
            });
        }
        this.validate(validator, adWebShopSettingDTO, "adWebShopSettingDTO");
    }
}

