/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.marketplace;

import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.marketplace.BasicAd;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.marketplace.AdInterestServiceLocal;
import org.cyclos.impl.system.ProfilingEntry;
import org.cyclos.impl.utils.tasks.AbstractBackgroundTask;
import org.cyclos.impl.utils.tasks.BackgroundTaskScheduling;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.scheduledtasks.BackgroundTaskPriority;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.utils.MessageKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AdInterestNotificationBackgroundTask
extends AbstractBackgroundTask {
    @Autowired
    private AdInterestServiceLocal adInterestService;
    @Autowired
    private InvokerHandler invokerHandler;

    public static BackgroundTaskScheduling scheduling(BasicAd basicAd) {
        return new BackgroundTaskScheduling(AdInterestNotificationBackgroundTask.class, (Object)basicAd.getId(), "Notify interests for ad with id " + basicAd.getId());
    }

    public MessageKey getMessageKey() {
        return SystemKeys.BackgroundTasks.NOTIFY_AD_INTEREST;
    }

    public BackgroundTaskPriority getPriority() {
        return BackgroundTaskPriority.LOW;
    }

    @Override
    protected long doExecute(String string, ProfilingEntry profilingEntry) {
        long l = Long.parseLong(string);
        return (Long)this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_WRITE, transactionStatus -> {
            BasicAd basicAd = this.find(BasicAd.class, l);
            Boolean bl = this.runInEntityNetwork((SimpleEntity)basicAd, () -> this.adInterestService.generateNotification(basicAd));
            return bl != false ? 1L : 0L;
        });
    }
}

