/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.marketplace;

import com.google.common.collect.Sets;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import java.util.Set;
import org.cyclos.entities.NetworkedEntity;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.marketplace.AdAddress;
import org.cyclos.entities.marketplace.BasicAd;
import org.cyclos.entities.marketplace.QAdAddress;
import org.cyclos.entities.system.AddressConfiguration;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.GeoLocatedAddress;
import org.cyclos.entities.users.User;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.marketplace.AdAddressServiceLocal;
import org.cyclos.impl.search.AdSearchHandler;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.ConfigurationServiceLocal;
import org.cyclos.impl.users.GoogleMapsGeocoder;
import org.cyclos.impl.users.MemberProductAccessor;
import org.cyclos.impl.users.UserAddressServiceLocal;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.MaxItemsException;
import org.cyclos.model.Property;
import org.cyclos.model.access.Permission;
import org.cyclos.model.marketplace.addresses.AdAddressDTO;
import org.cyclos.model.marketplace.addresses.AdAddressData;
import org.cyclos.model.marketplace.addresses.AdAddressDataParams;
import org.cyclos.model.marketplace.advertisements.BasicAdVO;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.addresses.AddressDTO;
import org.cyclos.model.users.addresses.AddressFields;
import org.cyclos.model.users.addresses.AddressListData;
import org.cyclos.model.users.addresses.GeoLocatedAddressVO;
import org.cyclos.model.users.addresses.IAddress;
import org.cyclos.security.marketplace.AdServiceSecurity;
import org.cyclos.utils.AddressHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdAddressServiceImpl
extends CRUDServiceImpl<AdAddress, QAdAddress, AdAddressDTO, AdAddressData, AdAddressDataParams>
implements AdAddressServiceLocal {
    @Autowired
    private ConfigurationServiceLocal configurationService;
    @Autowired
    private AdServiceSecurity adServiceSecurity;
    @Autowired
    private UserAddressServiceLocal userAddressService;
    @Autowired
    private AdSearchHandler adSearchHandler;
    @Autowired
    private GoogleMapsGeocoder geocoder;

    public AdAddressServiceImpl() {
        super(AdAddress.class, QAdAddress.adAddress, AdAddressDTO.class);
    }

    public void cleanDisabledAddressFields(IAddress iAddress, ConfigurationAccessor configurationAccessor) {
        AddressConfiguration addressConfiguration = configurationAccessor.getAddressConfiguration();
        Set set = addressConfiguration.getEnabledAddressFields();
        Sets.SetView setView = Sets.difference((Set)Sets.newHashSet((Object[])AddressFields.values()), (Set)set);
        for (AddressFields addressFields : setView) {
            AddressHelper.setValue((AddressFields)addressFields, (IAddress)iAddress, null);
        }
    }

    public AddressListData getAddressListData(BasicAd basicAd) throws FrameworkException {
        AddressListData addressListData = new AddressListData();
        DBQuery<?> dBQuery = this.from();
        dBQuery.where((Predicate)((QAdAddress)this.$).ad().eq((Object)basicAd));
        dBQuery.orderBy(((QAdAddress)this.$).name.asc());
        addressListData.setAddresses(dBQuery.list(GeoLocatedAddressVO.class, (Expression)this.$));
        MemberProductAccessor memberProductAccessor = this.productsHandler.getAccessor((BasicUser)basicAd.getOwner()).member();
        addressListData.setMaxAddresses(Integer.valueOf(memberProductAccessor.getMaxAddressesPerAd()));
        addressListData.setCanCreateAddress(this.canCreateAddress(addressListData, basicAd));
        return addressListData;
    }

    public AddressListData getAddressListData(BasicAdVO basicAdVO) throws FrameworkException {
        return this.getAddressListData((BasicAd)this.conversionHandler.convert(BasicAd.class, (Object)basicAdVO));
    }

    @Override
    public AdAddress newEntity(AdAddressDataParams adAddressDataParams) {
        BasicAd basicAd = (BasicAd)this.conversionHandler.convert(BasicAd.class, (Object)adAddressDataParams.getAd());
        User user = (User)this.conversionHandler.convert(User.class, (Object)basicAd.getOwner());
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor((BasicUser)user);
        AdAddress adAddress = new AdAddress();
        adAddress.setAd(basicAd);
        adAddress.setCity(configurationAccessor.getDefaultCity());
        adAddress.setCountry(configurationAccessor.getCountry());
        adAddress.setRegion(configurationAccessor.getDefaultRegion());
        return adAddress;
    }

    @Override
    protected AdAddressData getData(AdAddress adAddress) {
        User user = adAddress.getAd().getOwner();
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor((BasicUser)user);
        AdAddressData adAddressData = new AdAddressData();
        adAddressData.setDto((EntityDTO)((AdAddressDTO)this.toDTO(adAddress)));
        adAddressData.setConfiguration(this.configurationService.toAddressConfiguration(configurationAccessor));
        return adAddressData;
    }

    @Override
    protected void onAfterRemove(AdAddress adAddress) {
        super.onAfterRemove(adAddress);
        this.adSearchHandler.index((NetworkedEntity)adAddress.getAd());
    }

    @Override
    protected void onAfterSave(AdAddress adAddress, AdAddress adAddress2, Object object) {
        super.onAfterSave(adAddress, adAddress2, object);
        this.adSearchHandler.index((NetworkedEntity)adAddress.getAd());
    }

    @Override
    protected Object onBeforeSave(AdAddress adAddress, AdAddress adAddress2) {
        int n;
        int n2;
        if (adAddress.isTransient() && (n2 = this.productsHandler.getAccessor((BasicUser)adAddress.getAd().getOwner()).member().getMaxAddressesPerAd()) <= (n = ((DBQuery)this.from(this.$).where((Predicate)((QAdAddress)this.$).ad().eq((Object)adAddress.getAd()))).count(((QAdAddress)this.$).id))) {
            throw new MaxItemsException(n2);
        }
        if (!adAddress.isLocated()) {
            try {
                GoogleMapsGeocoder.LocalizationStatus localizationStatus = this.geocoder.geocode((GeoLocatedAddress)adAddress);
                adAddress.setGeocodeFailed(localizationStatus == GoogleMapsGeocoder.LocalizationStatus.FAILED);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.onBeforeSave(adAddress, adAddress2);
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QAdAddress)this.$).ad().owner().network());
    }

    @Override
    protected Validator resolveValidator(AdAddressDTO adAddressDTO) {
        AdAddress adAddress;
        BasicAd basicAd;
        Validator validator = new Validator();
        if (adAddressDTO.isTransient()) {
            validator.property((Property)AdAddressDTO.AD, UsersKeys.Addresses.ADVERTISEMENT).required();
            basicAd = (BasicAd)this.conversionHandler.convert(BasicAd.class, (Object)adAddressDTO.getAd());
        } else {
            adAddress = (AdAddress)this.find(adAddressDTO.getId());
            basicAd = adAddress.getAd();
        }
        if (basicAd != null) {
            adAddress = this.configurationHandler.getAccessor((BasicUser)basicAd.getOwner());
            this.userAddressService.appendValidations(validator, (AddressDTO)adAddressDTO, (ConfigurationAccessor)adAddress, false);
        }
        return validator;
    }

    private boolean canCreateAddress(AddressListData addressListData, BasicAd basicAd) {
        if (basicAd.isTransient() && this.isManagerOf((BasicUser)basicAd.getOwner()) && !this.hasPermission(Permission.USER_PENDING_ADS_MANAGE)) {
            return false;
        }
        return this.adServiceSecurity.hasManageAccess((SimpleEntity)basicAd) && addressListData.getMaxAddresses() > addressListData.getAddresses().size();
    }
}

