/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.logging;

import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cyclos.entities.system.LogConfiguration;
import org.cyclos.impl.CyclosThreadFactory;
import org.cyclos.impl.logging.BaseLogParams;
import org.cyclos.impl.logging.LogProvider;
import org.cyclos.impl.logging.LoggingHandler;
import org.cyclos.impl.logging.NoOpLogProvider;
import org.cyclos.impl.logging.ServiceLogParams;
import org.cyclos.impl.logging.TaskLogParams;
import org.cyclos.impl.utils.cluster.ClusterHandler;
import org.cyclos.model.system.configurations.TaskLoggingMode;
import org.cyclos.server.utils.CyclosProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LoggingHandlerImpl
implements LoggingHandler {
    private static final Logger LOG = LogManager.getLogger(LoggingHandlerImpl.class);
    @Autowired
    private CyclosProperties cyclosProperties;
    @Autowired
    private LogProvider logProvider;
    private boolean noOp;
    private ExecutorService executorService;
    @Autowired
    private ClusterHandler clusterHandler;

    @PreDestroy
    public void destroy() {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }

    @PostConstruct
    public void initialize() {
        String string = "Log output: " + this.logProvider.getLogOutput();
        LOG.info(string);
        this.noOp = this.logProvider instanceof NoOpLogProvider;
        boolean bl = this.cyclosProperties.isSynchronousLog();
        this.executorService = this.noOp || bl ? MoreExecutors.newDirectExecutorService() : Executors.newCachedThreadPool(CyclosThreadFactory.CyclosThreadGroup.LOG.factory());
    }

    public void invalidateLoggers(String string) {
        this.logProvider.invalidateLoggers(string);
    }

    public void logService(LogConfiguration logConfiguration, ServiceLogParams serviceLogParams, boolean bl) {
        if (!logConfiguration.isEnableServicesLog() || logConfiguration.isLogServicesWritesOnly() && !bl) {
            return;
        }
        if (!logConfiguration.isLogServicesForGuests() && serviceLogParams.getUserId() == null) {
            return;
        }
        if (serviceLogParams.getError() != null && this.clusterHandler.isCausedByShutdown(serviceLogParams.getError())) {
            return;
        }
        this.process(logConfiguration, (BaseLogParams)serviceLogParams);
    }

    public void logTask(LogConfiguration logConfiguration, TaskLogParams taskLogParams) {
        if (logConfiguration.getTasksLoggingMode() == TaskLoggingMode.OFF) {
            return;
        }
        if (taskLogParams.getError() != null && this.clusterHandler.isCausedByShutdown(taskLogParams.getError())) {
            return;
        }
        this.process(logConfiguration, (BaseLogParams)taskLogParams);
    }

    private void process(LogConfiguration logConfiguration, BaseLogParams baseLogParams) {
        if (this.noOp) {
            return;
        }
        this.executorService.submit(() -> {
            try {
                this.logProvider.log(logConfiguration, baseLogParams);
            }
            catch (Exception exception) {
                LOG.warn("Error while generating a log entry", (Throwable)exception);
            }
        });
    }
}

