/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.logging;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PreDestroy;
import javax.servlet.ServletContext;
import org.cyclos.impl.logging.BaseJULLogProvider;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;

public class FileLogProvider
extends BaseJULLogProvider {
    private static final String SERVICES = "services";
    private static final String TASKS = "tasks";
    private static final List<String> ALL_TYPES = Arrays.asList("services", "tasks");
    @Autowired
    private CyclosProperties cyclosProperties;
    @Autowired(required=false)
    private ServletContext servletContext;
    private Object mutex = new Object();
    private Map<String, Logger> loggers = new HashMap<String, Logger>();

    @PreDestroy
    public void destroy() {
        for (Logger logger : this.loggers.values()) {
            this.destroy(logger);
        }
    }

    @Override
    public String getLogOutput() {
        String string = this.cyclosProperties.getLogDir();
        if (StringHelper.isNotBlank((Object)string)) {
            string = StringHelper.replace((String)string, (String)"%w", (String)this.webDir());
            return this.cyclosProperties.resolveFile(string).getAbsolutePath();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateLoggers(String string) {
        Object object = this.mutex;
        synchronized (object) {
            ALL_TYPES.forEach(string2 -> {
                String string3 = this.logPath(string, (String)string2);
                Logger logger = this.loggers.get(string3);
                this.destroy(logger);
                this.loggers.remove(string3);
            });
        }
    }

    @Override
    protected void doLog(Logger logger, String string, String string2, Level level, String string3, Throwable throwable) {
        logger.log(level, string3, throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Logger getLogger(String string, String string2) {
        String string3 = this.logPath(string2, string);
        Logger logger = this.loggers.get(string3);
        if (logger == null) {
            Object object = this.mutex;
            synchronized (object) {
                logger = this.loggers.get(string3);
                if (logger == null) {
                    logger = this.initLogger(string3);
                    this.loggers.put(string3, logger);
                }
            }
        }
        return logger;
    }

    private void destroy(Logger logger) {
        if (logger != null) {
            for (Handler handler : logger.getHandlers()) {
                if (!(handler instanceof FileHandler)) continue;
                try {
                    handler.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private Logger initLogger(String string) {
        new File(string).getParentFile().mkdirs();
        int n = Math.max(102400, this.cyclosProperties.getLogMaxFileSize());
        int n2 = Math.max(1, this.cyclosProperties.getLogMaxFiles());
        Logger logger = Logger.getAnonymousLogger();
        logger.setLevel(Level.INFO);
        logger.setUseParentHandlers(false);
        try {
            FileHandler fileHandler = new FileHandler(string, n, n2, true);
            this.initHandler(fileHandler);
            logger.addHandler(fileHandler);
        }
        catch (Exception exception) {
            ConsoleHandler consoleHandler = new ConsoleHandler();
            this.initHandler(consoleHandler);
            logger.addHandler(consoleHandler);
            logger.log(Level.WARNING, "Unable to create logger on " + string + ". Falling back to console logging.");
        }
        return logger;
    }

    private String logPath(String string, String string2) {
        if (string == null) {
            string = "global";
        }
        String string3 = this.cyclosProperties.getLogDir();
        string3 = StringHelper.replace((String)string3, (String)"%n", (String)string);
        string3 = StringHelper.replace((String)string3, (String)"%w", (String)this.webDir());
        File file = this.cyclosProperties.resolveFile(string3);
        return file.getAbsolutePath() + "/" + string + "-" + string2 + ".%g.log";
    }

    private String webDir() {
        String string;
        if (this.servletContext == null) {
            String string2 = System.getProperty("java.io.tmpdir");
            string = new File(string2, "cyclos4").getAbsolutePath();
        } else {
            string = this.servletContext.getRealPath("/");
        }
        return string;
    }
}

