/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.logging;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.cyclos.entities.system.LogConfiguration;
import org.cyclos.impl.logging.BaseLogProvider;
import org.cyclos.impl.logging.LogFormatter;
import org.cyclos.impl.logging.ServiceLogParams;
import org.cyclos.impl.logging.TaskLogParams;
import org.cyclos.utils.ObjectHelper;

public abstract class BaseJULLogProvider
extends BaseLogProvider {
    protected static final String SERVICES = "services";
    protected static final String TASKS = "tasks";

    public void onApplicationInitialization() {
    }

    protected abstract void doLog(Logger var1, String var2, String var3, Level var4, String var5, Throwable var6);

    protected abstract Logger getLogger(String var1, String var2);

    protected void initHandler(Handler handler) {
        handler.setFormatter(LogFormatter.getInstance());
        try {
            handler.setEncoding("UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void service(LogConfiguration logConfiguration, ServiceLogParams serviceLogParams) {
        String string = (String)ObjectHelper.defaultValue((Object)serviceLogParams.getNetwork(), (Object)"global");
        Logger logger = this.getLogger(SERVICES, string);
        if (logger != null) {
            String string2 = LogFormatter.format(logConfiguration, serviceLogParams);
            Throwable throwable = serviceLogParams.getError();
            this.doLog(logger, SERVICES, string, throwable != null ? Level.SEVERE : Level.INFO, string2, throwable);
        }
    }

    @Override
    protected void task(LogConfiguration logConfiguration, TaskLogParams taskLogParams) {
        String string = "global";
        Logger logger = this.getLogger(TASKS, string);
        if (logger != null) {
            String string2 = LogFormatter.format(logConfiguration, taskLogParams);
            Throwable throwable = taskLogParams.getError();
            this.doLog(logger, TASKS, string, throwable != null ? Level.SEVERE : Level.INFO, string2, throwable);
        }
    }
}

