/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.contentmanagement;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.contentmanagement.QTheme;
import org.cyclos.entities.contentmanagement.Theme;
import org.cyclos.entities.contentmanagement.ThemeImage;
import org.cyclos.entities.system.Configuration;
import org.cyclos.entities.system.QConfiguration;
import org.cyclos.entities.utils.StoredFile;
import org.cyclos.impl.ApplicationHandler;
import org.cyclos.impl.ApplicationUpgradeInitializationListener;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.contentmanagement.ThemeImageServiceLocal;
import org.cyclos.impl.contentmanagement.ThemeServiceLocal;
import org.cyclos.impl.storage.StoredFileHandler;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.ConfigurationAccessorCacheKey;
import org.cyclos.impl.system.ConfigurationServiceLocal;
import org.cyclos.impl.utils.QueryHelper;
import org.cyclos.impl.utils.SerializablePredicate;
import org.cyclos.impl.utils.cache.CacheHandler;
import org.cyclos.impl.utils.cache.CacheType;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.PropertyAccess;
import org.cyclos.impl.utils.validation.PropertyValidation;
import org.cyclos.impl.utils.validation.ThemeDefinitionAccess;
import org.cyclos.impl.utils.validation.ValidationError;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.impl.utils.validation.validations.BasePropertyValidation;
import org.cyclos.model.CSSCompileException;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FileParsingException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.Property;
import org.cyclos.model.ValidationException;
import org.cyclos.model.contentmanagement.ContentManagementKeys;
import org.cyclos.model.contentmanagement.themes.ApplyThemesDTO;
import org.cyclos.model.contentmanagement.themes.GradientType;
import org.cyclos.model.contentmanagement.themes.MaterialPalette;
import org.cyclos.model.contentmanagement.themes.ThemeDTO;
import org.cyclos.model.contentmanagement.themes.ThemeData;
import org.cyclos.model.contentmanagement.themes.ThemeDataParams;
import org.cyclos.model.contentmanagement.themes.ThemeDefinition;
import org.cyclos.model.contentmanagement.themes.ThemeDefinitionType;
import org.cyclos.model.contentmanagement.themes.ThemeImageType;
import org.cyclos.model.contentmanagement.themes.ThemeType;
import org.cyclos.model.contentmanagement.themes.ThemeUsage;
import org.cyclos.model.contentmanagement.themes.ThemeVO;
import org.cyclos.model.contentmanagement.themes.ThemesListData;
import org.cyclos.model.system.configurations.ConfigurationVO;
import org.cyclos.model.system.configurations.DefaultConfigurationType;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.server.utils.IOHelper;
import org.cyclos.server.utils.PropertyHelper;
import org.cyclos.server.utils.ResourceHelper;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.server.utils.ServerImageHelper;
import org.cyclos.server.utils.XmlHelper;
import org.cyclos.server.utils.ZipHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ColorHelper;
import org.cyclos.utils.ContentType;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Pair;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.stro.jdartsass.CompilationOptions;
import org.stro.jdartsass.Distribution;
import org.stro.jdartsass.Installation;
import org.stro.jdartsass.JDartSass;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Service
public class ThemeServiceImpl
extends CRUDServiceImpl<Theme, QTheme, ThemeDTO, ThemeData, ThemeDataParams>
implements ThemeServiceLocal,
ApplicationUpgradeInitializationListener {
    private static final String DEFAULT_MOBILE_THEME_FILE = "default_mobile";
    private static final String DEFAULT_PAY_THEME_FILE = "default_pay";
    private static final String DEFAULT_APP_THEME_FILE = "default_app";
    private static final String THEME_DESCRIPTOR = "theme.xml";
    private static final String[] THEME_PROPERTIES = new String[]{"name", "type", "description", "author", "advancedDefinitions", "customStyle"};
    private static final String THEME_TAG = "theme";
    private static final String DEFINITIONS_TAG = "definitions";
    private static final String DEFINITION_TAG = "definition";
    private static final String NAME_TAG = "name";
    private static final String VALUE_TAG = "value";
    private static final Pattern URL_PATTERN = Pattern.compile("url\\(([^\\)]+)\\)", 2);
    private static final String MAIN_STYLES = "/main-styles";
    private static final String PAY_STYLES = "/pay-styles";
    private static final String APP_STYLES = "/app-styles";
    private static final String MAIN_STYLE = "/main-styles/main-style.scss";
    private static final String MAIN_VARIABLES = "/main-styles/main-variables.scss";
    private static final String MAIN_MIXINS = "/main-styles/main-mixins.scss";
    private static final String MAIN_FOOTER = "/main-styles/main-footer.scss";
    private Set<String> builtinThemes;
    private String dartSassVersion;
    private File sassDir;
    private final String[] EXCLUDED_PROPERTIES_TO_DTO = new String[]{ThemeDTO.DEFINITIONS.getName()};
    @Autowired(required=false)
    private ServletContext servletContext;
    @Autowired
    private ThemeImageServiceLocal themeImageService;
    @Autowired
    private ConfigurationServiceLocal configurationService;
    @Autowired
    private CacheHandler cacheHandler;
    @Autowired
    private StoredFileHandler storedFileHandler;
    @Autowired
    private CyclosProperties cyclosProperties;
    @Autowired
    private ApplicationHandler applicationHandler;
    private Map<String, String> resources = new ConcurrentHashMap<String, String>();

    public ThemeServiceImpl() {
        super(Theme.class, QTheme.theme, ThemeDTO.class);
    }

    public void applyThemes(ApplyThemesDTO applyThemesDTO) throws FrameworkException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Configuration configuration = (Configuration)this.conversionHandler.convert(Configuration.class, (Object)applyThemesDTO.getConfiguration());
        if (configuration == null) {
            throw new ValidationException();
        }
        Theme theme = this.convertAndCheck(configuration, applyThemesDTO.getUsersTheme(), ThemeType.MAIN_WEB);
        Theme theme2 = this.convertAndCheck(configuration, applyThemesDTO.getGuestsTheme(), ThemeType.MAIN_WEB);
        Theme theme3 = this.convertAndCheck(configuration, applyThemesDTO.getMobileTheme(), ThemeType.MOBILE);
        Theme theme4 = this.convertAndCheck(configuration, applyThemesDTO.getPayTheme(), ThemeType.PAY);
        Theme theme5 = this.convertAndCheck(configuration, applyThemesDTO.getAppTheme(), ThemeType.APP);
        QConfiguration qConfiguration = QConfiguration.configuration;
        if (configuration.getDefaultType() == DefaultConfigurationType.GLOBAL && (theme == null || theme2 == null || theme3 == null || theme4 == null)) {
            throw new ValidationException();
        }
        Long l = SimpleEntity.id((SimpleEntity)configuration.getNetwork());
        Theme theme6 = configuration.getUsersTheme();
        if (!Objects.equals(theme, theme6)) {
            if (theme6 != null) {
                theme6.getUserConfigurations().remove(configuration);
            }
            configuration.setUsersTheme(theme);
            if (theme != null) {
                theme.getUserConfigurations().add(configuration);
            }
            object4 = PropertyHelper.getGetterName((Path)qConfiguration.usersTheme());
            this.cacheHandler.schedulePartialEvict(CacheType.CONFIGURATION_ACCESSOR, arg_0 -> ThemeServiceImpl.lambda$applyThemes$fe78a5f7$1(l, (String)object4, arg_0));
        }
        if (!Objects.equals(theme2, object4 = configuration.getGuestsTheme())) {
            if (object4 != null) {
                object4.getGuestConfigurations().remove(configuration);
            }
            configuration.setGuestsTheme(theme2);
            if (theme2 != null) {
                theme2.getGuestConfigurations().add(configuration);
            }
            object3 = PropertyHelper.getGetterName((Path)qConfiguration.guestsTheme());
            this.cacheHandler.schedulePartialEvict(CacheType.CONFIGURATION_ACCESSOR, arg_0 -> ThemeServiceImpl.lambda$applyThemes$fe78a5f7$2(l, (String)object3, arg_0));
        }
        if (!Objects.equals(theme3, object3 = configuration.getMobileTheme())) {
            if (object3 != null) {
                object3.getMobileConfigurations().remove(configuration);
            }
            configuration.setMobileTheme(theme3);
            if (theme3 != null) {
                theme3.getMobileConfigurations().add(configuration);
            }
            object2 = PropertyHelper.getGetterName((Path)qConfiguration.mobileTheme());
            this.cacheHandler.schedulePartialEvict(CacheType.CONFIGURATION_ACCESSOR, arg_0 -> ThemeServiceImpl.lambda$applyThemes$fe78a5f7$3(l, (String)object2, arg_0));
        }
        if (!Objects.equals(theme4, object2 = configuration.getPayTheme())) {
            if (object2 != null) {
                object2.getPayConfigurations().remove(configuration);
            }
            configuration.setPayTheme(theme4);
            if (theme4 != null) {
                theme4.getPayConfigurations().add(configuration);
            }
            object = PropertyHelper.getGetterName((Path)qConfiguration.payTheme());
            this.cacheHandler.schedulePartialEvict(CacheType.CONFIGURATION_ACCESSOR, arg_0 -> ThemeServiceImpl.lambda$applyThemes$fe78a5f7$4(l, (String)object, arg_0));
        }
        if (!Objects.equals(theme5, object = configuration.getAppTheme())) {
            if (object != null) {
                object.getAppConfigurations().remove(configuration);
            }
            configuration.setAppTheme(theme5);
            if (theme5 != null) {
                theme5.getAppConfigurations().add(configuration);
            }
            String string = PropertyHelper.getGetterName((Path)qConfiguration.appTheme());
            this.cacheHandler.schedulePartialEvict(CacheType.CONFIGURATION_ACCESSOR, (SerializablePredicate & Serializable)configurationAccessorCacheKey -> configurationAccessorCacheKey.matchesNetworkAndMethod(l, string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileInfo export(Long l) {
        ZipOutputStream exception;
        Element element;
        String string;
        Theme theme = (Theme)this.find(l);
        File file = this.cyclosProperties.newTempFile(THEME_TAG, ".zip");
        Document document = XmlHelper.newDocument();
        Element element2 = document.createElement(THEME_TAG);
        document.appendChild(element2);
        XmlHelper.fillSubElements((Element)element2, (Object)theme, (String[])THEME_PROPERTIES);
        Element element3 = document.createElement(DEFINITIONS_TAG);
        element2.appendChild(element3);
        Map map = theme.getDefinitions();
        for (ThemeDefinition themeDefinition : ThemeDefinition.values((ThemeType)theme.getType())) {
            string = (String)map.get(themeDefinition);
            if (!StringHelper.isNotBlank((Object)string)) continue;
            element = document.createElement(DEFINITION_TAG);
            XmlHelper.createChild((Element)element, (String)NAME_TAG, (String)themeDefinition.name());
            XmlHelper.createChild((Element)element, (String)VALUE_TAG, (String)string);
            element3.appendChild(element);
        }
        String string2 = XmlHelper.export((Node)document);
        try {
            exception = new ZipOutputStream(new FileOutputStream(file));
            try {
                exception.putNextEntry(new ZipEntry(THEME_DESCRIPTOR));
                IOUtils.write((String)string2, (OutputStream)exception, (Charset)StandardCharsets.UTF_8);
                exception.closeEntry();
                for (ThemeDefinition themeDefinition : theme.getImages()) {
                    string = themeDefinition.getType();
                    exception.putNextEntry(new ZipEntry("images/" + string.name() + "/" + themeDefinition.getName()));
                    element = this.storedFileHandler.getContent((StoredFile)themeDefinition);
                    try {
                        IOUtils.copy((InputStream)((Object)element), (OutputStream)exception);
                    }
                    finally {
                        IOHelper.close((Closeable)((Object)element));
                        exception.closeEntry();
                    }
                }
            }
            finally {
                exception.close();
            }
        }
        catch (Exception exception2) {
            file.delete();
            throw exception2 instanceof RuntimeException ? (RuntimeException)exception2 : new IllegalStateException(exception2);
        }
        exception = new FileInfo();
        exception.setName(StringHelper.safeFilename((String)theme.getName()) + ".cyclos.theme");
        exception.setContentType(ContentType.ZIP.getMimeType());
        exception.setLength((int)file.length());
        exception.setContent(new SerializableInputStream(file));
        return exception;
    }

    public String getCSS(Long l) {
        Theme theme = (Theme)this.find(l);
        return this.getCSS(theme);
    }

    public String getCSS(Theme theme) {
        return this.doGetCSS(theme, null);
    }

    public String getDefinition(Theme theme, ThemeDefinition themeDefinition) {
        Map map = theme.getDefinitions();
        String string = map == null ? null : (String)map.get(themeDefinition);
        return string == null ? themeDefinition.defaultValue() : string;
    }

    public String getDefinitionsAsString(Theme theme) {
        return this.getDefinitionsAsString(theme.getType(), theme.getDefinitions());
    }

    public String getFallbackCSS(ThemeType themeType) {
        return this.doGetCSS(null, themeType);
    }

    public ThemesListData getListData(ConfigurationVO configurationVO) throws FrameworkException {
        Configuration configuration = (Configuration)this.conversionHandler.convert(Configuration.class, (Object)configurationVO);
        Configuration configuration2 = configuration.getParent();
        ThemesListData themesListData = new ThemesListData();
        if (configuration2 != null) {
            ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor(configuration2);
            themesListData.setInheritedUsersTheme((ThemeVO)this.conversionHandler.convert(ThemeVO.class, (Object)configurationAccessor.getUsersTheme()));
            themesListData.setInheritedGuestsTheme((ThemeVO)this.conversionHandler.convert(ThemeVO.class, (Object)configurationAccessor.getGuestsTheme()));
            themesListData.setInheritedMobileTheme((ThemeVO)this.conversionHandler.convert(ThemeVO.class, (Object)configurationAccessor.getMobileTheme()));
            themesListData.setInheritedPayTheme((ThemeVO)this.conversionHandler.convert(ThemeVO.class, (Object)configurationAccessor.getPayTheme()));
            themesListData.setInheritedAppTheme((ThemeVO)this.conversionHandler.convert(ThemeVO.class, (Object)configurationAccessor.getAppTheme()));
            themesListData.setThemeOptional(true);
        }
        themesListData.setForGuests(configuration.isForGuests());
        themesListData.setAppliedUsersTheme((ThemeVO)this.conversionHandler.convert(ThemeVO.class, (Object)configuration.getUsersTheme()));
        themesListData.setAppliedGuestsTheme((ThemeVO)this.conversionHandler.convert(ThemeVO.class, (Object)configuration.getGuestsTheme()));
        themesListData.setAppliedMobileTheme((ThemeVO)this.conversionHandler.convert(ThemeVO.class, (Object)configuration.getMobileTheme()));
        themesListData.setAppliedPayTheme((ThemeVO)this.conversionHandler.convert(ThemeVO.class, (Object)configuration.getPayTheme()));
        themesListData.setAppliedAppTheme((ThemeVO)this.conversionHandler.convert(ThemeVO.class, (Object)configuration.getAppTheme()));
        themesListData.setThemes(this.list(new ConfigurationVO(configuration.getId())));
        return themesListData;
    }

    public ThemeVO getTheme(ThemeType themeType) throws FrameworkException {
        Theme theme = null;
        SessionData sessionData = this.getSessionData();
        ConfigurationAccessor configurationAccessor = sessionData.getConfiguration();
        switch (themeType) {
            case MAIN_WEB: {
                theme = this.isGuest() ? configurationAccessor.getGuestsTheme() : configurationAccessor.getUsersTheme();
                break;
            }
            case MOBILE: {
                theme = configurationAccessor.getMobileTheme();
                break;
            }
            case PAY: {
                theme = configurationAccessor.getPayTheme();
                break;
            }
            case APP: {
                theme = configurationAccessor.getAppTheme();
            }
        }
        if (theme == null) {
            throw new IllegalArgumentException("Unknown theme type: " + String.valueOf(themeType));
        }
        return (ThemeVO)this.conversionHandler.convert(ThemeVO.class, (Object)theme);
    }

    public ThemeVO getVO(Long l) throws EntityNotFoundException {
        return (ThemeVO)this.conversionHandler.convert(ThemeVO.class, this.find(l));
    }

    /*
     * Unable to fully structure code
     */
    public List<Theme> importBuiltin() {
        var1_1 = new ArrayList<Theme>();
        var2_2 = this.configurationHandler.getDefault();
        var3_3 = null;
        var4_4 = null;
        var5_5 = null;
lbl6:
        // 10 sources

        block16: for (String var7_7 : this.builtinThemes) {
            var8_8 = "/themes/" + var7_7;
            var9_9 = ".xml";
            var10_10 = Collections.emptyList();
            var11_11 = null;
            if (var7_7.endsWith(".zip")) {
                try {
                    var12_12 = ResourceHelper.openStream((String)("/themes/" + var7_7));
                }
                catch (IOException var13_14) {
                    throw new FileParsingException("Error reading theme " + var7_7);
                }
                var11_11 = this.getZipTheme(var12_12);
                var8_8 = var11_11.getPath();
                var9_9 = ".zip";
                var10_10 = var11_11.getResources();
            }
            var7_7 = StringUtils.removeEnd((String)var7_7, (String)var9_9);
            var12_12 = (Theme)((DBQuery)this.from().where(new Predicate[]{((QTheme)this.$).fileName.eq((Object)var7_7), ((QTheme)this.$).configuration().eq((Object)var2_2)})).singleResult((Expression)this.$);
            try {
                var13_13 = this.doImport((Theme)var12_12, var2_2, var7_7, (String)var8_8, var10_10);
                var1_1.add(var13_13);
                switch (1.$SwitchMap$org$cyclos$model$contentmanagement$themes$ThemeType[var13_13.getType().ordinal()]) {
                    case 2: {
                        if (!"default_mobile".equals(var7_7) || var12_12 != null) continue block16;
                        var3_3 = var13_13;
                        ** break;
                    }
                    case 3: {
                        if (!"default_pay".equals(var7_7) || var12_12 != null) continue block16;
                        var4_4 = var13_13;
                        ** break;
                    }
                    case 4: {
                        if (!"default_app".equals(var7_7) || var12_12 != null) continue block16;
                        var5_5 = var13_13;
                        ** break;
                    }
                    ** default:
lbl41:
                    // 1 sources

                    continue block16;
                }
            }
            catch (Exception var13_16) {
                throw new IllegalStateException("Error importing theme from " + (String)var8_8, var13_16);
            }
            finally {
                if (var11_11 == null) continue;
                try {
                    FileUtils.deleteDirectory((File)var11_11.getFile());
                }
                catch (IOException var15_18) {}
            }
        }
        if (var3_3 != null && var2_2.getMobileTheme() == null) {
            var2_2.setMobileTheme(var3_3);
        }
        if (var4_4 != null && var2_2.getPayTheme() == null) {
            var2_2.setPayTheme(var4_4);
        }
        if (var5_5 != null && var2_2.getAppTheme() == null) {
            var2_2.setAppTheme(var5_5);
        }
        return var1_1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long importNew(ConfigurationVO configurationVO, String string, SerializableInputStream serializableInputStream) throws FileParsingException {
        Long l;
        Configuration configuration = (Configuration)this.conversionHandler.convert(Configuration.class, (Object)configurationVO);
        ZipTheme zipTheme = this.getZipTheme((InputStream)serializableInputStream);
        try {
            l = this.doImport(null, configuration, string, zipTheme.getPath(), zipTheme.getResources()).getId();
        }
        finally {
            try {
                FileUtils.deleteDirectory((File)zipTheme.getFile());
            }
            catch (IOException iOException) {}
        }
        return l;
    }

    @PostConstruct
    public void initialize() throws IOException {
        this.builtinThemes = new HashSet<String>();
        List list = ResourceHelper.listResources((String)"/themes");
        if (list != null) {
            for (String string : list) {
                this.builtinThemes.add(ResourceHelper.getName((String)string));
            }
        }
        this.sassDir = new File(this.cyclosProperties.getTempDir(), "sass");
        this.dartSassVersion = ResourceHelper.readContent((String)"/dart-sass-version");
    }

    public boolean isBuiltin(Theme theme) {
        String string = theme.getFileName();
        String string2 = string + ".zip";
        String string3 = string + ".xml";
        return this.builtinThemes.contains(string3) || this.builtinThemes.contains(string2);
    }

    public List<ThemeVO> list(ConfigurationVO configurationVO) {
        Configuration configuration = (Configuration)this.conversionHandler.convert(Configuration.class, (Object)configurationVO);
        List list = this.configurationHandler.getAncestors(configuration);
        List list2 = ((DBQuery)((DBQuery)this.from().where((Predicate)((QTheme)this.$).configuration().in((Collection)list))).orderBy(new OrderSpecifier[]{((QTheme)this.$).configuration().nameHierarchy().asc(), ((QTheme)this.$).name.asc()})).list((Expression)this.$);
        ArrayList<ThemeVO> arrayList = new ArrayList<ThemeVO>(list2.size());
        for (Theme theme : list2) {
            ThemeVO themeVO3 = (ThemeVO)this.conversionHandler.convert(ThemeVO.class, (Object)theme);
            themeVO3.setBuiltin(this.isBuiltin(theme));
            arrayList.add(themeVO3);
        }
        Collections.sort(arrayList, (themeVO, themeVO2) -> {
            int n = themeVO.getType() == ThemeType.MAIN_WEB ? 0 : 1;
            Integer n2 = themeVO2.getType() == ThemeType.MAIN_WEB ? 0 : 1;
            return Integer.compare(n, n2);
        });
        return arrayList;
    }

    public List<Theme> listAll() {
        return ((DBQuery)this.from().orderBy(((QTheme)this.$).name.asc())).list((Expression)this.$);
    }

    @Override
    public Theme newEntity(ThemeDataParams themeDataParams) {
        Long l = themeDataParams.getBasedOnId();
        Configuration configuration = (Configuration)this.conversionHandler.convert(Configuration.class, (Object)themeDataParams.getConfiguration());
        Theme theme = new Theme();
        theme.setConfiguration(configuration);
        theme.setBasedOnId(l);
        theme.setType(themeDataParams.getType());
        if (l != null) {
            Theme theme2 = (Theme)this.find(l);
            theme.setType(theme2.getType());
            theme.getDefinitions().putAll(theme2.getDefinitions());
            theme.setAdvancedDefinitions(theme2.getAdvancedDefinitions());
            theme.setCustomStyle(theme2.getCustomStyle());
        }
        return theme;
    }

    public void onApplicationUpgradeInitialization() {
        this.importBuiltin();
    }

    @Override
    public ThemeDTO toDTO(Theme theme) {
        ThemeDTO themeDTO = (ThemeDTO)super.toDTO(theme);
        HashMap<ThemeDefinition, String> hashMap = new HashMap<ThemeDefinition, String>();
        Map map = theme.getDefinitions();
        for (ThemeDefinition themeDefinition : ThemeDefinition.values((ThemeType)theme.getType())) {
            String string = null;
            try {
                string = (String)map.get(themeDefinition);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (StringHelper.isBlank(string)) {
                string = themeDefinition.defaultValue();
            }
            hashMap.put(themeDefinition, string);
        }
        themeDTO.setDefinitions(hashMap);
        return themeDTO;
    }

    @Override
    protected ThemeData getData(Theme theme) {
        ThemeDTO themeDTO;
        ThemeData themeData = new ThemeData();
        ThemeType themeType = theme.getType();
        if (theme.isPersistent()) {
            themeDTO = EnumSet.of(ThemeImageType.CUSTOM);
            themeData.setCustomImages(this.themeImageService.list(theme.getId(), (Set)themeDTO));
            themeData.setImages(this.themeImageService.list(theme.getId(), EnumSet.complementOf(themeDTO)));
            switch (themeType) {
                case MAIN_WEB: {
                    themeData.setUserConfigurations(this.conversionHandler.convertList(ConfigurationVO.class, (Iterable)this.configurationService.listByThemeUsage(theme, ThemeUsage.LOGGED_USERS)));
                    themeData.setGuestConfigurations(this.conversionHandler.convertList(ConfigurationVO.class, (Iterable)this.configurationService.listByThemeUsage(theme, ThemeUsage.GUESTS)));
                    break;
                }
                case MOBILE: {
                    themeData.setConfigurations(this.conversionHandler.convertList(ConfigurationVO.class, (Iterable)this.configurationService.listByThemeUsage(theme, ThemeUsage.MOBILE)));
                    break;
                }
                case PAY: {
                    themeData.setConfigurations(this.conversionHandler.convertList(ConfigurationVO.class, (Iterable)this.configurationService.listByThemeUsage(theme, ThemeUsage.PAY)));
                    break;
                }
                case APP: {
                    themeData.setConfigurations(this.conversionHandler.convertList(ConfigurationVO.class, (Iterable)this.configurationService.listByThemeUsage(theme, ThemeUsage.APP)));
                }
            }
        }
        themeDTO = this.toDTO(theme);
        themeData.setDto((EntityDTO)themeDTO);
        if (themeType == ThemeType.MAIN_WEB) {
            themeData.setAdvancedContent(this.readResource(MAIN_VARIABLES));
            themeData.setCss(this.readResource(MAIN_STYLE));
        } else if (themeType == ThemeType.APP) {
            themeData.setAdvancedContent(this.readResource("/app-styles/src/_definitions.scss"));
        }
        return themeData;
    }

    protected String[] getExcludedPropertiesToDTO(Theme theme) {
        return this.EXCLUDED_PROPERTIES_TO_DTO;
    }

    @Override
    protected void onAfterSave(Theme theme, Theme theme2, Object object) {
        Long l = theme.getBasedOnId();
        if (theme2 == null && l != null) {
            Theme theme3 = (Theme)this.find(l);
            for (ThemeImage themeImage : theme3.getImages()) {
                try {
                    SerializableInputStream serializableInputStream = this.storedFileHandler.getContent((StoredFile)themeImage);
                    try {
                        this.themeImageService.saveImage(theme, themeImage.getType(), themeImage.getName(), (InputStream)serializableInputStream, themeImage.getContentType());
                    }
                    finally {
                        if (serializableInputStream == null) continue;
                        serializableInputStream.close();
                    }
                }
                catch (Exception exception) {
                    throw new IllegalStateException(exception);
                }
            }
        }
    }

    @Override
    protected void onBeforeRemove(Theme theme) {
        theme.getImages().forEach(themeImage -> this.storedFileHandler.remove(themeImage.getId().longValue()));
    }

    @Override
    protected Object onBeforeSave(Theme theme, Theme theme2) {
        if (this.isBuiltin(theme)) {
            throw new IllegalActionException();
        }
        theme.setLastModified(DateHelper.now());
        if (theme.getType() == ThemeType.PAY) {
            theme.setAdvancedDefinitions(null);
        }
        return null;
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QTheme)this.$).configuration().network(), true);
    }

    @Override
    protected Validator resolveValidator(ThemeDTO themeDTO) {
        Validator validator = new Validator();
        validator.property((Property)ThemeDTO.TYPE, ContentManagementKeys.Themes.TYPE).required();
        validator.property((Property)ThemeDTO.CONFIGURATION, ContentManagementKeys.Themes.CONFIGURATION).required();
        validator.property((Property)ThemeDTO.AUTHOR, ContentManagementKeys.Themes.AUTHOR).maxLength(255);
        ThemeType themeType = themeDTO.getType();
        org.cyclos.impl.utils.validation.Property property = validator.property((Property)ThemeDTO.ADVANCED_DEFINITIONS, ContentManagementKeys.Themes.ADVANCED_DEFINITIONS);
        org.cyclos.impl.utils.validation.Property property2 = validator.property((Property)ThemeDTO.CUSTOM_STYLE, ContentManagementKeys.Themes.CUSTOM_STYLE);
        if (themeType == ThemeType.MAIN_WEB) {
            property.add((PropertyValidation)new MainPropertyValidation(true));
            property2.add((PropertyValidation)new MainPropertyValidation(false));
        } else if (themeType == ThemeType.PAY) {
            property.maxLength(0);
            property2.add((PropertyValidation)new PayPropertyValidation());
        }
        for (ThemeDefinition themeDefinition : ThemeDefinition.values()) {
            org.cyclos.impl.utils.validation.Property property3 = validator.property((PropertyAccess)new ThemeDefinitionAccess(themeDefinition), themeDefinition.getMessageKey());
            if (themeType == themeDefinition.themeType()) {
                property3.required();
                if (themeDefinition.type() != ThemeDefinitionType.COLOR) continue;
                property3.color();
                continue;
            }
            property3.invalid();
        }
        return validator;
    }

    private void appendFont(StringBuilder stringBuilder) {
        String string = "../../fonts";
        stringBuilder.append("\n@font-face {");
        stringBuilder.append("\nfont-family: CyclosIcons;");
        stringBuilder.append("\nsrc: url('").append(string).append("/CyclosIcons.eot');");
        stringBuilder.append("\nsrc:");
        stringBuilder.append("\nurl('").append(string).append("/CyclosIcons.eot') format('embedded-opentype'),");
        stringBuilder.append("\nurl('").append(string).append("/CyclosIcons.woff') format('woff'),");
        stringBuilder.append("\nurl('").append(string).append("/CyclosIcons.ttf') format('truetype'),");
        stringBuilder.append("\nurl('").append(string).append("/CyclosIcons.svg#CyclosIcons') format('svg');");
        stringBuilder.append("\n}");
    }

    private synchronized String compileApp(Map<ThemeDefinition, String> map, String string2, String string3) throws IOException {
        File file = new File(this.cyclosProperties.getTempDir(), "themes/app");
        file.mkdirs();
        File file2 = this.ensureAppResource(file, "files");
        HashMap hashMap = new HashMap();
        Files.readAllLines(file2.toPath(), StandardCharsets.UTF_8).forEach(string -> {
            try {
                hashMap.put(string, this.ensureAppResource(file, (String)string));
            }
            catch (IOException iOException) {
                throw new UncheckedIOException(iOException);
            }
        });
        map = new HashMap<ThemeDefinition, String>(CollectionHelper.orEmpty(map));
        for (ThemeDefinition object2 : ThemeDefinition.values((ThemeType)ThemeType.APP)) {
            map.computeIfAbsent(object2, ThemeDefinition::defaultValue);
        }
        File file3 = (File)hashMap.get("src/styles/_custom-definitions.scss");
        ArrayList arrayList = new ArrayList();
        CollectionHelper.orEmpty(map).forEach((themeDefinition, string) -> arrayList.add(this.toScssVar((ThemeDefinition)themeDefinition) + ": " + string + ";"));
        StringHelper.forEachLine((String)string2, (boolean)false, arrayList::add);
        Files.write(file3.toPath(), arrayList, StandardCharsets.UTF_8, new OpenOption[0]);
        File file4 = (File)hashMap.get("src/styles/_custom.scss");
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add("@import 'definitions';");
        StringHelper.forEachLine((String)string3, (boolean)false, arrayList2::add);
        Files.write(file4.toPath(), arrayList2, StandardCharsets.UTF_8, new OpenOption[0]);
        File file5 = (File)hashMap.get("src/styles.scss");
        try {
            JDartSass exception = new JDartSass(this.getJDartSassInstallation(), Arrays.asList(file, new File(file, "src")));
            return exception.compile(new CompilationOptions(file5, this.getSassStyle()));
        }
        catch (Exception exception) {
            throw new CSSCompileException("Error compiling SASS", (Throwable)exception);
        }
    }

    private String compileApp(Theme theme) throws IOException {
        String string = this.compileApp(theme.getDefinitions(), theme.getAdvancedDefinitions(), theme.getCustomStyle());
        string = this.processImages(string, theme);
        return string;
    }

    private String compileMain(Map<ThemeDefinition, String> map, String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.readResource(MAIN_MIXINS)).append('\n');
        stringBuilder.append(this.getDefinitionsAsString(ThemeType.MAIN_WEB, map)).append('\n');
        stringBuilder.append(this.readResource(MAIN_VARIABLES)).append('\n');
        if (StringHelper.isNotBlank((Object)string)) {
            stringBuilder.append(string).append('\n');
        }
        stringBuilder.append(this.readResource(MAIN_STYLE)).append('\n');
        if (StringHelper.isNotBlank((Object)string2)) {
            stringBuilder.append(string2).append('\n');
        }
        stringBuilder.append(this.readResource(MAIN_FOOTER)).append('\n');
        try {
            JDartSass jDartSass = new JDartSass(this.getJDartSassInstallation());
            return jDartSass.compile(new CompilationOptions((CharSequence)stringBuilder, this.getSassStyle()));
        }
        catch (Exception exception) {
            throw new CSSCompileException("Error compiling SASS", (Throwable)exception);
        }
    }

    private String compileMain(Theme theme) throws IOException {
        String string = this.compileMain(theme.getDefinitions(), theme.getAdvancedDefinitions(), theme.getCustomStyle());
        string = this.processImages(string, theme);
        StringBuilder stringBuilder = new StringBuilder(string);
        this.appendFont(stringBuilder);
        return stringBuilder.toString();
    }

    private String compilePay(MaterialPalette materialPalette, MaterialPalette materialPalette2, MaterialPalette materialPalette3, boolean bl, String string) throws IOException {
        File file = new File(this.cyclosProperties.getTempDir(), "themes");
        file.mkdirs();
        this.ensurePayResource(file, "material.scss");
        this.ensurePayResource(file, "normalize.css");
        File file2 = this.ensurePayResource(file, "styles.scss");
        StringBuilder stringBuilder = new StringBuilder();
        FileUtils.lineIterator((File)file2, (String)"UTF-8").forEachRemaining(object -> {
            if (((String)object).contains("~@angular/material/theming")) {
                object = "@import 'material';";
            } else if (((String)object).contains("~normalize.css/normalize.css")) {
                object = "@import 'normalize.css';";
            } else if (((String)object).contains("$primary: mat-palette")) {
                object = "$primary: mat-palette(" + this.toSassVar(materialPalette) + ");";
            } else if (((String)object).contains("$accent: mat-palette")) {
                object = "$accent: mat-palette(" + this.toSassVar(materialPalette2) + ", A200, A100, A400);";
            } else if (((String)object).contains("$warn: mat-palette")) {
                object = "$warn: mat-palette(" + this.toSassVar(materialPalette3) + ");";
            } else if (((String)object).contains("$theme: mat-light-theme")) {
                object = "$theme: mat-" + (bl ? "dark" : "light") + "-theme($primary, $accent, $warn);";
            }
            stringBuilder.append((String)object).append('\n');
        });
        if (StringHelper.isNotBlank((Object)string)) {
            stringBuilder.append('\n').append(string);
        }
        try {
            JDartSass jDartSass = new JDartSass(this.getJDartSassInstallation(), Arrays.asList(file));
            return jDartSass.compile(new CompilationOptions((CharSequence)stringBuilder, this.getSassStyle()));
        }
        catch (Exception exception) {
            throw new CSSCompileException("Error compiling SASS", (Throwable)exception);
        }
    }

    private String compilePay(Theme theme) throws IOException {
        MaterialPalette materialPalette = this.getMaterialPalette(theme, ThemeDefinition.MATERIAL_PRIMARY);
        MaterialPalette materialPalette2 = this.getMaterialPalette(theme, ThemeDefinition.MATERIAL_ACCENT);
        MaterialPalette materialPalette3 = this.getMaterialPalette(theme, ThemeDefinition.MATERIAL_WARN);
        boolean bl = Boolean.parseBoolean((String)CollectionHelper.orEmpty((Map)theme.getDefinitions()).get(ThemeDefinition.MATERIAL_DARK));
        String string = this.compilePay(materialPalette, materialPalette2, materialPalette3, bl, theme.getCustomStyle());
        string = this.processImages(string, theme);
        return string;
    }

    private Theme convertAndCheck(Configuration configuration, ThemeVO themeVO, ThemeType themeType) {
        Theme theme = (Theme)this.conversionHandler.convert(Theme.class, (Object)themeVO);
        if (!(theme == null || theme.getType() == themeType && this.configurationHandler.getAncestors(configuration).contains(theme.getConfiguration()))) {
            throw new EntityNotFoundException(Theme.class, themeVO.getId());
        }
        return theme;
    }

    private String cssImageUrl(byte[] byArray) {
        byte[] byArray2 = Base64.getEncoder().encode(byArray);
        return "url(\"data:image/png;base64," + new String(byArray2) + "\")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doGetCSS(Theme theme, ThemeType themeType) {
        if (theme == null == (themeType == null)) {
            throw new IllegalArgumentException("Only theme or type can be specfied");
        }
        themeType = themeType == null ? theme.getType() : themeType;
        File file = new File(this.cyclosProperties.getTempDir(), "themes");
        file.mkdirs();
        String string = theme != null ? this.applicationHandler.getIdMask().apply(theme.getId()) + "_" + theme.getVersion() : themeType.name();
        File file2 = new File(file, string + ".css");
        if (this.cyclosProperties.isDevelopment()) {
            file2.delete();
        }
        String string2 = null;
        while (!file2.exists()) {
            ThemeServiceImpl themeServiceImpl = this;
            synchronized (themeServiceImpl) {
                try {
                    switch (themeType) {
                        case MAIN_WEB: {
                            string2 = theme != null ? this.compileMain(theme) : this.compileMain(Collections.emptyMap(), "", "");
                            break;
                        }
                        case APP: {
                            string2 = theme != null ? this.compileApp(theme) : this.compileApp(Collections.emptyMap(), "", "");
                            break;
                        }
                        case PAY: {
                            string2 = theme != null ? this.compilePay(theme) : this.compilePay(MaterialPalette.INDIGO, MaterialPalette.PINK, MaterialPalette.RED, false, "");
                            break;
                        }
                        default: {
                            return null;
                        }
                    }
                    FileUtils.writeStringToFile((File)file2, (String)string2, (Charset)StandardCharsets.UTF_8);
                    if (theme != null && theme.getLastModified() != null) {
                        file2.setLastModified(theme.getLastModified().getTime());
                    }
                }
                catch (IOException iOException) {
                    throw new UncheckedIOException("Error writing the CSS content to disk", iOException);
                }
            }
        }
        if (string2 == null) {
            try {
                string2 = FileUtils.readFileToString((File)file2, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException iOException) {
                throw new UncheckedIOException("Error reading the CSS content from disk", iOException);
            }
        }
        return string2;
    }

    private Theme doImport(Theme theme, Configuration configuration, String string, String string2, List<String> list) throws FileParsingException {
        Theme theme2 = this.readTheme(string2, theme != null);
        theme2.setConfiguration(configuration);
        theme2.setLastModified(DateHelper.now());
        theme2.setFileName(this.nextFileName(string));
        if (theme == null) {
            this.persist((IEntity)theme2);
        } else {
            this.updateBuiltinTheme(theme, theme2);
        }
        if (CollectionHelper.isNotEmpty(list)) {
            Pair pair;
            Object object;
            Theme theme3 = theme != null ? theme : theme2;
            HashMap<String, Pair> hashMap = new HashMap<String, Pair>();
            for (String object2 : list) {
                hashMap.put(FilenameUtils.removeExtension((String)ResourceHelper.getName((String)object2)), Pair.create((Object)object2, (Object)new File(object2)));
            }
            if (theme != null) {
                Iterator iterator = new ArrayList();
                for (ThemeImage themeImage : theme.getImages()) {
                    object = themeImage.getName();
                    pair = (Pair)hashMap.get(object);
                    Long l = null;
                    if (pair == null || (long)themeImage.getLength().intValue() != ((File)pair.getSecond()).length()) {
                        l = themeImage.getId();
                    } else {
                        hashMap.remove(object);
                    }
                    if (l == null) continue;
                    iterator.add((Long)l);
                }
                this.themeImageService.removeAll(iterator);
            }
            for (String string3 : hashMap.keySet()) {
                ThemeImage themeImage;
                themeImage = (Pair)hashMap.get(string3);
                object = (File)themeImage.getSecond();
                try {
                    pair = ThemeImageType.valueOf((String)StringUtils.trim((String)((File)object).getParentFile().getName().toUpperCase()));
                }
                catch (Exception exception) {
                    continue;
                }
                try {
                    this.themeImageService.saveImage(theme3, (ThemeImageType)pair, string3, ResourceHelper.openStream((String)((String)themeImage.getFirst())), ServerImageHelper.ImageType.PNG.getContentType());
                }
                catch (IOException iOException) {
                    throw new FileParsingException((Throwable)iOException);
                }
            }
        }
        return theme2;
    }

    private String doReadResource(String string) {
        try {
            return IOHelper.readContentAsString((URL)ResourceHelper.getResource((String)string));
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    private synchronized File ensureAppResource(File file, String string) throws IOException {
        File file2 = new File(file, string);
        if (!file2.exists() || file2.length() == 0L) {
            String string2 = "/app-styles/" + string;
            String string3 = ResourceHelper.readContent((String)string2);
            if (string3 == null) {
                throw new FileNotFoundException(string2);
            }
            if (string.startsWith("src")) {
                string3 = StringHelper.replace((String)string3, (String)"~bootstrap", (String)"bootstrap");
            }
            FileUtils.writeStringToFile((File)file2, (String)string3, (Charset)StandardCharsets.UTF_8);
        }
        return file2;
    }

    private synchronized File ensurePayResource(File file, String string) throws IOException {
        File file2 = new File(file, string);
        if (!file2.exists() || file2.length() == 0L) {
            String string2 = "/pay-styles/" + string;
            String string3 = ResourceHelper.readContent((String)string2);
            if (string3 == null) {
                throw new FileNotFoundException(string2);
            }
            FileUtils.writeStringToFile((File)file2, (String)string3, (Charset)StandardCharsets.UTF_8);
        }
        return file2;
    }

    private Theme findByFileName(String string) {
        DBQuery<?> dBQuery = this.from();
        if (QueryHelper.useParameter((Object)string)) {
            dBQuery.where((Predicate)((QTheme)this.$).fileName.eq((Object)string));
        }
        return (Theme)dBQuery.singleResult((Expression)this.$);
    }

    private Theme findByName(String string) {
        DBQuery<?> dBQuery = this.from();
        if (QueryHelper.useParameter((Object)string)) {
            dBQuery.where((Predicate)((QTheme)this.$).name.eq((Object)string));
        }
        return (Theme)dBQuery.singleResult((Expression)this.$);
    }

    private String getDefinitionsAsString(ThemeType themeType, Map<ThemeDefinition, String> map) {
        char c = this.getVariablePrefix(themeType);
        StringBuilder stringBuilder = new StringBuilder();
        for (ThemeDefinition themeDefinition : ThemeDefinition.values((ThemeType)themeType)) {
            String string = (String)ObjectHelper.defaultValue((Object)(map == null ? null : map.get(themeDefinition)), (Object)themeDefinition.defaultValue());
            stringBuilder.append(c).append(themeDefinition.name().toLowerCase().replace('_', '-')).append(": ").append(string).append(";\n");
        }
        return StringHelper.trimToNull((Object)stringBuilder);
    }

    private Installation getJDartSassInstallation() throws IOException {
        String string = this.cyclosProperties.getSassExecutable();
        if (string != null) {
            File file = new File(string);
            if (!file.exists()) {
                throw new IllegalStateException("Couldn't find the SASS executable at " + string);
            }
            return Installation.executable((File)file);
        }
        this.sassDir.mkdirs();
        Distribution distribution = new Distribution();
        distribution.setVersion(this.dartSassVersion);
        String string2 = distribution.getArchiveFileName();
        URL uRL = null;
        if (this.servletContext != null) {
            uRL = this.servletContext.getResource("/WEB-INF/" + string2);
        }
        if (uRL == null) {
            uRL = distribution.getArchiveUrl();
        }
        return Installation.downloading((URL)uRL, (File)this.sassDir, (File)this.sassDir);
    }

    private MaterialPalette getMaterialPalette(Theme theme, ThemeDefinition themeDefinition) {
        String string = theme == null ? null : (String)theme.getDefinitions().get(themeDefinition);
        return MaterialPalette.valueOf((String)((String)ObjectHelper.defaultValue((Object)string, (Object)themeDefinition.defaultValue())));
    }

    private CompilationOptions.Style getSassStyle() {
        return this.cyclosProperties.isDevelopment() ? CompilationOptions.Style.EXPANDED : CompilationOptions.Style.COMPRESSED;
    }

    private char getVariablePrefix(ThemeType themeType) {
        boolean bl = themeType == ThemeType.MOBILE;
        return bl ? (char)'@' : '$';
    }

    private ZipTheme getZipTheme(InputStream inputStream) {
        ZipTheme zipTheme = null;
        File file = this.cyclosProperties.newTempDir();
        try {
            ZipHelper.extract((InputStream)inputStream, (File)file, null);
            File file2 = new File(file, THEME_DESCRIPTOR);
            if (!file2.exists()) {
                throw new FileParsingException("No descriptor file: theme.xml");
            }
            Collection collection = FileUtils.listFiles((File)file, (IOFileFilter)ServerImageHelper.FILE_CONTENT_FILTER, (IOFileFilter)TrueFileFilter.INSTANCE);
            ArrayList<String> arrayList = new ArrayList<String>(collection.size());
            for (File file3 : collection) {
                arrayList.add(file3.getAbsolutePath());
            }
            zipTheme = new ZipTheme(file2.getAbsolutePath(), arrayList, file);
        }
        catch (FileParsingException fileParsingException) {
            throw fileParsingException;
        }
        catch (Exception exception) {
            throw new FileParsingException((Throwable)exception);
        }
        finally {
            IOHelper.close((Closeable)inputStream);
        }
        return zipTheme;
    }

    private String nextFileName(String string) {
        string = FilenameUtils.removeExtension((String)string);
        Object object = string;
        int n = 1;
        while (this.findByFileName((String)object) != null) {
            object = string + n++;
        }
        return object;
    }

    private String nextName(String string) {
        Object object = string;
        int n = 1;
        while (this.findByName((String)object) != null) {
            object = string + n++;
        }
        return object;
    }

    private String processImages(String string, Theme theme) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher = URL_PATTERN.matcher(string);
        while (matcher.find()) {
            String string2 = matcher.group(1);
            if (string2.isEmpty()) {
                matcher.appendReplacement(stringBuffer, Matcher.quoteReplacement(string2));
                continue;
            }
            Object object = StringUtils.strip((String)string2, (String)"\"'");
            try {
                byte[] byArray = this.themeImageService.readImageContent(theme.getId(), ThemeImageType.CUSTOM, (String)object);
                object = this.cssImageUrl(byArray);
            }
            catch (Exception exception) {
                object = "url(" + string2 + ")";
            }
            matcher.appendReplacement(stringBuffer, Matcher.quoteReplacement((String)object));
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    private String readResource(String string) {
        if (this.cyclosProperties.isDevelopment()) {
            return this.doReadResource(string);
        }
        return this.resources.computeIfAbsent(string, this::doReadResource);
    }

    private Theme readTheme(String string, boolean bl) throws FileParsingException {
        Element element;
        Document document;
        InputStream inputStream = null;
        try {
            inputStream = ResourceHelper.openStream((String)string);
            document = XmlHelper.parse((InputStream)inputStream);
            element = document.getDocumentElement();
        }
        catch (Exception exception) {
            throw new FileParsingException((Throwable)exception);
        }
        finally {
            IOHelper.close((Closeable)inputStream);
        }
        document = new Theme();
        XmlHelper.fillPropertiesWithSubElements((Object)document, (Element)element, (String[])THEME_PROPERTIES);
        if (StringHelper.isBlank((Object)document.getName())) {
            document.setName(THEME_TAG);
        }
        if (StringHelper.isBlank((Object)document.getType())) {
            document.setType(ThemeType.MAIN_WEB);
        }
        if (!bl) {
            document.setName(this.nextName(document.getName()));
        }
        HashMap<ThemeDefinition, String> hashMap = new HashMap<ThemeDefinition, String>();
        Element element2 = XmlHelper.getFirst((Element)element, (String)DEFINITIONS_TAG);
        if (element2 != null) {
            for (Element element3 : XmlHelper.iterate((Element)element2, (String)DEFINITION_TAG)) {
                ThemeDefinition themeDefinition;
                String string2 = XmlHelper.getText((Element)element3, (String)NAME_TAG);
                try {
                    themeDefinition = ThemeDefinition.valueOf((String)StringHelper.trim((Object)string2).toUpperCase());
                }
                catch (Exception exception) {
                    throw new FileParsingException("Invalid theme definition name: " + string2);
                }
                String string3 = StringHelper.trimToNull((Object)XmlHelper.getText((Element)element3, (String)VALUE_TAG));
                try {
                    switch (themeDefinition.type()) {
                        case COLOR: {
                            string3 = ColorHelper.formatRGBasHex((int[])ColorHelper.parse((String)string3));
                            break;
                        }
                        case GRADIENT: {
                            string3 = GradientType.valueOf((String)string3.toUpperCase()).name().toLowerCase();
                            break;
                        }
                    }
                }
                catch (Exception exception) {
                    string3 = null;
                }
                if (string3 == null) continue;
                hashMap.put(themeDefinition, string3);
            }
        }
        document.setDefinitions(hashMap);
        return document;
    }

    private String toSassVar(MaterialPalette materialPalette) {
        return "$mat-" + materialPalette.name().toLowerCase().replace('_', '-');
    }

    private String toScssVar(ThemeDefinition themeDefinition) {
        return "$" + StringHelper.removeStart((String)themeDefinition.name(), (String)"APP_").replace('_', '-').toLowerCase();
    }

    private void updateBuiltinTheme(Theme theme, Theme theme2) {
        String string;
        Map map = theme2.getDefinitions();
        Map map2 = theme.getDefinitions();
        boolean bl = map2.keySet().removeIf(themeDefinition -> !map.containsKey(themeDefinition));
        for (Map.Entry beanWrapper2 : map.entrySet()) {
            ThemeDefinition themeDefinition2 = (ThemeDefinition)beanWrapper2.getKey();
            String string2 = (String)map2.get(themeDefinition2);
            string = (String)beanWrapper2.getValue();
            if (string == null) {
                map2.remove(themeDefinition2);
                continue;
            }
            if (Objects.equals(string2, string)) continue;
            bl = true;
            map2.put(themeDefinition2, string);
        }
        BeanWrapper beanWrapper3 = InvocationContext.wrap((Object)theme);
        BeanWrapper beanWrapper = InvocationContext.wrap((Object)theme2);
        for (String string2 : new ThemeDTO().properties()) {
            String string3;
            String string4;
            if (!String.class.equals((Object)string2.getType()) || Objects.equals(string4 = (String)beanWrapper3.getPropertyValue(string = string2.getName()), string3 = (String)beanWrapper.getPropertyValue(string))) continue;
            bl = true;
            beanWrapper3.setPropertyValue(string, (Object)string3);
        }
        if (bl) {
            theme.setLastModified(new Date());
        }
    }

    private static /* synthetic */ boolean lambda$applyThemes$fe78a5f7$4(Long l, String string, ConfigurationAccessorCacheKey configurationAccessorCacheKey) {
        return configurationAccessorCacheKey.matchesNetworkAndMethod(l, string);
    }

    private static /* synthetic */ boolean lambda$applyThemes$fe78a5f7$3(Long l, String string, ConfigurationAccessorCacheKey configurationAccessorCacheKey) {
        return configurationAccessorCacheKey.matchesNetworkAndMethod(l, string);
    }

    private static /* synthetic */ boolean lambda$applyThemes$fe78a5f7$2(Long l, String string, ConfigurationAccessorCacheKey configurationAccessorCacheKey) {
        return configurationAccessorCacheKey.matchesNetworkAndMethod(l, string);
    }

    private static /* synthetic */ boolean lambda$applyThemes$fe78a5f7$1(Long l, String string, ConfigurationAccessorCacheKey configurationAccessorCacheKey) {
        return configurationAccessorCacheKey.matchesNetworkAndMethod(l, string);
    }

    private class ZipTheme {
        private String path;
        private List<String> resources;
        private File file;

        public ZipTheme(String string, List<String> list, File file) {
            this.path = string;
            this.resources = list;
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }

        public String getPath() {
            return this.path;
        }

        public List<String> getResources() {
            return this.resources;
        }
    }

    private class MainPropertyValidation
    extends BasePropertyValidation {
        private boolean isAdvanced;

        public MainPropertyValidation(boolean bl) {
            super(new ValidationError(ContentManagementKeys.Themes.ERROR_INVALID_SASS));
            this.isAdvanced = bl;
        }

        protected boolean isValid(Object object, Object object2, Object object3) {
            try {
                String string = this.isAdvanced ? object3.toString() : null;
                String string2 = !this.isAdvanced ? object3.toString() : null;
                ThemeServiceImpl.this.compileMain(null, string, string2);
                return true;
            }
            catch (Exception exception) {
                ThemeServiceImpl.this.getLogger().error("Invalid theme SASS content", (Throwable)exception);
                return false;
            }
        }
    }

    private class PayPropertyValidation
    extends BasePropertyValidation {
        public PayPropertyValidation() {
            super(new ValidationError(ContentManagementKeys.Themes.ERROR_INVALID_SASS));
        }

        protected boolean isValid(Object object, Object object2, Object object3) {
            try {
                ThemeServiceImpl.this.compilePay(MaterialPalette.BLUE, MaterialPalette.LIGHT_BLUE, MaterialPalette.RED, false, (String)object3);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
    }
}

