/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.contentmanagement;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.imageio.ImageIO;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.contentmanagement.QThemeImage;
import org.cyclos.entities.contentmanagement.Theme;
import org.cyclos.entities.contentmanagement.ThemeImage;
import org.cyclos.entities.utils.StoredFile;
import org.cyclos.impl.ApplicationHandler;
import org.cyclos.impl.access.InitializationServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.contentmanagement.ThemeImageCacheKey;
import org.cyclos.impl.contentmanagement.ThemeImageServiceLocal;
import org.cyclos.impl.storage.StoredFileHandler;
import org.cyclos.impl.system.BaseImageServiceImpl;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.utils.SerializablePredicate;
import org.cyclos.impl.utils.cache.Cache;
import org.cyclos.impl.utils.cache.CacheHandler;
import org.cyclos.impl.utils.cache.CacheType;
import org.cyclos.impl.utils.cache.MapAccessorCacheValue;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.contentmanagement.themes.MobileThemeImage;
import org.cyclos.model.contentmanagement.themes.NewThemeImageParams;
import org.cyclos.model.contentmanagement.themes.ThemeBackground;
import org.cyclos.model.contentmanagement.themes.ThemeImageEnum;
import org.cyclos.model.contentmanagement.themes.ThemeImageType;
import org.cyclos.model.contentmanagement.themes.ThemeImageVO;
import org.cyclos.model.contentmanagement.themes.ThemeMapMarker;
import org.cyclos.model.contentmanagement.themes.ThemeVO;
import org.cyclos.model.system.images.ImageNature;
import org.cyclos.server.utils.ResourceHelper;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ContentType;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ThemeImageServiceImpl
extends BaseImageServiceImpl<ThemeImage, QThemeImage, NewThemeImageParams>
implements ThemeImageServiceLocal {
    private static final String IMAGES_PREFIX = "/themeImages/";
    private static final List<ThemeImageEnum> IMAGE_ENUM_ITEMS;
    private static final String IMAGE_VO_CACHE_KEY = "vo";
    private static final String CONTENT_CACHE_KEY = "content";
    @Autowired
    private StoredFileHandler storedFileHandler;
    @Autowired
    private CacheHandler cacheHandler;
    private Cache<ThemeImageCacheKey, MapAccessorCacheValue> cache;
    @Autowired
    private ApplicationHandler applicationHandler;
    @Autowired
    private InitializationServiceLocal initializationService;

    public ThemeImageServiceImpl() {
        super(ImageNature.THEME, ThemeImage.class, QThemeImage.themeImage);
    }

    public String getImageUrl(Theme theme, ThemeImageType themeImageType, String string) {
        ConfigurationAccessor configurationAccessor;
        SessionData sessionData = this.getSessionData();
        if (theme == null) {
            configurationAccessor = sessionData.getConfiguration();
            theme = sessionData.isLoggedIn() ? configurationAccessor.getUsersTheme() : configurationAccessor.getGuestsTheme();
        }
        configurationAccessor = this.getImageVO(theme.getId(), themeImageType, string);
        Long l = this.applicationHandler.getIdMask().apply(theme.getId());
        String string2 = configurationAccessor.getLastModifiedInMillis();
        if (string2 == null) {
            string2 = this.initializationService.getResourceCacheKey();
        }
        return StringHelper.removeEnd((String)sessionData.getRequestData().getBaseUrl(), (String)"/") + "/content/themes/" + l + "/image?type=" + themeImageType.name() + "&name=" + string + "&mod=" + string2;
    }

    public ThemeImageVO getImageVO(Long l, ThemeImageType themeImageType, String string) {
        ReadFromCacheResult readFromCacheResult = this.readFromCache(l, themeImageType, string);
        Theme theme = readFromCacheResult.theme;
        ThemeImageVO themeImageVO = readFromCacheResult.vo;
        themeImageVO.setTheme((ThemeVO)this.conversionHandler.convert(ThemeVO.class, (Object)theme));
        themeImageVO.setLastModified(this.toDateTime(theme.getLastModified()));
        themeImageVO.setLastModifiedInMillis(theme.getLastModifiedInMillis());
        return themeImageVO;
    }

    @PostConstruct
    public void initialize() {
        this.cache = this.cacheHandler.getCache(CacheType.THEME_IMAGES);
    }

    public List<ThemeImageVO> list(Long l, Set<ThemeImageType> set) {
        ThemeImageEnum themeImageEnum;
        ThemeImageVO themeImageVO;
        Theme theme = this.find(Theme.class, l);
        if (set == null) {
            return Collections.emptyList();
        }
        set = set.stream().filter(themeImageType -> themeImageType.isSupported(theme.getType())).collect(Collectors.toSet());
        QThemeImage qThemeImage = QThemeImage.themeImage;
        List list = ((DBQuery)this.from(new EntityPath[]{qThemeImage}).where(new Predicate[]{qThemeImage.theme().id.eq((Object)l), qThemeImage.type.in(set)})).list((Expression)qThemeImage);
        ArrayList<ThemeImageVO> arrayList = new ArrayList<ThemeImageVO>();
        HashMap<ThemeImageEnum, ThemeImageVO> hashMap = new HashMap<ThemeImageEnum, ThemeImageVO>();
        for (ThemeImage themeImage : list) {
            themeImageVO = this.toImageVO(themeImage);
            themeImageEnum = themeImage.getItem();
            if (themeImageEnum == null) {
                arrayList.add(themeImageVO);
                continue;
            }
            hashMap.put(themeImage.getItem(), themeImageVO);
        }
        for (ThemeImageEnum themeImageEnum2 : IMAGE_ENUM_ITEMS) {
            themeImageVO = ThemeImageType.getByEnumItem((ThemeImageEnum)themeImageEnum2);
            if (!set.contains(themeImageVO)) continue;
            themeImageEnum = (ThemeImageVO)hashMap.get(themeImageEnum2);
            if (themeImageEnum == null) {
                ReadFromCacheResult readFromCacheResult = this.readFromCache(l, (ThemeImageType)themeImageVO, themeImageEnum2.name());
                themeImageEnum = readFromCacheResult.vo;
            }
            arrayList.add((ThemeImageVO)themeImageEnum);
        }
        return arrayList;
    }

    @Override
    public ThemeImage newImage(NewThemeImageParams newThemeImageParams) {
        throw new UnsupportedOperationException("save() was overridden: this method is never invoked");
    }

    public byte[] readImageContent(Long l, ThemeImageType themeImageType, String string) throws EntityNotFoundException {
        ReadFromCacheResult readFromCacheResult = this.readFromCache(l, themeImageType, string);
        return readFromCacheResult.content;
    }

    @Override
    public void removeAll(Collection<Long> collection) throws FrameworkException {
        if (CollectionHelper.isNotEmpty(collection)) {
            for (Long l : collection) {
                this.remove(l);
            }
        }
    }

    public final ThemeImageVO save(NewThemeImageParams newThemeImageParams, String string, SerializableInputStream serializableInputStream, String string2) throws FrameworkException {
        Theme theme = this.find(Theme.class, newThemeImageParams.getThemeId());
        ThemeImage themeImage = this.saveImage(theme, newThemeImageParams.getType(), string, (InputStream)serializableInputStream, string2);
        return (ThemeImageVO)this.conversionHandler.convert(ThemeImageVO.class, (Object)themeImage);
    }

    public ThemeImage saveImage(Theme theme, ThemeImageType themeImageType, String string, InputStream inputStream, String string2) {
        boolean bl;
        if (themeImageType != ThemeImageType.CUSTOM && !themeImageType.isSupported(theme.getType())) {
            throw new IllegalActionException(String.format("Invalid theme image %s for theme type %s", themeImageType, theme.getType()));
        }
        ThemeImage themeImage = this.findImage(theme.getId(), themeImageType, string);
        boolean bl2 = bl = themeImage == null;
        if (themeImage == null) {
            themeImage = new ThemeImage();
            themeImage.setTheme(theme);
            themeImage.setType(themeImageType);
            themeImage.setName(string);
        }
        SerializableInputStream serializableInputStream = inputStream instanceof SerializableInputStream ? (SerializableInputStream)inputStream : new SerializableInputStream(inputStream);
        this.setDataAndPersist(themeImage, serializableInputStream, string2);
        if (bl) {
            theme.getImages().add(themeImage);
        }
        theme.setLastModified(new Date());
        Long l = theme.getId();
        this.cacheHandler.schedulePartialEvict(CacheType.THEME_IMAGES, (SerializablePredicate & Serializable)themeImageCacheKey -> themeImageCacheKey.matches(l, themeImageType, string));
        return themeImage;
    }

    @Override
    protected void onAfterRemove(ThemeImage themeImage) {
        Theme theme = themeImage.getTheme();
        theme.getImages().remove(themeImage);
        theme.setLastModified(new Date());
        Long l = theme.getId();
        ThemeImageType themeImageType = themeImage.getType();
        String string = themeImage.getName();
        this.cacheHandler.schedulePartialEvict(CacheType.THEME_IMAGES, (SerializablePredicate & Serializable)themeImageCacheKey -> themeImageCacheKey.matches(l, themeImageType, string));
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QThemeImage)this.$).theme().configuration().network(), true);
    }

    private Map<String, Object> doReadCache(Theme theme, ThemeImageType themeImageType, String string) {
        ThemeImageCacheKey themeImageCacheKey = new ThemeImageCacheKey(SimpleEntity.id((SimpleEntity)theme), themeImageType, string);
        MapAccessorCacheValue mapAccessorCacheValue = (MapAccessorCacheValue)this.cache.get((Serializable)themeImageCacheKey, () -> {
            ThemeImageEnum themeImageEnum;
            try {
                themeImageEnum = themeImageType == ThemeImageType.CUSTOM ? null : themeImageType.getEnumItem(string);
            }
            catch (Exception exception) {
                throw new EntityNotFoundException(ThemeImage.class);
            }
            Long l = themeImageCacheKey.getThemeId();
            if (l == null) {
                if (themeImageType == ThemeImageType.CUSTOM) {
                    throw new EntityNotFoundException(ThemeImage.class);
                }
                if (themeImageType == ThemeImageType.CUSTOM) {
                    throw new EntityNotFoundException(ThemeImage.class);
                }
                byte[] byArray = ResourceHelper.readBytes((String)this.getOriginalIconResource(themeImageEnum));
                if (byArray == null) {
                    throw new EntityNotFoundException(ThemeImage.class);
                }
                BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(byArray));
                if (bufferedImage == null) {
                    throw new IOException("Couldn't read the original theme image " + String.valueOf(themeImageEnum) + " with type " + String.valueOf(themeImageType));
                }
                ThemeImageVO themeImageVO = new ThemeImageVO();
                themeImageVO.setType(themeImageType);
                themeImageVO.setName(themeImageEnum.name());
                themeImageVO.setCustomized(false);
                themeImageVO.setContentType(ContentType.PNG.getMimeType());
                themeImageVO.setWidth(bufferedImage.getWidth());
                themeImageVO.setHeight(bufferedImage.getHeight());
                return MapAccessorCacheValue.create(Map.of(IMAGE_VO_CACHE_KEY, themeImageVO, CONTENT_CACHE_KEY, byArray));
            }
            ThemeImage themeImage = this.findImage(l, themeImageType, string);
            if (themeImage == null) {
                return MapAccessorCacheValue.create(Collections.emptyMap());
            }
            ThemeImageVO themeImageVO = this.toImageVO(themeImage);
            byte[] byArray = this.storedFileHandler.getBytes((StoredFile)themeImage);
            return MapAccessorCacheValue.create(Map.of(IMAGE_VO_CACHE_KEY, themeImageVO, CONTENT_CACHE_KEY, byArray));
        });
        return (Map)mapAccessorCacheValue.unwrap(this.getApplicationContext());
    }

    private ThemeImage findImage(Long l, ThemeImageType themeImageType, String string) {
        QThemeImage qThemeImage = QThemeImage.themeImage;
        return (ThemeImage)((DBQuery)this.from(new EntityPath[]{qThemeImage}).where(new Predicate[]{qThemeImage.theme().id.eq((Object)l), qThemeImage.type.eq((Object)themeImageType), qThemeImage.name.eq((Object)string)})).singleResult((Expression)qThemeImage);
    }

    private String getOriginalIconResource(ThemeImageEnum themeImageEnum) {
        ThemeImageType themeImageType = ThemeImageType.getByEnumItem((ThemeImageEnum)themeImageEnum);
        return IMAGES_PREFIX + themeImageType.name() + "/" + themeImageEnum.name() + ".png";
    }

    private ReadFromCacheResult readFromCache(Long l, ThemeImageType themeImageType, String string) {
        Object object;
        Theme theme = l == null ? ((object = this.getSessionData()).isGuest() ? object.getConfiguration().getGuestsTheme() : object.getConfiguration().getUsersTheme()) : this.find(Theme.class, l);
        object = this.doReadCache(theme, themeImageType, string);
        if (object.isEmpty()) {
            object = this.doReadCache(null, themeImageType, string);
        }
        return new ReadFromCacheResult(theme, (ThemeImageVO)object.get(IMAGE_VO_CACHE_KEY), (byte[])object.get(CONTENT_CACHE_KEY));
    }

    private ThemeImageVO toImageVO(ThemeImage themeImage) {
        ThemeImageVO themeImageVO = (ThemeImageVO)this.conversionHandler.convert(ThemeImageVO.class, (Object)themeImage);
        themeImageVO.setCustomized(true);
        return themeImageVO;
    }

    static {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.addAll(Arrays.asList(ThemeBackground.values()));
        arrayList.addAll(Arrays.asList(ThemeMapMarker.values()));
        arrayList.addAll(Arrays.asList(MobileThemeImage.values()));
        IMAGE_ENUM_ITEMS = Collections.unmodifiableList(arrayList);
    }

    private static class ReadFromCacheResult {
        private Theme theme;
        private ThemeImageVO vo;
        private byte[] content;

        public ReadFromCacheResult(Theme theme, ThemeImageVO themeImageVO, byte[] byArray) {
            this.theme = theme;
            this.vo = themeImageVO;
            this.content = byArray;
        }
    }
}

