/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.contentmanagement;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.cyclos.entities.contentmanagement.QSystemCustomImage;
import org.cyclos.entities.contentmanagement.SystemCustomImage;
import org.cyclos.entities.contentmanagement.SystemImageCategory;
import org.cyclos.impl.ApplicationUpgradeInitializationListener;
import org.cyclos.impl.contentmanagement.SystemCustomImageServiceLocal;
import org.cyclos.impl.contentmanagement.SystemImageCategoryServiceLocal;
import org.cyclos.impl.sql.postgresql.querydsl.QuerydslConfiguration;
import org.cyclos.impl.sql.postgresql.querytypes.SImportedSystemImages;
import org.cyclos.impl.system.BaseCustomImageServiceImpl;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.impl.utils.QueryHelper;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.contentmanagement.imagecategories.SystemImageCategoryVO;
import org.cyclos.model.system.images.AccessibleSystemImageCategoriesData;
import org.cyclos.model.system.images.FullSystemImageCategoryListData;
import org.cyclos.model.system.images.FullSystemImagesListData;
import org.cyclos.model.system.images.ImageNature;
import org.cyclos.model.system.images.ImageVO;
import org.cyclos.model.system.images.SystemCustomImageDTO;
import org.cyclos.model.system.images.SystemCustomImageQuery;
import org.cyclos.model.system.images.SystemCustomImageVO;
import org.cyclos.model.system.images.SystemCustomImagesSearchData;
import org.cyclos.server.utils.ResourceHelper;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.server.utils.ServerImageHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.MutableObject;
import org.cyclos.utils.Page;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class SystemCustomImageServiceImpl
extends BaseCustomImageServiceImpl<SystemCustomImage, SystemImageCategory, QSystemCustomImage, SystemImageCategoryVO>
implements SystemCustomImageServiceLocal,
ApplicationUpgradeInitializationListener {
    private static final String DEFAULT_SYSTEM_IMAGES_DIR = "/systemImages";
    @Autowired
    private SystemImageCategoryServiceLocal systemImageCategoryService;
    @Autowired
    private JdbcTemplate jdbcTemplate;

    public SystemCustomImageServiceImpl() {
        super(ImageNature.SYSTEM_CUSTOM, SystemCustomImage.class, SystemImageCategory.class, QSystemCustomImage.systemCustomImage, QSystemCustomImage.systemCustomImage.category());
    }

    public AccessibleSystemImageCategoriesData getAccessibleImageCategories() throws FrameworkException {
        AccessibleSystemImageCategoriesData accessibleSystemImageCategoriesData = new AccessibleSystemImageCategoriesData();
        accessibleSystemImageCategoriesData.setCategoriesView(this.conversionHandler.convertList(SystemImageCategoryVO.class, (Iterable)this.systemImageCategoryService.listVisible()));
        accessibleSystemImageCategoriesData.setCategoriesManage(this.conversionHandler.convertList(SystemImageCategoryVO.class, (Iterable)this.systemImageCategoryService.listManageable()));
        return accessibleSystemImageCategoriesData;
    }

    public FullSystemImagesListData getFullListData() throws FrameworkException {
        FullSystemImagesListData fullSystemImagesListData = new FullSystemImagesListData();
        fullSystemImagesListData.setCategories(new ArrayList());
        ProductsAccessor productsAccessor = this.getSessionData().getProducts();
        List list = productsAccessor.admin().getSystemImageCategoriesView();
        List list2 = productsAccessor.admin().getSystemImageCategoriesManage();
        if (CollectionHelper.isNotEmpty((Iterable)list)) {
            List list3 = ((DBQuery)((DBQuery)this.from(this.$).where((Predicate)((QSystemCustomImage)this.$).category().in((Collection)list))).orderBy(new OrderSpecifier[]{((QSystemCustomImage)this.$).category().order.asc(), ((QSystemCustomImage)this.$).name.asc()})).list((Expression)this.$);
            for (SystemImageCategory systemImageCategory : list) {
                FullSystemImageCategoryListData fullSystemImageCategoryListData = new FullSystemImageCategoryListData();
                fullSystemImageCategoryListData.setCategory((SystemImageCategoryVO)this.conversionHandler.convert(SystemImageCategoryVO.class, (Object)systemImageCategory));
                fullSystemImageCategoryListData.setEditable(list2.contains(systemImageCategory));
                fullSystemImageCategoryListData.setImages(list3.stream().filter(systemCustomImage -> systemImageCategory.equals((Object)systemCustomImage.getCategory())).map(this.conversionHandler.convertingFunction(ImageVO.class, new Object[0])).collect(Collectors.toList()));
                fullSystemImagesListData.getCategories().add(fullSystemImageCategoryListData);
            }
        }
        return fullSystemImagesListData;
    }

    public SystemCustomImagesSearchData getSearchData() throws FrameworkException {
        SystemCustomImagesSearchData systemCustomImagesSearchData = new SystemCustomImagesSearchData();
        List list = this.conversionHandler.convertList(SystemImageCategoryVO.class, (Iterable)this.systemImageCategoryService.listVisible());
        List list2 = this.conversionHandler.convertList(SystemImageCategoryVO.class, (Iterable)this.systemImageCategoryService.listManageable());
        systemCustomImagesSearchData.setCategoriesView(list);
        systemCustomImagesSearchData.setCategoriesManage(list2);
        SystemCustomImageQuery systemCustomImageQuery = (SystemCustomImageQuery)QueryHelper.newQuery(SystemCustomImageQuery.class);
        if (!StringHelper.isBlank((Object)list)) {
            systemCustomImageQuery.setCategory((SystemImageCategoryVO)CollectionHelper.first((Iterable)list));
        }
        systemCustomImagesSearchData.setQuery((QueryParameters)systemCustomImageQuery);
        return systemCustomImagesSearchData;
    }

    public void onApplicationUpgradeInitialization() {
        SImportedSystemImages sImportedSystemImages = SImportedSystemImages.importedSystemImages;
        MutableObject mutableObject = new MutableObject();
        List list = (List)this.jdbcTemplate.execute(connection -> ((SQLQuery)new SQLQuery(connection, QuerydslConfiguration.get()).from((Expression)sImportedSystemImages)).select((Expression)sImportedSystemImages.name).fetch());
        try {
            ResourceHelper.listResources((String)DEFAULT_SYSTEM_IMAGES_DIR).stream().filter(string -> {
                String string2 = ResourceHelper.getName((String)string);
                return ServerImageHelper.ImageType.hasImageExtension((String)string2) && !list.contains(string2);
            }).forEach(string -> {
                SerializableInputStream serializableInputStream;
                if (!mutableObject.isPresent()) {
                    mutableObject.set((Object)new SystemImageCategoryVO(this.systemImageCategoryService.ensureDefaultImageCategory().getId()));
                }
                String string2 = ResourceHelper.getName((String)string);
                try {
                    serializableInputStream = new SerializableInputStream(ResourceHelper.openStream((String)string));
                }
                catch (IOException iOException) {
                    throw new UncheckedIOException(iOException);
                }
                String string3 = string2.substring(0, string2.lastIndexOf("."));
                this.save((SystemImageCategoryVO)mutableObject.get(), string3, serializableInputStream, ServerImageHelper.ImageType.getByFileName((String)string2).getContentType());
                this.jdbcTemplate.execute(connection -> {
                    ((SQLInsertClause)new SQLInsertClause(connection, QuerydslConfiguration.get(), (RelationalPath)sImportedSystemImages).set((Path)sImportedSystemImages.name, (Object)string2)).execute();
                    return null;
                });
            });
        }
        catch (Exception exception) {
            throw new IllegalStateException("Error importing default system images", exception);
        }
    }

    public void saveCategory(Long l, SystemImageCategoryVO systemImageCategoryVO) throws FrameworkException {
        SystemCustomImage systemCustomImage = (SystemCustomImage)this.find(l);
        SystemImageCategory systemImageCategory = (SystemImageCategory)this.conversionHandler.convert(SystemImageCategory.class, (Object)systemImageCategoryVO);
        systemCustomImage.setCategory(systemImageCategory);
    }

    public Long saveDetails(SystemCustomImageDTO systemCustomImageDTO) throws FrameworkException {
        SystemCustomImage systemCustomImage = (SystemCustomImage)this.conversionHandler.convert(SystemCustomImage.class, (Object)systemCustomImageDTO);
        return systemCustomImage.getId();
    }

    public Page<SystemCustomImageVO> search(SystemCustomImageQuery systemCustomImageQuery) throws FrameworkException {
        SystemImageCategory systemImageCategory = (SystemImageCategory)this.conversionHandler.convert(SystemImageCategory.class, (Object)systemCustomImageQuery.getCategory());
        return ((DBQuery)((DBQuery)this.from(this.$).where((Predicate)(systemImageCategory == null ? ((QSystemCustomImage)this.$).id.isNotNull() : ((QSystemCustomImage)this.$).category().eq((Object)systemImageCategory)))).orderBy(((QSystemCustomImage)this.$).name.asc())).page(SystemCustomImageVO.class, (QueryParameters)systemCustomImageQuery, (Expression)this.$);
    }

    @Override
    protected boolean isCategoryActive(SystemImageCategory systemImageCategory) {
        return true;
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QSystemCustomImage)this.$).category().network(), true);
    }

    @Override
    protected int resolveMaxImages(SystemImageCategory systemImageCategory) {
        return -1;
    }
}

