/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.contentmanagement;

import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.time.DateUtils;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.contentmanagement.GuestHomeContent;
import org.cyclos.entities.contentmanagement.MenuItem;
import org.cyclos.entities.contentmanagement.QFooterContent;
import org.cyclos.entities.contentmanagement.QHeaderContent;
import org.cyclos.entities.marketplace.AdCustomField;
import org.cyclos.entities.marketplace.AdCustomFieldValue;
import org.cyclos.entities.marketplace.BasicAd;
import org.cyclos.entities.system.Configuration;
import org.cyclos.entities.system.CustomFieldValue;
import org.cyclos.entities.system.Language;
import org.cyclos.entities.system.QConfiguration;
import org.cyclos.entities.system.QNetwork;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.contentmanagement.MenuEntryServiceLocal;
import org.cyclos.impl.contentmanagement.SitemapServiceLocal;
import org.cyclos.impl.marketplace.AdCustomFieldServiceLocal;
import org.cyclos.impl.marketplace.AdServiceLocal;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.utils.RichTextHandler;
import org.cyclos.impl.utils.formatting.FormatterImpl;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.INamedEntity;
import org.cyclos.model.access.RequestData;
import org.cyclos.model.contentmanagement.contentitems.MenuItemDTO;
import org.cyclos.model.contentmanagement.staticcontents.GuestHomeContentDTO;
import org.cyclos.model.marketplace.MarketplaceKeys;
import org.cyclos.model.utils.ICurrencyAmount;
import org.cyclos.server.model.contentmanagement.contentitems.SitemapData;
import org.cyclos.server.model.contentmanagement.contentitems.SitemapIndexData;
import org.cyclos.server.model.contentmanagement.contentitems.SitemapIndexItemVO;
import org.cyclos.server.model.contentmanagement.contentitems.SitemapItemContentVO;
import org.cyclos.server.model.contentmanagement.contentitems.SitemapItemType;
import org.cyclos.server.model.contentmanagement.contentitems.SitemapItemVO;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.coercion.CoercionHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SitemapServiceImpl
extends BaseServiceImpl
implements SitemapServiceLocal {
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    private MenuEntryServiceLocal menuEntryService;
    @Autowired
    private RichTextHandler richTextHandler;
    @Autowired
    private AdServiceLocal adService;
    @Autowired
    private AdCustomFieldServiceLocal adCustomFieldService;

    public SitemapItemContentVO getContent(SitemapItemType sitemapItemType, Long l) throws FrameworkException {
        String string;
        String string2;
        String string3;
        GuestHomeContent guestHomeContent;
        ConfigurationAccessor configurationAccessor = this.getConfiguration();
        Language language = configurationAccessor.getLanguage();
        SitemapItemContentVO sitemapItemContentVO = new SitemapItemContentVO();
        String string4 = null;
        Long l2 = null;
        LinkedHashMap<String, String> linkedHashMap = null;
        switch (sitemapItemType) {
            case HOME_PAGE: {
                guestHomeContent = configurationAccessor.getGuestHomeContent();
                string3 = this.dataTranslationHandler.getValue(language, (BaseEntity)guestHomeContent, GuestHomeContentDTO.TITLE.getName());
                String string5 = this.dataTranslationHandler.getValue(language, (BaseEntity)guestHomeContent, GuestHomeContentDTO.CONTENT.getName());
                string2 = StringHelper.isBlank((Object)string3) ? configurationAccessor.getApplicationName() : string3;
                string = string5;
                string4 = configurationAccessor.getApplicationDescription();
                l2 = guestHomeContent.getLastModifiedMillis();
                break;
            }
            case MENU_ITEM: {
                MenuItem menuItem = this.find(MenuItem.class, l);
                string2 = this.dataTranslationHandler.getValue(language, (BaseEntity)menuItem, MenuItemDTO.TITLE.getName(), true);
                string = this.dataTranslationHandler.getValue(language, (BaseEntity)menuItem, MenuItemDTO.CONTENT.getName(), true);
                l2 = menuItem.getLastModifiedMillis();
                break;
            }
            case AD: {
                BasicAd basicAd = (BasicAd)this.adService.find(l);
                string2 = basicAd.getName();
                string = this.richTextHandler.replaceTagsByUrls(basicAd.getDescription());
                linkedHashMap = new LinkedHashMap<String, String>();
                FormatterImpl formatterImpl = this.getFormatter();
                MessageKey messageKey = CollectionHelper.size((Collection)basicAd.getCategories()) == 1 ? MarketplaceKeys.Advertisements.CATEGORY : MarketplaceKeys.Advertisements.CATEGORIES;
                linkedHashMap.put(this.message(messageKey, new Object[0]), formatterImpl.format((Collection)basicAd.getCategories()));
                linkedHashMap.put(this.message(MarketplaceKeys.Advertisements.OWNER, new Object[0]), formatterImpl.format((BasicUser)basicAd.getOwner()));
                linkedHashMap.put(this.message(MarketplaceKeys.Advertisements.PRICE, new Object[0]), formatterImpl.format((ICurrencyAmount)basicAd.getPrice()));
                if (basicAd.getPromotionalPrice() != null && basicAd.isPromotionalPeriodActive()) {
                    linkedHashMap.put(this.message(MarketplaceKeys.Advertisements.PROMOTIONAL_PRICE, new Object[0]), formatterImpl.format((Object)basicAd.getPromotionalPrice()));
                }
                Map<AdCustomField, AdCustomFieldValue> map = CollectionHelper.orEmpty((Set)basicAd.getCustomValues()).stream().collect(Collectors.toMap(AdCustomFieldValue::getField, adCustomFieldValue -> adCustomFieldValue));
                for (AdCustomField adCustomField : this.adCustomFieldService.listVisibleFieldEnabledToOwner(basicAd.getOwner())) {
                    AdCustomFieldValue adCustomFieldValue2 = map.get(adCustomField);
                    String string6 = StringHelper.trimToNull((Object)formatterImpl.format((CustomFieldValue)adCustomFieldValue2));
                    if (string6 == null) continue;
                    linkedHashMap.put(formatterImpl.format((INamedEntity)adCustomField), string6);
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled type: " + String.valueOf(sitemapItemType));
            }
        }
        sitemapItemContentVO.setId(l);
        sitemapItemContentVO.setTitle(string2);
        sitemapItemContentVO.setContent(this.richTextHandler.replaceTagsByUrls(string));
        sitemapItemContentVO.setDescription(string4);
        sitemapItemContentVO.setFields(linkedHashMap);
        sitemapItemContentVO.setType(sitemapItemType);
        if (l2 != null) {
            sitemapItemContentVO.setLastModifiedMillis(l2.toString());
        }
        if ((guestHomeContent = configurationAccessor.getHeaderContent()) != null) {
            sitemapItemContentVO.setHeader(this.dataTranslationHandler.getValue(language, (BaseEntity)guestHomeContent, QHeaderContent.headerContent.content));
        }
        if ((string3 = configurationAccessor.getFooterContent()) != null) {
            sitemapItemContentVO.setFooter(this.dataTranslationHandler.getValue(language, (BaseEntity)string3, QFooterContent.footerContent.content));
        }
        return sitemapItemContentVO;
    }

    public SitemapIndexData getIndexData() throws FrameworkException {
        RequestData requestData = this.getSessionData().getRequestData();
        boolean bl = requestData == null ? false : requestData.isCustomUrl();
        QConfiguration qConfiguration = QConfiguration.configuration;
        QNetwork qNetwork = QNetwork.network;
        Predicate[] predicateArray = new Predicate[3];
        predicateArray[0] = qConfiguration.defaultType.isNotNull().or((Predicate)qConfiguration.path.isNotNull());
        predicateArray[1] = qNetwork.id.isNull().or((Predicate)qNetwork.enabled.isTrue());
        predicateArray[2] = bl ? (requestData.getNetworkId() == null ? qNetwork.id.isNull() : qNetwork.id.eq((Object)requestData.getNetworkId())) : qConfiguration.id.isNotNull();
        CloseableIterator closeableIterator = ((DBQuery)((DBQuery)((DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{qConfiguration}).leftJoin((EntityPath)qConfiguration.network(), (Path)qNetwork)).where(predicateArray)).orderBy(new OrderSpecifier[]{qNetwork.internalName.asc().nullsFirst(), qConfiguration.path.asc().nullsFirst()})).iterate((Expression)qConfiguration);
        ArrayList arrayList = new ArrayList();
        this.processBatch(closeableIterator, (T configuration) -> {
            ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor(configuration);
            if (configurationAccessor.isIncludeInSitemap()) {
                SitemapIndexItemVO sitemapIndexItemVO = new SitemapIndexItemVO();
                if (!configuration.isGlobal()) {
                    sitemapIndexItemVO.setNetworkInternalName(configuration.getNetwork().getInternalName());
                }
                sitemapIndexItemVO.setConfigurationPath(configuration.getPath());
                sitemapIndexItemVO.setConfigurationId(configuration.getId());
                Date date = configuration.getSitemapLastModified();
                sitemapIndexItemVO.setLastModifiedMillis(date == null ? null : String.valueOf(date.getTime()));
                arrayList.add(sitemapIndexItemVO);
            }
        });
        String string = this.configurationHandler.getGlobalDefault().getRootUrl();
        SitemapIndexData sitemapIndexData = new SitemapIndexData();
        sitemapIndexData.setRootUrl(string);
        sitemapIndexData.setItems(arrayList);
        return sitemapIndexData;
    }

    public String getLastModifiedInMillis() {
        ConfigurationAccessor configurationAccessor = this.getConfiguration();
        Date date = configurationAccessor.getConfiguration().getSitemapLastModified();
        Date date2 = null;
        if (CollectionHelper.isNotEmpty((Iterable)configurationAccessor.getVisibleAdGroups())) {
            date2 = DateUtils.truncate((Date)new Date(), (int)11);
        }
        Date date3 = date == null && date2 == null ? null : (date == null || date2 == null ? (Date)ObjectHelper.defaultValue((Object)date, (Object)date2) : (date.after(date2) ? date : date2));
        return date3 == null ? null : String.valueOf(date3.getTime());
    }

    public SitemapData getSitemapData() {
        SessionData sessionData = this.getSessionData();
        ConfigurationAccessor configurationAccessor = sessionData.getConfiguration();
        this.checkIncludeInSitemap(configurationAccessor);
        SitemapData sitemapData = new SitemapData();
        sitemapData.setRootUrl(configurationAccessor.getFullUrl());
        sitemapData.setConfigurationId(configurationAccessor.getConfiguration().getId());
        LinkedList<SitemapItemVO> linkedList = new LinkedList<SitemapItemVO>();
        GuestHomeContent guestHomeContent = configurationAccessor.getGuestHomeContent();
        SitemapItemVO sitemapItemVO = new SitemapItemVO();
        sitemapItemVO.setType(SitemapItemType.HOME_PAGE);
        sitemapItemVO.setLastModifiedMillis(guestHomeContent == null ? null : (String)CoercionHelper.coerce(String.class, (Object)guestHomeContent.getLastModifiedMillis()));
        linkedList.add(sitemapItemVO);
        linkedList.addAll(this.menuEntryService.listForSitemap());
        linkedList.addAll(this.adService.listForSitemap());
        sitemapData.setItems(linkedList);
        return sitemapData;
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
    }

    private void checkIncludeInSitemap(ConfigurationAccessor configurationAccessor) {
        if (!configurationAccessor.isIncludeInSitemap()) {
            throw new EntityNotFoundException(Configuration.class);
        }
    }
}

