/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.contentmanagement;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.cyclos.entities.contentmanagement.MobilePage;
import org.cyclos.entities.contentmanagement.QMobilePage;
import org.cyclos.entities.system.Configuration;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.contentmanagement.MobilePageServiceLocal;
import org.cyclos.impl.system.ConfigurationServiceLocal;
import org.cyclos.impl.utils.LinkGeneratorHandler;
import org.cyclos.impl.utils.RichTextHandler;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.impl.utils.validation.validations.GeneralValidations;
import org.cyclos.model.Bean;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.Property;
import org.cyclos.model.contentmanagement.ContentManagementKeys;
import org.cyclos.model.contentmanagement.mobilepages.MobilePageDTO;
import org.cyclos.model.contentmanagement.mobilepages.MobilePageData;
import org.cyclos.model.contentmanagement.mobilepages.MobilePageDetailedVO;
import org.cyclos.model.contentmanagement.mobilepages.MobilePageShowInOption;
import org.cyclos.model.contentmanagement.mobilepages.MobilePageVO;
import org.cyclos.model.contentmanagement.mobilepages.MobilePagesListData;
import org.cyclos.model.system.configurations.ConfigurationVO;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MobilePageServiceImpl
extends CRUDServiceImpl<MobilePage, QMobilePage, MobilePageDTO, MobilePageData, ConfigurationVO>
implements MobilePageServiceLocal {
    @Autowired
    private RichTextHandler richTextHandler;
    @Autowired
    private LinkGeneratorHandler linkGeneratorHandler;

    public MobilePageServiceImpl() {
        super(MobilePage.class, QMobilePage.mobilePage, MobilePageDTO.class);
    }

    public String getContent(MobilePageVO mobilePageVO) throws FrameworkException {
        MobilePage mobilePage = (MobilePage)this.conversionHandler.convert(MobilePage.class, (Object)mobilePageVO);
        MobilePageDetailedVO mobilePageDetailedVO = (MobilePageDetailedVO)this.conversionHandler.convert(MobilePageDetailedVO.class, (Object)mobilePage);
        return mobilePageDetailedVO.getContent();
    }

    public MobilePagesListData getListData(ConfigurationVO configurationVO) throws FrameworkException {
        MobilePagesListData mobilePagesListData = new MobilePagesListData();
        Configuration configuration = (Configuration)this.conversionHandler.convert(Configuration.class, (Object)configurationVO);
        mobilePagesListData.setConfiguration((ConfigurationVO)this.conversionHandler.convert(ConfigurationVO.class, (Object)configuration));
        mobilePagesListData.setMobilePages(this.list(configurationVO));
        return mobilePagesListData;
    }

    public List<MobilePage> getMobilePages() throws FrameworkException {
        Configuration configuration = this.getConfiguration().getConfiguration();
        return this.doList(configuration);
    }

    public List<MobilePage> getPosMobilePages() throws FrameworkException {
        Configuration configuration = this.getConfiguration().getConfiguration();
        return this.doList(configuration, null, true);
    }

    public List<MobilePage> getUserMobilePages() throws FrameworkException {
        Configuration configuration = this.getConfiguration().getConfiguration();
        return this.doList(configuration, true, null);
    }

    public List<MobilePageVO> list(ConfigurationVO configurationVO) throws FrameworkException {
        Configuration configuration = (Configuration)this.conversionHandler.convert(Configuration.class, (Object)configurationVO);
        return this.conversionHandler.convertList(MobilePageVO.class, this.doList(configuration));
    }

    @Override
    public MobilePage newEntity(ConfigurationVO configurationVO) {
        Configuration configuration = (Configuration)this.conversionHandler.convert(Configuration.class, (Object)configurationVO);
        MobilePage mobilePage = new MobilePage();
        mobilePage.setConfiguration(configuration);
        return mobilePage;
    }

    @Override
    public MobilePageDTO toDTO(MobilePage mobilePage) {
        MobilePageDTO mobilePageDTO = (MobilePageDTO)super.toDTO(mobilePage);
        mobilePageDTO.setContent(this.richTextHandler.replaceTagsByUrls(mobilePageDTO.getContent()));
        ConfigurationServiceLocal.setConfiguration((Bean)mobilePageDTO, (Configuration)mobilePage.getConfiguration());
        return mobilePageDTO;
    }

    @Override
    public MobilePage toEntity(MobilePageDTO mobilePageDTO) {
        MobilePage mobilePage = (MobilePage)super.toEntity(mobilePageDTO);
        String string = mobilePageDTO.getContent();
        String string2 = mobilePageDTO.getExternalUrl();
        if (StringHelper.isNotBlank((Object)mobilePageDTO.getExternalUrl())) {
            string = null;
        } else {
            string2 = null;
        }
        mobilePage.setExternalUrl(string2);
        mobilePage.setContent(this.richTextHandler.replaceUrlsByTags(string));
        return mobilePage;
    }

    @Override
    protected void addCustomNameValidations(org.cyclos.impl.utils.validation.Property property, MobilePageDTO mobilePageDTO) {
    }

    protected List<MobilePage> doList(Configuration configuration) {
        return this.doList(configuration, null, null);
    }

    protected List<MobilePage> doList(Configuration configuration, Boolean bl, Boolean bl2) {
        List list = this.configurationHandler.getAncestors(configuration);
        DBQuery dBQuery = (DBQuery)this.from().where((Predicate)((QMobilePage)this.$).configuration().in((Collection)list));
        if (BooleanUtils.isTrue((Boolean)bl) || BooleanUtils.isTrue((Boolean)bl2)) {
            ArrayList<MobilePageShowInOption> arrayList = new ArrayList<MobilePageShowInOption>();
            arrayList.add(MobilePageShowInOption.MOBILE_APP_AND_MOBILE_POS);
            if (BooleanUtils.isTrue((Boolean)bl)) {
                arrayList.add(MobilePageShowInOption.MOBILE_APP);
            }
            if (BooleanUtils.isTrue((Boolean)bl2)) {
                arrayList.add(MobilePageShowInOption.MOBILE_POS);
            }
            dBQuery.where((Predicate)((QMobilePage)this.$).showIn.in(arrayList));
        }
        dBQuery.orderBy(new OrderSpecifier[]{((QMobilePage)this.$).configuration().nameHierarchy().asc(), ((QMobilePage)this.$).order.asc()});
        return dBQuery.list((Expression)this.$);
    }

    @Override
    protected MobilePageData getData(MobilePage mobilePage) {
        MobilePageData mobilePageData = new MobilePageData();
        mobilePageData.setDto((EntityDTO)this.toDTO(mobilePage));
        mobilePageData.setMobileScheme(this.linkGeneratorHandler.mobileScheme());
        return mobilePageData;
    }

    @Override
    protected String getNameLabel(MobilePageDTO mobilePageDTO) {
        return this.message(ContentManagementKeys.MobilePages.NAME, new Object[0]);
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QMobilePage)this.$).configuration().network());
    }

    @Override
    protected Validator resolveValidator(MobilePageDTO mobilePageDTO) {
        Validator validator = new Validator();
        validator.property((Property)MobilePageDTO.CONFIGURATION, ContentManagementKeys.ContentItems.CONFIGURATION).required();
        validator.property((Property)MobilePageDTO.ICON, ContentManagementKeys.MobilePages.ICON).required();
        validator.property((Property)MobilePageDTO.SHOW_IN, ContentManagementKeys.MobilePages.SHOW_IN).required();
        if (StringHelper.isBlank((Object)mobilePageDTO.getContent()) && StringHelper.isBlank((Object)mobilePageDTO.getExternalUrl())) {
            validator.general(GeneralValidations.invalid((MessageKey)ContentManagementKeys.MobilePages.ERROR_CONTENT_OR_EXTERNAL_URL_REQUIRED, (Object[])new Object[0]));
        }
        return validator;
    }
}

