/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.contentmanagement;

import com.querydsl.core.types.EntityPath;
import org.cyclos.entities.contentmanagement.ContentItem;
import org.cyclos.entities.system.Configuration;
import org.cyclos.entities.system.QConfiguration;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.system.ConfigurationServiceLocal;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.Bean;
import org.cyclos.model.EntityData;
import org.cyclos.model.Property;
import org.cyclos.model.contentmanagement.ContentManagementKeys;
import org.cyclos.model.contentmanagement.contentitems.ContentItemDTO;
import org.cyclos.model.contentmanagement.contentitems.MenuEntryDTO;
import org.cyclos.server.utils.MethodHelper;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseContentItemServiceImpl<E extends ContentItem, A extends EntityPath<E>, DTO extends ContentItemDTO, D extends EntityData<DTO>, DP>
extends CRUDServiceImpl<E, A, DTO, D, DP> {
    @Autowired
    protected ConfigurationServiceLocal configurationService;
    protected QConfiguration configurationPath;

    public BaseContentItemServiceImpl(Class<E> clazz, A a, Class<DTO> clazz2) {
        super(clazz, a, clazz2);
        this.configurationPath = (QConfiguration)MethodHelper.invoke(a, (String)ContentItemDTO.CONFIGURATION.getName(), (Object[])new Object[0]);
    }

    @Override
    public DTO toDTO(E e) {
        ContentItemDTO contentItemDTO = (ContentItemDTO)super.toDTO(e);
        ConfigurationServiceLocal.setConfiguration((Bean)contentItemDTO, (Configuration)e.getConfiguration());
        return (DTO)contentItemDTO;
    }

    @Override
    protected Validator resolveValidator(DTO DTO) {
        Validator validator = new Validator();
        validator.property((Property)MenuEntryDTO.CONFIGURATION, ContentManagementKeys.ContentItems.CONFIGURATION).required();
        validator.property((Property)MenuEntryDTO.VISIBILITY, ContentManagementKeys.ContentItems.VISIBILITY).required();
        return validator;
    }
}

