/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.contentmanagement;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.cyclos.entities.contentmanagement.Banner;
import org.cyclos.entities.contentmanagement.ClassicBanner;
import org.cyclos.entities.contentmanagement.FrontendBanner;
import org.cyclos.entities.contentmanagement.QBanner;
import org.cyclos.entities.system.Configuration;
import org.cyclos.impl.contentmanagement.BannerServiceLocal;
import org.cyclos.impl.contentmanagement.BaseContentItemServiceImpl;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.Property;
import org.cyclos.model.contentmanagement.ContentManagementKeys;
import org.cyclos.model.contentmanagement.contentitems.BannerDTO;
import org.cyclos.model.contentmanagement.contentitems.BannerData;
import org.cyclos.model.contentmanagement.contentitems.BannerDataParams;
import org.cyclos.model.contentmanagement.contentitems.BannerNature;
import org.cyclos.model.contentmanagement.contentitems.BannerVO;
import org.cyclos.model.contentmanagement.contentitems.BannersListData;
import org.cyclos.model.contentmanagement.contentitems.ClassicBannerDTO;
import org.cyclos.model.contentmanagement.contentitems.ContentItemVisibility;
import org.cyclos.model.contentmanagement.contentitems.FrontendBannerDTO;
import org.cyclos.model.system.configurations.ConfigurationVO;
import org.cyclos.model.utils.FrontendMenu;
import org.springframework.stereotype.Service;

@Service
public class BannerServiceImpl
extends BaseContentItemServiceImpl<Banner, QBanner, BannerDTO, BannerData, BannerDataParams>
implements BannerServiceLocal {
    private static final BidiMap<Class<? extends Banner>, Class<? extends BannerDTO>> SUBCLASS_MAPPINGS = new DualHashBidiMap();

    public BannerServiceImpl() {
        super(Banner.class, QBanner.banner, BannerDTO.class);
    }

    public List<ClassicBanner> getClassicBanners() {
        Configuration configuration = this.getConfiguration().getConfiguration();
        EnumSet<ContentItemVisibility> enumSet = EnumSet.of(ContentItemVisibility.ALL, this.isGuest() ? ContentItemVisibility.GUESTS : ContentItemVisibility.USERS);
        return this.list(configuration, enumSet, EnumSet.of(BannerNature.CLASSIC));
    }

    public List<FrontendBanner> getFrontendBanners() {
        Configuration configuration = this.getConfiguration().getConfiguration();
        EnumSet<ContentItemVisibility> enumSet = EnumSet.of(ContentItemVisibility.ALL, this.isGuest() ? ContentItemVisibility.GUESTS : ContentItemVisibility.USERS);
        return this.list(configuration, enumSet, EnumSet.of(BannerNature.FRONTEND));
    }

    public BannersListData getListData(ConfigurationVO configurationVO) throws FrameworkException {
        Configuration configuration = (Configuration)this.conversionHandler.convert(Configuration.class, (Object)configurationVO);
        BannersListData bannersListData = new BannersListData();
        bannersListData.setConfiguration((ConfigurationVO)this.conversionHandler.convert(ConfigurationVO.class, (Object)configuration));
        bannersListData.setBanners(this.list(configurationVO));
        return bannersListData;
    }

    public List<BannerVO> list(ConfigurationVO configurationVO) throws FrameworkException {
        Configuration configuration = (Configuration)this.conversionHandler.convert(Configuration.class, (Object)configurationVO);
        List<? extends Banner> list = this.list(configuration, Arrays.asList(ContentItemVisibility.values()), EnumSet.allOf(BannerNature.class));
        return this.conversionHandler.convertList(BannerVO.class, list);
    }

    public void move(Long l, boolean bl) throws FrameworkException {
        boolean bl2;
        Banner banner = (Banner)this.find(l);
        List list = ((DBQuery)((DBQuery)this.from().where((Predicate)((QBanner)this.$).configuration().eq((Object)banner.getConfiguration()))).orderBy(((QBanner)this.$).order.asc())).list((Expression)this.$);
        int n = list.indexOf(banner);
        boolean bl3 = bl2 = bl && n < 1 || !bl && n >= list.size() - 1;
        if (!bl2) {
            Banner banner2 = (Banner)list.get(bl ? n - 1 : n + 1);
            int n2 = banner.getOrder();
            banner.setOrder(banner2.getOrder());
            banner2.setOrder(Integer.valueOf(n2));
            this.flush();
        }
    }

    @Override
    public Banner newEntity(BannerDataParams bannerDataParams) {
        ClassicBanner classicBanner;
        switch (bannerDataParams.getNature()) {
            case CLASSIC: {
                classicBanner = new ClassicBanner();
                break;
            }
            case FRONTEND: {
                classicBanner = new FrontendBanner();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        Configuration configuration = (Configuration)this.conversionHandler.convert(Configuration.class, (Object)bannerDataParams.getConfiguration());
        classicBanner.setConfiguration(configuration);
        return classicBanner;
    }

    @Override
    protected BannerData getData(Banner banner) {
        BannerData bannerData = new BannerData();
        bannerData.setDto((EntityDTO)((BannerDTO)this.toDTO(banner)));
        bannerData.setNature(banner.getNature());
        return bannerData;
    }

    @Override
    protected Object onBeforeSave(Banner banner, Banner banner2) {
        if (banner.isTransient()) {
            Integer n = (Integer)((DBQuery)this.from().where((Predicate)((QBanner)this.$).configuration().eq((Object)banner.getConfiguration()))).singleResult((Expression)((QBanner)this.$).order.max());
            banner.setOrder(Integer.valueOf(n == null ? 0 : n + 1));
        }
        return null;
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QBanner)this.$).configuration().network(), true);
    }

    @Override
    protected Validator resolveValidator(BannerDTO bannerDTO) {
        Validator validator = super.resolveValidator(bannerDTO);
        validator.property((Property)BannerDTO.CONTENT, ContentManagementKeys.ContentItems.BANNER_CONTENT).required();
        if (bannerDTO instanceof ClassicBannerDTO) {
            validator.property((Property)ClassicBannerDTO.POSITION, ContentManagementKeys.ContentItems.BANNER_POSITION).required();
        } else if (bannerDTO instanceof FrontendBannerDTO) {
            validator.property((Property)FrontendBannerDTO.MENUS, ContentManagementKeys.ContentItems.BANNER_MENUS).noneOf(new Object[]{FrontendMenu.DASHBOARD});
        }
        return validator;
    }

    @Override
    protected BidiMap<Class<? extends Banner>, Class<? extends BannerDTO>> subClassMappings() {
        return SUBCLASS_MAPPINGS;
    }

    private List<? extends Banner> list(Configuration configuration, Collection<ContentItemVisibility> collection, Collection<BannerNature> collection2) {
        List list = this.configurationHandler.getAncestors(configuration);
        return ((DBQuery)((DBQuery)this.fromCacheable(this.$).where(new Predicate[]{((QBanner)this.$).configuration().in((Collection)list), ((QBanner)this.$).nature.in(collection2), ((QBanner)this.$).visibility.in(collection)})).orderBy(new OrderSpecifier[]{((QBanner)this.$).configuration().nameHierarchy().asc(), ((QBanner)this.$).order.asc()})).list((Expression)this.$);
    }

    static {
        SUBCLASS_MAPPINGS.put(ClassicBanner.class, ClassicBannerDTO.class);
        SUBCLASS_MAPPINGS.put(FrontendBanner.class, FrontendBannerDTO.class);
    }
}

