/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.cyclos.entities.banking.Transaction;
import org.cyclos.entities.banking.Voucher;
import org.cyclos.entities.banking.VoucherTopUp;
import org.cyclos.entities.banking.VoucherTransaction;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.banking.VoucherCustomFieldServiceLocal;
import org.cyclos.impl.banking.VoucherServiceLocal;
import org.cyclos.impl.utils.conversion.EntityVOConverter;
import org.cyclos.model.banking.vouchers.VoucherTransactionResultVO;
import org.cyclos.model.system.fields.CustomFieldValueVO;
import org.cyclos.security.banking.TransactionServiceSecurity;
import org.cyclos.security.banking.VoucherServiceSecurity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VoucherTransactionResultVOConverter
extends EntityVOConverter<VoucherTransactionResultVO> {
    @Autowired
    private VoucherServiceLocal voucherService;
    @Autowired
    private VoucherServiceSecurity voucherServiceSecurity;
    @Autowired
    private VoucherCustomFieldServiceLocal voucherCustomFieldService;
    @Autowired
    private TransactionServiceSecurity transactionServiceSecurity;

    public VoucherTransactionResultVOConverter() {
        super(VoucherTransactionResultVO.class);
    }

    @Override
    protected void fill(Object object, VoucherTransactionResultVO voucherTransactionResultVO, Object[] objectArray, InvocationContext.ConversionContext conversionContext) {
        if (object instanceof VoucherTransaction) {
            VoucherTransaction voucherTransaction = (VoucherTransaction)object;
            Voucher voucher = voucherTransaction.getVoucher();
            voucherTransactionResultVO.setToken(this.voucherService.formatToken(voucher));
            objectArray = ArrayUtils.add((Object[])objectArray, (Object)VoucherTransactionResultVO.TOKEN);
            if (this.voucherServiceSecurity.isVisible(voucher)) {
                voucherTransactionResultVO.setVoucherId(voucher.getId());
            }
            objectArray = ArrayUtils.add((Object[])objectArray, (Object)VoucherTransactionResultVO.VOUCHER_ID);
            if (voucherTransaction instanceof VoucherTopUp && ((VoucherTopUp)voucherTransaction).getVoucher().getActivation().equals((Object)voucherTransaction)) {
                List list = this.voucherCustomFieldService.listRelated(voucherTransaction.getType(), voucherTransaction.getUser());
                List list2 = voucherTransaction.getVoucher().getCustomValues().stream().filter(voucherCustomFieldValue -> list.contains(voucherCustomFieldValue.getField())).collect(Collectors.toList());
                voucherTransactionResultVO.setCustomValues(this.conversionHandler.convertList(CustomFieldValueVO.class, list2));
                objectArray = ArrayUtils.add((Object[])objectArray, (Object)VoucherTransactionResultVO.CUSTOM_VALUES);
            }
            if (voucherTransaction != null && !this.transactionServiceSecurity.isAccessible((Transaction)voucherTransaction.getTransaction())) {
                objectArray = ArrayUtils.add((Object[])objectArray, (Object)VoucherTransactionResultVO.TRANSACTION);
            }
            super.fill((Object)voucherTransaction, voucherTransactionResultVO, objectArray, conversionContext);
        } else {
            super.fill(object, voucherTransactionResultVO, objectArray, conversionContext);
        }
    }
}

