/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import org.cyclos.entities.banking.QVoucherTemplateImage;
import org.cyclos.entities.banking.VoucherTemplate;
import org.cyclos.entities.banking.VoucherTemplateImage;
import org.cyclos.entities.utils.StoredFile;
import org.cyclos.impl.ApplicationHandler;
import org.cyclos.impl.access.InitializationServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.banking.VoucherTemplateImageServiceLocal;
import org.cyclos.impl.storage.StoredFileHandler;
import org.cyclos.impl.system.BaseImageServiceImpl;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.banking.vouchertemplates.NewVoucherTemplateImageParams;
import org.cyclos.model.banking.vouchertemplates.VoucherTemplateImageVO;
import org.cyclos.model.system.images.ImageNature;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VoucherTemplateImageServiceImpl
extends BaseImageServiceImpl<VoucherTemplateImage, QVoucherTemplateImage, NewVoucherTemplateImageParams>
implements VoucherTemplateImageServiceLocal {
    @Autowired
    private StoredFileHandler storedFileHandler;
    @Autowired
    private ApplicationHandler applicationHandler;
    @Autowired
    private InitializationServiceLocal initializationService;

    public VoucherTemplateImageServiceImpl() {
        super(ImageNature.VOUCHER_TEMPLATE, VoucherTemplateImage.class, QVoucherTemplateImage.voucherTemplateImage);
    }

    public String getImageUrl(VoucherTemplate voucherTemplate, String string) {
        SessionData sessionData = this.getSessionData();
        VoucherTemplateImageVO voucherTemplateImageVO = this.getImageVO(voucherTemplate.getId(), string);
        Long l = this.applicationHandler.getIdMask().apply(voucherTemplate.getId());
        String string2 = voucherTemplateImageVO.getLastModifiedInMillis();
        if (string2 == null) {
            string2 = this.initializationService.getResourceCacheKey();
        }
        return StringHelper.removeEnd((String)sessionData.getRequestData().getBaseUrl(), (String)"/") + "/content/voucherTemplates/" + l + "/image?&name=" + string + "&mod=" + string2;
    }

    public VoucherTemplateImageVO getImageVO(Long l, String string) {
        VoucherTemplate voucherTemplate = this.find(VoucherTemplate.class, l);
        QVoucherTemplateImage qVoucherTemplateImage = QVoucherTemplateImage.voucherTemplateImage;
        VoucherTemplateImage voucherTemplateImage = (VoucherTemplateImage)((DBQuery)this.from(new EntityPath[]{qVoucherTemplateImage}).where(new Predicate[]{qVoucherTemplateImage.voucherTemplate().eq((Object)voucherTemplate), qVoucherTemplateImage.name.eq((Object)string)})).singleResult((Expression)qVoucherTemplateImage);
        if (voucherTemplateImage != null) {
            return (VoucherTemplateImageVO)this.conversionHandler.convert(VoucherTemplateImageVO.class, (Object)voucherTemplateImage);
        }
        throw new EntityNotFoundException(VoucherTemplateImage.class);
    }

    public List<VoucherTemplateImageVO> list(Long l) {
        QVoucherTemplateImage qVoucherTemplateImage = QVoucherTemplateImage.voucherTemplateImage;
        return ((DBQuery)this.from(new EntityPath[]{qVoucherTemplateImage}).where((Predicate)qVoucherTemplateImage.voucherTemplate().id.eq((Object)l))).list(VoucherTemplateImageVO.class, (Expression)qVoucherTemplateImage);
    }

    @Override
    public VoucherTemplateImage newImage(NewVoucherTemplateImageParams newVoucherTemplateImageParams) {
        throw new UnsupportedOperationException("save() was overridden: this method is never invoked");
    }

    public byte[] readImageContent(Long l, String string) throws EntityNotFoundException {
        VoucherTemplateImage voucherTemplateImage = this.findImage(l, string);
        if (voucherTemplateImage != null) {
            return this.storedFileHandler.getBytes((StoredFile)voucherTemplateImage);
        }
        throw new EntityNotFoundException(VoucherTemplateImage.class);
    }

    @Override
    public void removeAll(Collection<Long> collection) throws FrameworkException {
        if (CollectionHelper.isNotEmpty(collection)) {
            for (Long l : collection) {
                this.remove(l);
            }
        }
    }

    public final VoucherTemplateImageVO save(NewVoucherTemplateImageParams newVoucherTemplateImageParams, String string, SerializableInputStream serializableInputStream, String string2) throws FrameworkException {
        VoucherTemplate voucherTemplate = this.find(VoucherTemplate.class, newVoucherTemplateImageParams.getVoucherTemplateId());
        VoucherTemplateImage voucherTemplateImage = this.saveImage(voucherTemplate, string, (InputStream)serializableInputStream, string2);
        return (VoucherTemplateImageVO)this.conversionHandler.convert(VoucherTemplateImageVO.class, (Object)voucherTemplateImage);
    }

    public VoucherTemplateImage saveImage(VoucherTemplate voucherTemplate, String string, InputStream inputStream, String string2) {
        boolean bl;
        VoucherTemplateImage voucherTemplateImage = this.findImage(voucherTemplate.getId(), string);
        boolean bl2 = bl = voucherTemplateImage == null;
        if (voucherTemplateImage == null) {
            voucherTemplateImage = new VoucherTemplateImage();
            voucherTemplateImage.setVoucherTemplate(voucherTemplate);
            voucherTemplateImage.setName(string);
        }
        SerializableInputStream serializableInputStream = inputStream instanceof SerializableInputStream ? (SerializableInputStream)inputStream : new SerializableInputStream(inputStream);
        this.setDataAndPersist(voucherTemplateImage, serializableInputStream, string2);
        if (bl) {
            voucherTemplate.getImages().add(voucherTemplateImage);
        }
        return voucherTemplateImage;
    }

    @Override
    protected void onAfterRemove(VoucherTemplateImage voucherTemplateImage) {
        VoucherTemplate voucherTemplate = voucherTemplateImage.getVoucherTemplate();
        voucherTemplate.getImages().remove(voucherTemplateImage);
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QVoucherTemplateImage)this.$).voucherTemplate().network(), true);
    }

    private VoucherTemplateImage findImage(Long l, String string) {
        QVoucherTemplateImage qVoucherTemplateImage = QVoucherTemplateImage.voucherTemplateImage;
        return (VoucherTemplateImage)((DBQuery)this.from(new EntityPath[]{qVoucherTemplateImage}).where(new Predicate[]{qVoucherTemplateImage.voucherTemplate().id.eq((Object)l), qVoucherTemplateImage.name.eq((Object)string)})).singleResult((Expression)qVoucherTemplateImage);
    }
}

