/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.banking.QVoucherCustomField;
import org.cyclos.entities.banking.VoucherCustomField;
import org.cyclos.entities.banking.VoucherCustomFieldPossibleValue;
import org.cyclos.entities.banking.VoucherCustomFieldPossibleValueCategory;
import org.cyclos.entities.banking.VoucherType;
import org.cyclos.entities.users.AdminGroup;
import org.cyclos.entities.users.AdminProduct;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Group;
import org.cyclos.entities.users.QProduct;
import org.cyclos.entities.users.User;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.banking.VoucherCustomFieldPossibleValueCategoryServiceLocal;
import org.cyclos.impl.banking.VoucherCustomFieldPossibleValueServiceLocal;
import org.cyclos.impl.banking.VoucherCustomFieldServiceLocal;
import org.cyclos.impl.system.BaseCustomFieldPossibleValueCategoryServiceLocal;
import org.cyclos.impl.system.BaseCustomFieldServiceImpl;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.impl.utils.SerializablePredicate;
import org.cyclos.impl.utils.cache.CacheHandler;
import org.cyclos.impl.utils.cache.CacheType;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.ValidationError;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.Property;
import org.cyclos.model.banking.BankingKeys;
import org.cyclos.model.banking.voucherfields.VoucherCustomFieldDTO;
import org.cyclos.model.banking.voucherfields.VoucherCustomFieldData;
import org.cyclos.model.banking.vouchers.VoucherCustomFieldUsage;
import org.cyclos.model.banking.vouchertypes.VoucherTypeVO;
import org.cyclos.model.system.fields.CustomFieldVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.server.utils.PropertyHelper;
import org.cyclos.server.utils.SortHelper;
import org.cyclos.server.utils.SortSpecifier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VoucherCustomFieldServiceImpl
extends BaseCustomFieldServiceImpl<VoucherCustomField, VoucherCustomFieldPossibleValueCategory, VoucherCustomFieldPossibleValue, QVoucherCustomField, VoucherCustomFieldDTO, VoucherCustomFieldData, Void>
implements VoucherCustomFieldServiceLocal {
    @Autowired
    private VoucherCustomFieldPossibleValueServiceLocal voucherCustomFieldPossibleValueService;
    @Autowired
    private VoucherCustomFieldPossibleValueCategoryServiceLocal voucherCustomFieldPossibleValueCategoryService;
    @Autowired
    private CacheHandler cacheHandler;

    public VoucherCustomFieldServiceImpl() {
        super(VoucherCustomField.class, QVoucherCustomField.voucherCustomField, VoucherCustomFieldDTO.class, VoucherCustomFieldData.class);
    }

    public void addRelation(VoucherTypeVO voucherTypeVO, CustomFieldVO customFieldVO) throws EntityNotFoundException {
        VoucherType voucherType = (VoucherType)this.conversionHandler.convert(VoucherType.class, (Object)voucherTypeVO);
        VoucherCustomField voucherCustomField = (VoucherCustomField)this.conversionHandler.convert(VoucherCustomField.class, (Object)customFieldVO);
        voucherType.getCustomFields().add(voucherCustomField);
    }

    public List<CustomFieldVO> list() {
        return this.conversionHandler.convertList(CustomFieldVO.class, this.listAll());
    }

    public List<VoucherCustomField> listAll() {
        QVoucherCustomField qVoucherCustomField = QVoucherCustomField.voucherCustomField;
        return ((DBQuery)this.from(new EntityPath[]{qVoucherCustomField}).orderBy(qVoucherCustomField.order.asc())).list((Expression)qVoucherCustomField);
    }

    public List<CustomFieldVO> listAllRelated(VoucherTypeVO voucherTypeVO) throws EntityNotFoundException {
        VoucherType voucherType = (VoucherType)this.conversionHandler.convert(VoucherType.class, (Object)voucherTypeVO);
        ArrayList arrayList = new ArrayList(voucherType.getCustomFields());
        Collections.sort(arrayList, (voucherCustomField, voucherCustomField2) -> voucherCustomField.getOrder().compareTo(voucherCustomField2.getOrder()));
        return this.conversionHandler.convertList(CustomFieldVO.class, arrayList);
    }

    public List<VoucherCustomField> listRelated(VoucherType voucherType, User user) {
        SessionData sessionData = this.getSessionData();
        List list = SortHelper.sortBy((Collection)voucherType.getCustomFields(), (SortSpecifier[])new SortSpecifier[0]);
        if (!sessionData.isSystem()) {
            ProductsAccessor productsAccessor = sessionData.getProducts();
            if (user == null) {
                list.retainAll(productsAccessor.product().getVisibleVoucherFields());
            } else if (sessionData.isAdmin()) {
                list.retainAll(productsAccessor.admin().getVisibleVoucherFields());
            } else if (sessionData.isBrokerOf((BasicUser)user)) {
                list.retainAll(productsAccessor.broker().getVisibleVoucherFields());
            } else {
                list.retainAll(productsAccessor.member().getVisibleVoucherFields());
            }
        }
        return list;
    }

    public List<CustomFieldVO> listRelated(VoucherTypeVO voucherTypeVO, UserVO userVO) throws EntityNotFoundException {
        VoucherType voucherType = (VoucherType)this.conversionHandler.convert(VoucherType.class, (Object)voucherTypeVO);
        User user = userVO == null ? null : (User)this.conversionHandler.convert(User.class, (Object)userVO);
        return this.conversionHandler.convertList(CustomFieldVO.class, this.listRelated(voucherType, user));
    }

    public List<VoucherCustomField> listVisible(User user) throws FrameworkException {
        SessionData sessionData = this.getSessionData();
        ProductsAccessor productsAccessor = sessionData.getProducts();
        if (user == null) {
            return productsAccessor.product().getVisibleVoucherFields();
        }
        if (sessionData.isAdmin()) {
            return productsAccessor.admin().getVisibleVoucherFields();
        }
        if (sessionData.isBrokerOf((BasicUser)user)) {
            return productsAccessor.broker().getVisibleVoucherFields();
        }
        return productsAccessor.member().getVisibleVoucherFields();
    }

    @Override
    public VoucherCustomField newEntity(Void void_) {
        return new VoucherCustomField();
    }

    public void removeRelation(VoucherTypeVO voucherTypeVO, CustomFieldVO customFieldVO) throws EntityNotFoundException {
        VoucherType voucherType = (VoucherType)this.conversionHandler.convert(VoucherType.class, (Object)voucherTypeVO);
        VoucherCustomField voucherCustomField = (VoucherCustomField)this.conversionHandler.convert(VoucherCustomField.class, (Object)customFieldVO);
        voucherType.getCustomFields().remove(voucherCustomField);
    }

    @Override
    protected void addCustomValidations(Validator validator, VoucherCustomFieldDTO voucherCustomFieldDTO) {
        validator.property((Property)VoucherCustomFieldDTO.USAGE, BankingKeys.VoucherFields.USED_IN).required();
        if (voucherCustomFieldDTO.getUsage() == VoucherCustomFieldUsage.CREATION && !voucherCustomFieldDTO.isUsedOnBuying() && !voucherCustomFieldDTO.isUsedOnGeneration()) {
            validator.general(object -> new ValidationError(BankingKeys.VoucherFields.ERROR_NO_CREATION_TYPE_SELECTED));
        }
    }

    @Override
    protected Integer getMaxOrder(VoucherCustomField voucherCustomField) {
        QVoucherCustomField qVoucherCustomField = QVoucherCustomField.voucherCustomField;
        return (Integer)this.from(new EntityPath[]{qVoucherCustomField}).singleResult((Expression)qVoucherCustomField.order.max());
    }

    @Override
    protected BaseCustomFieldPossibleValueCategoryServiceLocal<VoucherCustomField, VoucherCustomFieldPossibleValueCategory, VoucherCustomFieldPossibleValue> getPossibleValueCategoryService() {
        return this.voucherCustomFieldPossibleValueCategoryService;
    }

    protected VoucherCustomFieldPossibleValueServiceLocal getPossibleValueService() {
        return this.voucherCustomFieldPossibleValueService;
    }

    @Override
    protected List<Class<?>> getPropertyClasses() {
        return Arrays.asList(new Class[0]);
    }

    @Override
    protected boolean isBinaryTypesAllowed() {
        return true;
    }

    @Override
    protected void onAfterRemove(VoucherCustomField voucherCustomField) {
        Long l = SimpleEntity.id((SimpleEntity)voucherCustomField.getNetwork());
        String string = PropertyHelper.getGetterName((Path)QProduct.product.visibleVoucherFields);
        this.cacheHandler.schedulePartialEvict(CacheType.PRODUCTS_ACCESSOR, (SerializablePredicate & Serializable)productsAccessorCacheKey -> productsAccessorCacheKey.matchesNetworkAndMethod(l, string));
    }

    @Override
    protected void onAfterSave(VoucherCustomField voucherCustomField, VoucherCustomField voucherCustomField2, Object object) {
        Group group;
        if (voucherCustomField2 == null && (group = this.getSessionData().getGroup()) instanceof AdminGroup) {
            AdminProduct adminProduct = ((AdminGroup)group).getAdminProduct();
            adminProduct.getVisibleVoucherFields().add(voucherCustomField);
            Long l = SimpleEntity.id((SimpleEntity)adminProduct);
            this.cacheHandler.schedulePartialEvict(CacheType.PRODUCTS_ACCESSOR, (SerializablePredicate & Serializable)productsAccessorCacheKey -> productsAccessorCacheKey.matchesProduct(l));
        }
    }

    @Override
    protected Object onBeforeSave(VoucherCustomField voucherCustomField, VoucherCustomField voucherCustomField2) {
        if (voucherCustomField.getUsage() == VoucherCustomFieldUsage.ACTIVATION) {
            voucherCustomField.setUsedOnBuying(false);
            voucherCustomField.setUsedOnGeneration(false);
        }
        if (!voucherCustomField.getType().isAllowedToBeOnSearchFilters()) {
            voucherCustomField.setShowInSearch(false);
        }
        return super.onBeforeSave(voucherCustomField, voucherCustomField2);
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QVoucherCustomField)this.$).network(), true);
    }
}

