/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.banking.AccountType;
import org.cyclos.entities.banking.QUserAccountVisibilitySettings;
import org.cyclos.entities.banking.UserAccountType;
import org.cyclos.entities.banking.UserAccountVisibilitySettings;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.banking.UserAccountVisibilitySettingsServiceLocal;
import org.cyclos.impl.users.MemberProductAccessor;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.ValidationException;
import org.cyclos.model.banking.BankingKeys;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.accounts.UserAccountVisibilityData;
import org.cyclos.model.banking.accounts.UserAccountVisibilitySettingsData;
import org.cyclos.model.banking.accounttypes.AccountTypeWithCurrencyVO;
import org.cyclos.model.banking.accounttypes.UserAccountTypeVO;
import org.cyclos.model.users.products.AccountAccessibility;
import org.cyclos.model.users.products.AccountVisibility;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.security.banking.AccountServiceSecurity;
import org.cyclos.utils.CollectionHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserAccountVisibilitySettingsServiceImpl
extends BaseServiceImpl
implements UserAccountVisibilitySettingsServiceLocal {
    private static final QUserAccountVisibilitySettings $ = QUserAccountVisibilitySettings.userAccountVisibilitySettings;
    @Autowired
    private AccountServiceLocal accountService;
    @Autowired
    private AccountServiceSecurity accountServiceSecurity;

    public UserAccountVisibilitySettingsData getData(UserLocatorVO userLocatorVO) throws FrameworkException {
        BasicUser basicUser = this.userLocatorHandler.toBasicUserOrCurrent((BasicUserVO)userLocatorVO);
        Map map = this.visibilityBaseQuery(basicUser).map((Expression)$.accountType(), (Expression)UserAccountVisibilitySettingsServiceImpl.$.visible);
        List list = this.getAccountAccessors(basicUser).stream().map(memberProductAccessor -> {
            UserAccountType userAccountType = (UserAccountType)memberProductAccessor.getUserAccounts().iterator().next();
            UserAccountVisibilityData userAccountVisibilityData = new UserAccountVisibilityData();
            userAccountVisibilityData.setAccountType((AccountTypeWithCurrencyVO)this.conversionHandler.convert(AccountTypeWithCurrencyVO.class, (Object)userAccountType));
            Account account = this.accountService.load((InternalAccountOwner)basicUser, (AccountType)userAccountType);
            userAccountVisibilityData.setAccountNumber(account.getNumber());
            AccountVisibility accountVisibility = memberProductAccessor.getAccountVisibility();
            if (accountVisibility == AccountVisibility.ALWAYS_VISIBLE) {
                userAccountVisibilityData.setCanHide(false);
                userAccountVisibilityData.setVisible(true);
            } else {
                userAccountVisibilityData.setCanHide(true);
                Boolean bl = (Boolean)map.get(userAccountType);
                userAccountVisibilityData.setVisible(bl == null ? accountVisibility.shouldBeVisible() : bl.booleanValue());
            }
            return userAccountVisibilityData;
        }).collect(Collectors.toList());
        UserAccountVisibilitySettingsData userAccountVisibilitySettingsData = new UserAccountVisibilitySettingsData();
        userAccountVisibilitySettingsData.setUser((BasicUserVO)this.conversionHandler.convert(UserVO.class, (Object)basicUser));
        userAccountVisibilitySettingsData.setAccounts(list);
        return userAccountVisibilitySettingsData;
    }

    public boolean hasAccountsToShowHide(BasicUser basicUser) {
        return this.getAccountAccessors(basicUser).stream().anyMatch(memberProductAccessor -> memberProductAccessor.getAccountVisibility() != AccountVisibility.ALWAYS_VISIBLE);
    }

    public void save(UserLocatorVO userLocatorVO, Set<UserAccountTypeVO> set) throws FrameworkException {
        BasicUser basicUser = this.userLocatorHandler.toBasicUserOrCurrent((BasicUserVO)userLocatorVO);
        ProductsAccessor productsAccessor = this.productsHandler.getAccessor(basicUser);
        Set set2 = this.conversionHandler.convertSet(UserAccountType.class, set);
        if (CollectionHelper.isEmpty(set) && productsAccessor.member().getAccountVisibility() != AccountVisibility.ALWAYS_VISIBLE) {
            throw new ValidationException(this.message(BankingKeys.AccountSettings.VISIBILITY_ERROR_TRY_TO_HIDE_ALL, new Object[0]));
        }
        HashSet hashSet = new HashSet();
        productsAccessor.member().getUserAccounts().forEach(userAccountType -> {
            if (this.doSetAsVisible(basicUser, (UserAccountType)userAccountType, set2.contains(userAccountType))) {
                hashSet.add(userAccountType);
            }
        });
        if (!hashSet.isEmpty()) {
            this.delete((EntityPath<?>)$).where(new Predicate[]{$.user().eq((Object)basicUser), $.accountType().in(hashSet)}).execute();
        }
    }

    public void setAsVisible(UserLocatorVO userLocatorVO, UserAccountTypeVO userAccountTypeVO, boolean bl) throws FrameworkException {
        BasicUser basicUser = this.userLocatorHandler.toBasicUserOrCurrent((BasicUserVO)userLocatorVO);
        UserAccountType userAccountType = (UserAccountType)this.conversionHandler.convert(UserAccountType.class, (Object)userAccountTypeVO);
        if (!bl && this.productsHandler.getAccessor(basicUser).member().getAccountVisibility() != AccountVisibility.ALWAYS_VISIBLE && ((DBQuery)this.visibilityBaseQuery(basicUser).where((Predicate)$.accountType().ne((Object)userAccountType).and((Predicate)UserAccountVisibilitySettingsServiceImpl.$.visible.isTrue()))).hasEmptyResults()) {
            throw new ValidationException(this.message(BankingKeys.AccountSettings.VISIBILITY_ERROR_TRY_TO_HIDE_ALL, new Object[0]));
        }
        if (this.doSetAsVisible(basicUser, userAccountType, bl)) {
            this.delete((EntityPath<?>)$).where(new Predicate[]{$.user().eq((Object)basicUser), $.accountType().eq((Object)userAccountType)}).execute();
        }
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register($.user().network());
    }

    private boolean doSetAsVisible(BasicUser basicUser, UserAccountType userAccountType, boolean bl) {
        ProductsAccessor productsAccessor = this.productsHandler.getAccessor(basicUser);
        MemberProductAccessor memberProductAccessor = productsAccessor.member(userAccountType);
        if (memberProductAccessor.getUserAccounts().isEmpty()) {
            throw new IllegalActionException();
        }
        boolean bl2 = memberProductAccessor.getAccountVisibility().shouldBeVisible();
        if (bl2 == bl) {
            return true;
        }
        UserAccountVisibilitySettings userAccountVisibilitySettings = (UserAccountVisibilitySettings)((DBQuery)this.visibilityBaseQuery(basicUser).where((Predicate)$.accountType().eq((Object)userAccountType))).singleResult((Expression)$);
        if (userAccountVisibilitySettings != null) {
            userAccountVisibilitySettings.setVisible(bl);
        } else {
            userAccountVisibilitySettings = new UserAccountVisibilitySettings();
            userAccountVisibilitySettings.setAccountType(userAccountType);
            userAccountVisibilitySettings.setUser(basicUser);
            userAccountVisibilitySettings.setVisible(bl);
            this.persist((IEntity)userAccountVisibilitySettings);
        }
        return false;
    }

    private List<MemberProductAccessor> getAccountAccessors(BasicUser basicUser) {
        ProductsAccessor productsAccessor = this.productsHandler.getAccessor(basicUser);
        Set set = productsAccessor.member().getUserAccounts().stream().filter(userAccountType -> productsAccessor.member(userAccountType).getAccountAccessibility() == AccountAccessibility.ONLY_IF_TRANSACTIONS).collect(Collectors.toSet());
        Set set2 = this.accountService.getAccountIdsWithTransactions(set, basicUser.getUser());
        return productsAccessor.member().getUserAccounts().stream().filter(userAccountType -> this.accountServiceSecurity.doHasAccess(this.accountService.load((InternalAccountOwner)basicUser, (AccountType)userAccountType), false, (Collection)set2)).map(userAccountType -> productsAccessor.member(userAccountType)).collect(Collectors.toCollection(ArrayList::new));
    }

    private DBQuery<?> visibilityBaseQuery(BasicUser basicUser) {
        return (DBQuery)this.from(new EntityPath[]{$}).where((Predicate)$.user().eq((Object)basicUser));
    }
}

