/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import com.google.common.base.Function;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.cyclos.entities.NamedEntity;
import org.cyclos.entities.access.Channel;
import org.cyclos.entities.access.PrincipalType;
import org.cyclos.entities.banking.AccountType;
import org.cyclos.entities.banking.AuthorizationRole;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.GeneratedTransferType;
import org.cyclos.entities.banking.HasCurrency;
import org.cyclos.entities.banking.IAccount;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.banking.QPaymentTransferType;
import org.cyclos.entities.banking.QTransferType;
import org.cyclos.entities.banking.SystemAccountType;
import org.cyclos.entities.banking.TransferFee;
import org.cyclos.entities.banking.TransferStatus;
import org.cyclos.entities.banking.TransferStatusFlow;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.banking.UserAccountType;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Group;
import org.cyclos.entities.users.GroupSet;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserGroup;
import org.cyclos.entities.users.UserPrincipal;
import org.cyclos.impl.ApplicationHandler;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.ChannelServiceLocal;
import org.cyclos.impl.access.DirectUserSessionData;
import org.cyclos.impl.access.PrincipalTypeServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.banking.AccountTypeServiceLocal;
import org.cyclos.impl.banking.AuthorizationLevelServiceLocal;
import org.cyclos.impl.banking.DRateTypeHandler;
import org.cyclos.impl.banking.LocateAccountOwnerResult;
import org.cyclos.impl.banking.PaymentTransferTypeQuery;
import org.cyclos.impl.banking.RateHandler;
import org.cyclos.impl.banking.TransactionCustomFieldServiceLocal;
import org.cyclos.impl.banking.TransactionServiceLocal;
import org.cyclos.impl.banking.TransferFeeServiceLocal;
import org.cyclos.impl.banking.TransferStatusFlowServiceLocal;
import org.cyclos.impl.banking.TransferTypeCacheKey;
import org.cyclos.impl.banking.TransferTypeServiceLocal;
import org.cyclos.impl.sql.NativeQueryHandler;
import org.cyclos.impl.users.MemberProductAccessor;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.impl.utils.QueryHelper;
import org.cyclos.impl.utils.cache.AccessorCacheValue;
import org.cyclos.impl.utils.cache.Cache;
import org.cyclos.impl.utils.cache.CacheHandler;
import org.cyclos.impl.utils.cache.CacheType;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.BasePropertyAccess;
import org.cyclos.impl.utils.validation.GeneralValidation;
import org.cyclos.impl.utils.validation.PropertyAccess;
import org.cyclos.impl.utils.validation.PropertyValidation;
import org.cyclos.impl.utils.validation.ValidationError;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.Availability;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.EntityVO;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.Property;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.access.RequestData;
import org.cyclos.model.access.channels.BuiltInChannel;
import org.cyclos.model.access.channels.ChannelVO;
import org.cyclos.model.access.principaltypes.PrincipalTypeVO;
import org.cyclos.model.banking.BankingKeys;
import org.cyclos.model.banking.accounts.AccountOwner;
import org.cyclos.model.banking.accounts.ExternalAccountOwner;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.accounts.SystemAccountOwner;
import org.cyclos.model.banking.accounttypes.AccountTypeLimitType;
import org.cyclos.model.banking.accounttypes.AccountTypeNature;
import org.cyclos.model.banking.accounttypes.AccountTypeVO;
import org.cyclos.model.banking.currencies.CurrencyVO;
import org.cyclos.model.banking.transferfees.TransferFeeConfigurationMode;
import org.cyclos.model.banking.transferfees.TransferFeeSubject;
import org.cyclos.model.banking.transferstatus.TransferStatusFlowWithStatusesVO;
import org.cyclos.model.banking.transfertypes.EditTransferTypeData;
import org.cyclos.model.banking.transfertypes.GeneratedTransferTypeDTO;
import org.cyclos.model.banking.transfertypes.MaturityPolicy;
import org.cyclos.model.banking.transfertypes.NewTransferTypeData;
import org.cyclos.model.banking.transfertypes.PaymentTransferTypeDTO;
import org.cyclos.model.banking.transfertypes.PaymentTransferTypeRestrictTo;
import org.cyclos.model.banking.transfertypes.TransferTypeDTO;
import org.cyclos.model.banking.transfertypes.TransferTypeData;
import org.cyclos.model.banking.transfertypes.TransferTypeDataParams;
import org.cyclos.model.banking.transfertypes.TransferTypeDirection;
import org.cyclos.model.banking.transfertypes.TransferTypeNature;
import org.cyclos.model.banking.transfertypes.TransferTypeQuery;
import org.cyclos.model.banking.transfertypes.TransferTypeVO;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.fields.CustomFieldVO;
import org.cyclos.model.users.references.TransactionFeedbackSetting;
import org.cyclos.model.utils.TimeField;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.MutableObject;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Page;
import org.cyclos.utils.PageImpl;
import org.cyclos.utils.TranslationMessageSpecification;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TransferTypeServiceImpl
extends CRUDServiceImpl<TransferType, QTransferType, TransferTypeDTO, TransferTypeData, TransferTypeDataParams>
implements TransferTypeServiceLocal {
    private static final BidiMap<Class<? extends TransferType>, Class<? extends TransferTypeDTO>> SUBCLASS_MAPPINGS = new DualHashBidiMap();
    private static final Comparator<TransferType> COMPARATOR;
    @Autowired
    private AccountTypeServiceLocal accountTypeService;
    @Autowired
    private ChannelServiceLocal channelService;
    @Autowired
    private TransactionCustomFieldServiceLocal transactionCustomFieldService;
    @Autowired
    private TransferFeeServiceLocal transferFeeService;
    @Autowired
    private AuthorizationLevelServiceLocal authorizationLevelService;
    @Autowired
    private DRateTypeHandler dRateHandler;
    @Autowired
    private AccountServiceLocal accountService;
    @Autowired
    private TransferStatusFlowServiceLocal transferStatusFlowService;
    @Autowired
    private NativeQueryHandler nativeQueryHandler;
    @Autowired
    private PrincipalTypeServiceLocal principalTypeService;
    @Autowired
    private InvokerHandler invokerHandler;
    @Autowired
    private TransactionServiceLocal transactionService;
    @Autowired
    private CacheHandler cacheHandler;
    private Cache<TransferTypeCacheKey, AccessorCacheValue> cache;
    @Autowired
    private ApplicationHandler applicationHandler;
    @Autowired
    private RateHandler rateHandler;
    @Autowired
    private CyclosProperties cyclosProperties;

    public TransferTypeServiceImpl() {
        super(TransferType.class, QTransferType.transferType, TransferTypeDTO.class);
    }

    @PostConstruct
    public void initialize() {
        this.cache = this.cacheHandler.getCache(CacheType.TRANSFER_TYPES);
    }

    public boolean isPaymentTypePossible(InternalAccountOwner internalAccountOwner, AccountOwner accountOwner, PaymentTransferType paymentTransferType) throws FrameworkException {
        internalAccountOwner = this.accountHandler.locate((AccountOwner)internalAccountOwner).getInternalAccountOwner();
        accountOwner = this.accountHandler.locate(accountOwner).getAccountOwner();
        PaymentTransferTypeQuery paymentTransferTypeQuery = new PaymentTransferTypeQuery();
        paymentTransferTypeQuery.setFromOwner(internalAccountOwner);
        paymentTransferTypeQuery.setToOwner(accountOwner);
        paymentTransferTypeQuery.setPossibleTransferTypes(Collections.singleton(paymentTransferType));
        paymentTransferTypeQuery.setCountOnly();
        return this.searchPayment(paymentTransferTypeQuery).getTotalCount() > 0;
    }

    @Override
    public TransferType newEntity(TransferTypeDataParams transferTypeDataParams) {
        GeneratedTransferType generatedTransferType = null;
        switch (transferTypeDataParams.getNature()) {
            case GENERATED: {
                generatedTransferType = new GeneratedTransferType();
                break;
            }
            case PAYMENT: {
                generatedTransferType = new PaymentTransferType();
                generatedTransferType.setNotifyPaymentReceived(true);
                ((PaymentTransferType)generatedTransferType).setChannels(Collections.singleton(this.channelService.getMain()));
                ((PaymentTransferType)generatedTransferType).setNotifyPaymentPerformed(Boolean.valueOf(true));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        AccountType accountType = (AccountType)this.conversionHandler.convert(AccountType.class, (Object)transferTypeDataParams.getFromAccountType());
        generatedTransferType.setFrom(accountType);
        generatedTransferType.setLockFrom(accountType.getLimitType() == AccountTypeLimitType.LIMITED);
        if (generatedTransferType instanceof PaymentTransferType) {
            ((PaymentTransferType)generatedTransferType).setEnabled(true);
        }
        return generatedTransferType;
    }

    public void resetAllMaturityPolicy(Currency currency) {
        QPaymentTransferType qPaymentTransferType = QPaymentTransferType.paymentTransferType;
        DBQuery<?> dBQuery = this.from(new EntityPath[]{qPaymentTransferType});
        dBQuery.where((Predicate)qPaymentTransferType.from().currency().eq((Object)currency));
        List list = dBQuery.list((Expression)qPaymentTransferType);
        for (PaymentTransferType paymentTransferType : list) {
            paymentTransferType.setMaturityPolicy(MaturityPolicy.ALWAYS);
        }
    }

    public TransferTypeDirection resolveDirection(AccountType accountType, AccountType accountType2) {
        if (accountType instanceof SystemAccountType) {
            if (accountType2 instanceof SystemAccountType) {
                return TransferTypeDirection.SYSTEM_TO_SYSTEM;
            }
            return TransferTypeDirection.SYSTEM_TO_USER;
        }
        if (accountType2 instanceof SystemAccountType) {
            return TransferTypeDirection.USER_TO_SYSTEM;
        }
        if (Objects.equals(accountType, accountType2)) {
            return TransferTypeDirection.USER_TO_USER;
        }
        return null;
    }

    public TransferTypeDirection resolveDirection(InternalAccountOwner internalAccountOwner, AccountOwner accountOwner) {
        if (internalAccountOwner instanceof SystemAccountOwner) {
            if (accountOwner instanceof SystemAccountOwner) {
                return TransferTypeDirection.SYSTEM_TO_SYSTEM;
            }
            return TransferTypeDirection.SYSTEM_TO_USER;
        }
        if (accountOwner instanceof SystemAccountOwner) {
            return TransferTypeDirection.USER_TO_SYSTEM;
        }
        if (internalAccountOwner instanceof BasicUser && accountOwner instanceof BasicUser && ((BasicUser)internalAccountOwner).getUser().equals((Object)((BasicUser)accountOwner).getUser())) {
            return TransferTypeDirection.USER_TO_SELF;
        }
        return TransferTypeDirection.USER_TO_USER;
    }

    public <T> Page<T> search(Class<T> clazz, TransferTypeQuery transferTypeQuery) {
        Page<T> page;
        if (QueryHelper.useParameter((Object)transferTypeQuery.getPriority())) {
            page = this.doSearch(clazz, transferTypeQuery);
            if (CollectionHelper.isEmpty(page)) {
                transferTypeQuery.setPriority(null);
                page = this.doSearch(clazz, transferTypeQuery);
            }
        } else {
            page = this.doSearch(clazz, transferTypeQuery);
        }
        return page;
    }

    public Page<TransferTypeVO> search(TransferTypeQuery transferTypeQuery) {
        return this.search(TransferTypeVO.class, transferTypeQuery);
    }

    public Page<PaymentTransferType> searchExternalPayment(PaymentTransferTypeQuery paymentTransferTypeQuery) {
        return this.doSearchPayment(paymentTransferTypeQuery, true, (Function<PaymentTransferTypeQuery, Collection<PaymentTransferType>>)((Function)paymentTransferTypeQuery2 -> {
            SessionData sessionData = this.getSessionData();
            InternalAccountOwner internalAccountOwner = paymentTransferTypeQuery.getFromOwner();
            if (internalAccountOwner instanceof SystemAccountOwner) {
                return sessionData.getProducts().admin().getSystemToUserExternalPayments();
            }
            User user = sessionData.getLoggedUser();
            if (internalAccountOwner.equals((Object)user)) {
                return sessionData.getProducts().member().getMyExternalPaymentTypes();
            }
            if (sessionData.isManagerOf((BasicUser)((User)internalAccountOwner))) {
                return sessionData.getProducts().userManagement().getExternalPaymentsAsUser();
            }
            return Collections.emptyList();
        }));
    }

    public Page<PaymentTransferType> searchPayment(PaymentTransferTypeQuery paymentTransferTypeQuery2) {
        return this.doSearchPayment(paymentTransferTypeQuery2, !paymentTransferTypeQuery2.isReceive(), (Function<PaymentTransferTypeQuery, Collection<PaymentTransferType>>)((Function)paymentTransferTypeQuery -> {
            LocateAccountOwnerResult locateAccountOwnerResult;
            SessionData sessionData = this.getSessionData();
            LocateAccountOwnerResult locateAccountOwnerResult2 = locateAccountOwnerResult = paymentTransferTypeQuery.isReceive() ? this.transactionService.locateForReceiving(paymentTransferTypeQuery.getFromOwner()) : this.accountHandler.locate((AccountOwner)paymentTransferTypeQuery.getFromOwner());
            if (locateAccountOwnerResult.isSystem()) {
                return sessionData.getProducts().admin().getSystemPayments();
            }
            User user = sessionData.getLoggedUser();
            if (paymentTransferTypeQuery.isReceive()) {
                List list = sessionData.getProducts().member().getReceivePosPaymentTypes();
                DirectUserSessionData directUserSessionData = SessionDataFactory.direct((UserPrincipal)locateAccountOwnerResult.getLocateUserResult()).channel(BuiltInChannel.POS).build();
                MemberProductAccessor memberProductAccessor = directUserSessionData.getProducts().member();
                List list2 = memberProductAccessor.getMakePosPaymentTypes();
                list.retainAll(list2);
                return list;
            }
            if (user == null) {
                return null;
            }
            if (user.equals((Object)locateAccountOwnerResult.getUser())) {
                if (sessionData.getChannel().isPos()) {
                    return sessionData.getProducts().member().getMakePosPaymentTypes();
                }
                return sessionData.getProducts().member().getMyPaymentTypes();
            }
            return sessionData.getProducts().userManagement().getPaymentsAsUser();
        }));
    }

    public Page<PaymentTransferType> searchPaymentRequest(PaymentTransferTypeQuery paymentTransferTypeQuery2) throws FrameworkException {
        return this.doSearchPayment(paymentTransferTypeQuery2, false, (Function<PaymentTransferTypeQuery, Collection<PaymentTransferType>>)((Function)paymentTransferTypeQuery -> {
            SessionData sessionData;
            InternalAccountOwner internalAccountOwner = this.accountHandler.locate((AccountOwner)paymentTransferTypeQuery.getFromOwner()).getInternalAccountOwner();
            InternalAccountOwner internalAccountOwner2 = this.accountHandler.locate(paymentTransferTypeQuery.getToOwner()).getInternalAccountOwner();
            List list = null;
            if (internalAccountOwner instanceof User) {
                list = this.productsHandler.getAccessor((BasicUser)((User)internalAccountOwner)).member().getReceivePaymentRequestTypes();
            }
            if (!(sessionData = this.getSessionData()).isSystem()) {
                boolean bl;
                InternalAccountOwner internalAccountOwner3 = this.accountHandler.getAccountOwner();
                List list2 = null;
                boolean bl2 = bl = internalAccountOwner2 instanceof User && !internalAccountOwner2.equals((Object)internalAccountOwner3);
                if (internalAccountOwner2 == null && internalAccountOwner == null || internalAccountOwner != null && internalAccountOwner2 != null && internalAccountOwner.equals((Object)internalAccountOwner2)) {
                    throw new IllegalActionException();
                }
                list2 = bl ? (internalAccountOwner instanceof SystemAccountOwner ? sessionData.getProducts().userManagement().getUserPaymentRequestsSendToSystem() : sessionData.getProducts().userManagement().getUserPaymentRequestsSendToUser()) : (internalAccountOwner2 instanceof SystemAccountOwner ? sessionData.getProducts().admin().getSystemPaymentRequestsSendToUser() : (internalAccountOwner instanceof SystemAccountOwner ? sessionData.getProducts().member().getMyPaymentRequestsSendToSystem() : sessionData.getProducts().member().getMyPaymentRequestsSendToUser()));
                if (list == null) {
                    list = list2;
                } else {
                    list.retainAll(list2);
                }
            }
            return list;
        }));
    }

    public Page<PaymentTransferType> searchTicket(PaymentTransferTypeQuery paymentTransferTypeQuery) {
        return this.doSearchPayment(paymentTransferTypeQuery, false, (Function<PaymentTransferTypeQuery, Collection<PaymentTransferType>>)((Function)paymentTransferTypeQuery2 -> {
            User user = (User)paymentTransferTypeQuery.getFromOwner();
            User user2 = (User)paymentTransferTypeQuery.getToOwner();
            SessionData sessionData = this.getSessionData();
            List list = sessionData.isSystem() || sessionData.isManagerOf((BasicUser)user2) ? sessionData.getProducts().userManagement().getCreateTicketsAsUser() : (user2.equals((Object)sessionData.getLoggedUser()) ? sessionData.getProducts().member().getMyCreateTicketPaymentTypes() : new ArrayList());
            if (user != null) {
                ProductsAccessor productsAccessor = this.productsHandler.getAccessor((BasicUser)user);
                List list2 = productsAccessor.member().getMyApproveTicketPaymentTypes();
                list.retainAll(list2);
            }
            return list;
        }));
    }

    @Override
    public TransferType toEntity(TransferTypeDTO transferTypeDTO) {
        TransferType transferType = (TransferType)super.toEntity(transferTypeDTO);
        if (transferTypeDTO instanceof PaymentTransferTypeDTO) {
            PaymentTransferTypeDTO paymentTransferTypeDTO = (PaymentTransferTypeDTO)transferTypeDTO;
            PaymentTransferType paymentTransferType = (PaymentTransferType)transferType;
            if (paymentTransferTypeDTO.isUseFixedAmount()) {
                paymentTransferType.setMinAmount(paymentTransferTypeDTO.getFixedAmount());
                paymentTransferType.setMaxAmount(paymentTransferTypeDTO.getFixedAmount());
                paymentTransferType.setMaxAmountPerDay(null);
                paymentTransferType.setMaxAmountPerWeek(null);
                paymentTransferType.setMaxAmountPerMonth(null);
                paymentTransferType.setMaxAmountPinless(null);
            }
        }
        this.dRateHandler.toEntity(transferType, transferTypeDTO.getDRateCreationValue());
        return transferType;
    }

    @Override
    protected TransferTypeData getData(TransferType transferType) {
        NewTransferTypeData newTransferTypeData;
        AccountType accountType = transferType.getFrom();
        AccountType accountType2 = transferType.getTo();
        boolean bl = accountType != null && accountType.getLimitType() == AccountTypeLimitType.UNLIMITED;
        boolean bl2 = this.dRateHandler.isEnabled(transferType.getCurrency(), null);
        if (transferType.isTransient()) {
            NewTransferTypeData newTransferTypeData2 = new NewTransferTypeData();
            if (accountType != null) {
                ArrayList arrayList = this.accountTypeService.listByCurrency(accountType.getCurrency());
                if (AccountTypeNature.SYSTEM == accountType.getNature()) {
                    arrayList = new ArrayList(arrayList);
                    arrayList.remove(accountType);
                }
                newTransferTypeData2.setDestinationAccountTypes(this.conversionHandler.convertList(AccountTypeVO.class, arrayList));
            }
            newTransferTypeData = newTransferTypeData2;
        } else {
            Long l = transferType.getId();
            TransferTypeVO transferTypeVO = new TransferTypeVO(l);
            EditTransferTypeData editTransferTypeData = new EditTransferTypeData();
            editTransferTypeData.setCustomFields(this.conversionHandler.convertList(CustomFieldVO.class, (Iterable)this.transactionCustomFieldService.listAll()));
            editTransferTypeData.setRelatedCustomFields(this.transactionCustomFieldService.listRelated(transferTypeVO));
            editTransferTypeData.setTransferFees(this.transferFeeService.list(transferTypeVO));
            editTransferTypeData.setAuthorizationLevels(this.authorizationLevelService.list(transferTypeVO));
            newTransferTypeData = editTransferTypeData;
        }
        newTransferTypeData.setDto((EntityDTO)((TransferTypeDTO)this.toDTO(transferType)));
        newTransferTypeData.setRatesEnabled(this.rateHandler.isAnyRateEnabled(transferType.getCurrency(), null));
        if (bl2) {
            newTransferTypeData.setDRateEnabled(true);
            newTransferTypeData.setAllowDRateCreationValueCustomization(bl && (accountType2 == null || accountType2.getLimitType() == AccountTypeLimitType.LIMITED));
        }
        newTransferTypeData.setTransferStatusFlows(this.conversionHandler.convertList(TransferStatusFlowWithStatusesVO.class, (Iterable)this.transferStatusFlowService.listAll()));
        if (transferType instanceof PaymentTransferType) {
            newTransferTypeData.setChannels(this.channelService.list());
            newTransferTypeData.setGroups(this.groupsHandler.visibles().accessibles().basicUsers().sorted());
            newTransferTypeData.setPrincipalTypes(this.conversionHandler.convertList(PrincipalTypeVO.class, (Iterable)this.principalTypeService.listAll()));
        }
        newTransferTypeData.setCurrency((CurrencyVO)this.conversionHandler.convert(CurrencyVO.class, (Object)transferType.getFrom().getCurrency()));
        newTransferTypeData.setFromUnlimitedAccount(bl);
        return newTransferTypeData;
    }

    @Override
    protected void onAfterSave(TransferType transferType, TransferType transferType2, Object object) {
        if (transferType2 == null) {
            transferType.getFrom().getFromTransferTypes().add(transferType);
            transferType.getTo().getToTransferTypes().add(transferType);
        } else {
            HashSet<TransferStatusFlow> hashSet = new HashSet<TransferStatusFlow>();
            for (TransferStatusFlow transferStatusFlow : transferType.getStatusFlows()) {
                if (transferType2.getStatusFlows().contains(transferStatusFlow)) continue;
                hashSet.add(transferStatusFlow);
            }
            if (!hashSet.isEmpty()) {
                for (TransferStatusFlow transferStatusFlow : transferType.getInitialStatuses()) {
                    if (!hashSet.contains(transferStatusFlow.getFlow())) continue;
                    this.nativeQueryHandler.insertTransferInitialStatus(transferType, (TransferStatus)transferStatusFlow);
                }
            }
        }
    }

    @Override
    protected void onBeforeRemove(TransferType transferType) {
        this.invalidateCache(transferType);
    }

    @Override
    protected Object onBeforeSave(TransferType transferType, TransferType transferType2) {
        boolean bl;
        boolean bl2;
        Object object;
        boolean bl3;
        this.invalidateCache(transferType);
        AccountType accountType = transferType.getFrom();
        AccountType accountType2 = transferType.getTo();
        boolean bl4 = accountType.getLimitType() == AccountTypeLimitType.UNLIMITED;
        boolean bl5 = bl3 = accountType2.getLimitType() == AccountTypeLimitType.UNLIMITED;
        if (transferType2 == null && (object = this.resolveDirection(accountType, accountType2)) != null) {
            transferType.setDirection(object);
        }
        object = (Set)ObjectHelper.defaultValue((Object)transferType.getStatusFlows(), Collections.emptySet());
        Set set = (Set)ObjectHelper.defaultValue((Object)transferType.getInitialStatuses(), Collections.emptySet());
        set.removeIf(arg_0 -> TransferTypeServiceImpl.lambda$onBeforeSave$5((Set)object, arg_0));
        if (transferType instanceof PaymentTransferType) {
            PaymentTransferTypeRestrictTo paymentTransferTypeRestrictTo;
            PaymentTransferType paymentTransferType = (PaymentTransferType)transferType;
            if (!paymentTransferType.isAllowsScheduledPayments()) {
                paymentTransferType.setMaxInstallments(null);
            }
            if (!paymentTransferType.isRequiresAuthorization()) {
                paymentTransferType.setAuthorizationExpirationPeriod(null);
            }
            if (paymentTransferType.isUseFixedAmount()) {
                if (paymentTransferType.isAllowsScheduledPayments()) {
                    paymentTransferType.setMaxInstallments(Integer.valueOf(1));
                }
                paymentTransferType.setMaxAmountPinless(null);
                paymentTransferType.setMaxAmountTrustedDevices(null);
            }
            if (!paymentTransferType.isRequiresFeedback() || paymentTransferType.getDirection() != TransferTypeDirection.USER_TO_USER) {
                paymentTransferType.setFeedbackSetting(null);
                paymentTransferType.setFeedbackExpirationDays(null);
                paymentTransferType.setFeedbackReplyExpirationDays(null);
                paymentTransferType.setDefaultFeedbackLevel(null);
                paymentTransferType.setDefaultFeedbackComments(null);
                paymentTransferType.setFeedbackEnabledSince(null);
            } else if (paymentTransferType.getFeedbackSetting() == TransactionFeedbackSetting.OPTIONAL) {
                paymentTransferType.setDefaultFeedbackLevel(null);
                paymentTransferType.setDefaultFeedbackComments(null);
            }
            if (paymentTransferType.isRequiresFeedback() && paymentTransferType.getFeedbackEnabledSince() == null) {
                paymentTransferType.setFeedbackEnabledSince(DateHelper.now());
            }
            if (paymentTransferType.isToSystem()) {
                paymentTransferType.setRestrictTo(null);
                paymentTransferType.setRestrictToGroups(null);
                paymentTransferType.setRestrictToUsers(null);
                paymentTransferType.setNotifyPaymentReceived(false);
            } else {
                paymentTransferTypeRestrictTo = paymentTransferType.getRestrictTo();
                if (paymentTransferTypeRestrictTo == null) {
                    paymentTransferTypeRestrictTo = PaymentTransferTypeRestrictTo.NONE;
                    paymentTransferType.setRestrictTo(paymentTransferTypeRestrictTo);
                }
                if (paymentTransferTypeRestrictTo != PaymentTransferTypeRestrictTo.SPECIFIC_GROUPS) {
                    paymentTransferType.setRestrictToGroups(null);
                }
                if (paymentTransferTypeRestrictTo != PaymentTransferTypeRestrictTo.SPECIFIC_USERS) {
                    paymentTransferType.setRestrictToUsers(null);
                }
            }
            paymentTransferTypeRestrictTo = paymentTransferType.getDefaultPaymentRequestExpirationPeriod();
            if (paymentTransferTypeRestrictTo == null || paymentTransferTypeRestrictTo.getAmount() == null || paymentTransferTypeRestrictTo.getField() == null) {
                paymentTransferType.setHidePaymentRequestExpirationDate(false);
            }
        }
        boolean bl6 = bl2 = (bl = this.dRateHandler.isEnabled(transferType.getCurrency(), null)) && bl4 && !bl3;
        if (!bl2) {
            transferType.setdRateCreationValue(null);
        }
        if (bl4) {
            transferType.setLockFrom(false);
        }
        if (bl3) {
            transferType.setLockTo(false);
        }
        if (transferType instanceof PaymentTransferType) {
            PaymentTransferType paymentTransferType = (PaymentTransferType)transferType;
            if (bl && bl4) {
                paymentTransferType.setMaturityPolicy(MaturityPolicy.ALWAYS);
            }
            if (paymentTransferType.getDescriptionAvailability() != Availability.OPTIONAL) {
                paymentTransferType.setValueForEmptyDescription(null);
            }
        }
        return null;
    }

    @Override
    protected void preProcessCurrentCopy(TransferTypeDTO transferTypeDTO, TransferType transferType) {
        transferType.getStatusFlows().size();
        transferType.getInitialStatuses().size();
        if (transferType instanceof PaymentTransferType) {
            PaymentTransferType paymentTransferType = (PaymentTransferType)transferType;
            paymentTransferType.getChannels().size();
            paymentTransferType.getPrincipalTypes().size();
            paymentTransferType.getRestrictToGroups().size();
            paymentTransferType.getRestrictToUsers().size();
        }
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QTransferType)this.$).from().currency().network(), true);
    }

    @Override
    protected Validator resolveValidator(TransferTypeDTO transferTypeDTO) {
        if (transferTypeDTO instanceof PaymentTransferTypeDTO) {
            PaymentTransferTypeDTO paymentTransferTypeDTO = (PaymentTransferTypeDTO)transferTypeDTO;
            return this.getPaymentValidator(paymentTransferTypeDTO);
        }
        return this.getBasicValidator(transferTypeDTO);
    }

    @Override
    protected BidiMap<Class<? extends TransferType>, Class<? extends TransferTypeDTO>> subClassMappings() {
        return SUBCLASS_MAPPINGS;
    }

    private <T> Page<T> doSearch(Class<T> clazz, TransferTypeQuery transferTypeQuery) {
        Collection<TransferType> collection;
        SessionData sessionData = this.getSessionData();
        HashSet<Currency> hashSet = new HashSet<Currency>();
        Currency currency = (Currency)this.conversionHandler.convert(Currency.class, (Object)transferTypeQuery.getCurrency());
        if (currency != null) {
            hashSet.add(currency);
        } else {
            collection = new HashSet(this.conversionHandler.convertSet(AccountType.class, (Iterable)transferTypeQuery.getFromAccountTypes()));
            collection.addAll(this.conversionHandler.convertSet(AccountType.class, (Iterable)transferTypeQuery.getFromOrToAccountTypes()));
            collection.addAll(this.conversionHandler.convertSet(AccountType.class, (Iterable)transferTypeQuery.getToAccountTypes()));
            for (AccountType set2 : collection) {
                hashSet.add(set2.getCurrency());
            }
            if (hashSet.size() == 1) {
                currency = (Currency)CollectionHelper.first(hashSet);
            }
        }
        collection = this.conversionHandler.convertList(TransferType.class, (Iterable)transferTypeQuery.getPossibleTransferTypes());
        Collection<TransferType> collection2 = collection.isEmpty() ? (currency == null ? this.listByNetwork() : this.listByCurrency(currency)) : collection;
        Set set = this.conversionHandler.convertSet(TransferType.class, (Iterable)transferTypeQuery.getExcludingTransferTypes());
        if (!set.isEmpty()) {
            collection2.removeAll(set);
        }
        collection2.removeIf(transferType -> {
            Set set2;
            MutableObject mutableObject2;
            Object object;
            boolean bl;
            PaymentTransferType paymentTransferType = (PaymentTransferType)ObjectHelper.ifType((Object)transferType, PaymentTransferType.class);
            boolean bl2 = bl = transferType.isGlobal() || Objects.equals(sessionData.getNetwork(), transferType.getNetwork());
            if (bl && transferTypeQuery.getDirection() != null) {
                boolean bl3 = bl = transferType.getDirection() == transferTypeQuery.getDirection();
            }
            if (bl && !transferTypeQuery.isIncludeDisabled()) {
                bl = transferType.isEnabled();
            }
            if (bl && transferTypeQuery.getPriority() != null && paymentTransferType != null) {
                boolean bl4 = bl = paymentTransferType.isPriority() == transferTypeQuery.getPriority().booleanValue();
            }
            if (bl && paymentTransferType != null && (object = (Channel)this.conversionHandler.convert(Channel.class, (Object)transferTypeQuery.getChannel())) != null) {
                bl = paymentTransferType.getChannels().contains(object);
            }
            if (bl && paymentTransferType != null && (object = (PrincipalType)this.conversionHandler.convert(PrincipalType.class, (Object)transferTypeQuery.getPrincipalType())) != null) {
                boolean bl5 = bl = CollectionHelper.isEmpty((Iterable)paymentTransferType.getPrincipalTypes()) || paymentTransferType.getPrincipalTypes().contains(object);
            }
            if (bl && paymentTransferType != null && transferTypeQuery.getMaturityPolicy() != null) {
                object = (MaturityPolicy)ObjectHelper.defaultValue((Object)paymentTransferType.getMaturityPolicy(), (Object)MaturityPolicy.ALWAYS);
                boolean bl6 = bl = object == transferTypeQuery.getMaturityPolicy();
            }
            if (bl && paymentTransferType != null && transferTypeQuery.getRequiresAuthorization() != null) {
                boolean bl7 = bl = paymentTransferType.isRequiresAuthorization() == transferTypeQuery.getRequiresAuthorization().booleanValue();
            }
            if (bl && paymentTransferType != null && !(object = this.conversionHandler.convertSet(AuthorizationRole.class, (Iterable)transferTypeQuery.getAuthorizationRoles())).isEmpty()) {
                bl = false;
                for (MutableObject mutableObject2 : paymentTransferType.getAuthorizationLevels()) {
                    if (!CollectionHelper.containsAny((Collection)mutableObject2.getRoles(), (Collection)object)) continue;
                    bl = true;
                    break;
                }
            }
            if (bl && CollectionHelper.isNotEmpty((Iterable)transferTypeQuery.getNatures())) {
                bl = transferTypeQuery.getNatures().contains(transferType.getNature());
            }
            object = new MutableObject();
            MutableObject mutableObject3 = new MutableObject();
            mutableObject2 = new MutableObject();
            if (bl) {
                this.invokerHandler.runAs(SessionDataFactory.system((RequestData)sessionData.getRequestData()), () -> this.lambda$doSearch$6(transferTypeQuery, (MutableObject)object, mutableObject3, mutableObject2));
            }
            if (bl && transferTypeQuery.getFromNature() != null) {
                boolean bl8 = bl = transferType.getFrom().getNature() == transferTypeQuery.getFromNature();
            }
            if (bl && transferTypeQuery.getToNature() != null) {
                boolean bl9 = bl = transferType.getTo().getNature() == transferTypeQuery.getToNature();
            }
            if (bl && transferTypeQuery.getFromOrToNature() != null) {
                boolean bl10 = bl = transferType.getFrom().getNature() == transferTypeQuery.getFromOrToNature() || transferType.getTo().getNature() == transferTypeQuery.getFromOrToNature();
            }
            if (bl && !(set2 = this.conversionHandler.convertSet(AccountType.class, (Iterable)transferTypeQuery.getFromAccountTypes())).isEmpty()) {
                bl = set2.contains(transferType.getFrom());
            }
            if (bl && !(set2 = this.conversionHandler.convertSet(AccountType.class, (Iterable)transferTypeQuery.getToAccountTypes())).isEmpty()) {
                bl = set2.contains(transferType.getTo());
            }
            if (bl && !(set2 = this.conversionHandler.convertSet(AccountType.class, (Iterable)transferTypeQuery.getFromOrToAccountTypes())).isEmpty()) {
                boolean bl11 = bl = set2.contains(transferType.getFrom()) || set2.contains(transferType.getTo());
            }
            if (bl && object.get() != null) {
                bl = this.resolveAccountTypes((User)object.get()).contains(transferType.getFrom());
            }
            if (bl && mutableObject3.get() != null) {
                bl = this.resolveAccountTypes((User)mutableObject3.get()).contains(transferType.getTo());
            }
            if (bl && mutableObject2.get() != null) {
                bl = CollectionHelper.containsAny(this.resolveAccountTypes((User)mutableObject2.get()), (Object[])new Object[]{transferType.getFrom(), transferType.getTo()});
            }
            if (bl && CollectionHelper.isNotEmpty((Iterable)hashSet)) {
                bl = hashSet.contains(transferType.getCurrency());
            }
            if (bl && transferTypeQuery.getOnlyWithCustomFields() != null) {
                bl = paymentTransferType != null && paymentTransferType.getCustomFields().isEmpty() != transferTypeQuery.getOnlyWithCustomFields().booleanValue();
            }
            return !bl;
        });
        Collections.sort(collection2, COMPARATOR);
        Page page = QueryHelper.buildPage((SessionData)this.getSessionData(), (List)collection2, (QueryParameters)transferTypeQuery);
        return this.conversionHandler.convertPage(clazz, (Iterable)page);
    }

    private Page<PaymentTransferType> doSearchPayment(PaymentTransferTypeQuery paymentTransferTypeQuery, boolean bl, Function<PaymentTransferTypeQuery, Collection<PaymentTransferType>> function) {
        Set set;
        GroupSet groupSet;
        Object object;
        Set set2;
        AccountOwner accountOwner;
        SessionData sessionData = this.getSessionData();
        TransferTypeQuery transferTypeQuery = (TransferTypeQuery)this.conversionHandler.convertExcluding(TransferTypeQuery.class, (Object)paymentTransferTypeQuery, new Object[]{TransferTypeQuery.FROM_OWNER, TransferTypeQuery.TO_OWNER});
        InternalAccountOwner internalAccountOwner = paymentTransferTypeQuery.getFromOwner();
        if (internalAccountOwner instanceof EntityVO) {
            internalAccountOwner = this.accountHandler.locate((AccountOwner)internalAccountOwner).getInternalAccountOwner();
        }
        if ((accountOwner = paymentTransferTypeQuery.getToOwner()) instanceof EntityVO) {
            accountOwner = this.accountHandler.locate(accountOwner).getInternalAccountOwner();
        }
        transferTypeQuery.setFromOwner(internalAccountOwner);
        transferTypeQuery.setToOwner(accountOwner);
        transferTypeQuery.setNatures(Collections.singleton(TransferTypeNature.PAYMENT));
        Collection collection = CollectionHelper.orEmpty((Collection)paymentTransferTypeQuery.getFromAccounts());
        if (!collection.isEmpty()) {
            set2 = (collection = (Collection)collection.stream().filter(account -> this.accountService.isActive((IAccount)account)).collect(Collectors.toSet())).stream().map(IAccount::getOwner).collect(Collectors.toSet());
            if (set2.size() != 1) {
                return QueryHelper.emptyPage((SessionData)sessionData, (QueryParameters)transferTypeQuery);
            }
            transferTypeQuery.setFromAccountTypes(collection.stream().map(account -> new AccountTypeVO(account.getType().getId())).collect(Collectors.toSet()));
            transferTypeQuery.setFromOwner((InternalAccountOwner)CollectionHelper.first(set2));
        }
        if (!(set2 = CollectionHelper.orEmpty((Collection)paymentTransferTypeQuery.getToAccounts())).isEmpty()) {
            object = (set2 = (Collection)set2.stream().filter(account -> this.accountService.isActive((IAccount)account)).collect(Collectors.toSet())).stream().map(IAccount::getOwner).collect(Collectors.toSet());
            if (object.size() != 1) {
                return QueryHelper.emptyPage((SessionData)sessionData, (QueryParameters)transferTypeQuery);
            }
            transferTypeQuery.setToAccountTypes(set2.stream().map(account -> new AccountTypeVO(account.getType().getId())).collect(Collectors.toSet()));
            transferTypeQuery.setToOwner((AccountOwner)CollectionHelper.first((Iterable)object));
        }
        object = internalAccountOwner instanceof BasicUser ? ((BasicUser)internalAccountOwner).getUser() : null;
        User user = accountOwner instanceof BasicUser ? ((BasicUser)accountOwner).getUser() : null;
        boolean bl2 = object != null && user != null;
        Group group = object == null ? null : object.getGroup();
        Group group2 = user == null ? null : user.getGroup();
        GroupSet groupSet2 = group instanceof UserGroup ? ((UserGroup)group).getGroupSet() : null;
        GroupSet groupSet3 = groupSet = group2 instanceof UserGroup ? ((UserGroup)group2).getGroupSet() : null;
        if (!sessionData.isSystem()) {
            set = this.conversionHandler.convertSet(PaymentTransferType.class, (Iterable)paymentTransferTypeQuery.getPossibleTransferTypes());
            Collection collection2 = (Collection)function.apply((Object)paymentTransferTypeQuery);
            if (object != null || user != null) {
                List list = object == null ? null : this.productsHandler.getAccessor((BasicUser)object).member().getUserAccounts();
                List list2 = user == null ? null : this.productsHandler.getAccessor((BasicUser)user).member().getUserAccounts();
                collection2.removeIf(arg_0 -> this.lambda$doSearchPayment$12(list, list2, user, bl2, (User)object, group, group2, groupSet2, groupSet, arg_0));
            }
            if (CollectionHelper.isNotEmpty((Iterable)set)) {
                collection2.retainAll(set);
            }
            if (CollectionHelper.isEmpty((Iterable)collection2)) {
                return PageImpl.empty();
            }
            transferTypeQuery.setPossibleTransferTypes(this.conversionHandler.convertSet(TransferTypeVO.class, (Iterable)collection2));
        }
        if (internalAccountOwner != null && accountOwner != null) {
            transferTypeQuery.setDirection(this.resolveDirection(internalAccountOwner, accountOwner));
        }
        if (bl) {
            transferTypeQuery.setChannel(new ChannelVO(sessionData.getChannel().getId()));
            set = sessionData.getPrincipalType();
            if (set != null) {
                transferTypeQuery.setPrincipalType(new PrincipalTypeVO(set.getId()));
            }
        }
        if (transferTypeQuery.getToOwner() != null) {
            transferTypeQuery.setPriority(Boolean.valueOf(true));
        }
        return this.search(PaymentTransferType.class, transferTypeQuery);
    }

    private Validator getBasicValidator(TransferTypeDTO transferTypeDTO) {
        Object object;
        Validator validator = new Validator();
        validator.property(TransferTypeDTO.DESCRIPTION, GeneralKeys.Ui.DESCRIPTION).maxLength(1000);
        org.cyclos.impl.utils.validation.Property property = validator.property((Property)TransferTypeDTO.FROM, BankingKeys.TransferTypes.FROM);
        property.required();
        if (transferTypeDTO.isPersistent()) {
            property.add((PropertyValidation)new SourceAccountTypeValidator());
        }
        validator.property((Property)TransferTypeDTO.TO, BankingKeys.TransferTypes.TO).required().add((PropertyValidation)new DestinationAccountTypeValidator());
        validator.property((Property)TransferTypeDTO.D_RATE_CREATION_VALUE, BankingKeys.Rates.D_CREATION_VALUE).greaterEquals((Comparable)Integer.valueOf(0));
        Set set = this.conversionHandler.convertSet(TransferStatusFlow.class, (Iterable)transferTypeDTO.getStatusFlows());
        Set set2 = this.conversionHandler.convertSet(TransferStatus.class, (Iterable)transferTypeDTO.getInitialStatuses());
        final HashMap<TransferStatusFlow, Integer> hashMap = new HashMap<TransferStatusFlow, Integer>();
        for (TransferStatus transferStatus : set2) {
            object = transferStatus.getFlow();
            if (!set.contains(object)) continue;
            Integer n = (Integer)hashMap.get(object);
            if (n == null) {
                hashMap.put((TransferStatusFlow)object, 1);
                continue;
            }
            hashMap.put((TransferStatusFlow)object, n + 1);
        }
        for (TransferStatus transferStatus : CollectionHelper.sort((Collection)set)) {
            object = new BasePropertyAccess((TransferStatusFlow)transferStatus){
                final /* synthetic */ TransferStatusFlow val$flow;
                {
                    this.val$flow = transferStatusFlow;
                }

                public Object get(Object object) {
                    return hashMap.get(this.val$flow);
                }

                public String getPropertyName() {
                    Object object = this.val$flow.getInternalName() != null ? this.val$flow.getInternalName() : TransferTypeServiceImpl.this.applicationHandler.getIdMask().apply(this.val$flow.getId());
                    return TransferTypeDTO.INITIAL_STATUSES.getName() + "." + String.valueOf(object);
                }
            };
            validator.property((PropertyAccess)object, new TranslationMessageSpecification(BankingKeys.TransferTypes.INITIAL_STATUSES, new Object[]{transferStatus})).required().anyOf(new Object[]{1});
        }
        validator.property((Property)TransferTypeDTO.MAX_CHARGEBACK_TIME, BankingKeys.TransferTypes.MAX_CHARGEBACK_TIME).positiveOrZero().maxInterval(this.cyclosProperties.getArchivingMonths() < 1 ? 999 : this.cyclosProperties.getArchivingMonths(), TimeField.MONTHS);
        return validator;
    }

    private Validator getManualValidator(PaymentTransferTypeDTO paymentTransferTypeDTO) {
        Validator validator = this.getBasicValidator((TransferTypeDTO)paymentTransferTypeDTO);
        validator.property((Property)PaymentTransferTypeDTO.CONFIRMATION_MESSAGE, BankingKeys.TransferTypes.CONFIRMATION_MESSAGE).maxLength(4000);
        if (paymentTransferTypeDTO.getMaturityPolicy() == MaturityPolicy.HISTORY) {
            validator.property((Property)PaymentTransferTypeDTO.MATURITY_HISTORY_SIZE, BankingKeys.TransferTypes.MATURITY_HISTORY_SIZE).required().positiveIntegerNonZero();
        }
        return validator;
    }

    private Validator getPaymentValidator(PaymentTransferTypeDTO paymentTransferTypeDTO) {
        TransferTypeDirection transferTypeDirection;
        Validator validator = this.getManualValidator(paymentTransferTypeDTO);
        validator.general((GeneralValidation)new RestrictToCollectionsValidator());
        validator.general((GeneralValidation)new MaturityPolicyCombinationValidator());
        AccountType accountType = (AccountType)this.conversionHandler.convert(AccountType.class, (Object)paymentTransferTypeDTO.getFrom());
        AccountType accountType2 = (AccountType)this.conversionHandler.convert(AccountType.class, (Object)paymentTransferTypeDTO.getTo());
        if (paymentTransferTypeDTO.isUseFixedAmount()) {
            validator.property((Property)PaymentTransferTypeDTO.FIXED_AMOUNT, BankingKeys.TransferTypes.FIXED_AMOUNT).required().positiveNonZero((HasCurrency)accountType);
        } else {
            validator.property((Property)PaymentTransferTypeDTO.MIN_AMOUNT, BankingKeys.TransferTypes.MIN_AMOUNT).positiveNonZero((HasCurrency)accountType);
            validator.property((Property)PaymentTransferTypeDTO.MAX_AMOUNT, BankingKeys.TransferTypes.MAX_AMOUNT).greaterThan((Comparable)paymentTransferTypeDTO.getMinAmount()).positiveNonZero((HasCurrency)accountType);
            validator.property((Property)PaymentTransferTypeDTO.MAX_AMOUNT_PER_DAY, BankingKeys.TransferTypes.MAX_AMOUNT_PER_DAY).positiveNonZero((HasCurrency)accountType);
            validator.property((Property)PaymentTransferTypeDTO.MAX_AMOUNT_PER_MONTH, BankingKeys.TransferTypes.MAX_AMOUNT_PER_MONTH).positiveNonZero((HasCurrency)accountType);
            validator.property((Property)PaymentTransferTypeDTO.MAX_AMOUNT_PER_WEEK, BankingKeys.TransferTypes.MAX_AMOUNT_PER_WEEK).positiveNonZero((HasCurrency)accountType);
            validator.property((Property)PaymentTransferTypeDTO.MAX_AMOUNT_PER_YEAR, BankingKeys.TransferTypes.MAX_AMOUNT_PER_YEAR).positiveNonZero((HasCurrency)accountType);
            validator.property((Property)PaymentTransferTypeDTO.MAX_AMOUNT_PINLESS, BankingKeys.TransferTypes.MAX_AMOUNT_PINLESS).positiveNonZero((HasCurrency)accountType);
            validator.property((Property)PaymentTransferTypeDTO.MAX_AMOUNT_PER_DAY_PINLESS, BankingKeys.TransferTypes.MAX_AMOUNT_PER_DAY_PINLESS).positiveNonZero((HasCurrency)accountType);
            validator.property((Property)PaymentTransferTypeDTO.MAX_AMOUNT_TRUSTED_DEVICES, BankingKeys.TransferTypes.MAX_AMOUNT_TRUSTED_DEVICES).positiveNonZero((HasCurrency)accountType).greaterThan((Comparable)paymentTransferTypeDTO.getMaxAmount()).childOf((Object)paymentTransferTypeDTO.getMaxAmount(), BankingKeys.TransferTypes.MAX_AMOUNT);
            validator.property((Property)PaymentTransferTypeDTO.MAX_AMOUNT_PINLESS_TRUSTED_DEVICES, BankingKeys.TransferTypes.MAX_AMOUNT_PINLESS_TRUSTED_DEVICES).positiveNonZero((HasCurrency)accountType).greaterThan((Comparable)paymentTransferTypeDTO.getMaxAmountPinless());
            validator.property((Property)PaymentTransferTypeDTO.MAX_AMOUNT_PER_DAY_TRUSTED_DEVICES, BankingKeys.TransferTypes.MAX_AMOUNT_PER_DAY_TRUSTED_DEVICES).positiveNonZero((HasCurrency)accountType).greaterThan((Comparable)paymentTransferTypeDTO.getMaxAmountPerDay()).childOf((Object)paymentTransferTypeDTO.getMaxAmountPerDay(), BankingKeys.TransferTypes.MAX_AMOUNT_PER_DAY);
            validator.property((Property)PaymentTransferTypeDTO.MAX_AMOUNT_PER_DAY_PINLESS_TRUSTED_DEVICES, BankingKeys.TransferTypes.MAX_AMOUNT_PER_DAY_PINLESS_TRUSTED_DEVICES).positiveNonZero((HasCurrency)accountType).greaterThan((Comparable)paymentTransferTypeDTO.getMaxAmountPerDayPinless());
            validator.property((Property)PaymentTransferTypeDTO.MAX_AMOUNT_PER_WEEK_TRUSTED_DEVICES, BankingKeys.TransferTypes.MAX_AMOUNT_PER_WEEK_TRUSTED_DEVICES).positiveNonZero((HasCurrency)accountType).greaterThan((Comparable)paymentTransferTypeDTO.getMaxAmountPerWeek()).childOf((Object)paymentTransferTypeDTO.getMaxAmountPerWeek(), BankingKeys.TransferTypes.MAX_AMOUNT_PER_WEEK);
            validator.property((Property)PaymentTransferTypeDTO.MAX_AMOUNT_PER_MONTH_TRUSTED_DEVICES, BankingKeys.TransferTypes.MAX_AMOUNT_PER_MONTH_TRUSTED_DEVICES).positiveNonZero((HasCurrency)accountType).greaterThan((Comparable)paymentTransferTypeDTO.getMaxAmountPerMonth()).childOf((Object)paymentTransferTypeDTO.getMaxAmountPerMonth(), BankingKeys.TransferTypes.MAX_AMOUNT_PER_MONTH);
            validator.property((Property)PaymentTransferTypeDTO.MAX_AMOUNT_PER_YEAR_TRUSTED_DEVICES, BankingKeys.TransferTypes.MAX_AMOUNT_PER_YEAR_TRUSTED_DEVICES).positiveNonZero((HasCurrency)accountType).greaterThan((Comparable)paymentTransferTypeDTO.getMaxAmountPerYear()).childOf((Object)paymentTransferTypeDTO.getMaxAmountPerYear(), BankingKeys.TransferTypes.MAX_AMOUNT_PER_YEAR);
        }
        validator.property((Property)PaymentTransferTypeDTO.MAX_TRANSFERS_PER_DAY, BankingKeys.TransferTypes.MAX_TRANSFERS_PER_DAY).positiveIntegerNonZero();
        validator.property((Property)PaymentTransferTypeDTO.MAX_TRANSFERS_PER_MONTH, BankingKeys.TransferTypes.MAX_TRANSFERS_PER_MONTH).positiveIntegerNonZero();
        validator.property((Property)PaymentTransferTypeDTO.MAX_TRANSFERS_PER_WEEK, BankingKeys.TransferTypes.MAX_TRANSFERS_PER_WEEK).positiveIntegerNonZero();
        validator.property((Property)PaymentTransferTypeDTO.MAX_TRANSFERS_PER_DAY_TRUSTED_DEVICES, BankingKeys.TransferTypes.MAX_TRANSFERS_PER_DAY_TRUSTED_DEVICES).greaterThan((Comparable)paymentTransferTypeDTO.getMaxTransfersPerDay()).childOf((Object)paymentTransferTypeDTO.getMaxTransfersPerDay(), BankingKeys.TransferTypes.MAX_TRANSFERS_PER_DAY).positiveIntegerNonZero();
        validator.property((Property)PaymentTransferTypeDTO.MAX_TRANSFERS_PER_WEEK_TRUSTED_DEVICES, BankingKeys.TransferTypes.MAX_TRANSFERS_PER_WEEK_TRUSTED_DEVICES).greaterThan((Comparable)paymentTransferTypeDTO.getMaxTransfersPerWeek()).childOf((Object)paymentTransferTypeDTO.getMaxTransfersPerWeek(), BankingKeys.TransferTypes.MAX_TRANSFERS_PER_WEEK).positiveIntegerNonZero();
        validator.property((Property)PaymentTransferTypeDTO.MAX_TRANSFERS_PER_MONTH_TRUSTED_DEVICES, BankingKeys.TransferTypes.MAX_TRANSFERS_PER_MONTH_TRUSTED_DEVICES).greaterThan((Comparable)paymentTransferTypeDTO.getMaxTransfersPerMonth()).childOf((Object)paymentTransferTypeDTO.getMaxTransfersPerMonth(), BankingKeys.TransferTypes.MAX_TRANSFERS_PER_MONTH).positiveIntegerNonZero();
        validator.property((Property)PaymentTransferTypeDTO.MIN_TIME_BETWEEN_TRANSFERS, BankingKeys.TransferTypes.MIN_TIME_BETWEEN_TRANSFERS).minInterval(0, TimeField.SECONDS).maxInterval(100, TimeField.DAYS);
        if (accountType != null && accountType2 != null) {
            transferTypeDirection = this.resolveDirection(accountType, accountType2);
            org.cyclos.impl.utils.validation.Property property = validator.property((Property)TransferTypeDTO.DIRECTION, BankingKeys.TransferTypes.DIRECTION);
            if (transferTypeDirection == null) {
                property.required().anyOf(new Object[]{TransferTypeDirection.USER_TO_USER, TransferTypeDirection.USER_TO_SELF});
            } else {
                property.anyOf(new Object[]{transferTypeDirection});
            }
        }
        if (paymentTransferTypeDTO.isAllowsScheduledPayments() && !paymentTransferTypeDTO.isUseFixedAmount()) {
            validator.property((Property)PaymentTransferTypeDTO.MAX_INSTALLMENTS, BankingKeys.TransferTypes.MAX_INSTALLMENTS).required().between((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(999));
        }
        if (paymentTransferTypeDTO.isRequiresFeedback()) {
            validator.property((Property)PaymentTransferTypeDTO.FEEDBACK_EXPIRATION_DAYS, BankingKeys.TransferTypes.FEEDBACK_EXPIRATION_DAYS).required().positiveIntegerNonZero();
            validator.property((Property)PaymentTransferTypeDTO.FEEDBACK_REMINDER_DAYS, BankingKeys.TransferTypes.FEEDBACK_REMINDER_DAYS).required().positiveOrZero().lessThan((Comparable)paymentTransferTypeDTO.getFeedbackExpirationDays());
            validator.property((Property)PaymentTransferTypeDTO.FEEDBACK_EXPIRATION_REMINDER_DAYS, BankingKeys.TransferTypes.FEEDBACK_EXPIRATION_REMINDER_DAYS).required().positiveIntegerNonZero().betweenIncludingOnlyFrom((Comparable)paymentTransferTypeDTO.getFeedbackReminderDays(), (Comparable)paymentTransferTypeDTO.getFeedbackExpirationDays());
            validator.property((Property)PaymentTransferTypeDTO.MAX_DAYS_TO_CHANGE_FEEDBACK, BankingKeys.TransferTypes.MAX_DAYS_TO_CHANGE_FEEDBACK).required().positiveOrZero();
            transferTypeDirection = validator.property((Property)PaymentTransferTypeDTO.FEEDBACK_REPLY_EXPIRATION_DAYS, BankingKeys.TransferTypes.FEEDBACK_REPLY_EXPIRATION_DAYS).positiveIntegerNonZero();
            if (paymentTransferTypeDTO.getFeedbackSetting() != TransactionFeedbackSetting.OPTIONAL) {
                transferTypeDirection.required();
                validator.property((Property)PaymentTransferTypeDTO.DEFAULT_FEEDBACK_LEVEL, BankingKeys.TransferTypes.DEFAULT_FEEDBACK_LEVEL).required();
                validator.property((Property)PaymentTransferTypeDTO.DEFAULT_FEEDBACK_COMMENTS, BankingKeys.TransferTypes.DEFAULT_FEEDBACK_COMMENTS).required();
            }
        }
        validator.property((Property)PaymentTransferTypeDTO.DEFAULT_PAYMENT_REQUEST_EXPIRATION_PERIOD, BankingKeys.TransferTypes.DEFAULT_PAYMENT_REQUEST_EXPIRATION_PERIOD).positiveIntegerNonZero().timeInterval();
        validator.property((Property)PaymentTransferTypeDTO.AUTHORIZATION_EXPIRATION_PERIOD, BankingKeys.TransferTypes.AUTHORIZATION_EXPIRATION_PERIOD).positiveIntegerNonZero().timeInterval();
        return validator;
    }

    private void invalidateCache(TransferType transferType) {
        this.cacheHandler.scheduleEvict(CacheType.TRANSFER_TYPES, (Serializable)new TransferTypeCacheKey(transferType.getNetwork()));
        this.cacheHandler.scheduleEvict(CacheType.TRANSFER_TYPES, (Serializable)new TransferTypeCacheKey(transferType.getCurrency()));
    }

    private List<TransferType> listByCurrency(Currency currency) {
        TransferTypeCacheKey transferTypeCacheKey = new TransferTypeCacheKey(currency);
        return (List)((AccessorCacheValue)this.cache.get((Serializable)transferTypeCacheKey, () -> AccessorCacheValue.create((Collection)((DBQuery)this.from().where((Predicate)((QTransferType)this.$).from().currency().eq((Object)currency))).list((Expression)this.$)))).unwrap(this.getApplicationContext());
    }

    private List<TransferType> listByNetwork() {
        TransferTypeCacheKey transferTypeCacheKey = new TransferTypeCacheKey(this.getSessionData().getNetwork());
        return (List)((AccessorCacheValue)this.cache.get((Serializable)transferTypeCacheKey, () -> AccessorCacheValue.create((Collection)this.from().list((Expression)this.$)))).unwrap(this.getApplicationContext());
    }

    private List<UserAccountType> resolveAccountTypes(User user) {
        return this.productsHandler.getAccessor((BasicUser)user.getUser()).member().getUserAccounts();
    }

    private /* synthetic */ boolean lambda$doSearchPayment$12(List list, List list2, User user, boolean bl, User user2, Group group, Group group2, GroupSet groupSet, GroupSet groupSet2, PaymentTransferType paymentTransferType) {
        if (list != null && !list.contains(paymentTransferType.getFrom()) || list2 != null && !list2.contains(paymentTransferType.getTo())) {
            return true;
        }
        for (TransferFee transferFee : paymentTransferType.getTransferFees()) {
            GeneratedTransferType generatedTransferType = transferFee.getGeneratedTransferType();
            if (!transferFee.isEnabled() || transferFee.getConfigurationMode() != TransferFeeConfigurationMode.FORM || !generatedTransferType.isFromUser() || (transferFee.getPayer() != TransferFeeSubject.SOURCE || list == null || list.contains(generatedTransferType.getFrom())) && (transferFee.getPayer() != TransferFeeSubject.DESTINATION || list2 == null || list2.contains(generatedTransferType.getFrom()))) continue;
            return true;
        }
        PaymentTransferTypeRestrictTo paymentTransferTypeRestrictTo = (PaymentTransferTypeRestrictTo)ObjectHelper.defaultValue((Object)paymentTransferType.getRestrictTo(), (Object)PaymentTransferTypeRestrictTo.NONE);
        switch (paymentTransferTypeRestrictTo) {
            case NONE: {
                return false;
            }
            case SPECIFIC_GROUPS: {
                return user != null && !this.groupsHandler.flatten((Collection)paymentTransferType.getRestrictToGroups()).contains(user.getGroup());
            }
            case SPECIFIC_USERS: {
                return user != null && !paymentTransferType.getRestrictToUsers().contains(user);
            }
            case BROKERS: {
                return bl && !user2.getBrokers().contains(user);
            }
            case BROKERED_USERS: {
                return bl && !user.getBrokers().contains(user2);
            }
            case USERS_IN_SAME_GROUP: {
                return bl && !group.equals((Object)group2);
            }
            case USERS_IN_SAME_GROUP_SET: {
                return bl && (groupSet == null || groupSet2 == null || !groupSet.equals((Object)groupSet2));
            }
            case USERS_IN_OTHER_GROUPS: {
                return bl && group.equals((Object)group2);
            }
            case USERS_IN_OTHER_GROUP_SETS: {
                return bl && (groupSet == null || groupSet2 == null || groupSet.equals((Object)groupSet2));
            }
        }
        return false;
    }

    private /* synthetic */ Object lambda$doSearch$6(TransferTypeQuery transferTypeQuery, MutableObject mutableObject, MutableObject mutableObject2, MutableObject mutableObject3) throws Exception {
        if (transferTypeQuery.getFromOwner() != null) {
            if (transferTypeQuery.getFromOwner() instanceof SystemAccountOwner) {
                transferTypeQuery.setFromNature(AccountTypeNature.SYSTEM);
            } else if (transferTypeQuery.getFromOwner() instanceof BasicUser) {
                mutableObject.set((Object)((BasicUser)transferTypeQuery.getFromOwner()).getUser());
            } else {
                mutableObject.set((Object)((User)this.conversionHandler.convert(User.class, (Object)transferTypeQuery.getFromOwner())));
            }
        }
        if (transferTypeQuery.getToOwner() != null) {
            if (transferTypeQuery.getToOwner() instanceof SystemAccountOwner) {
                transferTypeQuery.setToNature(AccountTypeNature.SYSTEM);
            } else if (transferTypeQuery.getToOwner() instanceof ExternalAccountOwner) {
                transferTypeQuery.setToNature(AccountTypeNature.USER);
            } else if (transferTypeQuery.getToOwner() instanceof BasicUser) {
                mutableObject2.set((Object)((BasicUser)transferTypeQuery.getToOwner()).getUser());
            } else {
                mutableObject2.set((Object)((User)this.conversionHandler.convert(User.class, (Object)transferTypeQuery.getToOwner())));
            }
        }
        if (transferTypeQuery.getFromOrToOwner() != null) {
            if (transferTypeQuery.getFromOrToOwner() instanceof SystemAccountOwner) {
                transferTypeQuery.setFromOrToNature(AccountTypeNature.SYSTEM);
            } else if (transferTypeQuery.getToOwner() instanceof ExternalAccountOwner) {
                transferTypeQuery.setToNature(AccountTypeNature.USER);
            } else if (transferTypeQuery.getFromOrToOwner() instanceof BasicUser) {
                mutableObject3.set((Object)((BasicUser)transferTypeQuery.getFromOrToOwner()).getUser());
            } else {
                mutableObject3.set((Object)((User)this.conversionHandler.convert(User.class, (Object)transferTypeQuery.getFromOrToOwner())));
            }
        }
        return null;
    }

    private static /* synthetic */ boolean lambda$onBeforeSave$5(Set set, TransferStatus transferStatus) {
        return set == null || !set.contains(transferStatus.getFlow());
    }

    static {
        SUBCLASS_MAPPINGS.put(GeneratedTransferType.class, GeneratedTransferTypeDTO.class);
        SUBCLASS_MAPPINGS.put(PaymentTransferType.class, PaymentTransferTypeDTO.class);
        COMPARATOR = (transferType, transferType2) -> {
            int n = transferType.getNature().compareTo((Enum)transferType2.getNature());
            if (n == 0) {
                n = transferType.getTo().compareTo((NamedEntity)transferType2.getTo());
            }
            if (n == 0) {
                n = transferType.compareTo((NamedEntity)transferType2);
            }
            return n;
        };
    }

    private final class SourceAccountTypeValidator
    implements PropertyValidation {
        private SourceAccountTypeValidator() {
        }

        public ValidationError validate(Object object, Object object2, Object object3) {
            TransferTypeDTO transferTypeDTO = (TransferTypeDTO)object;
            TransferTypeDTO transferTypeDTO2 = (TransferTypeDTO)TransferTypeServiceImpl.this.load(transferTypeDTO.getId());
            if (!transferTypeDTO.getFrom().equals((Object)transferTypeDTO2.getFrom())) {
                return new ValidationError(BankingKeys.TransferTypes.ERROR_SOURCE_ACCOUNT_TYPE_CHANGED);
            }
            return null;
        }
    }

    private final class DestinationAccountTypeValidator
    implements PropertyValidation {
        private DestinationAccountTypeValidator() {
        }

        public ValidationError validate(Object object, Object object2, Object object3) {
            TransferTypeDTO transferTypeDTO = (TransferTypeDTO)object;
            if (transferTypeDTO.getFrom() == null || transferTypeDTO.getTo() == null) {
                return null;
            }
            AccountType accountType = (AccountType)TransferTypeServiceImpl.this.conversionHandler.convert(AccountType.class, (Object)transferTypeDTO.getFrom());
            AccountType accountType2 = (AccountType)TransferTypeServiceImpl.this.conversionHandler.convert(AccountType.class, (Object)transferTypeDTO.getTo());
            if (accountType != null && accountType2 != null) {
                if (!accountType.getCurrency().equals((Object)accountType2.getCurrency())) {
                    return new ValidationError(BankingKeys.TransferTypes.ERROR_INVALID_DESTINATION_ACCOUNT_TYPE, new Object[]{TransferTypeServiceImpl.this.getTranslatedName((NamedEntity)accountType2)});
                }
                if (accountType.getNature() == AccountTypeNature.SYSTEM && accountType.equals((Object)accountType2)) {
                    return new ValidationError(BankingKeys.TransferTypes.ERROR_INVALID_DESTINATION_ACCOUNT_TYPE);
                }
            }
            return null;
        }
    }

    private final class RestrictToCollectionsValidator
    implements GeneralValidation {
        private RestrictToCollectionsValidator() {
        }

        public ValidationError validate(Object object) {
            PaymentTransferTypeDTO paymentTransferTypeDTO = (PaymentTransferTypeDTO)object;
            PaymentTransferTypeRestrictTo paymentTransferTypeRestrictTo = paymentTransferTypeDTO.getRestrictTo();
            if (paymentTransferTypeRestrictTo != null) {
                switch (paymentTransferTypeRestrictTo) {
                    case SPECIFIC_GROUPS: {
                        if (!CollectionHelper.isEmpty((Iterable)paymentTransferTypeDTO.getRestrictToGroups())) break;
                        return new ValidationError(BankingKeys.TransferTypes.ERROR_EMPTY_RESTRICT_TO_GROUPS);
                    }
                    case SPECIFIC_USERS: {
                        if (!CollectionHelper.isEmpty((Iterable)paymentTransferTypeDTO.getRestrictToUsers())) break;
                        return new ValidationError(BankingKeys.TransferTypes.ERROR_EMPTY_RESTRICT_TO_USERS);
                    }
                }
            }
            return null;
        }
    }

    private final class MaturityPolicyCombinationValidator
    implements GeneralValidation {
        private MaturityPolicyCombinationValidator() {
        }

        public ValidationError validate(Object object) {
            PaymentTransferTypeDTO paymentTransferTypeDTO = (PaymentTransferTypeDTO)object;
            if ((paymentTransferTypeDTO.getMaturityPolicy() == MaturityPolicy.ZERO || paymentTransferTypeDTO.getMaturityPolicy() == MaturityPolicy.HISTORY) && (paymentTransferTypeDTO.isRequiresAuthorization() || paymentTransferTypeDTO.isAllowsRecurringPayments() || paymentTransferTypeDTO.isAllowsScheduledPayments())) {
                return new ValidationError(BankingKeys.TransferTypes.ERROR_MATURITY_POLICY_WRONG_COMBINATION);
            }
            return null;
        }
    }
}

